/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.value;

import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.IInputArchive;
import com.crystaldecisions.reports.common.archive.IOutputArchive;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataOutput;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.RangeValue;
import com.crystaldecisions.reports.common.value.TimeValue;
import com.crystaldecisions.reports.common.value.ValueType;
import java.io.DataInput;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DateValue
extends FormulaValue
implements Comparable {
    public static final int nullCRDate = -1;
    private static final int[] m = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int q = DateValue.a(1899, 12, 30);
    private static final int n = DateValue.a(100, 1, 1);
    private static final int o = DateValue.a(9999, 12, 31);
    private static DateValue p = new DateValue(0);
    private final int r;
    static final int DATE_OFFSET_1900 = 2415019;

    private DateValue(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("CRDate must be >= 0");
        }
        this.r = n;
    }

    public static DateValue now() {
        DateValue dateValue = DateValue.fromCalendar(new GregorianCalendar(Locale.US));
        if (!p.equals(dateValue)) {
            p = dateValue;
        }
        return p;
    }

    public void store(ValueType valueType, ExtendedDataOutput extendedDataOutput) throws IOException {
        assert (valueType == this.getValueType());
        extendedDataOutput.writeInt(this.r);
    }

    public void storeToArchive(ValueType valueType, IOutputArchive iOutputArchive) throws ArchiveException {
        assert (valueType == this.getValueType());
        iOutputArchive.storeInt32(this.r);
    }

    public static DateValue LoadFromArchive(IInputArchive iInputArchive) throws ArchiveException {
        return DateValue.fromCRDate(iInputArchive.loadInt32());
    }

    public static DateValue Load(DataInput dataInput) throws IOException {
        return DateValue.fromCRDate(dataInput.readInt());
    }

    public static int GetMaxEncodedSize() {
        return 4;
    }

    public int getEncodedSizeForArchive(ValueType valueType) {
        assert (valueType == this.getValueType());
        return DateValue.GetMaxEncodedSize();
    }

    public int getEncodedSize(ValueType valueType) {
        assert (valueType == this.getValueType());
        return DateValue.GetMaxEncodedSize();
    }

    public static DateValue fromCRDate(int n) {
        if (n == -1) {
            return null;
        }
        if (n == DateValue.p.r) {
            return p;
        }
        return new DateValue(n);
    }

    private static int a(int n, int n2, int n3) {
        short s = 0;
        int n4 = 0;
        int n5 = n2;
        int n6 = n3;
        int n7 = n;
        if (n7 < 0) {
            ++n7;
        }
        if (n5 <= 2) {
            --n7;
            n5 += 12;
        }
        if (n7 * 10000 + n5 * 100 + n6 >= 15821015) {
            s = (short)(n7 / 100);
            n4 = 2 - s + s / 4;
        }
        return 36525 * n7 / 100 + 306001 * (n5 + 1) / 10000 + n6 + 1720994 + n4;
    }

    private static int[] if(int n) {
        int n2;
        int n3 = n + 1;
        if (n3 < 2299161) {
            n2 = n3;
        } else {
            int n4 = (n3 * 100 - 186721625) / 3652425;
            n2 = n3 + 1 + n4 - n4 / 4;
        }
        int n5 = n2 > 1721423 ? n2 + 1524 : n2 + 1158;
        int n6 = (n5 * 100 - 12210) / 36525;
        int n7 = 36525 * n6 / 100;
        int n8 = (n5 - n7) * 10000 / 306001;
        int n9 = n5 - n7 - 306001 * n8 / 10000;
        int n10 = n8 * 10 < 135 ? n8 - 1 : n8 - 13;
        int n11 = n10 * 10 > 25 ? n6 - 4716 : n6 - 4715;
        return new int[]{n11, n10, n9};
    }

    public static DateValue fromYMD(int n, int n2, int n3) {
        if (n < -4713) {
            throw new IllegalArgumentException("year must be >= -4713");
        }
        if (n > 54078) {
            throw new IllegalArgumentException("year must be <= 54078");
        }
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("month must be between 1 and 12");
        }
        boolean bl = n >= 1582 ? n % 4 == 0 && n % 100 != 0 || n % 400 == 0 : n % 4 == 0;
        int n4 = m[n2];
        if (n2 == 2 && bl) {
            n4 = 29;
        }
        if (n3 < 1 || n3 > n4) {
            throw new IllegalArgumentException("day must be between 1 and max days in month");
        }
        return DateValue.fromCRDate(DateValue.a(n, n2, n3));
    }

    public static DateValue fromCalendar(Calendar calendar) {
        return DateValue.fromYMD(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public static DateValue fromOleDate(double d) {
        int n = q + (int)d;
        if (n < 0 || !DateValue.isValidOleDate(d)) {
            throw new IllegalArgumentException("OleDate cannot be converted to a valid CRDate");
        }
        return DateValue.fromCRDate(n);
    }

    public static boolean isValidOleDate(double d) {
        int n = q + (int)d;
        return n >= DateValue.n && n <= o;
    }

    public double getOleDate() {
        return this.r - q;
    }

    public static int getCRDate(DateValue dateValue) {
        return dateValue == null ? -1 : dateValue.getCRDate();
    }

    public static int getYear(DateValue dateValue) {
        return dateValue == null ? DateValue.if(-1)[0] : dateValue.getYear();
    }

    public static int getMonth(DateValue dateValue) {
        return dateValue == null ? DateValue.if(-1)[1] : dateValue.getMonth();
    }

    public static int getDay(DateValue dateValue) {
        return dateValue == null ? DateValue.if(-1)[2] : dateValue.getDay();
    }

    public int getCRDate() {
        return this.r;
    }

    public int getYear() {
        return DateValue.if(this.r)[0];
    }

    public int getMonth() {
        return DateValue.if(this.r)[1];
    }

    public int getDay() {
        return DateValue.if(this.r)[2];
    }

    public ValueType getValueType() {
        return ValueType.date;
    }

    public FormulaValue coerceToDate() {
        return this;
    }

    public FormulaValue coerceToDateTime() {
        return this.getStartOfDayDateTimeValue();
    }

    public DateTimeValue getStartOfDayDateTimeValue() {
        return DateTimeValue.fromDateAndTimeValues(this, TimeValue.min);
    }

    public DateTimeValue getEndOfDayDateTimeValue() {
        return DateTimeValue.fromDateAndTimeValues(this, TimeValue.max);
    }

    public RangeValue getDateTimeRangeValue() {
        return RangeValue.fromStartAndEndValues(this.getStartOfDayDateTimeValue(), this.getEndOfDayDateTimeValue(), true, true);
    }

    public int hashCode(boolean bl) {
        return this.r;
    }

    public boolean equals(Object object, boolean bl) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object, Comparator comparator) {
        return this.compareTo(object);
    }

    public int compareTo(Object object) {
        if (object == null) {
            return 1;
        }
        return DateValue.compare(this.r, ((DateValue)object).r);
    }

    public DateValue addNumberToDate(int n) {
        return new DateValue(this.r + n);
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(4);
        String string = "d(" + numberFormat.format(this.getYear()) + "-";
        numberFormat.setMinimumIntegerDigits(2);
        string = string + numberFormat.format(this.getMonth()) + "-" + numberFormat.format(this.getDay()) + ")";
        return string;
    }

    public static double To1900Format(DateValue dateValue) {
        double d = dateValue.getCRDate() - 2415019;
        if (d >= 60.0) {
            d += 1.0;
        }
        return d;
    }

    public static DateValue From1900Format(int n) {
        if (n >= 60) {
            --n;
        }
        return DateValue.fromCRDate(n += 2415019);
    }

    public Date getJavaDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(this.getYear(), this.getMonth() - 1, this.getDay());
        calendar.set(14, 0);
        return calendar.getTime();
    }

    static {
        p = DateValue.now();
    }
}

