/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class StringUtil {
    private static final Map<Locale, Comparator<String>> for = new HashMap<Locale, Comparator<String>>();
    private static final Map<Locale, Comparator<String>> do = new HashMap<Locale, Comparator<String>>();
    public static final String EMPTY_STRING = new String();
    private static final char int = '?';
    private static final char if = '*';
    private static final char a = '\\';

    private StringUtil() {
    }

    public static Comparator<String> getStringComparator(Locale locale, boolean bl) {
        Map<Locale, Comparator<String>> map = bl ? for : do;
        a a2 = map.get(locale);
        if (a2 == null) {
            a2 = new a(locale, bl);
            map.put(locale, a2);
        }
        return a2;
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null) {
            throw new IllegalArgumentException("line is null");
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("match parameter is invalid");
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        int n2 = string.indexOf(string2);
        int n3 = string2.length();
        while (n2 != -1) {
            stringBuilder.append(string.substring(n, n2));
            stringBuilder.append(string3);
            n = n2 + n3;
            n2 = string.indexOf(string2, n);
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    public static String[] split(String string, String string2) {
        return StringUtil.split(string, string2, 0);
    }

    public static String[] split(String string, String string2, int n) {
        if (string == null) {
            throw new IllegalArgumentException("line is null");
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("separator parameter is invalid");
        }
        if (string.length() == 0) {
            return new String[0];
        }
        if (n <= 0) {
            n = Integer.MAX_VALUE;
        }
        int n2 = string2.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        int n4 = string.indexOf(string2);
        while (n4 != -1 && arrayList.size() < n - 1) {
            arrayList.add(string.substring(n3, n4));
            n3 = n4 + n2;
            n4 = string.indexOf(string2, n3);
        }
        arrayList.add(string.substring(n3));
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static boolean equalsIgnoreCase(String string, String string2, Locale locale) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string == string2) {
            return true;
        }
        if (string.length() != string2.length()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == (c = string2.charAt(i)) || StringUtil.toUpperCase(c2, locale) == StringUtil.toUpperCase(c, locale) || StringUtil.toLowerCase(c2, locale) == StringUtil.toLowerCase(c, locale)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCaseEng(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string == string2) {
            return true;
        }
        if (string.length() != string2.length()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == (c = string2.charAt(i)) || StringUtil.toUpperCaseEng(c2) == StringUtil.toUpperCaseEng(c)) continue;
            return false;
        }
        return true;
    }

    private static int a(String string) {
        return StringUtil.a(string, 0);
    }

    private static int a(String string, int n) {
        int n2 = -1;
        int n3 = string.length();
        for (int i = n; i < n3; ++i) {
            if (string.charAt(i) == '\n') {
                if (i + 1 < n3 && string.charAt(i + 1) == '\r') {
                    n2 = i + 2;
                    break;
                }
                n2 = i + 1;
                break;
            }
            if (string.charAt(i) != '\r') continue;
            if (i + 1 < n3 && string.charAt(i + 1) == '\n') {
                n2 = i + 2;
                break;
            }
            n2 = i + 1;
            break;
        }
        if (n2 >= n3) {
            n2 = -1;
        }
        return n2;
    }

    public static String[] splitByNewLine(String string) {
        if (string == null) {
            throw new IllegalArgumentException("line is null");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = StringUtil.a(string);
        while (n2 != -1) {
            arrayList.add(string.substring(n, n2));
            n = n2;
            n2 = StringUtil.a(string, n);
        }
        arrayList.add(string.substring(n));
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static boolean a(char c) {
        return c == '\t' || c == ' ' || c == '\u00a0' || c == '\u3000';
    }

    public static String trimLeadingBlanks(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && StringUtil.a(string.charAt(n)); ++n) {
        }
        return n > 0 ? string.substring(n) : string;
    }

    public static String trimTrailingBlanks(String string) {
        int n;
        int n2;
        for (n2 = n = string.length(); n2 > 0 && StringUtil.a(string.charAt(n2 - 1)); --n2) {
        }
        return n2 < n ? string.substring(0, n2) : string;
    }

    public static String cleanNullTerminatedString(String string) {
        int n = string.indexOf(0);
        if (n == -1) {
            return string;
        }
        if (n == 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String left(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("nCount must be non-negative");
        }
        if (n < string.length()) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String right(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("nCount must be non-negative");
        }
        int n2 = string.length();
        int n3 = n >= n2 ? 0 : n2 - n;
        return string.substring(n3);
    }

    public static String mid(String string, int n) {
        return n == 0 ? string : string.substring(n);
    }

    public static String mid(String string, int n, int n2) {
        if (n + n2 > string.length()) {
            return null;
        }
        if (n + n2 == string.length()) {
            return StringUtil.mid(string, n);
        }
        return string.substring(n, n + n2);
    }

    public static String makePaddedString(char c, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("nCount must be non-negative");
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        if (n > 0) {
            for (int i = 1; i <= n; ++i) {
                stringBuilder.append(c);
            }
        }
        return stringBuilder.toString();
    }

    public static boolean MatchStringPattern(String string, String string2, boolean bl) {
        if (!bl) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        return StringUtil.a(string, string2, 0, 0);
    }

    private static boolean a(String string, String string2, int n, int n2) {
        boolean bl = false;
        while (n2 < string2.length()) {
            if ('\\' == string2.charAt(n2) && !bl) {
                bl = true;
                if (n < string.length() && '\\' == string.charAt(n)) {
                    char c = '\u0000';
                    char c2 = '\u0000';
                    if (n2 + 1 < string2.length()) {
                        c = string2.charAt(n2 + 1);
                    }
                    if (n + 1 < string.length()) {
                        c2 = string.charAt(n + 1);
                    }
                    if ('\\' != c || '\\' == c && '\\' == c2) {
                        ++n;
                    }
                }
            } else {
                if ('*' == string2.charAt(n2) && !bl) {
                    while (true) {
                        if (n2 + 1 == string2.length()) {
                            return true;
                        }
                        if (StringUtil.a(string, string2, n, n2 + 1)) {
                            return true;
                        }
                        if (n == string.length()) {
                            return false;
                        }
                        ++n;
                    }
                }
                if (n == string.length()) {
                    return false;
                }
                if ((string2.charAt(n2) != '?' || bl) && string2.charAt(n2) != string.charAt(n)) {
                    return false;
                }
                bl = false;
                ++n;
            }
            ++n2;
        }
        return n == string.length();
    }

    public static double strToScaledDouble(String string, char c) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        double d = 0.0;
        int n = 1;
        block4: for (int i = 0; i < string.length() && !bl4; ++i) {
            char c2 = string.charAt(i);
            switch (c2) {
                case '-': {
                    if (bl || bl2 || bl3) {
                        bl4 = true;
                        continue block4;
                    }
                    bl = true;
                    continue block4;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    bl2 = true;
                    d = d * 10.0 + (double)(c2 - 48);
                    if (!bl3) continue block4;
                    n *= 10;
                    continue block4;
                }
                default: {
                    if (Character.isSpaceChar(c2)) {
                        if (!bl && !bl2 && !bl3) continue block4;
                        bl4 = true;
                        continue block4;
                    }
                    if (c2 == c) {
                        if (bl3) {
                            bl4 = true;
                            continue block4;
                        }
                        bl3 = true;
                        continue block4;
                    }
                    bl4 = true;
                }
            }
        }
        d *= 100.0;
        if (bl3) {
            d /= (double)n;
        }
        if (bl) {
            d = -d;
        }
        return d;
    }

    public static String removeNegativeSymbol(String string) {
        if (string.length() <= 0) {
            return string;
        }
        if (string.charAt(0) == '-') {
            if (string.length() == 1) {
                return "";
            }
            return string.substring(1);
        }
        int n = string.length();
        char c = string.charAt(n - 1);
        if (c == '-') {
            return string.substring(0, n > 1 ? n - 1 : 0);
        }
        if (string.charAt(0) == '(' && c == ')') {
            return string.substring(1, n - 1);
        }
        return string;
    }

    public static String removeCurrencySymbol(String string, String string2) {
        if (string.length() <= 0) {
            return string;
        }
        int n = string2.length();
        if (string.startsWith(string2)) {
            return string.substring(n);
        }
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - n - 1);
        }
        String string3 = "$";
        if (!string2.equals(string3)) {
            return StringUtil.removeCurrencySymbol(string, string3);
        }
        return string;
    }

    public static boolean isNumeric(String string, char c, char c2) {
        char c3;
        int n;
        boolean bl = false;
        int n2 = string.length();
        for (n = 0; n < n2; ++n) {
            c3 = string.charAt(n);
            if (Character.isDigit(c3)) {
                bl = true;
                continue;
            }
            if (c3 != c) break;
        }
        if (n < n2 && string.charAt(n) == c2) {
            ++n;
            while (n < n2 && Character.isDigit(c3 = string.charAt(n))) {
                bl = true;
                ++n;
            }
        }
        if (n < n2) {
            bl = false;
        }
        return bl;
    }

    public static String getLocaleString(Locale locale) {
        Locale locale2 = locale == null ? Locale.getDefault() : locale;
        String string = "";
        String string2 = locale2.getLanguage();
        String string3 = locale2.getCountry();
        string2 = string2 == null ? "" : string2;
        String string4 = string3 = string3 == null ? "" : string3;
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        }
        if (string3.length() > 2) {
            string3 = string3.substring(0, 2);
        }
        if (string2.length() > 0) {
            string = string2;
            if (string3.length() > 0) {
                string = string + "_" + string3;
            }
        } else if (string3.length() > 0) {
            string = string3;
        }
        return string;
    }

    public static char toLowerCase(char c, Locale locale) {
        if (locale.getLanguage().equals("tr")) {
            if (c == '\u0130') {
                return 'i';
            }
            if (c == 'I') {
                return '\u0131';
            }
        }
        return Character.toLowerCase(c);
    }

    public static final String toLowerCaseEng(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ('A' > c || c > 'Z') continue;
            char[] cArray = new char[n];
            string.getChars(0, n, cArray, 0);
            while (i < n) {
                c = cArray[i];
                if ('A' <= c && c <= 'Z') {
                    cArray[i] = (char)(c - 65 + 97);
                }
                ++i;
            }
            return new String(cArray);
        }
        return string;
    }

    public static char toLowerCaseEng(char c) {
        if ('A' <= c && c <= 'Z') {
            return (char)(c - 65 + 97);
        }
        return c;
    }

    public static char toUpperCase(char c, Locale locale) {
        if (locale.getLanguage().equals("tr")) {
            if (c == 'i') {
                return '\u0130';
            }
            if (c == '\u0131') {
                return 'I';
            }
        }
        return Character.toUpperCase(c);
    }

    public static final String toUpperCaseEng(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ('a' > c || c > 'z') continue;
            char[] cArray = new char[n];
            string.getChars(0, n, cArray, 0);
            while (i < n) {
                c = cArray[i];
                if ('a' <= c && c <= 'z') {
                    cArray[i] = (char)(c - 97 + 65);
                }
                ++i;
            }
            return new String(cArray);
        }
        return string;
    }

    public static char toUpperCaseEng(char c) {
        if ('a' <= c && c <= 'z') {
            return (char)(c - 97 + 65);
        }
        return c;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class a
    implements Comparator<String> {
        private final Collator a;

        public a(Locale locale, boolean bl) {
            this.a = Collator.getInstance((Locale)locale);
            this.a.setStrength(bl ? 2 : 1);
        }

        public int a(String string, String string2) {
            return this.a.compare(string, string2);
        }
    }
}

