/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphicengine;

import com.businessobjects.foundation.exception.UncheckedException;
import com.businessobjects.visualization.GraphicInstance;
import com.businessobjects.visualization.common.exceptions.ChartEngineProviderRuntimeException;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.graphic.PublicGraphicDef;
import com.businessobjects.visualization.internal.classloader.ClassLoaderHelper;
import com.businessobjects.visualization.legend.IGraphicLegend;
import com.businessobjects.visualization.rendering.RenderEngine;
import com.businessobjects.visualization.window.WindowSize;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public abstract class GraphicEngine {
    private static final String UNKNOWN_ERROR_CODE = "Unknown";
    private static HashMap engineCache = new HashMap();

    public abstract RenderEngine process(GraphicInstance var1, int var2, int var3, boolean var4);

    public abstract IGraphicLegend getLegend(GraphicInstance var1, int var2);

    public abstract boolean supportsWindowing(PublicGraphicDef var1);

    public abstract WindowSize getDataWindowBestSize(GraphicInstance var1);

    public abstract WindowSize getDataWindowBestSize(GraphicInstance var1, int[] var2);

    public abstract WindowSize getDataWindowMaximumSize(GraphicInstance var1);

    public RenderEngine process(GraphicInstance gi, int outputType) {
        return this.process(gi, outputType, 0);
    }

    public RenderEngine process(GraphicInstance instance, int outputType, int retrieveMap) {
        return this.process(instance, outputType, retrieveMap, false);
    }

    public abstract void initSettingsDependency(GraphicInstance var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphicEngine getEngine(String sLoaderClass) {
        GraphicEngine returnedGraphicEngine = null;
        Constructor constructor = null;
        HashMap hashMap = engineCache;
        synchronized (hashMap) {
            constructor = (Constructor)engineCache.get(sLoaderClass);
            if (constructor == null) {
                if (sLoaderClass == null) {
                    throw new VisualizationInternalException("Could not find loaderClass name for provider");
                }
                Class loaderClass = null;
                try {
                    loaderClass = ClassLoaderHelper.loadClass(sLoaderClass);
                }
                catch (ClassNotFoundException e) {
                    throw new VisualizationInternalException("Exception while trying to find loader Class:" + sLoaderClass, e);
                }
                if (loaderClass == null) {
                    throw new VisualizationInternalException("Could not find loader Class:" + sLoaderClass);
                }
                try {
                    Class[] params = new Class[]{};
                    constructor = loaderClass.getConstructor(params);
                }
                catch (Exception e) {
                    throw new VisualizationInternalException("Exception while trying to find loader Class with params:" + sLoaderClass, e);
                }
                engineCache.put(sLoaderClass, constructor);
            }
        }
        Object[] args = new Object[]{};
        try {
            returnedGraphicEngine = (GraphicEngine)constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new VisualizationInternalException("Exception while trying to instantiate loader Class:" + sLoaderClass, e);
        }
        if (returnedGraphicEngine == null) {
            throw new VisualizationInternalException("Could not instantiate loader:" + sLoaderClass);
        }
        return returnedGraphicEngine;
    }

    public void importNativeTemplate(GraphicInstance graphicInstance, InputStream is) {
        throw new VisualizationInternalException("importNativeTemplate not supported by " + graphicInstance.getGraphicDef().getProviderDescription().getName());
    }

    public void exportNativeTemplate(GraphicInstance graphicInstance, OutputStream os) {
        throw new VisualizationInternalException("exportNativeTemplate not supported by " + graphicInstance.getGraphicDef().getProviderDescription().getName());
    }

    public static UncheckedException createException(String strProviderId, Throwable objThrowableExceptionCause) {
        if (objThrowableExceptionCause instanceof UncheckedException) {
            return (UncheckedException)objThrowableExceptionCause;
        }
        return new ChartEngineProviderRuntimeException(objThrowableExceptionCause.getMessage(), "", UNKNOWN_ERROR_CODE, strProviderId, objThrowableExceptionCause);
    }
}

