/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectType;
import org.json.JSONException;
import org.json.JSONObject;

public class VisuObjectReference
extends VisuObject {
    private static final int PARAMSIZE = 2;
    private static VisuObjectType type = VisuObjectType.REFERENCE;
    private VisuObjectType referenceType_;
    private String key_;

    public VisuObjectReference(VisuObjectType type, String key) {
        this.referenceType_ = type;
        this.key_ = key;
    }

    public VisuObjectReference(String xmlValue) {
        this.setXmlValue(xmlValue);
    }

    public String toString() {
        String s = "type:" + this.referenceType_ + " value:" + this.key_;
        return s;
    }

    protected void setXmlValue(String xmlValue) {
        this.setXmlValue(VisuObject.stringToArray(xmlValue));
    }

    protected String getXmlValue() {
        String xmlValue = String.valueOf(this.referenceType_.value()) + ";" + this.key_;
        return xmlValue;
    }

    protected Object clone() {
        return super.clone();
    }

    protected boolean checkValidity(Object param) {
        return true;
    }

    private void setXmlValue(String[] values) {
        this.checkParams(values, 2);
        int itype = Integer.parseInt(values[0]);
        this.referenceType_ = VisuObjectType.fromInt(itype);
        this.key_ = values[1];
    }

    public VisuObjectType getType() {
        return type;
    }

    public VisuObjectType getReferenceType() {
        return this.referenceType_;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof VisuObjectReference) {
            VisuObjectReference vor = (VisuObjectReference)obj;
            if (vor.key_.equals(this.key_) && vor.referenceType_.equals(this.referenceType_)) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getKey() {
        return this.key_;
    }

    protected JSONObject getJSONObject() {
        try {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("type", new Integer(type.value()));
            jsonObj.put("reference type", new Integer(this.referenceType_.value()));
            jsonObj.put("key", this.key_);
            return jsonObj;
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }

    VisuObjectReference(JSONObject jobj) {
        try {
            this.referenceType_ = VisuObjectType.fromInt(jobj.getInt("reference type"));
            this.key_ = jobj.getString("key");
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }
}

