/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;

public final class VisuGradientOrientationType {
    public static final int I_HORIZONTAL = 0;
    public static final int I_HORIZONTAL_INV = 1;
    public static final int I_VERTICAL = 2;
    public static final int I_VERTICAL_INV = 3;
    public static final int I_DIAGONAL_UP = 4;
    public static final int I_DIAGONAL_UP_INV = 5;
    public static final int I_DIAGONAL_DOWN = 6;
    public static final int I_DIAGONAL_DOWN_INV = 7;
    private static final String[] SVALUES = new String[]{"HORIZONTAL", "HORIZONTAL INV", "VERTICAL", "VERTICAL INV", "DIAGONAL UP", "DIAGONAL UP INV", "DIAGONAL DOWN", "DIAGONAL DOWN INV"};
    public static final VisuGradientOrientationType HORIZONTAL = new VisuGradientOrientationType(0);
    public static final VisuGradientOrientationType HORIZONTAL_INV = new VisuGradientOrientationType(1);
    public static final VisuGradientOrientationType VERTICAL = new VisuGradientOrientationType(2);
    public static final VisuGradientOrientationType VERTICAL_INV = new VisuGradientOrientationType(3);
    public static final VisuGradientOrientationType DIAGONAL_UP = new VisuGradientOrientationType(4);
    public static final VisuGradientOrientationType DIAGONAL_UP_INV = new VisuGradientOrientationType(5);
    public static final VisuGradientOrientationType DIAGONAL_DOWN = new VisuGradientOrientationType(6);
    public static final VisuGradientOrientationType DIAGONAL_DOWN_INV = new VisuGradientOrientationType(7);
    private final int value_;

    private VisuGradientOrientationType(int value) {
        this.value_ = value;
    }

    public int value() {
        return this.value_;
    }

    public String toString() {
        return SVALUES[this.value_];
    }

    public static VisuGradientOrientationType fromString(String s) {
        int type = 0;
        try {
            type = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new VisualizationRuntimeException("VIZ_00123_ERR_INVALID_STRING_TO_IN", new Object[]{s});
        }
        return VisuGradientOrientationType.fromInt(type);
    }

    static VisuGradientOrientationType fromInt(int type) {
        VisuGradientOrientationType colorType = null;
        switch (type) {
            case 0: {
                colorType = HORIZONTAL;
                break;
            }
            case 1: {
                colorType = HORIZONTAL_INV;
                break;
            }
            case 2: {
                colorType = VERTICAL;
                break;
            }
            case 3: {
                colorType = VERTICAL_INV;
                break;
            }
            case 4: {
                colorType = DIAGONAL_UP;
                break;
            }
            case 5: {
                colorType = DIAGONAL_UP_INV;
                break;
            }
            case 6: {
                colorType = DIAGONAL_DOWN;
                break;
            }
            case 7: {
                colorType = DIAGONAL_DOWN_INV;
                break;
            }
            default: {
                throw new VisualizationRuntimeException("VIZ_00124_ERR_INVALID_TYPE_TO_INIT", new Object[]{new Integer(type)});
            }
        }
        return colorType;
    }
}

