/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectType;
import org.json.JSONException;
import org.json.JSONObject;

public class VisuBool
extends VisuObject {
    private static VisuObjectType type = VisuObjectType.BOOL;
    public static final VisuBool TRUE = new VisuBool(true);
    public static final VisuBool FALSE = new VisuBool(false);
    private boolean value_;

    public VisuBool(boolean b) {
        this.value_ = b;
    }

    public VisuBool(String s) {
        this.setXmlValue(s);
    }

    public String toString() {
        String s = String.valueOf(this.value_);
        return s;
    }

    public boolean booleanValue() {
        return this.value_;
    }

    public VisuObjectType getType() {
        return type;
    }

    public boolean equals(Object obj) {
        boolean ret = false;
        if (obj instanceof VisuBool) {
            VisuBool vb = (VisuBool)obj;
            if (vb.value_ == this.value_) {
                ret = true;
            }
        }
        return ret;
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected String getXmlValue() {
        if (this.value_) {
            return "true";
        }
        return "false";
    }

    protected Object clone() {
        return super.clone();
    }

    protected void setXmlValue(String xmlValue) {
        this.value_ = xmlValue != null && xmlValue.equalsIgnoreCase("true");
    }

    protected JSONObject getJSONObject() {
        try {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("type", new Integer(type.value()));
            jsonObj.put("value", this.value_ ? Boolean.TRUE : Boolean.FALSE);
            return jsonObj;
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }

    VisuBool(JSONObject jobj) {
        try {
            this.value_ = jobj.getBoolean("value");
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }

    public static VisuBool getVisuBool(boolean bool) {
        return bool ? TRUE : FALSE;
    }
}

