/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.graphic.GraphicDefNode;
import com.businessobjects.visualization.graphic.PropertyDefVisibilityType;
import com.businessobjects.visualization.graphic.VisuObject;
import java.util.Enumeration;
import java.util.Vector;

public abstract class SettingsTree {
    private GraphicDefNode definition_;
    private VisuObject value_;
    private Vector childs_ = new Vector();
    private SettingsTree parent_;
    private PropertyDefVisibilityType visibility_;

    protected SettingsTree(GraphicDefNode def, SettingsTree parent, VisuObject value, PropertyDefVisibilityType visibility) {
        this.definition_ = def;
        this.parent_ = parent;
        this.value_ = value;
        this.visibility_ = visibility;
    }

    public final GraphicDefNode getDefinition() {
        return this.definition_;
    }

    public final VisuObject getValue() {
        return this.value_;
    }

    public final Enumeration getChilds() {
        return this.childs_.elements();
    }

    public final int getChildsSize() {
        return this.childs_.size();
    }

    public final SettingsTree getParent() {
        return this.parent_;
    }

    public final boolean isLeaf() {
        return this.childs_.isEmpty();
    }

    public String toString() {
        return "definition : " + this.getDefinition().getName();
    }

    protected final Vector getChildVector() {
        return this.childs_;
    }

    public abstract void update();

    protected final void updateValue(VisuObject vo) {
        this.value_ = vo;
    }

    protected final void cleanChilds() {
        this.childs_.removeAllElements();
    }

    protected final PropertyDefVisibilityType getVisibility() {
        return this.visibility_;
    }
}

