/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.graphic.RegionShape;

public class RegionCoordinates {
    private RegionShape shape_;
    private int[] coordinates_;
    private int[] bbox_ = new int[4];

    public RegionCoordinates(RegionShape type, int[] coord) {
        this.shape_ = type;
        this.coordinates_ = coord;
        this.calcBBox();
    }

    public RegionCoordinates(String shape, String coord) {
        this.shape_ = RegionShape.parse(shape);
        String[] coords = coord.split(",");
        this.coordinates_ = new int[coords.length];
        for (int coordIdx = 0; coordIdx < coords.length; ++coordIdx) {
            this.coordinates_[coordIdx] = Integer.parseInt(coords[coordIdx]);
        }
        this.calcBBox();
    }

    private void calcBBox() {
        if (this.shape_.value() == 4) {
            this.bbox_[0] = this.coordinates_[0] - this.coordinates_[2];
            this.bbox_[1] = this.coordinates_[1] - this.coordinates_[3];
            this.bbox_[2] = this.coordinates_[2] * 2;
            this.bbox_[3] = this.coordinates_[3] * 2;
            return;
        }
        if (this.shape_.value() == 0) {
            System.arraycopy(this.coordinates_, 0, this.bbox_, 0, 4);
            return;
        }
        this.bbox_[0] = Integer.MAX_VALUE;
        this.bbox_[1] = Integer.MAX_VALUE;
        this.bbox_[2] = Integer.MIN_VALUE;
        this.bbox_[3] = Integer.MIN_VALUE;
        for (int i = 0; i < this.coordinates_.length; i += 2) {
            if (this.coordinates_[i] < this.bbox_[0]) {
                this.bbox_[0] = this.coordinates_[i];
            } else if (this.coordinates_[i] > this.bbox_[2]) {
                this.bbox_[2] = this.coordinates_[i];
            }
            if (this.coordinates_[i + 1] < this.bbox_[1]) {
                this.bbox_[1] = this.coordinates_[i + 1];
                continue;
            }
            if (this.coordinates_[i + 1] <= this.bbox_[3]) continue;
            this.bbox_[3] = this.coordinates_[i + 1];
        }
    }

    public int[] getBoundingBox() {
        return this.bbox_;
    }

    public RegionShape getShape() {
        return this.shape_;
    }

    public int[] getCoordinates() {
        return this.coordinates_;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("RegCoord[");
        if (this.coordinates_ == null) {
            buffer.append("coord_ = ").append("null");
        } else {
            buffer.append("coord_ = ").append("[");
            for (int i = 0; i < this.coordinates_.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.coordinates_[i]);
            }
            buffer.append("]");
        }
        buffer.append(", type_ = ").append(this.shape_);
        buffer.append("]");
        return buffer.toString();
    }

    public boolean overlap(RegionCoordinates rc) {
        int[] bb = rc.getBoundingBox();
        return bb[2] >= this.bbox_[0] && this.bbox_[2] >= bb[0] && bb[3] >= this.bbox_[1] && this.bbox_[3] >= bb[1];
    }
}

