/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data.impl;

import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.dataexchange.callbacks.IValuesGrid;
import com.businessobjects.visualization.dataexchange.data.impl.DoubleValueData;
import com.businessobjects.visualization.formatting.INumericFormatter;

public class MeasureValuesGridImpl
implements IValuesGrid {
    private Object values_;
    private int cardinality_;

    public MeasureValuesGridImpl(DoubleValueData data) {
        this.values_ = data.getValues();
        this.cardinality_ = data.getCardinality();
    }

    public double valueAt(int x, int y, int z) {
        if (this.cardinality_ == 1) {
            return ((double[])this.values_)[x];
        }
        if (this.cardinality_ == 2) {
            return ((double[][])this.values_)[x][y];
        }
        if (this.cardinality_ == 3) {
            return ((double[][][])this.values_)[x][y][z];
        }
        throw new VisualizationRuntimeException("VIZ_00022_ERR_IMPROPER_CARDINALITY");
    }

    public double[] getSerie(int x, int y) {
        if (this.cardinality_ == 1) {
            return (double[])this.values_;
        }
        if (this.cardinality_ == 2) {
            return ((double[][])this.values_)[x];
        }
        if (this.cardinality_ == 3) {
            return ((double[][][])this.values_)[x][y];
        }
        throw new VisualizationRuntimeException("VIZ_00022_ERR_IMPROPER_CARDINALITY");
    }

    public int getSeriesCount() {
        if (this.cardinality_ == 1) {
            return 1;
        }
        if (this.cardinality_ == 2) {
            return ((double[][])this.values_).length;
        }
        if (this.cardinality_ == 3) {
            return ((double[][][])this.values_).length;
        }
        throw new VisualizationRuntimeException("VIZ_00022_ERR_IMPROPER_CARDINALITY");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formattedValueAt(int x, int y, int z, INumericFormatter formatter) {
        Object object = this.values_;
        synchronized (object) {
            if (this.cardinality_ == 1) {
                formatter.format(((double[])this.values_)[x]);
                return formatter.out();
            }
            if (this.cardinality_ == 2) {
                formatter.format(((double[][])this.values_)[x][y]);
                return formatter.out();
            }
            if (this.cardinality_ == 3) {
                formatter.format(((double[][][])this.values_)[x][y][z]);
                return formatter.out();
            }
        }
        throw new VisualizationRuntimeException("VIZ_00022_ERR_IMPROPER_CARDINALITY");
    }

    private synchronized String[] getFormattedArray(double[] values, INumericFormatter formatter) {
        String[] valFormatted = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            formatter.format(values[i]);
            valFormatted[i] = formatter.out();
        }
        return valFormatted;
    }

    public String[] getFormattedSerie(int x, int y, INumericFormatter formatter) {
        if (this.cardinality_ == 1) {
            return this.getFormattedArray((double[])this.values_, formatter);
        }
        if (this.cardinality_ == 2) {
            return this.getFormattedArray(((double[][])this.values_)[x], formatter);
        }
        if (this.cardinality_ == 3) {
            return this.getFormattedArray(((double[][][])this.values_)[x][y], formatter);
        }
        throw new VisualizationRuntimeException("VIZ_00022_ERR_IMPROPER_CARDINALITY");
    }
}

