/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data;

import com.businessobjects.visualization.common.exceptions.SerializationException;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.data.ClientInfoAdapter;
import com.businessobjects.visualization.dataexchange.data.Data;
import com.businessobjects.visualization.dataexchange.data.DataRange;
import com.businessobjects.visualization.dataexchange.data.generated.XMLClientInfoAdapter;
import com.businessobjects.visualization.dataexchange.data.generated.XMLData;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDataRange;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDataRangeList;
import com.businessobjects.visualization.dataexchange.data.generated.XMLGroupingDimensionAdapter;
import com.businessobjects.visualization.dataexchange.data.impl.StringLabelData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class GroupingDimensionAdapter
implements IXMLDelegator {
    private ClientInfoAdapter clientInfoAdapter;
    private GroupingDimensionAdapter[] groupingDimensionAdapterList;
    private Vector dimensionsDataRangeLists = new Vector();
    private Vector groupingDataRangeLists = new Vector();
    private Data data;

    public GroupingDimensionAdapter(GroupingDimensionAdapter[] gda, ClientInfoAdapter cia) {
        this.clientInfoAdapter = cia;
        this.groupingDimensionAdapterList = gda;
    }

    public GroupingDimensionAdapter(XMLGroupingDimensionAdapter adapter, SerializationHelper sh) {
        this.clientInfoAdapter = new ClientInfoAdapter(adapter.m_clientInfoAdapter, sh);
        this.groupingDimensionAdapterList = new GroupingDimensionAdapter[adapter.m_list_groupingDimensionList.size()];
        Iterator iter = adapter.m_list_groupingDimensionList.iterator();
        int i = 0;
        while (iter.hasNext()) {
            this.groupingDimensionAdapterList[i++] = new GroupingDimensionAdapter((XMLGroupingDimensionAdapter)iter.next(), sh);
        }
        iter = adapter.m_list_dimensionRangeLists.iterator();
        this.fillRanges(iter, this.dimensionsDataRangeLists);
        iter = adapter.m_list_groupingRangeLists.iterator();
        this.fillRanges(iter, this.groupingDataRangeLists);
        if (adapter.m_values != null) {
            if (adapter.m_values.m_dataType.value() != 0) {
                throw new SerializationException("VIZ_00002_ERR_DESERIALIZATION_ERROR", "Invalid datatype for grouping dimensions:" + adapter.m_values.m_dataType);
            }
            this.data = new StringLabelData(adapter.m_values, sh);
        }
    }

    private void fillRanges(Iterator iter, Vector vector) {
        int i = 0;
        while (iter.hasNext()) {
            XMLDataRangeList xmlDataRangeList = (XMLDataRangeList)iter.next();
            DataRange[] newDataRangeList = new DataRange[xmlDataRangeList.m_list_dataRangeList.size()];
            Iterator iter2 = xmlDataRangeList.m_list_dataRangeList.iterator();
            int j = 0;
            while (iter2.hasNext()) {
                XMLDataRange xmlRange = (XMLDataRange)iter2.next();
                newDataRangeList[j++] = new DataRange(xmlRange.m_a_lower, xmlRange.m_a_upper);
            }
            vector.add(i, newDataRangeList);
        }
    }

    public ClientInfoAdapter getClientInfoAdapter() {
        return this.clientInfoAdapter;
    }

    public GroupingDimensionAdapter[] getGroupingDimensionAdapterList() {
        return this.groupingDimensionAdapterList;
    }

    public void setDimensionDataRangeListAt(int iDimensionIndex, DataRange[] dataRangeList) {
        this.dimensionsDataRangeLists.add(iDimensionIndex, dataRangeList);
    }

    public DataRange[] getDimensionDataRangeListAt(int iDimensionIndex) {
        return (DataRange[])this.dimensionsDataRangeLists.get(iDimensionIndex);
    }

    public void setGroupingDataRangeListAt(int iGroupingIndex, DataRange[] dataRangeList) {
        this.groupingDataRangeLists.add(iGroupingIndex, dataRangeList);
    }

    public DataRange[] getGroupingDataRangeListAt(int iGroupingIndex) {
        return (DataRange[])this.groupingDataRangeLists.get(iGroupingIndex);
    }

    public Data getData() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    private void fillXMLRange(Vector vector, ArrayList xmlList) {
        for (int j = 0; j < vector.size(); ++j) {
            DataRange[] aDataRange = (DataRange[])vector.get(j);
            XMLDataRangeList xmlDataRangeList = new XMLDataRangeList();
            for (int i = 0; i < aDataRange.length; ++i) {
                XMLDataRange xmlDataRange = new XMLDataRange();
                xmlDataRange.m_a_lower = aDataRange[i].getLower();
                xmlDataRange.m_a_upper = aDataRange[i].getUpper();
                xmlDataRangeList.m_list_dataRangeList.add(xmlDataRange);
            }
            xmlList.add(xmlDataRangeList);
        }
    }

    public Object getXMLDelegate() {
        XMLGroupingDimensionAdapter xmlGrouping = new XMLGroupingDimensionAdapter();
        this.fillXMLRange(this.groupingDataRangeLists, xmlGrouping.m_list_groupingRangeLists);
        this.fillXMLRange(this.dimensionsDataRangeLists, xmlGrouping.m_list_dimensionRangeLists);
        for (int i = 0; i < this.groupingDimensionAdapterList.length; ++i) {
            xmlGrouping.m_list_groupingDimensionList.add((XMLGroupingDimensionAdapter)this.groupingDimensionAdapterList[i].getXMLDelegate());
        }
        xmlGrouping.m_clientInfoAdapter = (XMLClientInfoAdapter)this.clientInfoAdapter.getXMLDelegate();
        if (this.data != null) {
            xmlGrouping.m_values = (XMLData)this.data.getXMLDelegate();
        }
        return xmlGrouping;
    }
}

