/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.GraphicDescription;
import com.businessobjects.visualization.GraphicInstance;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.dataexchange.definition.DataDescriptor;
import com.businessobjects.visualization.feed.definition.DataFeedDefinition;
import com.businessobjects.visualization.feed.definition.FeedDef;
import com.businessobjects.visualization.graphic.PublicGraphicDef;
import com.businessobjects.visualization.graphic.xml.scoring.generated.XMLCategoryScoringRule;
import com.businessobjects.visualization.graphic.xml.scoring.generated.XMLCategoryScoringRules;
import com.businessobjects.visualization.graphic.xml.scoring.generated.XMLFeedScoringRule;
import com.businessobjects.visualization.graphic.xml.scoring.generated.XMLFeedSpecification;
import com.businessobjects.visualization.graphic.xml.scoring.generated.XMLScoringRules;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public final class Score
implements Comparable {
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$Score == null ? (class$com$businessobjects$visualization$Score = Score.class$("com.businessobjects.visualization.Score")) : class$com$businessobjects$visualization$Score));
    private final DataDescriptor dataContext_;
    private final GraphicDescription graphicDesc_;
    private final String businessDomainId_;
    private final String analysisTypeId_;
    private final double score_;
    static /* synthetic */ Class class$com$businessobjects$visualization$Score;

    private Score(DataDescriptor dataContext, GraphicDescription graphicDesc, String businessDomainId, String analysisTypeId, double score) {
        this.dataContext_ = dataContext;
        this.graphicDesc_ = graphicDesc;
        this.businessDomainId_ = businessDomainId;
        this.analysisTypeId_ = analysisTypeId;
        this.score_ = score;
    }

    public String getAnalysisTypeId() {
        return this.analysisTypeId_;
    }

    public String getBusinessDomainId() {
        return this.businessDomainId_;
    }

    public GraphicDescription getGraphicDescription() {
        return this.graphicDesc_;
    }

    public double getScore() {
        return this.score_;
    }

    public DataDescriptor getDataContext() {
        return this.dataContext_;
    }

    public int compareTo(Object oThat) {
        if (this == oThat) {
            return 0;
        }
        Score that = (Score)oThat;
        if (this.getScore() > that.getScore()) {
            return 1;
        }
        if (this.getScore() < that.getScore()) {
            return -1;
        }
        return -1;
    }

    public static Score computeScore(GraphicInstance gi, GraphicDescription gd, String businessDomainId, String analysisTypeId) {
        boolean bHasUnfeededDataContainers;
        if (gi.getGraphicId() == null) {
            throw new VisualizationInternalException("Graphic is null, should be defined in graphicInstance");
        }
        XMLScoringRules xmlScoringRules = gi.getLocalizedEngine().getXMLScoringRules();
        Iterator categRulesIter = xmlScoringRules.m_list_CategoryScoringRules.iterator();
        ArrayList xmlFeedScoringRuleList = null;
        double score = 0.0;
        double defaultScore = xmlScoringRules.m_a_DefaultFeedValueScore;
        double defaultIncompleteScore = xmlScoringRules.m_a_DefaultIncompleteFeedValueScore;
        boolean bl = bHasUnfeededDataContainers = gi.getFeeder().getUnfeededDataContainers().size() > 0;
        if (bHasUnfeededDataContainers) {
            LOGGER.warn((Object)"Unfeeded dataContainers, returning default incomplete score !!");
            LOGGER.info((Object)("Score for:" + gi.getPublicGraphicId() + "=" + defaultIncompleteScore));
            return new Score(gi.getDataDescriptor(), gd, businessDomainId, analysisTypeId, defaultIncompleteScore);
        }
        while (categRulesIter.hasNext()) {
            XMLCategoryScoringRules xmlCategScoringRules = (XMLCategoryScoringRules)categRulesIter.next();
            if (!businessDomainId.equals("") && businessDomainId.indexOf(xmlCategScoringRules.m_a_BusinessDomain.toString()) == -1 || !analysisTypeId.equals("") && analysisTypeId.indexOf(xmlCategScoringRules.m_a_AnalysisType.toString()) == -1) continue;
            Iterator categRuleIter = xmlCategScoringRules.m_list_CategoryScoringRule.iterator();
            while (categRuleIter.hasNext()) {
                XMLCategoryScoringRule xmlCategScoringRule = (XMLCategoryScoringRule)categRuleIter.next();
                if (!xmlCategScoringRule.m_a_PublicGraphidId.equals(gi.getPublicGraphicId())) continue;
                xmlFeedScoringRuleList = xmlCategScoringRule.m_list_FeedScoringRule;
                Iterator feedScoringIter = xmlFeedScoringRuleList.iterator();
                while (feedScoringIter.hasNext()) {
                    XMLFeedScoringRule xmlFeedScoringRule = (XMLFeedScoringRule)feedScoringIter.next();
                    Iterator feedRestrictionsIter = xmlFeedScoringRule.m_list_FeedSpecification.iterator();
                    boolean bMatchRestrictions = true;
                    while (feedRestrictionsIter.hasNext()) {
                        XMLFeedSpecification xmlFeedRestriction = (XMLFeedSpecification)feedRestrictionsIter.next();
                        int nFeedCount = gi.getFeeder().getCurrentDataFeed().findByDefId(xmlFeedRestriction.m_a_FeedDefId).length;
                        if (gi.getMediator().checkRestrictions(nFeedCount, FeedDef.minFromXmlDouble(xmlFeedRestriction.m_a_min), FeedDef.maxFromXmlDouble(xmlFeedRestriction.m_a_max))) continue;
                        bMatchRestrictions = false;
                        break;
                    }
                    if (!bMatchRestrictions || !(xmlFeedScoringRule.m_a_Score > score)) continue;
                    score = xmlFeedScoringRule.m_a_Score;
                }
            }
        }
        if (xmlFeedScoringRuleList == null) {
            LOGGER.info((Object)("Score for:" + gi.getPublicGraphicId() + "=" + defaultScore));
            LOGGER.warn((Object)"Did not find any matching graphic id in scoring (although it was properly feeded)");
            return new Score(gi.getDataDescriptor(), gd, businessDomainId, analysisTypeId, defaultScore);
        }
        if (score == 0.0) {
            LOGGER.info((Object)"Could not find any matching restrictions for the feed");
            score = defaultScore;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Score for:" + gi.getPublicGraphicId() + "=" + score));
        }
        return new Score(gi.getDataDescriptor(), gd, businessDomainId, analysisTypeId, score);
    }

    static void checkValidScoringRules(XMLScoringRules xmlScoringRules, Hashtable feedSpecHt, Hashtable publicGraphicHt) {
        Iterator categRulesIter = xmlScoringRules.m_list_CategoryScoringRules.iterator();
        ArrayList xmlFeedScoringRuleList = null;
        while (categRulesIter.hasNext()) {
            XMLCategoryScoringRules xmlCategScoringRules = (XMLCategoryScoringRules)categRulesIter.next();
            Iterator categRuleIter = xmlCategScoringRules.m_list_CategoryScoringRule.iterator();
            while (categRuleIter.hasNext()) {
                XMLCategoryScoringRule xmlCategScoringRule = (XMLCategoryScoringRule)categRuleIter.next();
                if (!publicGraphicHt.containsKey(xmlCategScoringRule.m_a_PublicGraphidId)) {
                    LOGGER.warn((Object)("The current scoring file references a public GraphicId that does not exist:" + xmlCategScoringRule.m_a_PublicGraphidId));
                    continue;
                }
                PublicGraphicDef pgDef = (PublicGraphicDef)publicGraphicHt.get(xmlCategScoringRule.m_a_PublicGraphidId);
                DataFeedDefinition dataFeedDef = (DataFeedDefinition)feedSpecHt.get(pgDef.getGraphicDef().getFeedId());
                xmlFeedScoringRuleList = xmlCategScoringRule.m_list_FeedScoringRule;
                Iterator feedScoringIter = xmlFeedScoringRuleList.iterator();
                while (feedScoringIter.hasNext()) {
                    XMLFeedScoringRule xmlFeedScoringRule = (XMLFeedScoringRule)feedScoringIter.next();
                    Iterator feedRestrictionsIter = xmlFeedScoringRule.m_list_FeedSpecification.iterator();
                    while (feedRestrictionsIter.hasNext()) {
                        XMLFeedSpecification xmlFeedRestriction = (XMLFeedSpecification)feedRestrictionsIter.next();
                        if (dataFeedDef.findById(xmlFeedRestriction.m_a_FeedDefId) != null) continue;
                        throw new VisualizationInternalException("Invalid Scoring file, Cannot find FeedId:" + xmlFeedRestriction.m_a_FeedDefId + " in DataFeedId:" + dataFeedDef.getId());
                    }
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

