/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.common.value;

import com.crystaldecisions12.reports.common.NumberUtil;
import com.crystaldecisions12.reports.common.value.CurrencyValue;
import com.crystaldecisions12.reports.common.value.FormatterCache;
import com.crystaldecisions12.reports.common.value.FormulaValue;
import com.crystaldecisions12.reports.common.value.FormulaValueType;
import com.crystaldecisions12.reports.common.value.NumberValue;
import com.ibm.icu.text.NumberFormat;
import java.util.Comparator;
import java.util.Locale;

public abstract class NumericValue
extends FormulaValue
implements Comparable {
    public static final double scalingFactor = 100.0;
    public static final int nExactDecimalPlaces = 2;
    private final double e;
    boolean f;

    NumericValue(double d10, boolean bl2) {
        if (d10 == 0.0) {
            d10 = 0.0;
        }
        this.e = d10;
        this.f = bl2 || NumberUtil.do(d10);
    }

    private static NumericValue a(double d10, FormulaValueType formulaValueType, boolean bl2) {
        if (formulaValueType == FormulaValueType.number) {
            return NumberValue.a(d10, bl2);
        }
        if (formulaValueType == FormulaValueType.currency) {
            return CurrencyValue.if(d10, bl2);
        }
        throw new UnsupportedOperationException();
    }

    public static NumericValue fromScaledDouble(double d10, FormulaValueType formulaValueType) {
        return NumericValue.a(d10, formulaValueType, false);
    }

    public static NumericValue fromScaledLong(long l2, FormulaValueType formulaValueType) {
        return NumericValue.a(l2, formulaValueType, NumberUtil.a(l2));
    }

    public static NumericValue fromDouble(double d10, FormulaValueType formulaValueType) {
        return NumericValue.fromScaledDouble(d10 * 100.0, formulaValueType);
    }

    public static NumericValue fromLong(long l2, FormulaValueType formulaValueType) {
        return NumericValue.a((double)l2 * 100.0, formulaValueType, NumberUtil.if(l2));
    }

    public static NumericValue fromNumericValue(NumericValue numericValue, FormulaValueType formulaValueType) {
        if (numericValue instanceof NumberValue && formulaValueType == FormulaValueType.number) {
            return numericValue;
        }
        if (numericValue instanceof CurrencyValue && formulaValueType == FormulaValueType.currency) {
            return numericValue;
        }
        return NumericValue.a(numericValue.getScaledDouble(), formulaValueType, numericValue.f);
    }

    public final NumericValue getNormalizedNumericValue() {
        if (this.f) {
            return this;
        }
        double d10 = NumberUtil.for(this.getScaledDouble());
        if (this.getScaledDouble() == d10) {
            this.f = true;
            return this;
        }
        return NumericValue.a(d10, this.getFormulaValueType(), true);
    }

    public final double getScaledDouble() {
        return this.e;
    }

    public final long getScaledLong() {
        if (Double.isInfinite(this.e) || Double.isNaN(this.e)) {
            throw new IllegalArgumentException("Inifite double value");
        }
        return (long)this.getScaledDouble();
    }

    public final int getScaledInt() {
        if (Double.isInfinite(this.e) || Double.isNaN(this.e)) {
            throw new IllegalArgumentException("Inifite double value");
        }
        return (int)this.getScaledDouble();
    }

    public final double getDouble() {
        return this.e / 100.0;
    }

    public final long getLong() {
        if (Double.isInfinite(this.e) || Double.isNaN(this.e)) {
            throw new IllegalArgumentException("Inifite double value");
        }
        return (long)this.getDouble();
    }

    public final int getInt() {
        if (Double.isInfinite(this.e) || Double.isNaN(this.e)) {
            throw new IllegalArgumentException("Inifite double value");
        }
        return (int)this.getDouble();
    }

    public final boolean isIntegerValue() {
        return this.getDouble() == (double)this.getInt();
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.e);
        return (int)(l2 ^ l2 >>> 32);
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object, Comparator comparator) {
        return this.compareTo(object);
    }

    public int compareTo(Object object) {
        if (this.e < ((NumericValue)object).e) {
            return -1;
        }
        if (this.e > ((NumericValue)object).e) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "(" + Double.toString(this.getDouble()) + ")";
    }

    public String toValueString() {
        NumberFormat numberFormat = FormatterCache.new(Locale.US);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(15);
        double d10 = 0.0;
        d10 = !this.f ? NumberUtil.for(this.getDouble()) : this.getDouble();
        String string = numberFormat.format(d10);
        return string;
    }
}

