/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.common.value;

import com.crystaldecisions12.reports.common.NotImplementedException;
import com.crystaldecisions12.reports.common.asserts.CrystalAssert;
import com.crystaldecisions12.reports.common.filemanagement.LERawData;
import com.crystaldecisions12.reports.common.filemanagement.LEStringEncoder;
import com.crystaldecisions12.reports.common.value.BooleanValue;
import com.crystaldecisions12.reports.common.value.CrystalComparable;
import com.crystaldecisions12.reports.common.value.CurrencyValue;
import com.crystaldecisions12.reports.common.value.DateTimeValue;
import com.crystaldecisions12.reports.common.value.DateValue;
import com.crystaldecisions12.reports.common.value.FormulaValue;
import com.crystaldecisions12.reports.common.value.FormulaValueType;
import com.crystaldecisions12.reports.common.value.NumberValue;
import com.crystaldecisions12.reports.common.value.StringValue;
import com.crystaldecisions12.reports.common.value.TimeValue;
import com.crystaldecisions12.reports.common.value.ValueType;
import java.io.IOException;
import java.text.ParseException;
import java.util.Comparator;

public abstract class CrystalValue
implements CrystalComparable {
    public abstract ValueType getValueType();

    public abstract int hashCode();

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public abstract int compareTo(Object var1, Comparator var2);

    static int a(CrystalValue crystalValue, CrystalValue crystalValue2, Comparator comparator) {
        if (crystalValue == null) {
            return crystalValue2 == null ? 0 : -1;
        }
        if (crystalValue2 == null) {
            return 1;
        }
        return crystalValue.compareTo(crystalValue2, comparator);
    }

    static int a(int n2, int n3) {
        if (n2 > n3) {
            return 1;
        }
        if (n2 < n3) {
            return -1;
        }
        return 0;
    }

    static int a(boolean bl2, boolean bl3) {
        if (bl2 == bl3) {
            return 0;
        }
        return bl2 ? 1 : -1;
    }

    public static void a(CrystalValue crystalValue, byte[] byArray, boolean bl2, int n2) {
        switch (crystalValue.getValueType().int()) {
            case 0: {
                LERawData.a(((NumberValue)crystalValue).getScaledInt(), byArray, n2);
                break;
            }
            case 1: {
                LERawData.int(((NumberValue)crystalValue).getScaledInt(), byArray, n2);
                break;
            }
            case 2: {
                LERawData.for(((NumberValue)crystalValue).getScaledInt(), byArray, n2);
                break;
            }
            case 3: {
                LERawData.do(((NumberValue)crystalValue).getScaledInt(), byArray, n2);
                break;
            }
            case 4: {
                LERawData.if(((NumberValue)crystalValue).getScaledInt(), byArray, n2);
                break;
            }
            case 5: {
                if (bl2) {
                    LERawData.do(((NumberValue)crystalValue).getScaledInt(), byArray, n2);
                    break;
                }
                LERawData.a(((NumberValue)crystalValue).getScaledLong(), byArray, n2);
                break;
            }
            case 15: {
                int n3 = ((DateTimeValue)crystalValue).getDateValue().getCRDate();
                int n4 = ((DateTimeValue)crystalValue).getTimeValue().getCRTime();
                LERawData.if(n3, byArray, n2);
                LERawData.if(n4, byArray, n2 + 4);
                break;
            }
            case 6: {
                if (bl2) {
                    double d10 = ((NumberValue)crystalValue).getScaledDouble();
                    if (d10 > 3.4028234663852886E38 || d10 < (double)1.4E-45f) {
                        throw new IllegalArgumentException();
                    }
                    LERawData.a((float)d10, byArray, n2);
                    break;
                }
                double d11 = ((NumberValue)crystalValue).getScaledDouble();
                LERawData.a(d11, byArray, n2);
                break;
            }
            case 7: {
                if (bl2) {
                    double d12 = ((CurrencyValue)crystalValue).getScaledDouble();
                    if (d12 > 3.4028234663852886E38 || d12 < (double)1.4E-45f) {
                        throw new IllegalArgumentException();
                    }
                    LERawData.a((float)d12, byArray, n2);
                    break;
                }
                LERawData.a(((CurrencyValue)crystalValue).getScaledDouble(), byArray, n2);
                break;
            }
            case 8: {
                if (crystalValue == BooleanValue.TRUE) {
                    LERawData.for(1, byArray, n2);
                    break;
                }
                LERawData.for(0, byArray, n2);
                break;
            }
            case 9: {
                LERawData.if(((DateValue)crystalValue).getCRDate(), byArray, n2);
                break;
            }
            case 10: {
                LERawData.if(((TimeValue)crystalValue).getCRTime(), byArray, n2);
                break;
            }
            case 11: {
                LEStringEncoder.a(((StringValue)crystalValue).getString(), byArray, n2);
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 255: {
                throw new IllegalArgumentException();
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public static CrystalValue a(byte[] byArray, int n2, int n3, ValueType valueType, boolean bl2, LEStringEncoder lEStringEncoder) throws IOException {
        FormulaValue formulaValue = null;
        switch (valueType.int()) {
            case 0: {
                CrystalAssert.a(n3 == 1);
                formulaValue = NumberValue.fromLong(LERawData.byte(byArray, n2));
                break;
            }
            case 1: {
                CrystalAssert.a(n3 == 1);
                formulaValue = NumberValue.fromLong(LERawData.int(byArray, n2));
                break;
            }
            case 2: {
                CrystalAssert.a(n3 == 2);
                formulaValue = NumberValue.fromLong(LERawData.new(byArray, n2));
                break;
            }
            case 3: {
                CrystalAssert.a(n3 == 2);
                formulaValue = NumberValue.fromLong(LERawData.a(byArray, n2));
                break;
            }
            case 4: {
                CrystalAssert.a(n3 == 4);
                formulaValue = NumberValue.fromLong(LERawData.try(byArray, n2));
                break;
            }
            case 5: {
                if (bl2) {
                    CrystalAssert.a(n3 == 2);
                    formulaValue = NumberValue.fromLong(LERawData.a(byArray, n2));
                    break;
                }
                CrystalAssert.a(n3 == 4);
                formulaValue = NumberValue.fromLong(LERawData.if(byArray, n2));
                break;
            }
            case 15: {
                CrystalAssert.a(n3 == 8);
                formulaValue = DateTimeValue.fromDateAndTimeValues(DateValue.fromCRDate(LERawData.try(byArray, n2)), TimeValue.fromCRTime(LERawData.try(byArray, n2 + 4)));
                break;
            }
            case 6: {
                if (bl2) {
                    CrystalAssert.a(n3 == 4);
                    formulaValue = NumberValue.fromScaledDouble(LERawData.case(byArray, n2));
                    break;
                }
                CrystalAssert.a(n3 == 8);
                formulaValue = NumberValue.fromScaledDouble(LERawData.for(byArray, n2));
                break;
            }
            case 7: {
                if (bl2) {
                    CrystalAssert.a(n3 == 4);
                    formulaValue = CurrencyValue.fromScaledDouble(LERawData.case(byArray, n2));
                    break;
                }
                CrystalAssert.a(n3 == 8);
                formulaValue = CurrencyValue.fromScaledDouble(LERawData.for(byArray, n2));
                break;
            }
            case 8: {
                CrystalAssert.a(n3 == 2);
                if (LERawData.new(byArray, n2) != 0) {
                    formulaValue = BooleanValue.TRUE;
                    break;
                }
                formulaValue = BooleanValue.FALSE;
                break;
            }
            case 9: {
                CrystalAssert.a(n3 == 4 || n3 == 8);
                formulaValue = DateValue.fromCRDate(LERawData.try(byArray, n2));
                break;
            }
            case 10: {
                CrystalAssert.a(n3 == 4);
                formulaValue = TimeValue.fromCRTime(LERawData.try(byArray, n2));
                break;
            }
            case 11: {
                int n4 = n2 + n3 - 2;
                if (n3 >= 2 && byArray[n4] == 0 && byArray[n4 + 1] == 0) {
                    n3 -= 2;
                }
                String string = lEStringEncoder == null ? LEStringEncoder.a(byArray, n2, n3, null) : lEStringEncoder.a(byArray, n2, n3);
                formulaValue = StringValue.fromString(string);
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 255: {
                throw new IllegalArgumentException();
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return formulaValue;
    }

    public static CrystalValue a(ValueType valueType) {
        switch (valueType.do().int()) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 16: 
            case 17: 
            case 18: {
                valueType = valueType.byte() ? ValueType.d : (valueType.char() ? ValueType.S : (valueType.else() ? ValueType.g : ValueType.ax));
                break;
            }
            case 13: {
                valueType = valueType.byte() ? ValueType.W : (valueType.char() ? ValueType.u : (valueType.else() ? ValueType.aG : ValueType.v));
                break;
            }
            case 14: {
                return null;
            }
            default: {
                CrystalAssert.a(false, "Unexpected ValueType");
                return null;
            }
        }
        return FormulaValue.makeZeroValue(FormulaValueType.fromValueType(valueType));
    }

    public String toValueString() throws NotImplementedException {
        throw new NotImplementedException();
    }

    public static CrystalValue a(String string) throws ParseException, NotImplementedException {
        throw new NotImplementedException();
    }
}

