/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.formulas.functions.string;

import com.crystaldecisions.reports.common.StringUtil;
import com.crystaldecisions.reports.common.asserts.CrystalAssert;
import com.crystaldecisions.reports.common.locale.FormatterCache;
import com.crystaldecisions.reports.common.value.BooleanValue;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.common.value.NumericValue;
import com.crystaldecisions.reports.common.value.StringValue;
import com.crystaldecisions.reports.common.value.TimeValue;
import com.crystaldecisions.reports.formulas.FormatStringParser;
import com.crystaldecisions.reports.formulas.FormulaEnvironment;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentDefinition;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentException;
import com.crystaldecisions.reports.formulas.FormulaFunctionBase;
import com.crystaldecisions.reports.formulas.FormulaFunctionCallException;
import com.crystaldecisions.reports.formulas.FormulaResources;
import com.crystaldecisions.reports.formulas.FormulaValueReference;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.util.Calendar;
import java.util.Locale;

class al
extends FormulaFunctionBase {
    public al(String string, String string2, FormulaFunctionArgumentDefinition[] formulaFunctionArgumentDefinitionArray) {
        super(string, string2, formulaFunctionArgumentDefinitionArray);
    }

    public boolean allowNullArguments() {
        return true;
    }

    public FormulaValueType validate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
        return FormulaValueType.string;
    }

    public FormulaValue evaluate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
        int n2 = formulaValueReferenceArray.length;
        CrystalAssert.ASSERT((n2 >= 1 ? 1 : 0) != 0);
        FormulaValueReference formulaValueReference = formulaValueReferenceArray[0];
        if (formulaValueReference.getFormulaValue() == null) {
            return StringValue.empty;
        }
        if (formulaValueReference.getFormulaValueType() == FormulaValueType.string) {
            return formulaValueReference.getFormulaValue();
        }
        if (formulaValueReference.getFormulaValueType() == FormulaValueType.bool) {
            BooleanValue booleanValue = (BooleanValue)formulaValueReference.getFormulaValue();
            if (booleanValue.getBoolean()) {
                return StringValue.fromString((String)"True");
            }
            return StringValue.fromString((String)"False");
        }
        Locale locale = formulaEnvironment.getFormulaContext().getLocale();
        if (formulaValueReference.getFormulaValueType().isNumeric()) {
            String string;
            CharSequence charSequence;
            String string2;
            double d10 = ((NumericValue)formulaValueReference.getFormulaValue()).getDouble();
            DecimalFormat decimalFormat = FormatterCache.GetDecimalFormatter((Locale)locale);
            if (n2 == 1) {
                String string3 = decimalFormat.format(d10);
                return StringValue.fromString((String)string3);
            }
            DecimalFormat decimalFormat2 = FormatterCache.GetDecimalFormatter((Locale)locale);
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat2.getDecimalFormatSymbols();
            FormulaValue formulaValue = formulaValueReferenceArray[1].getFormulaValue();
            int n3 = 2;
            boolean bl2 = false;
            String string4 = null;
            if (formulaValue.getFormulaValueType() == FormulaValueType.string) {
                string4 = ((StringValue)formulaValue).getString();
                bl2 = true;
                decimalFormat2.setGroupingUsed(false);
                ++n3;
            } else {
                decimalFormat2.setGroupingUsed(true);
            }
            String string5 = decimalFormat2.format(d10);
            if (n3 <= n2) {
                string2 = formulaValueReferenceArray[n3 - 1].getFormulaValue();
                long l2 = ((NumberValue)string2).getLong();
                if (l2 < 0L) {
                    throw new FormulaFunctionArgumentException("JRC00002490", "", FormulaResources.a(), "InvalidNumberOfDecimalPlaces", n3 - 1);
                }
                charSequence = bl2 ? new StringBuilder("##0") : new StringBuilder(",##0");
                if (l2 > 0L) {
                    ((StringBuilder)charSequence).append(".");
                    int n4 = 1;
                    while ((long)n4 <= l2) {
                        ((StringBuilder)charSequence).append("0");
                        ++n4;
                    }
                }
                decimalFormat2.applyPattern(((StringBuilder)charSequence).toString());
                string5 = decimalFormat2.format(d10);
                ++n3;
            }
            String string6 = string2 = String.valueOf(decimalFormatSymbols.getGroupingSeparator());
            if (n3 <= n2) {
                string = formulaValueReferenceArray[n3 - 1].getFormulaValue();
                if (string.getFormulaValueType() == FormulaValueType.string) {
                    string6 = ((StringValue)string).getString();
                    if (!bl2) {
                        string5 = StringUtil.replace((String)string5, (String)string2, (String)string6);
                    }
                }
                ++n3;
            }
            string = String.valueOf(decimalFormatSymbols.getDecimalSeparator());
            charSequence = string;
            if (n3 <= n2) {
                FormulaValue formulaValue2 = formulaValueReferenceArray[n3 - 1].getFormulaValue();
                if (formulaValue2.getFormulaValueType() == FormulaValueType.string) {
                    charSequence = ((StringValue)formulaValue2).getString();
                    if (!bl2) {
                        string5 = StringUtil.replace((String)string5, (String)string, (String)charSequence);
                    }
                }
                ++n3;
            }
            if (bl2 && (string5 = FormatStringParser.a(string4, string6, (String)charSequence, string5)) == null) {
                throw new FormulaFunctionArgumentException("JRC00002491", "", FormulaResources.a(), "BadNumberFormatString", 1);
            }
            return StringValue.fromString((String)string5);
        }
        if (formulaValueReference.getFormulaValueType() == FormulaValueType.date) {
            DateValue dateValue = (DateValue)formulaValueReference.getFormulaValue();
            String string = null;
            if (n2 >= 2) {
                FormulaValue formulaValue = formulaValueReferenceArray[1].getFormulaValue();
                String string7 = ((StringValue)formulaValue).getString();
                if (string7.length() > 0) {
                    FormatStringParser formatStringParser = new FormatStringParser();
                    string = formatStringParser.a(dateValue, string7);
                }
                if (string == null) {
                    throw new FormulaFunctionArgumentException("JRC00002492", "", FormulaResources.a(), "BadDateFormatString", 1);
                }
            } else {
                Calendar calendar = Calendar.getInstance((Locale)locale);
                calendar.set(DateValue.getYear((DateValue)dateValue), DateValue.getMonth((DateValue)dateValue) - 1, DateValue.getDay((DateValue)dateValue));
                string = FormatterCache.GetShortDateFormatter((Calendar)calendar, (Locale)locale).format((Object)calendar);
            }
            return StringValue.fromString(string);
        }
        if (formulaValueReference.getFormulaValueType() == FormulaValueType.time) {
            TimeValue timeValue = (TimeValue)formulaValueReference.getFormulaValue();
            String string = null;
            if (n2 >= 2) {
                FormulaValue formulaValue = formulaValueReferenceArray[1].getFormulaValue();
                String string8 = ((StringValue)formulaValue).getString();
                DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
                String[] stringArray = dateFormatSymbols.getAmPmStrings();
                String string9 = stringArray[0];
                String string10 = stringArray[1];
                if (n2 >= 3) {
                    string9 = ((StringValue)formulaValueReferenceArray[2].getFormulaValue()).getString();
                }
                if (n2 >= 4) {
                    string10 = ((StringValue)formulaValueReferenceArray[3].getFormulaValue()).getString();
                }
                if (string8.length() > 0) {
                    FormatStringParser formatStringParser = new FormatStringParser();
                    string = formatStringParser.a(timeValue, string8, string9, string10);
                }
                if (string == null) {
                    throw new FormulaFunctionArgumentException("JRC00002493", "", FormulaResources.a(), "BadTimeFormatString", 1);
                }
            } else {
                Calendar calendar = Calendar.getInstance((Locale)locale);
                calendar.set(0, 0, 0, TimeValue.getHours((TimeValue)timeValue), TimeValue.getMinutes((TimeValue)timeValue), TimeValue.getWholeSeconds((TimeValue)timeValue));
                calendar.set(14, (int)(TimeValue.getNanoseconds((TimeValue)timeValue) / 1000000L));
                string = FormatterCache.GetTimeFormatter((Calendar)calendar, (Locale)locale).format((Object)calendar);
            }
            return StringValue.fromString((String)string);
        }
        if (formulaValueReference.getFormulaValueType() == FormulaValueType.dateTime) {
            DateTimeValue dateTimeValue = (DateTimeValue)formulaValueReference.getFormulaValue();
            String string = null;
            if (n2 >= 2) {
                FormulaValue formulaValue = formulaValueReferenceArray[1].getFormulaValue();
                String string11 = ((StringValue)formulaValue).getString();
                DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
                String[] stringArray = dateFormatSymbols.getAmPmStrings();
                String string12 = stringArray[0];
                String string13 = stringArray[1];
                if (n2 >= 3) {
                    string12 = ((StringValue)formulaValueReferenceArray[2].getFormulaValue()).getString();
                }
                if (n2 >= 4) {
                    string13 = ((StringValue)formulaValueReferenceArray[3].getFormulaValue()).getString();
                }
                if (string11.length() > 0) {
                    FormatStringParser formatStringParser = new FormatStringParser();
                    string = formatStringParser.a(dateTimeValue, string11, string12, string13);
                }
                if (string == null) {
                    throw new FormulaFunctionArgumentException("JRC00002494", "", FormulaResources.a(), "BadDateTimeFormatString", 1);
                }
            } else {
                DateValue dateValue = null;
                TimeValue timeValue = null;
                if (dateTimeValue != null) {
                    dateValue = dateTimeValue.getDateValue();
                    timeValue = dateTimeValue.getTimeValue();
                }
                Calendar calendar = Calendar.getInstance((Locale)locale);
                calendar.set(DateValue.getYear((DateValue)dateValue), DateValue.getMonth((DateValue)dateValue) - 1, DateValue.getDay((DateValue)dateValue), TimeValue.getHours((TimeValue)timeValue), TimeValue.getMinutes((TimeValue)timeValue), TimeValue.getWholeSeconds((TimeValue)timeValue));
                calendar.set(14, (int)(TimeValue.getNanoseconds((TimeValue)timeValue) / 1000000L));
                string = FormatterCache.GetShortDateTimeFormatter((Calendar)calendar, (Locale)locale).format((Object)calendar);
            }
            return StringValue.fromString(string);
        }
        CrystalAssert.ASSERT((boolean)false);
        return formulaValueReference.getFormulaValue();
    }
}

