/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.formulas.functions.financial;

import com.crystaldecisions.reports.common.DateTimeUtil;
import com.crystaldecisions.reports.common.NumberUtil;
import com.crystaldecisions.reports.common.value.CurrencyValue;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.common.value.NumericValue;
import com.crystaldecisions.reports.formulas.FormulaEnvironment;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentDefinition;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentException;
import com.crystaldecisions.reports.formulas.FormulaFunctionBase;
import com.crystaldecisions.reports.formulas.FormulaFunctionCallException;
import com.crystaldecisions.reports.formulas.FormulaFunctionDefinition;
import com.crystaldecisions.reports.formulas.FormulaResources;
import com.crystaldecisions.reports.formulas.FormulaValueReference;
import com.crystaldecisions.reports.formulas.functions.CommonArguments;
import com.crystaldecisions.reports.formulas.functions.FormulaFunctionFactory;
import com.crystaldecisions.reports.formulas.functions.financial.ae;
import com.crystaldecisions.reports.formulas.functions.financial.an;

class at
implements FormulaFunctionFactory {
    private static final at hz = new at();
    private static final FormulaFunctionArgumentDefinition[][] hA = new FormulaFunctionArgumentDefinition[][]{{CommonArguments.cost, CommonArguments.purchaseDate, CommonArguments.firstPeriodEndDate, CommonArguments.salvage, CommonArguments.period, CommonArguments.rate}, {CommonArguments.cost, CommonArguments.purchaseDate, CommonArguments.firstPeriodEndDate, CommonArguments.salvage, CommonArguments.period, CommonArguments.rate, CommonArguments.basis}};
    private static final String hD = "amordegrc";
    private static final String hC = "amorlinc";
    private static final FormulaFunctionDefinition[] hB = new FormulaFunctionDefinition[]{new a("AmorDEGRC", "amordegrc", hA[0]), new a("AmorDEGRC", "amordegrc", hA[1]), new a("AmorLINC", "amorlinc", hA[0]), new a("AmorLINC", "amorlinc", hA[1])};

    private at() {
    }

    public static at bj() {
        return hz;
    }

    public FormulaFunctionDefinition getFunctionInstance(int n2) {
        return hB[n2];
    }

    public int getNFunctionInstances() {
        return hB.length;
    }

    private static class a
    extends FormulaFunctionBase {
        public a(String string, String string2, FormulaFunctionArgumentDefinition[] formulaFunctionArgumentDefinitionArray) {
            super(string, string2, formulaFunctionArgumentDefinitionArray);
        }

        public FormulaValueType validate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            int n2;
            double d10;
            if (formulaValueReferenceArray[0].getFormulaValue() != null && (d10 = ((NumericValue)formulaValueReferenceArray[0].getFormulaValue()).getDouble()) < 0.0) {
                throw new FormulaFunctionArgumentException("JRC00002328", "", FormulaResources.a(), "ArgumentOutOfRange", 0);
            }
            if (formulaValueReferenceArray[1].getFormulaValue() != null && formulaValueReferenceArray[2].getFormulaValue() != null) {
                DateValue dateValue = ((DateTimeValue)formulaValueReferenceArray[1].getFormulaValue()).getDateValue();
                DateValue dateValue2 = ((DateTimeValue)formulaValueReferenceArray[2].getFormulaValue()).getDateValue();
                if (dateValue.getCRDate() > dateValue2.getCRDate()) {
                    String[] stringArray = new String[]{"periodDate", "purchaseDate"};
                    throw new FormulaFunctionArgumentException("JRC00002329", "", FormulaResources.a(), "BadOrder", stringArray, 2);
                }
            }
            if (formulaValueReferenceArray[3].getFormulaValue() != null && formulaValueReferenceArray[0].getFormulaValue() != null) {
                d10 = ((NumericValue)formulaValueReferenceArray[3].getFormulaValue()).getDouble();
                double d11 = ((NumericValue)formulaValueReferenceArray[0].getFormulaValue()).getDouble();
                String[] stringArray = new String[]{"Cost", "Salvage"};
                if (d10 > d11) {
                    throw new FormulaFunctionArgumentException("JRC00002330", "", FormulaResources.a(), "BadOrder", stringArray, 0);
                }
            }
            if (formulaValueReferenceArray[4].getFormulaValue() != null && (d10 = ((NumberValue)formulaValueReferenceArray[4].getFormulaValue()).getDouble()) < 0.0) {
                throw new FormulaFunctionArgumentException("JRC00002331", "", FormulaResources.a(), "ArgumentOutOfRange", 4);
            }
            if (formulaValueReferenceArray[5].getFormulaValue() != null && ((d10 = ((NumberValue)formulaValueReferenceArray[5].getFormulaValue()).getDouble()) <= 0.0 || this.getIdentifier() == at.hD && d10 >= 0.5)) {
                throw new FormulaFunctionArgumentException("JRC00002332", "", FormulaResources.a(), "ArgumentOutOfRange", 5);
            }
            if (formulaValueReferenceArray.length == 7 && formulaValueReferenceArray[6].getFormulaValue() != null && ((n2 = ((NumberValue)formulaValueReferenceArray[6].getFormulaValue()).getInt()) < 0 || n2 > 4 || n2 == 2)) {
                throw new FormulaFunctionArgumentException("JRC00002333", "", FormulaResources.a(), "ArgumentOutOfRange", 6);
            }
            return FormulaValueType.currency;
        }

        public FormulaValue evaluate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            this.validate(formulaValueReferenceArray, formulaEnvironment);
            double d10 = ((NumericValue)formulaValueReferenceArray[0].getFormulaValue()).getDouble();
            DateValue dateValue = ((DateTimeValue)formulaValueReferenceArray[1].getFormulaValue()).getDateValue();
            DateValue dateValue2 = ((DateTimeValue)formulaValueReferenceArray[2].getFormulaValue()).getDateValue();
            double d11 = ((NumericValue)formulaValueReferenceArray[3].getFormulaValue()).getDouble();
            double d12 = ((NumberValue)formulaValueReferenceArray[4].getFormulaValue()).getDouble();
            double d13 = ((NumberValue)formulaValueReferenceArray[5].getFormulaValue()).getDouble();
            an an2 = an.do;
            if (formulaValueReferenceArray.length == 7) {
                int n2 = ((NumberValue)formulaValueReferenceArray[6].getFormulaValue()).getInt();
                an2 = an.a(n2);
            }
            double[] dArray = ae.a(dateValue, dateValue2, an2);
            int n3 = (int)dArray[0];
            double d14 = dArray[1];
            if (an2 == an.a) {
                int n4 = dateValue.getYear();
                d14 = DateTimeUtil.NDaysInYear((int)n4);
            }
            if (this.getIdentifier() == at.hC) {
                double d15 = d10 * d13 * (double)n3 / d14;
                if (d12 == 0.0) {
                    return CurrencyValue.fromDouble((double)Math.min(d15, d10 - d11));
                }
                double d16 = d10 * d13;
                double d17 = d10 - d11 - d15 - (d12 - 1.0) * d10 * d13;
                double d18 = Math.max(Math.min(d16, d17), 0.0);
                return CurrencyValue.fromDouble((double)d18);
            }
            double d19 = 1.5;
            double d20 = 2.0;
            double d21 = 2.5;
            double d22 = 0.5;
            double d23 = 1.0;
            double d24 = 1.0 / d13;
            double d25 = d13;
            d25 = d24 <= 4.0 ? 1.5 * d13 : (d24 < 6.0 ? 2.0 * d13 : 2.5 * d13);
            double d26 = Math.min(d10 - d11, d10 * (double)n3 / d14 * d25);
            d26 = NumberUtil.roundFractional((double)d26, (int)2);
            if (d12 >= Math.ceil(d24)) {
                return CurrencyValue.zero;
            }
            if (d12 == 0.0) {
                return CurrencyValue.fromDouble((double)d26);
            }
            double d27 = d10 - (d10 - d26) * Math.pow(1.0 - d25, Math.min(d12 - 1.0, Math.floor(d24) - 2.0));
            if (d12 >= Math.floor(d24) - 1.0) {
                if (d12 >= Math.floor(d24)) {
                    d27 += (d10 - d27) * 0.5;
                    d25 = 1.0;
                } else {
                    d25 = 0.5;
                }
            }
            double d28 = (d10 - d27) * d25;
            d28 = NumberUtil.roundFractional((double)d28, (int)2);
            double d29 = d10 - d11 - d27;
            d29 = NumberUtil.roundFractional((double)d29, (int)2);
            return CurrencyValue.fromDouble((double)Math.max(0.0, Math.min(d28, d29)));
        }
    }
}

