/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.formulas;

import com.crystaldecisions.reports.common.asserts.CrystalAssert;
import com.crystaldecisions.reports.common.value.BooleanValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.formulas.ConditionalNode;
import com.crystaldecisions.reports.formulas.ExpressionNode;
import com.crystaldecisions.reports.formulas.ExpressionNodeType;
import com.crystaldecisions.reports.formulas.FormulaInfo;
import com.crystaldecisions.reports.formulas.ValueNode;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentNode
extends ExpressionNode {
    private final List<ExpressionNode> goto = new ArrayList<ExpressionNode>();
    private boolean else;
    private boolean char = false;

    ParentNode(ParentNode parentNode, boolean bl2) {
        super(parentNode, parentNode.for);
        if (bl2) {
            for (int i2 = 0; i2 < parentNode.size(); ++i2) {
                this.add(parentNode.get(i2));
            }
        }
        this.else = parentNode.else;
    }

    ParentNode(ParentNode parentNode, List<ExpressionNode> list) {
        super(parentNode, parentNode.for);
        this.goto.addAll(list);
        this.do();
    }

    public ParentNode(ExpressionNodeType expressionNodeType, List<ExpressionNode> list) {
        super(expressionNodeType);
        this.goto.addAll(list);
        this.do();
    }

    ParentNode(ParentNode parentNode, ExpressionNode[] expressionNodeArray) {
        super(parentNode, parentNode.for);
        for (ExpressionNode expressionNode : expressionNodeArray) {
            this.goto.add(expressionNode);
        }
        this.do();
    }

    public ParentNode(ExpressionNodeType expressionNodeType, ExpressionNode[] expressionNodeArray) {
        super(expressionNodeType);
        for (ExpressionNode expressionNode : expressionNodeArray) {
            this.goto.add(expressionNode);
        }
        this.do();
    }

    ParentNode(ExpressionNode expressionNode, ExpressionNodeType expressionNodeType) {
        super(expressionNode, expressionNodeType);
    }

    public ParentNode(ExpressionNodeType expressionNodeType) {
        super(expressionNodeType);
    }

    public ParentNode(ExpressionNodeType expressionNodeType, FormulaValueType formulaValueType) {
        super(expressionNodeType);
        this.try = formulaValueType;
    }

    private void new(ExpressionNode expressionNode) {
        if (this.do == expressionNode.do && expressionNode.byte >= 0) {
            this.byte = this.byte == -1 ? expressionNode.byte : Math.min(this.byte, expressionNode.byte);
        }
    }

    private void int(ExpressionNode expressionNode) {
        if (this.do == expressionNode.do && expressionNode.case >= 0) {
            this.case = this.case == -1 ? expressionNode.case : Math.max(this.case, expressionNode.case);
        }
    }

    private void for(ExpressionNode expressionNode) {
        this.new(expressionNode);
        this.int(expressionNode);
    }

    boolean int() {
        return true;
    }

    public void add(ExpressionNode expressionNode) {
        if (!this.int()) {
            throw new IllegalStateException("add is not permitted.");
        }
        if (expressionNode == null) {
            this.goto.add(null);
            return;
        }
        this.for(expressionNode);
        if (!this.else || !expressionNode.isEmptyExpression()) {
            this.goto.add(expressionNode);
            this.try(expressionNode);
        }
    }

    void a(ExpressionNodeType expressionNodeType, ExpressionNode expressionNode) {
        if (expressionNodeType == expressionNode.for && expressionNode.size() > 0) {
            ParentNode parentNode = (ParentNode)expressionNode;
            this.new(parentNode);
            for (int i2 = 0; i2 < parentNode.size(); ++i2) {
                this.add(parentNode.get(i2));
            }
            this.int(parentNode);
        } else {
            this.add(expressionNode);
        }
    }

    ParentNode if() {
        return new ParentNode(this, false);
    }

    ParentNode for() {
        return new ParentNode(this, true);
    }

    public ExpressionNode get(int n2) {
        return this.goto.get(n2);
    }

    public ExpressionNode set(int n2, ExpressionNode expressionNode) {
        if (expressionNode == null) {
            return this.goto.set(n2, null);
        }
        this.for(expressionNode);
        ExpressionNode expressionNode2 = null;
        if (this.else && expressionNode.isEmptyExpression()) {
            expressionNode2 = this.goto.remove(n2);
            if (expressionNode2 != null && expressionNode2.a()) {
                this.do();
            }
        } else {
            expressionNode2 = this.goto.set(n2, expressionNode);
            this.try(expressionNode);
        }
        return expressionNode2;
    }

    public void remove(int n2) {
        ExpressionNode expressionNode = this.goto.remove(n2);
        if (expressionNode != null && expressionNode.a()) {
            this.do();
        }
    }

    public void clear() {
        this.goto.clear();
        this.char = false;
    }

    void a(boolean bl2) {
        this.else = bl2;
    }

    @Override
    public final int size() {
        return this.goto.size();
    }

    @Override
    boolean a(ExpressionNode expressionNode) {
        if (expressionNode == this) {
            return true;
        }
        if (!(expressionNode instanceof ParentNode) || !super.a(expressionNode)) {
            return false;
        }
        ParentNode parentNode = (ParentNode)expressionNode;
        if (this.size() != parentNode.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (ParentNode.isSameExpression(this.get(i2), parentNode.get(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString(String string, String string2) {
        return this.toString(string, "", string2);
    }

    public String toString(String string, String string2, String string3) {
        String string4 = "    " + string;
        String string5 = super.toString(string, string2 + string3);
        for (int i2 = 0; i2 < this.size(); ++i2) {
            string5 = string5 + "\n" + ExpressionNode.toString(this.get(i2), string4, string3);
        }
        return string5;
    }

    @Override
    void a(MessageDigest messageDigest) {
        super.a(messageDigest);
        for (int i2 = 0; i2 < this.size(); ++i2) {
            ExpressionNode.a(this.get(i2), messageDigest);
        }
    }

    @Override
    public String toFormulaText(FormulaInfo.Syntax syntax, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.for.value()) {
            case 116: {
                stringBuilder.append('[');
                for (int i2 = 0; i2 < this.size(); ++i2) {
                    if (i2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(this.get(i2).toFormulaText(syntax, n2));
                }
                stringBuilder.append(']');
                break;
            }
            case 144: {
                for (int i3 = 0; i3 < this.size(); ++i3) {
                    if (i3 > 0) {
                        this.a(n2, stringBuilder);
                        stringBuilder.append("else ");
                    }
                    ExpressionNode expressionNode = this.get(i3);
                    ConditionalNode conditionalNode = null;
                    ExpressionNode expressionNode2 = null;
                    if (i3 == this.size() - 1) {
                        if (expressionNode instanceof ConditionalNode) {
                            FormulaValue formulaValue;
                            conditionalNode = (ConditionalNode)expressionNode;
                            ExpressionNode expressionNode3 = conditionalNode.getCondition();
                            if (expressionNode3 instanceof ValueNode && (formulaValue = ((ValueNode)expressionNode3).getValue()) instanceof BooleanValue && ((BooleanValue)formulaValue).getBoolean()) {
                                expressionNode2 = conditionalNode.getStatement();
                            }
                        } else {
                            expressionNode2 = expressionNode;
                        }
                    } else {
                        conditionalNode = (ConditionalNode)expressionNode;
                    }
                    if (expressionNode2 == null) {
                        stringBuilder.append("if ");
                        stringBuilder.append(conditionalNode.getCondition().toFormulaText(syntax, n2 + (i3 > 0 ? 8 : 3)));
                        this.a(n2, stringBuilder);
                        stringBuilder.append("then ");
                        stringBuilder.append(conditionalNode.getStatement().toFormulaText(syntax, n2 + 5));
                        continue;
                    }
                    stringBuilder.append(expressionNode2.toFormulaText(syntax, n2 + 5));
                }
                break;
            }
            case 147: {
                for (int i4 = 0; i4 < this.size(); ++i4) {
                    ConditionalNode conditionalNode = (ConditionalNode)this.get(i4);
                    stringBuilder.append(conditionalNode.toFormulaText(syntax, n2));
                }
                break;
            }
            default: {
                CrystalAssert.ASSERT((boolean)false);
                stringBuilder.append("?");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    boolean a() {
        return this.char;
    }

    private void do() {
        if (this.goto == null || this.goto.size() == 0) {
            return;
        }
        int n2 = this.goto.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ExpressionNode expressionNode = this.goto.get(i2);
            if (expressionNode == null || !expressionNode.a()) continue;
            this.char = true;
            break;
        }
    }

    private void try(ExpressionNode expressionNode) {
        if (expressionNode != null) {
            this.char |= expressionNode.a();
        }
    }
}

