/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.client.helper;

import com.crystaldecisions.client.helper.SpecialFieldHelper;
import com.crystaldecisions.sdk.occa.report.data.FieldKind;
import com.crystaldecisions.sdk.occa.report.data.FieldValueType;
import com.crystaldecisions.sdk.occa.report.data.IDBField;
import com.crystaldecisions.sdk.occa.report.data.IField;
import com.crystaldecisions.sdk.occa.report.data.IFormulaField;
import com.crystaldecisions.sdk.occa.report.data.IGroup;
import com.crystaldecisions.sdk.occa.report.data.IRunningTotalField;
import com.crystaldecisions.sdk.occa.report.data.ISummaryField;
import com.crystaldecisions.sdk.occa.report.data.ISummaryFieldBase;
import com.crystaldecisions.sdk.occa.report.data.ParameterField;
import com.crystaldecisions.sdk.occa.report.definition.BooleanFieldFormat;
import com.crystaldecisions.sdk.occa.report.definition.CommonFieldFormat;
import com.crystaldecisions.sdk.occa.report.definition.CurrencySymbolType;
import com.crystaldecisions.sdk.occa.report.definition.DateFieldFormat;
import com.crystaldecisions.sdk.occa.report.definition.DateTimeFieldFormat;
import com.crystaldecisions.sdk.occa.report.definition.FieldObject;
import com.crystaldecisions.sdk.occa.report.definition.HPageNumericFieldFormat;
import com.crystaldecisions.sdk.occa.report.definition.IFieldFormat;
import com.crystaldecisions.sdk.occa.report.definition.IFieldObject;
import com.crystaldecisions.sdk.occa.report.definition.NumericFieldFormat;
import com.crystaldecisions.sdk.occa.report.definition.RoundingType;
import com.crystaldecisions.sdk.occa.report.definition.StringFieldFormat;
import com.crystaldecisions.sdk.occa.report.definition.TimeFieldFormat;
import java.util.Date;
import java.util.Locale;

public final class FieldHelper {
    public static final String FormulaFieldPrefix1 = "@";
    public static final String FormulaFieldPrefix2 = "%";
    public static final String RunningTotalFieldPrefix = "#";
    public static final String ParameterFieldPrefix = "?";
    public static final String FormulaFormStartStr = "{";
    public static final String FormulaFormEndStr = "}";
    public static final String SummaryOperationStartStr = "(";
    public static final String SummaryOperationEndStr = ")";

    public static IFieldObject createFieldObject(IField iField) {
        if (iField == null) {
            throw new IllegalArgumentException();
        }
        FieldObject fieldObject = new FieldObject();
        fieldObject.setFieldValueType(iField.getType());
        fieldObject.setDataSourceName(iField.getFormulaForm());
        if ("HPageNumber".equals(iField.getFormulaForm())) {
            fieldObject.getFieldFormat().setNumericFormat(new HPageNumericFieldFormat());
            fieldObject.getFormat().setEnableRepeatOnHorizontalPages(true);
        }
        if (iField.getType() == FieldValueType.persistentMemoField || iField.getType() == FieldValueType.transientMemoField) {
            fieldObject.getFormat().setEnableCanGrow(true);
        }
        return fieldObject;
    }

    public static double getDoubleValueFromObject(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        throw new NumberFormatException();
    }

    public static int getFieldValueSize(FieldValueType fieldValueType) {
        switch (fieldValueType.value()) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: {
                return 4;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 2;
            }
            case 9: 
            case 10: {
                return 4;
            }
            case 15: {
                return 8;
            }
            case 11: {
                return 512;
            }
        }
        return 0;
    }

    public static FieldValueType getFieldValueTypeFromObject(Object object) {
        if (object instanceof Number || object instanceof Double || object instanceof Integer) {
            return FieldValueType.numberField;
        }
        if (object instanceof String) {
            return FieldValueType.stringField;
        }
        if (object instanceof Boolean) {
            return FieldValueType.booleanField;
        }
        if (object instanceof Date) {
            return FieldValueType.dateTimeField;
        }
        return FieldValueType.unknownField;
    }

    public static int getIntValueFromObject(Object object) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        throw new NumberFormatException();
    }

    public static long getLongValueFromObject(Object object) {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            return Long.parseLong((String)object);
        }
        throw new NumberFormatException();
    }

    public static FieldKind guessFieldTypeByFormulaForm(String string) {
        int n2;
        int n3 = n2 = string != null ? string.length() : 0;
        if (n2 > 1 && string.charAt(0) == '{') {
            char c10 = string.charAt(1);
            switch (c10) {
                case '%': 
                case '@': {
                    return FieldKind.formulaField;
                }
                case '#': {
                    return FieldKind.runningTotalField;
                }
                case '?': {
                    return FieldKind.parameterField;
                }
            }
            return FieldKind.DBField;
        }
        if (n2 > 0) {
            if (string.startsWith("GroupName")) {
                return FieldKind.groupNameField;
            }
            if (SpecialFieldHelper.isSpecialField(string)) {
                return FieldKind.specialField;
            }
            int n4 = string.indexOf(40);
            int n5 = string.indexOf(41);
            if (n4 != -1 && n5 > n4) {
                return FieldKind.summaryField;
            }
        }
        return FieldKind.unknownField;
    }

    public static boolean isDateTimeType(FieldValueType fieldValueType) {
        switch (fieldValueType.value()) {
            case 9: 
            case 10: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumericType(FieldValueType fieldValueType) {
        switch (fieldValueType.value()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public static boolean hasCountingOperation(ISummaryFieldBase iSummaryFieldBase) {
        assert (iSummaryFieldBase != null);
        assert (iSummaryFieldBase.getOperation() != null);
        switch (iSummaryFieldBase.getOperation().value()) {
            case 6: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPrimitiveType(FieldValueType fieldValueType) {
        switch (fieldValueType.value()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    public static boolean isValueTypeCompatible(FieldValueType fieldValueType, FieldValueType fieldValueType2) {
        if (FieldHelper.isNumericType(fieldValueType)) {
            return FieldHelper.isNumericType(fieldValueType2);
        }
        if (FieldHelper.isDateTimeType(fieldValueType)) {
            return FieldHelper.isDateTimeType(fieldValueType2);
        }
        return fieldValueType.value() == fieldValueType2.value();
    }

    public static boolean isValueTypeConvertible(FieldValueType fieldValueType, Object object) {
        FieldValueType fieldValueType2 = FieldHelper.getFieldValueTypeFromObject(object);
        if (FieldHelper.isNumericType(fieldValueType)) {
            if (FieldHelper.isNumericType(fieldValueType2)) {
                return true;
            }
            if (fieldValueType2 == FieldValueType.stringField) {
                try {
                    Double.parseDouble((String)object);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        }
        if (fieldValueType == FieldValueType.stringField) {
            return FieldHelper.isNumericType(fieldValueType2) || fieldValueType2 == FieldValueType.stringField;
        }
        if (FieldHelper.isDateTimeType(fieldValueType)) {
            return FieldHelper.isDateTimeType(fieldValueType2);
        }
        return fieldValueType.value() == fieldValueType2.value();
    }

    public static boolean canGroupOn(IField iField) {
        if (iField == null) {
            return false;
        }
        if (iField instanceof IDBField) {
            IDBField iDBField = (IDBField)iField;
            return FieldHelper.isPrimitiveType(iDBField.getType());
        }
        if (iField instanceof IFormulaField) {
            IFormulaField iFormulaField = (IFormulaField)iField;
            return iFormulaField.getIsRecurring();
        }
        return false;
    }

    public static final String makeParameterFieldFormulaFormByName(String string) {
        String string2 = null;
        if (string != null) {
            ParameterField parameterField = new ParameterField();
            parameterField.setName(string);
            string2 = parameterField.getFormulaForm();
        }
        return string2;
    }

    public static boolean isSameSummary(ISummaryFieldBase iSummaryFieldBase, ISummaryFieldBase iSummaryFieldBase2) {
        if (iSummaryFieldBase instanceof IRunningTotalField && iSummaryFieldBase2 instanceof IRunningTotalField) {
            return iSummaryFieldBase.getName().equalsIgnoreCase(iSummaryFieldBase2.getName());
        }
        if (iSummaryFieldBase instanceof ISummaryField && iSummaryFieldBase2 instanceof ISummaryField) {
            ISummaryField iSummaryField = (ISummaryField)iSummaryFieldBase;
            ISummaryField iSummaryField2 = (ISummaryField)iSummaryFieldBase2;
            IGroup iGroup = iSummaryField.getGroup();
            iSummaryField.setGroup(iSummaryField2.getGroup());
            boolean bl2 = iSummaryFieldBase.getFormulaForm().equalsIgnoreCase(iSummaryFieldBase2.getFormulaForm());
            iSummaryField.setGroup(iGroup);
            return bl2;
        }
        return false;
    }

    public static void updateFieldFormatWithFieldValueType(IFieldFormat iFieldFormat, FieldValueType fieldValueType, Locale locale) {
        assert (iFieldFormat != null);
        if (iFieldFormat == null) {
            return;
        }
        if (iFieldFormat.getCommonFormat() == null) {
            iFieldFormat.setCommonFormat(new CommonFieldFormat());
        }
        switch (fieldValueType.value()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                if (iFieldFormat.getNumericFormat() != null) break;
                iFieldFormat.setNumericFormat(new NumericFieldFormat(locale));
                if (fieldValueType == FieldValueType.currencyField) {
                    iFieldFormat.getNumericFormat().setCurrencySymbolFormat(CurrencySymbolType.fixedSymbol);
                }
                if (fieldValueType != FieldValueType.numberField && fieldValueType != FieldValueType.currencyField) {
                    iFieldFormat.getNumericFormat().setNDecimalPlaces(0);
                    iFieldFormat.getNumericFormat().setRoundingFormat(RoundingType.roundToUnit);
                    break;
                }
                iFieldFormat.getNumericFormat().setNDecimalPlaces(2);
                iFieldFormat.getNumericFormat().setRoundingFormat(RoundingType.roundToHundredth);
                break;
            }
            case 8: {
                if (iFieldFormat.getBooleanFormat() != null) break;
                iFieldFormat.setBooleanFormat(new BooleanFieldFormat());
                break;
            }
            case 9: {
                if (iFieldFormat.getDateFormat() != null) break;
                iFieldFormat.setDateFormat(new DateFieldFormat(locale));
                break;
            }
            case 10: {
                if (iFieldFormat.getTimeFormat() != null) break;
                iFieldFormat.setTimeFormat(new TimeFieldFormat(locale));
                break;
            }
            case 15: {
                if (iFieldFormat.getTimeFormat() == null) {
                    iFieldFormat.setTimeFormat(new TimeFieldFormat(locale));
                }
                if (iFieldFormat.getDateFormat() == null) {
                    iFieldFormat.setDateFormat(new DateFieldFormat(locale));
                }
                if (iFieldFormat.getDateTimeFormat() != null) break;
                iFieldFormat.setDateTimeFormat(new DateTimeFieldFormat(locale));
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                if (iFieldFormat.getStringFormat() != null) break;
                iFieldFormat.setStringFormat(new StringFieldFormat());
            }
        }
    }
}

