/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.Utilities;

import com.crystaldecisions.Utilities.LittleEndianDataInput;
import com.crystaldecisions.Utilities.StreamRandomAccess;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;

public class LittleEndianDataInputStream
implements LittleEndianDataInput,
DataInput,
StreamRandomAccess {
    protected DataInput in;
    protected int curByteN;

    public LittleEndianDataInputStream(DataInput dataInput) {
        this.in = dataInput;
    }

    public void close() throws IOException {
        if (this.in instanceof DataInputStream) {
            ((DataInputStream)this.in).close();
        }
    }

    public long readInt64s() throws IOException {
        long l2 = this.readInt32u();
        return ((long)this.readInt32s() << 32) + l2;
    }

    public long readInt32u() throws IOException {
        long l2 = this.readInt16u();
        return ((long)this.readInt16u() << 16) + l2;
    }

    public int readInt32s() throws IOException {
        int n2 = this.readInt16u();
        return (this.readInt16s() << 16) + n2;
    }

    public int readInt16u() throws IOException {
        int n2 = this.readInt8u();
        return (this.readInt8u() << 8) + n2;
    }

    public int readInt16s() throws IOException {
        int n2 = this.readInt8u();
        return (this.readInt8s() << 8) + n2;
    }

    public int readInt8u() throws IOException {
        int n2 = this.in.readUnsignedByte();
        ++this.curByteN;
        return n2;
    }

    public int readInt8s() throws IOException {
        byte by2 = this.in.readByte();
        ++this.curByteN;
        return by2;
    }

    public boolean readBoolean() throws IOException {
        throw new IOException("LittleEndianDataInputStream: 'readBoolean' not implemented.");
    }

    public byte readByte() throws IOException {
        return (byte)this.readInt8s();
    }

    public char readChar() throws IOException {
        return (char)this.readInt16u();
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readInt64s());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt32s());
    }

    public void readFully(byte[] byArray) throws IOException {
        this.in.readFully(byArray);
        this.curByteN += byArray.length;
    }

    public void readFully(byte[] byArray, int n2, int n3) throws IOException {
        this.in.readFully(byArray, n2, n3);
        this.curByteN += n3;
    }

    public int readInt() throws IOException {
        return this.readInt32s();
    }

    public String readLine() throws IOException {
        throw new IOException("LittleEndianDataInputStream: 'readLine' not implemented.");
    }

    public long readLong() throws IOException {
        return this.readInt64s();
    }

    public short readShort() throws IOException {
        return (short)this.readInt16s();
    }

    public int readUnsignedByte() throws IOException {
        return this.readInt8u();
    }

    public int readUnsignedShort() throws IOException {
        return this.readInt16s();
    }

    public String readUTF() throws IOException {
        throw new IOException("LittleEndianDataInputStream: 'readUTF' not implemented.");
    }

    public int skipBytes(int n2) throws IOException {
        n2 = this.in.skipBytes(n2);
        this.curByteN += n2;
        return n2;
    }

    public int getCurByteN() {
        return this.curByteN;
    }

    public void seek(int n2) throws IOException {
        int n3;
        if (n2 == this.curByteN) {
            return;
        }
        if (n2 < this.curByteN) {
            throw new IOException("LittleEndianDataInputStream: 'seek' cannot go backwards.");
        }
        for (int i2 = n2 - this.curByteN; i2 > 0; i2 -= n3) {
            n3 = this.skipBytes(i2);
            if (n3 > 0) continue;
            throw new IOException("LittleEndianDataInputStream: 'seek' cannot go beyond end of file.");
        }
    }
}

