/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.report.tslvreader;

import com.crystaldecisions.DIBitmap.DeviceIndependentBitmap;
import com.crystaldecisions.MetafileRenderer.Metafile;
import com.crystaldecisions.Utilities.LengthLimitedDataInputStream;
import com.crystaldecisions.report.tslvreader.TSLVHeaderData;
import com.crystaldecisions.sdk.occa.report.formatteddefinition.lib.UTFDecoder;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TSLVReader {
    private DataInputStream for = null;
    private int int = 0;
    private boolean if;
    boolean do;
    private static final int a = -1;

    public void initRead(DataInputStream dataInputStream) {
        this.for = dataInputStream;
    }

    public int read16_32(boolean[] blArray) {
        blArray[0] = false;
        try {
            int n2 = this.readUInt16(blArray);
            if (blArray[0]) {
                return 0;
            }
            if ((n2 & 0x8000) != 0) {
                n2 = ((n2 & Short.MAX_VALUE) << 16) + this.readUInt16(blArray);
            }
            return n2;
        }
        catch (Exception exception) {
            blArray[0] = true;
            return 0;
        }
    }

    public short read8_16(boolean[] blArray) {
        blArray[0] = false;
        try {
            int n2 = this.readByte(blArray);
            if (blArray[0]) {
                return 0;
            }
            if ((n2 & 0x80) != 0) {
                n2 = ((n2 & 0x7F) << 8) + this.readByte(blArray);
            }
            return (short)n2;
        }
        catch (Exception exception) {
            blArray[0] = true;
            return 0;
        }
    }

    public int readByte(boolean[] blArray) {
        blArray[0] = false;
        int n2 = 0;
        try {
            n2 = this.for.readUnsignedByte();
            --this.int;
        }
        catch (Exception exception) {
            blArray[0] = true;
        }
        return n2;
    }

    public int readColor(boolean[] blArray) {
        blArray[0] = false;
        try {
            int n2 = this.readByte(blArray);
            if (blArray[0]) {
                return -1;
            }
            int n3 = this.readByte(blArray);
            if (blArray[0]) {
                return -1;
            }
            int n4 = this.readByte(blArray);
            if (blArray[0]) {
                return -1;
            }
            int n5 = this.readByte(blArray);
            if (blArray[0]) {
                return -1;
            }
            if (n2 == 0) {
                return (n5 << 16) + (n4 << 8) + n3;
            }
        }
        catch (Exception exception) {
            blArray[0] = true;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceIndependentBitmap readDIB(boolean[] blArray) {
        blArray[0] = false;
        DeviceIndependentBitmap deviceIndependentBitmap = null;
        LengthLimitedDataInputStream lengthLimitedDataInputStream = new LengthLimitedDataInputStream((DataInput)this.for, this.int);
        try {
            deviceIndependentBitmap = new DeviceIndependentBitmap((DataInput)lengthLimitedDataInputStream);
        }
        catch (EOFException eOFException) {
            deviceIndependentBitmap = null;
        }
        catch (Exception exception) {
            blArray[0] = true;
        }
        finally {
            try {
                lengthLimitedDataInputStream.seekToEnd();
                this.int = 0;
            }
            catch (IOException iOException) {}
        }
        return deviceIndependentBitmap;
    }

    public double readDouble(boolean[] blArray) {
        blArray[0] = false;
        double d2 = 0.0;
        try {
            d2 = this.for.readDouble();
            this.int -= 8;
        }
        catch (Exception exception) {
            blArray[0] = true;
        }
        return d2;
    }

    public void readFully(boolean[] blArray, byte[] byArray, int n2, int n3) {
        blArray[0] = false;
        try {
            this.for.readFully(byArray, n2, n3);
            this.int -= n3;
        }
        catch (Exception exception) {
            blArray[0] = true;
        }
    }

    public TSLVHeaderData readHeader(boolean[] blArray, DataInputStream dataInputStream) throws IOException {
        int n2;
        boolean bl2;
        int n3;
        blArray[0] = false;
        TSLVHeaderData tSLVHeaderData = new TSLVHeaderData(0, 0, 0, 0);
        if (this.int < 0) {
            blArray[0] = true;
            return tSLVHeaderData;
        }
        try {
            n3 = dataInputStream.readUnsignedShort();
        }
        catch (EOFException eOFException) {
            blArray[0] = true;
            return tSLVHeaderData;
        }
        tSLVHeaderData.recordType = (short)n3;
        int n4 = (tSLVHeaderData.recordType & 0xC000) >> 14;
        boolean bl3 = (tSLVHeaderData.recordType & 0x2000) != 0;
        this.if = (tSLVHeaderData.recordType & 0x1000) != 0;
        this.do = (tSLVHeaderData.recordType & 0x800) != 0;
        boolean bl4 = bl2 = (tSLVHeaderData.recordType & 0x400) != 0;
        if (bl2) {
            tSLVHeaderData.recordType = (short)dataInputStream.readUnsignedShort();
            tSLVHeaderData.headerLength += 2;
        } else {
            tSLVHeaderData.recordType = (short)(tSLVHeaderData.recordType & 0x3FF);
        }
        tSLVHeaderData.headerLength = 2;
        if (bl3) {
            n2 = dataInputStream.readUnsignedShort();
            tSLVHeaderData.schema = (short)n2;
            if (blArray[0]) {
                return tSLVHeaderData;
            }
            tSLVHeaderData.headerLength += 2;
        } else {
            tSLVHeaderData.schema = (short)1360;
        }
        tSLVHeaderData.byteValueLength = 0;
        n2 = 0;
        switch (n4) {
            case 0: {
                n2 = 0;
                tSLVHeaderData.byteValueLength = 0;
                break;
            }
            case 1: {
                try {
                    n2 = dataInputStream.readUnsignedByte();
                }
                catch (EOFException eOFException) {
                    blArray[0] = true;
                    return tSLVHeaderData;
                }
                ++tSLVHeaderData.headerLength;
                tSLVHeaderData.byteValueLength = n2;
                break;
            }
            case 2: {
                try {
                    n2 = dataInputStream.readUnsignedShort();
                }
                catch (EOFException eOFException) {
                    blArray[0] = true;
                    return tSLVHeaderData;
                }
                tSLVHeaderData.headerLength += 2;
                tSLVHeaderData.byteValueLength = n2;
                break;
            }
            case 3: {
                try {
                    n2 = dataInputStream.readInt();
                }
                catch (EOFException eOFException) {
                    blArray[0] = true;
                    return tSLVHeaderData;
                }
                tSLVHeaderData.headerLength += 4;
                tSLVHeaderData.byteValueLength = n2;
            }
        }
        return tSLVHeaderData;
    }

    public short readInt16(boolean[] blArray) {
        blArray[0] = false;
        short s2 = 0;
        try {
            s2 = this.for.readShort();
            this.int -= 2;
        }
        catch (Exception exception) {
            blArray[0] = true;
        }
        return s2;
    }

    public int readInt32(boolean[] blArray) {
        blArray[0] = false;
        int n2 = 0;
        try {
            n2 = this.for.readInt();
            this.int -= 4;
        }
        catch (Exception exception) {
            blArray[0] = true;
        }
        return n2;
    }

    public long readInt64(boolean[] blArray) {
        blArray[0] = false;
        long l2 = 0L;
        try {
            l2 = this.for.readLong();
            this.int -= 8;
        }
        catch (Exception exception) {
            blArray[0] = true;
        }
        return l2;
    }

    public int readLEInt(boolean[] blArray) {
        blArray[0] = false;
        short s2 = this.readLEShort(blArray);
        short s3 = this.readLEShort(blArray);
        return (s3 << 16) + s2;
    }

    public short readLEShort(boolean[] blArray) {
        blArray[0] = false;
        int n2 = this.readByte(blArray);
        int n3 = this.readByte(blArray);
        int n4 = (n3 << 8) + n2;
        return (short)n4;
    }

    public Metafile readMetafile(boolean[] blArray) {
        blArray[0] = false;
        Metafile metafile = null;
        try {
            metafile = new Metafile(this.readRemainingBytes(blArray));
        }
        catch (EOFException eOFException) {
            metafile = null;
        }
        catch (Exception exception) {
            blArray[0] = true;
        }
        return metafile;
    }

    public TSLVHeaderData readNestedHeader(boolean[] blArray) throws IOException {
        blArray[0] = false;
        TSLVHeaderData tSLVHeaderData = this.readHeader(blArray, this.for);
        this.int -= tSLVHeaderData.headerLength;
        return tSLVHeaderData;
    }

    public TSLVHeaderData readRecord(boolean[] blArray) throws IOException {
        blArray[0] = false;
        if (this.int > 0) {
            this.for.skipBytes(this.int);
            this.int = 0;
        }
        TSLVHeaderData tSLVHeaderData = this.readHeader(blArray, this.for);
        this.int = tSLVHeaderData.byteValueLength;
        if (this.int == 0) {
            this.if = false;
        }
        return tSLVHeaderData;
    }

    public int readSignedByte(boolean[] blArray) {
        blArray[0] = false;
        byte by = 0;
        try {
            by = this.for.readByte();
            --this.int;
        }
        catch (Exception exception) {
            blArray[0] = true;
        }
        return by;
    }

    public int readUInt16(boolean[] blArray) {
        blArray[0] = false;
        int n2 = 0;
        try {
            n2 = this.for.readUnsignedShort();
            this.int -= 2;
        }
        catch (Exception exception) {
            blArray[0] = true;
        }
        return n2;
    }

    public String readUTF8String(boolean[] blArray) {
        int n2;
        blArray[0] = false;
        if (this.if) {
            int n3 = this.readInt32(blArray);
            if (blArray[0]) {
                return null;
            }
            if (n3 == 0) {
                return null;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = this.readByte(blArray)) != 0) {
            stringBuffer.append((char)n2);
        }
        return UTFDecoder.utfDecode(stringBuffer.toString());
    }

    public int unreadBytesForCurRec() {
        return this.int;
    }

    public byte[] readRemainingBytes(boolean[] blArray) {
        byte[] byArray = new byte[this.int];
        this.readFully(blArray, byArray, 0, this.int);
        return byArray;
    }
}

