/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.report.web.shared;

import com.businessobjects.report.web.json.JSONObject;
import com.businessobjects.report.web.shared.DateFormatter;
import com.businessobjects.report.web.shared.PromptDateFormat;
import com.businessobjects.report.web.shared.PromptDateMatcher;
import com.crystaldecisions.client.helper.LocaleID;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class PromptDateHelper {
    public static final String KEY_DATE = "d";
    public static final String KEY_MONTH = "m";
    public static final String KEY_YEAR = "y";
    public static final String KEY_HOURS = "h";
    public static final String KEY_MINUTES = "min";
    public static final String KEY_SECONDS = "s";
    public static final String KEY_MILLISECONDS = "ms";

    public static Date getDate(String string, Locale locale) {
        Date date = null;
        if (string != null) {
            PromptDateMatcher promptDateMatcher = null;
            promptDateMatcher = string.trim().toUpperCase(locale).startsWith("DATE") ? new PromptDateMatcher(PromptDateFormat.Crystal) : new PromptDateMatcher(PromptDateHelper.a(locale));
            promptDateMatcher.find(string);
            date = promptDateMatcher.getDate();
        }
        return date;
    }

    public static String getFormattedDate(Date date, Locale locale) {
        String string = null;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            PromptDateFormat promptDateFormat = PromptDateHelper.a(locale);
            if (promptDateFormat != null) {
                try {
                    string = DateFormatter.formatStringDate(date, promptDateFormat.toString());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    public static String getDateFormat(Locale locale) {
        return PromptDateHelper.a(locale).toString();
    }

    public static String getTimeFormat() {
        return "HH:mm:ss";
    }

    public static String getDateTimeFormat(Locale locale) {
        return PromptDateHelper.getDateFormat(locale) + " " + PromptDateHelper.getTimeFormat();
    }

    static PromptDateFormat a(Locale locale) {
        LocaleID localeID = new LocaleID(locale);
        switch (localeID.value()) {
            case 1033: 
            case 6154: 
            case 9225: 
            case 12297: 
            case 13321: {
                return PromptDateFormat.MDYSlash;
            }
            case 1043: 
            case 2070: 
            case 13322: {
                return PromptDateFormat.DMYDash;
            }
            case 1029: 
            case 1031: 
            case 1035: 
            case 1049: 
            case 1051: 
            case 2055: 
            case 2064: 
            case 2077: 
            case 3079: 
            case 4103: 
            case 4108: 
            case 5127: {
                return PromptDateFormat.DMYPeriod;
            }
            case 1034: 
            case 1036: 
            case 1040: 
            case 1046: 
            case 2057: 
            case 2058: 
            case 2060: 
            case 2067: 
            case 3076: 
            case 3081: 
            case 3082: 
            case 4100: 
            case 4105: 
            case 4106: 
            case 5124: 
            case 5129: 
            case 5130: 
            case 5132: 
            case 6153: 
            case 6156: 
            case 7178: 
            case 8201: 
            case 8202: 
            case 9226: 
            case 10249: 
            case 10250: 
            case 11273: 
            case 11274: 
            case 12298: 
            case 14346: 
            case 15370: 
            case 16394: 
            case 17418: 
            case 18442: 
            case 19466: 
            case 20490: {
                return PromptDateFormat.DMYSlash;
            }
            case 1028: 
            case 1041: 
            case 7177: {
                return PromptDateFormat.YMDSlash;
            }
            case 1038: {
                return PromptDateFormat.YMDPeriod;
            }
        }
        return PromptDateFormat.YMDDash;
    }

    public static JSONObject getJsonFromDate(Date date) {
        JSONObject jSONObject = null;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime(date);
            jSONObject = new JSONObject();
            jSONObject.put(KEY_DATE, new Integer(calendar.get(5)));
            jSONObject.put(KEY_MONTH, new Integer(calendar.get(2)));
            jSONObject.put(KEY_YEAR, new Integer(calendar.get(1)));
            jSONObject.put(KEY_HOURS, new Integer(calendar.get(11)));
            jSONObject.put(KEY_MINUTES, new Integer(calendar.get(12)));
            jSONObject.put(KEY_SECONDS, new Integer(calendar.get(13)));
            jSONObject.put(KEY_MILLISECONDS, new Integer(calendar.get(14)));
        }
        return jSONObject;
    }

    public static Date getTimeFromJson(JSONObject jSONObject) {
        Date date = null;
        if (jSONObject != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(11, PromptDateHelper.a(jSONObject.get(KEY_HOURS)));
            calendar.set(12, PromptDateHelper.a(jSONObject.get(KEY_MINUTES)));
            calendar.set(13, PromptDateHelper.a(jSONObject.get(KEY_SECONDS)));
            calendar.set(14, PromptDateHelper.a(jSONObject.get(KEY_MILLISECONDS)));
            date = calendar.getTime();
        }
        return date;
    }

    public static Date getDateFromJson(JSONObject jSONObject) {
        Date date = null;
        if (jSONObject != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(5, PromptDateHelper.a(jSONObject.get(KEY_DATE)));
            calendar.set(2, PromptDateHelper.a(jSONObject.get(KEY_MONTH)));
            calendar.set(1, PromptDateHelper.a(jSONObject.get(KEY_YEAR)));
            calendar.set(11, PromptDateHelper.a(jSONObject.get(KEY_HOURS)));
            calendar.set(12, PromptDateHelper.a(jSONObject.get(KEY_MINUTES)));
            calendar.set(13, PromptDateHelper.a(jSONObject.get(KEY_SECONDS)));
            calendar.set(14, PromptDateHelper.a(jSONObject.get(KEY_MILLISECONDS)));
            date = calendar.getTime();
        }
        return date;
    }

    private static int a(Object object) {
        int n2 = 0;
        if (object instanceof Number) {
            n2 = ((Number)object).intValue();
        }
        return n2;
    }
}

