/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ArrayDescriptor;
import oracle.sql.AttributeDescriptor;
import oracle.sql.Datum;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.OracleJdbc2SQLInput;
import oracle.sql.OracleSQLOutput;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.TypeDescriptor;

public class StructDescriptor
extends TypeDescriptor
implements OracleTypeMetaData.Struct,
Serializable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructDescriptor createDescriptor(String name, Connection conn) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StructDescriptor __result__ = StructDescriptor.createDescriptor(name, conn, false, false);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StructDescriptor structDescriptor = __result__;
            return structDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructDescriptor createDescriptor(String name, Connection conn, boolean recurse, boolean force) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn) + ", " + OracleLog.argument(recurse) + ", " + OracleLog.argument(force));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (name == null || name.length() == 0 || conn == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructDescriptor.logger().log(OracleLog.INTERNAL_ERROR, "        Internal Error: 60Invalid arguments");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 60, "Invalid arguments");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            SQLName sqlName = new SQLName(name, (oracle.jdbc.OracleConnection)conn);
            StructDescriptor sd = StructDescriptor.createDescriptor(sqlName, conn, recurse, force);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Return: " + sd);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StructDescriptor structDescriptor = sd;
            return structDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructDescriptor createDescriptor(SQLName sqlName, Connection conn, boolean recurse, boolean force) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(sqlName) + ", " + OracleLog.argument(conn) + ", " + OracleLog.argument(recurse) + ", " + OracleLog.argument(force));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String qualifiedName = sqlName.getName();
            StructDescriptor descriptor = null;
            if (!force && (descriptor = (StructDescriptor)((oracle.jdbc.OracleConnection)conn).getDescriptor(qualifiedName)) == null) {
                descriptor = new StructDescriptor(sqlName, conn);
                if (recurse) {
                    descriptor.initNamesRecursively();
                }
                ((oracle.jdbc.OracleConnection)conn).putDescriptor(qualifiedName, descriptor);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Return: " + descriptor);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StructDescriptor structDescriptor = descriptor;
            return structDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructDescriptor createDescriptor(SQLName name, Connection conn) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StructDescriptor __result__ = StructDescriptor.createDescriptor(name, conn, false, false);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StructDescriptor structDescriptor = __result__;
            return structDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructDescriptor createDescriptor(OracleTypeADT otype) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(otype));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String fullName = otype.getFullName();
            OracleConnection conn = otype.getConnection();
            StructDescriptor descriptor = (StructDescriptor)conn.getDescriptor(fullName);
            if (descriptor == null) {
                SQLName sqlName = new SQLName(otype.getSchemaName(), otype.getSimpleName(), otype.getConnection());
                descriptor = new StructDescriptor(sqlName, otype, (Connection)conn);
                conn.putDescriptor(fullName, (Object)descriptor);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Return: " + descriptor);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StructDescriptor structDescriptor = descriptor;
            return structDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructDescriptor createDescriptor(SQLName sqlName, byte[] typoid, int version, byte[] tds, OracleConnection conn) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(sqlName) + ", " + OracleLog.argument(typoid) + ", " + OracleLog.argument(version) + ", " + OracleLog.argument(tds) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleTypeADT pickler = new OracleTypeADT(sqlName, typoid, version, tds, conn);
            StructDescriptor __result__ = new StructDescriptor(sqlName, pickler, (Connection)conn);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StructDescriptor structDescriptor = __result__;
            return structDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructDescriptor(OracleTypeADT type, Connection conn) throws SQLException {
        block12: {
            super((short)108, type, conn);
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructDescriptor(String name, Connection conn) throws SQLException {
        super((short)108, name, conn);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.initPickler();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructDescriptor(SQLName name, Connection conn) throws SQLException {
        super((short)108, name, conn);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.initPickler();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructDescriptor(SQLName name, OracleTypeADT type, Connection conn) throws SQLException {
        super((short)108, name, type, conn);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.toid = type.getTOID();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StructDescriptor(byte[] _toid, int _toidVersion, Connection conn) throws SQLException {
        super((short)108);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_toid) + ", " + OracleLog.argument(_toidVersion) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.toid = _toid;
            this.toidVersion = _toidVersion;
            this.setPhysicalConnectionOf(conn);
            this.initPickler();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StructDescriptor(AttributeDescriptor[] _ados, Connection conn) throws SQLException {
        super((short)108);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_ados) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attributesDescriptor = _ados;
            this.setPhysicalConnectionOf(conn);
            this.isTransient = true;
            this.initPickler();
            this.isInstanciable = Boolean.TRUE;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPickler() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                if (this.isTransient) {
                    this.pickler = new OracleTypeADT(this.attributesDescriptor, this.connection);
                } else {
                    this.pickler = new OracleTypeADT(this.getName(), (Connection)this.connection);
                    ((OracleTypeADT)this.pickler).init(this.connection);
                    this.toid = ((OracleTypeADT)this.pickler).getTOID();
                }
                this.pickler.setDescriptor(this);
            }
            catch (Exception e2) {
                if (e2 instanceof SQLException) {
                    throw (SQLException)e2;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 60 + "Unable to resolve type \"" + this.getName() + "\"");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"" + this.getName() + "\"");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleTypeMetaData.Kind getKind() {
        OracleTypeMetaData.Kind kind;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)OracleTypeMetaData.Kind.STRUCT));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            kind = OracleTypeMetaData.Kind.STRUCT;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return kind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTypeCode() throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int typeCode = this.getOracleTypeADT().getTypeCode();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + typeCode);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = typeCode;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTypeVersion() throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int typeVersion = this.getOracleTypeADT().getTypeVersion();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + typeVersion);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = typeVersion;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttributesDescriptor(AttributeDescriptor[] _attributesDescriptor) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_attributesDescriptor));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attributesDescriptor = _attributesDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeDescriptor[] getAttributesDescriptor() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.attributesDescriptor);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            AttributeDescriptor[] attributeDescriptorArray = this.attributesDescriptor;
            return attributeDescriptorArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] toBytes(STRUCT s2, boolean keepLocalCopy) throws SQLException {
        try {
            byte[] bytes;
            block32: {
                block30: {
                    block31: {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(s2) + ", " + OracleLog.argument(keepLocalCopy));
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if ((bytes = s2.shareBytes()) != null) break block30;
                        if (s2.datumArray == null) break block31;
                        bytes = this.pickler.linearize(s2);
                        if (!keepLocalCopy) {
                            s2.setShareBytes(null);
                        }
                        break block32;
                    }
                    if (s2.objectArray != null) {
                        s2.datumArray = this.toOracleArray(s2.objectArray);
                        bytes = this.pickler.linearize(s2);
                        if (!keepLocalCopy) {
                            s2.datumArray = null;
                            s2.setShareBytes(null);
                        }
                        break block32;
                    } else {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                StructDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
                if (s2.imageLength != 0L && (s2.imageOffset != 0L || s2.imageLength != (long)bytes.length)) {
                    byte[] image = new byte[(int)s2.imageLength];
                    System.arraycopy(bytes, (int)s2.imageOffset, image, 0, (int)s2.imageLength);
                    s2.setImage(image, 0L, 0L);
                    bytes = image;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bytes);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Datum[] toOracleArray(STRUCT s2, boolean keepLocalCopy) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(s2) + ", " + OracleLog.argument(keepLocalCopy));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datumArray = s2.datumArray;
            Datum[] ret = null;
            if (datumArray == null) {
                if (s2.objectArray != null) {
                    datumArray = this.toOracleArray(s2.objectArray);
                } else if (s2.shareBytes() != null) {
                    if ((s2.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.pickler).isEmbeddedADT()) {
                        this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
                    }
                    this.pickler.unlinearize(s2.shareBytes(), s2.imageOffset, s2, 1, null);
                    datumArray = s2.datumArray;
                    if (!keepLocalCopy) {
                        s2.datumArray = null;
                    }
                } else {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (keepLocalCopy) {
                s2.datumArray = datumArray;
                ret = (Datum[])datumArray.clone();
            } else {
                ret = datumArray;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datumArray2 = ret;
            return datumArray2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object[] toArray(STRUCT s2, Map map, boolean saveLocalCopy) throws SQLException {
        try {
            Object[] objArray;
            block32: {
                block31: {
                    block29: {
                        block30: {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(s2) + ", " + OracleLog.argument(map) + ", " + OracleLog.argument(saveLocalCopy));
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            objArray = null;
                            if (s2.objectArray != null) break block29;
                            if (s2.datumArray == null) break block30;
                            objArray = new Object[s2.datumArray.length];
                            break block31;
                        }
                        if (s2.shareBytes() != null) {
                            if ((s2.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.pickler).isEmbeddedADT()) {
                                this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
                            }
                            this.pickler.unlinearize(s2.shareBytes(), s2.imageOffset, s2, 2, map);
                            objArray = s2.objectArray;
                            s2.objectArray = null;
                            break block32;
                        } else {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    StructDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                    }
                    objArray = (Object[])s2.objectArray.clone();
                    break block32;
                }
                for (int i2 = 0; i2 < s2.datumArray.length; ++i2) {
                    if (s2.datumArray[i2] == null) continue;
                    objArray[i2] = s2.datumArray[i2] instanceof STRUCT ? ((STRUCT)s2.datumArray[i2]).toJdbc(map) : s2.datumArray[i2].toJdbc();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + objArray);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object[] objectArray = objArray;
            return objectArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int __result__ = this.getFieldTypes().length;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleTypeADT getOracleTypeADT() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.pickler == null) {
                this.initPickler();
            }
            OracleTypeADT ret = (OracleTypeADT)this.pickler;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleTypeADT oracleTypeADT = ret;
            return oracleTypeADT;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OracleType[] getFieldTypes() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleType[] __result__ = ((OracleTypeADT)this.pickler).getAttrTypes();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleType[] oracleTypeArray = __result__;
            return oracleTypeArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLInput toJdbc2SQLInput(STRUCT s2, Map map) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(s2) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleJdbc2SQLInput __result__ = new OracleJdbc2SQLInput(this.toOracleArray(s2, false), map, this.connection);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleJdbc2SQLInput oracleJdbc2SQLInput = __result__;
            return oracleJdbc2SQLInput;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLOutput toJdbc2SQLOutput() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleSQLOutput __result__ = new OracleSQLOutput(this, this.connection);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleSQLOutput oracleSQLOutput = __result__;
            return oracleSQLOutput;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum[] toOracleArray(Object[] attributes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(attributes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datum = null;
            if (attributes != null) {
                OracleType[] oracleTypes = this.getFieldTypes();
                int oracleTypesLen = oracleTypes.length;
                if (attributes.length != oracleTypesLen) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 49 + null);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, null);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                datum = new Datum[oracleTypesLen];
                OracleConnection iconn = this.connection;
                for (int i2 = 0; i2 < oracleTypesLen; ++i2) {
                    datum[i2] = oracleTypes[i2].toDatum(attributes[i2], iconn);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + datum);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datumArray = datum;
            return datumArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum[] toOracleArray(Map attributes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(attributes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datum = null;
            int nonNullAttrCount = 0;
            if (attributes != null) {
                OracleType[] oracleTypes = this.getFieldTypes();
                int oracleTypesLen = oracleTypes.length;
                int attributesSize = attributes.size();
                datum = new Datum[oracleTypesLen];
                OracleConnection iconn = this.connection;
                for (int i2 = 0; i2 < oracleTypesLen; ++i2) {
                    Object o2 = attributes.get(((OracleTypeADT)this.pickler).getAttributeName(i2 + 1));
                    datum[i2] = oracleTypes[i2].toDatum(o2, iconn);
                    if (o2 == null && !attributes.containsKey(((OracleTypeADT)this.pickler).getAttributeName(i2 + 1))) continue;
                    ++nonNullAttrCount;
                }
                if (nonNullAttrCount < attributesSize) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + null);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, null);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + datum);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datumArray = datum;
            return datumArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData resultSetMetaData;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSetMetaData __result__ = this.connection.newStructMetaData(this);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            resultSetMetaData = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return resultSetMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinalType() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean __result__ = this.getOracleTypeADT().isFinalType();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubtype() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean __result__ = this.getOracleTypeADT().isSubType();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInHierarchyOf(String checkThisName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(checkThisName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StructDescriptor currentDescriptor = this;
            String currentName = currentDescriptor.getName();
            boolean ret = false;
            if (checkThisName.equals(currentName)) {
                ret = true;
            } else {
                while (true) {
                    if ((currentName = currentDescriptor.getSupertypeName()) == null) {
                        ret = false;
                        break;
                    }
                    if (checkThisName.equals(currentName)) {
                        ret = true;
                        break;
                    }
                    currentDescriptor = StructDescriptor.createDescriptor(currentName, (Connection)this.connection);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstantiable() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.isInstanciable == null) {
                this.isInstanciable = this.getOracleTypeADT().isInstanciable();
            }
            boolean __result__ = this.isInstanciable;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJavaObject() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean __result__ = this.getOracleTypeADT().isJavaObject();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSupertypeName() throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String ret = null;
            if (this.isSubtype()) {
                if (this.supertype == null) {
                    this.supertype = this.getOracleTypeADT().getSuperTypeName();
                }
                ret = this.supertype;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocalAttributeCount() throws SQLException {
        int n2;
        try {
            int ret;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.isSubtype()) {
                ret = this.getOracleTypeADT().getAttrTypes().length;
            } else {
                if (this.numLocalAttrs == -1) {
                    this.numLocalAttrs = this.getOracleTypeADT().getNumberOfLocalAttributes();
                }
                ret = this.numLocalAttrs;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSubtypeNames() throws SQLException {
        String[] stringArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.subtypes == null) {
                this.subtypes = this.getOracleTypeADT().getSubtypeNames();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.subtypes);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            stringArray = this.subtypes;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJavaClassName() throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String ret = null;
            if (this.isJavaObject()) {
                ret = StructDescriptor.getJavaObjectClassName(this.connection, this);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeJavaName(int column) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String ret = null;
            if (this.isJavaObject()) {
                if (this.attrJavaNames == null) {
                    this.initMetaData3();
                }
                ret = this.attrJavaNames[column];
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = ret;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAttributeJavaNames() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String[] ret = null;
            if (this.isJavaObject()) {
                if (this.attrJavaNames == null) {
                    this.initMetaData3();
                }
                ret = this.attrJavaNames;
            } else {
                ret = new String[]{};
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String[] stringArray = ret;
            return stringArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLanguage() throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String ret = null;
            ret = this.isJavaObject() ? "JAVA" : "SQL";
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getClass(Map map) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String qualifiedName = this.getName();
            Class c2 = this.connection.getClassForType(qualifiedName, map);
            String schema = this.getSchemaName();
            String type = this.getTypeName();
            if (c2 == null) {
                c2 = (Class)map.get(type);
            }
            if (SQLName.s_parseAllFormat) {
                if (c2 == null && this.connection.getDefaultSchemaNameForNamedTypes().equals(schema)) {
                    c2 = (Class)map.get("\"" + type + "\"");
                }
                if (c2 == null) {
                    c2 = (Class)map.get("\"" + schema + "\"" + "." + "\"" + type + "\"");
                }
                if (c2 == null) {
                    c2 = (Class)map.get("\"" + schema + "\"" + "." + type);
                }
                if (c2 == null) {
                    c2 = (Class)map.get(schema + "." + "\"" + type + "\"");
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + c2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Class clazz = c2;
            return clazz;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJavaObjectClassName(Connection conn, StructDescriptor desc) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(desc));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String __result__ = StructDescriptor.getJavaObjectClassName(conn, desc.getSchemaName(), desc.getTypeName());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJavaObjectClassName(Connection conn, String schema, String typename) throws SQLException {
        try {
            String ret;
            block33: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructDescriptor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(schema) + ", " + OracleLog.argument(typename));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                PreparedStatement pstmt = null;
                ResultSet rset = null;
                ret = null;
                try {
                    pstmt = conn.prepareStatement("select external_name from all_sqlj_types where owner = :1 and type_name = :2");
                    pstmt.setString(1, schema);
                    pstmt.setString(2, typename);
                    rset = pstmt.executeQuery();
                    if (rset.next()) {
                        ret = rset.getString(1);
                        break block33;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructDescriptor.logger().log(Level.SEVERE, "         Throwing SQLException: 100");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 100);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                catch (SQLException e2) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block33;
                    try {
                        StructDescriptor.logger().log(OracleLog.TRACE_20, "         Debug:  SQL exception caught." + e2.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                finally {
                    if (rset != null) {
                        rset.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = ret;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String descType() throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StringBuffer strBuf = new StringBuffer();
            String __result__ = this.descType(strBuf, 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                StructDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String descType(StringBuffer strBuf, int level) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(strBuf) + ", " + OracleLog.argument(level));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String level_one = "";
            for (int i2 = 0; i2 < level; ++i2) {
                level_one = level_one + "  ";
            }
            String level_two = level_one + "  ";
            strBuf.append(level_one);
            strBuf.append(this.getTypeName());
            strBuf.append("\n");
            strBuf.append(level_one);
            strBuf.append("Subtype=" + this.getOracleTypeADT().isSubType());
            strBuf.append(" JavaObject=" + this.getOracleTypeADT().isJavaObject());
            strBuf.append(" FinalType=" + this.getOracleTypeADT().isFinalType());
            strBuf.append("\n");
            ResultSetMetaData md = this.getMetaData();
            int numCols = md.getColumnCount();
            for (int i3 = 0; i3 < numCols; ++i3) {
                int tcode = md.getColumnType(i3 + 1);
                if (tcode == 2002 || tcode == 2008) {
                    StructDescriptor adt_desc = StructDescriptor.createDescriptor(md.getColumnTypeName(i3 + 1), (Connection)this.connection);
                    adt_desc.descType(strBuf, level + 1);
                    continue;
                }
                if (tcode == 2003) {
                    ArrayDescriptor array_desc = ArrayDescriptor.createDescriptor(md.getColumnTypeName(i3 + 1), (Connection)this.connection);
                    array_desc.descType(strBuf, level + 1);
                    continue;
                }
                if (tcode == 2007) {
                    OpaqueDescriptor opq_desc = OpaqueDescriptor.createDescriptor(md.getColumnTypeName(i3 + 1), (Connection)this.connection);
                    opq_desc.descType(strBuf, level + 1);
                    continue;
                }
                strBuf.append(level_two);
                strBuf.append(md.getColumnTypeName(i3 + 1));
                strBuf.append("\n");
            }
            String __result__ = strBuf.substring(0, strBuf.length());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes(Object[] attributes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datums = this.toOracleArray(attributes);
            byte[] __result__ = this.toBytes(datums);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes(Datum[] attributes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(attributes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            STRUCT s2 = new STRUCT(this, (byte[])null, this.connection);
            s2.setDatumArray(attributes);
            byte[] __result__ = this.pickler.linearize(s2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum[] toArray(Object[] attributes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(attributes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] __result__ = this.toOracleArray(attributes);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datumArray = __result__;
            return datumArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum[] toArray(byte[] bytes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            STRUCT s2 = new STRUCT(this, bytes, this.connection);
            Datum[] __result__ = this.toOracleArray(s2, false);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datumArray = __result__;
            return datumArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData3() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            block23: {
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (this.attrJavaNames != null) break block23;
                    String[] temp_attrJavaNames = null;
                    PreparedStatement pstmt = null;
                    ResultSet rset = null;
                    try {
                        pstmt = this.connection.prepareStatement("select EXTERNAL_ATTR_NAME from all_sqlj_type_attrs where owner = :1 and type_name = :2");
                        pstmt.setString(1, this.getSchemaName());
                        pstmt.setString(2, this.getTypeName());
                        rset = pstmt.executeQuery();
                        temp_attrJavaNames = new String[this.getOracleTypeADT().getAttrTypes().length];
                        int i2 = 0;
                        while (rset.next()) {
                            temp_attrJavaNames[i2] = rset.getString(1);
                            ++i2;
                        }
                    }
                    finally {
                        if (rset != null) {
                            rset.close();
                        }
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    this.attrJavaNames = temp_attrJavaNames;
                }
                finally {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String tagName() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "StructDescriptor");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = "StructDescriptor";
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        block17: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block17;
                try {
                    StructDescriptor.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "do nothing");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block17: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block17;
                try {
                    StructDescriptor.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "do nothing");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.StructDescriptor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

