/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.PooledConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OracleConnectionCacheEntry;
import oracle.jdbc.pool.OracleConnectionCacheEventListener;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleDatabaseInstance;
import oracle.jdbc.pool.OracleFailoverWorkerThread;
import oracle.jdbc.pool.OracleGravitateConnectionCacheThread;
import oracle.jdbc.pool.OracleImplicitConnectionCacheThread;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.pool.OracleRuntimeLoadBalancingEventHandlerThread;
import oracle.jdbc.xa.client.OracleXADataSource;

class OracleImplicitConnectionCache {
    protected OracleDataSource cacheEnabledDS = null;
    protected String cacheName = null;
    protected OracleConnectionPoolDataSource connectionPoolDS = null;
    protected boolean fastConnectionFailoverEnabled = false;
    protected String defaultUser = null;
    protected String defaultPassword = null;
    protected static final int DEFAULT_MIN_LIMIT = 0;
    protected static final int DEFAULT_MAX_LIMIT = Integer.MAX_VALUE;
    protected static final int DEFAULT_INITIAL_LIMIT = 0;
    protected static final int DEFAULT_MAX_STATEMENTS_LIMIT = 0;
    protected static final int DEFAULT_INACTIVITY_TIMEOUT = 0;
    protected static final int DEFAULT_TIMETOLIVE_TIMEOUT = 0;
    protected static final int DEFAULT_ABANDONED_CONN_TIMEOUT = 0;
    protected static final int DEFAULT_CONNECTION_WAIT_TIMEOUT = 0;
    protected static final String DEFAULT_ATTRIBUTE_WEIGHT = "0";
    protected static final int DEFAULT_LOWER_THRESHOLD_LIMIT = 20;
    protected static final int DEFAULT_PROPERTY_CHECK_INTERVAL = 900;
    protected static final int CLOSE_AND_REMOVE_ALL_CONNECTIONS = 1;
    protected static final int CLOSE_AND_REMOVE_FAILOVER_CONNECTIONS = 2;
    protected static final int PROCESS_INACTIVITY_TIMEOUT = 4;
    protected static final int CLOSE_AND_REMOVE_N_CONNECTIONS = 8;
    protected static final int DISABLE_STATEMENT_CACHING = 16;
    protected static final int RESET_STATEMENT_CACHE_SIZE = 18;
    protected static final int CLOSE_AND_REMOVE_RLB_CONNECTIONS = 24;
    protected static final int ABORT_AND_CLOSE_ALL_CONNECTIONS = 32;
    public static final int REFRESH_INVALID_CONNECTIONS = 4096;
    public static final int REFRESH_ALL_CONNECTIONS = 8192;
    private static final String ATTRKEY_DELIM = "0xffff";
    protected int cacheMinLimit = 0;
    protected int cacheMaxLimit = Integer.MAX_VALUE;
    protected int cacheInitialLimit = 0;
    protected int cacheMaxStatementsLimit = 0;
    protected Properties cacheAttributeWeights = null;
    protected int cacheInactivityTimeout = 0;
    protected int cacheTimeToLiveTimeout = 0;
    protected int cacheAbandonedConnectionTimeout = 0;
    protected int cacheLowerThresholdLimit = 20;
    protected int cachePropertyCheckInterval = 900;
    protected boolean cacheClosestConnectionMatch = false;
    protected boolean cacheValidateConnection = false;
    protected boolean cacheUseLIFO = false;
    protected int cacheConnectionWaitTimeout = 0;
    static final String MIN_LIMIT_KEY = "MinLimit";
    static final String MAX_LIMIT_KEY = "MaxLimit";
    static final String INITIAL_LIMIT_KEY = "InitialLimit";
    static final String MAX_STATEMENTS_LIMIT_KEY = "MaxStatementsLimit";
    static final String ATTRIBUTE_WEIGHTS_KEY = "AttributeWeights";
    static final String INACTIVITY_TIMEOUT_KEY = "InactivityTimeout";
    static final String TIME_TO_LIVE_TIMEOUT_KEY = "TimeToLiveTimeout";
    static final String ABANDONED_CONNECTION_TIMEOUT_KEY = "AbandonedConnectionTimeout";
    static final String LOWER_THRESHOLD_LIMIT_KEY = "LowerThresholdLimit";
    static final String PROPERTY_CHECK_INTERVAL_KEY = "PropertyCheckInterval";
    static final String VALIDATE_CONNECTION_KEY = "ValidateConnection";
    static final String CLOSEST_CONNECTION_MATCH_KEY = "ClosestConnectionMatch";
    static final String CONNECTION_WAIT_TIMEOUT_KEY = "ConnectionWaitTimeout";
    static final String LOCAL_TXN_COMMIT_ON_CLOSE = "LocalTransactionCommitOnClose";
    static final String USE_LIFO_KEY = "UseLIFO";
    static final int INSTANCE_GOOD = 1;
    static final int INSTANCE_UNKNOWN = 2;
    static final int INSTANCE_VIOLATING = 3;
    static final int INSTANCE_NO_DATA = 4;
    static final int INSTANCE_BLOCKED = 5;
    static final int RLB_NUMBER_OF_HITS_PER_INSTANCE = 1000;
    int dbInstancePercentTotal = 0;
    boolean useGoodGroup = false;
    Vector instancesToRetireQueue = null;
    OracleDatabaseInstance instanceToRetire = null;
    int retireConnectionsCount = 0;
    int countTotal = 0;
    protected OracleConnectionCacheManager cacheManager = null;
    protected boolean disableConnectionRequest = false;
    protected OracleImplicitConnectionCacheThread timeoutThread = null;
    protected OracleRuntimeLoadBalancingEventHandlerThread runtimeLoadBalancingThread = null;
    protected OracleGravitateConnectionCacheThread gravitateCacheThread = null;
    protected int connectionsToRemove = 0;
    private HashMap userMap = null;
    Vector checkedOutConnectionList = null;
    LinkedList databaseInstancesList = null;
    int cacheSize = 0;
    protected static final String EVENT_DELIMITER = " ";
    protected boolean isEntireServiceDownProcessed = false;
    protected int defaultUserPreFailureSize = 0;
    protected String dataSourceServiceName = null;
    protected OracleFailoverWorkerThread failoverWorkerThread = null;
    protected Random rand = null;
    protected int downEventCount = 0;
    protected int upEventCount = 0;
    protected int pendingCreationRequests = 0;
    protected int connectionClosedCount = 0;
    protected int connectionCreatedCount = 0;
    boolean cacheLocalTxnCommitOnClose = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    OracleImplicitConnectionCache(OracleDataSource ds, Properties cacheProps) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(ds) + ", " + OracleLog.argument(cacheProps));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.cacheEnabledDS = ds;
            this.initializeConnectionCache();
            this.setConnectionCacheProperties(cacheProps);
            this.defaultUserPrePopulateCache(this.cacheInitialLimit);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultUserPrePopulateCache(int sz) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(sz));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (sz > 0) {
                String user = this.defaultUser;
                String passwd = this.defaultPassword;
                this.validateUser(user, passwd);
                OraclePooledConnection pc = null;
                for (int i2 = 0; i2 < sz; ++i2) {
                    pc = this.makeOneConnection(user, passwd);
                    OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
                    synchronized (oracleImplicitConnectionCache) {
                        if (pc != null) {
                            --this.cacheSize;
                            this.storeCacheConnection(null, pc);
                        }
                        continue;
                    }
                }
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_12 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initializeConnectionCache() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.userMap = new HashMap();
            this.checkedOutConnectionList = new Vector();
            if (this.cacheManager == null) {
                this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
            }
            this.defaultUser = this.cacheEnabledDS.user != null && !this.cacheEnabledDS.user.startsWith("\"") ? this.cacheEnabledDS.user.toLowerCase() : this.cacheEnabledDS.user;
            this.defaultPassword = this.cacheEnabledDS.password;
            if (this.connectionPoolDS == null) {
                this.connectionPoolDS = this.cacheEnabledDS instanceof OracleXADataSource ? new OracleXADataSource() : new OracleConnectionPoolDataSource();
                this.cacheEnabledDS.copy(this.connectionPoolDS);
            }
            if (this.fastConnectionFailoverEnabled = this.cacheEnabledDS.getFastConnectionFailoverEnabled()) {
                this.rand = new Random(0L);
                this.instancesToRetireQueue = new Vector();
                ++this.cacheManager.failoverEnabledCacheCount;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_8 = null;
            }
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateUser(String user, String passwd) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(user) + ", " + OracleLog.argument(passwd));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (user == null || passwd == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 79);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 79);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnection(String user, String passwd, Properties connAttr) throws SQLException {
        Connection connection;
        try {
            Connection conn;
            block39: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(user) + ", " + OracleLog.argument(passwd) + ", " + OracleLog.argument(connAttr));
                        Object var5_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                OraclePooledConnection pc = null;
                conn = null;
                try {
                    if (this.disableConnectionRequest) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleImplicitConnectionCache.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 142);
                                Object var7_8 = null;
                            }
                            catch (Throwable throwable) {
                                Object var7_9 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 142);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    this.validateUser(user, passwd);
                    if (!user.startsWith("\"")) {
                        user = user.toLowerCase();
                    }
                    if (this.getNumberOfCheckedOutConnections() < this.cacheMaxLimit) {
                        pc = this.getCacheConnection(user, passwd, connAttr);
                    }
                    if (pc == null) {
                        this.processConnectionCacheCallback();
                        if (this.cacheSize > 0) {
                            pc = this.getCacheConnection(user, passwd, connAttr);
                        }
                        if (pc == null && this.cacheConnectionWaitTimeout > 0) {
                            long localCacheConnectionWaitTimeout = (long)this.cacheConnectionWaitTimeout * 1000L;
                            long beforeWait = System.currentTimeMillis();
                            long afterWait = 0L;
                            do {
                                this.processConnectionWaitTimeout(localCacheConnectionWaitTimeout);
                                if (this.cacheSize > 0) {
                                    pc = this.getCacheConnection(user, passwd, connAttr);
                                }
                                afterWait = System.currentTimeMillis();
                                beforeWait = afterWait;
                            } while (pc == null && (localCacheConnectionWaitTimeout -= System.currentTimeMillis() - beforeWait) > 0L);
                        }
                    }
                    if (pc == null || pc.physicalConn == null || (conn = pc.getConnection()) == null) break block39;
                    if (this.cacheValidateConnection && this.testDatabaseConnection((OracleConnection)conn) != 0) {
                        ((OracleConnection)conn).close(4096);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleImplicitConnectionCache.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 143);
                                Object var13_20 = null;
                            }
                            catch (Throwable throwable) {
                                Object var13_21 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 143);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (this.cacheAbandonedConnectionTimeout > 0) {
                        ((OracleConnection)conn).setAbandonedTimeoutEnabled(true);
                    }
                    if (this.cacheTimeToLiveTimeout > 0) {
                        ((OracleConnection)conn).setStartTime(System.currentTimeMillis());
                    }
                    OracleImplicitConnectionCache __ex__ = this;
                    synchronized (__ex__) {
                        --this.cacheSize;
                        this.checkedOutConnectionList.addElement(pc);
                    }
                }
                catch (SQLException ea) {
                    OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
                    synchronized (oracleImplicitConnectionCache) {
                        if (pc != null) {
                            --this.cacheSize;
                            this.abortConnection(pc);
                        }
                    }
                    throw ea;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + conn);
                    Object var17_25 = null;
                }
                catch (Throwable throwable) {
                    Object var17_26 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            connection = conn;
            Object var19_28 = null;
        }
        catch (Throwable throwable) {
            Object var19_29 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var21_32 = null;
                }
                catch (Throwable throwable2) {
                    Object var21_33 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var21_30 = null;
            }
            catch (Throwable throwable) {
                Object var21_31 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OraclePooledConnection getCacheConnection(String user, String passwd, Properties connAttr) throws SQLException {
        OraclePooledConnection oraclePooledConnection;
        try {
            OraclePooledConnection pc;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(user) + ", " + OracleLog.argument(passwd) + ", " + OracleLog.argument(connAttr));
                    oraclePooledConnection = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((pc = this.retrieveCacheConnection(user, passwd, connAttr)) == null && (pc = this.makeOneConnection(user, passwd)) != null && connAttr != null && !connAttr.isEmpty()) {
                this.setUnMatchedAttributes(connAttr, pc);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + pc);
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oraclePooledConnection = pc;
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oraclePooledConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OraclePooledConnection makeOneConnection(String _user, String _passwd) throws SQLException {
        OraclePooledConnection pc = null;
        boolean doMakeCacheConnection = false;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
        synchronized (oracleImplicitConnectionCache) {
            if (this.getTotalCachedConnections() + this.pendingCreationRequests < this.cacheMaxLimit) {
                ++this.pendingCreationRequests;
                doMakeCacheConnection = true;
            }
        }
        if (doMakeCacheConnection) {
            OracleImplicitConnectionCache oracleImplicitConnectionCache2;
            try {
                pc = this.makeCacheConnection(_user, _passwd);
                Object var8_7 = null;
                oracleImplicitConnectionCache2 = this;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                OracleImplicitConnectionCache oracleImplicitConnectionCache3 = this;
                synchronized (oracleImplicitConnectionCache3) {
                    if (pc != null) {
                        ++this.connectionCreatedCount;
                    }
                    --this.pendingCreationRequests;
                }
                throw throwable;
            }
            synchronized (oracleImplicitConnectionCache2) {
                if (pc != null) {
                    ++this.connectionCreatedCount;
                }
                --this.pendingCreationRequests;
            }
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getTotalCachedConnections() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            int __result__ = this.cacheSize + this.getNumberOfCheckedOutConnections();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            n2 = __result__;
            Object var6_9 = null;
            if (!TRACE) return n2;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return n2;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_11 = null;
            OracleLog.recursiveExit();
            return n2;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNumberOfCheckedOutConnections() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int __result__ = this.checkedOutConnectionList.size();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized OraclePooledConnection retrieveCacheConnection(String user, String passwd, Properties connAttr) throws SQLException {
        OraclePooledConnection oraclePooledConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(user) + ", " + OracleLog.argument(passwd) + ", " + OracleLog.argument(connAttr));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OraclePooledConnection pc = null;
            OracleConnectionCacheEntry m_userConnEntry = (OracleConnectionCacheEntry)this.userMap.get(OraclePooledConnection.generateKey(user, passwd));
            if (m_userConnEntry != null) {
                if (connAttr == null || connAttr != null && connAttr.isEmpty()) {
                    if (m_userConnEntry.userConnList != null) {
                        pc = this.retrieveFromConnectionList(m_userConnEntry.userConnList);
                    }
                } else if (m_userConnEntry.attrConnMap != null) {
                    String attrKey = this.buildAttrKey(connAttr);
                    Vector attrMapEntry = (Vector)m_userConnEntry.attrConnMap.get(attrKey);
                    if (attrMapEntry != null) {
                        pc = this.retrieveFromConnectionList(attrMapEntry);
                    }
                    if (pc == null && this.cacheClosestConnectionMatch) {
                        pc = this.retrieveClosestConnectionMatch(m_userConnEntry.attrConnMap, connAttr);
                    }
                    if (pc == null && m_userConnEntry.userConnList != null) {
                        pc = this.retrieveFromConnectionList(m_userConnEntry.userConnList);
                    }
                }
            }
            if (pc != null && connAttr != null && !connAttr.isEmpty()) {
                this.setUnMatchedAttributes(connAttr, pc);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + pc);
                    Object var9_10 = null;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oraclePooledConnection = pc;
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_15 = null;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oraclePooledConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OraclePooledConnection retrieveClosestConnectionMatch(HashMap attrConnMap, Properties inAttr) throws SQLException {
        OraclePooledConnection oraclePooledConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(attrConnMap) + ", " + OracleLog.argument(inAttr));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OraclePooledConnection opc = null;
            OraclePooledConnection currOpc = null;
            Vector currOpcVector = null;
            int reqMatchCount = inAttr.size();
            int reqWeightCount = 0;
            int actualWeightCount = 0;
            int currWeightCount = 0;
            int actualMatchCount = 0;
            int currMatchCount = 0;
            if (this.cacheAttributeWeights != null) {
                reqWeightCount = this.getAttributesWeightCount(inAttr, null);
            }
            if (attrConnMap != null && !attrConnMap.isEmpty()) {
                for (Map.Entry me : attrConnMap.entrySet()) {
                    Vector aList = (Vector)me.getValue();
                    Object[] aObjArr = aList.toArray();
                    int asz = aList.size();
                    for (int l2 = 0; l2 < asz; ++l2) {
                        opc = (OraclePooledConnection)aObjArr[l2];
                        if (opc.cachedConnectionAttributes == null || opc.cachedConnectionAttributes.isEmpty() || opc.cachedConnectionAttributes.size() > reqMatchCount) continue;
                        if (reqWeightCount > 0) {
                            currWeightCount = this.getAttributesWeightCount(inAttr, opc.cachedConnectionAttributes);
                            if (currWeightCount <= actualWeightCount) continue;
                            currOpc = opc;
                            actualWeightCount = currWeightCount;
                            currOpcVector = aList;
                            continue;
                        }
                        currMatchCount = this.getAttributesMatchCount(inAttr, opc.cachedConnectionAttributes);
                        if (currMatchCount <= actualMatchCount) continue;
                        currOpc = opc;
                        actualMatchCount = currMatchCount;
                        currOpcVector = aList;
                    }
                }
            }
            if (currOpcVector != null) {
                currOpcVector.remove(currOpc);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + currOpc);
                    Object var19_20 = null;
                }
                catch (Throwable throwable) {
                    Object var19_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oraclePooledConnection = currOpc;
            Object var21_23 = null;
        }
        catch (Throwable throwable) {
            Object var21_24 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var23_27 = null;
                }
                catch (Throwable throwable2) {
                    Object var23_28 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var23_25 = null;
            }
            catch (Throwable throwable) {
                Object var23_26 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oraclePooledConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getAttributesMatchCount(Properties in, Properties curr) throws SQLException {
        try {
            if (OracleImplicitConnectionCache.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(in) + ", " + OracleLog.argument(curr));
                    var4_3 = null;
                }
                catch (Throwable var3_5) {
                    var4_4 = null;
                    OracleLog.recursiveExit();
                    throw var3_5;
                }
                OracleLog.recursiveExit();
            }
            matchCount = 0;
            me = null;
            inKeyObj = null;
            inValueObj = null;
            for (Map.Entry<Object, Object> me : in.entrySet()) {
                inKeyObj = me.getKey();
                inValueObj = me.getValue();
                if (!curr.containsKey(inKeyObj) || !inValueObj.equals(curr.get(inKeyObj))) continue;
                ++matchCount;
            }
            if (OracleImplicitConnectionCache.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + matchCount);
                    var9_10 = null;
                }
                catch (Throwable var8_12) {
                    var9_11 = null;
                    OracleLog.recursiveExit();
                    throw var8_12;
                }
                OracleLog.recursiveExit();
            }
            var8_13 = matchCount;
            var11_14 = null;
            if (OracleImplicitConnectionCache.TRACE == false) return var8_13;
            ** GOTO lbl56
        }
        catch (Throwable var10_22) {
            var11_15 = null;
            if (OracleImplicitConnectionCache.TRACE == false) throw var10_22;
            if (OracleLog.recursiveEnter() == false) throw var10_22;
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var13_18 = null;
            }
            catch (Throwable var12_21) {
                var13_19 = null;
                OracleLog.recursiveExit();
                throw var12_21;
            }
lbl56:
            // 1 sources

            if (OracleLog.recursiveEnter() == false) return var8_13;
            try {}
            catch (Throwable var12_20) {
                var13_17 = null;
                OracleLog.recursiveExit();
                throw var12_20;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var13_16 = null;
            OracleLog.recursiveExit();
            return var8_13;
            OracleLog.recursiveExit();
            throw var10_22;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAttributesWeightCount(Properties inAttr, Properties currAttr) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(inAttr) + ", " + OracleLog.argument(currAttr));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Map.Entry<Object, Object> me2 = null;
            Object inKeyObj = null;
            Object inValueObj = null;
            int weightCount = 0;
            for (Map.Entry<Object, Object> me2 : inAttr.entrySet()) {
                inKeyObj = me2.getKey();
                inValueObj = me2.getValue();
                if (currAttr == null) {
                    if (!this.cacheAttributeWeights.containsKey(inKeyObj)) continue;
                    weightCount += Integer.parseInt((String)this.cacheAttributeWeights.get(inKeyObj));
                    continue;
                }
                if (!currAttr.containsKey(inKeyObj) || !inValueObj.equals(currAttr.get(inKeyObj))) continue;
                if (this.cacheAttributeWeights.containsKey(inKeyObj)) {
                    weightCount += Integer.parseInt((String)this.cacheAttributeWeights.get(inKeyObj));
                    continue;
                }
                ++weightCount;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + weightCount);
                    Object var9_10 = null;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = weightCount;
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_16 = null;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setUnMatchedAttributes(Properties inAttr, OraclePooledConnection opc) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(inAttr) + ", " + OracleLog.argument(opc));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (opc.unMatchedCachedConnAttr == null) {
                opc.unMatchedCachedConnAttr = new Properties();
            } else {
                opc.unMatchedCachedConnAttr.clear();
            }
            if (!this.cacheClosestConnectionMatch) {
                opc.unMatchedCachedConnAttr.putAll((Map<?, ?>)inAttr);
            } else {
                Properties curr = opc.cachedConnectionAttributes;
                Map.Entry<Object, Object> me2 = null;
                Object inKeyObj = null;
                Object inValueObj = null;
                for (Map.Entry<Object, Object> me2 : inAttr.entrySet()) {
                    inKeyObj = me2.getKey();
                    inValueObj = me2.getValue();
                    if (curr.containsKey(inKeyObj) || inValueObj.equals(curr.get(inKeyObj))) continue;
                    opc.unMatchedCachedConnAttr.put(inKeyObj, inValueObj);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var9_10 = null;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_17 = null;
            }
            catch (Throwable throwable2) {
                Object var13_18 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OraclePooledConnection retrieveFromConnectionList(Vector list) throws SQLException {
        OraclePooledConnection oraclePooledConnection;
        LinkedList linkedList;
        block37: {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(list));
                    linkedList = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache.retrieveFromConnectionList" + "( of Conns=" + list.size() + ", list=" + list + ")");
                    Object var5_9 = null;
                }
                catch (Throwable throwable) {
                    Object var5_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (!list.isEmpty()) break block37;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    Object var7_14 = null;
                }
                catch (Throwable throwable) {
                    Object var7_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OraclePooledConnection oraclePooledConnection2 = null;
            Object var18_21 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var20_24 = null;
                }
                catch (Throwable throwable) {
                    Object var20_25 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return oraclePooledConnection2;
        }
        try {
            OraclePooledConnection pc = null;
            if (this.fastConnectionFailoverEnabled) {
                if (this.useGoodGroup && this.databaseInstancesList != null && this.databaseInstancesList.size() > 0) {
                    linkedList = this.databaseInstancesList;
                    synchronized (linkedList) {
                        int numInstances = this.databaseInstancesList.size();
                        OracleDatabaseInstance dbInstance = null;
                        int randomPercent = 0;
                        boolean[] tried = new boolean[numInstances];
                        int total = this.dbInstancePercentTotal;
                        block20: for (int j2 = 0; j2 < numInstances; ++j2) {
                            int percentSum = 0;
                            randomPercent = total <= 1 ? 0 : this.rand.nextInt(total - 1);
                            for (int i2 = 0; i2 < numInstances; ++i2) {
                                dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                                if (tried[i2] || dbInstance.flag > 3) continue;
                                percentSum += dbInstance.percent;
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    Object var13_37;
                                    try {
                                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache." + "retrieveFromConnectionList()" + "RandomPercent=" + randomPercent + ": percentSum=" + percentSum);
                                        var13_37 = null;
                                    }
                                    catch (Throwable throwable) {
                                        var13_37 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                if (randomPercent > percentSum) continue;
                                if (j2 == 0) {
                                    ++dbInstance.attemptedConnRequestCount;
                                }
                                if ((pc = this.selectConnectionFromList(list, dbInstance)) != null) break block20;
                                total -= dbInstance.percent;
                                tried[i2] = true;
                                continue block20;
                            }
                        }
                    }
                }
                if (!this.cacheUseLIFO) {
                    int sz = list.size();
                    int pos = this.rand.nextInt(sz);
                    OraclePooledConnection tmpPc = null;
                    for (int i3 = 0; i3 < sz; ++i3) {
                        int position = (pos++ + sz) % sz;
                        tmpPc = (OraclePooledConnection)list.get(position);
                        if (tmpPc.connectionMarkedDown) continue;
                        pc = tmpPc;
                        list.remove(pc);
                        break;
                    }
                } else {
                    pc = (OraclePooledConnection)list.remove(0);
                }
            } else {
                pc = (OraclePooledConnection)list.remove(0);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + pc);
                    Object var16_40 = null;
                }
                catch (Throwable throwable) {
                    Object var16_41 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oraclePooledConnection = pc;
            Object var18_22 = null;
        }
        catch (Throwable throwable) {
            Object var18_23 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var20_28 = null;
                }
                catch (Throwable throwable2) {
                    Object var20_29 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var20_26 = null;
            }
            catch (Throwable throwable) {
                Object var20_27 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oraclePooledConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OraclePooledConnection selectConnectionFromList(Vector list, OracleDatabaseInstance dbInstance) {
        OraclePooledConnection oraclePooledConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(list) + ", " + OracleLog.argument(dbInstance));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OraclePooledConnection pc = null;
            OraclePooledConnection tmpPc = null;
            int sz = list.size();
            for (int i2 = 0; i2 < sz; ++i2) {
                tmpPc = (OraclePooledConnection)list.get(i2);
                if (tmpPc.connectionMarkedDown || tmpPc.dataSourceDbUniqNameKey != dbInstance.databaseUniqName || tmpPc.dataSourceInstanceNameKey != dbInstance.instanceName) continue;
                pc = tmpPc;
                list.remove(pc);
                break;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB) OracleImplicitConnectionCache.selectConnectionFromList" + "(pc=" + pc + ")" + " <<< ServiceName=" + this.dataSourceServiceName + ", Connections to " + dbInstance.instanceName + " = " + dbInstance.numberOfConnectionsCount + ", Attempted Connection Requests to this instance=" + dbInstance.attemptedConnRequestCount + ", Total Connections=" + this.getTotalCachedConnections() + " >>>");
                    Object var8_10 = null;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + pc);
                    Object var10_13 = null;
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oraclePooledConnection = pc;
            Object var12_16 = null;
            if (!TRACE) return oraclePooledConnection;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_20 = null;
            }
            catch (Throwable throwable2) {
                Object var14_21 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return oraclePooledConnection;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_18 = null;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return oraclePooledConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void removeCacheConnection(OraclePooledConnection pc) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc));
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            boolean pcRemoved = false;
            OracleConnectionCacheEntry m_userConnEntry = pc.removeFromImplictCache(this.userMap);
            if (m_userConnEntry != null) {
                String attrKey;
                Vector attrMapEntry;
                Properties connAttr = pc.cachedConnectionAttributes;
                if (connAttr == null || connAttr != null && connAttr.isEmpty()) {
                    if (m_userConnEntry.userConnList != null) {
                        pcRemoved = m_userConnEntry.userConnList.removeElement(pc);
                    }
                } else if (m_userConnEntry.attrConnMap != null && (attrMapEntry = (Vector)m_userConnEntry.attrConnMap.get(attrKey = this.buildAttrKey(connAttr))) != null) {
                    if (pc.unMatchedCachedConnAttr != null) {
                        pc.unMatchedCachedConnAttr.clear();
                        pc.unMatchedCachedConnAttr = null;
                    }
                    if (pc.cachedConnectionAttributes != null) {
                        pc.cachedConnectionAttributes.clear();
                        pc.cachedConnectionAttributes = null;
                    }
                    connAttr = null;
                    pcRemoved = attrMapEntry.removeElement(pc);
                }
            }
            if (pcRemoved) {
                --this.cacheSize;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var8_9 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var10_12 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var12_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var12_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var12_14 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doForEveryCachedConnection(int task) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(task));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int repSize = 0;
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
            synchronized (oracleImplicitConnectionCache) {
                if (this.userMap != null && !this.userMap.isEmpty()) {
                    for (Map.Entry e2 : this.userMap.entrySet()) {
                        OraclePooledConnection pc;
                        OracleConnectionCacheEntry occe = (OracleConnectionCacheEntry)e2.getValue();
                        if (occe.userConnList != null && !occe.userConnList.isEmpty()) {
                            Vector uList = occe.userConnList;
                            Object[] objArr = uList.toArray();
                            for (int k2 = 0; k2 < objArr.length; ++k2) {
                                pc = (OraclePooledConnection)objArr[k2];
                                if (pc == null || !this.performPooledConnectionTask(pc, task)) continue;
                                ++repSize;
                            }
                        }
                        if (occe.attrConnMap == null || occe.attrConnMap.isEmpty()) continue;
                        for (Map.Entry me : occe.attrConnMap.entrySet()) {
                            Vector aList = (Vector)me.getValue();
                            Object[] objArr = aList.toArray();
                            for (int l2 = 0; l2 < objArr.length; ++l2) {
                                pc = (OraclePooledConnection)objArr[l2];
                                if (pc == null || !this.performPooledConnectionTask(pc, task)) continue;
                                ++repSize;
                            }
                        }
                        if (task != 1 && task != 32) continue;
                        occe.attrConnMap.clear();
                    }
                    if (task == 1 || task == 32) {
                        this.userMap.clear();
                        this.cacheSize = 0;
                    }
                }
            }
            if (repSize > 0) {
                this.defaultUserPrePopulateCache(repSize);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var15_18 = null;
                }
                catch (Throwable throwable) {
                    Object var15_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var17_21 = null;
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var19_25 = null;
            }
            catch (Throwable throwable2) {
                Object var19_26 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var19_23 = null;
        }
        catch (Throwable throwable) {
            Object var19_24 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean performPooledConnectionTask(OraclePooledConnection pc, int task) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc) + ", " + OracleLog.argument(task));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            boolean mustReplace = false;
            switch (task) {
                case 2: {
                    if (!pc.connectionMarkedDown) break;
                    pc.needToAbort = true;
                    this.closeAndRemovePooledConnection(pc);
                    break;
                }
                case 8: {
                    if (this.connectionsToRemove <= 0) break;
                    this.closeAndRemovePooledConnection(pc);
                    --this.connectionsToRemove;
                    break;
                }
                case 24: {
                    if (this.retireConnectionsCount <= 0 || this.instanceToRetire.databaseUniqName != pc.dataSourceDbUniqNameKey || this.instanceToRetire.instanceName != pc.dataSourceInstanceNameKey) break;
                    this.closeAndRemovePooledConnection(pc);
                    --this.retireConnectionsCount;
                    if (this.getTotalCachedConnections() >= this.cacheMinLimit) break;
                    mustReplace = true;
                    break;
                }
                case 4096: {
                    Connection conn = pc.getLogicalHandle();
                    if (conn == null && (conn = pc.getPhysicalHandle()) == null || this.testDatabaseConnection((OracleConnection)conn) == 0) break;
                    this.closeAndRemovePooledConnection(pc);
                    mustReplace = true;
                    break;
                }
                case 8192: {
                    this.closeAndRemovePooledConnection(pc);
                    mustReplace = true;
                    break;
                }
                case 1: {
                    this.closeAndRemovePooledConnection(pc);
                    break;
                }
                case 4: {
                    this.processInactivityTimeout(pc);
                    break;
                }
                case 16: {
                    this.setStatementCaching(pc, this.cacheMaxStatementsLimit, false);
                    break;
                }
                case 18: {
                    this.setStatementCaching(pc, this.cacheMaxStatementsLimit, true);
                    break;
                }
                case 32: {
                    this.abortConnection(pc);
                    this.closeAndRemovePooledConnection(pc);
                    break;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + mustReplace);
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = mustReplace;
            Object var8_11 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_13 = null;
            OracleLog.recursiveExit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void doForEveryCheckedOutConnection(int task) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(task));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int sz = this.checkedOutConnectionList.size();
            switch (task) {
                case 1: {
                    for (int i2 = 0; i2 < sz; ++i2) {
                        this.closeCheckedOutConnection((OraclePooledConnection)this.checkedOutConnectionList.get(i2), false);
                    }
                    this.checkedOutConnectionList.removeAllElements();
                    break;
                }
                case 24: {
                    for (int i3 = 0; i3 < sz && this.retireConnectionsCount > 0; ++i3) {
                        OraclePooledConnection pc = (OraclePooledConnection)this.checkedOutConnectionList.get(i3);
                        if (this.instanceToRetire.databaseUniqName != pc.dataSourceDbUniqNameKey || this.instanceToRetire.instanceName != pc.dataSourceInstanceNameKey) continue;
                        pc.closeOption = 4096;
                        this.retireConnectionsCount -= 2;
                    }
                    break;
                }
                case 32: {
                    for (int i4 = 0; i4 < sz; ++i4) {
                        OraclePooledConnection pc = null;
                        pc = (OraclePooledConnection)this.checkedOutConnectionList.get(i4);
                        this.abortConnection(pc);
                        this.closeCheckedOutConnection(pc, false);
                    }
                    this.checkedOutConnectionList.removeAllElements();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var6_11 = null;
                }
                catch (Throwable throwable) {
                    Object var6_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var8_14 = null;
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_18 = null;
            }
            catch (Throwable throwable2) {
                Object var10_19 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_16 = null;
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void closeCheckedOutConnection(OraclePooledConnection pc, boolean isReuse) throws SQLException {
        try {
            if (OracleImplicitConnectionCache.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc) + ", " + OracleLog.argument(isReuse));
                    var4_3 = null;
                }
                catch (Throwable var3_5) {
                    var4_4 = null;
                    OracleLog.recursiveExit();
                    throw var3_5;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (pc != null) {
                lconn = (OracleConnection)pc.getLogicalHandle();
                pconn = (OracleConnection)pc.getPhysicalHandle();
                savedAC = lconn.getAutoCommit();
                if (isReuse) {
                    savedValue = pc.localTxnCommitOnClose;
                    try {
                        try {
                            block33: {
                                pc.localTxnCommitOnClose = false;
                                lconn.cleanupAndClose(true);
                                try {
                                    if (!savedAC && !pc.needToAbort) {
                                        pconn.rollback();
                                    }
                                }
                                catch (SQLException e) {
                                    if (!OracleImplicitConnectionCache.TRACE || !OracleLog.recursiveEnter()) break block33;
                                    try {
                                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache.closeCheckedOutConnection():" + "rollback() - SQLException Occurred " + e.getMessage());
                                        var9_12 = null;
                                    }
                                    catch (Throwable var8_14) {
                                        var9_13 = null;
                                        OracleLog.recursiveExit();
                                        throw var8_14;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                            }
                            var13_15 = null;
                            if (pc.localTxnCommitOnClose == savedValue) ** GOTO lbl89
                            pc.localTxnCommitOnClose = savedValue;
                        }
                        catch (SQLException e) {
                            if (OracleImplicitConnectionCache.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache.closeCheckedOutConnection" + "():close() - SQLException Occurred " + e.getMessage());
                                    var11_18 = null;
                                }
                                catch (Throwable var10_20) {
                                    var11_19 = null;
                                    OracleLog.recursiveExit();
                                    throw var10_20;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            var13_16 = null;
                            if (pc.localTxnCommitOnClose == savedValue) ** GOTO lbl89
                            pc.localTxnCommitOnClose = savedValue;
                        }
                    }
                    catch (Throwable var12_21) {
                        var13_17 = null;
                        if (pc.localTxnCommitOnClose != savedValue) {
                            pc.localTxnCommitOnClose = savedValue;
                        }
                        throw var12_21;
                    }
                } else {
                    block34: {
                        try {
                            if (!savedAC && !pc.needToAbort) {
                                pconn.cancel();
                                pconn.rollback();
                            }
                        }
                        catch (SQLException e) {
                            if (!OracleImplicitConnectionCache.TRACE || !OracleLog.recursiveEnter()) break block34;
                            try {
                                OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache.closeCheckedOutConnection():" + "cancel()/rollback() - SQLException Occurred " + e.getMessage());
                                var15_22 = null;
                            }
                            catch (Throwable var14_24) {
                                var15_23 = null;
                                OracleLog.recursiveExit();
                                throw var14_24;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                    }
                    this.actualPooledConnectionClose(pc);
                }
            }
lbl89:
            // 7 sources

            if (OracleImplicitConnectionCache.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    var17_25 = null;
                }
                catch (Throwable var16_27) {
                    var17_26 = null;
                    OracleLog.recursiveExit();
                    throw var16_27;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            var19_28 = null;
        }
        catch (Throwable var18_36) {
            var19_29 = null;
            if (OracleImplicitConnectionCache.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    var21_32 = null;
                }
                catch (Throwable var20_35) {
                    var21_33 = null;
                    OracleLog.recursiveExit();
                    throw var20_35;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw var18_36;
        }
        if (!OracleImplicitConnectionCache.TRACE || !OracleLog.recursiveEnter()) ** GOTO lbl130
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var21_30 = null;
        }
        catch (Throwable var20_34) {
            var21_31 = null;
            OracleLog.recursiveExit();
            throw var20_34;
        }
        OracleLog.recursiveExit();
lbl130:
        // 2 sources

    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    synchronized void storeCacheConnection(Properties connAttr, OraclePooledConnection pc) throws SQLException {
        try {
            boolean pcAdded;
            block30: {
                OracleConnectionCacheEntry m_userConnEntry;
                block33: {
                    String attrKey;
                    Vector<OraclePooledConnection> attrMapEntry;
                    block34: {
                        block32: {
                            block31: {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(connAttr) + ", " + OracleLog.argument(pc));
                                        Object var4_3 = null;
                                        OracleLog.recursiveExit();
                                    }
                                    catch (Throwable throwable) {
                                        Object var4_4 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                }
                                pcAdded = false;
                                if (pc == null) break block31;
                                if (pc.physicalConn != null) break block32;
                            }
                            Object var11_7 = null;
                            if (!TRACE) return;
                            if (!OracleLog.recursiveEnter()) return;
                            try {
                                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                Object var13_10 = null;
                                OracleLog.recursiveExit();
                                return;
                            }
                            catch (Throwable throwable) {
                                Object var13_11 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        if (this.cacheInactivityTimeout > 0) {
                            pc.setLastAccessedTime(System.currentTimeMillis());
                        }
                        if (pc.unMatchedCachedConnAttr != null) {
                            pc.unMatchedCachedConnAttr.clear();
                            pc.unMatchedCachedConnAttr = null;
                        }
                        if ((m_userConnEntry = pc.removeFromImplictCache(this.userMap)) == null) break block33;
                        if (connAttr != null && (connAttr == null || !connAttr.isEmpty())) break block34;
                        if (m_userConnEntry.userConnList == null) {
                            m_userConnEntry.userConnList = new Vector();
                        }
                        if (this.cacheUseLIFO) {
                            m_userConnEntry.userConnList.add(0, pc);
                            pcAdded = true;
                            break block30;
                        } else {
                            pcAdded = m_userConnEntry.userConnList.add(pc);
                        }
                        break block30;
                    }
                    pc.cachedConnectionAttributes = connAttr;
                    if (m_userConnEntry.attrConnMap == null) {
                        m_userConnEntry.attrConnMap = new HashMap();
                    }
                    if ((attrMapEntry = (Vector<OraclePooledConnection>)m_userConnEntry.attrConnMap.get(attrKey = this.buildAttrKey(connAttr))) != null) {
                        if (this.cacheUseLIFO) {
                            attrMapEntry.add(0, pc);
                            pcAdded = true;
                            break block30;
                        } else {
                            pcAdded = attrMapEntry.add(pc);
                        }
                        break block30;
                    } else {
                        attrMapEntry = new Vector<OraclePooledConnection>();
                        pcAdded = attrMapEntry.add(pc);
                        m_userConnEntry.attrConnMap.put(attrKey, attrMapEntry);
                    }
                    break block30;
                }
                m_userConnEntry = new OracleConnectionCacheEntry();
                pc.addToImplicitCache(this.userMap, m_userConnEntry);
                if (connAttr == null || connAttr != null && connAttr.isEmpty()) {
                    Vector<OraclePooledConnection> userMapEntry = new Vector<OraclePooledConnection>();
                    pcAdded = userMapEntry.add(pc);
                    m_userConnEntry.userConnList = userMapEntry;
                } else {
                    String attrKey = this.buildAttrKey(connAttr);
                    pc.cachedConnectionAttributes = connAttr;
                    HashMap userMapEntry = new HashMap();
                    Vector<OraclePooledConnection> attrMapEntry = new Vector<OraclePooledConnection>();
                    pcAdded = attrMapEntry.add(pc);
                    userMapEntry.put(attrKey, attrMapEntry);
                    m_userConnEntry.attrConnMap = userMapEntry;
                }
            }
            if (pcAdded) {
                ++this.cacheSize;
            }
            if (this.cacheConnectionWaitTimeout > 0) {
                this.notifyAll();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var9_25 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var9_26 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var11_8 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var13_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var13_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {}
        catch (Throwable throwable) {
            Object var13_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var13_12 = null;
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String buildAttrKey(Properties connAttr) throws SQLException {
        String string;
        try {
            int i2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(connAttr));
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            int sz = connAttr.keySet().size();
            Object[] origArray = connAttr.keySet().toArray();
            boolean isChanged = true;
            StringBuffer buf = new StringBuffer();
            while (isChanged) {
                isChanged = false;
                for (i2 = 0; i2 < sz - 1; ++i2) {
                    if (((String)origArray[i2]).compareTo((String)origArray[i2 + 1]) <= 0) continue;
                    isChanged = true;
                    Object tempObj = origArray[i2];
                    origArray[i2] = origArray[i2 + 1];
                    origArray[i2 + 1] = tempObj;
                }
            }
            for (i2 = 0; i2 < sz; ++i2) {
                buf.append(origArray[i2] + ATTRKEY_DELIM + connAttr.get(origArray[i2]));
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + buf.toString());
                    Object var9_11 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            string = buf.toString();
            Object var11_14 = null;
            if (!TRACE) return string;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var13_19 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var13_18 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return string;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var13_16 = null;
            OracleLog.recursiveExit();
            return string;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected OraclePooledConnection makeCacheConnection(String user, String passwd) throws SQLException {
        Object object;
        try {
            OraclePooledConnection pc;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(user) + ", " + OracleLog.argument(passwd));
                    object = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((pc = (OraclePooledConnection)this.connectionPoolDS.getPooledConnection(user, passwd)) != null) {
                if (this.cacheMaxStatementsLimit > 0) {
                    this.setStatementCaching(pc, this.cacheMaxStatementsLimit, true);
                }
                pc.registerImplicitCacheConnectionEventListener(new OracleConnectionCacheEventListener(this));
                pc.cachedConnectionAttributes = new Properties();
                if (this.fastConnectionFailoverEnabled) {
                    this.initFailoverParameters(pc);
                }
                object = this;
                synchronized (object) {
                    ++this.cacheSize;
                    if (this.fastConnectionFailoverEnabled && this.runtimeLoadBalancingThread == null) {
                        this.runtimeLoadBalancingThread = new OracleRuntimeLoadBalancingEventHandlerThread(this.dataSourceServiceName);
                        this.cacheManager.checkAndStartThread(this.runtimeLoadBalancingThread);
                    }
                }
                pc.localTxnCommitOnClose = this.cacheLocalTxnCommitOnClose;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + pc);
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            object = pc;
            Object var9_11 = null;
            if (!TRACE) return object;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_15 = null;
            }
            catch (Throwable throwable2) {
                Object var11_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return object;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatementCaching(OraclePooledConnection pc, int maxLimit, boolean flag) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc) + ", " + OracleLog.argument(maxLimit) + ", " + OracleLog.argument(flag));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (maxLimit > 0) {
                pc.setStatementCacheSize(maxLimit);
            }
            pc.setImplicitCachingEnabled(flag);
            pc.setExplicitCachingEnabled(flag);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void reusePooledConnection(PooledConnection pc) throws SQLException {
        try {
            OraclePooledConnection opc;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((opc = (OraclePooledConnection)pc) != null && opc.physicalConn != null) {
                if (opc.localTxnCommitOnClose) {
                    opc.physicalConn.commit();
                }
                this.storeCacheConnection(opc.cachedConnectionAttributes, opc);
                this.checkedOutConnectionList.removeElement(opc);
                opc.logicalHandle = null;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_13 = null;
            }
            catch (Throwable throwable2) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void closePooledConnection(PooledConnection pc) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (pc != null) {
                this.actualPooledConnectionClose((OraclePooledConnection)pc);
                if (((OraclePooledConnection)pc).closeOption == 4096) {
                    this.checkedOutConnectionList.removeElement(pc);
                }
                pc = null;
                if (this.getTotalCachedConnections() < this.cacheMinLimit) {
                    this.defaultUserPrePopulateCache(1);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable2) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void refreshCacheConnections(int mode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(mode));
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.doForEveryCachedConnection(mode);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var7_8 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_10 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void reinitializeCacheConnections(Properties cp) throws SQLException {
        int connectionsToCreate = 0;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(cp));
                    Object var7_3 = null;
                }
                catch (Throwable throwable) {
                    Object var7_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
            synchronized (oracleImplicitConnectionCache) {
                this.defaultUser = this.cacheEnabledDS.user;
                this.defaultPassword = this.cacheEnabledDS.password;
                this.fastConnectionFailoverEnabled = this.cacheEnabledDS.getFastConnectionFailoverEnabled();
                this.cleanupTimeoutThread();
                this.doForEveryCheckedOutConnection(1);
                int origCacheInitialLimit = this.cacheInitialLimit;
                int origCacheMaxLimit = this.cacheMaxLimit;
                int origCacheMaxStatementsLimit = this.cacheMaxStatementsLimit;
                this.setConnectionCacheProperties(cp);
                if (this.cacheInitialLimit > origCacheInitialLimit) {
                    connectionsToCreate = this.cacheInitialLimit - origCacheInitialLimit;
                }
                if (origCacheMaxLimit != Integer.MAX_VALUE && this.cacheMaxLimit < origCacheMaxLimit && this.cacheSize > this.cacheMaxLimit) {
                    this.connectionsToRemove = this.cacheSize - this.cacheMaxLimit;
                    this.doForEveryCachedConnection(8);
                    this.connectionsToRemove = 0;
                }
                if (this.cacheMaxStatementsLimit != origCacheMaxStatementsLimit) {
                    if (this.cacheMaxStatementsLimit == 0) {
                        this.doForEveryCachedConnection(16);
                    } else {
                        this.doForEveryCachedConnection(18);
                    }
                }
            }
            if (connectionsToCreate > 0) {
                this.defaultUserPrePopulateCache(connectionsToCreate);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var10_11 = null;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_18 = null;
            }
            catch (Throwable throwable2) {
                Object var14_19 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_16 = null;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void setConnectionCacheProperties(Properties cp) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(cp));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            try {
                if (cp != null) {
                    Properties caw;
                    String inVal = null;
                    inVal = cp.getProperty(MIN_LIMIT_KEY);
                    if (inVal != null && (this.cacheMinLimit = Integer.parseInt(inVal)) < 0) {
                        this.cacheMinLimit = 0;
                    }
                    if ((inVal = cp.getProperty(MAX_LIMIT_KEY)) != null && (this.cacheMaxLimit = Integer.parseInt(inVal)) < 0) {
                        this.cacheMaxLimit = Integer.MAX_VALUE;
                    }
                    if (this.cacheMaxLimit < this.cacheMinLimit) {
                        this.cacheMinLimit = this.cacheMaxLimit;
                    }
                    if ((inVal = cp.getProperty(INITIAL_LIMIT_KEY)) != null && (this.cacheInitialLimit = Integer.parseInt(inVal)) < 0) {
                        this.cacheInitialLimit = 0;
                    }
                    if (this.cacheInitialLimit > this.cacheMaxLimit) {
                        this.cacheInitialLimit = this.cacheMaxLimit;
                    }
                    if ((inVal = cp.getProperty(MAX_STATEMENTS_LIMIT_KEY)) != null && (this.cacheMaxStatementsLimit = Integer.parseInt(inVal)) < 0) {
                        this.cacheMaxStatementsLimit = 0;
                    }
                    if ((caw = (Properties)cp.get(ATTRIBUTE_WEIGHTS_KEY)) != null) {
                        Map.Entry<Object, Object> me2 = null;
                        int weight = 0;
                        Object inKeyObj = null;
                        for (Map.Entry<Object, Object> me2 : caw.entrySet()) {
                            inKeyObj = me2.getKey();
                            inVal = (String)caw.get(inKeyObj);
                            if (inVal == null || (weight = Integer.parseInt(inVal)) >= 0) continue;
                            caw.put(inKeyObj, DEFAULT_ATTRIBUTE_WEIGHT);
                        }
                        if (this.cacheAttributeWeights == null) {
                            this.cacheAttributeWeights = new Properties();
                        }
                        this.cacheAttributeWeights.putAll((Map<?, ?>)caw);
                    }
                    if ((inVal = cp.getProperty(INACTIVITY_TIMEOUT_KEY)) != null && (this.cacheInactivityTimeout = Integer.parseInt(inVal)) < 0) {
                        this.cacheInactivityTimeout = 0;
                    }
                    if ((inVal = cp.getProperty(TIME_TO_LIVE_TIMEOUT_KEY)) != null && (this.cacheTimeToLiveTimeout = Integer.parseInt(inVal)) < 0) {
                        this.cacheTimeToLiveTimeout = 0;
                    }
                    if ((inVal = cp.getProperty(ABANDONED_CONNECTION_TIMEOUT_KEY)) != null && (this.cacheAbandonedConnectionTimeout = Integer.parseInt(inVal)) < 0) {
                        this.cacheAbandonedConnectionTimeout = 0;
                    }
                    if ((inVal = cp.getProperty(LOWER_THRESHOLD_LIMIT_KEY)) != null) {
                        this.cacheLowerThresholdLimit = Integer.parseInt(inVal);
                        if (this.cacheLowerThresholdLimit < 0 || this.cacheLowerThresholdLimit > 100) {
                            this.cacheLowerThresholdLimit = 20;
                        }
                    }
                    if ((inVal = cp.getProperty(PROPERTY_CHECK_INTERVAL_KEY)) != null && (this.cachePropertyCheckInterval = Integer.parseInt(inVal)) < 0) {
                        this.cachePropertyCheckInterval = 900;
                    }
                    if ((inVal = cp.getProperty(VALIDATE_CONNECTION_KEY)) != null) {
                        this.cacheValidateConnection = Boolean.valueOf(inVal);
                    }
                    if ((inVal = cp.getProperty(CLOSEST_CONNECTION_MATCH_KEY)) != null) {
                        this.cacheClosestConnectionMatch = Boolean.valueOf(inVal);
                    }
                    if ((inVal = cp.getProperty(USE_LIFO_KEY)) != null) {
                        this.cacheUseLIFO = Boolean.valueOf(inVal);
                    }
                    if ((inVal = cp.getProperty(CONNECTION_WAIT_TIMEOUT_KEY)) != null && (this.cacheConnectionWaitTimeout = Integer.parseInt(inVal)) < 0) {
                        this.cacheConnectionWaitTimeout = 0;
                    }
                    if ((inVal = cp.getProperty(LOCAL_TXN_COMMIT_ON_CLOSE)) != null) {
                        this.cacheLocalTxnCommitOnClose = inVal.equalsIgnoreCase("true");
                    }
                } else {
                    this.cacheMinLimit = 0;
                    this.cacheMaxLimit = Integer.MAX_VALUE;
                    this.cacheInitialLimit = 0;
                    this.cacheMaxStatementsLimit = 0;
                    this.cacheAttributeWeights = null;
                    this.cacheInactivityTimeout = 0;
                    this.cacheTimeToLiveTimeout = 0;
                    this.cacheAbandonedConnectionTimeout = 0;
                    this.cacheLowerThresholdLimit = 20;
                    this.cachePropertyCheckInterval = 900;
                    this.cacheClosestConnectionMatch = false;
                    this.cacheValidateConnection = false;
                    this.cacheConnectionWaitTimeout = 0;
                    this.cacheLocalTxnCommitOnClose = false;
                    this.cacheUseLIFO = false;
                }
                if ((this.cacheInactivityTimeout > 0 || this.cacheTimeToLiveTimeout > 0 || this.cacheAbandonedConnectionTimeout > 0) && this.cachePropertyCheckInterval > 0) {
                    if (this.timeoutThread == null) {
                        this.timeoutThread = new OracleImplicitConnectionCacheThread(this);
                    }
                    this.cacheManager.checkAndStartThread(this.timeoutThread);
                }
                if (this.cachePropertyCheckInterval == 0) {
                    this.cleanupTimeoutThread();
                }
            }
            catch (NumberFormatException nfe) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 139 + "" + "OracleImplicitConnectionCache:setConnectionCacheProperties()" + " - NumberFormatException Occurred :" + nfe.getMessage());
                        Object var9_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 139, "OracleImplicitConnectionCache:setConnectionCacheProperties() - NumberFormatException Occurred :" + nfe.getMessage());
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_18 = null;
            }
            catch (Throwable throwable2) {
                Object var13_19 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var13_16 = null;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getConnectionCacheProperties() throws SQLException {
        Properties properties;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    properties = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Properties cacheProp = new Properties();
            cacheProp.setProperty(MIN_LIMIT_KEY, String.valueOf(this.cacheMinLimit));
            cacheProp.setProperty(MAX_LIMIT_KEY, String.valueOf(this.cacheMaxLimit));
            cacheProp.setProperty(INITIAL_LIMIT_KEY, String.valueOf(this.cacheInitialLimit));
            cacheProp.setProperty(MAX_STATEMENTS_LIMIT_KEY, String.valueOf(this.cacheMaxStatementsLimit));
            if (this.cacheAttributeWeights != null) {
                cacheProp.put(ATTRIBUTE_WEIGHTS_KEY, this.cacheAttributeWeights);
            } else {
                cacheProp.setProperty(ATTRIBUTE_WEIGHTS_KEY, "NULL");
            }
            cacheProp.setProperty(INACTIVITY_TIMEOUT_KEY, String.valueOf(this.cacheInactivityTimeout));
            cacheProp.setProperty(TIME_TO_LIVE_TIMEOUT_KEY, String.valueOf(this.cacheTimeToLiveTimeout));
            cacheProp.setProperty(ABANDONED_CONNECTION_TIMEOUT_KEY, String.valueOf(this.cacheAbandonedConnectionTimeout));
            cacheProp.setProperty(LOWER_THRESHOLD_LIMIT_KEY, String.valueOf(this.cacheLowerThresholdLimit));
            cacheProp.setProperty(PROPERTY_CHECK_INTERVAL_KEY, String.valueOf(this.cachePropertyCheckInterval));
            cacheProp.setProperty(CONNECTION_WAIT_TIMEOUT_KEY, String.valueOf(this.cacheConnectionWaitTimeout));
            cacheProp.setProperty(VALIDATE_CONNECTION_KEY, String.valueOf(this.cacheValidateConnection));
            cacheProp.setProperty(CLOSEST_CONNECTION_MATCH_KEY, String.valueOf(this.cacheClosestConnectionMatch));
            cacheProp.setProperty(LOCAL_TXN_COMMIT_ON_CLOSE, String.valueOf(this.cacheLocalTxnCommitOnClose));
            cacheProp.setProperty(USE_LIFO_KEY, String.valueOf(this.cacheUseLIFO));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + cacheProp);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            properties = cacheProp;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int testDatabaseConnection(OracleConnection conn) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int __result__ = conn.pingDatabase();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void closeConnectionCache(int mode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(mode));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.cleanupTimeoutThread();
            this.purgeCacheConnections(true, mode);
            this.connectionPoolDS = null;
            this.cacheEnabledDS = null;
            this.checkedOutConnectionList = null;
            this.userMap = null;
            this.cacheManager = null;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected synchronized void disableConnectionCache() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.disableConnectionRequest = true;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var6_7 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_9 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void enableConnectionCache() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.disableConnectionRequest = false;
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void initFailoverParameters(OraclePooledConnection pc) throws SQLException {
        try {
            LinkedList linkedList;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc));
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            String instanceNameKey = null;
            String DBUniqNameKey = null;
            String val = null;
            Properties prop = ((OracleConnection)pc.getPhysicalHandle()).getServerSessionInfo();
            val = prop.getProperty("INSTANCE_NAME");
            if (val != null) {
                instanceNameKey = pc.dataSourceInstanceNameKey = val.trim().toLowerCase().intern();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "Instance Name = " + val);
                    linkedList = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if ((val = prop.getProperty("SERVER_HOST")) != null) {
                pc.dataSourceHostNameKey = val.trim().toLowerCase().intern();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "Host Name = " + val);
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if ((val = prop.getProperty("SERVICE_NAME")) != null) {
                this.dataSourceServiceName = val.trim();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "Service Name = " + val);
                    Object var11_17 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var11_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if ((val = prop.getProperty("DATABASE_NAME")) != null) {
                DBUniqNameKey = pc.dataSourceDbUniqNameKey = val.trim().toLowerCase().intern();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "DBUniq Name = " + val);
                    Object var13_22 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var13_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.databaseInstancesList == null) {
                this.databaseInstancesList = new LinkedList();
            }
            int numInstances = this.databaseInstancesList.size();
            linkedList = this.databaseInstancesList;
            // MONITORENTER : linkedList
            OracleDatabaseInstance dbInstance = null;
            boolean found = false;
            for (int i2 = 0; i2 < numInstances; ++i2) {
                dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                if (dbInstance.databaseUniqName != DBUniqNameKey || dbInstance.instanceName != instanceNameKey) continue;
                ++dbInstance.numberOfConnectionsCount;
                found = true;
                break;
            }
            if (!found) {
                OracleDatabaseInstance tmpInstance = new OracleDatabaseInstance(DBUniqNameKey, instanceNameKey);
                ++tmpInstance.numberOfConnectionsCount;
                this.databaseInstancesList.add(tmpInstance);
            }
            // MONITOREXIT : linkedList
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var16_25 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var16_26 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var18_28 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var18_29 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var20_33 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var20_32 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var20_30 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var20_31 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processFailoverEvent(int eventType, String instNameKey, String dbUniqNameKey, String hostNameKey, String status, int card) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(eventType) + ", " + OracleLog.argument(instNameKey) + ", " + OracleLog.argument(dbUniqNameKey) + ", " + OracleLog.argument(hostNameKey) + ", " + OracleLog.argument(status) + ", " + OracleLog.argument(card));
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (eventType == 256) {
                if (status.equalsIgnoreCase("down") || status.equalsIgnoreCase("not_restarting") || status.equalsIgnoreCase("restart_failed")) {
                    ++this.downEventCount;
                    this.markDownLostConnections(true, false, instNameKey, dbUniqNameKey, hostNameKey, status);
                    this.cleanupFailoverConnections(true, false, instNameKey, dbUniqNameKey, hostNameKey, status);
                } else if (status.equalsIgnoreCase("up")) {
                    block26: {
                        if (this.downEventCount > 0) {
                            ++this.upEventCount;
                        }
                        try {
                            this.processUpEvent(card);
                        }
                        catch (Exception e2) {
                            if (!TRACE || !OracleLog.recursiveEnter()) break block26;
                            try {
                                OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_10, Integer.toHexString(this.hashCode()).toUpperCase() + " Event: " + "OracleImplicitConnectionCache:processFailoverEvent()" + " - Exception Occurred :" + e2.getMessage());
                                Object var10_11 = null;
                            }
                            catch (Throwable throwable) {
                                Object var10_12 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                    }
                    this.isEntireServiceDownProcessed = false;
                }
            } else if (eventType == 512 && status.equalsIgnoreCase("nodedown")) {
                this.markDownLostConnections(false, true, instNameKey, dbUniqNameKey, hostNameKey, status);
                this.cleanupFailoverConnections(false, true, instNameKey, dbUniqNameKey, hostNameKey, status);
            } else if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_10, Integer.toHexString(this.hashCode()).toUpperCase() + " Event: " + "OracleImplicitConnectionCache:processFailoverEvent UnKnown " + "Event:" + eventType);
                    Object var12_14 = null;
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var14_17 = null;
                }
                catch (Throwable throwable) {
                    Object var14_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var16_20 = null;
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var18_24 = null;
            }
            catch (Throwable throwable2) {
                Object var18_25 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var18_22 = null;
        }
        catch (Throwable throwable) {
            Object var18_23 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void processUpEvent(int card) throws SQLException {
        try {
            boolean isRecreate;
            int connectionsToLoadBalance;
            int selectedConnections;
            block28: {
                int totalConnections;
                block27: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(card));
                            Object var3_2 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    selectedConnections = 0;
                    connectionsToLoadBalance = 0;
                    totalConnections = this.getTotalCachedConnections();
                    isRecreate = false;
                    OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
                    // MONITORENTER : oracleImplicitConnectionCache
                    if (card <= 1) {
                        card = 2;
                    }
                    if ((selectedConnections = this.downEventCount == 0 && this.upEventCount == 0 && this.getNumberOfDefaultUserConnections() > 0 ? (int)((double)this.cacheSize * 0.25) : this.defaultUserPreFailureSize) > 0) break block27;
                    if (this.getNumberOfDefaultUserConnections() > 0) {
                        connectionsToLoadBalance = (int)((double)this.cacheSize * 0.25);
                        isRecreate = true;
                        break block28;
                    } else {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                                Object var8_10 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var8_11 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        // MONITOREXIT : oracleImplicitConnectionCache
                        Object var15_13 = null;
                        if (!TRACE) return;
                        if (!OracleLog.recursiveEnter()) return;
                        try {
                            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var17_16 = null;
                            OracleLog.recursiveExit();
                            return;
                        }
                        catch (Throwable throwable) {
                            Object var17_17 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                }
                connectionsToLoadBalance = selectedConnections / card;
                if (connectionsToLoadBalance + totalConnections > this.cacheMaxLimit) {
                    isRecreate = true;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache.processUpEvent()" + "selectedConnections=" + selectedConnections + ": connectionsToLoadBalance=" + connectionsToLoadBalance);
                    Object var10_25 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var10_26 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.downEventCount == this.upEventCount) {
                this.defaultUserPreFailureSize = 0;
                this.downEventCount = 0;
                this.upEventCount = 0;
            }
            // MONITOREXIT : oracleImplicitConnectionCache
            if (connectionsToLoadBalance > 0) {
                this.loadBalanceConnections(connectionsToLoadBalance, isRecreate);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var13_28 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var13_29 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var15_14 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var17_21 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var17_20 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {}
        catch (Throwable throwable) {
            Object var17_19 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var17_18 = null;
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void loadBalanceConnections(int connectionsToLoadBalance, boolean isRecreate) throws SQLException {
        try {
            if (OracleImplicitConnectionCache.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(connectionsToLoadBalance) + ", " + OracleLog.argument(isRecreate));
                    var4_3 = null;
                }
                catch (Throwable var3_6) {
                    var4_4 = null;
                    OracleLog.recursiveExit();
                    throw var3_6;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (isRecreate) {
                this.connectionsToRemove = connectionsToLoadBalance;
                this.doForEveryCachedConnection(8);
                this.connectionsToRemove = 0;
            }
            if (connectionsToLoadBalance <= 10) {
                try {
                    this.defaultUserPrePopulateCache(connectionsToLoadBalance);
                }
                catch (Exception e) {
                    if (!OracleImplicitConnectionCache.TRACE || !OracleLog.recursiveEnter()) ** GOTO lbl53
                    try {
                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_10, Integer.toHexString(this.hashCode()).toUpperCase() + " Event: " + "OracleImplicitConnectionCache:loadBalanceConnections():" + "defaultUserPrePopulateCache() - Exception Occurred :" + e.getMessage());
                        var6_9 = null;
                    }
                    catch (Throwable var5_11) {
                        var6_10 = null;
                        OracleLog.recursiveExit();
                        throw var5_11;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
            } else {
                val = (int)((double)connectionsToLoadBalance * 0.25);
                for (i = 0; i < 4; ++i) {
                    try {
                        this.defaultUserPrePopulateCache(val);
                        continue;
                    }
                    catch (Exception e) {
                        if (!OracleImplicitConnectionCache.TRACE || !OracleLog.recursiveEnter()) continue;
                        try {
                            OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_10, Integer.toHexString(this.hashCode()).toUpperCase() + " Event: " + "OracleImplicitConnectionCache:loadBalanceConnections()" + ":defaultUserPrePopulateCache() - Exception Occurred :" + e.getMessage());
                            var8_13 = null;
                        }
                        catch (Throwable var7_14) {
                            var8_13 = null;
                            OracleLog.recursiveExit();
                            throw var7_14;
                        }
                        OracleLog.recursiveExit();
                        {
                            continue;
                        }
                    }
                }
            }
lbl53:
            // 4 sources

            if (OracleImplicitConnectionCache.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    var10_15 = null;
                }
                catch (Throwable var9_17) {
                    var10_16 = null;
                    OracleLog.recursiveExit();
                    throw var9_17;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            var12_18 = null;
        }
        catch (Throwable var11_26) {
            var12_19 = null;
            if (OracleImplicitConnectionCache.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    var14_22 = null;
                }
                catch (Throwable var13_25) {
                    var14_23 = null;
                    OracleLog.recursiveExit();
                    throw var13_25;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw var11_26;
        }
        if (!OracleImplicitConnectionCache.TRACE || !OracleLog.recursiveEnter()) ** GOTO lbl94
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var14_20 = null;
        }
        catch (Throwable var13_24) {
            var14_21 = null;
            OracleLog.recursiveExit();
            throw var13_24;
        }
        OracleLog.recursiveExit();
lbl94:
        // 2 sources

    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumberOfDefaultUserConnections() {
        int n2;
        try {
            OracleConnectionCacheEntry occe;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int defaultUserConnections = 0;
            if (this.userMap != null && !this.userMap.isEmpty() && (occe = (OracleConnectionCacheEntry)this.userMap.get(OraclePooledConnection.generateKey(this.defaultUser, this.defaultPassword))) != null && occe.userConnList != null && !occe.userConnList.isEmpty()) {
                defaultUserConnections = occe.userConnList.size();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + defaultUserConnections);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = defaultUserConnections;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void markDownLostConnections(boolean serviceDownEvent, boolean hostDownEvent, String instNameKey, String dbUniqNameKey, String hostNameKey, String status) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(serviceDownEvent) + ", " + OracleLog.argument(hostDownEvent) + ", " + OracleLog.argument(instNameKey) + ", " + OracleLog.argument(dbUniqNameKey) + ", " + OracleLog.argument(hostNameKey) + ", " + OracleLog.argument(status));
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (!this.isEntireServiceDownProcessed) {
                if (this.userMap != null && !this.userMap.isEmpty()) {
                    Iterator i2 = this.userMap.entrySet().iterator();
                    while (i2.hasNext()) {
                        OracleConnectionCacheEntry occe;
                        boolean isDefaultUser = false;
                        Map.Entry e2 = i2.next();
                        String defaultKey = null;
                        if (this.defaultUser != null && this.defaultPassword != null) {
                            defaultKey = this.defaultUser + this.defaultPassword;
                        }
                        if (defaultKey != null && defaultKey.equalsIgnoreCase((String)e2.getKey())) {
                            isDefaultUser = true;
                        }
                        if ((occe = (OracleConnectionCacheEntry)e2.getValue()) != null && occe.userConnList != null && !occe.userConnList.isEmpty()) {
                            boolean markedDown = false;
                            for (OraclePooledConnection pc : occe.userConnList) {
                                if (serviceDownEvent) {
                                    markedDown = this.markDownConnectionsForServiceEvent(instNameKey, dbUniqNameKey, pc);
                                } else if (hostDownEvent) {
                                    markedDown = this.markDownConnectionsForHostEvent(hostNameKey, pc);
                                }
                                if (!markedDown || !isDefaultUser) continue;
                                ++this.defaultUserPreFailureSize;
                            }
                        }
                        if (occe == null || occe.attrConnMap == null || occe.attrConnMap.isEmpty()) continue;
                        for (Map.Entry me : occe.attrConnMap.entrySet()) {
                            for (OraclePooledConnection pc : (Vector)me.getValue()) {
                                if (serviceDownEvent) {
                                    this.markDownConnectionsForServiceEvent(instNameKey, dbUniqNameKey, pc);
                                    continue;
                                }
                                if (!hostDownEvent) continue;
                                this.markDownConnectionsForHostEvent(hostNameKey, pc);
                            }
                        }
                    }
                }
                if (instNameKey == null) {
                    this.isEntireServiceDownProcessed = true;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var17_20 = null;
                }
                catch (Throwable throwable) {
                    Object var17_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var19_23 = null;
        }
        catch (Throwable throwable) {
            Object var19_24 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var21_27 = null;
            }
            catch (Throwable throwable2) {
                Object var21_28 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var21_25 = null;
        }
        catch (Throwable throwable) {
            Object var21_26 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean markDownConnectionsForServiceEvent(String instanceNameKey, String dbUniqNameKey, OraclePooledConnection pc) {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(instanceNameKey) + ", " + OracleLog.argument(dbUniqNameKey) + ", " + OracleLog.argument(pc));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean markedDown = false;
            if (instanceNameKey == null || dbUniqNameKey == pc.dataSourceDbUniqNameKey && instanceNameKey == pc.dataSourceInstanceNameKey) {
                pc.connectionMarkedDown = true;
                markedDown = true;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + markedDown);
                    Object var7_9 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = markedDown;
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean markDownConnectionsForHostEvent(String hostNameKey, OraclePooledConnection pc) {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(hostNameKey) + ", " + OracleLog.argument(pc));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean markedDown = false;
            if (hostNameKey == pc.dataSourceHostNameKey) {
                pc.connectionMarkedDown = true;
                pc.needToAbort = true;
                markedDown = true;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + markedDown);
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = markedDown;
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    synchronized void cleanupFailoverConnections(boolean serviceDownEvent, boolean hostDownEvent, String instNameKey, String dbUniqNameKey, String hostNameKey, String status) {
        try {
            int sz;
            Object[] objArr;
            block32: {
                int k2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(serviceDownEvent) + ", " + OracleLog.argument(hostDownEvent) + ", " + OracleLog.argument(instNameKey) + ", " + OracleLog.argument(dbUniqNameKey) + ", " + OracleLog.argument(hostNameKey) + ", " + OracleLog.argument(status));
                        Object var8_7 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                OraclePooledConnection pc = null;
                objArr = this.checkedOutConnectionList.toArray();
                sz = this.checkedOutConnectionList.size();
                OraclePooledConnection[] abortedConnections = new OraclePooledConnection[sz];
                int abortedConnectionsCount = 0;
                for (k2 = 0; k2 < sz; ++k2) {
                    try {
                        pc = (OraclePooledConnection)objArr[k2];
                        if ((!serviceDownEvent || instNameKey != null && instNameKey != pc.dataSourceInstanceNameKey || dbUniqNameKey != pc.dataSourceDbUniqNameKey) && (!hostDownEvent || hostNameKey != pc.dataSourceHostNameKey)) continue;
                        if (pc.isSameUser(this.defaultUser, this.defaultPassword) && pc.cachedConnectionAttributes != null && pc.cachedConnectionAttributes.isEmpty()) {
                            ++this.defaultUserPreFailureSize;
                        }
                        this.checkedOutConnectionList.removeElement(pc);
                        this.abortConnection(pc);
                        pc.needToAbort = true;
                        abortedConnections[abortedConnectionsCount++] = pc;
                        continue;
                    }
                    catch (Exception e2) {
                        Object var15_20;
                        if (!TRACE || !OracleLog.recursiveEnter()) continue;
                        try {
                            OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache:cleanupFailoverConnections()" + "- Exception Occurred :" + e2.getMessage());
                            var15_20 = null;
                            OracleLog.recursiveExit();
                            continue;
                        }
                        catch (Throwable throwable) {
                            var15_20 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                }
                for (k2 = 0; k2 < abortedConnectionsCount; ++k2) {
                    try {
                        this.closeCheckedOutConnection(abortedConnections[k2], false);
                        continue;
                    }
                    catch (SQLException e3) {
                        Object var17_23;
                        if (!TRACE || !OracleLog.recursiveEnter()) continue;
                        try {
                            OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache:cleanupFailoverConnections" + "():closeCheckedOutConnection() - Exception Occurred :" + e3.getMessage());
                            var17_23 = null;
                            OracleLog.recursiveExit();
                            continue;
                        }
                        catch (Throwable throwable) {
                            var17_23 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                }
                if (this.checkedOutConnectionList.size() < sz && this.cacheConnectionWaitTimeout > 0) {
                    this.notifyAll();
                }
                try {
                    this.doForEveryCachedConnection(2);
                }
                catch (SQLException e4) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block32;
                    try {
                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache:cleanupFailoverConnections()" + ":doForEveryCachedConnection() - Exception Occurred :" + e4.getMessage());
                        Object var19_25 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var19_26 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
            }
            if (this.databaseInstancesList != null && (sz = this.databaseInstancesList.size()) > 0) {
                LinkedList linkedList = this.databaseInstancesList;
                // MONITORENTER : linkedList
                OracleDatabaseInstance dbInstance = null;
                objArr = this.databaseInstancesList.toArray();
                for (int k3 = 0; k3 < sz; ++k3) {
                    dbInstance = (OracleDatabaseInstance)objArr[k3];
                    if (dbInstance.databaseUniqName != dbUniqNameKey || dbInstance.instanceName != instNameKey) continue;
                    if (dbInstance.flag <= 3) {
                        this.dbInstancePercentTotal -= dbInstance.percent;
                    }
                    this.databaseInstancesList.remove(dbInstance);
                }
                // MONITOREXIT : linkedList
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var22_28 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var22_29 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var24_31 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var24_32 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var26_36 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var26_35 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var26_33 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var26_34 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zapRLBInfo() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.databaseInstancesList.clear();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void closeAndRemovePooledConnection(OraclePooledConnection pc) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (pc != null) {
                if (pc.needToAbort) {
                    this.abortConnection(pc);
                }
                this.actualPooledConnectionClose(pc);
                this.removeCacheConnection(pc);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable2) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortConnection(OraclePooledConnection pc) {
        try {
            block14: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc));
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                try {
                    ((OracleConnection)pc.getPhysicalHandle()).abort();
                }
                catch (Exception ex) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block14;
                    try {
                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_10, Integer.toHexString(this.hashCode()).toUpperCase() + " Event: " + "OracleImplicitConnectionCache:abortConnection()" + " - Exception Occurred :" + ex.getMessage());
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualPooledConnectionClose(OraclePooledConnection pc) throws SQLException {
        try {
            block19: {
                LinkedList linkedList;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc));
                        linkedList = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                int sz = 0;
                if (this.databaseInstancesList != null && (sz = this.databaseInstancesList.size()) > 0) {
                    linkedList = this.databaseInstancesList;
                    synchronized (linkedList) {
                        OracleDatabaseInstance dbInstance = null;
                        for (int i2 = 0; i2 < sz; ++i2) {
                            dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                            if (dbInstance.databaseUniqName != pc.dataSourceDbUniqNameKey || dbInstance.instanceName != pc.dataSourceInstanceNameKey) continue;
                            if (dbInstance.numberOfConnectionsCount <= 0) break;
                            --dbInstance.numberOfConnectionsCount;
                            break;
                        }
                    }
                }
                try {
                    ++this.connectionClosedCount;
                    pc.close();
                }
                catch (SQLException e2) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block19;
                    try {
                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache:actualPooledConnectionClose()" + " - Exception Occurred :" + e2.getMessage());
                        Object var8_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
            }
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCacheTimeToLiveTimeout() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.cacheTimeToLiveTimeout);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = this.cacheTimeToLiveTimeout;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected int getCacheInactivityTimeout() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.cacheInactivityTimeout);
                    Object var4_5 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            n2 = this.cacheInactivityTimeout;
            Object var6_8 = null;
            if (!TRACE) return n2;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return n2;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            return n2;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCachePropertyCheckInterval() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.cachePropertyCheckInterval);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = this.cachePropertyCheckInterval;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCacheAbandonedTimeout() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.cacheAbandonedConnectionTimeout);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = this.cacheAbandonedConnectionTimeout;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void processConnectionCacheCallback() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            float cachePct = (float)this.cacheMaxLimit / 100.0f;
            int expectedCacheSize = (int)((float)this.cacheLowerThresholdLimit * cachePct);
            this.releaseBasedOnPriority(1024, expectedCacheSize);
            if (this.cacheSize < expectedCacheSize) {
                this.releaseBasedOnPriority(512, expectedCacheSize);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var6_9 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_11 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void releaseBasedOnPriority(int priority, int expCacheSz) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(priority) + ", " + OracleLog.argument(expCacheSz));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object[] objArr = this.checkedOutConnectionList.toArray();
            for (int i2 = 0; i2 < objArr.length && this.cacheSize < expCacheSz; ++i2) {
                OracleConnectionCacheCallback occc;
                OraclePooledConnection pc = (OraclePooledConnection)objArr[i2];
                OracleConnection conn = null;
                if (pc != null) {
                    conn = (OracleConnection)pc.getLogicalHandle();
                }
                if (conn == null || (occc = conn.getConnectionCacheCallbackObj()) == null || conn.getConnectionCacheCallbackFlag() != 2 && conn.getConnectionCacheCallbackFlag() != 4 || priority != conn.getConnectionReleasePriority()) continue;
                Object userObj = conn.getConnectionCacheCallbackPrivObj();
                occc.releaseConnection(conn, userObj);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var10_12 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var12_15 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var14_20 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_19 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_17 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void processConnectionWaitTimeout(long waitTimeout) throws SQLException {
        try {
            block15: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(waitTimeout));
                        Object var4_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                try {
                    this.wait(waitTimeout);
                }
                catch (InterruptedException ea) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block15;
                    try {
                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache:processConnectionWaitTimeout()" + " -Got an InterruptedException:" + ea.getMessage());
                        Object var6_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_16 = null;
            }
            catch (Throwable throwable2) {
                Object var12_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processInactivityTimeout(OraclePooledConnection pc) throws SQLException {
        try {
            if (OracleImplicitConnectionCache.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc));
                    var3_2 = null;
                }
                catch (Throwable var2_4) {
                    var3_3 = null;
                    OracleLog.recursiveExit();
                    throw var2_4;
                }
                OracleLog.recursiveExit();
            }
            lastAccessedTime = pc.getLastAccessedTime();
            currentTime = System.currentTimeMillis();
            if (this.getTotalCachedConnections() > this.cacheMinLimit && currentTime - lastAccessedTime > (long)(this.cacheInactivityTimeout * 1000)) {
                if (OracleImplicitConnectionCache.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache.processInactivityTimeout()" + ":PooledConnection in cache closed:" + pc);
                        var7_7 = null;
                    }
                    catch (Throwable var6_9) {
                        var7_8 = null;
                        OracleLog.recursiveExit();
                        throw var6_9;
                    }
                    OracleLog.recursiveExit();
                }
                this.closeAndRemovePooledConnection(pc);
            }
            if (OracleImplicitConnectionCache.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    var9_10 = null;
                }
                catch (Throwable var8_12) {
                    var9_11 = null;
                    OracleLog.recursiveExit();
                    throw var8_12;
                }
                OracleLog.recursiveExit();
            }
            var11_13 = null;
            if (OracleImplicitConnectionCache.TRACE == false) return;
            ** GOTO lbl60
        }
        catch (Throwable var10_21) {
            var11_14 = null;
            if (OracleImplicitConnectionCache.TRACE == false) throw var10_21;
            if (OracleLog.recursiveEnter() == false) throw var10_21;
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var13_17 = null;
            }
            catch (Throwable var12_20) {
                var13_18 = null;
                OracleLog.recursiveExit();
                throw var12_20;
            }
lbl60:
            // 1 sources

            if (OracleLog.recursiveEnter() == false) return;
            try {}
            catch (Throwable var12_19) {
                var13_16 = null;
                OracleLog.recursiveExit();
                throw var12_19;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var13_15 = null;
            OracleLog.recursiveExit();
            return;
            OracleLog.recursiveExit();
            throw var10_21;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cleanupTimeoutThread() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.timeoutThread != null) {
                this.timeoutThread.timeToLive = false;
                if (this.timeoutThread.isSleeping) {
                    this.timeoutThread.interrupt();
                }
                this.timeoutThread = null;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable2) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void purgeCacheConnections(boolean cleanupCheckedOutConnections, int mode) {
        try {
            block16: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(cleanupCheckedOutConnections) + ", " + OracleLog.argument(mode));
                        Object var4_3 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                try {
                    if (cleanupCheckedOutConnections) {
                        this.doForEveryCheckedOutConnection(mode);
                    }
                    this.doForEveryCachedConnection(mode);
                }
                catch (SQLException e2) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block16;
                    try {
                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache:purgeCacheConnections() " + "- Got an Exception:" + e2.getMessage());
                        Object var6_7 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var8_10 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var10_13 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var12_18 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var12_17 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var12_15 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateDatabaseInstance(String dbUniqNameKey, String instNameKey, int percent, int flag) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(dbUniqNameKey) + ", " + OracleLog.argument(instNameKey) + ", " + OracleLog.argument(percent) + ", " + OracleLog.argument(flag));
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.databaseInstancesList == null) {
                this.databaseInstancesList = new LinkedList();
            }
            LinkedList linkedList = this.databaseInstancesList;
            synchronized (linkedList) {
                int numInstances = this.databaseInstancesList.size();
                boolean updated = false;
                for (int i2 = 0; i2 < numInstances; ++i2) {
                    OracleDatabaseInstance dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                    if (dbInstance.databaseUniqName != dbUniqNameKey || dbInstance.instanceName != instNameKey) continue;
                    dbInstance.percent = percent;
                    dbInstance.flag = flag;
                    updated = true;
                    break;
                }
                if (!updated) {
                    OracleDatabaseInstance tmpInstance = new OracleDatabaseInstance(dbUniqNameKey, instNameKey);
                    tmpInstance.percent = percent;
                    tmpInstance.flag = flag;
                    this.databaseInstancesList.add(tmpInstance);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var12_15 = null;
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var14_18 = null;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var16_22 = null;
            }
            catch (Throwable throwable2) {
                Object var16_23 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var16_20 = null;
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void processDatabaseInstances() throws SQLException {
        try {
            LinkedList linkedList;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    linkedList = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            OracleDatabaseInstance dbInstance = null;
            if (this.databaseInstancesList != null) {
                int i2;
                linkedList = this.databaseInstancesList;
                // MONITORENTER : linkedList
                int goodGroupSum = 0;
                boolean resetDBInstanceValues = false;
                this.useGoodGroup = false;
                int numInstances = this.databaseInstancesList.size();
                for (i2 = 0; i2 < numInstances; ++i2) {
                    Object var8_10;
                    dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                    if (dbInstance.flag <= 3) {
                        goodGroupSum += dbInstance.percent;
                    }
                    if (!TRACE || !OracleLog.recursiveEnter()) continue;
                    try {
                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB) OracleImplicitConnectionCache." + "processDatabaseInstances:" + " <<< ServiceName=" + this.dataSourceServiceName + ", Connections to " + dbInstance.instanceName + " = " + dbInstance.numberOfConnectionsCount + ", Attempted Connection" + " Requests to this instance=" + dbInstance.attemptedConnRequestCount + ", Total Connections=" + this.getTotalCachedConnections() + " >>>");
                        var8_10 = null;
                        OracleLog.recursiveExit();
                        continue;
                    }
                    catch (Throwable throwable) {
                        var8_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                if (goodGroupSum > 0) {
                    this.dbInstancePercentTotal = goodGroupSum;
                    this.useGoodGroup = true;
                }
                if (numInstances > 1) {
                    for (i2 = 0; i2 < numInstances; this.countTotal += dbInstance.attemptedConnRequestCount, ++i2) {
                        dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                    }
                    if (this.countTotal > numInstances * 1000) {
                        for (i2 = 0; i2 < numInstances; ++i2) {
                            dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                            float ACRRatio = (float)dbInstance.attemptedConnRequestCount / (float)this.countTotal;
                            float connRatio = (float)dbInstance.numberOfConnectionsCount / (float)this.getTotalCachedConnections();
                            if (TRACE && OracleLog.recursiveEnter()) {
                                Object var10_14;
                                try {
                                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleImplicitConnectionCache." + "processDatabaseInstances() \n Total ACR count since last" + " gravitation=" + this.countTotal + "\nNumberofInstances=" + numInstances + "\nInstanceName=" + dbInstance.instanceName + "\nAttemptedConnectionRequestRatio=" + ACRRatio + "\nConnectionRequestRatio=" + connRatio);
                                    var10_14 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    var10_14 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            if (!(connRatio > ACRRatio * 2.0f)) continue;
                            if (TRACE && OracleLog.recursiveEnter()) {
                                Object var12_15;
                                try {
                                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleImplicitConnectionCache." + "processDatabaseInstances: For Instance being retired::" + "\nInstanceName=" + dbInstance.instanceName + "\nAttemptedConnectionRequestRatio=" + ACRRatio + "\nConnectionRequestRatio=" + connRatio);
                                    var12_15 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    var12_15 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            if ((int)((double)dbInstance.numberOfConnectionsCount * 0.25) >= 1) {
                                this.instancesToRetireQueue.addElement(dbInstance);
                            }
                            resetDBInstanceValues = true;
                        }
                        if (resetDBInstanceValues) {
                            for (i2 = 0; i2 < numInstances; ++i2) {
                                dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                                dbInstance.attemptedConnRequestCount = 0;
                            }
                            resetDBInstanceValues = false;
                        }
                    }
                }
                // MONITOREXIT : linkedList
                if (this.instancesToRetireQueue.size() > 0) {
                    if (this.gravitateCacheThread != null) {
                        block38: {
                            try {
                                this.gravitateCacheThread.interrupt();
                                this.gravitateCacheThread.join();
                            }
                            catch (InterruptedException ie) {
                                if (!TRACE || !OracleLog.recursiveEnter()) break block38;
                                try {
                                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache:processDatabaseInstances" + "() - Got an InterruptedException:" + ie.getMessage());
                                    Object var15_18 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    Object var15_19 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                        }
                        this.gravitateCacheThread = null;
                    }
                    this.gravitateCacheThread = new OracleGravitateConnectionCacheThread(this);
                    this.cacheManager.checkAndStartThread(this.gravitateCacheThread);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var17_21 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var17_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var19_24 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var19_25 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var21_29 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var21_28 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var21_26 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var21_27 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void gravitateCache() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
            }
            while (this.instancesToRetireQueue.size() > 0) {
                block26: {
                    this.instanceToRetire = (OracleDatabaseInstance)this.instancesToRetireQueue.remove(0);
                    this.retireConnectionsCount = (int)((double)this.instanceToRetire.numberOfConnectionsCount * 0.25);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        Object var4_7;
                        try {
                            OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleImplicitConnectionCache.gravitateCache() :" + " Available conns to retire from: " + this.instanceToRetire.instanceName + " = " + this.retireConnectionsCount);
                            var4_7 = null;
                        }
                        catch (Throwable throwable) {
                            var4_7 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                    }
                    try {
                        this.doForEveryCachedConnection(24);
                    }
                    catch (SQLException e2) {
                        Object var6_8;
                        if (!TRACE || !OracleLog.recursiveEnter()) break block26;
                        try {
                            OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleImplicitConnectionCache.gravitateCache():" + "doForEveryCachedConnection() - Got a SQLException:" + e2.getMessage());
                            var6_8 = null;
                        }
                        catch (Throwable throwable) {
                            var6_8 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                    }
                }
                if (this.retireConnectionsCount <= 0) continue;
                if (TRACE && OracleLog.recursiveEnter()) {
                    Object var8_9;
                    try {
                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleImplicitConnectionCache.gravitateCache():" + " checkedout conns to retire from: " + this.instanceToRetire.instanceName + " = " + this.retireConnectionsCount);
                        var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        var8_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                }
                try {
                    this.doForEveryCheckedOutConnection(24);
                }
                catch (SQLException e3) {
                    Object var10_10;
                    if (!TRACE || !OracleLog.recursiveEnter()) continue;
                    try {
                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleImplicitConnectionCache.gravitateCache():" + "doForEveryCheckedOutConnection() - Got an SQLException:" + e3.getMessage());
                        var10_10 = null;
                    }
                    catch (Throwable throwable) {
                        var10_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                }
            }
            this.retireConnectionsCount = 0;
            this.instanceToRetire = null;
            this.countTotal = 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var12_15 = null;
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
            }
            Object var14_18 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var16_23 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var16_22 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var16_20 = null;
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void cleanupRLBThreads() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.gravitateCacheThread != null) {
                block21: {
                    try {
                        this.gravitateCacheThread.interrupt();
                        this.gravitateCacheThread.join();
                    }
                    catch (InterruptedException ie) {
                        if (!TRACE || !OracleLog.recursiveEnter()) break block21;
                        try {
                            OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleImplicitConnectionCache.cleanupRLBThreads()" + " - Got an InterruptedException:" + ie.getMessage());
                            Object var4_6 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var4_7 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                }
                this.gravitateCacheThread = null;
            }
            if (this.runtimeLoadBalancingThread != null) {
                block22: {
                    try {
                        this.runtimeLoadBalancingThread.interrupt();
                    }
                    catch (Exception e2) {
                        if (!TRACE || !OracleLog.recursiveEnter()) break block22;
                        try {
                            OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleImplicitConnectionCache.cleanupRLBThreads()" + " - Got an Exception:" + e2.getMessage());
                            Object var6_9 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var6_10 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                }
                this.runtimeLoadBalancingThread = null;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var8_12 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var10_15 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var12_20 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var12_19 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var12_17 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getStatistics() throws SQLException {
        HashMap<String, Integer> hashMap;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    hashMap = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            HashMap<String, Integer> map = new HashMap<String, Integer>(2);
            map.put("PhysicalConnectionClosedCount", new Integer(this.connectionClosedCount));
            map.put("PhysicalConnectionCreatedCount", new Integer(this.connectionCreatedCount));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + map);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            hashMap = map;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        OracleConnection oracleConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleConnection = null;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleConnection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleImplicitConnectionCache"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

