/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jdbc.xa.client.OracleXADataSource;

public class OracleDataSourceFactory
implements ObjectFactory {
    private static final String CONNECTION_CACHING_ENABLED = "connectionCachingEnabled";
    private static final String CONNECTION_CACHE_NAME = "connectionCacheName";
    private static final String CONNECTION_CACHE_PROPERTIES = "connectionCacheProperties";
    private static final String CONNECTION_PROPERTIES = "connectionProperties";
    private static final String FAST_CONNECTION_FAILOVER_ENABLED = "fastConnectionFailoverEnabled";
    private static final String ONS_CONFIG_STR = "onsConfigStr";
    private static final String ORACLE_CONN_DATA_POOL_SOURCE = "oracle.jdbc.pool.OracleConnectionPoolDataSource";
    private static final String ORACLE_OCI_CONN_POOL = "oracle.jdbc.pool.OracleOCIConnectionPool";
    private static final String ORACLE_DATA_SOURCE = "oracle.jdbc.pool.OracleDataSource";
    private static final String ORACLE_XA_DATA_SOURCE = "oracle.jdbc.xa.client.OracleXADataSource";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws Exception {
        StringRefAddr st;
        Properties info;
        String cn;
        OracleDataSource ods;
        Reference ref;
        block54: {
            Object pn_conn_min_limit2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDataSourceFactory.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(refObj) + ", " + OracleLog.argument(name) + ", " + OracleLog.argument(nameCtx) + ", " + OracleLog.argument(env));
                        Object var6_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                ref = (Reference)refObj;
                ods = null;
                cn = ref.getClassName();
                info = new Properties();
                if (cn.equals(ORACLE_DATA_SOURCE) || cn.equals(ORACLE_XA_DATA_SOURCE)) {
                    String isFailoverEnabled;
                    Properties props;
                    String val;
                    String isCacheEnabled;
                    ods = cn.equals(ORACLE_DATA_SOURCE) ? new OracleDataSource() : new OracleXADataSource();
                    st = null;
                    st = (StringRefAddr)ref.get(CONNECTION_CACHING_ENABLED);
                    if (st != null && (isCacheEnabled = (String)st.getContent()).equals(String.valueOf("true"))) {
                        ods.setConnectionCachingEnabled(true);
                    }
                    if ((st = (StringRefAddr)ref.get(CONNECTION_CACHE_NAME)) != null) {
                        ods.setConnectionCacheName((String)st.getContent());
                    }
                    if ((st = (StringRefAddr)ref.get(CONNECTION_CACHE_PROPERTIES)) != null) {
                        val = (String)st.getContent();
                        props = this.extractConnectionCacheProperties(val);
                        ods.setConnectionCacheProperties(props);
                    }
                    if ((st = (StringRefAddr)ref.get(CONNECTION_PROPERTIES)) != null) {
                        val = (String)st.getContent();
                        props = this.extractConnectionProperties(val);
                        ods.setConnectionProperties(props);
                    }
                    if ((st = (StringRefAddr)ref.get(FAST_CONNECTION_FAILOVER_ENABLED)) != null && (isFailoverEnabled = (String)st.getContent()).equals(String.valueOf("true"))) {
                        ods.setFastConnectionFailoverEnabled(true);
                    }
                    if ((st = (StringRefAddr)ref.get(ONS_CONFIG_STR)) != null) {
                        ods.setONSConfiguration((String)st.getContent());
                    }
                    break block54;
                }
                if (cn.equals(ORACLE_CONN_DATA_POOL_SOURCE)) {
                    ods = new OracleConnectionPoolDataSource();
                    break block54;
                }
                if (cn.equals(ORACLE_OCI_CONN_POOL)) {
                    ods = new OracleOCIConnectionPool();
                    String pn_conn_min_limit2 = null;
                    String pn_conn_max_limit = null;
                    String pn_conn_increment = null;
                    String pn_conn_active_size = null;
                    String pn_conn_pool_size = null;
                    String pn_conn_timeout = null;
                    String pn_conn_nowait = null;
                    StringRefAddr st2 = null;
                    Object pn = null;
                    String pn_txn_dist = null;
                    st2 = (StringRefAddr)ref.get("connpool_min_limit");
                    if (st2 != null) {
                        pn_conn_min_limit2 = (String)st2.getContent();
                    }
                    if ((st2 = (StringRefAddr)ref.get("connpool_max_limit")) != null) {
                        pn_conn_max_limit = (String)st2.getContent();
                    }
                    if ((st2 = (StringRefAddr)ref.get("connpool_increment")) != null) {
                        pn_conn_increment = (String)st2.getContent();
                    }
                    if ((st2 = (StringRefAddr)ref.get("connpool_active_size")) != null) {
                        pn_conn_active_size = (String)st2.getContent();
                    }
                    if ((st2 = (StringRefAddr)ref.get("connpool_pool_size")) != null) {
                        pn_conn_pool_size = (String)st2.getContent();
                    }
                    if ((st2 = (StringRefAddr)ref.get("connpool_timeout")) != null) {
                        pn_conn_timeout = (String)st2.getContent();
                    }
                    if ((st2 = (StringRefAddr)ref.get("connpool_nowait")) != null) {
                        pn_conn_nowait = (String)st2.getContent();
                    }
                    if ((st2 = (StringRefAddr)ref.get("transactions_distributed")) != null) {
                        pn_txn_dist = (String)st2.getContent();
                    }
                    info.put("connpool_min_limit", pn_conn_min_limit2);
                    info.put("connpool_max_limit", pn_conn_max_limit);
                    info.put("connpool_increment", pn_conn_increment);
                    info.put("connpool_active_size", pn_conn_active_size);
                    info.put("connpool_pool_size", pn_conn_pool_size);
                    info.put("connpool_timeout", pn_conn_timeout);
                    if (pn_conn_nowait == "true") {
                        info.put("connpool_nowait", pn_conn_nowait);
                    }
                    if (pn_txn_dist == "true") {
                        info.put("transactions_distributed", pn_txn_dist);
                    }
                    break block54;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDataSourceFactory.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        Object var20_23 = null;
                    }
                    catch (Throwable throwable) {
                        Object var20_24 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                pn_conn_min_limit2 = null;
                Object var24_26 = null;
            }
            catch (Throwable throwable) {
                Object var24_28 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDataSourceFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var26_33 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var26_34 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSourceFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var26_29 = null;
                }
                catch (Throwable throwable) {
                    Object var26_30 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return pn_conn_min_limit2;
        }
        if (ods != null) {
            st = null;
            st = (StringRefAddr)ref.get("url");
            if (st != null) {
                ods.setURL((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("userName")) != null || (st = (StringRefAddr)ref.get("u")) != null || (st = (StringRefAddr)ref.get("user")) != null) {
                ods.setUser((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("passWord")) != null || (st = (StringRefAddr)ref.get("password")) != null) {
                ods.setPassword((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("description")) != null || (st = (StringRefAddr)ref.get("describe")) != null) {
                ods.setDescription((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("driverType")) != null || (st = (StringRefAddr)ref.get("driver")) != null) {
                ods.setDriverType((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("serverName")) != null || (st = (StringRefAddr)ref.get("host")) != null) {
                ods.setServerName((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("databaseName")) != null || (st = (StringRefAddr)ref.get("sid")) != null) {
                ods.setDatabaseName((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("serviceName")) != null) {
                ods.setServiceName((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("networkProtocol")) != null || (st = (StringRefAddr)ref.get("protocol")) != null) {
                ods.setNetworkProtocol((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("portNumber")) != null || (st = (StringRefAddr)ref.get("port")) != null) {
                String pn = (String)st.getContent();
                ods.setPortNumber(Integer.parseInt(pn));
            }
            if ((st = (StringRefAddr)ref.get("tnsentryname")) != null || (st = (StringRefAddr)ref.get("tns")) != null) {
                ods.setTNSEntryName((String)st.getContent());
            } else if (cn.equals(ORACLE_OCI_CONN_POOL)) {
                String pn_is_poolCreated = null;
                st = (StringRefAddr)ref.get("connpool_is_poolcreated");
                if (st != null) {
                    pn_is_poolCreated = (String)st.getContent();
                }
                if (pn_is_poolCreated.equals(String.valueOf("true"))) {
                    ((OracleOCIConnectionPool)ods).setPoolConfig(info);
                }
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleDataSourceFactory.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ods);
                Object var22_38 = null;
            }
            catch (Throwable throwable) {
                Object var22_39 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        OracleDataSource oracleDataSource = ods;
        Object var24_27 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleDataSourceFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var26_31 = null;
            }
            catch (Throwable throwable) {
                Object var26_32 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private Properties extractConnectionCacheProperties(String val) throws SQLException {
        Object object;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSourceFactory.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(val));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Properties cprops = new Properties();
            int awIdx = (val = val.substring(1, val.length() - 1)).indexOf("AttributeWeights", 0);
            if (awIdx >= 0) {
                StringTokenizer strTokens1;
                if (val.charAt(awIdx + 16) != '=' || awIdx > 0 && val.charAt(awIdx - 1) != ' ') {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleDataSourceFactory.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 139);
                            Object var5_7 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_8 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 139);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                Properties awProps = new Properties();
                int awLastIdx = val.indexOf("}", awIdx);
                String tmpawStr = val.substring(awIdx, awLastIdx);
                String awStr = tmpawStr.substring(18);
                StringTokenizer stringTokenizer = strTokens1 = new StringTokenizer(awStr, ", ");
                synchronized (stringTokenizer) {
                    while (strTokens1.hasMoreTokens()) {
                        String strTkn = strTokens1.nextToken();
                        int len = strTkn.length();
                        int equalsIndex = strTkn.indexOf("=");
                        String key = strTkn.substring(0, equalsIndex);
                        String value = strTkn.substring(equalsIndex + 1, len);
                        awProps.setProperty(key, value);
                    }
                }
                cprops.put("AttributeWeights", awProps);
                if (awIdx > 0 && awLastIdx + 1 == val.length()) {
                    val = val.substring(0, awIdx - 2);
                } else if (awIdx > 0 && awLastIdx + 1 < val.length()) {
                    String valA = val.substring(0, awIdx - 2);
                    String valB = val.substring(awLastIdx + 1, val.length());
                    val = valA.concat(valB);
                } else {
                    val = val.substring(awLastIdx + 2, val.length());
                }
            }
            StringTokenizer strTokens2 = new StringTokenizer(val, ", ");
            object = strTokens2;
            synchronized (object) {
                while (strTokens2.hasMoreTokens()) {
                    String strTkn = strTokens2.nextToken();
                    int len = strTkn.length();
                    int equalsIndex = strTkn.indexOf("=");
                    String key = strTkn.substring(0, equalsIndex);
                    String value = strTkn.substring(equalsIndex + 1, len);
                    cprops.setProperty(key, value);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSourceFactory.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + cprops);
                    Object var18_27 = null;
                }
                catch (Throwable throwable) {
                    Object var18_28 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            object = cprops;
            Object var20_30 = null;
        }
        catch (Throwable throwable) {
            Object var20_31 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSourceFactory.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var22_34 = null;
                }
                catch (Throwable throwable2) {
                    Object var22_35 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleDataSourceFactory.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var22_32 = null;
            }
            catch (Throwable throwable) {
                Object var22_33 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties extractConnectionProperties(String val) throws SQLException {
        Properties properties;
        try {
            String[] tokens;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSourceFactory.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(val));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Properties cprops = new Properties();
            val = val.substring(1, val.length() - 1);
            for (String strTkn : tokens = val.split(";")) {
                int len = strTkn.length();
                int equalsIndex = strTkn.indexOf("=");
                if (len == 0 || equalsIndex <= 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        Object var11_14;
                        try {
                            OracleDataSourceFactory.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 190);
                            var11_14 = null;
                        }
                        catch (Throwable throwable) {
                            var11_14 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                String key = strTkn.substring(0, equalsIndex);
                String value = strTkn.substring(equalsIndex + 1, len);
                cprops.setProperty(key.trim(), value.trim());
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSourceFactory.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + cprops);
                    Object var13_15 = null;
                }
                catch (Throwable throwable) {
                    Object var13_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            properties = cprops;
            Object var15_18 = null;
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSourceFactory.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var17_22 = null;
                }
                catch (Throwable throwable2) {
                    Object var17_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleDataSourceFactory.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var17_20 = null;
            }
            catch (Throwable throwable) {
                Object var17_21 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        OracleConnection oracleConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSourceFactory.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSourceFactory.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleConnection = null;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSourceFactory.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleDataSourceFactory.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleConnection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleDataSourceFactory"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

