/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.TypeTreeElement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.SQLName;
import oracle.sql.StructDescriptor;

public class OracleTypeCOLLECTION
extends OracleTypeADT
implements Serializable {
    static final long serialVersionUID = -7279638692691669378L;
    public static final int TYPE_PLSQL_INDEX_TABLE = 1;
    public static final int TYPE_NESTED_TABLE = 2;
    public static final int TYPE_VARRAY = 3;
    int userCode;
    long maxSize;
    OracleType elementType;
    static final int CURRENT_USER_OBJECT = 0;
    static final int CURRENT_USER_SYNONYM = 1;
    static final int CURRENT_USER_SYNONYM_10g = 2;
    static final int CURRENT_USER_PUBLIC_SYNONYM = 3;
    static final int CURRENT_USER_PUBLIC_SYNONYM_10g = 4;
    static final int POSSIBLY_OTHER_USER_OBJECT = 5;
    static final int POSSIBLY_OTHER_USER_OBJECT_10g = 6;
    static final int OTHER_USER_OBJECT = 7;
    static final int OTHER_USER_SYNONYM = 8;
    static final int PUBLIC_SYNONYM = 9;
    static final int PUBLIC_SYNONYM_10g = 10;
    static final int BREAK = 11;
    static final String[] sqlString = new String[]{"SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME = :1", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME in (SELECT TABLE_NAME FROM USER_SYNONYMS START WITH SYNONYM_NAME = :1 CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME UNION SELECT :1 FROM DUAL) ", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME in (SELECT TABLE_NAME FROM USER_SYNONYMS START WITH SYNONYM_NAME = :1 CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME UNION SELECT :1 FROM DUAL) ", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM USER_SYNONYMS START WITH SYNONYM_NAME = :tname CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME UNION SELECT :tname FROM DUAL)", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM USER_SYNONYMS START WITH SYNONYM_NAME = :tname CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME UNION SELECT :tname FROM DUAL)", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE OWNER = :1 AND TYPE_NAME = :2", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE OWNER = (SELECT TABLE_OWNER FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:1) AND TYPE_NAME = (SELECT TABLE_NAME FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:2) ", "DECLARE   the_owner VARCHAR2(100);   the_type  VARCHAR2(100); begin  SELECT TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;", "DECLARE   the_owner VARCHAR2(100);   the_type  VARCHAR2(100); begin  SELECT TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;"};
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleTypeCOLLECTION(String sql_name, OracleConnection conn) throws SQLException {
        block12: {
            super(sql_name, (Connection)conn);
            this.userCode = 0;
            this.maxSize = 0L;
            this.elementType = null;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    OracleTypeCOLLECTION.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(sql_name) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleTypeCOLLECTION(OracleTypeADT parent, int idx, OracleConnection conn) throws SQLException {
        block12: {
            super(parent, idx, (Connection)conn);
            this.userCode = 0;
            this.maxSize = 0L;
            this.elementType = null;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    OracleTypeCOLLECTION.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(parent) + ", " + OracleLog.argument(idx) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleTypeCOLLECTION(SQLName sqlName, byte[] typoid, int version, byte[] tds, OracleConnection conn) throws SQLException {
        block12: {
            super(sqlName, typoid, version, tds, conn);
            this.userCode = 0;
            this.maxSize = 0L;
            this.elementType = null;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(sqlName) + ", " + OracleLog.argument(typoid) + ", " + OracleLog.argument(version) + ", " + OracleLog.argument(tds) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (value != null) {
                if (value instanceof ARRAY) {
                    ARRAY __result__ = (ARRAY)value;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    ARRAY aRRAY = __result__;
                    return aRRAY;
                }
                ArrayDescriptor desc = this.createArrayDescriptor();
                ARRAY __result__ = new ARRAY(desc, this.connection, value);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ARRAY aRRAY = __result__;
                return aRRAY;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum datum = null;
            return datum;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTypeCode() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 2003);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = 2003;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInHierarchyOf(OracleType anOracleType) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(anOracleType));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (anOracleType == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            if (anOracleType == this) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = true;
                return bl;
            }
            if (anOracleType.getClass() != this.getClass()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            boolean __result__ = anOracleType.getTypeDescriptor().getName().equals(this.descriptor.getName());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInHierarchyOf(StructDescriptor aStructDescriptor) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(aStructDescriptor));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isObjectType() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseTDSrec(TDSReader tdsReader) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long elementPos = tdsReader.readLong();
            this.maxSize = tdsReader.readLong();
            this.userCode = tdsReader.readByte();
            tdsReader.addSimplePatch(elementPos, this);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum unlinearize(byte[] pickled_bytes, long offset, Datum container, int type, Map objmap) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pickled_bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(objmap));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum __result__ = this.unlinearize(pickled_bytes, offset, container, 1L, -1, type, objmap);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum datum = __result__;
            return datum;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum unlinearize(byte[] pickled_bytes, long offset, Datum container, long idx, int cnt, int style, Map objmap) throws SQLException {
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pickled_bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(idx) + ", " + OracleLog.argument(cnt) + ", " + OracleLog.argument(style) + ", " + OracleLog.argument(objmap));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection mc = this.getConnection();
            Datum ret = null;
            if (mc == null) {
                ret = this.unlinearizeInternal(pickled_bytes, offset, container, idx, cnt, style, objmap);
            } else {
                object = mc;
                synchronized (object) {
                    ret = this.unlinearizeInternal(pickled_bytes, offset, container, idx, cnt, style, objmap);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            object = ret;
            return object;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Datum unlinearizeInternal(byte[] pickled_bytes, long offset, Datum container, long idx, int cnt, int style, Map objmap) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pickled_bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(idx) + ", " + OracleLog.argument(cnt) + ", " + OracleLog.argument(style) + ", " + OracleLog.argument(objmap));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (pickled_bytes == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Datum datum = null;
                return datum;
            }
            PickleContext context = new PickleContext(pickled_bytes, offset);
            ARRAY __result__ = this.unpickle81(context, (ARRAY)container, idx, cnt, 1, style, objmap);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ARRAY aRRAY = __result__;
            return aRRAY;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isInlineImage(byte[] pickled_bytes, int offset) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pickled_bytes) + ", " + OracleLog.argument(offset));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (pickled_bytes == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            if (PickleContext.isCollectionImage_pctx(pickled_bytes[offset])) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = true;
                return bl;
            }
            if (PickleContext.isDegenerateImage_pctx(pickled_bytes[offset])) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Image is not a collection image");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not a collection image");
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int pickle81(PickleContext ctx, Datum datum) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(ctx) + ", " + OracleLog.argument(datum));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ARRAY data = (ARRAY)datum;
            boolean inline = data.hasDataSeg();
            int imglen = 0;
            int lenOffset = ctx.offset() + 2;
            if (inline) {
                if (!this.metaDataInitialized) {
                    this.copy_properties((OracleTypeCOLLECTION)data.getDescriptor().getPickler());
                }
                Datum[] dataValues = data.getOracleArray();
                if (this.userCode == 3 && (long)dataValues.length > this.maxSize) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeCOLLECTION.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 71 + null);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 71, null);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                imglen += ctx.writeCollImageHeader(dataValues.length, this.typeVersion);
                for (int ctr = 0; ctr < dataValues.length; ++ctr) {
                    imglen = dataValues[ctr] == null ? (imglen += ctx.writeElementNull()) : (imglen += this.elementType.pickle81(ctx, dataValues[ctr]));
                    if (!TRACE || !OracleLog.recursiveEnter()) continue;
                    try {
                        OracleTypeCOLLECTION.logger().log(Level.FINEST, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "idx=" + ctr + " is " + dataValues[ctr]);
                        continue;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            } else {
                imglen += ctx.writeCollImageHeader(data.getLocator());
            }
            ctx.patchImageLen(lenOffset, imglen);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + imglen);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = imglen;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ARRAY unpickle81(PickleContext context, ARRAY container, int style, int elemStyle, Map elemMap) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(context) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(style) + ", " + OracleLog.argument(elemStyle) + ", " + OracleLog.argument(elemMap));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ARRAY __result__ = this.unpickle81(context, container, 1L, -1, style, elemStyle, elemMap);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ARRAY aRRAY = __result__;
            return aRRAY;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ARRAY unpickle81(PickleContext context, ARRAY container, long beginIdx, int count, int style, int elemStyle, Map elemMap) throws SQLException {
        try {
            ARRAY coll_obj;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(context) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(style) + ", " + OracleLog.argument(elemStyle) + ", " + OracleLog.argument(elemMap));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((coll_obj = container) == null) {
                ArrayDescriptor desc = this.createArrayDescriptor();
                coll_obj = new ARRAY(desc, (byte[])null, this.connection);
            }
            if (this.unpickle81ImgHeader(context, coll_obj, style, elemStyle)) {
                if (beginIdx == 1L && count == -1) {
                    this.unpickle81ImgBody(context, coll_obj, elemStyle, elemMap);
                } else {
                    this.unpickle81ImgBody(context, coll_obj, beginIdx, count, elemStyle, elemMap);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + coll_obj);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ARRAY aRRAY = coll_obj;
            return aRRAY;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unpickle81ImgHeader(PickleContext context, ARRAY container, int style, int elemStyle) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(context) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(style) + ", " + OracleLog.argument(elemStyle));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean inline = true;
            if (style == 3) {
                container.setImage(context.image(), context.absoluteOffset(), 0L);
            }
            byte flags = context.readByte();
            if (!PickleContext.is81format(flags)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Image is not in 8.1 format");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not in 8.1 format");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (!PickleContext.hasPrefix(flags)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Image has no prefix segment");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image has no prefix segment");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (PickleContext.isCollectionImage_pctx(flags)) {
                inline = true;
            } else if (PickleContext.isDegenerateImage_pctx(flags)) {
                inline = false;
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Image is not a collection image");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not a collection image");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            context.readByte();
            if (style == 9) {
                context.skipBytes(context.readLength(true) - 2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean __ex__ = false;
                return __ex__;
            }
            if (style == 3) {
                long length = context.readLength();
                container.setImageLength(length);
                context.skipTo(container.getImageOffset() + length);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            context.skipLength();
            int psegLen = context.readLength();
            container.setPrefixFlag(context.readByte());
            if (container.isInline()) {
                context.readDataValue(psegLen - 1);
            } else {
                container.setLocator(context.readDataValue(psegLen - 1));
            }
            boolean __result__ = container.isInline();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unpickle81ImgBody(PickleContext context, ARRAY container, long beginIdx, int count, int elemStyle, Map elemMap) throws SQLException {
        try {
            boolean cacheAll;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(context) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(elemStyle) + ", " + OracleLog.argument(elemMap));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            context.readByte();
            int coll_len = context.readLength();
            container.setLength(coll_len);
            if (elemStyle == 0) {
                return;
            }
            int length = (int)this.getAccessLength(coll_len, beginIdx, count);
            boolean bl = cacheAll = ArrayDescriptor.getCacheStyle(container) == 1;
            if (beginIdx > 1L && length > 0) {
                long lastIdx = container.getLastIndex();
                if (lastIdx < beginIdx) {
                    if (lastIdx > 0L) {
                        context.skipTo(container.getLastOffset());
                    } else {
                        lastIdx = 1L;
                    }
                    if (cacheAll) {
                        for (long i2 = lastIdx; i2 < beginIdx; ++i2) {
                            container.setIndexOffset(i2, context.offset());
                            this.elementType.unpickle81rec(context, 9, null);
                        }
                    } else {
                        for (long i3 = lastIdx; i3 < beginIdx; ++i3) {
                            this.elementType.unpickle81rec(context, 9, null);
                        }
                    }
                } else if (lastIdx > beginIdx) {
                    long offset = container.getOffset(beginIdx);
                    if (offset != -1L) {
                        context.skipTo(offset);
                    } else if (cacheAll) {
                        int i4 = 1;
                        while ((long)i4 < beginIdx) {
                            container.setIndexOffset(i4, context.offset());
                            this.elementType.unpickle81rec(context, 9, null);
                            ++i4;
                        }
                    } else {
                        int i5 = 1;
                        while ((long)i5 < beginIdx) {
                            this.elementType.unpickle81rec(context, 9, null);
                            ++i5;
                        }
                    }
                } else {
                    context.skipTo(container.getLastOffset());
                }
                container.setLastIndexOffset(beginIdx, context.offset());
            }
            this.unpickle81ImgBodyElements(context, container, (int)beginIdx, length, elemStyle, elemMap);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unpickle81ImgBody(PickleContext context, ARRAY container, int elemStyle, Map elemMap) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(context) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(elemStyle) + ", " + OracleLog.argument(elemMap));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            context.readByte();
            int length = context.readLength();
            container.setLength(length);
            if (elemStyle == 0) {
                return;
            }
            this.unpickle81ImgBodyElements(context, container, 1, length, elemStyle, elemMap);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpickle81ImgBodyElements(PickleContext context, ARRAY container, int beginIdx, int length, int elemStyle, Map elemMap) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(context) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(length) + ", " + OracleLog.argument(elemStyle) + ", " + OracleLog.argument(elemMap));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean cacheAll = ArrayDescriptor.getCacheStyle(container) == 1;
            switch (elemStyle) {
                case 1: {
                    Datum[] datumArray = new Datum[length];
                    if (cacheAll) {
                        for (int i2 = 0; i2 < length; ++i2) {
                            container.setIndexOffset(beginIdx + i2, context.offset());
                            datumArray[i2] = (Datum)this.elementType.unpickle81rec(context, elemStyle, elemMap);
                        }
                    } else {
                        for (int i3 = 0; i3 < length; ++i3) {
                            datumArray[i3] = (Datum)this.elementType.unpickle81rec(context, elemStyle, elemMap);
                        }
                    }
                    container.setDatumArray(datumArray);
                    break;
                }
                case 2: {
                    Object[] darray = ArrayDescriptor.makeJavaArray(length, this.elementType.getTypeCode());
                    if (cacheAll) {
                        for (int i4 = 0; i4 < length; ++i4) {
                            container.setIndexOffset(beginIdx + i4, context.offset());
                            darray[i4] = this.elementType.unpickle81rec(context, elemStyle, elemMap);
                        }
                    } else {
                        for (int i5 = 0; i5 < length; ++i5) {
                            darray[i5] = this.elementType.unpickle81rec(context, elemStyle, elemMap);
                        }
                    }
                    container.setObjArray(darray);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (this.elementType instanceof OracleTypeNUMBER || this.elementType instanceof OracleTypeFLOAT) {
                        container.setObjArray(OracleTypeNUMBER.unpickle81NativeArray(context, 1L, length, elemStyle));
                        break;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeCOLLECTION.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23 + "This feature is limited to numeric collection");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "This feature is limited to numeric collection");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                default: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeCOLLECTION.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "Invalid conversion type " + this.elementType);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "Invalid conversion type " + this.elementType);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            container.setLastIndexOffset(beginIdx + length, context.offset());
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCollElemTypeName() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.connection == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return;
            }
            OracleConnection oracleConnection = this.connection;
            synchronized (oracleConnection) {
                if (this.sqlName == null) {
                    this.getFullName();
                }
                Statement cstmt = null;
                Statement ps = null;
                ResultSet rs = null;
                try {
                    int state;
                    int n2 = state = this.sqlName.getSchema().equalsIgnoreCase(this.connection.getDefaultSchemaNameForNamedTypes()) ? 0 : 7;
                    while (state != 11) {
                        switch (state) {
                            case 0: {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleTypeCOLLECTION.logger().log(Level.FINEST, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "try CURRENT_USER_OBJECT, bind: " + this.sqlName.getSimpleName());
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                ps = this.connection.prepareStatement(this.getSqlHint() + sqlString[state]);
                                ps.setString(1, this.sqlName.getSimpleName());
                                ps.setFetchSize(1);
                                rs = ps.executeQuery();
                                state = 1;
                                break;
                            }
                            case 1: {
                                if (this.connection.getVersionNumber() >= 10000) {
                                    state = 2;
                                }
                            }
                            case 2: {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleTypeCOLLECTION.logger().log(Level.FINEST, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "try CURRENT_USER_SYNONYM, bind: " + this.sqlName.getSimpleName() + ", " + this.sqlName.getSimpleName() + ", ");
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                ps = this.connection.prepareStatement(this.getSqlHint() + sqlString[state]);
                                ps.setString(1, this.sqlName.getSimpleName());
                                ps.setString(2, this.sqlName.getSimpleName());
                                ps.setFetchSize(1);
                                rs = ps.executeQuery();
                                state = 3;
                                break;
                            }
                            case 3: {
                                if (this.connection.getVersionNumber() >= 10000) {
                                    state = 4;
                                }
                            }
                            case 4: {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleTypeCOLLECTION.logger().log(Level.FINEST, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "try CURRENT_USER_PUBLIC_SYNONYM, bind: " + this.sqlName.getSimpleName() + ", " + this.sqlName.getSimpleName());
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                ps = this.connection.prepareStatement(this.getSqlHint() + sqlString[state]);
                                ps.setString(1, this.sqlName.getSimpleName());
                                ps.setString(2, this.sqlName.getSimpleName());
                                ps.setFetchSize(1);
                                rs = ps.executeQuery();
                                state = 5;
                                break;
                            }
                            case 5: {
                                if (this.connection.getVersionNumber() >= 10000) {
                                    state = 6;
                                }
                            }
                            case 6: {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleTypeCOLLECTION.logger().log(Level.FINEST, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "try POSSIBLY_OTHER_USER_OBJECT, bind: " + this.sqlName.getSimpleName() + ", " + this.sqlName.getSimpleName());
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                ps = this.connection.prepareStatement(this.getSqlHint() + sqlString[state]);
                                ps.setString(1, this.sqlName.getSimpleName());
                                ps.setString(2, this.sqlName.getSimpleName());
                                ps.setFetchSize(1);
                                rs = ps.executeQuery();
                                state = 8;
                                break;
                            }
                            case 7: {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleTypeCOLLECTION.logger().log(Level.FINEST, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "try OTHER_USER_OBJECT, bind: " + this.sqlName.getSchema() + ", " + this.sqlName.getSimpleName());
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                ps = this.connection.prepareStatement(this.getSqlHint() + sqlString[state]);
                                ps.setString(1, this.sqlName.getSchema());
                                ps.setString(2, this.sqlName.getSimpleName());
                                ps.setFetchSize(1);
                                rs = ps.executeQuery();
                                state = 8;
                                break;
                            }
                            case 8: {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleTypeCOLLECTION.logger().log(Level.FINEST, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "try OTHER_USER_SYNONYM, bind: " + this.sqlName.getSimpleName() + ", " + this.sqlName.getSimpleName());
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                ps = this.connection.prepareStatement(this.getSqlHint() + sqlString[state]);
                                ps.setString(1, this.sqlName.getSimpleName());
                                ps.setString(2, this.sqlName.getSimpleName());
                                ps.setFetchSize(1);
                                rs = ps.executeQuery();
                                state = 9;
                                break;
                            }
                            case 9: {
                                if (this.connection.getVersionNumber() >= 10000) {
                                    state = 10;
                                }
                            }
                            case 10: {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleTypeCOLLECTION.logger().log(Level.FINEST, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "try PUBLIC_SYNONYM, bind: " + this.sqlName.getSimpleName());
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                cstmt = this.connection.prepareCall(this.getSqlHint() + sqlString[state]);
                                cstmt.setString(1, this.sqlName.getSimpleName());
                                cstmt.registerOutParameter(2, -10);
                                cstmt.execute();
                                rs = ((OracleCallableStatement)cstmt).getCursor(2);
                                state = 11;
                            }
                        }
                        if (rs.next()) {
                            if (this.attrTypeNames == null) {
                                this.attrTypeNames = new String[1];
                            }
                            this.attrTypeNames[0] = rs.getString(2) + "." + rs.getString(1);
                            state = 11;
                            continue;
                        }
                        if (state != 11) continue;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleTypeCOLLECTION.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    while (state != 11) {
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps != null) {
                        ps.close();
                    }
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeName(int idx) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(idx));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeName(int idx, boolean force) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(idx) + ", " + OracleLog.argument(force));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String __result__ = this.getAttributeName(idx);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeType(int idx) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(idx));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (idx != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.sqlName == null) {
                this.getFullName();
            }
            if (this.attrTypeNames == null) {
                this.initCollElemTypeName();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.attrTypeNames[0]);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.attrTypeNames[0];
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeType(int idx, boolean force) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (force) {
                String __result__ = this.getAttributeType(idx);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = __result__;
                return string;
            }
            if (idx != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.sqlName != null && this.attrTypeNames != null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.attrTypeNames[0]);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = this.attrTypeNames[0];
                return string;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumAttrs() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = 0;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleType getAttrTypeAt(int idx) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleType oracleType = null;
            return oracleType;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayDescriptor createArrayDescriptor() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayDescriptor __result__ = new ArrayDescriptor(this, (Connection)this.connection);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayDescriptor arrayDescriptor = __result__;
            return arrayDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayDescriptor createArrayDescriptorWithItsOwnTree() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.descriptor == null) {
                this.descriptor = this.sqlName == null && this.getFullName(false) == null ? new ArrayDescriptor(this, (Connection)this.connection) : ArrayDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
            }
            ArrayDescriptor __result__ = (ArrayDescriptor)this.descriptor;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayDescriptor arrayDescriptor = __result__;
            return arrayDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleType getElementType() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.elementType);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleType oracleType = this.elementType;
            return oracleType;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUserCode() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.userCode);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.userCode;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxLength() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.maxSize);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = this.maxSize;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getAccessLength(long coll_len, long beginIdx, int count) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(coll_len) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (beginIdx > coll_len) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long l2 = 0L;
                return l2;
            }
            if (count < 0) {
                long __result__ = coll_len - beginIdx + 1L;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long l3 = __result__;
                return l3;
            }
            long __result__ = Math.min(coll_len - beginIdx + 1L, (long)count);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l4 = __result__;
            return l4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(out));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            out.writeInt(this.userCode);
            out.writeLong(this.maxSize);
            out.writeObject(this.elementType);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(in));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.userCode = in.readInt();
            this.maxSize = in.readLong();
            this.elementType = (OracleType)in.readObject();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnection(OracleConnection conn) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.connection = conn;
            this.elementType.setConnection(conn);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initMetadataRecursively() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.initMetadata(this.connection);
            if (this.elementType != null) {
                this.elementType.initMetadataRecursively();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initChildNamesRecursively(Map typesMap) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(typesMap));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TypeTreeElement element = (TypeTreeElement)typesMap.get(this.sqlName);
            if (this.elementType != null) {
                this.elementType.setNames(element.getChildSchemaName(0), element.getChildTypeName(0));
                this.elementType.initChildNamesRecursively(typesMap);
                this.elementType.cacheDescriptor();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheDescriptor() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.descriptor = ArrayDescriptor.createDescriptor(this);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printXML(PrintWriter pw, int indent) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pw) + ", " + OracleLog.argument(indent));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.printXML(pw, indent, false);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printXML(PrintWriter pw, int indent, boolean fetchAllMetaDataAsNeeded) throws SQLException {
        try {
            int i2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pw) + ", " + OracleLog.argument(indent) + ", " + OracleLog.argument(fetchAllMetaDataAsNeeded));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            for (i2 = 0; i2 < indent; ++i2) {
                pw.print("  ");
            }
            pw.println("<OracleTypeCOLLECTION sqlName=\"" + this.sqlName + "\" " + ">");
            if (this.elementType != null) {
                this.elementType.printXML(pw, indent + 1, fetchAllMetaDataAsNeeded);
            }
            for (i2 = 0; i2 < indent; ++i2) {
                pw.print("  ");
            }
            pw.println("</OracleTypeCOLLECTION>");
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.OracleTypeCOLLECTION"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

