/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LogicalConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementWrapper;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class UpdatableResultSet
extends BaseResultSet {
    static final int concurrencyType = 1008;
    static final int BEGIN_COLUMN_INDEX = 1;
    static final int MAX_CHAR_BUFFER_SIZE = 1024;
    static final int MAX_BYTE_BUFFER_SIZE = 1024;
    PhysicalConnection connection;
    OracleResultSet resultSet;
    boolean isCachedRset;
    ScrollRsetStatement scrollStmt;
    ResultSetMetaData rsetMetaData;
    private int rsetType;
    private int columnCount;
    private OraclePreparedStatement deleteStmt;
    private OraclePreparedStatement insertStmt;
    private OraclePreparedStatement updateStmt;
    private int[] indexColsChanged;
    private Object[] rowBuffer;
    private boolean[] m_nullIndicator;
    private int[][] typeInfo;
    private boolean isInserting;
    private boolean isUpdating;
    private int wasNull;
    private static final int VALUE_NULL = 1;
    private static final int VALUE_NOT_NULL = 2;
    private static final int VALUE_UNKNOWN = 3;
    private static final int VALUE_IN_RSET = 4;
    private static final int ASCII_STREAM = 1;
    private static final int BINARY_STREAM = 2;
    private static final int UNICODE_STREAM = 3;
    private static int _MIN_STREAM_SIZE = 4000;
    ArrayList tempClobsToFree = null;
    ArrayList tempBlobsToFree = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UpdatableResultSet(ScrollRsetStatement stmt, ScrollableResultSet rset, int type, int update) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(rset) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(update));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.init(stmt, rset, type, update);
            rset.resetBeginColumnIndex();
            this.getInternalMetadata();
            this.isCachedRset = true;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UpdatableResultSet(ScrollRsetStatement stmt, OracleResultSetImpl rset, int type, int update) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(rset) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(update));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.init(stmt, rset, type, update);
            this.getInternalMetadata();
            this.isCachedRset = false;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(ScrollRsetStatement stmt, OracleResultSet rset, int type, int update) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(rset) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(update));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (stmt == null || rset == null || update != 1008) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.connection = ((OracleStatement)stmt).connection;
            this.resultSet = rset;
            this.scrollStmt = stmt;
            this.rsetType = type;
            this.deleteStmt = null;
            this.insertStmt = null;
            this.updateStmt = null;
            this.indexColsChanged = null;
            this.rowBuffer = null;
            this.m_nullIndicator = null;
            this.typeInfo = null;
            this.isInserting = false;
            this.isUpdating = false;
            this.wasNull = -1;
            this.rsetMetaData = null;
            this.columnCount = 0;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpen() throws SQLException {
        if (this.closed) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (this.resultSet == null || this.scrollStmt == null || ((OracleStatement)this.scrollStmt).closed) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                super.close();
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
                if (this.insertStmt != null) {
                    this.insertStmt.close();
                }
                if (this.updateStmt != null) {
                    this.updateStmt.close();
                }
                if (this.deleteStmt != null) {
                    this.deleteStmt.close();
                }
                if (this.scrollStmt != null) {
                    this.scrollStmt.notifyCloseRset();
                }
                this.cancelRowInserts();
                this.connection = LogicalConnection.closedConnection;
                this.resultSet = null;
                this.scrollStmt = null;
                this.rsetMetaData = null;
                this.scrollStmt = null;
                this.deleteStmt = null;
                this.insertStmt = null;
                this.updateStmt = null;
                this.indexColsChanged = null;
                this.rowBuffer = null;
                this.m_nullIndicator = null;
                this.typeInfo = null;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean wasNull() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 19[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getFirstUserColumnIndex() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 1);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = 1;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Statement statement;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Statement)((Object)this.scrollStmt));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                statement = (Statement)((Object)this.scrollStmt);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return statement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning;
        SQLWarning innerWarnings;
        block29: {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            innerWarnings = this.resultSet.getWarnings();
            if (this.sqlWarning != null) break block29;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + innerWarnings);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLWarning sQLWarning2 = innerWarnings;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return sQLWarning2;
        }
        try {
            SQLWarning thisWarning = this.sqlWarning;
            while (thisWarning.getNextWarning() != null) {
                thisWarning = thisWarning.getNextWarning();
            }
            thisWarning.setNextWarning(innerWarnings);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.sqlWarning);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            sQLWarning = this.sqlWarning;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return sQLWarning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWarnings() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.sqlWarning = null;
            this.resultSet.clearWarnings();
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                this.cancelRowChanges();
                boolean __result__ = this.resultSet.next();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBeforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                boolean __result__ = this.resultSet.isBeforeFirst();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAfterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                boolean __result__ = this.resultSet.isAfterLast();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                boolean __result__ = this.resultSet.isFirst();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                boolean __result__ = this.resultSet.isLast();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                this.cancelRowChanges();
                this.resultSet.beforeFirst();
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                this.cancelRowChanges();
                this.resultSet.afterLast();
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean first() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                this.cancelRowChanges();
                boolean __result__ = this.resultSet.first();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean last() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                this.cancelRowChanges();
                boolean __result__ = this.resultSet.last();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                int __result__ = this.resultSet.getRow();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean absolute(int row) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(row));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.cancelRowChanges();
                boolean __result__ = this.resultSet.absolute(row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relative(int rows) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rows));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                this.cancelRowChanges();
                boolean __result__ = this.resultSet.relative(rows);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                this.cancelRowChanges();
                boolean __result__ = this.resultSet.previous();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum getOracleObject(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                Datum value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    this.setIsNull(value == null);
                    value = this.getRowBufferDatumAt(columnIndex);
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getOracleObject(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                datum = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return datum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            String string;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                String value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null) {
                        value = datum.stringValue(this.connection);
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getString(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                string = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                boolean value = false;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null) {
                        value = datum.booleanValue();
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getBoolean(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int columnIndex) throws SQLException {
        OracleResultSet.AuthorizationIndicator authorizationIndicator;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)this.resultSet.getAuthorizationIndicator(columnIndex + 1)));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            authorizationIndicator = this.resultSet.getAuthorizationIndicator(columnIndex + 1);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return authorizationIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            byte by;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                byte value = 0;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null) {
                        value = datum.byteValue();
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getByte(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                by = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return by;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            short s2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                short value = 0;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    long longvalue = this.getLong(columnIndex);
                    if (longvalue > 65537L || longvalue < -65538L) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 26 + "getShort");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26, "getShort");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    value = (short)longvalue;
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getShort(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                s2 = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return s2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                int value = 0;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null) {
                        value = datum.intValue();
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getInt(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long l2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                long value = 0L;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null) {
                        value = datum.longValue();
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getLong(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                l2 = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            float f2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                float value = 0.0f;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null) {
                        value = datum.floatValue();
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getFloat(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                f2 = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return f2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            double d2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                double value = 0.0;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null) {
                        value = datum.doubleValue();
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getDouble(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                d2 = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return d2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BigDecimal bigDecimal;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(scale));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                BigDecimal value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null) {
                        value = datum.bigDecimalValue();
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getBigDecimal(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bigDecimal = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            byte[] byArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                byte[] value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null) {
                        value = datum.getBytes();
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getBytes(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byArray = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Date date;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                Date value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null) {
                        value = datum.dateValue();
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getDate(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                date = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Time time;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                Time value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null) {
                        value = datum.timeValue();
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getTime(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                time = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Timestamp timestamp;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                Timestamp value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null) {
                        value = datum.timestampValue();
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getTimestamp(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                timestamp = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                InputStream value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Object obj = this.getRowBufferAt(columnIndex);
                    this.setIsNull(obj == null);
                    if (obj != null) {
                        if (obj instanceof InputStream) {
                            value = (InputStream)obj;
                        } else {
                            Datum datum = this.getRowBufferDatumAt(columnIndex);
                            value = datum.asciiStreamValue();
                        }
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getAsciiStream(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                inputStream = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            try {
                InputStream value;
                block29: {
                    block28: {
                        byte[] bytes;
                        DBConversion dbconv;
                        Datum datum;
                        block31: {
                            block30: {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                this.ensureOpen();
                                value = null;
                                this.setIsNull(3);
                                if (!this.isOnInsertRow() && (!this.isUpdatingRow() || !this.isRowBufferUpdatedAt(columnIndex))) break block28;
                                Object obj = this.getRowBufferAt(columnIndex);
                                this.setIsNull(obj == null);
                                if (obj == null) break block29;
                                if (!(obj instanceof InputStream)) break block30;
                                value = (InputStream)obj;
                                break block29;
                            }
                            datum = this.getRowBufferDatumAt(columnIndex);
                            dbconv = this.connection.conversion;
                            bytes = datum.shareBytes();
                            if (!(datum instanceof RAW)) break block31;
                            value = dbconv.ConvertStream(new ByteArrayInputStream(bytes), 3);
                            break block29;
                        }
                        if (datum instanceof CHAR) {
                            value = dbconv.ConvertStream(new ByteArrayInputStream(bytes), 1);
                            break block29;
                        } else {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getUnicodeStream");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getUnicodeStream");
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                    }
                    this.setIsNull(4);
                    value = this.resultSet.getUnicodeStream(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                inputStream = value;
                if (!TRACE) return inputStream;
            }
            catch (Throwable throwable) {
                if (!TRACE) throw throwable;
                if (!OracleLog.recursiveEnter()) throw throwable;
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    throw throwable;
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!OracleLog.recursiveEnter()) return inputStream;
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                InputStream value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Object obj = this.getRowBufferAt(columnIndex);
                    this.setIsNull(obj == null);
                    if (obj != null) {
                        if (obj instanceof InputStream) {
                            value = (InputStream)obj;
                        } else {
                            Datum datum = this.getRowBufferDatumAt(columnIndex);
                            value = datum.binaryStreamValue();
                        }
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getBinaryStream(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                inputStream = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                Object value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getOracleObject(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null) {
                        value = datum.toJdbc();
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getObject(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                object = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int columnIndex, OracleDataFactory oracleDataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleData oracleData;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(oracleDataFactory));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleDataFactory.create(this.getObject(columnIndex), 0));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracleData = oracleDataFactory.create(this.getObject(columnIndex), 0);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oracleData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Reader reader;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                Reader value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Object obj = this.getRowBufferAt(columnIndex);
                    this.setIsNull(obj == null);
                    if (obj != null) {
                        if (obj instanceof Reader) {
                            value = (Reader)obj;
                        } else {
                            Datum datum = this.getRowBufferDatumAt(columnIndex);
                            value = datum.characterStreamValue();
                        }
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getCharacterStream(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                reader = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BigDecimal bigDecimal;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                BigDecimal value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null) {
                        value = datum.bigDecimalValue();
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getBigDecimal(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bigDecimal = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int columnIndex, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(map));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                Object value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getOracleObject(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null) {
                        value = datum instanceof STRUCT ? ((STRUCT)datum).toJdbc(map) : datum.toJdbc();
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getObject(columnIndex + 1, map);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                object = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ref getRef(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            REF rEF;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                REF __result__ = this.getREF(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                rEF = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return rEF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BLOB bLOB;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                BLOB __result__ = this.getBLOB(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bLOB = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CLOB cLOB;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                CLOB __result__ = this.getCLOB(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                cLOB = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return cLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getArray(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ARRAY aRRAY;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                ARRAY __result__ = this.getARRAY(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                aRRAY = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return aRRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Date date;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(cal));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                Date value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getOracleObject(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null) {
                        if (datum instanceof DATE) {
                            value = ((DATE)datum).dateValue(cal);
                        } else if (datum instanceof TIMESTAMP) {
                            Timestamp ts = ((TIMESTAMP)datum).timestampValue(cal);
                            long millis = ts.getTime();
                            value = new Date(millis);
                        } else {
                            DATE d2 = new DATE(datum.stringValue(this.connection));
                            if (d2 != null) {
                                value = d2.dateValue(cal);
                            }
                        }
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getDate(columnIndex + 1, cal);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                date = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Time time;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(cal));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                Time value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getOracleObject(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null) {
                        if (datum instanceof DATE) {
                            value = ((DATE)datum).timeValue(cal);
                        } else if (datum instanceof TIMESTAMP) {
                            Timestamp ts = ((TIMESTAMP)datum).timestampValue(cal);
                            long millis = ts.getTime();
                            value = new Time(millis);
                        } else {
                            DATE d2 = new DATE(datum.stringValue(this.connection));
                            if (d2 != null) {
                                value = d2.timeValue(cal);
                            }
                        }
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getTime(columnIndex + 1, cal);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                time = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Timestamp timestamp;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(cal));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                Timestamp value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getOracleObject(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null) {
                        if (datum instanceof DATE) {
                            value = ((DATE)datum).timestampValue(cal);
                        } else if (datum instanceof TIMESTAMP) {
                            value = ((TIMESTAMP)datum).timestampValue(cal);
                        } else {
                            DATE d2 = new DATE(datum.stringValue(this.connection));
                            if (d2 != null) {
                                value = d2.timestampValue(cal);
                            }
                        }
                    }
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getTimestamp(columnIndex + 1, cal);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                timestamp = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            URL uRL;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                URL result = null;
                int colType = this.getInternalMetadata().getColumnType(columnIndex + 1);
                int dbTypeCode = SQLUtil.getInternalType(colType);
                if (dbTypeCode == 96 || dbTypeCode == 1 || dbTypeCode == 8) {
                    try {
                        String val = this.getString(columnIndex);
                        if (val == null) {
                            result = null;
                        }
                        result = new URL(val);
                    }
                    catch (MalformedURLException exc) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 136);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 136);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                } else {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                uRL = result;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return uRL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCursor(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ResultSet resultSet;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                ResultSet value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getOracleObject(columnIndex);
                    this.setIsNull(datum == null);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getCursor");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCursor");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.setIsNull(4);
                value = this.resultSet.getCursor(columnIndex + 1);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                resultSet = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROWID getROWID(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ROWID rOWID;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                ROWID value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null && !(datum instanceof ROWID)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getROWID");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getROWID");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    value = (ROWID)datum;
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getROWID(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                rOWID = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return rOWID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NUMBER getNUMBER(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            NUMBER nUMBER;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                NUMBER value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null && !(datum instanceof NUMBER)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getNUMBER");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNUMBER");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    value = (NUMBER)datum;
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getNUMBER(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                nUMBER = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return nUMBER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DATE getDATE(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            DATE dATE;
            try {
                DATE value;
                block31: {
                    block28: {
                        Datum datum;
                        block29: {
                            block30: {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                this.ensureOpen();
                                value = null;
                                this.setIsNull(3);
                                if (!this.isOnInsertRow() && (!this.isUpdatingRow() || !this.isRowBufferUpdatedAt(columnIndex))) break block28;
                                datum = this.getRowBufferDatumAt(columnIndex);
                                if (datum == null) break block29;
                                if (!(datum instanceof DATE)) break block30;
                                value = (DATE)datum;
                                break block31;
                            }
                            if (datum instanceof TIMESTAMP) {
                                Timestamp ts = ((TIMESTAMP)datum).timestampValue();
                                value = new DATE(ts);
                                break block31;
                            } else {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getDATE");
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getDATE");
                                __ex__.fillInStackTrace();
                                throw __ex__;
                            }
                        }
                        this.setIsNull(datum == null);
                        break block31;
                    }
                    this.setIsNull(4);
                    value = this.resultSet.getDATE(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                dATE = value;
                if (!TRACE) return dATE;
            }
            catch (Throwable throwable) {
                if (!TRACE) throw throwable;
                if (!OracleLog.recursiveEnter()) throw throwable;
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    throw throwable;
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!OracleLog.recursiveEnter()) return dATE;
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return dATE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMP getTIMESTAMP(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            TIMESTAMP tIMESTAMP;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                TIMESTAMP value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null && !(datum instanceof TIMESTAMP)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getTIMESTAMP");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    value = (TIMESTAMP)datum;
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getTIMESTAMP(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                tIMESTAMP = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return tIMESTAMP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMPTZ getTIMESTAMPTZ(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            TIMESTAMPTZ tIMESTAMPTZ;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                TIMESTAMPTZ value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null && !(datum instanceof TIMESTAMPTZ)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getTIMESTAMPTZ");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    value = (TIMESTAMPTZ)datum;
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getTIMESTAMPTZ(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                tIMESTAMPTZ = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return tIMESTAMPTZ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            TIMESTAMPLTZ tIMESTAMPLTZ;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                TIMESTAMPLTZ value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null && !(datum instanceof TIMESTAMPLTZ)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getTIMESTAMPLTZ");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    value = (TIMESTAMPLTZ)datum;
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getTIMESTAMPLTZ(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                tIMESTAMPLTZ = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return tIMESTAMPLTZ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INTERVALDS getINTERVALDS(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            INTERVALDS iNTERVALDS;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                INTERVALDS value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null && !(datum instanceof INTERVALDS)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getINTERVALDS");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALDS");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    value = (INTERVALDS)datum;
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getINTERVALDS(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                iNTERVALDS = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return iNTERVALDS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INTERVALYM getINTERVALYM(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            INTERVALYM iNTERVALYM;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                INTERVALYM value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null && !(datum instanceof INTERVALYM)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getINTERVALYM");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALYM");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    value = (INTERVALYM)datum;
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getINTERVALYM(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                iNTERVALYM = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return iNTERVALYM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ARRAY getARRAY(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ARRAY aRRAY;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                ARRAY value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null && !(datum instanceof ARRAY)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getARRAY");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getARRAY");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    value = (ARRAY)datum;
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getARRAY(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                aRRAY = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return aRRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT getSTRUCT(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            STRUCT sTRUCT;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                STRUCT value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null && !(datum instanceof STRUCT)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getSTRUCT");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSTRUCT");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    value = (STRUCT)datum;
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getSTRUCT(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                sTRUCT = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return sTRUCT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPAQUE getOPAQUE(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OPAQUE oPAQUE;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                OPAQUE value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null && !(datum instanceof OPAQUE)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getOPAQUE");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOPAQUE");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    value = (OPAQUE)datum;
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getOPAQUE(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oPAQUE = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oPAQUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REF getREF(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            REF rEF;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                REF value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null && !(datum instanceof REF)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getREF");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getREF");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    value = (REF)datum;
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getREF(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                rEF = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return rEF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CHAR getCHAR(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CHAR cHAR;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                CHAR value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null && !(datum instanceof CHAR)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getCHAR");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCHAR");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    value = (CHAR)datum;
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getCHAR(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                cHAR = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return cHAR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAW getRAW(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            RAW rAW;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                RAW value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null && !(datum instanceof RAW)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getRAW");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getRAW");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    value = (RAW)datum;
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getRAW(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                rAW = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return rAW;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLOB getBLOB(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BLOB bLOB;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                BLOB value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null && !(datum instanceof BLOB)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getBLOB");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBLOB");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    value = (BLOB)datum;
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getBLOB(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bLOB = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLOB getCLOB(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CLOB cLOB;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                CLOB value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null && !(datum instanceof CLOB)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getCLOB");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    value = (CLOB)datum;
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getCLOB(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                cLOB = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return cLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE getBFILE(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BFILE bFILE;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                BFILE value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    if (datum != null && !(datum instanceof BFILE)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getBFILE");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBFILE");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    value = (BFILE)datum;
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getBFILE(columnIndex + 1);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bFILE = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bFILE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE getBfile(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BFILE bFILE;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                BFILE __result__ = this.getBFILE(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bFILE = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bFILE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomDatum getCustomDatum(int columnIndex, CustomDatumFactory factory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CustomDatum customDatum;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(factory));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                if (factory == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                CustomDatum value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    value = factory.create(datum, 0);
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getCustomDatum(columnIndex + 1, factory);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                customDatum = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return customDatum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORAData getORAData(int columnIndex, ORADataFactory factory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ORAData oRAData;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(factory));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                if (factory == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                ORAData value = null;
                this.setIsNull(3);
                if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    this.setIsNull(datum == null);
                    value = factory.create(datum, 0);
                } else {
                    this.setIsNull(4);
                    value = this.resultSet.getORAData(columnIndex + 1, factory);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oRAData = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oRAData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateBlob(int columnIndex, InputStream inStream, long length) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(inStream) + ", " + OracleLog.argument(length));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BLOB lob = BLOB.createTemporary(this.connection, true, 10);
            this.addToTempLobsToFree(lob);
            int bufferSize = lob.getBufferSize();
            OutputStream outStream = lob.setBinaryStream(1L);
            byte[] buffer = new byte[bufferSize];
            try {
                int lengthRead;
                for (long lengthRemaining = length; lengthRemaining > 0L && (lengthRead = inStream.read(buffer, 0, Math.min(bufferSize, (int)lengthRemaining))) != -1; lengthRemaining -= (long)lengthRead) {
                    outStream.write(buffer, 0, lengthRead);
                }
                outStream.close();
                this.updateBlob(columnIndex, (Blob)lob);
            }
            catch (IOException iox) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iox);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iox);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(length));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateClob(columnIndex, reader, length, (short)1);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateClob(int columnIndex, Reader reader, long length, short formOfUse) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(length) + ", " + OracleLog.argument(formOfUse));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CLOB lob = CLOB.createTemporary(this.connection, true, 10, formOfUse);
            this.addToTempLobsToFree(lob);
            int bufferSize = lob.getBufferSize();
            Writer writer = lob.setCharacterStream(1L);
            char[] buffer = new char[bufferSize];
            try {
                int lengthRead;
                for (long lengthRemaining = length; lengthRemaining > 0L && (lengthRead = reader.read(buffer, 0, Math.min(bufferSize, (int)lengthRemaining))) != -1; lengthRemaining -= (long)lengthRead) {
                    writer.write(buffer, 0, lengthRead);
                }
                writer.close();
                this.updateClob(columnIndex, (Clob)lob);
            }
            catch (IOException iox) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iox);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iox);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateClob(int columnIndex, InputStream inStream, int length) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(inStream) + ", " + OracleLog.argument(length));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateClob(columnIndex, inStream, length, (short)1);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateClob(int columnIndex, InputStream inStream, int length, short formOfUse) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(inStream) + ", " + OracleLog.argument(length) + ", " + OracleLog.argument(formOfUse));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CLOB lob = CLOB.createTemporary(this.connection, true, 10, formOfUse);
            this.addToTempLobsToFree(lob);
            int bufferSize = lob.getBufferSize();
            OutputStream outStream = lob.setAsciiStream(1L);
            byte[] buffer = new byte[bufferSize];
            try {
                int lengthRead;
                for (long lengthRemaining = (long)length; lengthRemaining > 0L && (lengthRead = inStream.read(buffer, 0, Math.min(bufferSize, (int)lengthRemaining))) != -1; lengthRemaining -= (long)lengthRead) {
                    outStream.write(buffer, 0, lengthRead);
                }
                outStream.close();
                this.updateClob(columnIndex, (Clob)lob);
            }
            catch (IOException iox) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iox);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iox);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToTempLobsToFree(Clob tclob) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(tclob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.tempClobsToFree == null) {
                this.tempClobsToFree = new ArrayList();
            }
            this.tempClobsToFree.add(tclob);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToTempLobsToFree(Blob tblob) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(tblob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.tempBlobsToFree == null) {
                this.tempBlobsToFree = new ArrayList();
            }
            this.tempBlobsToFree.add(tblob);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanTempLobs() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.cleanTempClobs(this.tempClobsToFree);
            this.cleanTempBlobs(this.tempBlobsToFree);
            this.tempClobsToFree = null;
            this.tempBlobsToFree = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanTempBlobs(ArrayList x) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (x != null) {
                Iterator iter = x.iterator();
                while (iter.hasNext()) {
                    try {
                        ((BLOB)iter.next()).freeTemporary();
                    }
                    catch (SQLException e2) {
                        if (!TRACE || !OracleLog.recursiveEnter()) continue;
                        try {
                            UpdatableResultSet.logger().log(Level.WARNING, Integer.toHexString(this.hashCode()).toUpperCase() + " Warning: " + " exception " + e2.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanTempClobs(ArrayList x) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (x != null) {
                Iterator iter = x.iterator();
                while (iter.hasNext()) {
                    try {
                        ((CLOB)iter.next()).freeTemporary();
                    }
                    catch (SQLException e2) {
                        if (!TRACE || !OracleLog.recursiveEnter()) continue;
                        try {
                            UpdatableResultSet.logger().log(Level.WARNING, Integer.toHexString(this.hashCode()).toUpperCase() + " Warning: " + " exception " + e2.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        OracleResultSetMetaData oracleResultSetMetaData;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (((OracleStatement)this.scrollStmt).closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9 + "getMetaData");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getMetaData");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OracleResultSetMetaData __result__ = new OracleResultSetMetaData(this.connection, (OracleStatement)this.scrollStmt, 1);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracleResultSetMetaData = __result__;
            }
            if (!TRACE) return oracleResultSetMetaData;
        }
        catch (Throwable throwable) {
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                throw throwable;
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        if (!OracleLog.recursiveEnter()) return oracleResultSetMetaData;
        try {
            UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            return oracleResultSetMetaData;
        }
        finally {
            OracleLog.recursiveExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String columnName) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                int __result__ = this.resultSet.findColumn(columnName) - 1;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int direction) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(direction));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                this.resultSet.setFetchDirection(direction);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchDirection() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                int __result__ = this.resultSet.getFetchDirection();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int rows) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rows));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                this.resultSet.setFetchSize(rows);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchSize() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                int __result__ = this.resultSet.getFetchSize();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType() throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rsetType);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.rsetType;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConcurrency() throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 1008);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = 1008;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowUpdated() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = false;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowInserted() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = false;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowDeleted() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = false;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                if (!this.isOnInsertRow()) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 83);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 83);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.prepareInsertRowStatement();
                this.prepareInsertRowBinds();
                this.executeInsertRow();
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block24: {
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.ensureOpen();
                    if (this.isOnInsertRow()) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 84);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    int _numColsChanged = this.getNumColumnsChanged();
                    if (_numColsChanged <= 0) break block24;
                    this.prepareUpdateRowStatement(_numColsChanged);
                    this.prepareUpdateRowBinds(_numColsChanged);
                    this.executeUpdateRow();
                }
                catch (Throwable throwable) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                if (this.isOnInsertRow()) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 84);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.prepareDeleteRowStatement();
                this.prepareDeleteRowBinds();
                this.executeDeleteRow();
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                if (this.isOnInsertRow()) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 84);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.resultSet.refreshRow();
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRowUpdates() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block18: {
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.ensureOpen();
                    if (!this.isUpdating) break block18;
                    this.isUpdating = false;
                    this.clearRowBuffer();
                }
                catch (Throwable throwable) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToInsertRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block28: {
                block29: {
                    try {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        this.ensureOpen();
                        if (!this.isOnInsertRow()) break block28;
                        if (!TRACE || !OracleLog.recursiveEnter()) break block29;
                        try {
                            UpdatableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    catch (Throwable throwable) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw throwable;
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return;
            }
            this.isInserting = true;
            if (this.rowBuffer == null) {
                this.rowBuffer = new Object[this.getColumnCount()];
            }
            if (this.m_nullIndicator == null) {
                this.m_nullIndicator = new boolean[this.getColumnCount()];
            }
            this.clearRowBuffer();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToCurrentRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                this.cancelRowInserts();
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateString(int columnIndex, String x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block19: {
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (x == null || x.length() == 0) {
                        this.updateNull(columnIndex);
                        break block19;
                    }
                    this.updateObject(columnIndex, (Object)x);
                }
                catch (Throwable throwable) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNull(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.setRowBufferAt(columnIndex, null);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(columnIndex, (Object)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateByte(int columnIndex, byte x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(columnIndex, (Object)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateShort(int columnIndex, short x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(columnIndex, (Object)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInt(int columnIndex, int x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(columnIndex, (Object)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLong(int columnIndex, long x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(columnIndex, (Object)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFloat(int columnIndex, float x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(columnIndex, (Object)Float.valueOf(x));
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDouble(int columnIndex, double x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(columnIndex, (Object)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(columnIndex, (Object)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(columnIndex, (Object)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDate(int columnIndex, Date x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(columnIndex, (Object)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTime(int columnIndex, Time x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(columnIndex, (Object)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(columnIndex, (Object)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        block35: {
            block32: {
                block33: {
                    try {
                        if (UpdatableResultSet.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(length));
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        this.ensureOpen();
                        metadata = (OracleResultSetMetaData)this.getInternalMetadata();
                        type = metadata.getColumnType(1 + columnIndex);
                        if (x == null || length <= 0) break block32;
                        switch (type) {
                            case 2005: {
                                if (metadata.isNCHAR(1 + columnIndex)) {
                                    this.updateClob(columnIndex, x, length, (short)2);
                                    ** break;
                                }
                                this.updateClob(columnIndex, x, length);
                                ** break;
                            }
                            case 2004: {
                                this.updateBlob(columnIndex, x, (long)length);
                                ** break;
                            }
                            case -1: {
                                infoArray = new int[]{length, 1};
                                this.setRowBufferAt(columnIndex, x, infoArray);
                                ** break;
                            }
                        }
                        try {
                            len = 0;
                            asciiBytes = new byte[1024];
                            charBuf = new char[1024];
                            inStr = new StringBuilder(1024);
                            for (lengthRemaining = length; lengthRemaining > 0 && (len = lengthRemaining >= 1024 ? x.read(asciiBytes) : x.read(asciiBytes, 0, lengthRemaining)) != -1; lengthRemaining -= len) {
                                this.connection.conversion;
                                DBConversion.asciiBytesToJavaChars(asciiBytes, len, charBuf);
                                inStr.append(charBuf, 0, len);
                            }
                            x.close();
                            if (lengthRemaining == length) {
                                this.updateNull(columnIndex);
                                if (UpdatableResultSet.TRACE == false) return;
                                break block33;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (IOException e) {
                            if (UpdatableResultSet.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                    }
                    catch (Throwable var15_18) {
                        if (UpdatableResultSet.TRACE == false) throw var15_18;
                        if (OracleLog.recursiveEnter() == false) throw var15_18;
                        try {
                            UpdatableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            throw var15_18;
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
                if (OracleLog.recursiveEnter() == false) return;
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    return;
                }
                finally {
                    OracleLog.recursiveExit();
                }
lbl-1000:
                // 1 sources

                {
                    this.updateString(columnIndex, inStr.toString());
                    ** break;
                }
lbl79:
                // 5 sources

                break block35;
            }
            this.setRowBufferAt(columnIndex, null);
        }
        if (UpdatableResultSet.TRACE == false) return;
        if (OracleLog.recursiveEnter() == false) return;
        try {
            UpdatableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            return;
        }
        finally {
            OracleLog.recursiveExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        block33: {
            block30: {
                block31: {
                    try {
                        if (UpdatableResultSet.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(length));
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        this.ensureOpen();
                        type = this.getInternalMetadata().getColumnType(1 + columnIndex);
                        if (x == null || length <= 0) break block30;
                        switch (type) {
                            case 2004: {
                                this.updateBlob(columnIndex, x, (long)length);
                                ** break;
                            }
                            case -4: {
                                infoArray = new int[]{length, 2};
                                this.setRowBufferAt(columnIndex, x, infoArray);
                                ** break;
                            }
                        }
                        try {
                            len = 0;
                            rawBytes = new byte[1024];
                            bstream = new ByteArrayOutputStream(1024);
                            for (lengthRemaining = length; lengthRemaining > 0 && (len = lengthRemaining >= 1024 ? x.read(rawBytes) : x.read(rawBytes, 0, lengthRemaining)) != -1; lengthRemaining -= len) {
                                bstream.write(rawBytes, 0, len);
                            }
                            x.close();
                            if (lengthRemaining == length) {
                                this.updateNull(columnIndex);
                                if (UpdatableResultSet.TRACE == false) return;
                                break block31;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (IOException e) {
                            if (UpdatableResultSet.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                    }
                    catch (Throwable var13_16) {
                        if (UpdatableResultSet.TRACE == false) throw var13_16;
                        if (OracleLog.recursiveEnter() == false) throw var13_16;
                        try {
                            UpdatableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            throw var13_16;
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
                if (OracleLog.recursiveEnter() == false) return;
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    return;
                }
                finally {
                    OracleLog.recursiveExit();
                }
lbl-1000:
                // 1 sources

                {
                    this.updateBytes(columnIndex, bstream.toByteArray());
                    ** break;
                }
lbl66:
                // 3 sources

                break block33;
            }
            this.setRowBufferAt(columnIndex, null);
        }
        if (UpdatableResultSet.TRACE == false) return;
        if (OracleLog.recursiveEnter() == false) return;
        try {
            UpdatableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            return;
        }
        finally {
            OracleLog.recursiveExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        block34: {
            block31: {
                block32: {
                    len = 0;
                    lengthRemaining = length;
                    try {
                        if (UpdatableResultSet.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                UpdatableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(length));
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        this.ensureOpen();
                        metadata = (OracleResultSetMetaData)this.getInternalMetadata();
                        type = metadata.getColumnType(1 + columnIndex);
                        if (x == null || length <= 0) break block31;
                        switch (type) {
                            case 2005: {
                                if (metadata.isNCHAR(1 + columnIndex)) {
                                    this.updateClob(columnIndex, x, (long)length, (short)2);
                                    ** break;
                                }
                                this.updateClob(columnIndex, x, (long)length);
                                ** break;
                            }
                            case -1: {
                                infoArray = new int[]{length};
                                this.setRowBufferAt(columnIndex, x, infoArray);
                                ** break;
                            }
                        }
                        try {
                            chars = new char[1024];
                            inStr = new StringBuilder(1024);
                            while (lengthRemaining > 0 && (len = lengthRemaining >= 1024 ? x.read(chars) : x.read(chars, 0, lengthRemaining)) != -1) {
                                inStr.append(chars, 0, len);
                                lengthRemaining -= len;
                            }
                            x.close();
                            if (lengthRemaining == length) {
                                this.updateNull(columnIndex);
                                if (UpdatableResultSet.TRACE == false) return;
                                break block32;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (IOException e) {
                            if (UpdatableResultSet.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                    }
                    catch (Throwable var14_16) {
                        if (UpdatableResultSet.TRACE == false) throw var14_16;
                        if (OracleLog.recursiveEnter() == false) throw var14_16;
                        try {
                            UpdatableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            throw var14_16;
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
                if (OracleLog.recursiveEnter() == false) return;
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    return;
                }
                finally {
                    OracleLog.recursiveExit();
                }
lbl-1000:
                // 1 sources

                {
                    this.updateString(columnIndex, inStr.toString());
                    ** break;
                }
lbl73:
                // 4 sources

                break block34;
            }
            this.setRowBufferAt(columnIndex, null);
        }
        if (UpdatableResultSet.TRACE == false) return;
        if (OracleLog.recursiveEnter() == false) return;
        try {
            UpdatableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            return;
        }
        finally {
            OracleLog.recursiveExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(scale));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(columnIndex, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(int columnIndex, Object x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                Datum datum = null;
                if (x != null) {
                    if (x instanceof OracleData) {
                        Object jdbcObject;
                        x = jdbcObject = ((OracleData)x).toJDBCObject(this.connection);
                    }
                    if (x instanceof Datum) {
                        datum = (Datum)x;
                    } else {
                        int idx;
                        OracleResultSetMetaData rsmd = (OracleResultSetMetaData)this.getInternalMetadata();
                        if (rsmd.getColumnType(idx = columnIndex + 1) == 96) {
                            int delta = rsmd.getColumnDisplaySize(idx);
                            String s2 = (String)x;
                            for (int i2 = s2.length(); i2 < delta; ++i2) {
                                s2 = s2 + " ";
                            }
                        }
                        datum = SQLUtil.makeOracleDatum(this.connection, x, rsmd.getColumnType(idx), null, rsmd.isNCHAR(idx));
                    }
                }
                this.setRowBufferAt(columnIndex, datum);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOracleObject(int columnIndex, Datum x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.setRowBufferAt(columnIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateROWID(int columnIndex, ROWID x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateOracleObject(columnIndex, (Datum)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNUMBER(int columnIndex, NUMBER x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateOracleObject(columnIndex, (Datum)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDATE(int columnIndex, DATE x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateOracleObject(columnIndex, (Datum)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateINTERVALYM(int columnIndex, INTERVALYM x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateOracleObject(columnIndex, (Datum)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateINTERVALDS(int columnIndex, INTERVALDS x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateOracleObject(columnIndex, (Datum)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTIMESTAMP(int columnIndex, TIMESTAMP x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateOracleObject(columnIndex, (Datum)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTIMESTAMPTZ(int columnIndex, TIMESTAMPTZ x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateOracleObject(columnIndex, (Datum)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTIMESTAMPLTZ(int columnIndex, TIMESTAMPLTZ x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateOracleObject(columnIndex, (Datum)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateARRAY(int columnIndex, ARRAY x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateOracleObject(columnIndex, (Datum)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSTRUCT(int columnIndex, STRUCT x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateOracleObject(columnIndex, (Datum)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOPAQUE(int columnIndex, OPAQUE x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateOracleObject(columnIndex, (Datum)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateREF(int columnIndex, REF x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateOracleObject(columnIndex, (Datum)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCHAR(int columnIndex, CHAR x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateOracleObject(columnIndex, (Datum)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRAW(int columnIndex, RAW x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateOracleObject(columnIndex, (Datum)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBLOB(int columnIndex, BLOB x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateOracleObject(columnIndex, (Datum)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCLOB(int columnIndex, CLOB x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateOracleObject(columnIndex, (Datum)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBFILE(int columnIndex, BFILE x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateOracleObject(columnIndex, (Datum)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBfile(int columnIndex, BFILE x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateOracleObject(columnIndex, (Datum)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCustomDatum(int columnIndex, CustomDatum x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw new Error("wanna do datum = ((CustomDatum) x).toDatum(m_comm)");
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateORAData(int columnIndex, ORAData x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum d2 = x.toDatum(this.connection);
            this.updateOracleObject(columnIndex, d2);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateREF(columnIndex, (REF)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateBLOB(columnIndex, (BLOB)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateCLOB(columnIndex, (CLOB)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateArray(int columnIndex, Array x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateARRAY(columnIndex, (ARRAY)x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getColumnCount() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.columnCount == 0) {
                this.columnCount = this.resultSet instanceof OracleResultSetImpl ? (((OracleResultSetImpl)this.resultSet).statement.accessors != null ? ((OracleResultSetImpl)this.resultSet).statement.numberOfDefinePositions : this.getInternalMetadata().getColumnCount()) : ((ScrollableResultSet)this.resultSet).getColumnCount();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.columnCount);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.columnCount;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSetMetaData getInternalMetadata() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rsetMetaData == null) {
                this.rsetMetaData = this.resultSet.getMetaData();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rsetMetaData);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSetMetaData resultSetMetaData = this.rsetMetaData;
            return resultSetMetaData;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelRowChanges() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.isInserting) {
                    this.cancelRowInserts();
                }
                if (this.isUpdating) {
                    this.cancelRowUpdates();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOnInsertRow() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.isInserting);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.isInserting;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelRowInserts() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.isInserting) {
                this.isInserting = false;
                this.clearRowBuffer();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isUpdatingRow() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.isUpdating);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.isUpdating;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRowBuffer() {
        try {
            int i2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowBuffer != null) {
                for (i2 = 0; i2 < this.rowBuffer.length; ++i2) {
                    this.rowBuffer[i2] = null;
                }
            }
            if (this.m_nullIndicator != null) {
                for (i2 = 0; i2 < this.m_nullIndicator.length; ++i2) {
                    this.m_nullIndicator[i2] = false;
                }
            }
            if (this.typeInfo != null) {
                for (i2 = 0; i2 < this.typeInfo.length; ++i2) {
                    if (this.typeInfo[i2] == null) continue;
                    for (int j2 = 0; j2 < this.typeInfo[i2].length; ++j2) {
                        this.typeInfo[i2][j2] = 0;
                    }
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRowBufferAt(int idx, Datum value) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(idx) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.setRowBufferAt(idx, value, null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRowBufferAt(int idx, Object value, int[] info) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(idx) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(info));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.isInserting) {
                if (this.isBeforeFirst() || this.isAfterLast() || this.getRow() == 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 82);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.isUpdating = true;
            }
            if (idx < 1 || idx > this.getColumnCount() - 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "setRowBufferAt");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setRowBufferAt");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowBuffer == null) {
                this.rowBuffer = new Object[this.getColumnCount()];
            }
            if (this.m_nullIndicator == null) {
                this.m_nullIndicator = new boolean[this.getColumnCount()];
                for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                    this.m_nullIndicator[i2] = false;
                }
            }
            if (info != null) {
                if (this.typeInfo == null) {
                    this.typeInfo = new int[this.getColumnCount()][];
                }
                this.typeInfo[idx] = info;
            }
            this.rowBuffer[idx] = value;
            this.m_nullIndicator[idx] = value == null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Datum getRowBufferDatumAt(int idx) throws SQLException {
        try {
            Object value;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(idx));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (idx < 1 || idx > this.getColumnCount() - 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "getRowBufferDatumAt");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getRowBufferDatumAt");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Datum datum = null;
            if (this.rowBuffer != null && (value = this.rowBuffer[idx]) != null) {
                if (value instanceof Datum) {
                    datum = (Datum)value;
                } else {
                    OracleResultSetMetaData rsmd = (OracleResultSetMetaData)this.getInternalMetadata();
                    int index = idx + 1;
                    datum = SQLUtil.makeOracleDatum(this.connection, value, rsmd.getColumnType(index), null, rsmd.isNCHAR(index));
                    this.rowBuffer[idx] = datum;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + datum);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum datum2 = datum;
            return datum2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getRowBufferAt(int idx) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(idx));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (idx < 1 || idx > this.getColumnCount() - 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "getRowBufferDatumAt");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getRowBufferDatumAt");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowBuffer != null) {
                Object __result__ = this.rowBuffer[idx];
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Object object = __result__;
                return object;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object var2_5 = null;
            return var2_5;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRowBufferUpdatedAt(int idx) {
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(idx));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowBuffer == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = __result__ = this.rowBuffer[idx] != null || this.m_nullIndicator[idx];
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareInsertRowStatement() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.insertStmt == null) {
                PreparedStatement ps = this.connection.prepareStatement(((OracleStatement)this.scrollStmt).sqlObject.getInsertSqlForUpdatableResultSet(this));
                this.insertStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)ps).preparedStatement;
                this.insertStmt.setQueryTimeout(((Statement)((Object)this.scrollStmt)).getQueryTimeout());
                if (((OracleStatement)this.scrollStmt).sqlObject.generatedSqlNeedEscapeProcessing()) {
                    this.insertStmt.setEscapeProcessing(true);
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareInsertRowBinds() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int idxBound = 1;
            idxBound = this.prepareSubqueryBinds(this.insertStmt, idxBound);
            OracleResultSetMetaData rsmd = (OracleResultSetMetaData)this.getInternalMetadata();
            for (int i2 = 1; i2 < this.getColumnCount(); ++i2) {
                Object value = this.getRowBufferAt(i2);
                if (value != null) {
                    if (value instanceof Reader) {
                        if (rsmd.isNCHAR(i2 + 1)) {
                            this.insertStmt.setFormOfUse(idxBound, (short)2);
                        }
                        this.insertStmt.setCharacterStream(idxBound + i2 - 1, (Reader)value, this.typeInfo[i2][0]);
                        continue;
                    }
                    if (value instanceof InputStream) {
                        if (this.typeInfo[i2][1] == 2) {
                            this.insertStmt.setBinaryStream(idxBound + i2 - 1, (InputStream)value, this.typeInfo[i2][0]);
                            continue;
                        }
                        if (this.typeInfo[i2][1] != 1) continue;
                        this.insertStmt.setAsciiStream(idxBound + i2 - 1, (InputStream)value, this.typeInfo[i2][0]);
                        continue;
                    }
                    Datum datum = this.getRowBufferDatumAt(i2);
                    if (rsmd.isNCHAR(i2 + 1)) {
                        this.insertStmt.setFormOfUse(idxBound + i2 - 1, (short)2);
                    }
                    this.insertStmt.setOracleObject(idxBound + i2 - 1, datum);
                    continue;
                }
                int colType = this.getInternalMetadata().getColumnType(i2 + 1);
                if (colType == 2006 || colType == 2002 || colType == 2008 || colType == 2007 || colType == 2003) {
                    this.insertStmt.setNull(idxBound + i2 - 1, colType, this.getInternalMetadata().getColumnTypeName(i2 + 1));
                    continue;
                }
                this.insertStmt.setNull(idxBound + i2 - 1, colType);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInsertRow() throws SQLException {
        block18: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.insertStmt.executeUpdate() == 1) break block18;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 85);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumColumnsChanged() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int _numColsChanged = 0;
            if (this.indexColsChanged == null) {
                this.indexColsChanged = new int[this.getColumnCount()];
            }
            if (this.rowBuffer != null) {
                for (int i2 = 1; i2 < this.getColumnCount(); ++i2) {
                    if (this.rowBuffer[i2] == null && (this.rowBuffer[i2] != null || !this.m_nullIndicator[i2])) continue;
                    this.indexColsChanged[_numColsChanged++] = i2;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + _numColsChanged);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = _numColsChanged;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareUpdateRowStatement(int _numColsChanged) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_numColsChanged));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.updateStmt != null) {
                this.updateStmt.close();
            }
            PreparedStatement ps = this.connection.prepareStatement(((OracleStatement)this.scrollStmt).sqlObject.getUpdateSqlForUpdatableResultSet(this, _numColsChanged, this.rowBuffer, this.indexColsChanged));
            this.updateStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)ps).preparedStatement;
            this.updateStmt.setQueryTimeout(((Statement)((Object)this.scrollStmt)).getQueryTimeout());
            if (((OracleStatement)this.scrollStmt).sqlObject.generatedSqlNeedEscapeProcessing()) {
                this.updateStmt.setEscapeProcessing(true);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareUpdateRowBinds(int _numColsChanged) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_numColsChanged));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int idxBound = 1;
            idxBound = this.prepareSubqueryBinds(this.updateStmt, idxBound);
            OracleResultSetMetaData rsmd = (OracleResultSetMetaData)this.getInternalMetadata();
            for (int i2 = 0; i2 < _numColsChanged; ++i2) {
                int idx = this.indexColsChanged[i2];
                Object value = this.getRowBufferAt(idx);
                if (value != null) {
                    if (value instanceof Reader) {
                        if (rsmd.isNCHAR(idx + 1)) {
                            this.updateStmt.setFormOfUse(idxBound, (short)2);
                        }
                        this.updateStmt.setCharacterStream(idxBound++, (Reader)value, this.typeInfo[idx][0]);
                        continue;
                    }
                    if (value instanceof InputStream) {
                        if (this.typeInfo[idx][1] == 2) {
                            this.updateStmt.setBinaryStream(idxBound++, (InputStream)value, this.typeInfo[idx][0]);
                            continue;
                        }
                        if (this.typeInfo[idx][1] != 1) continue;
                        this.updateStmt.setAsciiStream(idxBound++, (InputStream)value, this.typeInfo[idx][0]);
                        continue;
                    }
                    Datum datum = this.getRowBufferDatumAt(idx);
                    if (rsmd.isNCHAR(idx + 1)) {
                        this.updateStmt.setFormOfUse(idxBound, (short)2);
                    }
                    this.updateStmt.setOracleObject(idxBound++, datum);
                    continue;
                }
                int colType = this.getInternalMetadata().getColumnType(idx + 1);
                if (colType == 2006 || colType == 2002 || colType == 2008 || colType == 2007 || colType == 2003) {
                    this.updateStmt.setNull(idxBound++, colType, this.getInternalMetadata().getColumnTypeName(idx + 1));
                    continue;
                }
                if (rsmd.isNCHAR(idx + 1)) {
                    this.updateStmt.setFormOfUse(idxBound, (short)2);
                }
                this.updateStmt.setNull(idxBound++, colType);
            }
            this.prepareCompareSelfBinds(this.updateStmt, idxBound);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdateRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                if (this.updateStmt.executeUpdate() == 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 85);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (this.isCachedRset) {
                    ((ScrollableResultSet)this.resultSet).refreshRowsInCache(this.getRow(), 1, 1000);
                    this.cancelRowUpdates();
                }
            }
            finally {
                if (this.updateStmt != null) {
                    this.updateStmt.close();
                    this.updateStmt = null;
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareDeleteRowStatement() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.deleteStmt == null) {
                PreparedStatement ps = this.connection.prepareStatement(((OracleStatement)this.scrollStmt).sqlObject.getDeleteSqlForUpdatableResultSet(this));
                this.deleteStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)ps).preparedStatement;
                this.deleteStmt.setQueryTimeout(((Statement)((Object)this.scrollStmt)).getQueryTimeout());
                if (((OracleStatement)this.scrollStmt).sqlObject.generatedSqlNeedEscapeProcessing()) {
                    this.deleteStmt.setEscapeProcessing(true);
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareDeleteRowBinds() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int idxBound = 1;
            idxBound = this.prepareSubqueryBinds(this.deleteStmt, idxBound);
            this.prepareCompareSelfBinds(this.deleteStmt, idxBound);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDeleteRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.deleteStmt.executeUpdate() == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 85);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.isCachedRset) {
                ((ScrollableResultSet)this.resultSet).removeRowInCache(this.getRow());
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int prepareCompareSelfBinds(OraclePreparedStatement pstmt, int idxBound) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pstmt) + ", " + OracleLog.argument(idxBound));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            pstmt.setOracleObject(idxBound, this.resultSet.getOracleObject(1));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (idxBound + 1));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = idxBound + 1;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int prepareSubqueryBinds(OraclePreparedStatement pstmt, int idxBound) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pstmt) + ", " + OracleLog.argument(idxBound));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int _numSubQueryBinds = this.scrollStmt.copyBinds(pstmt, idxBound - 1);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (_numSubQueryBinds + 1));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = _numSubQueryBinds + 1;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIsNull(int status) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(status));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.wasNull = status;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIsNull(boolean isNull) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(isNull));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.wasNull = isNull ? 1 : 2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23 + "getCursorName");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UpdatableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PhysicalConnection physicalConnection = this.connection;
            return physicalConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleStatement getOracleStatement() throws SQLException {
        try {
            OracleStatement __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleStatement oracleStatement = __result__ = this.resultSet == null ? null : this.resultSet.getOracleStatement();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleStatement oracleStatement2 = __result__;
            return oracleStatement2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UpdatableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.UpdatableResultSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

