/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.transaction.xa.XAResource;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.OracleSQLPermission;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQNotificationRegistration;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.driver.AQMessageI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.ArrayDataResultSet;
import oracle.jdbc.driver.ArrayLocatorResultSet;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.BufferCache;
import oracle.jdbc.driver.ByteArrayKey;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.ClassRef;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LRUStatementCache;
import oracle.jdbc.driver.LogicalConnection;
import oracle.jdbc.driver.NTFAQRegistration;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.NTFManager;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleCallableStatementWrapper;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDatabaseMetaData;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementWrapper;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleStatementWrapper;
import oracle.jdbc.driver.OracleTimeout;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.StructMetaData;
import oracle.jdbc.internal.KeywordValueLong;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.XSEventListener;
import oracle.jdbc.internal.XSNamespace;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleWallet;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.ClobDBAccess;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.TypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PhysicalConnection
extends OracleConnection {
    public static final String SECRET_STORE_CONNECT = "oracle.security.client.connect_string";
    public static final String SECRET_STORE_USERNAME = "oracle.security.client.username";
    public static final String SECRET_STORE_PASSWORD = "oracle.security.client.password";
    public static final String SECRET_STORE_DEFAULT_USERNAME = "oracle.security.client.default_username";
    public static final String SECRET_STORE_DEFAULT_PASSWORD = "oracle.security.client.default_password";
    static final CRC64 CHECKSUM = new CRC64();
    public static final char slash_character = '/';
    public static final char at_sign_character = '@';
    public static final char left_square_bracket_character = '[';
    public static final char right_square_bracket_character = ']';
    static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    long outScn = 0L;
    char[][] charOutput = new char[1][];
    byte[][] byteOutput = new byte[1][];
    short[][] shortOutput = new short[1][];
    Properties sessionProperties = null;
    boolean retainV9BindBehavior;
    String userName;
    String database;
    boolean autocommit;
    String protocol;
    int streamChunkSize;
    boolean setFloatAndDoubleUseBinary;
    String thinVsessionTerminal;
    String thinVsessionMachine;
    String thinVsessionOsuser;
    String thinVsessionProgram;
    String thinVsessionProcess;
    String thinVsessionIname;
    String thinVsessionEname;
    String thinNetProfile;
    String thinNetAuthenticationServices;
    String thinNetAuthenticationKrb5Mutual;
    String thinNetAuthenticationKrb5CcName;
    String thinNetEncryptionLevel;
    String thinNetEncryptionTypes;
    String thinNetChecksumLevel;
    String thinNetChecksumTypes;
    String thinNetCryptoSeed;
    boolean thinTcpNoDelay;
    String thinReadTimeout;
    String thinNetConnectTimeout;
    boolean thinNetDisableOutOfBandBreak;
    boolean thinNetUseZeroCopyIO;
    boolean thinNetEnableSDP;
    boolean use1900AsYearForTime;
    boolean timestamptzInGmt;
    boolean timezoneAsRegion;
    String thinSslServerDnMatch;
    String thinSslVersion;
    String thinSslCipherSuites;
    String thinJavaxNetSslKeystore;
    String thinJavaxNetSslKeystoretype;
    String thinJavaxNetSslKeystorepassword;
    String thinJavaxNetSslTruststore;
    String thinJavaxNetSslTruststoretype;
    String thinJavaxNetSslTruststorepassword;
    String thinSslKeymanagerfactoryAlgorithm;
    String thinSslTrustmanagerfactoryAlgorithm;
    String thinNetOldsyntax;
    String thinNamingContextInitial;
    String thinNamingProviderUrl;
    String thinNamingSecurityAuthentication;
    String thinNamingSecurityPrincipal;
    String thinNamingSecurityCredentials;
    String walletLocation;
    String walletPassword;
    String proxyClientName;
    boolean useNio;
    String ociDriverCharset;
    String editionName;
    String logonCap;
    String internalLogon;
    boolean createDescriptorUseCurrentSchemaForSchemaName;
    long ociSvcCtxHandle;
    long ociEnvHandle;
    long ociErrHandle;
    boolean prelimAuth;
    boolean nlsLangBackdoor;
    String setNewPassword;
    boolean spawnNewThreadToCancel;
    int defaultExecuteBatch;
    int defaultRowPrefetch;
    int defaultLobPrefetchSize;
    boolean enableDataInLocator;
    boolean enableReadDataInLocator;
    boolean overrideEnableReadDataInLocator;
    boolean reportRemarks;
    boolean includeSynonyms;
    boolean restrictGettables;
    boolean accumulateBatchResult;
    boolean useFetchSizeWithLongColumn;
    boolean processEscapes;
    boolean fixedString;
    boolean defaultnchar;
    boolean permitTimestampDateMismatch;
    String resourceManagerId;
    boolean disableDefinecolumntype;
    boolean convertNcharLiterals;
    boolean j2ee13Compliant;
    boolean mapDateToTimestamp;
    boolean useThreadLocalBufferCache;
    String driverNameAttribute;
    int maxCachedBufferSize;
    int implicitStatementCacheSize;
    boolean lobStreamPosStandardCompliant;
    boolean isStrictAsciiConversion;
    boolean isQuickAsciiConversion;
    boolean thinForceDnsLoadBalancing;
    boolean enableJavaNetFastPath;
    boolean enableTempLobRefCnt;
    boolean plsqlVarcharParameter4KOnly;
    boolean keepAlive;
    public boolean calculateChecksum;
    String url;
    String savedUser;
    int commitOption;
    int ociConnectionPoolMinLimit = 0;
    int ociConnectionPoolMaxLimit = 0;
    int ociConnectionPoolIncrement = 0;
    int ociConnectionPoolTimeout = 0;
    boolean ociConnectionPoolNoWait = false;
    boolean ociConnectionPoolTransactionDistributed = false;
    String ociConnectionPoolLogonMode = null;
    boolean ociConnectionPoolIsPooling = false;
    Object ociConnectionPoolObject = null;
    Object ociConnectionPoolConnID = null;
    String ociConnectionPoolProxyType = null;
    Integer ociConnectionPoolProxyNumRoles = 0;
    Object ociConnectionPoolProxyRoles = null;
    String ociConnectionPoolProxyUserName = null;
    String ociConnectionPoolProxyPassword = null;
    String ociConnectionPoolProxyDistinguishedName = null;
    Object ociConnectionPoolProxyCertificate = null;
    static NTFManager ntfManager = new NTFManager();
    public int protocolId = -3;
    OracleTimeout timeout;
    DBConversion conversion;
    boolean xaWantsError;
    boolean usingXA;
    int txnMode = 0;
    byte[] fdo;
    Boolean bigEndian;
    OracleStatement statements;
    int lifecycle;
    static final int OPEN = 1;
    static final int CLOSING = 2;
    static final int CLOSED = 4;
    static final int ABORTED = 8;
    static final int BLOCKED = 16;
    boolean clientIdSet = false;
    String clientId = null;
    int txnLevel;
    Map map;
    Map javaObjectMap;
    final Hashtable[] descriptorCacheStack = new Hashtable[2];
    int dci = 0;
    OracleStatement statementHoldingLine;
    oracle.jdbc.OracleDatabaseMetaData databaseMetaData = null;
    LogicalConnection logicalConnectionAttached;
    boolean isProxy = false;
    OracleSql sqlObj = null;
    SQLWarning sqlWarning = null;
    boolean readOnly = false;
    LRUStatementCache statementCache = null;
    boolean clearStatementMetaData = false;
    OracleCloseCallback closeCallback = null;
    Object privateData = null;
    Statement savepointStatement = null;
    boolean isUsable = true;
    TimeZone defaultTimeZone = null;
    final int[] endToEndMaxLength = new int[4];
    boolean endToEndAnyChanged = false;
    final boolean[] endToEndHasChanged = new boolean[4];
    short endToEndECIDSequenceNumber = Short.MIN_VALUE;
    static final int DMS_NONE = 0;
    static final int DMS_10G = 1;
    static final int DMS_11 = 2;
    String[] endToEndValues = null;
    final int whichDMS = 0;
    oracle.jdbc.OracleConnection wrapper = null;
    int minVcsBindSize;
    int maxRawBytesSql;
    int maxRawBytesPlsql;
    int maxVcsCharsSql;
    int maxVcsNCharsSql;
    int maxVcsBytesPlsql;
    int maxIbtVarcharElementLength;
    String instanceName = null;
    OracleDriverExtension driverExtension;
    static final String uninitializedMarker = "";
    String databaseProductVersion = "";
    short versionNumber = (short)-1;
    int namedTypeAccessorByteLen;
    int refTypeAccessorByteLen;
    CharacterSet setCHARCharSetObj;
    CharacterSet setCHARNCharSetObj;
    protected final Object cancelInProgressLockForThin;
    boolean plsqlCompilerWarnings = false;
    private static final Pattern driverNameAttributePattern = Pattern.compile("[\\x20-\\x7e]{0,8}");
    private static final OracleSQLPermission CALL_ABORT_PERMISSION = new OracleSQLPermission("callAbort");
    static final String DATABASE_NAME = "DATABASE_NAME";
    static final String SERVER_HOST = "SERVER_HOST";
    static final String INSTANCE_NAME = "INSTANCE_NAME";
    static final String SERVICE_NAME = "SERVICE_NAME";
    Hashtable clientData;
    private BufferCacheStore connectionBufferCacheStore;
    private static ThreadLocal<BufferCacheStore> threadLocalBufferCacheStore;
    private int pingResult;
    String sessionTimeZone = null;
    String databaseTimeZone = null;
    Calendar dbTzCalendar = null;
    static final String RAW_STR = "RAW";
    static final String SYS_RAW_STR = "SYS.RAW";
    static final String SYS_ANYDATA_STR = "SYS.ANYDATA";
    static final String SYS_XMLTYPE_STR = "SYS.XMLTYPE";
    int timeZoneVersionNumber = -1;
    TIMEZONETAB timeZoneTab = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    private static Logger LOGGER;

    protected PhysicalConnection() {
        this.cancelInProgressLockForThin = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PhysicalConnection(String ur, Properties info, OracleDriverExtension ext) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(ur) + ", " + OracleLog.argument(info) + ", " + OracleLog.argument(ext));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.cancelInProgressLockForThin = new Object();
            this.readConnectionProperties(ur, info);
            this.driverExtension = ext;
            this.initialize(null, null, null);
            this.logicalConnectionAttached = null;
            try {
                this.needLine();
                this.logon();
                this.setAutoCommit(this.autocommit);
                if (this.getVersionNumber() >= 11202) {
                    this.minVcsBindSize = 4001;
                    this.maxRawBytesSql = 4000;
                    this.maxRawBytesPlsql = 32766;
                    this.maxVcsCharsSql = 32766;
                    this.maxVcsNCharsSql = 32766;
                    this.maxVcsBytesPlsql = 32766;
                    this.maxIbtVarcharElementLength = 32766;
                    this.endToEndMaxLength[0] = 64;
                    this.endToEndMaxLength[1] = 64;
                    this.endToEndMaxLength[2] = 64;
                    this.endToEndMaxLength[3] = 64;
                } else if (this.getVersionNumber() >= 11000) {
                    this.minVcsBindSize = 4001;
                    this.maxRawBytesSql = 4000;
                    this.maxRawBytesPlsql = 32766;
                    this.maxVcsCharsSql = 32766;
                    this.maxVcsNCharsSql = 32766;
                    this.maxVcsBytesPlsql = 32766;
                    this.maxIbtVarcharElementLength = 32766;
                    this.endToEndMaxLength[0] = 32;
                    this.endToEndMaxLength[1] = 64;
                    this.endToEndMaxLength[2] = 64;
                    this.endToEndMaxLength[3] = 48;
                } else if (this.getVersionNumber() >= 10000) {
                    this.minVcsBindSize = 4001;
                    this.maxRawBytesSql = 2000;
                    this.maxRawBytesPlsql = 32512;
                    this.maxVcsCharsSql = 32766;
                    this.maxVcsNCharsSql = 32766;
                    this.maxVcsBytesPlsql = 32512;
                    this.maxIbtVarcharElementLength = 32766;
                    this.endToEndMaxLength[0] = 32;
                    this.endToEndMaxLength[1] = 64;
                    this.endToEndMaxLength[2] = 64;
                    this.endToEndMaxLength[3] = 48;
                } else if (this.getVersionNumber() >= 9200) {
                    this.minVcsBindSize = 4001;
                    this.maxRawBytesSql = 2000;
                    this.maxRawBytesPlsql = 32512;
                    this.maxVcsCharsSql = 32766;
                    this.maxVcsNCharsSql = 32766;
                    this.maxVcsBytesPlsql = 32512;
                    this.maxIbtVarcharElementLength = 32766;
                    this.endToEndMaxLength[0] = 32;
                    this.endToEndMaxLength[1] = 64;
                    this.endToEndMaxLength[2] = 64;
                    this.endToEndMaxLength[3] = 48;
                } else {
                    this.minVcsBindSize = 4001;
                    this.maxRawBytesSql = 2000;
                    this.maxRawBytesPlsql = 2000;
                    this.maxVcsCharsSql = 4000;
                    this.maxVcsNCharsSql = 4000;
                    this.maxVcsBytesPlsql = 4000;
                    this.maxIbtVarcharElementLength = 4000;
                    this.endToEndMaxLength[0] = 32;
                    this.endToEndMaxLength[1] = 64;
                    this.endToEndMaxLength[2] = 64;
                    this.endToEndMaxLength[3] = 48;
                }
                if (this.getVersionNumber() >= 10000) {
                    this.retainV9BindBehavior = false;
                }
                this.initializeSetCHARCharSetObjs();
                if (this.implicitStatementCacheSize > 0) {
                    this.setStatementCacheSize(this.implicitStatementCacheSize);
                    this.setImplicitCachingEnabled(true);
                }
            }
            catch (SQLException ea) {
                this.lifecycle = 2;
                try {
                    this.logoff();
                }
                catch (SQLException eb) {
                    // empty catch block
                }
                this.lifecycle = 4;
                throw ea;
            }
            this.txnMode = 0;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static final String propertyVariableName(String fieldName) {
        char[] fieldNameInChars = new char[fieldName.length()];
        fieldName.getChars(0, fieldName.length(), fieldNameInChars, 0);
        String propertyVariableName = uninitializedMarker;
        for (int i2 = 0; i2 < fieldNameInChars.length; ++i2) {
            if (Character.isUpperCase(fieldNameInChars[i2])) {
                propertyVariableName = propertyVariableName + "_";
            }
            propertyVariableName = propertyVariableName + Character.toUpperCase(fieldNameInChars[i2]);
        }
        return propertyVariableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConnectionProperties(String ul, Properties info) throws SQLException {
        try {
            String password;
            int login_timeout_value;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(ul) + ", " + OracleLog.argument(info));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String tempval = null;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.RetainV9LongBindBehavior");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.RetainV9LongBindBehavior", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.retainV9BindBehavior = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("user")) == null) {
                tempval = info.getProperty("oracle.jdbc.user");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.user", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.userName = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("database")) == null) {
                tempval = info.getProperty("oracle.jdbc.database");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.database", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.database = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("autoCommit")) == null) {
                tempval = info.getProperty("oracle.jdbc.autoCommit");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.autoCommit", null);
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.autocommit = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("protocol")) == null) {
                tempval = info.getProperty("oracle.jdbc.protocol");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.protocol", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.protocol = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.StreamChunkSize");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.StreamChunkSize", null);
            }
            if (tempval == null) {
                tempval = "16384";
            }
            try {
                this.streamChunkSize = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 190 + "Property is 'streamChunkSize'");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'streamChunkSize'");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            tempval = null;
            if (info != null && (tempval = info.getProperty("SetFloatAndDoubleUseBinary")) == null) {
                tempval = info.getProperty("oracle.jdbc.SetFloatAndDoubleUseBinary");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.SetFloatAndDoubleUseBinary", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.setFloatAndDoubleUseBinary = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.terminal")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.terminal");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.v$session.terminal", null);
            }
            if (tempval == null) {
                tempval = "unknown";
            }
            this.thinVsessionTerminal = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.machine")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.machine");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.v$session.machine", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinVsessionMachine = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.osuser")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.osuser");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.v$session.osuser", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinVsessionOsuser = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.program")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.program");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.v$session.program", null);
            }
            if (tempval == null) {
                tempval = "JDBC Thin Client";
            }
            this.thinVsessionProgram = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.process")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.process");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.v$session.process", null);
            }
            if (tempval == null) {
                tempval = "1234";
            }
            this.thinVsessionProcess = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.iname")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.iname");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.v$session.iname", null);
            }
            if (tempval == null) {
                tempval = "jdbc_ttc_impl";
            }
            this.thinVsessionIname = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.ename")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.ename");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.v$session.ename", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinVsessionEname = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.profile");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.profile", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetProfile = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.authentication_services");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.authentication_services", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetAuthenticationServices = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.kerberos5_mutual_authentication");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.kerberos5_mutual_authentication", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetAuthenticationKrb5Mutual = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.kerberos5_cc_name");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.kerberos5_cc_name", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetAuthenticationKrb5CcName = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.encryption_client");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.encryption_client", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetEncryptionLevel = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.encryption_types_client");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.encryption_types_client", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetEncryptionTypes = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.crypto_checksum_client");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.crypto_checksum_client", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetChecksumLevel = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.crypto_checksum_types_client");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.crypto_checksum_types_client", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetChecksumTypes = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.crypto_seed");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.crypto_seed", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetCryptoSeed = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.TcpNoDelay");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.TcpNoDelay", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.thinTcpNoDelay = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.ReadTimeout");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.ReadTimeout", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinReadTimeout = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.CONNECT_TIMEOUT");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.CONNECT_TIMEOUT", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetConnectTimeout = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.disableOob");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.disableOob", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.thinNetDisableOutOfBandBreak = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.useZeroCopyIO");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.useZeroCopyIO", null);
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.thinNetUseZeroCopyIO = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.SDP");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.SDP", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.thinNetEnableSDP = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.use1900AsYearForTime");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.use1900AsYearForTime", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.use1900AsYearForTime = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.timestampTzInGmt");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.timestampTzInGmt", null);
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.timestamptzInGmt = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.timezoneAsRegion");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.timezoneAsRegion", null);
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.timezoneAsRegion = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ssl_server_dn_match");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.ssl_server_dn_match", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinSslServerDnMatch = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ssl_version");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.ssl_version", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinSslVersion = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ssl_cipher_suites");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.ssl_cipher_suites", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinSslCipherSuites = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("javax.net.ssl.keyStore");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("javax.net.ssl.keyStore", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJavaxNetSslKeystore = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("javax.net.ssl.keyStoreType");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("javax.net.ssl.keyStoreType", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJavaxNetSslKeystoretype = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("javax.net.ssl.keyStorePassword");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("javax.net.ssl.keyStorePassword", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJavaxNetSslKeystorepassword = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("javax.net.ssl.trustStore");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("javax.net.ssl.trustStore", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJavaxNetSslTruststore = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("javax.net.ssl.trustStoreType");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("javax.net.ssl.trustStoreType", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJavaxNetSslTruststoretype = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("javax.net.ssl.trustStorePassword");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("javax.net.ssl.trustStorePassword", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJavaxNetSslTruststorepassword = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("ssl.keyManagerFactory.algorithm")) == null) {
                tempval = info.getProperty("oracle.jdbc.ssl.keyManagerFactory.algorithm");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.ssl.keyManagerFactory.algorithm", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinSslKeymanagerfactoryAlgorithm = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("ssl.trustManagerFactory.algorithm")) == null) {
                tempval = info.getProperty("oracle.jdbc.ssl.trustManagerFactory.algorithm");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.ssl.trustManagerFactory.algorithm", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinSslTrustmanagerfactoryAlgorithm = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.oldSyntax");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.oldSyntax", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetOldsyntax = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("java.naming.factory.initial");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNamingContextInitial = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("java.naming.provider.url");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNamingProviderUrl = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("java.naming.security.authentication");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNamingSecurityAuthentication = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("java.naming.security.principal");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNamingSecurityPrincipal = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("java.naming.security.credentials");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNamingSecurityCredentials = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.wallet_location");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.wallet_location", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.walletLocation = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.wallet_password");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.wallet_password", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.walletPassword = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.proxyClientName");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.proxyClientName", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.proxyClientName = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.useNio");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.useNio", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.useNio = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("JDBCDriverCharSetId")) == null) {
                tempval = info.getProperty("oracle.jdbc.JDBCDriverCharSetId");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.JDBCDriverCharSetId", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.ociDriverCharset = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.editionName");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.editionName", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.editionName = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.thinLogonCapability");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.thinLogonCapability", null);
            }
            if (tempval == null) {
                tempval = "o5";
            }
            this.logonCap = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("internal_logon")) == null) {
                tempval = info.getProperty("oracle.jdbc.internal_logon");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.internal_logon", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.internalLogon = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.createDescriptorUseCurrentSchemaForSchemaName");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.createDescriptorUseCurrentSchemaForSchemaName", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.createDescriptorUseCurrentSchemaForSchemaName = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("OCISvcCtxHandle")) == null) {
                tempval = info.getProperty("oracle.jdbc.OCISvcCtxHandle");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.OCISvcCtxHandle", null);
            }
            if (tempval == null) {
                tempval = "0";
            }
            try {
                this.ociSvcCtxHandle = Long.parseLong(tempval);
            }
            catch (NumberFormatException nfe) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 190 + "Property is 'ociSvcCtxHandle'");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'ociSvcCtxHandle'");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            tempval = null;
            if (info != null && (tempval = info.getProperty("OCIEnvHandle")) == null) {
                tempval = info.getProperty("oracle.jdbc.OCIEnvHandle");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.OCIEnvHandle", null);
            }
            if (tempval == null) {
                tempval = "0";
            }
            try {
                this.ociEnvHandle = Long.parseLong(tempval);
            }
            catch (NumberFormatException nfe) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 190 + "Property is 'ociEnvHandle'");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'ociEnvHandle'");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            tempval = null;
            if (info != null && (tempval = info.getProperty("OCIErrHandle")) == null) {
                tempval = info.getProperty("oracle.jdbc.OCIErrHandle");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.OCIErrHandle", null);
            }
            if (tempval == null) {
                tempval = "0";
            }
            try {
                this.ociErrHandle = Long.parseLong(tempval);
            }
            catch (NumberFormatException nfe) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 190 + "Property is 'ociErrHandle'");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'ociErrHandle'");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            tempval = null;
            if (info != null && (tempval = info.getProperty("prelim_auth")) == null) {
                tempval = info.getProperty("oracle.jdbc.prelim_auth");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.prelim_auth", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.prelimAuth = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.ociNlsLangBackwardCompatible", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.nlsLangBackdoor = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("OCINewPassword")) == null) {
                tempval = info.getProperty("oracle.jdbc.OCINewPassword");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.OCINewPassword", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.setNewPassword = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.spawnNewThreadToCancel");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.spawnNewThreadToCancel", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.spawnNewThreadToCancel = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("defaultExecuteBatch")) == null) {
                tempval = info.getProperty("oracle.jdbc.defaultExecuteBatch");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.defaultExecuteBatch", null);
            }
            if (tempval == null) {
                tempval = "1";
            }
            try {
                this.defaultExecuteBatch = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 190 + "Property is 'defaultExecuteBatch'");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'defaultExecuteBatch'");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            tempval = null;
            if (info != null && (tempval = info.getProperty("defaultRowPrefetch")) == null) {
                tempval = info.getProperty("oracle.jdbc.defaultRowPrefetch");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.defaultRowPrefetch", null);
            }
            if (tempval == null) {
                tempval = "10";
            }
            try {
                this.defaultRowPrefetch = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 190 + "Property is 'defaultRowPrefetch'");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'defaultRowPrefetch'");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.defaultLobPrefetchSize");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.defaultLobPrefetchSize", null);
            }
            if (tempval == null) {
                tempval = "4000";
            }
            try {
                this.defaultLobPrefetchSize = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 190 + "Property is 'defaultLobPrefetchSize'");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'defaultLobPrefetchSize'");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.enableDataInLocator");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.enableDataInLocator", null);
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.enableDataInLocator = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.enableReadDataInLocator");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.enableReadDataInLocator", null);
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.enableReadDataInLocator = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.overrideEnableReadDataInLocator");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.overrideEnableReadDataInLocator", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.overrideEnableReadDataInLocator = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("remarksReporting")) == null) {
                tempval = info.getProperty("oracle.jdbc.remarksReporting");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.remarksReporting", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.reportRemarks = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("includeSynonyms")) == null) {
                tempval = info.getProperty("oracle.jdbc.includeSynonyms");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.includeSynonyms", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.includeSynonyms = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("restrictGetTables")) == null) {
                tempval = info.getProperty("oracle.jdbc.restrictGetTables");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.restrictGetTables", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.restrictGettables = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("AccumulateBatchResult")) == null) {
                tempval = info.getProperty("oracle.jdbc.AccumulateBatchResult");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.AccumulateBatchResult", null);
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.accumulateBatchResult = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("useFetchSizeWithLongColumn")) == null) {
                tempval = info.getProperty("oracle.jdbc.useFetchSizeWithLongColumn");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.useFetchSizeWithLongColumn", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.useFetchSizeWithLongColumn = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("processEscapes")) == null) {
                tempval = info.getProperty("oracle.jdbc.processEscapes");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.processEscapes", null);
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.processEscapes = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("fixedString")) == null) {
                tempval = info.getProperty("oracle.jdbc.fixedString");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.fixedString", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.fixedString = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("defaultNChar")) == null) {
                tempval = info.getProperty("oracle.jdbc.defaultNChar");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.defaultNChar", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.defaultnchar = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.internal.permitBindDateDefineTimestampMismatch");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.internal.permitBindDateDefineTimestampMismatch", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.permitTimestampDateMismatch = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("RessourceManagerId")) == null) {
                tempval = info.getProperty("oracle.jdbc.RessourceManagerId");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.RessourceManagerId", null);
            }
            if (tempval == null) {
                tempval = "0000";
            }
            this.resourceManagerId = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("disableDefineColumnType")) == null) {
                tempval = info.getProperty("oracle.jdbc.disableDefineColumnType");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.disableDefineColumnType", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.disableDefinecolumntype = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.convertNcharLiterals");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.convertNcharLiterals", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.convertNcharLiterals = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.J2EE13Compliant");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.J2EE13Compliant", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.j2ee13Compliant = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.mapDateToTimestamp");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.mapDateToTimestamp", null);
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.mapDateToTimestamp = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.useThreadLocalBufferCache");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.useThreadLocalBufferCache", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.useThreadLocalBufferCache = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.driverNameAttribute");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.driverNameAttribute", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.driverNameAttribute = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.maxCachedBufferSize");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.maxCachedBufferSize", null);
            }
            if (tempval == null) {
                tempval = "30";
            }
            try {
                this.maxCachedBufferSize = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 190 + "Property is 'maxCachedBufferSize'");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'maxCachedBufferSize'");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.implicitStatementCacheSize");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.implicitStatementCacheSize", null);
            }
            if (tempval == null) {
                tempval = "0";
            }
            try {
                this.implicitStatementCacheSize = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 190 + "Property is 'implicitStatementCacheSize'");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'implicitStatementCacheSize'");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.LobStreamPosStandardCompliant");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.LobStreamPosStandardCompliant", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.lobStreamPosStandardCompliant = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.strictASCIIConversion");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.strictASCIIConversion", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.isStrictAsciiConversion = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.quickASCIIConversion");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.quickASCIIConversion", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.isQuickAsciiConversion = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.thinForceDNSLoadBalancing");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.thinForceDNSLoadBalancing", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.thinForceDnsLoadBalancing = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.enableJavaNetFastPath");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.enableJavaNetFastPath", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.enableJavaNetFastPath = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.enableTempLobRefCnt");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.enableTempLobRefCnt", null);
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.enableTempLobRefCnt = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.plsqlVarcharParameter4KOnly");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.plsqlVarcharParameter4KOnly", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.plsqlVarcharParameter4KOnly = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.keepAlive");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.keepAlive", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.keepAlive = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.commitOption");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.commitOption", null);
            }
            if (tempval != null) {
                this.commitOption = 0;
                String[] values = tempval.split(",");
                if (values != null && values.length > 0) {
                    for (String opt : values) {
                        if (opt.trim() == uninitializedMarker) continue;
                        this.commitOption |= OracleConnection.CommitOption.valueOf(opt.trim()).getCode();
                    }
                }
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.calculateChecksum");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.calculateChecksum", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.calculateChecksum = tempval != null && tempval.equalsIgnoreCase("true");
            this.includeSynonyms = PhysicalConnection.parseConnectionProperty_boolean(info, "synonyms", (byte)3, this.includeSynonyms);
            this.reportRemarks = PhysicalConnection.parseConnectionProperty_boolean(info, "remarks", (byte)3, this.reportRemarks);
            this.defaultRowPrefetch = PhysicalConnection.parseConnectionProperty_int(info, "prefetch", (byte)3, this.defaultRowPrefetch);
            this.defaultRowPrefetch = PhysicalConnection.parseConnectionProperty_int(info, "rowPrefetch", (byte)3, this.defaultRowPrefetch);
            this.defaultExecuteBatch = PhysicalConnection.parseConnectionProperty_int(info, "batch", (byte)3, this.defaultExecuteBatch);
            this.defaultExecuteBatch = PhysicalConnection.parseConnectionProperty_int(info, "executeBatch", (byte)3, this.defaultExecuteBatch);
            this.proxyClientName = PhysicalConnection.parseConnectionProperty_String(info, "PROXY_CLIENT_NAME", (byte)1, this.proxyClientName);
            if (this.defaultRowPrefetch <= 0) {
                this.defaultRowPrefetch = Integer.parseInt("10");
            }
            if (this.defaultExecuteBatch <= 0) {
                this.defaultExecuteBatch = Integer.parseInt("1");
            }
            if (this.defaultLobPrefetchSize < -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 267);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 267);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.streamChunkSize = this.streamChunkSize > 0 ? Math.max(4096, this.streamChunkSize) : Integer.parseInt("16384");
            if (this.thinVsessionOsuser == null) {
                this.thinVsessionOsuser = PhysicalConnection.getSystemProperty("user.name", null);
                if (this.thinVsessionOsuser == null) {
                    this.thinVsessionOsuser = "jdbcuser";
                }
            }
            if (this.thinNetConnectTimeout == CONNECTION_PROPERTY_THIN_NET_CONNECT_TIMEOUT_DEFAULT && (login_timeout_value = DriverManager.getLoginTimeout()) != 0) {
                this.thinNetConnectTimeout = uninitializedMarker + login_timeout_value * 1000;
            }
            this.url = ul;
            Hashtable url_properties = PhysicalConnection.parseUrl(this.url, this.walletLocation, this.walletPassword);
            if (this.userName == CONNECTION_PROPERTY_USER_NAME_DEFAULT) {
                this.userName = (String)url_properties.get("user");
            }
            String[] loginModeOUT = new String[1];
            String[] proxyClientNameOUT = new String[1];
            this.userName = PhysicalConnection.parseLoginOption(this.userName, info, loginModeOUT, proxyClientNameOUT);
            if (loginModeOUT[0] != null) {
                this.internalLogon = loginModeOUT[0];
            }
            if (proxyClientNameOUT[0] != null) {
                this.proxyClientName = proxyClientNameOUT[0];
            }
            if ((password = info.getProperty("password", CONNECTION_PROPERTY_PASSWORD_DEFAULT)) == CONNECTION_PROPERTY_PASSWORD_DEFAULT) {
                password = (String)url_properties.get("password");
            }
            this.initializePassword(password);
            if (this.database == CONNECTION_PROPERTY_DATABASE_DEFAULT) {
                this.database = info.getProperty("server", CONNECTION_PROPERTY_DATABASE_DEFAULT);
            }
            if (this.database == CONNECTION_PROPERTY_DATABASE_DEFAULT) {
                this.database = (String)url_properties.get("database");
            }
            this.protocol = (String)url_properties.get("protocol");
            if (this.protocol == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 40 + "Protocol is not specified in URL");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 40, "Protocol is not specified in URL");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.protocol.equals("oci8") || this.protocol.equals("oci")) {
                this.database = this.translateConnStr(this.database);
            }
            if (info.getProperty("is_connection_pooling") == "true" && this.database == null) {
                this.database = uninitializedMarker;
            }
            if (this.userName != null && !this.userName.startsWith("\"")) {
                char[] srcChars = this.userName.toCharArray();
                for (int i2 = 0; i2 < srcChars.length; ++i2) {
                    srcChars[i2] = Character.toUpperCase(srcChars[i2]);
                }
                this.userName = String.copyValueOf(srcChars);
            }
            this.xaWantsError = false;
            this.usingXA = false;
            this.readOCIConnectionPoolProperties(info);
            this.validateConnectionProperties();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readOCIConnectionPoolProperties(Properties info) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(info));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.ociConnectionPoolMinLimit = PhysicalConnection.parseConnectionProperty_int(info, "connpool_min_limit", (byte)1, 0);
            this.ociConnectionPoolMaxLimit = PhysicalConnection.parseConnectionProperty_int(info, "connpool_max_limit", (byte)1, 0);
            this.ociConnectionPoolIncrement = PhysicalConnection.parseConnectionProperty_int(info, "connpool_increment", (byte)1, 0);
            this.ociConnectionPoolTimeout = PhysicalConnection.parseConnectionProperty_int(info, "connpool_timeout", (byte)1, 0);
            this.ociConnectionPoolNoWait = PhysicalConnection.parseConnectionProperty_boolean(info, "connpool_nowait", (byte)1, false);
            this.ociConnectionPoolTransactionDistributed = PhysicalConnection.parseConnectionProperty_boolean(info, "transactions_distributed", (byte)1, false);
            this.ociConnectionPoolLogonMode = PhysicalConnection.parseConnectionProperty_String(info, "connection_pool", (byte)1, null);
            this.ociConnectionPoolIsPooling = PhysicalConnection.parseConnectionProperty_boolean(info, "is_connection_pooling", (byte)1, false);
            this.ociConnectionPoolObject = PhysicalConnection.parseConnectionProperty_Object(info, "connpool_object", null);
            this.ociConnectionPoolConnID = PhysicalConnection.parseConnectionProperty_Object(info, "connection_id", null);
            this.ociConnectionPoolProxyType = PhysicalConnection.parseConnectionProperty_String(info, "proxytype", (byte)1, null);
            this.ociConnectionPoolProxyNumRoles = (Integer)PhysicalConnection.parseConnectionProperty_Object(info, "proxy_num_roles", 0);
            this.ociConnectionPoolProxyRoles = PhysicalConnection.parseConnectionProperty_Object(info, "proxy_roles", null);
            this.ociConnectionPoolProxyUserName = PhysicalConnection.parseConnectionProperty_String(info, "proxy_user_name", (byte)1, null);
            this.ociConnectionPoolProxyPassword = PhysicalConnection.parseConnectionProperty_String(info, "proxy_password", (byte)1, null);
            this.ociConnectionPoolProxyDistinguishedName = PhysicalConnection.parseConnectionProperty_String(info, "proxy_distinguished_name", (byte)1, null);
            this.ociConnectionPoolProxyCertificate = PhysicalConnection.parseConnectionProperty_Object(info, "proxy_certificate", null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateConnectionProperties() throws SQLException {
        block18: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.driverNameAttribute == null || driverNameAttributePattern.matcher(this.driverNameAttribute).matches()) break block18;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 257);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 257);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object parseConnectionProperty_Object(Properties props, String name, Object def) throws SQLException {
        try {
            Object val;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(props) + ", " + OracleLog.argument(name) + ", " + OracleLog.argument(def));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object ret = def;
            if (props != null && (val = props.get(name)) != null) {
                ret = val;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = ret;
            return object;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String parseConnectionProperty_String(Properties props, String name, byte mode, String def) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(props) + ", " + OracleLog.argument(name) + ", " + OracleLog.argument(mode) + ", " + OracleLog.argument(def));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String ret = null;
            if (!(mode != 1 && mode != 3 || props == null || (ret = props.getProperty(name)) != null || name.startsWith("oracle.") || name.startsWith("java.") || name.startsWith("javax."))) {
                ret = props.getProperty("oracle.jdbc." + name);
            }
            if (ret == null && (mode == 2 || mode == 3)) {
                ret = name.startsWith("oracle.") || name.startsWith("java.") || name.startsWith("javax.") ? PhysicalConnection.getSystemProperty(name, null) : PhysicalConnection.getSystemProperty("oracle.jdbc." + name, null);
            }
            if (ret == null) {
                ret = def;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = ret;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int parseConnectionProperty_int(Properties props, String name, byte mode, int def) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(props) + ", " + OracleLog.argument(name) + ", " + OracleLog.argument(mode) + ", " + OracleLog.argument(def));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int ret = def;
            String val = PhysicalConnection.parseConnectionProperty_String(props, name, mode, null);
            if (val != null) {
                try {
                    ret = Integer.parseInt(val);
                }
                catch (NumberFormatException nfe) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(Level.SEVERE, "         Throwing SQLException: 190Property is '" + name + "' and value is '" + val + "'");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 190, "Property is '" + name + "' and value is '" + val + "'");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = ret;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long parseConnectionProperty_long(Properties props, String name, byte mode, long def) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(props) + ", " + OracleLog.argument(name) + ", " + OracleLog.argument(mode) + ", " + OracleLog.argument(def));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long ret = def;
            String val = PhysicalConnection.parseConnectionProperty_String(props, name, mode, null);
            if (val != null) {
                try {
                    ret = Long.parseLong(val);
                }
                catch (NumberFormatException nfe) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(Level.SEVERE, "         Throwing SQLException: 190Property is '" + name + "' and value is '" + val + "'");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 190, "Property is '" + name + "' and value is '" + val + "'");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = ret;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean parseConnectionProperty_boolean(Properties props, String name, byte mode, boolean def) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(props) + ", " + OracleLog.argument(name) + ", " + OracleLog.argument(mode) + ", " + OracleLog.argument(def));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean ret = def;
            String val = PhysicalConnection.parseConnectionProperty_String(props, name, mode, null);
            if (val != null) {
                if (val.equalsIgnoreCase("false")) {
                    ret = false;
                } else if (val.equalsIgnoreCase("true")) {
                    ret = true;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String parseLoginOption(String _user, Properties info, String[] loginModeOUT, String[] proxyClientNameOUT) {
        try {
            String lowerCaseUser;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(_user) + ", " + OracleLog.argument(info));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int j2 = 0;
            String userOnly = null;
            String proxyClient = null;
            if (_user == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = null;
                return string;
            }
            int len = _user.length();
            if (len == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = null;
                return string;
            }
            int i2 = _user.indexOf(91);
            if (i2 > 0) {
                j2 = _user.indexOf(93);
                proxyClient = _user.substring(i2 + 1, j2);
                if ((proxyClient = proxyClient.trim()).length() > 0) {
                    proxyClientNameOUT[0] = proxyClient;
                }
                _user = _user.substring(0, i2) + _user.substring(j2 + 1, len);
            }
            if ((i2 = (lowerCaseUser = _user.toLowerCase()).lastIndexOf(" as ")) == -1 || i2 < lowerCaseUser.lastIndexOf("\"")) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, "         Return: " + _user);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = _user;
                return string;
            }
            userOnly = _user.substring(0, i2);
            i2 += 4;
            while (i2 < len && lowerCaseUser.charAt(i2) == ' ') {
                ++i2;
            }
            if (i2 == len) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, "         Return: " + _user);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = _user;
                return string;
            }
            String loginMode = lowerCaseUser.substring(i2).trim();
            if (loginMode.length() > 0) {
                loginModeOUT[0] = loginMode;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Return: " + userOnly);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = userOnly;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Hashtable parseUrl(String url, String wallet_location, String wallet_password) throws SQLException {
        try {
            String alias;
            String[] tmpCreds;
            int end;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(url));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Hashtable<String, String> result = new Hashtable<String, String>(5);
            int sub_sub_index = url.indexOf(58, url.indexOf(58) + 1) + 1;
            if (sub_sub_index == (end = url.length())) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, "         Return: " + result);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Hashtable<String, String> hashtable = result;
                return hashtable;
            }
            int next_colon_index = url.indexOf(58, sub_sub_index);
            if (next_colon_index == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, "         Return: " + result);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Hashtable<String, String> hashtable = result;
                return hashtable;
            }
            result.put("protocol", url.substring(sub_sub_index, next_colon_index));
            int _user = next_colon_index + 1;
            int slash = url.indexOf(47, _user);
            int at_sign = url.indexOf(64, _user);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.TRACE_20, "         Debug: sub_sub_index=" + sub_sub_index + ", end=" + end + ", next_colon_index=" + next_colon_index + ", _user=" + _user + ", slash=" + slash + ", at_sign=" + at_sign);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (at_sign > _user && _user > sub_sub_index && slash == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, "         Throwing SQLException: 67");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 67);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (at_sign == -1) {
                at_sign = end;
            }
            if (slash == -1) {
                slash = at_sign;
            }
            if (slash < at_sign && slash != _user && at_sign != _user) {
                result.put("user", url.substring(_user, slash));
                result.put("password", url.substring(slash + 1, at_sign));
            }
            if (!(slash > at_sign || slash != _user && at_sign != _user || at_sign >= end || (tmpCreds = PhysicalConnection.getSecretStoreCredentials(alias = url.substring(at_sign + 1), wallet_location, wallet_password))[0] == null && tmpCreds[1] == null)) {
                result.put("user", tmpCreds[0]);
                result.put("password", tmpCreds[1]);
            }
            if (at_sign < end) {
                result.put("database", url.substring(at_sign + 1));
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Hashtable<String, String> hashtable = result;
            return hashtable;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final synchronized String[] getSecretStoreCredentials(String connectString, String wallet_location, String wallet_password) throws SQLException {
        try {
            String[] userPwd;
            block36: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                userPwd = new String[]{null, null};
                if (wallet_location != null) {
                    try {
                        OracleWallet wallet;
                        if (wallet_location.startsWith("(")) {
                            wallet_location = "file:" + CustomSSLSocketFactory.processWalletLocation(wallet_location);
                        }
                        if (!(wallet = new OracleWallet()).exists(wallet_location)) break block36;
                        char[] walletPasswordInChars = null;
                        if (wallet_password != null) {
                            walletPasswordInChars = wallet_password.toCharArray();
                        }
                        wallet.open(wallet_location, walletPasswordInChars);
                        OracleSecretStore secretStore = wallet.getSecretStore();
                        if (secretStore.containsAlias(SECRET_STORE_DEFAULT_USERNAME)) {
                            userPwd[0] = new String(secretStore.getSecret(SECRET_STORE_DEFAULT_USERNAME));
                        }
                        if (secretStore.containsAlias(SECRET_STORE_DEFAULT_PASSWORD)) {
                            userPwd[1] = new String(secretStore.getSecret(SECRET_STORE_DEFAULT_PASSWORD));
                        }
                        Enumeration list = wallet.getSecretStore().internalAliases();
                        String alias = null;
                        while (list.hasMoreElements()) {
                            alias = (String)list.nextElement();
                            if (!alias.startsWith(SECRET_STORE_CONNECT) || !connectString.equalsIgnoreCase(new String(secretStore.getSecret(alias)))) continue;
                            String idx = alias.substring(SECRET_STORE_CONNECT.length());
                            userPwd[0] = new String(secretStore.getSecret(SECRET_STORE_USERNAME + idx));
                            userPwd[1] = new String(secretStore.getSecret(SECRET_STORE_PASSWORD + idx));
                            break;
                        }
                    }
                    catch (NoClassDefFoundError ndef) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                PhysicalConnection.logger().log(Level.SEVERE, "         Throwing SQLException: 167" + ndef);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(null, 167, ndef);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    catch (Exception s2) {
                        if (s2 instanceof RuntimeException) {
                            throw (RuntimeException)s2;
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                PhysicalConnection.logger().log(Level.SEVERE, "         Throwing SQLException: 168" + s2);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(null, 168, s2);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Return: " + userPwd);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String[] stringArray = userPwd;
            return stringArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String translateConnStr(String database) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(database));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int fColon = 0;
            int sColon = 0;
            if (database == null || database.equals(uninitializedMarker)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + database);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = database;
                return string;
            }
            if (database.indexOf(41) != -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + database);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = database;
                return string;
            }
            boolean ipV6LiteralFormat = false;
            if (database.indexOf(91) != -1) {
                fColon = database.indexOf(93);
                if (fColon == -1) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 67 + database);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67, database);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                ipV6LiteralFormat = true;
            }
            if ((fColon = database.indexOf(58, fColon)) == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + database);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String __ex__ = database;
                return __ex__;
            }
            sColon = database.indexOf(58, fColon + 1);
            if (sColon == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + database);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String __ex__ = database;
                return __ex__;
            }
            if (database.indexOf(58, sColon + 1) != -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 67 + database);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67, database);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String host = null;
            host = ipV6LiteralFormat ? database.substring(1, fColon - 1) : database.substring(0, fColon);
            String port = database.substring(fColon + 1, sColon);
            String sid = database.substring(sColon + 1, database.length());
            String translate_database = "(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=" + host + ")(PORT=" + port + "))(CONNECT_DATA=(SID=" + sid + ")))";
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "translate_database=" + translate_database);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + translate_database);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = translate_database;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getSystemPropertyPollInterval() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Return: " + PhysicalConnection.getSystemProperty("oracle.jdbc.TimeoutPollInterval", "1000"));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = PhysicalConnection.getSystemProperty("oracle.jdbc.TimeoutPollInterval", "1000");
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getSystemPropertyFastConnectionFailover(String defaultValue) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(defaultValue));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Return: " + PhysicalConnection.getSystemProperty("oracle.jdbc.FastConnectionFailover", defaultValue));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = PhysicalConnection.getSystemProperty("oracle.jdbc.FastConnectionFailover", defaultValue);
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getSystemPropertyJserverVersion() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String __result__ = PhysicalConnection.getSystemProperty("oracle.jserver.version", null);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSystemProperty(String str, String defaultValue) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(str) + ", " + OracleLog.argument(defaultValue));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (str != null) {
                final String fstr = str;
                final String fdefaultValue = defaultValue;
                final String[] rets = new String[]{defaultValue};
                AccessController.doPrivileged(new PrivilegedAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() {
                        rets[0] = System.getProperty(fstr, fdefaultValue);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                PhysicalConnection.logger().log(Level.FINER, "         Return: " + null);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        return null;
                    }
                });
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, "         Return: " + rets[0]);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = rets[0];
                return string;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Return: " + defaultValue);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = defaultValue;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    abstract void initializePassword(String var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getProperties() {
        Properties properties;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Properties props = new Properties();
            try {
                Class connectionclass = null;
                Class physicalConnectionClass = null;
                try {
                    connectionclass = ClassRef.newInstance("oracle.jdbc.OracleConnection").get();
                    physicalConnectionClass = ClassRef.newInstance("oracle.jdbc.driver.PhysicalConnection").get();
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
                Field[] physicalConnectionFields = physicalConnectionClass.getDeclaredFields();
                for (int i2 = 0; i2 < physicalConnectionFields.length; ++i2) {
                    String propertyValue;
                    int modifier = physicalConnectionFields[i2].getModifiers();
                    if (Modifier.isStatic(modifier)) continue;
                    String fieldName = physicalConnectionFields[i2].getName();
                    String propertyConstantName = "CONNECTION_PROPERTY_" + PhysicalConnection.propertyVariableName(fieldName);
                    Field connectionPropertyField = null;
                    try {
                        connectionPropertyField = connectionclass.getField(propertyConstantName);
                    }
                    catch (NoSuchFieldException ex) {
                        continue;
                    }
                    if (propertyConstantName.matches(".*PASSWORD.*")) continue;
                    String propertyName = (String)connectionPropertyField.get(null);
                    String typeName = physicalConnectionFields[i2].getType().getName();
                    if (typeName.equals("boolean")) {
                        boolean propertyValue2 = physicalConnectionFields[i2].getBoolean(this);
                        if (propertyValue2) {
                            props.setProperty(propertyName, "true");
                            continue;
                        }
                        props.setProperty(propertyName, "false");
                        continue;
                    }
                    if (typeName.equals("int")) {
                        int propertyValue3 = physicalConnectionFields[i2].getInt(this);
                        props.setProperty(propertyName, Integer.toString(propertyValue3));
                        continue;
                    }
                    if (typeName.equals("long")) {
                        long propertyValue4 = physicalConnectionFields[i2].getLong(this);
                        props.setProperty(propertyName, Long.toString(propertyValue4));
                        continue;
                    }
                    if (!typeName.equals("java.lang.String") || (propertyValue = (String)physicalConnectionFields[i2].get(this)) == null) continue;
                    props.setProperty(propertyName, propertyValue);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + props);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            properties = props;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Connection _getPC() {
        Connection connection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            connection = null;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        PhysicalConnection physicalConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            physicalConnection = this;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return physicalConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isLogicalConnection() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = false;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize(Hashtable dc, Map pcmap, Map omap) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(dc) + ", " + OracleLog.argument(pcmap) + ", " + OracleLog.argument(omap));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.clearStatementMetaData = false;
            this.descriptorCacheStack[this.dci] = dc != null ? dc : new Hashtable(10);
            this.map = pcmap;
            this.javaObjectMap = omap != null ? omap : new Hashtable(10);
            this.lifecycle = 1;
            this.txnLevel = 2;
            this.clientIdSet = false;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeSetCHARCharSetObjs() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.setCHARNCharSetObj = this.conversion.getDriverNCharSetObj();
            this.setCHARCharSetObj = this.conversion.getDriverCharSetObj();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleTimeout getTimeout() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.timeout == null) {
                this.timeout = OracleTimeout.newTimeout(this.url);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.timeout);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleTimeout oracleTimeout = this.timeout;
            return oracleTimeout;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Statement createStatement() throws SQLException {
        Statement statement;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Statement __result__ = this.createStatement(-1, -1);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            statement = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        OracleStatementWrapper oracleStatementWrapper;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            OracleStatement stmt = null;
            stmt = this.driverExtension.allocateStatement(this, resultSetType, resultSetConcurrency);
            OracleStatementWrapper __result__ = new OracleStatementWrapper(stmt);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oracleStatementWrapper = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oracleStatementWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement preparedStatement;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PreparedStatement __result__ = this.prepareStatement(sql, -1, -1);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            preparedStatement = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PreparedStatement prepareStatementWithKey(String key) throws SQLException {
        block40: {
            PreparedStatement __ex__2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(key));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.lifecycle != 1) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                    __ex__2.fillInStackTrace();
                    throw __ex__2;
                }
                if (key != null) break block40;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                __ex__2 = null;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return __ex__2;
        }
        if (!this.isStatementCacheInitialized()) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 95);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 95);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        oracle.jdbc.internal.OraclePreparedStatement pstmt = null;
        pstmt = (OraclePreparedStatement)this.statementCache.searchExplicitCache(key);
        if (pstmt != null) {
            pstmt = new OraclePreparedStatementWrapper(pstmt);
        }
        OraclePreparedStatement __result__ = pstmt;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        OraclePreparedStatement oraclePreparedStatement = __result__;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oraclePreparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        OraclePreparedStatementWrapper oraclePreparedStatementWrapper;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (sql == null || sql.length() == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 104);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 104);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            OraclePreparedStatement pstmt = null;
            if (this.statementCache != null) {
                pstmt = (OraclePreparedStatement)this.statementCache.searchImplicitCache(sql, 1, resultSetType != -1 || resultSetConcurrency != -1 ? ResultSetUtil.getRsetTypeCode(resultSetType, resultSetConcurrency) : 1);
            }
            if (pstmt == null) {
                pstmt = this.driverExtension.allocatePreparedStatement(this, sql, resultSetType, resultSetConcurrency);
            }
            OraclePreparedStatementWrapper __result__ = new OraclePreparedStatementWrapper(pstmt);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oraclePreparedStatementWrapper = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oraclePreparedStatementWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement callableStatement;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CallableStatement __result__ = this.prepareCall(sql, -1, -1);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            callableStatement = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return callableStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        OracleCallableStatementWrapper oracleCallableStatementWrapper;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (sql == null || sql.length() == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 104);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 104);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            OracleCallableStatement cstmt = null;
            if (this.statementCache != null) {
                cstmt = (OracleCallableStatement)this.statementCache.searchImplicitCache(sql, 2, resultSetType != -1 || resultSetConcurrency != -1 ? ResultSetUtil.getRsetTypeCode(resultSetType, resultSetConcurrency) : 1);
            }
            if (cstmt == null) {
                cstmt = this.driverExtension.allocateCallableStatement(this, sql, resultSetType, resultSetConcurrency);
            }
            OracleCallableStatementWrapper __result__ = new OracleCallableStatementWrapper(cstmt);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oracleCallableStatementWrapper = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oracleCallableStatementWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CallableStatement prepareCallWithKey(String key) throws SQLException {
        block40: {
            CallableStatement __ex__2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(key));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.lifecycle != 1) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                    __ex__2.fillInStackTrace();
                    throw __ex__2;
                }
                if (key != null) break block40;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                __ex__2 = null;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return __ex__2;
        }
        if (!this.isStatementCacheInitialized()) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 95);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 95);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        oracle.jdbc.internal.OracleCallableStatement cstmt = null;
        cstmt = (OracleCallableStatement)this.statementCache.searchExplicitCache(key);
        if (cstmt != null) {
            cstmt = new OracleCallableStatementWrapper(cstmt);
        }
        OracleCallableStatement __result__ = cstmt;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        OracleCallableStatement oracleCallableStatement = __result__;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oracleCallableStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String nativeSQL(String sql) throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.sqlObj == null) {
                this.sqlObj = new OracleSql(this.conversion);
            }
            this.sqlObj.initialize(sql);
            String osql = this.sqlObj.getSql(this.processEscapes, this.convertNcharLiterals);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + osql);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = osql;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(autoCommit));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (autoCommit) {
                this.disallowGlobalTxnMode(116);
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.needLine();
            this.doSetAutoCommit(autoCommit);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoCommit() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.autocommit);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.autocommit;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        block29: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleStatement stmt = this.statements;
                if (this.lifecycle != 1 && this.lifecycle != 16) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                boolean connectionHasBeenCancelled = false;
                while (stmt != null) {
                    block28: {
                        try {
                            if (stmt.doCancel()) {
                                connectionHasBeenCancelled = true;
                            }
                        }
                        catch (SQLException e2) {
                            if (!TRACE || !OracleLog.recursiveEnter()) break block28;
                            try {
                                PhysicalConnection.logger().log(OracleLog.TRACE_10, Integer.toHexString(this.hashCode()).toUpperCase() + " Event: " + "PhysicalConnection.cancel() failed: " + e2.getMessage());
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                    }
                    stmt = stmt.next;
                }
                if (connectionHasBeenCancelled) break block29;
                this.cancelOperationOnServer(false);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(EnumSet<OracleConnection.CommitOption> options) throws SQLException {
        int optionsAsInt = 0;
        if (options != null) {
            if (options.contains((Object)OracleConnection.CommitOption.WRITEBATCH) && options.contains((Object)OracleConnection.CommitOption.WRITEIMMED) || options.contains((Object)OracleConnection.CommitOption.WAIT) && options.contains((Object)OracleConnection.CommitOption.NOWAIT)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 191);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 191);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            for (OracleConnection.CommitOption option : options) {
                optionsAsInt |= option.getCode();
            }
        }
        this.commit(optionsAsInt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void commit(int flags) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.disallowGlobalTxnMode(114);
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            OracleStatement s2 = this.statements;
            while (s2 != null) {
                if (!s2.closed) {
                    s2.sendBatch();
                }
                s2 = s2.next;
            }
            if ((flags & OracleConnection.CommitOption.WRITEBATCH.getCode()) != 0 && (flags & OracleConnection.CommitOption.WRITEIMMED.getCode()) != 0 || (flags & OracleConnection.CommitOption.WAIT.getCode()) != 0 && (flags & OracleConnection.CommitOption.NOWAIT.getCode()) != 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 191);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 191);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.registerHeartbeat();
            this.needLine();
            this.doCommit(flags);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        this.commit(this.commitOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rollback() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.disallowGlobalTxnMode(115);
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            OracleStatement s2 = this.statements;
            while (s2 != null) {
                if (s2.isOracleBatchStyle()) {
                    s2.clearBatch();
                }
                s2 = s2.next;
            }
            this.registerHeartbeat();
            this.needLine();
            this.doRollback();
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        block32: {
            block33: {
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (this.lifecycle != 2 && this.lifecycle != 4) break block32;
                    if (!TRACE || !OracleLog.recursiveEnter()) break block33;
                    try {
                        PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                catch (Throwable throwable) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        this.needLineUnchecked();
        try {
            if (this.closeCallback != null) {
                this.closeCallback.beforeClose(this, this.privateData);
            }
            this.closeStatementCache();
            this.closeStatements(false);
            if (this.lifecycle == 1) {
                this.lifecycle = 2;
            }
            if (this.isProxy) {
                this.close(1);
            }
            if (this.timeZoneTab != null) {
                this.timeZoneTab.freeInstance();
            }
            this.logoff();
            this.cleanup();
            if (this.timeout != null) {
                this.timeout.close();
            }
            if (this.closeCallback != null) {
                this.closeCallback.afterClose(this.privateData);
            }
        }
        finally {
            this.lifecycle = 4;
            this.isUsable = false;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDataIntegrityAlgorithmName() throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEncryptionAlgorithmName() throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAuthenticationAdaptorName() throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeInternal(boolean putPhysicalConnBackInCache) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(putPhysicalConnBackInCache));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupAndClose(boolean putPhysicalConnBackInCache) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(putPhysicalConnBackInCache));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupAndClose() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return;
            }
            this.lifecycle = 16;
            this.cancel();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeLogicalConnection() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.lifecycle == 1 || this.lifecycle == 16 || this.lifecycle == 2) {
                this.savepointStatement = null;
                this.closeStatements(true);
                if (this.clientIdSet) {
                    this.clearClientIdentifier(this.clientId);
                }
                this.logicalConnectionAttached = null;
                this.lifecycle = 1;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(Properties cachedConnectionAttributes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cachedConnectionAttributes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 152);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 152);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(int opt) throws SQLException {
        block30: {
            block27: {
                block28: {
                    try {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(opt));
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if ((opt & 0x1000) == 0) break block27;
                        this.close();
                        if (!TRACE || !OracleLog.recursiveEnter()) break block28;
                        try {
                            PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    catch (Throwable throwable) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw throwable;
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return;
            }
            if ((opt & 1) != 0 && this.isProxy) {
                this.purgeStatementCache();
                this.closeStatements(false);
                this.descriptorCacheStack[this.dci--] = null;
                this.closeProxySession();
                this.isProxy = false;
            }
            if (!TRACE || !OracleLog.recursiveEnter()) break block30;
            try {
                PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() throws SQLException {
        block24: {
            block25: {
                SecurityManager security = System.getSecurityManager();
                if (security != null) {
                    security.checkPermission(CALL_ABORT_PERMISSION);
                }
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (this.lifecycle != 4 && this.lifecycle != 8) break block24;
                    if (!TRACE || !OracleLog.recursiveEnter()) break block25;
                    try {
                        PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                catch (Throwable throwable) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        this.lifecycle = 8;
        this.doAbort();
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    abstract void doAbort() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeProxySession() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getServerSessionInfo() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void applyConnectionAttributes(Properties cachedConnectionAttributes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cachedConnectionAttributes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 152);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 152);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Properties getConnectionAttributes() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 152);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 152);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Properties getUnMatchedConnectionAttributes() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 152);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 152);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setAbandonedTimeoutEnabled(boolean val) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(val));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 152);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 152);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void registerConnectionCacheCallback(OracleConnectionCacheCallback occc, Object userObj, int cbkFlag) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(occc) + ", " + OracleLog.argument(userObj) + ", " + OracleLog.argument(cbkFlag));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 152);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 152);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleConnectionCacheCallback getConnectionCacheCallbackObj() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 152);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 152);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getConnectionCacheCallbackPrivObj() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 152);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 152);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConnectionCacheCallbackFlag() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 152);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 152);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setConnectionReleasePriority(int priority) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(priority));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 152);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 152);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConnectionReleasePriority() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 152);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 152);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isClosed() throws SQLException {
        boolean bl;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__ = this.lifecycle != 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isProxySession() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.isProxy);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.isProxy;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void openProxySession(int type, Properties prop) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(prop));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean proxyError = true;
            if (this.isProxy) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 149);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 149);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String user = prop.getProperty("PROXY_USER_NAME");
            String passwd = prop.getProperty("PROXY_USER_PASSWORD");
            String distName = prop.getProperty("PROXY_DISTINGUISHED_NAME");
            Object certif = prop.get("PROXY_CERTIFICATE");
            if (type == 1) {
                if (user == null && passwd == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 150);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 150);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            } else if (type == 2) {
                if (distName == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 150);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 150);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            } else {
                if (type == 3) {
                    if (certif == null) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 150);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 150);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    try {
                        byte[] verify = (byte[])certif;
                    }
                    catch (ClassCastException e2) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 150);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 150);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 150);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 150);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.purgeStatementCache();
            this.closeStatements(false);
            try {
                this.doProxySession(type, prop);
                ++this.dci;
                proxyError = false;
            }
            finally {
                if (proxyError) {
                    this.closeProxySession();
                }
            }
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doProxySession(int type, Properties prop) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(prop));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.fdo = null;
            this.conversion = null;
            this.statements = null;
            this.descriptorCacheStack[this.dci] = null;
            this.map = null;
            this.javaObjectMap = null;
            this.statementHoldingLine = null;
            this.sqlObj = null;
            this.isProxy = false;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        oracle.jdbc.OracleDatabaseMetaData oracleDatabaseMetaData;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.databaseMetaData == null) {
                this.databaseMetaData = new OracleDatabaseMetaData(this);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.databaseMetaData);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oracleDatabaseMetaData = this.databaseMetaData;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oracleDatabaseMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnly(boolean value) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.readOnly = value;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.readOnly);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.readOnly;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCatalog(String catalog) throws SQLException {
        block13: {
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(catalog));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalog() throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = null;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        block34: {
            block35: {
                try {
                    if (PhysicalConnection.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(level));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (this.txnLevel != level) break block34;
                    if (!PhysicalConnection.TRACE || !OracleLog.recursiveEnter()) break block35;
                    try {
                        PhysicalConnection.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                catch (Throwable var8_10) {
                    if (PhysicalConnection.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var8_10;
                }
            }
            if (PhysicalConnection.TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        ostmt = this.createStatement();
        try {
            switch (level) {
                case 2: {
                    ostmt.execute("ALTER SESSION SET ISOLATION_LEVEL = READ COMMITTED");
                    this.txnLevel = 2;
                    ** break;
lbl48:
                    // 1 sources

                    break;
                }
                case 8: {
                    ostmt.execute("ALTER SESSION SET ISOLATION_LEVEL = SERIALIZABLE");
                    this.txnLevel = 8;
                    ** break;
lbl54:
                    // 1 sources

                    break;
                }
                default: {
                    if (PhysicalConnection.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 30);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 30);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
        }
        finally {
            ostmt.close();
        }
        if (PhysicalConnection.TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionIsolation() throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.txnLevel);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.txnLevel;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setAutoClose(boolean autoClose) throws SQLException {
        block19: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(autoClose));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (autoClose) break block19;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 31);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 31);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoClose() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = true;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.sqlWarning);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            sQLWarning = this.sqlWarning;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return sQLWarning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.sqlWarning = null;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWarnings(SQLWarning warn) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(warn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.sqlWarning = warn;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultRowPrefetch(int value) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (value <= 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 20);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 20);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.defaultRowPrefetch = value;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDefaultRowPrefetch() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.defaultRowPrefetch);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.defaultRowPrefetch;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getTimestamptzInGmt() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.timestamptzInGmt);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.timestamptzInGmt;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getUse1900AsYearForTime() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.use1900AsYearForTime);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.use1900AsYearForTime;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setDefaultExecuteBatch(int batch) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(batch));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (batch <= 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 42);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 42);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.defaultExecuteBatch = batch;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getDefaultExecuteBatch() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.defaultExecuteBatch);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.defaultExecuteBatch;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setRemarksReporting(boolean _reportRemarks) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(_reportRemarks));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.reportRemarks = _reportRemarks;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean getRemarksReporting() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.reportRemarks);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.reportRemarks;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIncludeSynonyms(boolean synonyms) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(synonyms));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.includeSynonyms = synonyms;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String[] getEndToEndMetrics() throws SQLException {
        String[] stringArray;
        try {
            String[] result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.endToEndValues == null) {
                result = null;
            } else {
                result = new String[this.endToEndValues.length];
                System.arraycopy(this.endToEndValues, 0, result, 0, this.endToEndValues.length);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            stringArray = result;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getEndToEndECIDSequenceNumber() throws SQLException {
        short s2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.endToEndECIDSequenceNumber);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            s2 = this.endToEndECIDSequenceNumber;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setEndToEndMetrics(String[] metrics, short sequenceNumber) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(metrics) + ", " + OracleLog.argument(sequenceNumber));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String[] copyMetrics = new String[metrics.length];
            System.arraycopy(metrics, 0, copyMetrics, 0, metrics.length);
            this.setEndToEndMetricsInternal(copyMetrics, sequenceNumber);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEndToEndMetricsInternal(String[] metrics, short sequenceNumber) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(metrics) + ", " + OracleLog.argument(sequenceNumber));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (metrics != this.endToEndValues) {
                String s2;
                int i2;
                if (metrics.length != 4) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 156);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 156);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                for (i2 = 0; i2 < 4; ++i2) {
                    s2 = metrics[i2];
                    if (s2 == null || s2.length() <= this.endToEndMaxLength[i2]) continue;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 159 + s2);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 159, s2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (this.endToEndValues != null) {
                    for (i2 = 0; i2 < 4; ++i2) {
                        s2 = metrics[i2];
                        if ((s2 != null || this.endToEndValues[i2] == null) && (s2 == null || s2.equals(this.endToEndValues[i2]))) continue;
                        this.endToEndHasChanged[i2] = true;
                        this.endToEndAnyChanged = true;
                    }
                    this.endToEndHasChanged[0] = this.endToEndHasChanged[0] | this.endToEndHasChanged[3];
                } else {
                    for (i2 = 0; i2 < 4; ++i2) {
                        this.endToEndHasChanged[i2] = true;
                    }
                    this.endToEndAnyChanged = true;
                }
                this.endToEndValues = metrics;
            }
            this.endToEndECIDSequenceNumber = sequenceNumber;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSystemContext() throws SQLException {
        block12: {
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetSystemContext() {
        block12: {
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSystemContext11() throws SQLException {
        block12: {
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getIncludeSynonyms() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.includeSynonyms);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.includeSynonyms;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRestrictGetTables(boolean restrict) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(restrict));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.restrictGettables = restrict;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getRestrictGetTables() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.restrictGettables);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.restrictGettables;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultFixedString(boolean fixed) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(fixed));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.fixedString = fixed;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultNChar(boolean defnchar) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(defnchar));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.defaultnchar = defnchar;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getDefaultFixedString() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.fixedString);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.fixedString;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNlsRatio() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 1);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = 1;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getC2SNlsRatio() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 1);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = 1;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void addStatement(OracleStatement os) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(os));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (os.next != null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Error: " + "add_statement called twice on " + os);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new Error("add_statement called twice on " + os);
            }
            os.next = this.statements;
            if (this.statements != null) {
                this.statements.prev = os;
            }
            this.statements = os;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeStatement(OracleStatement os) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(os));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleStatement p2 = os.prev;
            OracleStatement n2 = os.next;
            if (p2 == null) {
                if (this.statements != os) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    return;
                }
                this.statements = n2;
            } else {
                p2.next = n2;
            }
            if (n2 != null) {
                n2.prev = p2;
            }
            os.next = null;
            os.prev = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeStatements(boolean needToCache) throws SQLException {
        try {
            OracleStatement n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(needToCache));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleStatement s2 = this.statements;
            while (s2 != null) {
                n2 = s2.nextChild;
                if (s2.serverCursor) {
                    s2.close();
                    this.removeStatement(s2);
                }
                s2 = n2;
            }
            s2 = this.statements;
            while (s2 != null) {
                n2 = s2.next;
                if (needToCache) {
                    s2.close();
                } else {
                    s2.hardClose();
                }
                this.removeStatement(s2);
                s2 = n2;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void purgeStatementCache() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.isStatementCacheInitialized()) {
                this.statementCache.purgeImplicitCache();
                this.statementCache.purgeExplicitCache();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closeStatementCache() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.isStatementCacheInitialized()) {
                this.statementCache.close();
                this.statementCache = null;
                this.clearStatementMetaData = true;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void needLine() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.needLineUnchecked();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void needLineUnchecked() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.statementHoldingLine != null) {
                this.statementHoldingLine.freeLine();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void holdLine(oracle.jdbc.internal.OracleStatement stmt) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.holdLine((OracleStatement)stmt);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void holdLine(OracleStatement stmt) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.statementHoldingLine = stmt;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void releaseLine() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.releaseLineForCancel();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseLineForCancel() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.statementHoldingLine = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void startup(String startup_str, int mode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(startup_str) + ", " + OracleLog.argument(mode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void startup(OracleConnection.DatabaseStartupMode mode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument((Object)mode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (mode == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.needLine();
            this.doStartup(mode.getMode());
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStartup(int mode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(mode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown(OracleConnection.DatabaseShutdownMode mode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument((Object)mode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (mode == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.needLine();
            this.doShutdown(mode.getMode());
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doShutdown(int mode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(mode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void archive(int mode, int aseq, String acstext) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(mode) + ", " + OracleLog.argument(aseq) + ", " + OracleLog.argument(acstext));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void registerSQLType(String sql_name, String java_class_name) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql_name) + ", " + OracleLog.argument(java_class_name));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (sql_name == null || java_class_name == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            try {
                this.registerSQLType(sql_name, Class.forName(java_class_name));
            }
            catch (ClassNotFoundException e2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Class not found: " + java_class_name);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Class not found: " + java_class_name);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void registerSQLType(String sql_name, Class java_class) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql_name) + ", " + OracleLog.argument(java_class));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (sql_name == null || java_class == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.map == null) {
                this.map = new Hashtable(10);
            }
            this.map.put(sql_name, java_class);
            this.map.put(java_class.getName(), sql_name);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getSQLType(Object obj) throws SQLException {
        block28: {
            String string;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(obj));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (obj == null || this.map == null) break block28;
                String java_class_name = obj.getClass().getName();
                String __result__ = (String)this.map.get(java_class_name);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                string = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return string;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        String string = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object getJavaObject(String sql_name) throws SQLException {
        Object var3_4;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql_name));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object obj = null;
            try {
                if (sql_name != null && this.map != null) {
                    Class java_class = (Class)this.map.get(sql_name);
                    obj = java_class.newInstance();
                }
            }
            catch (IllegalAccessException e2) {
                e2.printStackTrace();
            }
            catch (InstantiationException e3) {
                e3.printStackTrace();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + obj);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var3_4 = obj;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return var3_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void putDescriptor(String sql_name, Object desc) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(sql_name) + ", " + OracleLog.argument(desc));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (sql_name != null && desc != null) {
                    if (this.descriptorCacheStack[this.dci] == null) {
                        this.descriptorCacheStack[this.dci] = new Hashtable(10);
                    }
                    ((TypeDescriptor)desc).fixupConnection(this);
                    this.descriptorCacheStack[this.dci].put(sql_name, desc);
                    break block20;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object getDescriptor(String sql_name) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(sql_name));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object desc = null;
            if (sql_name != null) {
                if (this.descriptorCacheStack[this.dci] != null) {
                    desc = this.descriptorCacheStack[this.dci].get(sql_name);
                }
                if (desc == null && this.dci == 1 && this.descriptorCacheStack[0] != null) {
                    desc = this.descriptorCacheStack[0].get(sql_name);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + desc);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object var3_5 = desc;
            return var3_5;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeDecriptor(String sql_name) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(sql_name));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.removeDescriptor(sql_name);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeDescriptor(String sql_name) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(sql_name));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (sql_name != null && this.descriptorCacheStack[this.dci] != null) {
                this.descriptorCacheStack[this.dci].remove(sql_name);
            }
            if (sql_name != null && this.dci == 1 && this.descriptorCacheStack[0] != null) {
                this.descriptorCacheStack[0].remove(sql_name);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeAllDescriptor() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            for (int i2 = 0; i2 <= this.dci; ++i2) {
                if (this.descriptorCacheStack[i2] == null) continue;
                this.descriptorCacheStack[i2].clear();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numberOfDescriptorCacheEntries() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int result = 0;
            for (int i2 = 0; i2 <= this.dci; ++i2) {
                if (this.descriptorCacheStack[i2] == null) continue;
                result += this.descriptorCacheStack[i2].size();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = result;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration descriptorCacheKeys() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.dci == 0) {
                if (this.descriptorCacheStack[this.dci] != null) {
                    Enumeration __result__ = this.descriptorCacheStack[this.dci].keys();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    Enumeration enumeration = __result__;
                    return enumeration;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Enumeration __result__ = null;
                return __result__;
            }
            if (this.descriptorCacheStack[0] == null && this.descriptorCacheStack[1] != null) {
                Enumeration __result__ = this.descriptorCacheStack[1].keys();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Enumeration enumeration = __result__;
                return enumeration;
            }
            if (this.descriptorCacheStack[1] == null && this.descriptorCacheStack[0] != null) {
                Enumeration __result__ = this.descriptorCacheStack[0].keys();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Enumeration enumeration = __result__;
                return enumeration;
            }
            if (this.descriptorCacheStack[0] == null && this.descriptorCacheStack[1] == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Enumeration __result__ = null;
                return __result__;
            }
            Vector v = new Vector(this.descriptorCacheStack[1].keySet());
            v.addAll(this.descriptorCacheStack[0].keySet());
            Enumeration __result__ = v.elements();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Enumeration enumeration = __result__;
            return enumeration;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void putDescriptor(byte[] toid, Object desc) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(toid) + ", " + OracleLog.argument(desc));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (toid != null && desc != null) {
                    if (this.descriptorCacheStack[this.dci] == null) {
                        this.descriptorCacheStack[this.dci] = new Hashtable(10);
                    }
                    this.descriptorCacheStack[this.dci].put(new ByteArrayKey(toid), desc);
                    break block20;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object getDescriptor(byte[] toid) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(toid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object desc = null;
            if (toid != null) {
                ByteArrayKey k2 = new ByteArrayKey(toid);
                if (this.descriptorCacheStack[this.dci] != null) {
                    desc = this.descriptorCacheStack[this.dci].get(k2);
                }
                if (desc == null && this.dci == 1 && this.descriptorCacheStack[0] != null) {
                    desc = this.descriptorCacheStack[0].get(k2);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + desc);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object var3_4 = desc;
            return var3_4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeDecriptor(byte[] toid) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(toid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (toid != null) {
                ByteArrayKey k2 = new ByteArrayKey(toid);
                if (this.descriptorCacheStack[this.dci] != null) {
                    this.descriptorCacheStack[this.dci].remove(k2);
                }
                if (this.dci == 1 && this.descriptorCacheStack[0] != null) {
                    this.descriptorCacheStack[0].remove(k2);
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getJdbcCsId() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.conversion == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 65);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 65);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            short __result__ = this.conversion.getClientCharSet();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short s2 = __result__;
            return s2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getDbCsId() throws SQLException {
        short s2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.conversion == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 65);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 65);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            short __result__ = this.conversion.getServerCharSetId();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            s2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getNCsId() throws SQLException {
        short s2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.conversion == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 65);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 65);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            short __result__ = this.conversion.getNCharSetId();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            s2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getStructAttrCsId() throws SQLException {
        short s2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short __result__ = this.getDbCsId();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            s2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getStructAttrNCsId() throws SQLException {
        short s2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short __result__ = this.getNCsId();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            s2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map getTypeMap() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.map == null) {
                this.map = new Hashtable(10);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.map);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Map map = this.map;
            return map;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setTypeMap(Map map) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.map = map;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setUsingXAFlag(boolean value) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.usingXA = value;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean getUsingXAFlag() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.usingXA);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.usingXA;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setXAErrorFlag(boolean value) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.xaWantsError = value;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean getXAErrorFlag() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.xaWantsError);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.xaWantsError;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getPropertyFromDatabase(String sql) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String returnValue = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.createStatement();
                stmt.setFetchSize(1);
                rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    returnValue = rs.getString(1);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            String __result__ = returnValue;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getUserName() throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.userName == null) {
                this.userName = this.getPropertyFromDatabase("SELECT USER FROM DUAL");
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.userName);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = this.userName;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentSchema() throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String __result__ = this.getPropertyFromDatabase("SELECT SYS_CONTEXT('USERENV', 'CURRENT_SCHEMA') FROM DUAL");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultSchemaNameForNamedTypes() throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String returnValue = null;
            returnValue = this.createDescriptorUseCurrentSchemaForSchemaName ? this.getCurrentSchema() : this.getUserName();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + returnValue);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = returnValue;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setStartTime(long startTime) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(startTime));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 152);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 152);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long getStartTime() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 152);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 152);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerHeartbeat() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.logicalConnectionAttached != null) {
                this.logicalConnectionAttached.registerHeartbeat();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHeartbeatNoChangeCount() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 152);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 152);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] getFDO(boolean init) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(init));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.fdo == null && init) {
                CallableStatement cstmt = null;
                try {
                    cstmt = this.prepareCall("begin :1 := dbms_pickler.get_format (:2); end;");
                    cstmt.registerOutParameter(1, 2);
                    cstmt.registerOutParameter(2, -4);
                    cstmt.execute();
                    this.fdo = cstmt.getBytes(2);
                }
                finally {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                    cstmt = null;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.fdo);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = this.fdo;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setFDO(byte[] fdo) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(fdo));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.fdo = fdo;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean getBigEndian() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.bigEndian == null) {
                int[] ub1fdo = Util.toJavaUnsignedBytes(this.getFDO(true));
                int kopfdo_auxinfo = ub1fdo[6 + ub1fdo[5] + ub1fdo[6] + 5];
                int offset = kopfdo_auxinfo & 0x10;
                if (offset < 0) {
                    offset += 256;
                }
                this.bigEndian = offset > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            boolean __result__ = this.bigEndian;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHoldability(int holdability) throws SQLException {
        block18: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(holdability));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block18;
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHoldability() throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 1);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = 1;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        OracleSavepoint oracleSavepoint;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleSavepoint __result__ = this.oracleSetSavepoint();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oracleSavepoint = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oracleSavepoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        OracleSavepoint oracleSavepoint;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(name));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleSavepoint __result__ = this.oracleSetSavepoint(name);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oracleSavepoint = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oracleSavepoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(savepoint));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.disallowGlobalTxnMode(122);
            if (this.autocommit) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 121);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 121);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.savepointStatement == null) {
                this.savepointStatement = this.createStatement();
            }
            String _svptName = null;
            try {
                _svptName = savepoint.getSavepointName();
            }
            catch (SQLException exc) {
                _svptName = "ORACLE_SVPT_" + savepoint.getSavepointId();
            }
            this.savepointStatement.executeUpdate("ROLLBACK TO " + _svptName);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(savepoint));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement statement;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency) + ", " + OracleLog.argument(resultSetHoldability));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Statement __result__ = this.createStatement(resultSetType, resultSetConcurrency);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            statement = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement preparedStatement;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency) + ", " + OracleLog.argument(resultSetHoldability));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PreparedStatement __result__ = this.prepareStatement(sql, resultSetType, resultSetConcurrency);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            preparedStatement = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement callableStatement;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency) + ", " + OracleLog.argument(resultSetHoldability));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CallableStatement __result__ = this.prepareCall(sql, resultSetType, resultSetConcurrency);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            callableStatement = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return callableStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        AutoKeyInfo info;
        block33: {
            PreparedStatement preparedStatement;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(autoGeneratedKeys));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                info = new AutoKeyInfo(sql);
                if (autoGeneratedKeys != 2 && info.isInsertSqlStmt()) break block33;
                PreparedStatement __result__ = this.prepareStatement(sql);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                preparedStatement = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return preparedStatement;
        }
        if (autoGeneratedKeys != 1) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        String newSql = info.getNewSql();
        oracle.jdbc.OraclePreparedStatement returnValue = (oracle.jdbc.OraclePreparedStatement)this.prepareStatement(newSql);
        OraclePreparedStatement pstmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)returnValue).preparedStatement;
        pstmt.isAutoGeneratedKey = true;
        pstmt.autoKeyInfo = info;
        pstmt.registerReturnParamsForAutoKey();
        oracle.jdbc.OraclePreparedStatement __result__ = returnValue;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        oracle.jdbc.OraclePreparedStatement oraclePreparedStatement = __result__;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oraclePreparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        AutoKeyInfo info;
        block29: {
            PreparedStatement preparedStatement;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(columnIndexes));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((info = new AutoKeyInfo(sql, columnIndexes)).isInsertSqlStmt()) break block29;
                preparedStatement = this.prepareStatement(sql);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return preparedStatement;
        }
        if (columnIndexes == null || columnIndexes.length == 0) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        this.doDescribeTable(info);
        String newSql = info.getNewSql();
        oracle.jdbc.OraclePreparedStatement returnValue = (oracle.jdbc.OraclePreparedStatement)this.prepareStatement(newSql);
        OraclePreparedStatement pstmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)returnValue).preparedStatement;
        pstmt.isAutoGeneratedKey = true;
        pstmt.autoKeyInfo = info;
        pstmt.registerReturnParamsForAutoKey();
        oracle.jdbc.OraclePreparedStatement __result__ = returnValue;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        oracle.jdbc.OraclePreparedStatement oraclePreparedStatement = __result__;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oraclePreparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        AutoKeyInfo info;
        block29: {
            PreparedStatement preparedStatement;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(columnNames));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((info = new AutoKeyInfo(sql, columnNames)).isInsertSqlStmt()) break block29;
                preparedStatement = this.prepareStatement(sql);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return preparedStatement;
        }
        if (columnNames == null || columnNames.length == 0) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        this.doDescribeTable(info);
        String newSql = info.getNewSql();
        oracle.jdbc.OraclePreparedStatement returnValue = (oracle.jdbc.OraclePreparedStatement)this.prepareStatement(newSql);
        OraclePreparedStatement pstmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)returnValue).preparedStatement;
        pstmt.isAutoGeneratedKey = true;
        pstmt.autoKeyInfo = info;
        pstmt.registerReturnParamsForAutoKey();
        oracle.jdbc.OraclePreparedStatement __result__ = returnValue;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        oracle.jdbc.OraclePreparedStatement oraclePreparedStatement = __result__;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oraclePreparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized OracleSavepoint oracleSetSavepoint() throws SQLException {
        oracle.jdbc.driver.OracleSavepoint oracleSavepoint;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.disallowGlobalTxnMode(117);
            if (this.autocommit) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 120);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 120);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.savepointStatement == null) {
                this.savepointStatement = this.createStatement();
            }
            oracle.jdbc.driver.OracleSavepoint _osvpt = new oracle.jdbc.driver.OracleSavepoint();
            String _svptSqlString = "SAVEPOINT ORACLE_SVPT_" + _osvpt.getSavepointId();
            this.savepointStatement.executeUpdate(_svptSqlString);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + _osvpt);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oracleSavepoint = _osvpt;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oracleSavepoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized OracleSavepoint oracleSetSavepoint(String name) throws SQLException {
        oracle.jdbc.driver.OracleSavepoint oracleSavepoint;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(name));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.disallowGlobalTxnMode(117);
            if (this.autocommit) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 120);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 120);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.savepointStatement == null) {
                this.savepointStatement = this.createStatement();
            }
            oracle.jdbc.driver.OracleSavepoint _osvpt = new oracle.jdbc.driver.OracleSavepoint(name);
            String _svptSqlString = "SAVEPOINT " + _osvpt.getSavepointName();
            this.savepointStatement.executeUpdate(_svptSqlString);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + _osvpt);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oracleSavepoint = _osvpt;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oracleSavepoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void oracleRollback(OracleSavepoint savepoint) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(savepoint));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.disallowGlobalTxnMode(115);
            if (this.autocommit) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 121);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 121);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.savepointStatement == null) {
                this.savepointStatement = this.createStatement();
            }
            String _svptName = null;
            try {
                _svptName = savepoint.getSavepointName();
            }
            catch (SQLException exc) {
                _svptName = "ORACLE_SVPT_" + savepoint.getSavepointId();
            }
            this.savepointStatement.executeUpdate("ROLLBACK TO " + _svptName);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void oracleReleaseSavepoint(OracleSavepoint savepoint) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(savepoint));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disallowGlobalTxnMode(int errorCode) throws SQLException {
        block18: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(errorCode));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.txnMode != 1) break block18;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + errorCode);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), errorCode);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTxnMode(int mode) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(mode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.txnMode = mode;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTxnMode() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.txnMode);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.txnMode;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object getClientData(Object key) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(key));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.clientData == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Object var2_3 = null;
                return var2_3;
            }
            Object __result__ = this.clientData.get(key);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object v = __result__;
            return v;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object setClientData(Object key, Object value) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(key) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.clientData == null) {
                this.clientData = new Hashtable();
            }
            Object __result__ = this.clientData.put(key, value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = __result__;
            return object;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object removeClientData(Object key) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(key));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.clientData == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Object var2_3 = null;
                return var2_3;
            }
            Object __result__ = this.clientData.remove(key);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object v = __result__;
            return v;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlobDBAccess createBlobDBAccess() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClobDBAccess createClobDBAccess() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BfileDBAccess createBfileDBAccess() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printState() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                short jdbc_cs_id = this.getJdbcCsId();
                short db_cs_id = this.getDbCsId();
                short struct_cs_id = this.getStructAttrCsId();
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProtocolType() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.protocol);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.protocol;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getURL() {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.url);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = this.url;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setStmtCacheSize(int size) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(size));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.setStatementCacheSize(size);
            this.setImplicitCachingEnabled(true);
            this.setExplicitCachingEnabled(true);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setStmtCacheSize(int size, boolean clearMetaData) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(size) + ", " + OracleLog.argument(clearMetaData));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.setStatementCacheSize(size);
            this.setImplicitCachingEnabled(true);
            this.setExplicitCachingEnabled(true);
            this.clearStatementMetaData = clearMetaData;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getStmtCacheSize() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int returnValue = 0;
            try {
                returnValue = this.getStatementCacheSize();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (returnValue == -1) {
                returnValue = 0;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + returnValue);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = returnValue;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setStatementCacheSize(int size) throws SQLException {
        block16: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(size));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.statementCache == null) {
                    this.statementCache = new LRUStatementCache(size);
                    break block16;
                }
                this.statementCache.resize(size);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getStatementCacheSize() throws SQLException {
        block28: {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.statementCache != null) break block28;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -1);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = -1;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
        int __result__ = this.statementCache.getCacheSize();
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        int n3 = __result__;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setImplicitCachingEnabled(boolean cache) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cache));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.statementCache == null) {
                this.statementCache = new LRUStatementCache(0);
            }
            this.statementCache.setImplicitCachingEnabled(cache);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean getImplicitCachingEnabled() throws SQLException {
        block28: {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.statementCache != null) break block28;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = false;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
        boolean __result__ = this.statementCache.getImplicitCachingEnabled();
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        boolean bl = __result__;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setExplicitCachingEnabled(boolean cache) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cache));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.statementCache == null) {
                this.statementCache = new LRUStatementCache(0);
            }
            this.statementCache.setExplicitCachingEnabled(cache);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean getExplicitCachingEnabled() throws SQLException {
        block28: {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.statementCache != null) break block28;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = false;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
        boolean __result__ = this.statementCache.getExplicitCachingEnabled();
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        boolean bl = __result__;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void purgeImplicitCache() throws SQLException {
        block15: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.statementCache == null) break block15;
                this.statementCache.purgeImplicitCache();
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void purgeExplicitCache() throws SQLException {
        block15: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.statementCache == null) break block15;
                this.statementCache.purgeExplicitCache();
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public synchronized PreparedStatement getStatementWithKey(String key) throws SQLException {
        block32: {
            try {
                if (PhysicalConnection.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(key));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.statementCache == null) ** GOTO lbl56
                os = this.statementCache.searchExplicitCache(key);
                if (os != null && os.statementType != 1) break block32;
                __result__ = (PreparedStatement)os;
                if (PhysicalConnection.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_8 = __result__;
            }
            catch (Throwable var9_13) {
                if (PhysicalConnection.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw var9_13;
            }
            if (PhysicalConnection.TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var4_8;
        }
        if (PhysicalConnection.TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 125);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 125);
        __ex__.fillInStackTrace();
        throw __ex__;
lbl56:
        // 1 sources

        if (PhysicalConnection.TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        var2_4 = null;
        if (PhysicalConnection.TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return var2_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public synchronized CallableStatement getCallWithKey(String key) throws SQLException {
        block32: {
            try {
                if (PhysicalConnection.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(key));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.statementCache == null) ** GOTO lbl56
                os = this.statementCache.searchExplicitCache(key);
                if (os != null && os.statementType != 2) break block32;
                __result__ = (CallableStatement)os;
                if (PhysicalConnection.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_8 = __result__;
            }
            catch (Throwable var9_13) {
                if (PhysicalConnection.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw var9_13;
            }
            if (PhysicalConnection.TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var4_8;
        }
        if (PhysicalConnection.TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 125);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 125);
        __ex__.fillInStackTrace();
        throw __ex__;
lbl56:
        // 1 sources

        if (PhysicalConnection.TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        var2_4 = null;
        if (PhysicalConnection.TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return var2_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cacheImplicitStatement(OraclePreparedStatement stmt, String sql, int statementType, int scrollType) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(sql) + ", " + OracleLog.argument(statementType) + ", " + OracleLog.argument(scrollType));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.statementCache == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 95);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 95);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.statementCache.addToImplicitCache(stmt, sql, statementType, scrollType);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cacheExplicitStatement(OraclePreparedStatement stmt, String key) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(key));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.statementCache == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 95);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 95);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.statementCache.addToExplicitCache(stmt, key);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isStatementCacheInitialized() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.statementCache == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            if (this.statementCache.getCacheSize() == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private BufferCacheStore getBufferCacheStore() {
        if (this.useThreadLocalBufferCache) {
            if (threadLocalBufferCacheStore == null) {
                BufferCacheStore.MAX_CACHED_BUFFER_SIZE = this.maxCachedBufferSize;
                threadLocalBufferCacheStore = new ThreadLocal<BufferCacheStore>(){

                    @Override
                    protected BufferCacheStore initialValue() {
                        return new BufferCacheStore();
                    }
                };
            }
            return threadLocalBufferCacheStore.get();
        }
        if (this.connectionBufferCacheStore == null) {
            this.connectionBufferCacheStore = new BufferCacheStore(this.maxCachedBufferSize);
        }
        return this.connectionBufferCacheStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheBuffer(byte[] buffer) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(buffer));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (buffer != null) {
                BufferCacheStore s2 = this.getBufferCacheStore();
                s2.byteBufferCache.put(buffer);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheBuffer(char[] buffer) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(buffer));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (buffer != null) {
                BufferCacheStore s2 = this.getBufferCacheStore();
                s2.charBufferCache.put(buffer);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheBufferSync(char[] buffer) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(buffer));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PhysicalConnection physicalConnection = this;
            synchronized (physicalConnection) {
                this.cacheBuffer(buffer);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getByteBuffer(int length) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(length));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BufferCacheStore s2 = this.getBufferCacheStore();
            byte[] __result__ = s2.byteBufferCache.get(Byte.TYPE, length);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    char[] getCharBuffer(int length) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(length));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BufferCacheStore s2 = this.getBufferCacheStore();
            char[] __result__ = s2.charBufferCache.get(Character.TYPE, length);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            char[] cArray = __result__;
            return cArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getCharBufferSync(int length) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(length));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PhysicalConnection physicalConnection = this;
            synchronized (physicalConnection) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.getCharBuffer(length));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                char[] cArray = this.getCharBuffer(length);
                return cArray;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleConnection.BufferCacheStatistics getByteBufferCacheStatistics() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BufferCacheStore s2 = this.getBufferCacheStore();
            OracleConnection.BufferCacheStatistics __result__ = s2.byteBufferCache.getStatistics();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection.BufferCacheStatistics bufferCacheStatistics = __result__;
            return bufferCacheStatistics;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleConnection.BufferCacheStatistics getCharBufferCacheStatistics() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BufferCacheStore s2 = this.getBufferCacheStore();
            OracleConnection.BufferCacheStatistics __result__ = s2.charBufferCache.getStatistics();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection.BufferCacheStatistics bufferCacheStatistics = __result__;
            return bufferCacheStatistics;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void registerTAFCallback(OracleOCIFailover cbk, Object obj) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cbk) + ", " + OracleLog.argument(obj));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDatabaseProductVersion() throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.databaseProductVersion == uninitializedMarker) {
                this.needLine();
                this.databaseProductVersion = this.doGetDatabaseProductVersion();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.databaseProductVersion);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = this.databaseProductVersion;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getReportRemarks() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.reportRemarks);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.reportRemarks;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getVersionNumber() throws SQLException {
        short s2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.versionNumber == -1) {
                PhysicalConnection physicalConnection = this;
                synchronized (physicalConnection) {
                    if (this.versionNumber == -1) {
                        this.needLine();
                        this.versionNumber = this.doGetVersionNumber();
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.versionNumber);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            s2 = this.versionNumber;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerCloseCallback(OracleCloseCallback occ, Object privData) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(occ) + ", " + OracleLog.argument(privData));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.closeCallback = occ;
            this.privateData = privData;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCreateStatementAsRefCursor(boolean value) {
        block13: {
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getCreateStatementAsRefCursor() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = false;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int pingDatabase() throws SQLException {
        block28: {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.lifecycle == 1) break block28;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -1);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = -1;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
        int __result__ = this.doPingDatabase();
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        int n3 = __result__;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public int pingDatabase(int timeOut) throws SQLException {
        int n2;
        block50: {
            block47: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(timeOut));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.lifecycle == 1) break block47;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -1);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n3 = -1;
                {
                    catch (Throwable throwable) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw throwable;
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return n3;
            }
            if (timeOut != 0) break block50;
            int __result__ = this.pingDatabase();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n4 = __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n4;
        }
        try {
            this.pingResult = -2;
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        PhysicalConnection.this.pingResult = PhysicalConnection.this.doPingDatabase();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            t.start();
            t.join(timeOut * 1000);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.pingResult);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.pingResult;
        }
        catch (InterruptedException ex) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -3);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n5 = -3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n5;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int doPingDatabase() throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        Statement stmt = null;
        try {
            stmt = this.createStatement();
            ((oracle.jdbc.OracleStatement)stmt).defineColumnType(1, 12, 1);
            stmt.executeQuery("SELECT 'x' FROM DUAL");
        }
        catch (SQLException ea) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -1);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = -1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        int n3 = 0;
        return n3;
        {
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map getJavaObjectTypeMap() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.javaObjectMap);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Map map = this.javaObjectMap;
            return map;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setJavaObjectTypeMap(Map map) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.javaObjectMap = map;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearClientIdentifier(String clientId) throws SQLException {
        block15: {
            try {
                String[] metrics;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(clientId));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (clientId == null || clientId.length() == 0 || (metrics = this.getEndToEndMetrics()) == null || !clientId.equals(metrics[1])) break block15;
                metrics[1] = null;
                this.setEndToEndMetrics(metrics, this.getEndToEndECIDSequenceNumber());
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientIdentifier(String clientId) throws SQLException {
        try {
            String[] metrics;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(clientId));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((metrics = this.getEndToEndMetrics()) == null) {
                metrics = new String[4];
            }
            metrics[1] = clientId;
            this.setEndToEndMetrics(metrics, this.getEndToEndECIDSequenceNumber());
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSessionTimeZone(String regionName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(regionName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Statement stmt = null;
            Object rset = null;
            try {
                stmt = this.createStatement();
                stmt.executeUpdate("ALTER SESSION SET TIME_ZONE = '" + regionName + "'");
                if (this.dbTzCalendar == null) {
                    this.setDbTzCalendar(this.getDatabaseTimeZone());
                }
            }
            catch (SQLException e2) {
                throw e2;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            this.sessionTimeZone = regionName;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDatabaseTimeZone() throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.databaseTimeZone == null) {
                this.databaseTimeZone = this.getPropertyFromDatabase("SELECT DBTIMEZONE FROM DUAL");
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.databaseTimeZone);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = this.databaseTimeZone;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSessionTimeZone() {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.sessionTimeZone);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = this.sessionTimeZone;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String to2DigitString(int number) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(number));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String twoDigit = number < 10 ? "0" + number : uninitializedMarker + number;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Return: " + twoDigit);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = twoDigit;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tzToOffset(String sessiontzhours) {
        block31: {
            String string;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sessiontzhours));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (sessiontzhours != null) break block31;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sessiontzhours);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                string = sessiontzhours;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return string;
        }
        char sign = sessiontzhours.charAt(0);
        if (sign != '-' && sign != '+') {
            TimeZone tz = TimeZone.getTimeZone(sessiontzhours);
            int sessTZOffsetMillis = tz.getOffset(System.currentTimeMillis());
            if (sessTZOffsetMillis != 0) {
                int sessTZOffsetMinutes = sessTZOffsetMillis / 60000;
                int sessTZOffsetHours = sessTZOffsetMinutes / 60;
                sessiontzhours = sessTZOffsetMillis > 0 ? "+" + PhysicalConnection.to2DigitString(sessTZOffsetHours) + ":" + PhysicalConnection.to2DigitString(sessTZOffsetMinutes) : "-" + PhysicalConnection.to2DigitString(-sessTZOffsetHours) + ":" + PhysicalConnection.to2DigitString(-(sessTZOffsetMinutes -= sessTZOffsetHours * 60));
            } else {
                sessiontzhours = "+00:00";
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sessiontzhours);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        String string = sessiontzhours;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSessionTimeZoneOffset() throws SQLException {
        String string;
        try {
            String sessiontzhours;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((sessiontzhours = this.getPropertyFromDatabase("SELECT SESSIONTIMEZONE FROM DUAL")) != null) {
                sessiontzhours = this.tzToOffset(sessiontzhours.trim());
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sessiontzhours);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = sessiontzhours;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDbTzCalendar(String dbTzStr) {
        try {
            char sign;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(dbTzStr));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((sign = dbTzStr.charAt(0)) == '-' || sign == '+') {
                dbTzStr = "GMT" + dbTzStr;
            }
            TimeZone tz = TimeZone.getTimeZone(dbTzStr);
            this.dbTzCalendar = new GregorianCalendar(tz);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Calendar getDbTzCalendar() throws SQLException {
        Calendar calendar;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.dbTzCalendar == null) {
                this.setDbTzCalendar(this.getDatabaseTimeZone());
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.dbTzCalendar);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            calendar = this.dbTzCalendar;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccumulateBatchResult(boolean val) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(val));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.accumulateBatchResult = val;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAccumulateBatchResult() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.accumulateBatchResult);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.accumulateBatchResult;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJ2EE13Compliant(boolean val) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(val));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.j2ee13Compliant = val;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getJ2EE13Compliant() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.j2ee13Compliant);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.j2ee13Compliant;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class classForNameAndSchema(String name, String schemaName) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(schemaName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Class<?> __result__ = Class.forName(name);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            clazz = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class safelyGetClassForName(String name) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(name));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Class<?> __result__ = Class.forName(name);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            clazz = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHeapAllocSize() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOCIEnvHeapAllocSize() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OracleConnection unwrapCompletely(oracle.jdbc.OracleConnection wrappedConnection) {
        try {
            oracle.jdbc.OracleConnection previous;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(wrappedConnection));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oracle.jdbc.OracleConnection next = previous = wrappedConnection;
            while (true) {
                if (next == null) {
                    OracleConnection __result__ = (OracleConnection)previous;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(Level.FINER, "         Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    OracleConnection oracleConnection = __result__;
                    return oracleConnection;
                }
                previous = next;
                next = previous.unwrap();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWrapper(oracle.jdbc.OracleConnection w) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(w));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.wrapper = w;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public oracle.jdbc.OracleConnection unwrap() {
        oracle.jdbc.OracleConnection oracleConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oracleConnection = null;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oracleConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public oracle.jdbc.OracleConnection getWrapper() {
        block28: {
            oracle.jdbc.OracleConnection oracleConnection;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.wrapper == null) break block28;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.wrapper);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracleConnection = this.wrapper;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oracleConnection;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        PhysicalConnection physicalConnection = this;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return physicalConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static oracle.jdbc.internal.OracleConnection _physicalConnectionWithin(Connection possiblyWrappedPossiblyLogicalConnection) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(possiblyWrappedPossiblyLogicalConnection));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection unwrappedConnection = null;
            if (possiblyWrappedPossiblyLogicalConnection != null) {
                unwrappedConnection = PhysicalConnection.unwrapCompletely((oracle.jdbc.OracleConnection)possiblyWrappedPossiblyLogicalConnection);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Return: " + unwrappedConnection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = unwrappedConnection;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public oracle.jdbc.internal.OracleConnection physicalConnectionWithin() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PhysicalConnection physicalConnection = this;
            return physicalConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTdoCState(String schemaName, String typeName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(schemaName) + ", " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0L);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = 0L;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public void getOracleTypeADT(OracleTypeADT otype) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum toDatum(CustomDatum inObject) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(inObject));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum __result__ = inObject.toDatum(this);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum datum = __result__;
            return datum;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getNCharSet() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short __result__ = this.conversion.getNCharSetId();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short s2 = __result__;
            return s2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet newArrayDataResultSet(Datum[] data, long index, int count, Map map) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(data) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayDataResultSet __result__ = new ArrayDataResultSet((OracleConnection)this, data, index, count, map);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayDataResultSet arrayDataResultSet = __result__;
            return arrayDataResultSet;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet newArrayDataResultSet(ARRAY array, long index, int count, Map map) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(array) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayDataResultSet __result__ = new ArrayDataResultSet((OracleConnection)this, array, index, count, map);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayDataResultSet arrayDataResultSet = __result__;
            return arrayDataResultSet;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet newArrayLocatorResultSet(ArrayDescriptor desc, byte[] locator, long index, int count, Map map) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(desc) + ", " + OracleLog.argument(locator) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayLocatorResultSet __result__ = new ArrayLocatorResultSet(this, desc, locator, index, count, map);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayLocatorResultSet arrayLocatorResultSet = __result__;
            return arrayLocatorResultSet;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData newStructMetaData(StructDescriptor desc) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(desc));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StructMetaData __result__ = new StructMetaData(desc);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StructMetaData structMetaData = __result__;
            return structMetaData;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int CHARBytesToJavaChars(byte[] bytes, int nbytes, char[] chars) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(nbytes) + ", " + OracleLog.argument(chars));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int[] nBytes = new int[]{nbytes};
            int n2 = this.conversion.CHARBytesToJavaChars(bytes, 0, chars, 0, nBytes, chars.length);
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int NCHARBytesToJavaChars(byte[] bytes, int nbytes, char[] chars) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(nbytes) + ", " + OracleLog.argument(chars));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int[] nBytes = new int[1];
            int n2 = this.conversion.NCHARBytesToJavaChars(bytes, 0, chars, 0, nBytes, chars.length);
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean IsNCharFixedWith() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean __result__ = this.conversion.IsNCharFixedWith();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getDriverCharSet() {
        short s2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short __result__ = this.conversion.getClientCharSet();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            s2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxCharSize() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 58);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 58);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxCharbyteSize() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int __result__ = this.conversion.getMaxCharbyteSize();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxNCharbyteSize() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int __result__ = this.conversion.getMaxNCharbyteSize();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCharSetMultibyte(short charSet) {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(charSet));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean __result__ = DBConversion.isCharSetMultibyte(charSet);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int javaCharsToCHARBytes(char[] chars, int nchars, byte[] bytes) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(nchars) + ", " + OracleLog.argument(bytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int __result__ = this.conversion.javaCharsToCHARBytes(chars, nchars, bytes);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int javaCharsToNCHARBytes(char[] chars, int nchars, byte[] bytes) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(nchars) + ", " + OracleLog.argument(bytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int __result__ = this.conversion.javaCharsToNCHARBytes(chars, nchars, bytes);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    @Override
    public abstract void getPropertyForPooledConnection(OraclePooledConnection var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void getPropertyForPooledConnection(OraclePooledConnection pc, String password) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc) + ", " + OracleLog.argument("******"));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Hashtable<String, Map> hashTable = new Hashtable<String, Map>();
            hashTable.put("obj_type_map", this.javaObjectMap);
            Properties prop = new Properties();
            prop.put("user", this.userName);
            prop.put("password", password);
            prop.put("connection_url", this.url);
            prop.put("connect_auto_commit", uninitializedMarker + this.autocommit);
            prop.put("trans_isolation", uninitializedMarker + this.txnLevel);
            if (this.getStatementCacheSize() != -1) {
                prop.put("stmt_cache_size", uninitializedMarker + this.getStatementCacheSize());
                prop.put("implicit_cache_enabled", uninitializedMarker + this.getImplicitCachingEnabled());
                prop.put("explict_cache_enabled", uninitializedMarker + this.getExplicitCachingEnabled());
            }
            prop.put("defaultExecuteBatch", uninitializedMarker + this.defaultExecuteBatch);
            prop.put("defaultRowPrefetch", uninitializedMarker + this.defaultRowPrefetch);
            prop.put("remarksReporting", uninitializedMarker + this.reportRemarks);
            prop.put("AccumulateBatchResult", uninitializedMarker + this.accumulateBatchResult);
            prop.put("oracle.jdbc.J2EE13Compliant", uninitializedMarker + this.j2ee13Compliant);
            prop.put("processEscapes", uninitializedMarker + this.processEscapes);
            prop.put("restrictGetTables", uninitializedMarker + this.restrictGettables);
            prop.put("includeSynonyms", uninitializedMarker + this.includeSynonyms);
            prop.put("fixedString", uninitializedMarker + this.fixedString);
            hashTable.put("connection_properties", prop);
            pc.setProperties(hashTable);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getDBAccessProperties() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getOCIHandles() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    abstract void logon() throws SQLException;

    void logoff() throws SQLException {
    }

    abstract void open(OracleStatement var1) throws SQLException;

    abstract void cancelOperationOnServer(boolean var1) throws SQLException;

    abstract void doSetAutoCommit(boolean var1) throws SQLException;

    abstract void doCommit(int var1) throws SQLException;

    abstract void doRollback() throws SQLException;

    abstract String doGetDatabaseProductVersion() throws SQLException;

    abstract short doGetVersionNumber() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getDefaultStreamChunkSize() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.streamChunkSize);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.streamChunkSize;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    abstract OracleStatement RefCursorBytesToStatement(byte[] var1, OracleStatement var2) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public oracle.jdbc.internal.OracleStatement refCursorCursorToStatement(int cursorNumber) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(cursorNumber));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getLogicalConnection(OraclePooledConnection pc, boolean autoCommit) throws SQLException {
        try {
            LogicalConnection logicalConn;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc) + ", " + OracleLog.argument(autoCommit));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.logicalConnectionAttached != null || pc.getPhysicalHandle() != this) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 143);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 143);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.logicalConnectionAttached = logicalConn = new LogicalConnection(pc, this, autoCommit);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + logicalConn);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            LogicalConnection logicalConnection = logicalConn;
            return logicalConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    public void getForm(OracleTypeADT otypeADT, OracleTypeCLOB otype, int attrIndex) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB createClob(byte[] locator_bytes) throws SQLException {
        try {
            CLOB result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(locator_bytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((result = new CLOB(this, locator_bytes)).isNCLOB()) {
                result = new NCLOB(result);
            }
            CLOB __result__ = result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CLOB cLOB = __result__;
            return cLOB;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB createClobWithUnpickledBytes(byte[] locator_bytes) throws SQLException {
        try {
            CLOB result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(locator_bytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((result = new CLOB((oracle.jdbc.OracleConnection)this, locator_bytes, true)).isNCLOB()) {
                result = new NCLOB(result);
            }
            CLOB __result__ = result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CLOB cLOB = __result__;
            return cLOB;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB createClob(byte[] locator_bytes, short csform) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(locator_bytes) + ", " + OracleLog.argument(csform));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CLOB __result__ = new CLOB((oracle.jdbc.OracleConnection)this, locator_bytes, csform);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CLOB cLOB = __result__;
            return cLOB;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLOB createBlob(byte[] locator_bytes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(locator_bytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BLOB __result__ = new BLOB(this, locator_bytes);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BLOB bLOB = __result__;
            return bLOB;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLOB createBlobWithUnpickledBytes(byte[] locator_bytes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(locator_bytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BLOB __result__ = new BLOB(this, locator_bytes, true);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BLOB bLOB = __result__;
            return bLOB;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE createBfile(byte[] locator_bytes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(locator_bytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BFILE __result__ = new BFILE(this, locator_bytes);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BFILE bFILE = __result__;
            return bFILE;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ARRAY createARRAY(String typeName, Object elements) throws SQLException {
        ARRAY aRRAY;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(typeName) + ", " + OracleLog.argument(elements));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayDescriptor descriptor = ArrayDescriptor.createDescriptor(typeName, (Connection)this);
            ARRAY __result__ = new ARRAY(descriptor, this, elements);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            aRRAY = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return aRRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array createOracleArray(String arrayTypeName, Object elements) throws SQLException {
        ARRAY aRRAY;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(arrayTypeName) + ", " + OracleLog.argument(elements));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ARRAY __result__ = this.createARRAY(arrayTypeName, elements);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            aRRAY = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return aRRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BINARY_DOUBLE createBINARY_DOUBLE(double value) throws SQLException {
        BINARY_DOUBLE bINARY_DOUBLE;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BINARY_DOUBLE __result__ = new BINARY_DOUBLE(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bINARY_DOUBLE = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bINARY_DOUBLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BINARY_FLOAT createBINARY_FLOAT(float value) throws SQLException {
        BINARY_FLOAT bINARY_FLOAT;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BINARY_FLOAT __result__ = new BINARY_FLOAT(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bINARY_FLOAT = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bINARY_FLOAT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE createDATE(Date value) throws SQLException {
        DATE dATE;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            DATE __result__ = new DATE(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            dATE = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return dATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE createDATE(Time value) throws SQLException {
        DATE dATE;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            DATE __result__ = new DATE(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            dATE = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return dATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE createDATE(Timestamp value) throws SQLException {
        DATE dATE;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            DATE __result__ = new DATE(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            dATE = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return dATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE createDATE(Date value, Calendar cal) throws SQLException {
        DATE dATE;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            DATE __result__ = new DATE(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            dATE = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return dATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE createDATE(Time value, Calendar cal) throws SQLException {
        DATE dATE;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            DATE __result__ = new DATE(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            dATE = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return dATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE createDATE(Timestamp value, Calendar cal) throws SQLException {
        DATE dATE;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            DATE __result__ = new DATE(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            dATE = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return dATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE createDATE(String value) throws SQLException {
        DATE dATE;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            DATE __result__ = new DATE(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            dATE = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return dATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALDS createINTERVALDS(String value) throws SQLException {
        INTERVALDS iNTERVALDS;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            INTERVALDS __result__ = new INTERVALDS(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            iNTERVALDS = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return iNTERVALDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALYM createINTERVALYM(String value) throws SQLException {
        INTERVALYM iNTERVALYM;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            INTERVALYM __result__ = new INTERVALYM(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            iNTERVALYM = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return iNTERVALYM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(boolean value) throws SQLException {
        NUMBER nUMBER;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NUMBER __result__ = new NUMBER(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            nUMBER = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(byte value) throws SQLException {
        NUMBER nUMBER;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NUMBER __result__ = new NUMBER(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            nUMBER = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(short value) throws SQLException {
        NUMBER nUMBER;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NUMBER __result__ = new NUMBER(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            nUMBER = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(int value) throws SQLException {
        NUMBER nUMBER;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NUMBER __result__ = new NUMBER(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            nUMBER = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(long value) throws SQLException {
        NUMBER nUMBER;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NUMBER __result__ = new NUMBER(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            nUMBER = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(float value) throws SQLException {
        NUMBER nUMBER;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NUMBER __result__ = new NUMBER(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            nUMBER = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(double value) throws SQLException {
        NUMBER nUMBER;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NUMBER __result__ = new NUMBER(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            nUMBER = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(BigDecimal value) throws SQLException {
        NUMBER nUMBER;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NUMBER __result__ = new NUMBER(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            nUMBER = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(BigInteger value) throws SQLException {
        NUMBER nUMBER;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NUMBER __result__ = new NUMBER(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            nUMBER = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(String value, int scale) throws SQLException {
        NUMBER nUMBER;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(scale));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NUMBER __result__ = new NUMBER(value, scale);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            nUMBER = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(typeName) + ", " + OracleLog.argument(elements));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(typeName) + ", " + OracleLog.argument(attributes));
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        StructDescriptor descriptor = StructDescriptor.createDescriptor(typeName, (Connection)this);
        STRUCT __result__ = new STRUCT(descriptor, (Connection)this, attributes);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        STRUCT sTRUCT = __result__;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return sTRUCT;
        {
            catch (SQLException ex) {
                try {
                    if (ex.getErrorCode() == 17049) {
                        this.removeAllDescriptor();
                    }
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP createTIMESTAMP(Date value) throws SQLException {
        TIMESTAMP tIMESTAMP;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMP __result__ = new TIMESTAMP(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMP = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP createTIMESTAMP(DATE value) throws SQLException {
        TIMESTAMP tIMESTAMP;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMP __result__ = new TIMESTAMP(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMP = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP createTIMESTAMP(Time value) throws SQLException {
        TIMESTAMP tIMESTAMP;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMP __result__ = new TIMESTAMP(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMP = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP createTIMESTAMP(Timestamp value) throws SQLException {
        TIMESTAMP tIMESTAMP;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMP __result__ = new TIMESTAMP(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMP = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP createTIMESTAMP(String value) throws SQLException {
        TIMESTAMP tIMESTAMP;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMP __result__ = new TIMESTAMP(value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMP = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Date value) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPTZ __result__ = new TIMESTAMPTZ((Connection)this, value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMPTZ = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Date value, Calendar cal) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPTZ __result__ = new TIMESTAMPTZ((Connection)this, value, cal);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMPTZ = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Time value) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPTZ __result__ = new TIMESTAMPTZ((Connection)this, value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMPTZ = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Time value, Calendar cal) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPTZ __result__ = new TIMESTAMPTZ((Connection)this, value, cal);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMPTZ = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Timestamp value) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPTZ __result__ = new TIMESTAMPTZ((Connection)this, value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMPTZ = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Timestamp value, Calendar cal) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPTZ __result__ = new TIMESTAMPTZ((Connection)this, value, cal);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMPTZ = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(String value) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPTZ __result__ = new TIMESTAMPTZ((Connection)this, value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMPTZ = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(String value, Calendar cal) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPTZ __result__ = new TIMESTAMPTZ((Connection)this, value, cal);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMPTZ = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(DATE value) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPTZ __result__ = new TIMESTAMPTZ((Connection)this, value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMPTZ = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(Date value, Calendar cal) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPLTZ __result__ = new TIMESTAMPLTZ((Connection)this, cal, value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMPLTZ = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMPLTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(Time value, Calendar cal) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPLTZ __result__ = new TIMESTAMPLTZ((Connection)this, cal, value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMPLTZ = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMPLTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(Timestamp value, Calendar cal) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPLTZ __result__ = new TIMESTAMPLTZ((Connection)this, cal, value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMPLTZ = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMPLTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(String value, Calendar cal) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPLTZ __result__ = new TIMESTAMPLTZ((Connection)this, cal, value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMPLTZ = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMPLTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(DATE value, Calendar cal) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPLTZ __result__ = new TIMESTAMPLTZ((Connection)this, cal, value);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMPLTZ = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMPLTZ;
    }

    public abstract BLOB createTemporaryBlob(Connection var1, boolean var2, int var3) throws SQLException;

    public abstract CLOB createTemporaryClob(Connection var1, boolean var2, int var3, short var4) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDescriptorSharable(oracle.jdbc.internal.OracleConnection conn) throws SQLException {
        try {
            PhysicalConnection c2;
            PhysicalConnection c1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = (c1 = this) == (c2 = (PhysicalConnection)conn.getPhysicalConnection()) || c1.url.equals(c2.url) || c2.protocol != null && c2.protocol.equals("kprb");
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean useLittleEndianSetCHARBinder() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPlsqlWarnings(String setting) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(setting));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (setting == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (setting != null && (setting = setting.trim()).length() > 0 && !OracleSql.isValidPlsqlWarning(setting)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String alterSession = "ALTER SESSION SET PLSQL_WARNINGS=" + setting;
            String alterSessionEvent = "ALTER SESSION SET EVENTS='10933 TRACE NAME CONTEXT LEVEL 32768'";
            Statement stmt = null;
            try {
                stmt = this.createStatement(-1, -1);
                stmt.execute(alterSession);
                if (setting.equals("'DISABLE:ALL'")) {
                    this.plsqlCompilerWarnings = false;
                } else {
                    stmt.execute(alterSessionEvent);
                    this.plsqlCompilerWarnings = true;
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalClose() throws SQLException {
        try {
            OracleStatement n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.lifecycle = 4;
            OracleStatement s2 = this.statements;
            while (s2 != null) {
                n2 = s2.nextChild;
                if (s2.serverCursor) {
                    s2.internalClose();
                    this.removeStatement(s2);
                }
                s2 = n2;
            }
            s2 = this.statements;
            while (s2 != null) {
                n2 = s2.next;
                s2.internalClose();
                s2 = n2;
            }
            this.statements = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XAResource getXAResource() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 164);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 164);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDescribeTable(AutoKeyInfo info) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(info));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setApplicationContext(String nameSpace, String attribute, String value) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(nameSpace) + ", " + OracleLog.argument(attribute) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (nameSpace == null || attribute == null || value == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing NullPointerException: " + uninitializedMarker);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new NullPointerException();
            }
            if (nameSpace.equals(uninitializedMarker)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 170);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 170);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (nameSpace.compareToIgnoreCase("CLIENTCONTEXT") != 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 174);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 174);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (attribute.length() > 30) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 171);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 171);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (value.length() > 4000) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 172);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 172);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.doSetApplicationContext(nameSpace, attribute, value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSetApplicationContext(String nameSpace, String attribute, String value) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(nameSpace) + ", " + OracleLog.argument(attribute) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllApplicationContext(String nameSpace) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(nameSpace));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (nameSpace == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing NullPointerException: " + uninitializedMarker);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new NullPointerException();
            }
            if (nameSpace.equals(uninitializedMarker)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 170);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 170);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.doClearAllApplicationContext(nameSpace);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doClearAllApplicationContext(String nameSpace) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(nameSpace));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] createLightweightSession(String userName, KeywordValueLong[] inKeyVal, int inFlags, KeywordValueLong[][] outKeyVal, int[] outFlags) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(userName) + ", " + OracleLog.argument(inKeyVal) + ", " + OracleLog.argument(inFlags) + ", " + OracleLog.argument(outKeyVal) + ", " + OracleLog.argument(outFlags));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeLightweightSessionRoundtrip(int functionId, byte[] sessionId, KeywordValueLong[] inKeyVal, int inFlags, KeywordValueLong[][] outKeyVal, int[] outFlags) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(functionId) + ", " + OracleLog.argument(sessionId) + ", " + OracleLog.argument(inKeyVal) + ", " + OracleLog.argument(inFlags) + ", " + OracleLog.argument(outKeyVal) + ", " + OracleLog.argument(outFlags));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeLightweightSessionPiggyback(int functionId, byte[] sessionId, KeywordValueLong[] inKeyVal, int inFlags) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(functionId) + ", " + OracleLog.argument(sessionId) + ", " + OracleLog.argument(inKeyVal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doXSNamespaceOp(OracleConnection.XSOperationCode operationCode, byte[] sessionId, XSNamespace[] namespaces, XSNamespace[][] returnedNamespaces) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument((Object)operationCode) + ", " + OracleLog.argument(sessionId) + ", " + OracleLog.argument(namespaces) + ", " + OracleLog.argument(returnedNamespaces));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doXSNamespaceOp(OracleConnection.XSOperationCode operationCode, byte[] sessionId, XSNamespace[] namespaces) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument((Object)operationCode) + ", " + OracleLog.argument(sessionId) + ", " + OracleLog.argument(namespaces));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(String queueName, AQEnqueueOptions opt, AQMessage mesg) throws SQLException {
        block15: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(opt) + ", " + OracleLog.argument(mesg));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                AQMessageI imesg = (AQMessageI)mesg;
                byte[][] msgId = new byte[1][];
                this.doEnqueue(queueName, opt, imesg.getMessagePropertiesI(), imesg.getPayloadTOID(), imesg.getPayload(), msgId, imesg.isRAWPayload());
                if (msgId[0] == null) break block15;
                imesg.setMessageId(msgId[0]);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AQMessage dequeue(String queueName, AQDequeueOptions opt, byte[] toid) throws SQLException {
        AQMessageI aQMessageI;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(queueName) + ", " + OracleLog.argument(opt) + ", " + OracleLog.argument(toid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[][] msgId = new byte[1][];
            AQMessagePropertiesI prop = new AQMessagePropertiesI();
            byte[][] payload = new byte[1][];
            boolean hasAMessageBeenDequeued = false;
            hasAMessageBeenDequeued = this.doDequeue(queueName, opt, prop, toid, payload, msgId, AQMessageI.compareToid(toid, TypeDescriptor.RAWTOID));
            AQMessageI msg = null;
            if (hasAMessageBeenDequeued) {
                msg = new AQMessageI(prop, this);
                msg.setPayload(payload[0], toid);
                msg.setMessageId(msgId[0]);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + msg);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            aQMessageI = msg;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return aQMessageI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AQMessage dequeue(String queueName, AQDequeueOptions opt, String typeName) throws SQLException {
        AQMessageI aQMessageI;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(queueName) + ", " + OracleLog.argument(opt) + ", " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] toid = null;
            TypeDescriptor sd = null;
            if (RAW_STR.equals(typeName) || SYS_RAW_STR.equals(typeName)) {
                toid = TypeDescriptor.RAWTOID;
            } else if (SYS_ANYDATA_STR.equals(typeName)) {
                toid = TypeDescriptor.ANYDATATOID;
            } else if (SYS_XMLTYPE_STR.equals(typeName)) {
                toid = TypeDescriptor.XMLTYPETOID;
            } else {
                sd = TypeDescriptor.getTypeDescriptor(typeName, this);
                toid = ((OracleTypeADT)sd.getPickler()).getTOID();
            }
            AQMessageI msg = (AQMessageI)this.dequeue(queueName, opt, toid);
            if (msg != null) {
                msg.setTypeName(typeName);
                msg.setTypeDescriptor(sd);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + msg);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            aQMessageI = msg;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return aQMessageI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doEnqueue(String queueName, AQEnqueueOptions enqueueOptions, AQMessagePropertiesI prop, byte[] payloadTDO, byte[] payload, byte[][] msgId, boolean isRawPayload) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(queueName) + ", " + OracleLog.argument(enqueueOptions) + ", " + OracleLog.argument(prop) + ", " + OracleLog.argument(payloadTDO) + ", " + OracleLog.argument(payload) + ", " + OracleLog.argument(msgId) + ", " + OracleLog.argument(isRawPayload));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean doDequeue(String queueName, AQDequeueOptions dequeueOptions, AQMessagePropertiesI msgProp, byte[] payloadTDO, byte[][] payload, byte[][] msgid, boolean isRawQueue) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(queueName) + ", " + OracleLog.argument(dequeueOptions) + ", " + OracleLog.argument(msgProp) + ", " + OracleLog.argument(payloadTDO) + ", " + OracleLog.argument(payload) + ", " + OracleLog.argument(msgid) + ", " + OracleLog.argument(isRawQueue));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isV8Compatible() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.mapDateToTimestamp);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.mapDateToTimestamp;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMapDateToTimestamp() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.mapDateToTimestamp);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.mapDateToTimestamp;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getInstanceProperty(OracleConnection.InstanceProperty whatProperty) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument((Object)whatProperty));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AQNotificationRegistration[] registerAQNotification(String[] name, Properties[] options, Properties globalOptions) throws SQLException {
        AQNotificationRegistration[] aQNotificationRegistrationArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(options) + ", " + OracleLog.argument(globalOptions));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String dcnhost = this.readNTFlocalhost(globalOptions);
            int tcpport = this.readNTFtcpport(globalOptions);
            NTFAQRegistration[] registrations = this.doRegisterAQNotification(name, dcnhost, tcpport, options);
            AQNotificationRegistration[] __result__ = registrations;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            aQNotificationRegistrationArray = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return aQNotificationRegistrationArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFAQRegistration[] doRegisterAQNotification(String[] name, String dcnhost, int tcpport, Properties[] options) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(dcnhost) + ", " + OracleLog.argument(tcpport) + ", " + OracleLog.argument(options));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAQNotification(AQNotificationRegistration registration) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(registration));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NTFAQRegistration aqregistration = (NTFAQRegistration)registration;
            this.doUnregisterAQNotification(aqregistration);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUnregisterAQNotification(NTFAQRegistration registration) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(registration));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readNTFlocalhost(Properties options) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(options));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String dcnhost = null;
            try {
                dcnhost = options.getProperty("NTF_LOCAL_HOST", InetAddress.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException optionsExcep1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 240);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 240);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (SecurityException optionsExcep2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 241);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 241);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + dcnhost);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = dcnhost;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readNTFtcpport(Properties options) throws SQLException {
        try {
            int tcpport;
            block28: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(options));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                tcpport = 0;
                try {
                    tcpport = Integer.parseInt(options.getProperty("NTF_LOCAL_TCP_PORT", "0"));
                    if (tcpport >= 0) break block28;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 242);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 242);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                catch (NumberFormatException optionsExcep3) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 242);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 242);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + tcpport);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = tcpport;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readNTFtimeout(Properties options) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(options));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int timeout = 0;
            try {
                timeout = Integer.parseInt(options.getProperty("NTF_TIMEOUT", "0"));
            }
            catch (NumberFormatException optionsExcep4) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 243);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 243);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timeout);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = timeout;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseChangeRegistration registerDatabaseChangeNotification(Properties options) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(options));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String dcnhost = this.readNTFlocalhost(options);
            int tcpport = this.readNTFtcpport(options);
            int timeout = this.readNTFtimeout(options);
            int txnlag = 0;
            try {
                txnlag = Integer.parseInt(options.getProperty("DCN_NOTIFY_CHANGELAG", "0"));
            }
            catch (NumberFormatException optionsExcep5) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 244);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 244);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            NTFDCNRegistration registration = this.doRegisterDatabaseChangeNotification(dcnhost, tcpport, options, timeout, txnlag);
            ntfManager.addRegistration(registration);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + registration);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NTFDCNRegistration nTFDCNRegistration = registration;
            return nTFDCNRegistration;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFDCNRegistration doRegisterDatabaseChangeNotification(String dcnhost, int tcpport, Properties options, int timeout, int txnlag) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(dcnhost) + ", " + OracleLog.argument(tcpport) + ", " + OracleLog.argument(options) + ", " + OracleLog.argument(timeout) + ", " + OracleLog.argument(txnlag));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseChangeRegistration getDatabaseChangeRegistration(int regid) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(regid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NTFDCNRegistration registration = new NTFDCNRegistration(this.instanceName, regid, this.userName, this.versionNumber);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + registration);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NTFDCNRegistration nTFDCNRegistration = registration;
            return nTFDCNRegistration;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterDatabaseChangeNotification(DatabaseChangeRegistration registration) throws SQLException {
        try {
            NTFDCNRegistration dcnregistration;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(registration));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((dcnregistration = (NTFDCNRegistration)registration).getDatabaseName().compareToIgnoreCase(this.instanceName) != 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 245);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 245);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.doUnregisterDatabaseChangeNotification(dcnregistration);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUnregisterDatabaseChangeNotification(NTFDCNRegistration registration) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(registration));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterDatabaseChangeNotification(int registrationId) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(registrationId));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String dcnhost = null;
            try {
                dcnhost = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.unregisterDatabaseChangeNotification(registrationId, dcnhost, 47632);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterDatabaseChangeNotification(int registrationId, String host, int tcpport) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(registrationId) + ", " + OracleLog.argument(host) + ", " + OracleLog.argument(tcpport));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String location = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + host + ")(PORT=" + tcpport + "))?PR=0";
            this.unregisterDatabaseChangeNotification(registrationId, location);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterDatabaseChangeNotification(long registrationId, String callback) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(registrationId) + ", " + OracleLog.argument(callback));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.doUnregisterDatabaseChangeNotification(registrationId, callback);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUnregisterDatabaseChangeNotification(long registrationId, String callback) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(registrationId) + ", " + OracleLog.argument(callback));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addXSEventListener(XSEventListener listener) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(listener));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addXSEventListener(XSEventListener listener, Executor executor) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(listener) + ", " + OracleLog.argument(executor));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeXSEventListener(XSEventListener listener) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(listener));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeDescriptor[] getAllTypeDescriptorsInCurrentSchema() throws SQLException {
        TypeDescriptor[] typeDescriptorArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TypeDescriptor[] result = null;
            Statement stmt = null;
            try {
                stmt = this.createStatement();
                ResultSet rst = stmt.executeQuery("SELECT schema_name, typename, typoid, typecode, version, tds  FROM TABLE(private_jdbc.Get_Type_Shape_Info())");
                result = this.getTypeDescriptorsFromResultSet(rst);
                rst.close();
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 904) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 165);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 165);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                throw ex;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            typeDescriptorArray = result;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return typeDescriptorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeDescriptor[] getTypeDescriptorsFromListInCurrentSchema(String[] typeNames) throws SQLException {
        TypeDescriptor[] typeDescriptorArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(typeNames));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String sql = "SELECT schema_name, typename, typoid, typecode, version, tds  FROM TABLE(private_jdbc.Get_Type_Shape_Info(?))";
            TypeDescriptor[] result = null;
            PreparedStatement stmt = null;
            try {
                stmt = this.prepareStatement(sql);
                int typeNamesLength = typeNames.length;
                StringBuffer sb = new StringBuffer(typeNamesLength * 8);
                for (int i2 = 0; i2 < typeNamesLength; ++i2) {
                    sb.append(typeNames[i2]);
                    if (i2 >= typeNamesLength - 1) continue;
                    sb.append(',');
                }
                stmt.setString(1, sb.toString());
                ResultSet rst = stmt.executeQuery();
                result = this.getTypeDescriptorsFromResultSet(rst);
                rst.close();
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 904) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 165);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 165);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                throw ex;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            typeDescriptorArray = result;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return typeDescriptorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeDescriptor[] getTypeDescriptorsFromList(String[][] schemaAndTypeNamePairs) throws SQLException {
        TypeDescriptor[] typeDescriptorArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(schemaAndTypeNamePairs));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TypeDescriptor[] result = null;
            PreparedStatement stmt = null;
            int length = schemaAndTypeNamePairs.length;
            StringBuffer schemaNames = new StringBuffer(length * 8);
            StringBuffer typeNames = new StringBuffer(length * 8);
            for (int i2 = 0; i2 < length; ++i2) {
                schemaNames.append(schemaAndTypeNamePairs[i2][0]);
                typeNames.append(schemaAndTypeNamePairs[i2][1]);
                if (i2 >= length - 1) continue;
                schemaNames.append(',');
                typeNames.append(',');
            }
            try {
                String sql = "SELECT schema_name, typename, typoid, typecode, version, tds FROM TABLE(private_jdbc.Get_All_Type_Shape_Info(?,?))";
                stmt = this.prepareStatement(sql);
                stmt.setString(1, schemaNames.toString());
                stmt.setString(2, typeNames.toString());
                ResultSet rst = stmt.executeQuery();
                result = this.getTypeDescriptorsFromResultSet(rst);
                rst.close();
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 904) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 165);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 165);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                throw ex;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            typeDescriptorArray = result;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return typeDescriptorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TypeDescriptor[] getTypeDescriptorsFromResultSet(ResultSet rst) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rst));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayList<TypeDescriptor> list = new ArrayList<TypeDescriptor>();
            while (rst.next()) {
                TypeDescriptor desc;
                String schema = rst.getString(1);
                String typename = rst.getString(2);
                byte[] typoid = rst.getBytes(3);
                String typecode = rst.getString(4);
                int version = rst.getInt(5);
                byte[] tds = rst.getBytes(6);
                SQLName sqlName = new SQLName(schema, typename, this);
                if (typecode.equals("OBJECT")) {
                    desc = StructDescriptor.createDescriptor(sqlName, typoid, version, tds, this);
                    this.putDescriptor(typoid, (Object)desc);
                    this.putDescriptor(desc.getName(), (Object)desc);
                    list.add(desc);
                    continue;
                }
                if (!typecode.equals("COLLECTION")) continue;
                desc = ArrayDescriptor.createDescriptor(sqlName, typoid, version, tds, this);
                this.putDescriptor(typoid, (Object)desc);
                this.putDescriptor(desc.getName(), (Object)desc);
                list.add(desc);
            }
            TypeDescriptor[] result = new TypeDescriptor[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                TypeDescriptor desc;
                result[i2] = desc = (TypeDescriptor)list.get(i2);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TypeDescriptor[] typeDescriptorArray = result;
            return typeDescriptorArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isUsable() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.isUsable);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.isUsable;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUsable(boolean isUsable) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(isUsable));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.isUsable = isUsable;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queryFCFProperties(Properties prop) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(prop));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Statement stmt = null;
            ResultSet rs = null;
            String query = "select sys_context('userenv', 'instance_name'),sys_context('userenv', 'server_host'),sys_context('userenv', 'service_name'),sys_context('userenv', 'db_unique_name') from dual";
            try {
                stmt = this.createStatement();
                stmt.setFetchSize(1);
                rs = stmt.executeQuery(query);
                while (rs.next()) {
                    String val = null;
                    val = rs.getString(1);
                    if (val != null) {
                        prop.put(INSTANCE_NAME, val.trim());
                    }
                    if ((val = rs.getString(2)) != null) {
                        prop.put(SERVER_HOST, val.trim());
                    }
                    if ((val = rs.getString(3)) != null) {
                        prop.put(SERVICE_NAME, val.trim());
                    }
                    if ((val = rs.getString(4)) == null) continue;
                    prop.put(DATABASE_NAME, val.trim());
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultTimeZone(TimeZone tz) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(tz));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.defaultTimeZone = tz;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeZone getDefaultTimeZone() throws SQLException {
        TimeZone timeZone;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            timeZone = this.defaultTimeZone;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return timeZone;
    }

    @Override
    public int getTimezoneVersionNumber() throws SQLException {
        return this.timeZoneVersionNumber;
    }

    @Override
    public TIMEZONETAB getTIMEZONETAB() throws SQLException {
        if (this.timeZoneTab == null) {
            this.timeZoneTab = TIMEZONETAB.getInstance(this.getTimezoneVersionNumber());
        }
        return this.timeZoneTab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDataInLocatorEnabled() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean __result__ = this.getVersionNumber() >= 10200 & this.getVersionNumber() < 11000 & this.enableReadDataInLocator | this.overrideEnableReadDataInLocator;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLobStreamPosStandardCompliant() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean __result__ = this.lobStreamPosStandardCompliant;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCurrentSCN() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.doGetCurrentSCN());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = this.doGetCurrentSCN();
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long doGetCurrentSCN() throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSetSnapshotSCN(long scn) throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumSet<OracleConnection.TransactionState> getTransactionState() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.doGetTransactionState());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            EnumSet<OracleConnection.TransactionState> enumSet = this.doGetTransactionState();
            return enumSet;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PhysicalConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EnumSet<OracleConnection.TransactionState> doGetTransactionState() throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException, SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PhysicalConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + uninitializedMarker);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.PhysicalConnection"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class BufferCacheStore {
        static int MAX_CACHED_BUFFER_SIZE = Integer.MAX_VALUE;
        final BufferCache<byte[]> byteBufferCache;
        final BufferCache<char[]> charBufferCache;

        BufferCacheStore() {
            this(MAX_CACHED_BUFFER_SIZE);
        }

        BufferCacheStore(int maxCachedBufferSize) {
            this.byteBufferCache = new BufferCache(maxCachedBufferSize);
            this.charBufferCache = new BufferCache(maxCachedBufferSize);
        }
    }
}

