/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;

abstract class OracleInputStream
extends OracleBufferedStream {
    int columnIndex;
    Accessor accessor;
    OracleInputStream nextStream;
    boolean hasBeenOpen = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleInputStream(OracleStatement stmt, int index, Accessor a2) {
        super(stmt, stmt.connection.getDefaultStreamChunkSize());
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(a2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.closed = true;
            this.statement = stmt;
            this.columnIndex = index;
            this.accessor = a2;
            this.nextStream = null;
            OracleInputStream s2 = this.statement.streamList;
            if (s2 == null || this.columnIndex < s2.columnIndex) {
                this.nextStream = this.statement.streamList;
                this.statement.streamList = this;
            } else if (this.columnIndex == s2.columnIndex) {
                this.nextStream = s2.nextStream;
                s2.nextStream = null;
                this.statement.streamList = this;
            } else {
                while (s2.nextStream != null && this.columnIndex > s2.nextStream.columnIndex) {
                    s2 = s2.nextStream;
                }
                if (s2.nextStream != null && this.columnIndex == s2.nextStream.columnIndex) {
                    this.nextStream = s2.nextStream.nextStream;
                    s2.nextStream.nextStream = null;
                    s2.nextStream = this;
                } else {
                    this.nextStream = s2.nextStream;
                    s2.nextStream = this;
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleInputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String __result__ = "OIS@" + Integer.toHexString(this.hashCode()) + "{" + "statement = " + this.statement + ", accessor = " + this.accessor + ", nextStream = " + this.nextStream + ", columnIndex = " + this.columnIndex + ", hasBeenOpen = " + this.hasBeenOpen + "}";
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleInputStream.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean needBytes(int howMany) throws IOException {
        block60: {
            block52: {
                block49: {
                    try {
                        if (OracleInputStream.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleInputStream.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if (!this.closed) break block49;
                        if (OracleInputStream.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleInputStream.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        var2_3 = false;
                    }
                    catch (Throwable var11_17) {
                        if (OracleInputStream.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleInputStream.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw var11_17;
                    }
                    if (OracleInputStream.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleInputStream.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    return var2_3;
                }
                if (this.pos < this.count) ** GOTO lbl98
                if (howMany > this.currentBufferSize) {
                    this.currentBufferSize = Math.max(howMany, this.initialBufferSize);
                    this.resizableBuffer = new byte[this.currentBufferSize];
                }
                readLength = this.getBytes(this.currentBufferSize);
                this.pos = 0;
                this.count = readLength;
                if (this.count != -1) break block52;
                if (this.nextStream == null) {
                    this.statement.connection.releaseLine();
                }
                this.closed = true;
                this.accessor.fetchNextColumns();
                if (OracleInputStream.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleInputStream.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var3_7 = false;
                if (OracleInputStream.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleInputStream.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var3_7;
            }
            break block60;
            {
                catch (SQLException e) {
                    if (OracleInputStream.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            sw = new StringWriter();
                            pw = new PrintWriter(sw);
                            e.printStackTrace(pw);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (OracleInputStream.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createIOException(e);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
        }
        if (OracleInputStream.TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleInputStream.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        var2_4 = true;
        if (OracleInputStream.TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleInputStream.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return var2_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNull() throws IOException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleInputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean result = false;
            try {
                result = this.accessor.isNull(0);
            }
            catch (SQLException exc) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + exc);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                IOException __ex__ = DatabaseError.createIOException(exc);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleInputStream.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = result;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleInputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleInputStream.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.closed);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.closed;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            block21: {
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleInputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (this.closed || !this.hasBeenOpen) break block21;
                    while (this.statement.nextStream != this) {
                        this.statement.nextStream.close();
                        this.statement.nextStream = this.statement.nextStream.nextStream;
                    }
                    if (!this.isNull()) {
                        while (this.needBytes(Math.max(this.initialBufferSize, this.currentBufferSize))) {
                            this.pos = this.count;
                        }
                    }
                    this.closed = true;
                    this.resizableBuffer = null;
                    this.currentBufferSize = 0;
                }
                catch (Throwable throwable) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public abstract int getBytes(int var1) throws IOException;

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleInputStream"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

