/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.sql.ANYDATA;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

abstract class OracleCallableStatement
extends OraclePreparedStatement
implements oracle.jdbc.internal.OracleCallableStatement {
    boolean atLeastOneOrdinalParameter;
    boolean atLeastOneNamedParameter;
    String[] namedParameters;
    int parameterCount;
    final String errMsgMixedBind = "Ordinal binding and Named binding cannot be combined!";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleCallableStatement(PhysicalConnection conn, String sql, int batchValue, int rowPrefetchValue) throws SQLException {
        block12: {
            this(conn, sql, batchValue, rowPrefetchValue, 1003, 1007);
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(sql) + ", " + OracleLog.argument(batchValue) + ", " + OracleLog.argument(rowPrefetchValue));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleCallableStatement(PhysicalConnection conn, String sql, int batch_value, int row_prefetch_value, int UserResultSetType, int UserResultSetConcur) throws SQLException {
        super(conn, sql, 1, row_prefetch_value, UserResultSetType, UserResultSetConcur);
        this.atLeastOneOrdinalParameter = false;
        this.atLeastOneNamedParameter = false;
        this.namedParameters = new String[8];
        this.parameterCount = 0;
        this.errMsgMixedBind = "Ordinal binding and Named binding cannot be combined!";
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(sql) + ", " + OracleLog.argument(batch_value) + ", " + OracleLog.argument(row_prefetch_value) + ", " + OracleLog.argument(UserResultSetType) + ", " + OracleLog.argument(UserResultSetConcur));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.statementType = 2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerOutParameterInternal(int paramIndex, int external_type, int scale, int maxLength, String sqlName) throws SQLException {
        try {
            int index;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(maxLength) + ", " + OracleLog.argument(sqlName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (external_type == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int internal_type = this.getInternalType(external_type);
            this.resetBatch();
            this.currentRowNeedToPrepareBinds = true;
            if (this.currentRowBindAccessors == null) {
                this.currentRowBindAccessors = new Accessor[this.numberOfBindPositions];
            }
            switch (external_type) {
                case -4: 
                case -3: 
                case -1: 
                case 1: 
                case 12: 
                case 70: {
                    break;
                }
                default: {
                    maxLength = 0;
                }
            }
            this.currentRowBindAccessors[index] = this.allocateAccessor(internal_type, external_type, index + 1, maxLength, this.currentRowFormOfUse[index], sqlName, true);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int paramIndex, int sqlType, String sqlName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(sqlType) + ", " + OracleLog.argument(sqlName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (sqlName == null || sqlName.length() == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 60 + "empty Object name");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "empty Object name");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.registerOutParameterInternal(paramIndex, sqlType, 0, 0, sqlName);
            }
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameterBytes(int paramIndex, int sqlType, int scale, int maxLength) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(sqlType) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(maxLength));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.registerOutParameterInternal(paramIndex, sqlType, scale, maxLength, null);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameterChars(int paramIndex, int sqlType, int scale, int maxLength) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(sqlType) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(maxLength));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.registerOutParameterInternal(paramIndex, sqlType, scale, maxLength, null);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int paramIndex, int sqlType, int scale, int maxLength) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(sqlType) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(maxLength));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.registerOutParameterInternal(paramIndex, sqlType, scale, maxLength, null);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(String parameterName, int sqlType, int scale, int maxLength) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(sqlType) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(maxLength));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.registerOutParameterInternal(parameterName, sqlType, scale, maxLength, null);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOracleBatchStyle() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetBatch() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.batch = 1;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExecuteBatch(int nrows) throws SQLException {
        block18: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(nrows));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block18;
                try {
                    OracleCallableStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "do nothing");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "do nothing");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.validRows);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = this.validRows;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int paramIndex, int sqlType) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(sqlType));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.registerOutParameter(paramIndex, sqlType, 0, -1);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int paramIndex, int sqlType, int scale) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(sqlType) + ", " + OracleLog.argument(scale));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.registerOutParameter(paramIndex, sqlType, scale, -1);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean __result__ = this.wasNullValue();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int parameterIndex) throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            String __result__ = accessor.getString(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum getOracleObject(int parameterIndex) throws SQLException {
        Datum datum;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Datum __result__ = accessor.getOracleObject(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            datum = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROWID getROWID(int parameterIndex) throws SQLException {
        ROWID rOWID;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            ROWID __result__ = accessor.getROWID(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            rOWID = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return rOWID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NUMBER getNUMBER(int parameterIndex) throws SQLException {
        NUMBER nUMBER;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            NUMBER __result__ = accessor.getNUMBER(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            nUMBER = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DATE getDATE(int parameterIndex) throws SQLException {
        DATE dATE;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            DATE __result__ = accessor.getDATE(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            dATE = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return dATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INTERVALYM getINTERVALYM(int parameterIndex) throws SQLException {
        INTERVALYM iNTERVALYM;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            INTERVALYM __result__ = accessor.getINTERVALYM(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            iNTERVALYM = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return iNTERVALYM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INTERVALDS getINTERVALDS(int parameterIndex) throws SQLException {
        INTERVALDS iNTERVALDS;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            INTERVALDS __result__ = accessor.getINTERVALDS(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            iNTERVALDS = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return iNTERVALDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMP getTIMESTAMP(int parameterIndex) throws SQLException {
        TIMESTAMP tIMESTAMP;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            TIMESTAMP __result__ = accessor.getTIMESTAMP(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMP = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMPTZ getTIMESTAMPTZ(int parameterIndex) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            TIMESTAMPTZ __result__ = accessor.getTIMESTAMPTZ(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMPTZ = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int parameterIndex) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            TIMESTAMPLTZ __result__ = accessor.getTIMESTAMPLTZ(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMPLTZ = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMPLTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REF getREF(int parameterIndex) throws SQLException {
        REF rEF;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            REF __result__ = accessor.getREF(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            rEF = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return rEF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ARRAY getARRAY(int parameterIndex) throws SQLException {
        ARRAY aRRAY;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            ARRAY __result__ = accessor.getARRAY(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            aRRAY = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return aRRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT getSTRUCT(int parameterIndex) throws SQLException {
        STRUCT sTRUCT;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            STRUCT __result__ = accessor.getSTRUCT(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            sTRUCT = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return sTRUCT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPAQUE getOPAQUE(int parameterIndex) throws SQLException {
        OPAQUE oPAQUE;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            OPAQUE __result__ = accessor.getOPAQUE(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oPAQUE = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oPAQUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CHAR getCHAR(int parameterIndex) throws SQLException {
        CHAR cHAR;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            CHAR __result__ = accessor.getCHAR(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            cHAR = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return cHAR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        Reader reader;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Reader __result__ = accessor.getCharacterStream(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            reader = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAW getRAW(int parameterIndex) throws SQLException {
        RAW rAW;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            RAW __result__ = accessor.getRAW(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            rAW = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return rAW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLOB getBLOB(int parameterIndex) throws SQLException {
        BLOB bLOB;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            BLOB __result__ = accessor.getBLOB(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bLOB = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLOB getCLOB(int parameterIndex) throws SQLException {
        CLOB cLOB;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            CLOB __result__ = accessor.getCLOB(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            cLOB = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return cLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE getBFILE(int parameterIndex) throws SQLException {
        BFILE bFILE;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            BFILE __result__ = accessor.getBFILE(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bFILE = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bFILE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE getBfile(int parameterIndex) throws SQLException {
        BFILE bFILE;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            BFILE __result__ = accessor.getBFILE(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bFILE = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bFILE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int parameterIndex) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            boolean __result__ = accessor.getBoolean(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int parameterIndex) throws SQLException {
        byte by;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            byte __result__ = accessor.getByte(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            by = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int parameterIndex) throws SQLException {
        short s2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            short __result__ = accessor.getShort(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            s2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int parameterIndex) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            int __result__ = accessor.getInt(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int parameterIndex) throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            long __result__ = accessor.getLong(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            l2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int parameterIndex) throws SQLException {
        float f2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            float __result__ = accessor.getFloat(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            f2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return f2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int parameterIndex) throws SQLException {
        double d2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            double __result__ = accessor.getDouble(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            d2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        BigDecimal bigDecimal;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(scale));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            BigDecimal __result__ = accessor.getBigDecimal(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bigDecimal = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int parameterIndex) throws SQLException {
        byte[] byArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            byte[] __result__ = accessor.getBytes(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byArray = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] privateGetBytes(int parameterIndex) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            byte[] __result__ = accessor.privateGetBytes(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int parameterIndex) throws SQLException {
        Date date;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Date __result__ = accessor.getDate(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            date = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int parameterIndex) throws SQLException {
        Time time;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Time __result__ = accessor.getTime(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            time = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        Timestamp timestamp;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Timestamp __result__ = accessor.getTimestamp(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            timestamp = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(int parameterIndex) throws SQLException {
        InputStream inputStream;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            InputStream __result__ = accessor.getAsciiStream(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            inputStream = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getUnicodeStream(int parameterIndex) throws SQLException {
        InputStream inputStream;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            InputStream __result__ = accessor.getUnicodeStream(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            inputStream = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(int parameterIndex) throws SQLException {
        InputStream inputStream;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            InputStream __result__ = accessor.getBinaryStream(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            inputStream = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int parameterIndex) throws SQLException {
        Object object;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Object __result__ = accessor.getObject(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            object = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAnyDataEmbeddedObject(int parameterIndex) throws SQLException {
        Object object;
        try {
            Datum d2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object result = null;
            Object o2 = this.getObject(parameterIndex);
            if (o2 instanceof ANYDATA && (d2 = ((ANYDATA)o2).accessDatum()) != null) {
                result = d2.toJdbc();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            object = result;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCustomDatum(int parameterIndex, CustomDatumFactory factory) throws SQLException {
        CustomDatum customDatum;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(factory));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            CustomDatum __result__ = accessor.getCustomDatum(this.currentRank, factory);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            customDatum = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return customDatum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int parameterIndex, OracleDataFactory factory) throws SQLException {
        Object object;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(factory));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Object __result__ = accessor.getObject(this.currentRank, factory);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            object = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getORAData(int parameterIndex, ORADataFactory factory) throws SQLException {
        ORAData oRAData;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(factory));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            ORAData __result__ = accessor.getORAData(this.currentRank, factory);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oRAData = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oRAData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCursor(int parameterIndex) throws SQLException {
        ResultSet resultSet;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            ResultSet __result__ = accessor.getCursor(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            resultSet = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearParameters() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                super.clearParameters();
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int parameterIndex, Map map) throws SQLException {
        Object object;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Object __result__ = accessor.getObject(this.currentRank, map);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            object = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ref getRef(int parameterIndex) throws SQLException {
        REF rEF;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            REF __result__ = accessor.getREF(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            rEF = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return rEF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int parameterIndex) throws SQLException {
        BLOB bLOB;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            BLOB __result__ = accessor.getBLOB(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bLOB = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int parameterIndex) throws SQLException {
        CLOB cLOB;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            CLOB __result__ = accessor.getCLOB(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            cLOB = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return cLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getArray(int parameterIndex) throws SQLException {
        ARRAY aRRAY;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            ARRAY __result__ = accessor.getARRAY(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            aRRAY = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return aRRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        BigDecimal bigDecimal;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            BigDecimal __result__ = accessor.getBigDecimal(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bigDecimal = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        Date date;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Date __result__ = accessor.getDate(this.currentRank, cal);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            date = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        Time time;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Time __result__ = accessor.getTime(this.currentRank, cal);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            time = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        Timestamp timestamp;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Timestamp __result__ = accessor.getTimestamp(this.currentRank, cal);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            timestamp = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.currentRowBindAccessors != null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Stored procedure with out or inout parameters cannot be batched");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Stored procedure with out or inout parameters cannot be batched");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            super.addBatch();
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void alwaysOnClose() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.sqlObject.resetNamedParameters();
            this.namedParameters = new String[8];
            this.parameterCount = 0;
            this.atLeastOneOrdinalParameter = false;
            this.atLeastOneNamedParameter = false;
            super.alwaysOnClose();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(sqlType));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.registerOutParameterInternal(parameterName, sqlType, 0, -1, null);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(sqlType) + ", " + OracleLog.argument(scale));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.registerOutParameterInternal(parameterName, sqlType, scale, -1, null);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(sqlType) + ", " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.registerOutParameterInternal(parameterName, sqlType, 0, -1, typeName);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    void registerOutParameterInternal(String parameterName, int sqlType, int scale, int maxLength, String typeName) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.registerOutParameterInternal(index, sqlType, scale, maxLength, typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL(int parameterIndex) throws SQLException {
        URL uRL;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            URL __result__ = accessor.getURL(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            uRL = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStringForClob(String parameterName, String x) throws SQLException {
        int index;
        block23: {
            block24: {
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    index = this.addNamedPara(parameterName);
                    if (x != null && x.length() != 0) break block23;
                    this.setNull(index, 2005);
                    if (!TRACE || !OracleLog.recursiveEnter()) break block24;
                    try {
                        OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                catch (Throwable throwable) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        this.setStringForClob(index, x);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStringForClob(int paramIndex, String x) throws SQLException {
        block26: {
            block27: {
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (x != null && x.length() != 0) break block26;
                    this.setNull(paramIndex, 2005);
                    if (!TRACE || !OracleLog.recursiveEnter()) break block27;
                    try {
                        OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                catch (Throwable throwable) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setStringForClobCritical(paramIndex, x);
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytesForBlob(String parameterName, byte[] x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setBytesForBlob(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytesForBlob(int paramIndex, byte[] x) throws SQLException {
        block26: {
            block27: {
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (x != null && x.length != 0) break block26;
                    this.setNull(paramIndex, 2004);
                    if (!TRACE || !OracleLog.recursiveEnter()) break block27;
                    try {
                        OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                catch (Throwable throwable) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setBytesForBlobCritical(paramIndex, x);
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String parameterName) throws SQLException {
        String string;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            String __result__ = accessor.getString(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String parameterName) throws SQLException {
        boolean bl;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            boolean __result__ = accessor.getBoolean(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(String parameterName) throws SQLException {
        byte by;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            byte __result__ = accessor.getByte(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            by = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(String parameterName) throws SQLException {
        short s2;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            short __result__ = accessor.getShort(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            s2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String parameterName) throws SQLException {
        int n2;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            int __result__ = accessor.getInt(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String parameterName) throws SQLException {
        long l2;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            long __result__ = accessor.getLong(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            l2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(String parameterName) throws SQLException {
        float f2;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            float __result__ = accessor.getFloat(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            f2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return f2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(String parameterName) throws SQLException {
        double d2;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            double __result__ = accessor.getDouble(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            d2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(String parameterName) throws SQLException {
        byte[] byArray;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            byte[] __result__ = accessor.getBytes(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byArray = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(String parameterName) throws SQLException {
        Date date;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Date __result__ = accessor.getDate(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            date = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(String parameterName) throws SQLException {
        Time time;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Time __result__ = accessor.getTime(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            time = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        Timestamp timestamp;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Timestamp __result__ = accessor.getTimestamp(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            timestamp = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String parameterName) throws SQLException {
        Object object;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Object __result__ = accessor.getObject(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            object = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        BigDecimal bigDecimal;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            BigDecimal __result__ = accessor.getBigDecimal(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bigDecimal = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(String parameterName, int scale) throws SQLException {
        BigDecimal bigDecimal;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            BigDecimal __result__ = accessor.getBigDecimal(this.currentRank, scale);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bigDecimal = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String parameterName, Map map) throws SQLException {
        Object object;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Object __result__ = accessor.getObject(this.currentRank, map);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            object = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ref getRef(String parameterName) throws SQLException {
        REF rEF;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            REF __result__ = accessor.getREF(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            rEF = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return rEF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(String parameterName) throws SQLException {
        BLOB bLOB;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            BLOB __result__ = accessor.getBLOB(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bLOB = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(String parameterName) throws SQLException {
        CLOB cLOB;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            CLOB __result__ = accessor.getCLOB(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            cLOB = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return cLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getArray(String parameterName) throws SQLException {
        ARRAY aRRAY;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            ARRAY __result__ = accessor.getARRAY(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            aRRAY = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return aRRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        Date date;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Date __result__ = accessor.getDate(this.currentRank, cal);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            date = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        Time time;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Time __result__ = accessor.getTime(this.currentRank, cal);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            time = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        Timestamp timestamp;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Timestamp __result__ = accessor.getTimestamp(this.currentRank, cal);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            timestamp = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL(String parameterName) throws SQLException {
        URL uRL;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            URL __result__ = accessor.getURL(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            uRL = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(String parameterName) throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIndexTableOutParameter(int paramIndex, int maxLen, int elemSqlType, int elemMaxLen) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                int index;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(maxLen) + ", " + OracleLog.argument(elemSqlType) + ", " + OracleLog.argument(elemMaxLen));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int internal_type = this.getInternalType(elemSqlType);
                this.resetBatch();
                this.currentRowNeedToPrepareBinds = true;
                if (this.currentRowBindAccessors == null) {
                    this.currentRowBindAccessors = new Accessor[this.numberOfBindPositions];
                }
                this.currentRowBindAccessors[index] = this.allocateIndexTableAccessor(elemSqlType, internal_type, elemMaxLen, maxLen, this.currentRowFormOfUse[index], true);
                this.hasIbtBind = true;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PlsqlIndexTableAccessor allocateIndexTableAccessor(int elemSqlType, int elemInternalType, int elemMaxLen, int maxNumOfElements, short form, boolean forBind) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(elemSqlType) + ", " + OracleLog.argument(elemInternalType) + ", " + OracleLog.argument(elemMaxLen) + ", " + OracleLog.argument(maxNumOfElements) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(forBind));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PlsqlIndexTableAccessor plsqlIndexTableAccessor = new PlsqlIndexTableAccessor(this, elemSqlType, elemInternalType, elemMaxLen, maxNumOfElements, form, forBind);
            return plsqlIndexTableAccessor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPlsqlIndexTable(int paramIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object[] objectArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Datum[] darray = this.getOraclePlsqlIndexTable(paramIndex);
                PlsqlIndexTableAccessor accessor = (PlsqlIndexTableAccessor)this.outBindAccessors[paramIndex - 1];
                int type = accessor.elementInternalType;
                Object[] jarray = null;
                switch (type) {
                    case 9: {
                        jarray = new String[darray.length];
                        break;
                    }
                    case 6: {
                        jarray = new BigDecimal[darray.length];
                        break;
                    }
                    default: {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Invalid column type");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid column type");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
                for (int i2 = 0; i2 < jarray.length; ++i2) {
                    jarray[i2] = darray[i2] != null && darray[i2].getLength() != 0L ? darray[i2].toJdbc() : null;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + jarray);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                objectArray = jarray;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getPlsqlIndexTable(int paramIndex, Class primitiveType) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block115: {
                boolean[] blArray;
                String type;
                Datum[] darray;
                block112: {
                    block109: {
                        block106: {
                            block103: {
                                block100: {
                                    block97: {
                                        block94: {
                                            if (TRACE && OracleLog.recursiveEnter()) {
                                                try {
                                                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(primitiveType));
                                                }
                                                finally {
                                                    OracleLog.recursiveExit();
                                                }
                                            }
                                            darray = this.getOraclePlsqlIndexTable(paramIndex);
                                            if (primitiveType == null || !primitiveType.isPrimitive()) {
                                                if (TRACE && OracleLog.recursiveEnter()) {
                                                    try {
                                                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                                                    }
                                                    finally {
                                                        OracleLog.recursiveExit();
                                                    }
                                                }
                                                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                                                __ex__.fillInStackTrace();
                                                throw __ex__;
                                            }
                                            type = primitiveType.getName();
                                            if (!type.equals("byte")) break block94;
                                            byte[] jarray = new byte[darray.length];
                                            for (int i2 = 0; i2 < darray.length; ++i2) {
                                                jarray[i2] = darray[i2] != null ? darray[i2].byteValue() : (byte)0;
                                            }
                                            if (TRACE && OracleLog.recursiveEnter()) {
                                                try {
                                                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + jarray);
                                                }
                                                finally {
                                                    OracleLog.recursiveExit();
                                                }
                                            }
                                            byte[] i2 = jarray;
                                            if (!TRACE) return i2;
                                            if (!OracleLog.recursiveEnter()) return i2;
                                            try {
                                                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                            }
                                            finally {
                                                OracleLog.recursiveExit();
                                            }
                                            return i2;
                                        }
                                        if (!type.equals("char")) break block97;
                                        char[] jarray = new char[darray.length];
                                        for (int i3 = 0; i3 < darray.length; ++i3) {
                                            jarray[i3] = darray[i3] != null && darray[i3].getLength() != 0L ? (char)darray[i3].intValue() : (char)'\u0000';
                                        }
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + jarray);
                                            }
                                            finally {
                                                OracleLog.recursiveExit();
                                            }
                                        }
                                        char[] i3 = jarray;
                                        if (!TRACE) return i3;
                                        if (!OracleLog.recursiveEnter()) return i3;
                                        try {
                                            OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                        }
                                        finally {
                                            OracleLog.recursiveExit();
                                        }
                                        return i3;
                                    }
                                    if (!type.equals("double")) break block100;
                                    double[] jarray = new double[darray.length];
                                    for (int i4 = 0; i4 < darray.length; ++i4) {
                                        jarray[i4] = darray[i4] != null && darray[i4].getLength() != 0L ? darray[i4].doubleValue() : 0.0;
                                    }
                                    if (TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + jarray);
                                        }
                                        finally {
                                            OracleLog.recursiveExit();
                                        }
                                    }
                                    double[] i4 = jarray;
                                    if (!TRACE) return i4;
                                    if (!OracleLog.recursiveEnter()) return i4;
                                    try {
                                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                    return i4;
                                }
                                if (!type.equals("float")) break block103;
                                float[] jarray = new float[darray.length];
                                for (int i5 = 0; i5 < darray.length; ++i5) {
                                    jarray[i5] = darray[i5] != null && darray[i5].getLength() != 0L ? darray[i5].floatValue() : 0.0f;
                                }
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + jarray);
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                float[] i5 = jarray;
                                if (!TRACE) return i5;
                                if (!OracleLog.recursiveEnter()) return i5;
                                try {
                                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                                return i5;
                            }
                            if (!type.equals("int")) break block106;
                            int[] jarray = new int[darray.length];
                            for (int i6 = 0; i6 < darray.length; ++i6) {
                                jarray[i6] = darray[i6] != null && darray[i6].getLength() != 0L ? darray[i6].intValue() : 0;
                            }
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + jarray);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            int[] i6 = jarray;
                            if (!TRACE) return i6;
                            if (!OracleLog.recursiveEnter()) return i6;
                            try {
                                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                            return i6;
                        }
                        if (!type.equals("long")) break block109;
                        long[] jarray = new long[darray.length];
                        for (int i7 = 0; i7 < darray.length; ++i7) {
                            jarray[i7] = darray[i7] != null && darray[i7].getLength() != 0L ? darray[i7].longValue() : 0L;
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + jarray);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        long[] i7 = jarray;
                        if (!TRACE) return i7;
                        if (!OracleLog.recursiveEnter()) return i7;
                        try {
                            OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        return i7;
                    }
                    if (!type.equals("short")) break block112;
                    short[] jarray = new short[darray.length];
                    for (int i8 = 0; i8 < darray.length; ++i8) {
                        jarray[i8] = darray[i8] != null && darray[i8].getLength() != 0L ? (short)darray[i8].intValue() : (short)0;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + jarray);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    short[] i8 = jarray;
                    if (!TRACE) return i8;
                    if (!OracleLog.recursiveEnter()) return i8;
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    return i8;
                }
                try {
                    if (!type.equals("boolean")) break block115;
                    boolean[] jarray = new boolean[darray.length];
                    for (int i9 = 0; i9 < darray.length; ++i9) {
                        jarray[i9] = darray[i9] != null && darray[i9].getLength() != 0L ? darray[i9].booleanValue() : false;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + jarray);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    blArray = jarray;
                    if (!TRACE) return blArray;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return blArray;
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return blArray;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum[] getOraclePlsqlIndexTable(int parameterIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum[] datumArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (this.atLeastOneNamedParameter) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                Accessor accessor = null;
                if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.lastIndex = parameterIndex;
                if (this.streamList != null) {
                    this.closeUsedStreams(parameterIndex);
                }
                Datum[] __result__ = accessor.getOraclePlsqlIndexTable(this.currentRank);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                datumArray = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return datumArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.ensureOpen();
                if (this.atLeastOneNamedParameter && this.atLeastOneOrdinalParameter) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (this.sqlObject.setNamedParameters(this.parameterCount, this.namedParameters)) {
                    this.needToParse = true;
                }
                boolean __result__ = super.execute();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                throw throwable;
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            return bl;
        }
        finally {
            OracleLog.recursiveExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                if (this.atLeastOneNamedParameter && this.atLeastOneOrdinalParameter) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (this.sqlObject.setNamedParameters(this.parameterCount, this.namedParameters)) {
                    this.needToParse = true;
                }
                int __result__ = super.executeUpdate();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    void releaseBuffers() {
        if (this.outBindAccessors != null) {
            int len = this.outBindAccessors.length;
            for (int i2 = 0; i2 < len; ++i2) {
                if (this.outBindAccessors[i2] == null) continue;
                this.outBindAccessors[i2].rowSpaceByte = null;
                this.outBindAccessors[i2].rowSpaceChar = null;
            }
        }
        super.releaseBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doLocalInitialization() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.outBindAccessors != null) {
                int len = this.outBindAccessors.length;
                for (int i2 = 0; i2 < len; ++i2) {
                    if (this.outBindAccessors[i2] == null) continue;
                    this.outBindAccessors[i2].rowSpaceByte = this.bindBytes;
                    this.outBindAccessors[i2].rowSpaceChar = this.bindChars;
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setArray(int paramIndex, Array x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setArrayInternal(paramIndex, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBigDecimal(int paramIndex, BigDecimal x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBigDecimalInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int paramIndex, Blob x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBlobInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoolean(int paramIndex, boolean x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBooleanInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setByte(int paramIndex, byte x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setByteInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(int paramIndex, byte[] x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBytesInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int paramIndex, Clob x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setClobInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(int paramIndex, Date x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setDateInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(int paramIndex, Date x, Calendar y) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setDateInternal(paramIndex, x, y);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDouble(int paramIndex, double x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setDoubleInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFloat(int paramIndex, float x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setFloatInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInt(int paramIndex, int x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setIntInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLong(int paramIndex, long x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setLongInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int paramIndex, Object x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setObjectInternal(paramIndex, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int paramIndex, Object x, int y) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setObjectInternal(paramIndex, x, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRef(int paramIndex, Ref x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setRefInternal(paramIndex, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShort(int paramIndex, short x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setShortInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(int paramIndex, String x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setStringInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTime(int paramIndex, Time x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setTimeInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTime(int paramIndex, Time x, Calendar y) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setTimeInternal(paramIndex, x, y);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int paramIndex, Timestamp x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setTimestampInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int paramIndex, Timestamp x, Calendar y) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setTimestampInternal(paramIndex, x, y);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURL(int paramIndex, URL x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setURLInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setARRAY(int paramIndex, ARRAY x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setARRAYInternal(paramIndex, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBFILE(int paramIndex, BFILE x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBFILEInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBfile(int paramIndex, BFILE x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBfileInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryFloat(int paramIndex, float x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBinaryFloatInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryFloat(int paramIndex, BINARY_FLOAT x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBinaryFloatInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryDouble(int paramIndex, double x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBinaryDoubleInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryDouble(int paramIndex, BINARY_DOUBLE x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBinaryDoubleInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBLOB(int paramIndex, BLOB x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBLOBInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCHAR(int paramIndex, CHAR x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setCHARInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCLOB(int paramIndex, CLOB x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setCLOBInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursor(int paramIndex, ResultSet x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setCursorInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomDatum(int paramIndex, CustomDatum x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setCustomDatumInternal(paramIndex, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDATE(int paramIndex, DATE x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setDATEInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFixedCHAR(int paramIndex, String x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setFixedCHARInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setINTERVALDS(int paramIndex, INTERVALDS x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setINTERVALDSInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setINTERVALYM(int paramIndex, INTERVALYM x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setINTERVALYMInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNUMBER(int paramIndex, NUMBER x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setNUMBERInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOPAQUE(int paramIndex, OPAQUE x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setOPAQUEInternal(paramIndex, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOracleObject(int paramIndex, Datum x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setOracleObjectInternal(paramIndex, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setORAData(int paramIndex, ORAData x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setORADataInternal(paramIndex, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRAW(int paramIndex, RAW x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setRAWInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setREF(int paramIndex, REF x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setREFInternal(paramIndex, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRefType(int paramIndex, REF x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setRefTypeInternal(paramIndex, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setROWID(int paramIndex, ROWID x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setROWIDInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSTRUCT(int paramIndex, STRUCT x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setSTRUCTInternal(paramIndex, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTIMESTAMPLTZ(int paramIndex, TIMESTAMPLTZ x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setTIMESTAMPLTZInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTIMESTAMPTZ(int paramIndex, TIMESTAMPTZ x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setTIMESTAMPTZInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTIMESTAMP(int paramIndex, TIMESTAMP x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setTIMESTAMPInternal(paramIndex, x);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(int paramIndex, InputStream x, int y) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setAsciiStreamInternal(paramIndex, x, y);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(int paramIndex, InputStream x, int y) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBinaryStreamInternal(paramIndex, x, y);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(int paramIndex, Reader x, int y) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setCharacterStreamInternal(paramIndex, x, y);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnicodeStream(int paramIndex, InputStream x, int y) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setUnicodeStreamInternal(paramIndex, x, y);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setArray(String parameterName, Array x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setArrayInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setBigDecimalInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(String parameterName, Blob x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setBlobInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setBooleanInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setByte(String parameterName, byte x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setByteInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setBytesInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(String parameterName, Clob x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setClobInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(String parameterName, Date x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setDateInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(String parameterName, Date x, Calendar y) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setDateInternal(index, x, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDouble(String parameterName, double x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setDoubleInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFloat(String parameterName, float x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setFloatInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInt(String parameterName, int x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setIntInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLong(String parameterName, long x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setLongInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(String parameterName, Object x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setObjectInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(String parameterName, Object x, int y) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setObjectInternal(index, x, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRef(String parameterName, Ref x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setRefInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShort(String parameterName, short x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setShortInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(String parameterName, String x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setStringInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTime(String parameterName, Time x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setTimeInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTime(String parameterName, Time x, Calendar y) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setTimeInternal(index, x, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setTimestampInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(String parameterName, Timestamp x, Calendar y) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setTimestampInternal(index, x, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURL(String parameterName, URL x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setURLInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setARRAY(String parameterName, ARRAY x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setARRAYInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBFILE(String parameterName, BFILE x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setBFILEInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBfile(String parameterName, BFILE x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setBfileInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryFloat(String parameterName, float x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setBinaryFloatInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryFloat(String parameterName, BINARY_FLOAT x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setBinaryFloatInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryDouble(String parameterName, double x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setBinaryDoubleInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryDouble(String parameterName, BINARY_DOUBLE x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setBinaryDoubleInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBLOB(String parameterName, BLOB x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setBLOBInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCHAR(String parameterName, CHAR x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setCHARInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCLOB(String parameterName, CLOB x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setCLOBInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursor(String parameterName, ResultSet x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setCursorInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomDatum(String parameterName, CustomDatum x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setCustomDatumInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDATE(String parameterName, DATE x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setDATEInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFixedCHAR(String parameterName, String x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setFixedCHARInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setINTERVALDS(String parameterName, INTERVALDS x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setINTERVALDSInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setINTERVALYM(String parameterName, INTERVALYM x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setINTERVALYMInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNUMBER(String parameterName, NUMBER x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setNUMBERInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOPAQUE(String parameterName, OPAQUE x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setOPAQUEInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOracleObject(String parameterName, Datum x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setOracleObjectInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setORAData(String parameterName, ORAData x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setORADataInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRAW(String parameterName, RAW x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setRAWInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setREF(String parameterName, REF x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setREFInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRefType(String parameterName, REF x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setRefTypeInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setROWID(String parameterName, ROWID x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setROWIDInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSTRUCT(String parameterName, STRUCT x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setSTRUCTInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTIMESTAMPLTZ(String parameterName, TIMESTAMPLTZ x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setTIMESTAMPLTZInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTIMESTAMPTZ(String parameterName, TIMESTAMPTZ x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setTIMESTAMPTZInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTIMESTAMP(String parameterName, TIMESTAMP x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setTIMESTAMPInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(String parameterName, InputStream x, int y) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setAsciiStreamInternal(index, x, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(String parameterName, InputStream x, int y) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setBinaryStreamInternal(index, x, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(String parameterName, Reader x, int y) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setCharacterStreamInternal(index, x, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnicodeStream(String parameterName, InputStream x, int y) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setUnicodeStreamInternal(index, x, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNull(String parameterName, int x, String y) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setNullInternal(index, x, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNull(String parameterName, int x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setNullInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStructDescriptor(String parameterName, StructDescriptor x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName) + ", " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(parameterName);
            this.setStructDescriptorInternal(index, x);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(String name, Object value, int type, int scale) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(scale));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = this.addNamedPara(name);
            this.setObjectInternal(index, value, type, scale);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlsqlIndexTable(int paramIndex, Object arrayData, int maxLen, int curLen, int elemSqlType, int elemMaxLen) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(arrayData) + ", " + OracleLog.argument(maxLen) + ", " + OracleLog.argument(curLen) + ", " + OracleLog.argument(elemSqlType) + ", " + OracleLog.argument(elemMaxLen));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setPlsqlIndexTableInternal(paramIndex, arrayData, maxLen, curLen, elemSqlType, elemMaxLen);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int addNamedPara(String parameterName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iParameterName = parameterName.toUpperCase().intern();
            for (int i2 = 0; i2 < this.parameterCount; ++i2) {
                if (iParameterName != this.namedParameters[i2]) continue;
                int __result__ = i2 + 1;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n2 = __result__;
                return n2;
            }
            if (this.parameterCount >= this.namedParameters.length) {
                String[] newList = new String[this.namedParameters.length * 2];
                System.arraycopy(this.namedParameters, 0, newList, 0, this.namedParameters.length);
                this.namedParameters = newList;
            }
            this.namedParameters[this.parameterCount++] = iParameterName;
            this.atLeastOneNamedParameter = true;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.parameterCount);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = this.parameterCount;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(String parameterName) throws SQLException {
        Reader reader;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Reader __result__ = accessor.getCharacterStream(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            reader = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getUnicodeStream(String parameterName) throws SQLException {
        InputStream inputStream;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            InputStream __result__ = accessor.getUnicodeStream(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            inputStream = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(String parameterName) throws SQLException {
        InputStream inputStream;
        try {
            int parameterIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            InputStream __result__ = accessor.getBinaryStream(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            inputStream = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return inputStream;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleCallableStatement"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

