/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.JAVA_STRUCT;
import oracle.sql.OPAQUE;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

class NamedTypeAccessor
extends TypeAccessor {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamedTypeAccessor(OracleStatement stmt, String typeName, short form, int external_type, boolean forBind) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(typeName) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.init(stmt, 109, 109, form, forBind);
            this.initForDataAccess(external_type, 0, typeName);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamedTypeAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, String typeName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.init(stmt, 109, 109, form, false);
            this.initForDescribe(109, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
            this.initForDataAccess(0, max_len, typeName);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamedTypeAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, String typeName, OracleType otype) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(typeName) + ", " + OracleLog.argument(otype));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.init(stmt, 109, 109, form, false);
            this.describeOtype = otype;
            this.initForDescribe(109, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
            this.internalOtype = otype;
            this.initForDataAccess(0, max_len, typeName);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleType otypeFromName(String typeName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.outBind) {
                OracleNamedType __result__ = TypeDescriptor.getTypeDescriptor(typeName, this.statement.connection).getPickler();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleNamedType oracleNamedType = __result__;
                return oracleNamedType;
            }
            if (this.externalType == 2003) {
                OracleTypeCOLLECTION __result__ = ArrayDescriptor.createDescriptor(typeName, (Connection)this.statement.connection).getOracleTypeCOLLECTION();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleTypeCOLLECTION oracleTypeCOLLECTION = __result__;
                return oracleTypeCOLLECTION;
            }
            if (this.externalType == 2007) {
                OracleNamedType __result__ = OpaqueDescriptor.createDescriptor(typeName, (Connection)this.statement.connection).getPickler();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleNamedType oracleNamedType = __result__;
                return oracleNamedType;
            }
            OracleTypeADT __result__ = StructDescriptor.createDescriptor(typeName, (Connection)this.statement.connection).getOracleTypeADT();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleTypeADT oracleTypeADT = __result__;
            return oracleTypeADT;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            super.initForDataAccess(external_type, max_len, typeName);
            this.byteLength = this.statement.connection.namedTypeAccessorByteLen;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getObject(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object __result__ = this.getObject(currentRow, this.statement.connection.getTypeMap());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = __result__;
            return object;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getObject(int currentRow, OracleDataFactory oracleDataFactory) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleData __result__ = oracleDataFactory.create(this.getObject(currentRow, this.statement.connection.getTypeMap()), 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleData oracleData = __result__;
            return oracleData;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    Object getObject(int currentRow, Map map) throws SQLException {
        try {
            block87: {
                if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(map));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.rowSpaceIndicator == null) {
                    if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            NamedTypeAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) break block87;
                if (this.externalType == 0) {
                    named_obj = this.getOracleObject(currentRow);
                    if (named_obj == null) {
                        if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        var4_9 = null;
                        return var4_9;
                    }
                    if (named_obj instanceof STRUCT) {
                        __result__ = ((STRUCT)named_obj).toJdbc(map);
                        if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        var5_18 = __result__;
                        return var5_18;
                    }
                    if (named_obj instanceof OPAQUE) {
                        obj = ((OPAQUE)named_obj).toJdbc(map);
                        if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + obj);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        var5_19 = obj;
                        return var5_19;
                    }
                    obj = named_obj.toJdbc();
                    return obj;
                }
                switch (this.externalType) {
                    case 2008: {
                        map = null;
                    }
                    case 2000: 
                    case 2002: 
                    case 2003: 
                    case 2007: {
                        named_obj = this.getOracleObject(currentRow);
                        if (named_obj != null) ** GOTO lbl78
                        if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        obj = null;
                        return obj;
lbl78:
                        // 1 sources

                        if (!(named_obj instanceof STRUCT)) ** GOTO lbl89
                        __result__ = ((STRUCT)named_obj).toJdbc(map);
                        if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        var5_20 = __result__;
                        return var5_20;
lbl89:
                        // 1 sources

                        __result__ = named_obj.toJdbc();
                        if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        var5_21 = __result__;
                        return var5_21;
                    }
                }
                if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NamedTypeAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var3_7 = null;
            return var3_7;
        }
        finally {
            if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Datum getOracleObject(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            DatumWithConnection result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NamedTypeAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            byte[] data = this.pickledBytes(currentRow);
            if (data == null || data.length == 0) {
                Datum datum = null;
                return datum;
            }
            PhysicalConnection conn = this.statement.connection;
            OracleTypeADT otype = (OracleTypeADT)this.internalOtype;
            TypeDescriptor desc = TypeDescriptor.getTypeDescriptor(otype.getFullName(), conn, data, 0L);
            switch (desc.getTypeCode()) {
                case 2003: {
                    result = new ARRAY((ArrayDescriptor)desc, data, conn);
                    break;
                }
                case 2002: {
                    result = new STRUCT((StructDescriptor)desc, data, conn);
                    break;
                }
                case 2007: {
                    result = new OPAQUE((OpaqueDescriptor)desc, data, conn);
                    break;
                }
                case 2008: {
                    result = new JAVA_STRUCT((StructDescriptor)desc, data, conn);
                    break;
                }
                default: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            NamedTypeAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            DatumWithConnection datumWithConnection = result;
            return datumWithConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ARRAY getARRAY(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ARRAY __result__ = (ARRAY)this.getOracleObject(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ARRAY aRRAY = __result__;
            return aRRAY;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    STRUCT getSTRUCT(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            STRUCT __result__ = (STRUCT)this.getOracleObject(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            STRUCT sTRUCT = __result__;
            return sTRUCT;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OPAQUE getOPAQUE(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OPAQUE __result__ = (OPAQUE)this.getOracleObject(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OPAQUE oPAQUE = __result__;
            return oPAQUE;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isNull(int currentRow) throws SQLException {
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NamedTypeAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            byte[] data = this.pickledBytes(currentRow);
            boolean bl = __result__ = data == null || data.length == 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NamedTypeAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

