/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.NTFListener;
import oracle.jdbc.driver.NTFRegistration;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;

class NTFManager {
    private Hashtable<Integer, NTFListener> nsListeners = new Hashtable();
    private Hashtable<Integer, NTFRegistration> ntfRegistrations = new Hashtable();
    private byte[] listOfJdbcRegId = new byte[20];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    NTFManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean listenOnPortT4C(int[] portArr, boolean force) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(portArr) + ", " + OracleLog.argument(force));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int tryPort = portArr[0];
            boolean newListenerThreadCreated = false;
            while (this.nsListeners.get(tryPort) == null) {
                try {
                    ServerSocketChannel ssChannel = ServerSocketChannel.open();
                    ssChannel.configureBlocking(false);
                    ServerSocket serverSocket = ssChannel.socket();
                    InetSocketAddress isa = new InetSocketAddress(tryPort);
                    try {
                        serverSocket.bind(isa);
                        newListenerThreadCreated = true;
                        NTFListener listener = new NTFListener(this, ssChannel, tryPort);
                        this.nsListeners.put(tryPort, listener);
                        listener.start();
                        break;
                    }
                    catch (BindException be) {
                        if (!force) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    NTFManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 250);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 250);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                        ++tryPort;
                    }
                    catch (IOException iox2) {
                        if (!force) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    NTFManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 250);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 250);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                        ++tryPort;
                    }
                }
                catch (IOException ioe) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            NTFManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ioe);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioe);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            portArr[0] = tryPort;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + newListenerThreadCreated);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = newListenerThreadCreated;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int getNextJdbcRegId() {
        try {
            int off;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            for (off = 1; off < this.listOfJdbcRegId.length && this.listOfJdbcRegId[off] != 0; ++off) {
            }
            if (off == this.listOfJdbcRegId.length - 1) {
                byte[] listOfJdbcRegId2 = new byte[this.listOfJdbcRegId.length * 2];
                System.arraycopy(this.listOfJdbcRegId, 0, listOfJdbcRegId2, 0, this.listOfJdbcRegId.length);
                this.listOfJdbcRegId = listOfJdbcRegId2;
            }
            this.listOfJdbcRegId[off] = 2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + off);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = off;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void addRegistration(NTFRegistration registration) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(registration));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Integer key = registration.getJdbcRegId();
            Hashtable ntfRegistrations2 = (Hashtable)this.ntfRegistrations.clone();
            ntfRegistrations2.put(key, registration);
            this.ntfRegistrations = ntfRegistrations2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean removeRegistration(NTFRegistration registration) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(registration));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Integer key = registration.getJdbcRegId();
            Hashtable ntfRegistrations2 = (Hashtable)this.ntfRegistrations.clone();
            Object obj = ntfRegistrations2.remove(key);
            this.ntfRegistrations = ntfRegistrations2;
            boolean ret = false;
            if (obj != null) {
                ret = true;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void freeJdbcRegId(int jdbcRegId) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(jdbcRegId));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.listOfJdbcRegId != null && this.listOfJdbcRegId.length > jdbcRegId) {
                this.listOfJdbcRegId[jdbcRegId] = 0;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void cleanListenersT4C(int tcpport) {
        try {
            NTFListener listener;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(tcpport));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Enumeration<Integer> keys = this.ntfRegistrations.keys();
            boolean portUsed = false;
            while (!portUsed && keys.hasMoreElements()) {
                Integer localkey = keys.nextElement();
                NTFRegistration reg = this.ntfRegistrations.get(localkey);
                if (reg.getClientTCPPort() != tcpport) continue;
                portUsed = true;
            }
            if (!portUsed && (listener = this.nsListeners.get(tcpport)) != null) {
                listener.closeThisListener();
                listener.interrupt();
                this.nsListeners.remove(tcpport);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFRegistration getRegistration(int jdbcRegId) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(jdbcRegId));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Integer key = jdbcRegId;
            Hashtable<Integer, NTFRegistration> localHandle = this.ntfRegistrations;
            NTFRegistration obj = localHandle.get(key);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + obj);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NTFRegistration nTFRegistration = obj;
            return nTFRegistration;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver.ntf");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NTFManager"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

