/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.Datum;

class CachedRowElement {
    private final int row;
    private final int col;
    private final OracleResultSet.AuthorizationIndicator securityIndicator;
    private final byte[] data;
    private Datum dataAsDatum;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CachedRowElement(int _row, int _col, OracleResultSet.AuthorizationIndicator _securityIndicator, byte[] _data) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CachedRowElement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_row) + ", " + OracleLog.argument(_col) + ", " + OracleLog.argument((Object)_securityIndicator) + ", " + OracleLog.argument(_data));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.row = _row;
            this.col = _col;
            this.securityIndicator = _securityIndicator;
            this.data = _data;
            this.dataAsDatum = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CachedRowElement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleResultSet.AuthorizationIndicator getIndicator() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CachedRowElement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CachedRowElement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)this.securityIndicator));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleResultSet.AuthorizationIndicator authorizationIndicator = this.securityIndicator;
            return authorizationIndicator;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CachedRowElement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setData(Datum dat) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CachedRowElement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(dat));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.dataAsDatum = dat;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CachedRowElement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getData() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CachedRowElement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CachedRowElement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.data);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = this.data;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CachedRowElement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Datum getDataAsDatum() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CachedRowElement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CachedRowElement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.dataAsDatum);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum datum = this.dataAsDatum;
            return datum;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CachedRowElement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.CachedRowElement"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

