/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.BuildInfo;
import oracle.jdbc.driver.OracleLog;

public class OracleDriver
extends oracle.jdbc.driver.OracleDriver {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isDMS() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = BuildInfo.isDMS();
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isInServer() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = BuildInfo.isInServer();
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isJDK14() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = BuildInfo.isJDK14();
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isDebug() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = BuildInfo.isDebug();
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isPrivateDebug() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = BuildInfo.isPrivateDebug();
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getJDBCVersion() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = BuildInfo.getJDBCVersion();
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getDriverVersion() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = BuildInfo.getDriverVersion();
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getBuildDate() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = BuildInfo.getBuildDate();
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String compilerName = "JDK5";
            System.out.println("Oracle " + OracleDriver.getDriverVersion() + " " + OracleDriver.getJDBCVersion() + (OracleDriver.isDMS() ? " DMS" : "") + (OracleDriver.isPrivateDebug() ? " private" : "") + (OracleDriver.isDebug() ? " debug" : "") + (OracleDriver.isInServer() ? " for JAVAVM" : "") + " compiled with " + compilerName + " on " + OracleDriver.getBuildDate());
            ByteArrayOutputStream os = new ByteArrayOutputStream(128);
            DEFAULT_CONNECTION_PROPERTIES.store(os, "Default Connection Properties Resource");
            System.out.println(os.toString("ISO-8859-1"));
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.OracleDriver"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

