/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint.AbstractPaintContext;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class AngularGradientPaintContext
extends AbstractPaintContext {
    private double centerX;
    private double centerY;
    private double centralAngle;
    private double deltaAngle;

    public AngularGradientPaintContext(Rectangle2D.Float bounds, Color color1, Color color2, Point2D.Float center, double centralAngle, double deltaAngle, AffineTransform trans) throws NoninvertibleTransformException {
        super((Rectangle2D)bounds, color1, color2, trans);
        this.centerX = center.getX();
        this.centerY = center.getY();
        this.centralAngle = centralAngle;
        this.deltaAngle = deltaAngle;
    }

    public final double calcGradientValue(double X, double Y) {
        double fValue = 1.0;
        double x = X - this.centerX;
        double y = Y - this.centerY;
        double angle = Math.atan2(y, x);
        if ((angle -= this.centralAngle) < 0.0) {
            angle = -angle;
        }
        if (angle > Math.PI) {
            angle = Math.PI * 2 - angle;
        }
        if (angle < this.deltaAngle) {
            fValue = angle / this.deltaAngle;
        }
        if (!(fValue >= 0.0) || !(fValue <= 1.0)) {
            System.out.println("X=" + X + ",Y=" + Y + "\nx=" + x + "',y=" + y + "\ncentralA=" + this.centralAngle + "\ndeltaA=" + this.deltaAngle);
            assert (false);
        }
        return fValue;
    }
}

