/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.FillRenderer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.ListOfLayersComposition;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.ScaledRenderer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.Shape_Layer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.SphereView;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint.RadialGradientPaint;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint.RadialGradientPaintExt;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.sun.Position;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;

public class SphereComposition {
    private transient SphereView sphereView = null;
    private transient IBlackBox bb = null;
    private transient Rectangle bounds = null;
    private Color backgroundColor = Color.white;
    private Color highlightColor = Color.green;
    private Color midtoneColor = Color.blue;
    private double highlightInterval = 1.0;
    private double midtoneInterval = 3.0;
    private boolean m_bSpecularLightOn = true;
    private int sphereSize = 200;
    private Paint m_sphereFillPaint = null;

    public void setBlackBox(IBlackBox bb) {
        this.bb = bb;
        this.setMidtoneColor(bb.getBorderColor());
        this.setHighlightColor(bb.getFillColor());
        this.setSpecularLight(bb.isSpecularLight());
    }

    public IBlackBox getBlackBox() {
        return this.bb;
    }

    public int getSphereSize() {
        return this.sphereSize;
    }

    public void setSphereSize(int sphereSize) {
        this.sphereSize = sphereSize;
    }

    public double getHighlightInterval() {
        return this.highlightInterval;
    }

    public void setHighlightInterval(double highlightInterval) {
        this.highlightInterval = highlightInterval;
    }

    public void setSpecularLight(boolean bOn) {
        this.m_bSpecularLightOn = bOn;
    }

    public double getMidtoneInterval() {
        return this.midtoneInterval;
    }

    public void setMidtoneInterval(double midtoneInterval) {
        this.midtoneInterval = midtoneInterval;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public Color getMidtoneColor() {
        return this.midtoneColor;
    }

    public void setMidtoneColor(Color midtoneColor) {
        this.midtoneColor = midtoneColor;
    }

    public void setSphereView(SphereView view) {
        this.sphereView = view;
    }

    public int getMargin() {
        return 10;
    }

    public void setMargin(int margin) {
    }

    static final void calcBoundingRect(Rectangle rect, Point center) {
        int dx = Math.max(Math.abs(center.x - rect.x), Math.abs(center.x - rect.x - rect.width));
        int dy = Math.max(Math.abs(center.y - rect.y), Math.abs(center.y - rect.y - rect.height));
        rect.x = center.x - dx;
        rect.y = center.y - dy;
        rect.width = dx + dx;
        rect.height = dy + dy;
    }

    static final void calcBoundingSquare(Rectangle rect, Point center) {
        int dx = Math.max(Math.abs(center.x - rect.x), Math.abs(center.x - rect.x - rect.width));
        int dy = Math.max(Math.abs(center.y - rect.y), Math.abs(center.y - rect.y - rect.height));
        int dr = Math.max(dx, dy);
        int dr2 = dr + dr;
        rect.x = center.x - dr;
        rect.y = center.y - dr;
        rect.width = dr2;
        rect.height = dr2;
    }

    public ListOfLayersComposition build() {
        Rectangle gradientRect;
        if (this.sphereView == null) {
            throw new IllegalArgumentException("SphereView instance is null.");
        }
        if (!this.sphereView.isVisible()) {
            return new ListOfLayersComposition(new Dimension());
        }
        Shape visibleEllipse = this.sphereView.calcContourEllipse();
        this.bounds = gradientRect = visibleEllipse.getBounds();
        Dimension size = new Dimension(this.bounds.width + this.getMargin() * 2, this.bounds.height + this.getMargin() * 2);
        ListOfLayersComposition cmp = new ListOfLayersComposition(size);
        Paint filling = null;
        Point brightestPoint = this.sphereView.getBrightestPoint();
        SphereComposition.calcBoundingSquare(gradientRect, brightestPoint);
        if (this.m_bSpecularLightOn) {
            Color[] gradientColors = new Color[]{Color.white, this.highlightColor, this.midtoneColor};
            double[] gradientIntervals = new double[]{this.highlightInterval, this.midtoneInterval};
            filling = new RadialGradientPaintExt(gradientRect, gradientColors, gradientIntervals);
        } else {
            filling = new RadialGradientPaint(gradientRect, this.highlightColor, this.midtoneColor);
        }
        ScaledRenderer renderer = new ScaledRenderer(new FillRenderer(filling));
        Shape_Layer sphereLayer = new Shape_Layer(cmp, visibleEllipse, renderer, Position.CENTER);
        this.m_sphereFillPaint = filling;
        cmp.setLayers(new Shape_Layer[]{sphereLayer});
        cmp.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return cmp;
    }

    public Paint getSpherePaint() {
        return this.m_sphereFillPaint;
    }
}

