/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IDrawContainer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.IModel3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Matrix4d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Model3DFlatFace
implements IModel3D {
    public static final int XX = 0;
    public static final int YY = 1;
    public static final int ZZ = 2;
    public static final int MIN_POINTS = 3;
    public static final double BY_ANGLE_SCALE = 1.0;
    private static final int OBJ_FACTOR = 1000;
    private static final int FACE_FACTOR = 1000000;
    private static final int AXIS_FACTOR = 100000000;
    private static final double BRIGHTNESS_FACTOR = 3.0;
    private static final double DARKNESS_FACTOR = 0.3333333333333333;
    protected JChart_3D m_chart;
    private Point3d m_viewer;
    protected IdentObj m_id;
    IBlackBox m_bb;
    int m_nVertices;
    protected Point3d[] m_vertices;
    Point3d[] m_xVertices;
    Point2D[] m_projVertices;
    boolean m_bIsTransformed;
    boolean m_bIsProjected;
    int m_nFaces;
    protected int[][] m_faces;
    protected double m_distance;
    protected IDrawContainer drawContainer;
    List<Point3d>[][][] m_GridLines;
    Point3d m_boundMin;
    Point3d m_boundMax;
    boolean[][] m_bGridStatus;
    protected boolean m_bWantGrids;
    boolean m_bAutoshading;
    boolean m_bCanUseSimpleVisibility;
    Point3d[] m_ptsForNormal;
    int m_nPointsFound;
    double m_floorLevel;
    Point3d m_vLightDirection;
    Point3d[] m_vNormal;
    Point3d[] m_vNormalInWorld = null;
    Point3d m_lightDirectionInWorld;

    protected Model3DFlatFace(JChart_3D chart, IdentObj id, IBlackBox bb, int nFaces, int nVertices, boolean[][] bGridStatus, boolean bAutoshading) {
        this.m_chart = chart;
        this.m_viewer = null;
        this.m_id = id;
        this.m_bb = bb;
        this.m_nVertices = nVertices;
        this.m_nFaces = nFaces;
        this.drawContainer = this.m_chart.getDrawContainer();
        this.m_bIsTransformed = false;
        this.m_bIsProjected = false;
        this.m_vertices = new Point3d[this.m_nVertices];
        this.m_xVertices = new Point3d[this.m_nVertices];
        this.m_projVertices = new Point2D.Double[this.m_nVertices];
        this.m_vNormal = new Point3d[this.m_nFaces];
        this.m_vLightDirection = this.m_chart.m_ColorLightVersor;
        this.m_bGridStatus = bGridStatus;
        this.m_bWantGrids = bGridStatus == null ? false : bGridStatus[1][0] || bGridStatus[1][1] || bGridStatus[1][2];
        this.m_bAutoshading = bAutoshading;
        this.m_bCanUseSimpleVisibility = false;
        this.m_GridLines = null;
        this.m_floorLevel = this.m_chart.getCubeWallThickY();
    }

    @Override
    public IdentObj getIdentObj() {
        return this.m_id;
    }

    protected Point3d getLightDirectionInWorld() {
        Point3d v = this.m_vLightDirection;
        Matrix4d mm = this.m_chart.getMatrix();
        mm.transformCovector3d(v, v);
        return v;
    }

    public void getBounds(Point3d min, Point3d max) {
        min.copy(this.m_vertices[0]);
        max.copy(this.m_vertices[0]);
        for (int v = 1; v < this.m_nVertices; ++v) {
            if (this.m_vertices[v].x < min.x) {
                min.x = this.m_vertices[v].x;
            }
            if (this.m_vertices[v].x > max.x) {
                max.x = this.m_vertices[v].x;
            }
            if (this.m_vertices[v].y < min.y) {
                min.y = this.m_vertices[v].y;
            }
            if (this.m_vertices[v].y > max.y) {
                max.y = this.m_vertices[v].y;
            }
            if (this.m_vertices[v].z < min.z) {
                min.z = this.m_vertices[v].z;
            }
            if (!(this.m_vertices[v].z > max.z)) continue;
            max.z = this.m_vertices[v].z;
        }
    }

    public static double applyDiffuseLighting(Point3d vNormal, Point3d vLight) {
        double fCosAngleOfIncidence;
        vNormal.normalize();
        double fIntensity = fCosAngleOfIncidence = vNormal.mult(vLight);
        fIntensity = fIntensity < 0.2 ? Math.pow(0.2, 0.3333333333333333) : Math.pow(fIntensity, 0.3333333333333333);
        return fIntensity;
    }

    private void calcBounds() {
        this.m_boundMin = new Point3d(this.m_vertices[0].x, this.m_vertices[0].y, this.m_vertices[0].z);
        this.m_boundMax = new Point3d(this.m_vertices[0].x, this.m_vertices[0].y, this.m_vertices[0].z);
        for (int v = 1; v < this.m_nVertices; ++v) {
            if (this.m_vertices[v].x < this.m_boundMin.x) {
                this.m_boundMin.x = this.m_vertices[v].x;
            }
            if (this.m_vertices[v].x > this.m_boundMax.x) {
                this.m_boundMax.x = this.m_vertices[v].x;
            }
            if (this.m_vertices[v].y < this.m_boundMin.y) {
                this.m_boundMin.y = this.m_vertices[v].y;
            }
            if (this.m_vertices[v].y > this.m_boundMax.y) {
                this.m_boundMax.y = this.m_vertices[v].y;
            }
            if (this.m_vertices[v].z < this.m_boundMin.z) {
                this.m_boundMin.z = this.m_vertices[v].z;
            }
            if (!(this.m_vertices[v].z > this.m_boundMax.z)) continue;
            this.m_boundMax.z = this.m_vertices[v].z;
        }
    }

    @Override
    public Point2D getPosition(Matrix4d matrix, int nDataTextPosition) throws UnsupportedOperationException {
        switch (nDataTextPosition) {
            case 0: {
                this.calcBounds();
                double x = (this.m_boundMin.x + this.m_boundMax.x) / 2.0;
                double y = this.m_boundMax.y;
                double z = (this.m_boundMin.z + this.m_boundMax.z) / 2.0;
                Point3d p3d = new Point3d(x, y, z);
                this.m_chart.transformPoint3d(p3d);
                return this.m_chart.projectPoint3dInDouble(p3d);
            }
            case 1: {
                this.calcBounds();
                double x = (this.m_boundMin.x + this.m_boundMax.x) / 2.0;
                double y = this.m_boundMax.y + 3000.0;
                if (y > this.m_chart.getCubeSize().y) {
                    y = this.m_chart.getCubeSize().y;
                }
                double z = (this.m_boundMin.z + this.m_boundMax.z) / 2.0;
                Point3d p3d = new Point3d(x, y, z);
                this.m_chart.transformPoint3d(p3d);
                return this.m_chart.projectPoint3dInDouble(p3d);
            }
        }
        throw new UnsupportedOperationException("NYI for data text position " + nDataTextPosition);
    }

    @Override
    public void calcDistance(Matrix4d matrix, Point3d viewer) {
        Point3d center = this.getCenter();
        center.y = this.m_floorLevel;
        this.m_chart.transformPoint3d(center);
        double dist2 = (viewer.x - center.x) * (viewer.x - center.x) + (viewer.y - center.y) * (viewer.y - center.y) + (viewer.z - center.z) * (viewer.z - center.z);
        this.m_distance = Math.sqrt(dist2);
    }

    public void calcEdges() {
    }

    private void calcGridLines() {
        Point3d ptStart = null;
        Point3d ptEnd = null;
        this.m_GridLines = new ArrayList[2][3][this.m_nFaces];
        for (int nGridType = 0; nGridType < 2; ++nGridType) {
            for (int nAxis = 0; nAxis <= 2; ++nAxis) {
                double axisMax;
                double axisMin;
                if (!this.m_bGridStatus[nGridType][nAxis]) continue;
                if (nAxis == 0) {
                    axisMin = this.m_boundMin.x;
                    axisMax = this.m_boundMax.x;
                } else if (nAxis == 1) {
                    axisMin = this.m_boundMin.y;
                    axisMax = this.m_boundMax.y;
                } else {
                    axisMin = this.m_boundMin.z;
                    axisMax = this.m_boundMax.z;
                }
                List<Double> gridPos = nGridType == 0 ? this.m_chart.getMinorGridPositions(nAxis) : this.m_chart.getMajorGridPositions(nAxis);
                for (int nFace = 0; nFace < this.m_nFaces; ++nFace) {
                    this.m_GridLines[nGridType][nAxis][nFace] = null;
                    int gridCount = gridPos.size();
                    for (int index = 0; index < gridCount; ++index) {
                        double d = gridPos.get(index);
                        ptStart = this.getGridLineStart(nAxis, nFace, d);
                        ptEnd = this.getGridLineEnd(nAxis, nFace, d);
                        if (ptStart == null || ptEnd == null || !(d > axisMin) || !(d < axisMax)) continue;
                        if (this.m_GridLines[nGridType][nAxis][nFace] == null) {
                            this.m_GridLines[nGridType][nAxis][nFace] = new ArrayList<Point3d>();
                        }
                        this.m_GridLines[nGridType][nAxis][nFace].add(ptStart);
                        this.m_GridLines[nGridType][nAxis][nFace].add(ptEnd);
                    }
                }
            }
        }
    }

    @Override
    public void calcGrids() {
        if (this.m_bWantGrids) {
            this.calcBounds();
            this.calcGridLines();
        }
    }

    @Override
    public void display() {
        if (this.m_bCanUseSimpleVisibility && !this.m_bWantGrids) {
            IBlackBox bb = this.m_bb != null ? this.m_bb : this.m_chart.getModelBlackBox(this.m_id);
            this.transformVertices();
            this.projectVertices();
            IdentObj newId = this.m_id;
            Polygon poly = this.projectVertices(0);
            DrawFactory.createPolygon(this.drawContainer, newId, poly, bb, null, 1.0);
            newId = this.m_id.incrementMisc(2);
            poly = this.projectVertices(2);
            DrawFactory.createPolygon(this.drawContainer, newId, poly, bb, null, 1.0);
            newId = this.m_id.incrementMisc(4);
            poly = this.projectVertices(4);
            DrawFactory.createPolygon(this.drawContainer, newId, poly, bb, null, 1.0);
        } else {
            double fIntensity = 1.0;
            IBlackBox bb = this.m_bb == null ? this.m_chart.getModelBlackBox(this.m_id) : this.m_bb;
            this.transformVertices();
            if (this.m_bWantGrids) {
                this.transformGrids();
            }
            this.projectVertices();
            for (int f = 0; f < this.getNumFaces(); ++f) {
                if (this.m_bCanUseSimpleVisibility) {
                    if (!this.isVisibleIpsoFacto(f)) continue;
                    this.displayFace(f, bb, fIntensity);
                    continue;
                }
                Point3d vNormal = this.visibility(f);
                if (vNormal == null) continue;
                if (this.m_bAutoshading) {
                    fIntensity = Model3DFlatFace.applyDiffuseLighting(vNormal, this.m_vLightDirection);
                }
                this.displayFace(f, bb, fIntensity);
            }
        }
    }

    public void displayFace(int f, IBlackBox bb, double fIntensity) {
        Polygon poly = this.projectVertices(f);
        IdentObj newId = this.m_id.incrementMisc(f);
        DrawFactory.createPolygon(this.drawContainer, newId, poly, bb, null, fIntensity);
        if (this.m_bWantGrids) {
            this.displayGridFace(true, 0, f);
            this.displayGridFace(true, 1, f);
            this.displayGridFace(true, 2, f);
            this.displayGridFace(false, 0, f);
            this.displayGridFace(false, 1, f);
            this.displayGridFace(false, 2, f);
        }
    }

    protected void displayGridFace(boolean bMajor, int nAxis, int nFace) {
        int nUniqueIdentifier = 0;
        List<Point> pts = this.projectGrids(bMajor, nAxis, nFace);
        if (pts != null) {
            IdentObj idGrid = bMajor ? this.m_chart.getMajorGridId(nAxis) : this.m_chart.getMinorGridId(nAxis);
            IBlackBox bbGrid = bMajor ? this.m_chart.getMajorGridsBlackBox(nAxis) : this.m_chart.getMinorGridsBlackBox(nAxis);
            double fLineWidth = 0.0;
            Perspective persp = this.m_chart.getPerspective();
            IAxis3D axis = (IAxis3D)((Object)this.m_chart.getAxisObj(nAxis));
            IdentObj idMajor = new IdentObj(axis.getMajorGridId().getObjectID());
            if (bMajor) {
                fLineWidth = persp.getLineWidth(idMajor);
            }
            for (int i = 0; i < pts.size(); ++i) {
                Point pt0 = pts.get(i);
                Point pt1 = pts.get(++i);
                Model3DFlatFace.drawIndivGridline(persp, this.m_id, bbGrid, idGrid, nFace, nAxis, nUniqueIdentifier, pt0, pt1, fLineWidth);
                ++nUniqueIdentifier;
                ++nUniqueIdentifier;
            }
            this.displayTopBottomGridFace(bbGrid, idGrid, nAxis, nFace, fLineWidth, nUniqueIdentifier);
        }
    }

    protected static void drawIndivGridline(Perspective p, IdentObj idModel, IBlackBox bbGrid, IdentObj idGrid, int nFace, int nAxis, int nUniqueInteger, Point pt0, Point pt1, double fLineWidth) {
        IdentObj newID = new IdentObj(idGrid.getObjectID(), idModel.getSeriesID(), idModel.getGroupID());
        newID = newID.incrementMisc(nAxis * 100000000 + nFace * 1000000 + idModel.getObjectID() * 1000 + nUniqueInteger);
        Java2DLine line2D = new Java2DLine(p);
        IdentObj idUntouched = new IdentObj(idGrid.getObjectID(), idModel.getSeriesID(), idModel.getGroupID());
        line2D.createLine(idUntouched, newID, pt0.x, pt0.y, pt1.x, pt1.y, bbGrid, null, fLineWidth);
    }

    protected void displayTopBottomGridFace(IBlackBox bbGrid, IdentObj idGrid, int nAxis, int nFace, double fLineWidth, int nUniqueIdentifier) {
        Perspective persp = this.m_chart.getPerspective();
        IBlackBox bbModel = this.m_bb == null ? this.m_chart.getModelBlackBox(this.m_id) : this.m_bb;
        if (bbModel.getTransparentBorderColor()) {
            switch (nAxis) {
                case 1: {
                    Polygon poly = this.projectVertices(nFace);
                    Point pt0 = new Point(poly.xpoints[0], poly.ypoints[0]);
                    Point pt1 = new Point(poly.xpoints[1], poly.ypoints[1]);
                    Model3DFlatFace.drawIndivGridline(persp, this.m_id, bbGrid, idGrid, nFace, nAxis, nUniqueIdentifier, pt0, pt1, fLineWidth);
                    pt0 = new Point(poly.xpoints[2], poly.ypoints[2]);
                    pt1 = new Point(poly.xpoints[3], poly.ypoints[3]);
                    Model3DFlatFace.drawIndivGridline(persp, this.m_id, bbGrid, idGrid, nFace, nAxis, ++nUniqueIdentifier, pt0, pt1, fLineWidth);
                }
            }
        }
    }

    @Override
    public double getDistance() {
        return this.m_distance;
    }

    public int[] getFace(int iFace) {
        return this.m_faces[iFace];
    }

    public Point3d getFaceNormal(int f) {
        this.transformVertices();
        if (this.m_vNormal[f] != null) {
            return new Point3d(this.m_vNormal[f]);
        }
        Point3d normalVector = null;
        boolean bNotColinear = false;
        Point3d delta1 = null;
        Point3d delta2 = null;
        Point3d vertex = null;
        Point3d lastVertex = null;
        int[] face = this.getFace(f);
        int v0 = face[0];
        lastVertex = new Point3d(this.m_xVertices[v0]);
        for (int i = 1; i < face.length; ++i) {
            int vi = face[i];
            vertex = this.m_xVertices[vi];
            if (delta1 == null) {
                if (!vertex.equals(lastVertex)) {
                    delta1 = new Point3d(vertex).minus(lastVertex);
                    continue;
                }
            } else if (!vertex.equals(lastVertex)) {
                delta2 = new Point3d(vertex).minus(lastVertex);
                double nx = delta1.y * delta2.z - delta1.z * delta2.y;
                double ny = delta1.z * delta2.x - delta1.x * delta2.z;
                double nz = delta1.x * delta2.y - delta1.y * delta2.x;
                boolean bl = bNotColinear = FP.nonzero(nx) || FP.nonzero(ny) || FP.nonzero(nz);
                if (bNotColinear) {
                    normalVector = new Point3d(nx, ny, nz);
                    break;
                }
            }
            lastVertex = vertex;
        }
        this.m_vNormal[f] = normalVector;
        return normalVector == null ? null : new Point3d(normalVector);
    }

    public IdentObj getID() {
        return this.m_id;
    }

    public IdentObj getIDColor() {
        IdentObj idColor = this.m_id.getSeriesID() != -3 ? new IdentObj(-3, this.m_id.getSeriesID()) : this.m_id;
        return idColor;
    }

    public int getNumFaces() {
        return this.m_nFaces;
    }

    public boolean isVisibleIpsoFacto(int f) {
        throw new RuntimeException("Simple visiblity is available only for rectangular solids");
    }

    public List<Point> projectGrids(boolean bMajor, int nAxis, int f) {
        ArrayList<Point> pts = new ArrayList<Point>();
        if (this.m_GridLines[bMajor ? 1 : 0][nAxis][f] == null) {
            return null;
        }
        List<Point3d> values = this.m_GridLines[bMajor ? 1 : 0][nAxis][f];
        for (Point3d point3d : values) {
            pts.add(this.m_chart.projectPoint3d(point3d));
        }
        return pts;
    }

    public void projectVertices() {
        if (this.m_bIsProjected) {
            return;
        }
        this.transformVertices();
        for (int i = 0; i < this.m_nVertices; ++i) {
            this.m_projVertices[i] = this.m_chart.projectPoint3dInDouble(this.m_xVertices[i]);
        }
        this.m_bIsProjected = true;
    }

    public Polygon projectVertices(int f) {
        Polygon poly = new Polygon();
        int x0 = 0;
        int y0 = 0;
        assert (this.m_bIsProjected);
        for (int iPoint = 0; iPoint < this.m_faces[f].length; ++iPoint) {
            int nPoint = this.m_faces[f][iPoint];
            Point2D pt = this.m_projVertices[nPoint];
            poly.addPoint((int)Math.round(pt.getX()), (int)Math.round(pt.getY()));
            if (iPoint != 0) continue;
            x0 = (int)Math.round(pt.getX());
            y0 = (int)Math.round(pt.getY());
        }
        poly.addPoint(x0, y0);
        return poly;
    }

    public GeneralPath projectVerticesFloat(int f) {
        assert (this.m_bIsProjected);
        assert (this.m_faces[f].length > 2);
        GeneralPath path = new GeneralPath();
        int iPoint = 0;
        int nPoint = this.m_faces[f][iPoint];
        Point2D pt = this.m_projVertices[nPoint];
        path.moveTo((float)pt.getX(), (float)pt.getY());
        for (iPoint = 1; iPoint < this.m_faces[f].length; ++iPoint) {
            nPoint = this.m_faces[f][iPoint];
            pt = this.m_projVertices[nPoint];
            path.lineTo((float)pt.getX(), (float)pt.getY());
        }
        path.closePath();
        return path;
    }

    public void transformGrids() {
        if (this.m_GridLines == null) {
            throw new RuntimeException("Grid line not initialized in 3D Model");
        }
        int nGridType = 1;
        for (int nAxis = 0; nAxis < 3; ++nAxis) {
            for (int nFace = 0; nFace < this.m_nFaces; ++nFace) {
                if (this.m_GridLines[nGridType][nAxis][nFace] == null) continue;
                List<Point3d> values = this.m_GridLines[nGridType][nAxis][nFace];
                for (Point3d point3d : values) {
                    this.m_chart.transformPoint3d(point3d);
                }
            }
        }
    }

    public void transformVertices() {
        if (this.m_bIsTransformed) {
            return;
        }
        for (int i = 0; i < this.m_nVertices; ++i) {
            Point3d p3D_X = new Point3d(this.m_vertices[i]);
            this.m_chart.transformPoint3d(p3D_X);
            this.m_xVertices[i] = p3D_X;
        }
        this.m_bIsTransformed = true;
    }

    public Point3d visibility(int f) {
        Point3d normal = this.getFaceNormal(f);
        int v0 = this.getFace(f)[0];
        boolean bVisible = false;
        if (normal != null) {
            this.m_viewer = this.m_chart.getViewer();
            Point3d toViewer = this.m_viewer.minus(this.m_xVertices[v0]);
            double dotProduct = normal.mult(toViewer);
            bVisible = dotProduct > 0.0;
        }
        return bVisible ? normal : null;
    }

    protected Point3d getGridLineStart(int nAxis, int nFace, double dValue) {
        block7: {
            boolean isLower;
            Point3d p;
            Point3d pLast;
            int[] face;
            block8: {
                block6: {
                    face = this.m_faces[nFace];
                    pLast = this.m_vertices[face[0]];
                    p = null;
                    isLower = false;
                    if (nAxis != 0) break block6;
                    isLower = pLast.x < dValue;
                    for (int nn = 1; nn < face.length; ++nn) {
                        p = this.m_vertices[face[nn]];
                        if (p.x < dValue != isLower) {
                            return Model3DFlatFace.calcIntersection(pLast, p, nAxis, dValue);
                        }
                        pLast = p;
                    }
                    break block7;
                }
                if (nAxis != 1) break block8;
                isLower = pLast.y < dValue;
                for (int nn = 1; nn < face.length; ++nn) {
                    p = this.m_vertices[face[nn]];
                    if (p.y < dValue != isLower) {
                        return Model3DFlatFace.calcIntersection(pLast, p, nAxis, dValue);
                    }
                    pLast = p;
                }
                break block7;
            }
            if (nAxis != 2) break block7;
            isLower = pLast.z < dValue;
            for (int nn = 1; nn < face.length; ++nn) {
                p = this.m_vertices[face[nn]];
                if (p.z < dValue != isLower) {
                    return Model3DFlatFace.calcIntersection(pLast, p, nAxis, dValue);
                }
                pLast = p;
            }
        }
        return null;
    }

    protected Point3d getGridLineEnd(int nAxis, int nFace, double dValue) {
        block7: {
            boolean isLower;
            Point3d p;
            Point3d pLast;
            int[] face;
            block8: {
                block6: {
                    face = this.m_faces[nFace];
                    pLast = this.m_vertices[face[0]];
                    p = null;
                    isLower = false;
                    int nLen = face.length;
                    if (nAxis != 0) break block6;
                    isLower = pLast.x < dValue;
                    for (int nn = nLen - 1; nn > 0; --nn) {
                        p = this.m_vertices[face[nn]];
                        if (p.x < dValue != isLower) {
                            return Model3DFlatFace.calcIntersection(pLast, p, nAxis, dValue);
                        }
                        pLast = p;
                    }
                    break block7;
                }
                if (nAxis != 1) break block8;
                isLower = pLast.y < dValue;
                for (int nn = nLen - 1; nn > 0; --nn) {
                    p = this.m_vertices[face[nn]];
                    if (p.y < dValue != isLower) {
                        return Model3DFlatFace.calcIntersection(pLast, p, nAxis, dValue);
                    }
                    pLast = p;
                }
                break block7;
            }
            if (nAxis != 2) break block7;
            isLower = pLast.z < dValue;
            for (int nn = nLen - 1; nn > 0; --nn) {
                p = this.m_vertices[face[nn]];
                if (p.z < dValue != isLower) {
                    return Model3DFlatFace.calcIntersection(pLast, p, nAxis, dValue);
                }
                pLast = p;
            }
        }
        return null;
    }

    public static Point3d calcIntersection(Point3d p1, Point3d p2, int nAxis, double dValue) {
        double deltaX = p2.x - p1.x;
        double deltaY = p2.y - p1.y;
        double deltaZ = p2.z - p1.z;
        double ratio = 0.0;
        if (nAxis == 0) {
            ratio = (dValue - p1.x) / deltaX;
        } else if (nAxis == 1) {
            ratio = (dValue - p1.y) / deltaY;
        } else if (nAxis == 2) {
            ratio = (dValue - p1.z) / deltaZ;
        }
        double x = nAxis == 0 ? dValue : p1.x + ratio * deltaX;
        double y = nAxis == 1 ? dValue : p1.y + ratio * deltaY;
        double z = nAxis == 2 ? dValue : p1.z + ratio * deltaZ;
        Point3d p = new Point3d(x, y, z);
        return p;
    }
}

