/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.Access;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Gridlines2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MinMaxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Ticks2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IOrdinalAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.RelativeAxisObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Axis2DObj
extends RelativeAxisObj
implements IOrdinalAxis,
IAxis2D {
    static final int MAX_TITLE_SIZE = 1300;
    static final int TITLE_AXISLABEL_DISTANCE = 50;
    static final int LABEL_BOUNDS_MARGIN = 300;
    static final int RIGHT_EDGE = 16000;
    static final int RIGHT_MARGIN = 15900;
    static final int LEFT_EDGE = -16000;
    static final int LEFT_MARGIN = -15900;
    static final int BOTTOM_EDGE = -16000;
    static final int BOTTOM_MARGIN = -15900;
    static final int TOP_EDGE = 16000;
    static final int TOP_MARGIN = 15900;
    boolean m_bVertScale;
    private boolean m_bDisplayOnCalc;
    private int m_axisLengthVC;
    private int m_axisOrgVC;
    private final Point m_frameDepthOffset = this.m_Perspective.getFrameDepthOffset();
    Rectangle m_rFrame;
    Ticks2D m_majorTicks = null;
    Ticks2D m_minorTicks = null;

    Axis2DObj(Perspective perspective, Access access, AxisTemplate id, int nAxisType, boolean bVertical, boolean bAscending) {
        this(perspective, access, id, nAxisType, bVertical, bAscending, 0, 100);
    }

    private Axis2DObj(Perspective perspective, Access access, AxisTemplate id, int nAxisType, boolean bVertical, boolean bAscending, int nAxisOffset, int nAxisSize) {
        super(perspective, access, id, nAxisType, bAscending, nAxisOffset, nAxisSize);
        this.initVariables(bVertical, true);
        this.initAxis();
    }

    Axis2DObj(Perspective perspective, Access access, AxisTemplate id, MinMaxObj minMax, boolean bVertical, boolean bAscending, int nAxisOffset, int nAxisSize, boolean bDrawOnCalc) {
        super(perspective, access, id, minMax, bAscending, nAxisOffset, nAxisSize);
        this.initVariables(bVertical, bDrawOnCalc);
        this.initAxis();
    }

    @Override
    void adjustTitlePosPass1(int nSide, List<Rectangle> rVectLabels, Rectangle rTitle) {
        if (this.m_bVertScale) {
            switch (nSide) {
                case 0: {
                    this.adjustTitleLeftmost(rVectLabels, rTitle);
                    break;
                }
                case 1: 
                case 2: {
                    this.adjustTitleRightmost(rVectLabels, rTitle);
                }
            }
        } else {
            switch (nSide) {
                case 1: 
                case 2: {
                    this.adjustTitleHighest(rVectLabels, rTitle);
                    break;
                }
                case 0: {
                    this.adjustTitleLowest(rVectLabels, rTitle);
                }
            }
        }
    }

    void adjustTitleLowest(List<Rectangle> rVectLabels, Rectangle rTitle) {
        int nYLowest = 16000;
        for (Rectangle rLabel : rVectLabels) {
            nYLowest = Math.min(nYLowest, rLabel.y);
        }
        rTitle.y = nYLowest - rTitle.height - 300;
        if (this.m_Perspective.getTextRotation(this.m_template.getLabel()) == 3) {
            rTitle.y -= 300;
        }
        if (rTitle.y < -16000) {
            rTitle.y = -15900;
        }
    }

    void adjustTitleHighest(List<Rectangle> rVectLabels, Rectangle rTitle) {
        int nYHighest = -16000;
        for (Rectangle rLabel : rVectLabels) {
            nYHighest = Math.max(nYHighest, rLabel.y + rLabel.height);
        }
        rTitle.y = nYHighest + 300;
        if (rTitle.y + rTitle.height > 16000) {
            rTitle.y = 15900 - rTitle.height;
        }
    }

    void adjustTitleLeftmost(List<Rectangle> rVectLabels, Rectangle rTitle) {
        int nXLeftMost = 16000;
        for (Rectangle rLabel : rVectLabels) {
            nXLeftMost = Math.min(nXLeftMost, rLabel.x);
        }
        rTitle.x = nXLeftMost - rTitle.width - 300;
        if (rTitle.x < -16000) {
            rTitle.x = -15900;
        }
    }

    void adjustTitleRightmost(List<Rectangle> rVectLabels, Rectangle rTitle) {
        int nXRightMost = -16000;
        for (Rectangle rLabel : rVectLabels) {
            nXRightMost = Math.max(nXRightMost, rLabel.x + rLabel.width);
        }
        rTitle.x = nXRightMost + 300;
        if (rTitle.x + rTitle.width > 16000) {
            rTitle.x = 15900 - rTitle.width;
        }
    }

    @Override
    void adjustTitlePosPass2(IdentObj id, int nSide, Rectangle rTitle, Dimension dimTitle) {
    }

    @Override
    public void calc() {
        super.calc();
        if (this.isNumericAxis()) {
            IdentObj id;
            boolean bNonZeroBaseline;
            double fBaseline = 0.0;
            if (this.m_Perspective.getDisplay(this.m_template.getZeroLine()) && this.isZeroInRange() && !this.isLogScale() && !this.isDateScale()) {
                this.calcZeroLine();
            }
            if ((bNonZeroBaseline = this.m_Perspective.getNonZeroBaseline(id = this.getAxisIdentObj())) && this.m_gt.isScalingAbs() && !this.m_gt.isBubble() && !this.m_gt.isScatter()) {
                fBaseline = this.m_Perspective.getNonZeroBaselineValue(id);
                if ((this.isLogScale() || this.isDateScale()) && fBaseline < 0.0) {
                    bNonZeroBaseline = false;
                }
                if (bNonZeroBaseline) {
                    this.calcNonZeroLine(id);
                }
            }
        }
    }

    @Override
    public void calcAxisBody() {
        if (this.m_bDisplayOnCalc && (this.m_Perspective.getDepthRadius() == 0 || !this.m_Perspective.getUsePGSDKViewing())) {
            IdentObj idBody = this.m_template.getBody();
            if (!this.m_Perspective.getDisplay(idBody)) {
                return;
            }
            int nSide = this.getAxisSide();
            Rectangle rFrame = new Rectangle(this.m_rFrame.x, this.m_rFrame.y, this.m_rFrame.width, this.m_rFrame.height);
            BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, idBody);
            double fWidth = this.m_Perspective.getLineWidth(idBody);
            Java2DLine line2D = new Java2DLine(this.m_Perspective);
            if (this.m_bVertScale) {
                if (this.m_Perspective.getDepthAngle() < 90) {
                    line2D.createLine(idBody, idBody, rFrame.x - this.m_frameDepthOffset.x, this.m_axisOrgVC - this.m_frameDepthOffset.y, rFrame.x - this.m_frameDepthOffset.x, this.m_axisOrgVC + this.m_axisLengthVC - this.m_frameDepthOffset.y, blackBox, null, fWidth);
                } else {
                    line2D.createLine(idBody, idBody, rFrame.x + rFrame.width, this.m_axisOrgVC, rFrame.x + rFrame.width, this.m_axisOrgVC + this.m_axisLengthVC, blackBox, null, fWidth);
                }
            } else {
                if (nSide == 0 || nSide == 2) {
                    line2D.createLine(idBody, idBody, this.m_axisOrgVC - this.m_frameDepthOffset.x, rFrame.y - this.m_frameDepthOffset.y, this.m_axisOrgVC + this.m_axisLengthVC - this.m_frameDepthOffset.x, rFrame.y - this.m_frameDepthOffset.y, blackBox, null, fWidth);
                }
                if (nSide == 1 || nSide == 2) {
                    line2D.createLine(idBody, idBody, this.m_axisOrgVC, rFrame.y + rFrame.height, this.m_axisOrgVC + this.m_axisLengthVC, rFrame.y + rFrame.height, blackBox, null, fWidth);
                }
            }
        }
    }

    @Override
    void calcMajorGridLine(IdentObj id, double fRelPos, IBlackBox blackBox) {
        this.calcLineOnFrame(this.m_Perspective.getGridStyle(this.m_template.getMajor()), fRelPos, id, blackBox, this.m_Perspective.getLineWidth(this.m_template.getMajor()));
    }

    @Override
    void calcMajorTickLine(double fRelPos) {
        int nPosVC = (int)this.scaleToVC(fRelPos);
        this.m_majorTicks.calc(nPosVC);
    }

    @Override
    void calcMinorGridLine(IdentObj id, double fRelPos, IBlackBox blackBox) {
        boolean isTimeScaleAxis = this.m_Perspective.getUseTimeScaleAxis();
        if (FP.between(fRelPos, 0.0, 1.0) || isTimeScaleAxis) {
            this.calcLineOnFrame(this.m_Perspective.getGridStyle(this.m_template.getMinor()), fRelPos, id, blackBox, this.m_Perspective.getLineWidth(this.m_template.getMinor()));
        }
    }

    @Override
    void calcMinorTickLine(double fRelPos) {
        int nPosVC = (int)this.scaleToVC(fRelPos);
        this.m_minorTicks.calc(nPosVC);
    }

    void calcZeroLine() {
        assert (this.isNumericAxis());
        this.calcLineOnFrame(0, this.getValueRelCoord(0.0), this.m_template.getZeroLine(), new BlackBoxObj(this.m_Perspective, this.m_template.getZeroLine()), this.m_Perspective.getLineWidth(this.m_template.getZeroLine()));
    }

    private void calcNonZeroLine(IdentObj axisID) {
        assert (this.isNumericAxis());
        IdentObj idl = null;
        switch (axisID.getObjectID()) {
            case 2004: {
                idl = Identity.Y1AxisLine;
                break;
            }
            case 2005: {
                idl = Identity.Y2AxisLine;
                break;
            }
            case 2003: {
                idl = Identity.X1AxisLine;
            }
        }
        IdentObj id = new IdentObj(251, idl.getObjectID(), axisID.getObjectID());
        IdentObj idObj = this.m_Perspective.getNonZeroBaseLineZeroLine(axisID);
        if (!this.m_Perspective.getDisplay(idObj) || this.m_gt.isRiserLine()) {
            return;
        }
        double fBaseline = this.m_Perspective.getNonZeroBaselineValue(axisID);
        BlackBoxObj bbo = new BlackBoxObj(this.m_Perspective, idObj);
        bbo.setBorderColor(this.m_Perspective.getFillColor(this.m_Perspective.getNonZeroBaseLineZeroLine(axisID)));
        this.calcLineOnFrame(0, this.getValueRelCoord(fBaseline), id, bbo, this.m_Perspective.getLineWidth(idObj));
    }

    @Override
    public void setDisplayOnCalc(boolean bDisplayOnCalc) {
        this.m_bDisplayOnCalc = bDisplayOnCalc;
    }

    @Override
    boolean doDisplayOnCalc() {
        return this.m_bDisplayOnCalc;
    }

    @Override
    public boolean isVertical() {
        return this.m_bVertScale;
    }

    @Override
    public int getAxisSide() {
        return this.m_Perspective.getAxisSide(this.m_template.getAxis());
    }

    @Override
    boolean isAxisLabelVisible(int nSide) {
        return true;
    }

    @Override
    public double getBaseCoord() {
        assert (this.isNumericAxis());
        return (double)this.m_axisOrgVC + this.getBaseRelCoord() * (double)this.m_axisLengthVC;
    }

    @Override
    public double getCenterCoord(int g) {
        assert (!this.isNumericAxis());
        return (double)this.m_axisOrgVC + this.getCenterRelCoord(g) * (double)this.m_axisLengthVC;
    }

    @Override
    public double getHighCoord(int s, int g) {
        assert (!this.isNumericAxis());
        return (double)this.m_axisOrgVC + this.getHighRelCoord(s, g) * (double)this.m_axisLengthVC;
    }

    @Override
    public int getMinVC() {
        return this.m_axisOrgVC - this.m_frameDepthOffset.x;
    }

    @Override
    public int getMaxVC() {
        return this.m_axisLengthVC + this.getMinVC();
    }

    @Override
    void getLabelAndTitlePos(int nSide, int nNumLabels, List<Rectangle> rVectLabels, List<Double> fVectRelLabelPos, List<Integer> nVectAlign, Rectangle rTitleVC, boolean bLabelRotate, int nAutoSkip, int nLabelBegin, int nSkipFactor, ITextStyle textStyleLabel) {
        Rectangle rSpace = this.getSpaceAvailableForLabel(nSide, this.m_Perspective.getVC());
        boolean bStaggerLabels = this.m_bLabelStagger && nNumLabels > 1;
        boolean bLeftDepthWall = this.m_frameDepthOffset.x >= 0;
        Dimension dimTitleVC = this.calcTitleDimVC(nSide);
        int nTotalSpace = this.m_bVertScale ? dimTitleVC.width : dimTitleVC.height;
        this.calcLabelAlignments(nSide, nNumLabels, textStyleLabel.getRotationSetting(), nVectAlign);
        this.calcLabelPositions(nSide, nNumLabels, fVectRelLabelPos, rSpace, nTotalSpace, bStaggerLabels, 0, rVectLabels);
        this.calcTitleBox(nSide, rSpace, dimTitleVC, bLeftDepthWall, rTitleVC);
    }

    Dimension calcMaxLabelDimensionVC(int nSide, int nNumLabels, int skipCount, boolean bStaggerLabels, List<Double> fVectRelLabelPos, List<Rectangle> rVectLabels) {
        Rectangle rSpace = this.getSpaceAvailableForLabel(nSide, this.m_Perspective.getVC());
        Dimension dimTitleVC = this.calcTitleDimVC(nSide);
        int nTitleSpace = this.m_bVertScale ? dimTitleVC.width : dimTitleVC.height;
        this.calcLabelPositions(nSide, nNumLabels, fVectRelLabelPos, rSpace, nTitleSpace, bStaggerLabels, skipCount, rVectLabels);
        return TextUtil.getLargestLabelVC(rVectLabels);
    }

    void calcLabelPositions(int nSide, int nNumLabels, List<Double> fVectRelLabelPos, Rectangle rSpace, int nTitleSpace, boolean bStaggerLabels, int skipCount, List<Rectangle> rVectLabels) {
        int nMaxLabelDim;
        boolean bLeftDepthWall = this.m_frameDepthOffset.x >= 0;
        boolean bRightDepthWall = this.m_frameDepthOffset.x < 0;
        int[] nLabelPos = new int[nNumLabels];
        for (int i = 0; i < nNumLabels; ++i) {
            double d = fVectRelLabelPos.get(i);
            nLabelPos[i] = (int)this.scaleToVC(d);
            if (this.m_bVertScale) {
                if ((nSide != 0 || !bLeftDepthWall) && (nSide != 1 || !bRightDepthWall)) continue;
                int n = i;
                nLabelPos[n] = nLabelPos[n] - this.m_frameDepthOffset.y;
                continue;
            }
            if (!bLeftDepthWall && !bRightDepthWall || nSide != 0) continue;
            int n = i;
            nLabelPos[n] = nLabelPos[n] - this.m_frameDepthOffset.x;
        }
        if (nNumLabels > 1) {
            double nO1LabelMargin = this.m_Perspective.getO1LabelMargin();
            nMaxLabelDim = Math.abs(nLabelPos[1] - nLabelPos[0]);
            if (bStaggerLabels) {
                nMaxLabelDim *= 2;
            }
            if (skipCount > 0) {
                nMaxLabelDim *= Math.min(skipCount + 1, nNumLabels);
            }
            nMaxLabelDim = (int)((double)nMaxLabelDim * ((100.0 - nO1LabelMargin) / 100.0));
        } else {
            nMaxLabelDim = this.m_bVertScale ? rSpace.height : rSpace.width;
        }
        this.m_maxLabelSize = nMaxLabelDim;
        boolean bFlip = false;
        rVectLabels.clear();
        for (int i = 0; i < nNumLabels; ++i) {
            Rectangle rLabel = new Rectangle(0, 0, 0, 0);
            if (this.m_bVertScale) {
                rLabel.y = nLabelPos[i] - nMaxLabelDim / 2;
                rLabel.height = nMaxLabelDim;
                rLabel.width = rSpace.width - nTitleSpace;
                if (bStaggerLabels) {
                    rLabel.width /= 2;
                    rLabel.x = rSpace.x;
                    if (!bFlip && nSide == 0 || bFlip && nSide == 1) {
                        rLabel.x += rLabel.width;
                    }
                } else {
                    rLabel.x = rSpace.x;
                }
                if (nSide == 0) {
                    rLabel.x += nTitleSpace;
                }
            } else {
                rLabel.x = nLabelPos[i] - nMaxLabelDim / 2;
                rLabel.width = nMaxLabelDim;
                rLabel.height = rSpace.height - nTitleSpace;
                if (bStaggerLabels) {
                    rLabel.height /= 2;
                    rLabel.y = rSpace.y;
                    if (!bFlip && nSide == 0 || bFlip && nSide == 1) {
                        rLabel.y += rLabel.height;
                    }
                } else {
                    rLabel.y = rSpace.y;
                }
                if (nSide == 0) {
                    rLabel.y += nTitleSpace;
                }
            }
            rVectLabels.add(rLabel);
            bFlip = !bFlip;
        }
    }

    private void calcLabelAlignments(int nSide, int nNumLabels, int nRotation, List<Integer> nVectAlign) {
        int nAlign = 3;
        nAlign = nSide == 0 ? (this.m_bVertScale ? (nRotation == 3 ? 11 : 5) : (nRotation == 3 ? 9 : 3)) : (this.m_bVertScale ? (nRotation == 3 ? 12 : 1) : (nRotation == 3 ? 10 : 7));
        for (int i = 0; i < nNumLabels; ++i) {
            nVectAlign.add(i, new Integer(nAlign));
        }
    }

    private Dimension calcTitleDimVC(int nSide) {
        Dimension dimTitleVC = new Dimension(0, 0);
        IdentObj idTitle = this.m_template.getTitle();
        String strTitle = this.m_Perspective.getTextString(idTitle);
        if (strTitle.length() != 0) {
            boolean bTextWrap = this.m_Perspective.getTextWrap(idTitle);
            ITextStyle titleTextStyle = this.getTitleTextStyle(nSide, idTitle);
            double nFontSizeHeightDC = TextUtil.getFontSizeHeightDC(this.m_Perspective, idTitle);
            Dimension dimMaxVC = VC.DEFAULT_RECTANGLE.getSize();
            if (this.m_bVertScale) {
                dimMaxVC.width = 16000;
            } else {
                dimMaxVC.height = 16000;
            }
            Dimension dimMaxDC = this.m_Perspective.getVC().virtToDest(dimMaxVC);
            Dimension dimTitleDC = titleTextStyle.getTextSizeDC(strTitle, nFontSizeHeightDC, dimMaxDC, null, bTextWrap);
            if (this.m_bVertScale) {
                dimTitleDC.setSize(dimTitleDC.height, dimTitleDC.width);
            }
            dimTitleVC = this.m_Perspective.getVC().destToVirt(dimTitleDC);
        }
        return dimTitleVC;
    }

    private void calcTitleBox(int nSide, Rectangle rSpace, Dimension dimTitle, boolean bLeftDepthWall, Rectangle rTitle) {
        if (rTitle != null) {
            if (this.m_bVertScale) {
                int midY = 0;
                midY = this.isNumericAxis() ? (int)(this.getMinCoord() + this.getMaxCoord()) / 2 : this.m_axisOrgVC + this.m_axisLengthVC / 2;
                rTitle.y = Math.max(-15900, midY - dimTitle.height / 2);
                rTitle.height = Math.min(dimTitle.height, 15900 - rTitle.y);
                if (nSide == 0 && bLeftDepthWall) {
                    rTitle.y -= this.m_frameDepthOffset.y;
                }
                rTitle.width = dimTitle.width;
                rTitle.x = nSide == 0 ? rSpace.x : rSpace.x + rSpace.width - dimTitle.width;
            } else {
                int midX = 0;
                midX = this.isNumericAxis() ? (int)(this.getMinCoord() + this.getMaxCoord()) / 2 : this.m_axisOrgVC + this.m_axisLengthVC / 2;
                rTitle.x = Math.max(-15900, midX - dimTitle.width / 2);
                rTitle.width = Math.min(dimTitle.width, 15900 - rTitle.x);
                if (nSide == 0) {
                    rTitle.x -= this.m_frameDepthOffset.x;
                }
                rTitle.height = dimTitle.height;
                rTitle.y = nSide == 0 ? rSpace.y : rSpace.y + rSpace.height - dimTitle.height;
            }
        }
    }

    @Override
    public List<String> getLabels() {
        if (this.isNumericAxis()) {
            return this.getNumericLabels();
        }
        int nNumLabels = this.getNumLabels();
        ArrayList<String> sVectLabels = new ArrayList<String>(nNumLabels);
        if (this.useSeriesLabels()) {
            SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.m_Access);
            while (sEnum.hasNext()) {
                int s = sEnum.next();
                assert (s >= 0 && s < this.m_Access.getNumTotalSeries());
                sVectLabels.add(this.m_Perspective.getSeriesLabel(s).trim());
            }
        } else {
            GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.m_Access);
            while (gEnum.hasNext()) {
                int g = gEnum.next();
                assert (g >= 0 && g < this.m_Access.getNumTotalGroups());
                sVectLabels.add(this.m_Perspective.getGroupLabel(g).trim());
            }
        }
        return sVectLabels;
    }

    @Override
    List<IdentObj> getLabelIdents() {
        ArrayList<IdentObj> idents;
        block6: {
            idents = null;
            if (this.isNumericAxis()) break block6;
            int nNumLabels = this.getNumLabels();
            idents = new ArrayList<IdentObj>(nNumLabels);
            if (this.useSeriesLabels()) {
                SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.m_Access);
                while (sEnum.hasNext()) {
                    int s = sEnum.next();
                    assert (s >= 0 && s < this.m_Access.getNumTotalSeries());
                    idents.add(new IdentObj(-3, s));
                }
            } else {
                GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.m_Access);
                while (gEnum.hasNext()) {
                    int g = gEnum.next();
                    assert (g >= 0 && g < this.m_Access.getNumTotalGroups());
                    idents.add(new IdentObj(-3, -3, g));
                }
            }
        }
        return idents;
    }

    @Override
    public double getLowCoord(int s, int g) {
        assert (!this.isNumericAxis());
        return (double)this.m_axisOrgVC + this.getLowRelCoord(s, g) * (double)this.m_axisLengthVC;
    }

    @Override
    boolean getMajorGridDisplay(AxisTemplate axisID) {
        return this.m_Perspective.getDisplay(axisID.getMajor());
    }

    @Override
    boolean getMinorGridDisplay(AxisTemplate axisID) {
        return this.m_Perspective.getDisplay(axisID.getMinor());
    }

    @Override
    boolean getMajorTickDisplay(AxisTemplate axisID) {
        return this.m_Perspective.getDisplay(axisID.getMajorTick());
    }

    @Override
    boolean getMinorTickDisplay(AxisTemplate axisID) {
        return this.m_Perspective.getDisplay(axisID.getMinorTick());
    }

    public Rectangle getSpaceAvailableForLabel(int nSide, VC vc) {
        Rectangle rTotalSpace = this.getSpaceAvailable(nSide, vc);
        Rectangle rLabelSpace = new Rectangle(rTotalSpace.x, rTotalSpace.y, rTotalSpace.width, rTotalSpace.height);
        return rLabelSpace;
    }

    private Rectangle getSpaceAvailable(int nSide, VC vc) {
        Rectangle rSpace;
        boolean bRightDepthWall;
        Rectangle rFrame = new Rectangle(this.m_rFrame.x, this.m_rFrame.y, this.m_rFrame.width, this.m_rFrame.height);
        Dimension dimVirtBounds = vc.getVirtDimension();
        boolean bLeftDepthWall = this.m_frameDepthOffset.x >= 0;
        boolean bl = bRightDepthWall = this.m_frameDepthOffset.x < 0;
        if (nSide == 0) {
            if (this.m_bVertScale) {
                if (bLeftDepthWall) {
                    rFrame.x -= this.m_frameDepthOffset.x;
                    rFrame.width += this.m_frameDepthOffset.x;
                    rFrame.y -= this.m_frameDepthOffset.y;
                }
                rSpace = new Rectangle(-dimVirtBounds.width / 2, rFrame.y - 100, rFrame.x + dimVirtBounds.width / 2, rFrame.height + 200);
                rSpace.x += 300;
                rSpace.width -= 600;
            } else {
                if (bLeftDepthWall || bRightDepthWall) {
                    rFrame.x -= this.m_frameDepthOffset.x;
                    rFrame.width += this.m_frameDepthOffset.x;
                    rFrame.y -= this.m_frameDepthOffset.y;
                }
                rSpace = new Rectangle(rFrame.x - 100, -dimVirtBounds.height / 2, rFrame.width + 200, dimVirtBounds.height / 2 + rFrame.y);
                rSpace.y += 300;
                rSpace.height -= 600;
            }
        } else if (this.m_bVertScale) {
            if (bRightDepthWall) {
                rFrame.width -= this.m_frameDepthOffset.x;
                rFrame.y -= this.m_frameDepthOffset.y;
            }
            rSpace = new Rectangle(rFrame.x + rFrame.width, rFrame.y - 100, dimVirtBounds.width / 2 - rFrame.x - rFrame.width, rFrame.height + 200);
            rSpace.x += 300;
            rSpace.width -= 600;
        } else {
            rSpace = new Rectangle(rFrame.x - 100, rFrame.y + rFrame.height, rFrame.width + 200, dimVirtBounds.width / 2 - (rFrame.y + rFrame.height));
            rSpace.y += 300;
            rSpace.height -= 600;
        }
        return rSpace;
    }

    @Override
    int getTitleRotation(AxisTemplate template, int nSide) {
        int nRotation = this.m_Perspective.getTextRotation(template.getTitle());
        nRotation = nSide == 0 && this.m_bVertScale ? (this.m_Perspective.getTextRotation(template.getTitle()) == 2 ? 2 : 1) : (nSide == 1 && this.m_bVertScale ? (this.m_Perspective.getTextRotation(template.getTitle()) == 1 ? 1 : 2) : 0);
        return nRotation;
    }

    @Override
    public double getValueCoord(double fValue) {
        assert (this.isNumericAxis());
        return (double)this.m_axisOrgVC + this.getValueRelCoord(fValue) * (double)this.m_axisLengthVC;
    }

    @Override
    public double getValueFromCoord(int nCoord) {
        assert (this.isNumericAxis());
        return this.getValueFromRelCoord(((double)nCoord - (double)this.m_axisOrgVC) / (double)this.m_axisLengthVC);
    }

    @Override
    public int getGroupAboveCoord(int nCoord) {
        assert (!this.isNumericAxis());
        return this.getGroupAboveRelCoord(((double)nCoord - (double)this.m_axisOrgVC) / (double)this.m_axisLengthVC);
    }

    @Override
    public int getGroupBelowCoord(int nCoord) {
        assert (!this.isNumericAxis());
        return this.getGroupBelowRelCoord(((double)nCoord - (double)this.m_axisOrgVC) / (double)this.m_axisLengthVC);
    }

    public void resetFrame(Rectangle frame) {
        this.m_rFrame = frame;
        this.initAxis();
    }

    private void initAxis() {
        if (this.m_bVertScale) {
            this.m_axisLengthVC = this.m_rFrame.height;
            this.m_axisOrgVC = this.m_rFrame.y;
        } else {
            this.m_axisLengthVC = this.m_rFrame.width;
            this.m_axisOrgVC = this.m_rFrame.x;
        }
    }

    private void initVariables(boolean bVertical, boolean bDisplayOnCalc) {
        this.m_bVertScale = bVertical;
        this.m_bLabelStagger = this.m_Perspective.getLabelStagger(this.m_template.getLabel());
        this.m_bDisplayOnCalc = bDisplayOnCalc;
        this.m_majorTicks = new Ticks2D(this.m_Perspective, this, this.m_template.getMajorTick());
        this.m_minorTicks = new Ticks2D(this.m_Perspective, this, this.m_template.getMinorTick());
        this.m_rFrame = this.m_Perspective.getFrameRect(false);
    }

    Rectangle getFrameRect() {
        return this.m_rFrame;
    }

    @Override
    public double scaleToVC(double fRelPos) {
        double fPosVC = (double)this.m_axisOrgVC + fRelPos * (double)this.m_axisLengthVC;
        return fPosVC;
    }

    void calcLineOnFrame(int nStyle, double fRelPos, IdentObj id, IBlackBox blackBox, double fLineWidth) {
        if (this.m_bDisplayOnCalc && !this.m_Perspective.getPDECalc()) {
            int nSide = this.getAxisSide();
            boolean bLeftSide = nSide == 0 || nSide == 2;
            boolean bRightSide = nSide == 1 || nSide == 2;
            boolean isTimeScaleAxis = this.m_Perspective.getUseTimeScaleAxis();
            int nPosVC = (int)fRelPos;
            if (!isTimeScaleAxis || this.m_template.getAxisObjID() != 7) {
                nPosVC = (int)this.scaleToVC(fRelPos);
            }
            int nOffset = 0;
            if (fLineWidth > 1.0 && id.getObjectID() == 251) {
                nOffset = 100;
            }
            Point ptFrameDepthOffset = new Point(this.m_frameDepthOffset);
            if (this.m_bVertScale) {
                Rectangle rFrameVert = new Rectangle(this.m_rFrame.x, this.m_rFrame.y, this.m_rFrame.width, this.m_rFrame.height);
                rFrameVert.y -= 2000;
                rFrameVert.height += 4000;
                Gridlines2D grid2DVert = new Gridlines2D(this.m_Perspective, rFrameVert, ptFrameDepthOffset, nPosVC, nOffset, id, blackBox, fLineWidth);
                switch (nStyle) {
                    case 0: {
                        grid2DVert.calcGridTicksVertNormal();
                        break;
                    }
                    case 1: {
                        grid2DVert.calcGridTicksVertNormalOutside(bLeftSide, bRightSide);
                        break;
                    }
                    case 2: {
                        grid2DVert.calcGridTicksVertInside(bLeftSide, bRightSide);
                        break;
                    }
                    case 3: {
                        grid2DVert.calcGridTicksVertOutside(bLeftSide, bRightSide);
                        break;
                    }
                    case 4: {
                        grid2DVert.calcGridTicksVertSpanning(bLeftSide, bRightSide);
                    }
                }
            } else {
                Rectangle rFrameHoriz = new Rectangle(this.m_rFrame.x, this.m_rFrame.y, this.m_rFrame.width, this.m_rFrame.height);
                rFrameHoriz.x -= 2000;
                rFrameHoriz.width += 4000;
                Gridlines2D grid2DHoriz = new Gridlines2D(this.m_Perspective, rFrameHoriz, ptFrameDepthOffset, nPosVC, nOffset, id, blackBox, fLineWidth);
                switch (nStyle) {
                    case 0: {
                        grid2DHoriz.calcGridTicksHorizNormal();
                        break;
                    }
                    case 1: {
                        grid2DHoriz.calcGridTicksHorizNormalTicks(bLeftSide, bRightSide);
                        break;
                    }
                    case 2: {
                        grid2DHoriz.calcGridTicksHorizInside(bLeftSide, bRightSide);
                        break;
                    }
                    case 3: {
                        grid2DHoriz.calcGridTicksHorizOutside(bLeftSide, bRightSide);
                        break;
                    }
                    case 4: {
                        grid2DHoriz.calcGridTicksHorizSpanning(bLeftSide, bRightSide);
                    }
                }
            }
        }
    }

    @Override
    void calcUserLine(IdentObj lineId) {
        int y2;
        int y1;
        int x2;
        int x1;
        BlackBoxObj bb = new BlackBoxObj(this.m_Perspective, lineId);
        Java2DLine line = new Java2DLine(this.m_Perspective);
        double value = this.m_Perspective.getUserLineValue(lineId);
        if (this.isValueOffscale(value)) {
            return;
        }
        int positionVC = (int)this.getValueCoord(value);
        if (this.m_bVertScale) {
            x1 = this.m_rFrame.x;
            x2 = x1 + this.m_rFrame.width;
            y2 = y1 = positionVC;
        } else {
            x2 = x1 = positionVC;
            y1 = this.m_rFrame.y;
            y2 = y1 + this.m_rFrame.height;
        }
        line.createLine(lineId, lineId, x1, y1, x2, y2, bb, null, this.m_Perspective.getLineWidth(lineId));
    }

    @Override
    void adjustLabelPos(int nSide, List<Rectangle> labelRects) {
        Rectangle label;
        int i;
        int numLabels = labelRects.size();
        if (!this.m_bLabelStagger || numLabels <= 0) {
            return;
        }
        Rectangle baseLineRectangle = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, 0);
        boolean lineOne = true;
        for (i = 0; i < numLabels; ++i) {
            label = labelRects.get(i);
            if (lineOne) {
                baseLineRectangle.width = Math.max(baseLineRectangle.width, label.width);
                baseLineRectangle.height = Math.max(baseLineRectangle.height, label.height);
                baseLineRectangle.x = Math.min(baseLineRectangle.x, label.x);
                baseLineRectangle.y = Math.min(baseLineRectangle.y, label.y);
            }
            lineOne = !lineOne;
        }
        lineOne = true;
        for (i = 0; i < numLabels; ++i) {
            label = labelRects.get(i);
            if (!lineOne) {
                if (this.m_bVertScale) {
                    label.x = nSide == 0 ? baseLineRectangle.x - label.width : baseLineRectangle.x + baseLineRectangle.width;
                } else {
                    label.y = nSide == 0 ? baseLineRectangle.y - label.height : baseLineRectangle.y + baseLineRectangle.height;
                }
            }
            lineOne = !lineOne;
        }
    }

    @Override
    int calcHorizontalTextAlignment(int rotation, int side, boolean isVerticalChart) {
        int align = -1;
        switch (rotation) {
            default: {
                if (side == 0) {
                    align = isVerticalChart ? 2 : 1;
                    break;
                }
                if (side != 1) break;
                align = isVerticalChart ? 0 : 1;
                break;
            }
            case 3: {
                if (side == 0) {
                    align = 2;
                    break;
                }
                if (side != 1) break;
                align = 0;
                break;
            }
            case 1: {
                if (side == 0) {
                    align = isVerticalChart ? 1 : 2;
                    break;
                }
                if (side != 1) break;
                align = isVerticalChart ? 1 : 0;
                break;
            }
            case 2: {
                if (side == 0) {
                    align = isVerticalChart ? 1 : 0;
                    break;
                }
                if (side != 0) break;
                align = isVerticalChart ? 1 : 2;
            }
        }
        return align;
    }

    public Rectangle calcBoundingBox(int side, int numLabels, int rotation, ITextStyle textStyle, List<Rectangle> rVectLabels, List<String> sVectLabels, Dimension dimMaxStartingLabelDC) {
        ArrayList<Integer> rAlign = new ArrayList<Integer>(numLabels);
        this.calcLabelAlignments(side, numLabels, rotation, rAlign);
        this.alignLabelsOneSide(side, numLabels, dimMaxStartingLabelDC, rVectLabels, sVectLabels, rAlign, textStyle);
        return this.m_labelBoundingBoxVC;
    }
}

