/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.common.ChartRenderingStrings;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.MarkerTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextStyleObjFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Standard;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_Base;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JGraphType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.LegendObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MarkerObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisUtils;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceUtilities;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegendMarkersLabels {
    public static final int LEFT_OF_TEXT = 0;
    public static final int RIGHT_OF_TEXT = 1;
    public static final int ABOVE_TEXT = 2;
    public static final int BELOW_TEXT = 3;
    public static final int UNDER_TEXT = 4;
    static final boolean LEFT_TO_RIGHT = false;
    static final boolean RIGHT_TO_LEFT = true;
    public static final int MKR_MARGIN = 200;

    LegendMarkersLabels() {
    }

    static final Rectangle getLabelRect(Perspective p, int index, Dimension dMinSize, Dimension largestLabelVC) {
        Rectangle rCell = new Rectangle(LegendObj.getCellRect(p, index, dMinSize));
        Rectangle rLabel = new Rectangle(rCell);
        switch (LegendMarkersLabels.getMarkerPosition(p)) {
            case 2: {
                rLabel.height /= 2;
                rLabel.width = largestLabelVC.width;
                break;
            }
            case 3: {
                rLabel.height /= 2;
                rLabel.y += rLabel.height;
                rLabel.width = largestLabelVC.width;
                break;
            }
            case 0: {
                int markerWidth = LegendObj.getMarkerSize(p) + LegendObj.getMarkerSpacing(p);
                if (p.getVC().getSquareAspectRatioX() >= 1.0) {
                    markerWidth += 100;
                }
                rLabel.width = largestLabelVC.width;
                rLabel.x = rCell.x + markerWidth;
                rLabel.height = largestLabelVC.height;
                rLabel.y = rCell.y + (rCell.height - largestLabelVC.height);
                break;
            }
            case 1: {
                int markerWidth = LegendObj.getMarkerSize(p);
                rLabel.width -= markerWidth;
                rLabel.height = largestLabelVC.height;
                rLabel.y = rCell.y + (rCell.height - largestLabelVC.height);
                break;
            }
        }
        return rLabel;
    }

    static final int getMarkerPosition(Perspective p) {
        int legendMarkerPosition;
        boolean bi = p.getBiDirectional();
        int adjustedLegendMarkerPosition = legendMarkerPosition = p.getLegendMarkerPosition();
        if (bi) {
            if (legendMarkerPosition == 0) {
                adjustedLegendMarkerPosition = 1;
            }
            if (legendMarkerPosition == 1) {
                adjustedLegendMarkerPosition = 0;
            }
        }
        return adjustedLegendMarkerPosition;
    }

    static final void setLabelAlignment(Perspective p) {
        if (p.getLegendAutomatic()) {
            IdentObj id = Identity.LegendText;
            switch (LegendMarkersLabels.getMarkerPosition(p)) {
                case 2: 
                case 3: 
                case 4: {
                    p.setTextJustHoriz(id, 1);
                    break;
                }
                case 0: {
                    p.setTextJustHoriz(id, 0);
                    break;
                }
                case 1: {
                    p.setTextJustHoriz(id, 2);
                }
            }
        }
    }

    static final Rectangle getMarkerRect(Perspective p, int index, Rectangle rCellSrc) {
        Rectangle rCell = new Rectangle(rCellSrc);
        Rectangle rMarker = new Rectangle(rCell);
        switch (LegendMarkersLabels.getMarkerPosition(p)) {
            case 2: {
                rMarker.height /= 2;
                rMarker.y += rMarker.height;
                break;
            }
            case 3: {
                rMarker.height /= 2;
                break;
            }
            case 0: {
                int markerWidth;
                rMarker.width = markerWidth = LegendObj.getMarkerSize(p);
                break;
            }
            case 1: {
                int markerWidth;
                rMarker.width = markerWidth = LegendObj.getMarkerSize(p);
                rMarker.x = rCell.x + rCell.width - markerWidth;
                break;
            }
        }
        return rMarker;
    }

    static final void draw(Perspective p, Dimension dMinSize) {
        boolean isExtendedLegend = LegendObj.isExtendedLegend(p);
        int nSeriesStart = LegendObj.getSeriesStart(p);
        int maxSeriesRange = LegendObj.getNumCols(p, dMinSize) * LegendObj.getNumRows(p, dMinSize);
        int nSeriesRange = Math.min(LegendObj.getSeriesRange(p), maxSeriesRange);
        LegendMarkersLabels.setLabelAlignment(p);
        IdentObj id = new IdentObj(14);
        BlackBoxObj blackBoxLabel = new BlackBoxObj(p, id);
        int fontSize = TextUtil.getFontSizeHeightVC(p, Identity.LegendText);
        Dimension d = new Dimension(fontSize, fontSize);
        Dimension percentages = LegendMarkersLabels.calcMarkerSizePercent(p, d);
        List<String> vectStrPercentages = null;
        List<String> vectStrValues = null;
        IdentObj idLegendText = new IdentObj(14);
        ITextStyle textStyle = TextStyleObjFactory.newTextStyleObj(p, idLegendText);
        Dimension dimValueCellVC = null;
        Dimension dimPercentageCellVC = null;
        if (isExtendedLegend) {
            vectStrPercentages = LegendObj.calcLegendPercentages(p);
            vectStrValues = LegendObj.calcLegendValues(p);
            dimValueCellVC = LegendMarkersLabels.getCellMaxWidthVC(p, idLegendText, vectStrValues, textStyle);
            dimPercentageCellVC = LegendMarkersLabels.getCellMaxWidthVC(p, idLegendText, vectStrPercentages, textStyle);
        }
        Dimension largestLabelVC = LegendObj.getMaxLegendLabel(p);
        JGraphType gt = p.getJGraphType();
        boolean bottomUpOrder = gt.isStacked() && !gt.getIsNumericScaleAxis();
        int lastLegendItemIndex = nSeriesRange - 1;
        for (int i = nSeriesStart; i < nSeriesRange; ++i) {
            int series = i;
            if (bottomUpOrder) {
                series = nSeriesRange - i - 1;
            }
            idLegendText = idLegendText.changeSeries(series);
            Rectangle rCell = LegendObj.getCellRect(p, i, dMinSize);
            Rectangle rLabel = LegendMarkersLabels.getLabelRect(p, i, dMinSize, largestLabelVC);
            if (isExtendedLegend && i == lastLegendItemIndex) {
                LegendMarkersLabels.drawLabels(p, LegendObj.getSeriesRange(p) - 1, rCell, dMinSize, blackBoxLabel, vectStrPercentages, vectStrValues, rLabel, textStyle, dimValueCellVC, dimPercentageCellVC, idLegendText);
                continue;
            }
            LegendMarkersLabels.drawOneMarker(p, series, rCell, percentages);
            LegendMarkersLabels.drawLabels(p, series, rCell, dMinSize, blackBoxLabel, vectStrPercentages, vectStrValues, rLabel, textStyle, dimValueCellVC, dimPercentageCellVC, idLegendText);
        }
    }

    private static void drawLabels(Perspective p, int i, Rectangle rCell, Dimension dMinSize, BlackBoxObj blackBoxLabel, List<String> m_vectStrPercentages, List<String> m_vectStrValues, Rectangle rLabel, ITextStyle textStyle, Dimension m_dimValueCellVC, Dimension m_dimPercentageCellVC, IdentObj idLegendText) {
        String sLabel = LegendMarkersLabels.getLabel(p, i);
        rLabel.y -= rLabel.height / 10;
        DrawFactory.createLabel(p.getDetectiv(), idLegendText, sLabel, rLabel, textStyle, blackBoxLabel, null);
        if (LegendObj.isExtendedLegend(p) && m_dimValueCellVC != null && m_dimPercentageCellVC != null) {
            int legendLabelType = p.getLegendLabelType();
            String szValue = m_vectStrValues.get(i);
            String szPercentage = m_vectStrPercentages.get(i);
            ITextStyle textStyleR = TextStyleObjFactory.newTextStyleObj(p, idLegendText);
            textStyleR.setHorizAlign(2);
            switch (legendLabelType) {
                case 1: {
                    Rectangle rPercentage = new Rectangle(m_dimPercentageCellVC);
                    rPercentage.y = rLabel.y;
                    rPercentage.x = rLabel.x + rLabel.width + 200;
                    DrawFactory.createLabel(p.getDetectiv(), idLegendText, szPercentage, rPercentage, textStyleR, blackBoxLabel, null);
                    break;
                }
                case 2: {
                    Rectangle rValue = new Rectangle(m_dimValueCellVC);
                    rValue.y = rLabel.y;
                    rValue.x = rLabel.x + rLabel.width + 200;
                    DrawFactory.createLabel(p.getDetectiv(), idLegendText, szValue, rValue, textStyleR, blackBoxLabel, null);
                    break;
                }
                case 3: {
                    Rectangle rValue = new Rectangle(m_dimValueCellVC);
                    rValue.y = rLabel.y;
                    rValue.x = rLabel.x + rLabel.width + 200;
                    Rectangle rPercentage = new Rectangle(m_dimPercentageCellVC);
                    rPercentage.y = rLabel.y;
                    rPercentage.x = rValue.x + rValue.width + 200;
                    DrawFactory.createLabel(p.getDetectiv(), idLegendText, szValue, rValue, textStyleR, blackBoxLabel, null);
                    DrawFactory.createLabel(p.getDetectiv(), idLegendText, szPercentage, rPercentage, textStyleR, blackBoxLabel, null);
                }
            }
        }
    }

    private static Dimension getCellMaxWidthVC(Perspective p, IdentObj id, List<String> vLabels, ITextStyle textStyle) {
        int maxWidth = 0;
        Dimension maxDim = new Dimension(0, 0);
        for (String string : vLabels) {
            Dimension d = PlaceUtilities.getTextDim(p, id, string, textStyle);
            if (d.width <= maxWidth) continue;
            maxWidth = d.width;
            maxDim = new Dimension(d.width, d.height);
        }
        return maxDim;
    }

    private static void drawOneMarker(Perspective p, int i, Rectangle rCell, Dimension percentages) {
        int lineIndex;
        IdentObj idLegendMarker = LegendMarkersLabels.getMarkerId(p, i);
        MarkerTemplate markerTemplate = p.getMarkerTemplate(p.getMarkerShape(p.getSeries(i)));
        IBlackBox blackBox = LegendMarkersLabels.getBlackBox(p, i);
        Rectangle rMarker = LegendMarkersLabels.getMarkerRect(p, i, rCell);
        Point pMarker = new Point(rMarker.x + rMarker.width / 2, rMarker.y + rMarker.height / 2);
        boolean bBeveledLegendMarker = p.getDisplay(Identity.BeveledLegendMarker);
        boolean bUnderText = LegendMarkersLabels.getMarkerPosition(p) == 4;
        int n = lineIndex = p.isColorByGroup() ? 0 : i;
        if (bUnderText) {
            DrawFactory.createRectangle(p.getDetectiv(), idLegendMarker, rMarker.x, rMarker.y, rMarker.width, rMarker.height, blackBox, null);
        } else {
            if (LegendMarkersLabels.shouldDrawLine(p, lineIndex)) {
                LegendMarkersLabels.drawLine(p, lineIndex, rMarker);
            }
            if (LegendMarkersLabels.shouldDrawMarker(p, i)) {
                new MarkerObj(p.getDetectiv(), idLegendMarker, markerTemplate, pMarker, percentages, blackBox, null, true, bBeveledLegendMarker, true);
            }
        }
    }

    private static void drawLine(Perspective p, int i, Rectangle rMarker) {
        IBlackBox lineBBox = p.getGraphObject().assignSeriesColor(i);
        if (lineBBox.getFillColor() != null) {
            lineBBox.setBorderColor(lineBBox.getFillColor());
        }
        if (!lineBBox.getTransparentFillColor()) {
            IdentObj idLegendMarker = LegendMarkersLabels.getMarkerId(p, i);
            int y = rMarker.y + rMarker.height / 2;
            int indent = rMarker.width / 20;
            int x1 = rMarker.x + indent;
            int x2 = rMarker.x + rMarker.width - 2 * indent;
            Java2DLine line2D = new Java2DLine(p);
            line2D.createLine(p.getSeries(i), idLegendMarker, x1, y, x2, y, lineBBox, null, p.getLineWidth(p.getSeries(i)));
        }
    }

    private static boolean shouldDrawLine(Perspective p, int i) {
        return p.getJGraphType().isBLAType() && p.getSeriesType(i) == 2 && p.getConnectLineMarkers(i);
    }

    private static boolean shouldDrawMarker(Perspective p, int i) {
        if (p.getSeriesType(i) != 2) {
            return true;
        }
        if (!(p.getGraphObject() instanceof JChart_2D_Standard)) {
            return true;
        }
        JChart_2D_Standard stdChart = (JChart_2D_Standard)p.getGraphObject();
        return stdChart.hasMarkers() && p.getMarkerDisplay(i);
    }

    private static final Dimension calcMarkerSizePercent(Perspective p, Dimension dimMarker) {
        boolean bUnderText;
        int percentX = 1;
        int percentY = 1;
        Dimension dimDefaultMarker = new Dimension(MarkerTemplate.MARKER_SQUARE.width, MarkerTemplate.MARKER_SQUARE.height);
        double fWidthPercent = dimMarker.width;
        fWidthPercent /= (double)dimDefaultMarker.width;
        percentX = (int)(fWidthPercent *= 100.0);
        double fHeightPercent = dimMarker.height;
        fHeightPercent /= (double)dimDefaultMarker.height;
        percentY = (int)(fHeightPercent *= 100.0);
        if (percentX > 100) {
            percentX = 100;
        } else if (percentX < 1) {
            percentX = 1;
        }
        if (percentY > 100) {
            percentY = 100;
        } else if (percentY < 1) {
            percentY = 1;
        }
        boolean bl = bUnderText = LegendMarkersLabels.getMarkerPosition(p) == 4;
        if (!bUnderText) {
            double fDestY;
            double fDestX = p.getVC().virtToDestWidth((double)percentX);
            if (fDestX > (fDestY = p.getVC().virtToDestHeight((double)percentY))) {
                percentX = (int)((double)percentX * fDestY / fDestX);
            } else {
                percentY = (int)((double)percentY * fDestX / fDestY);
            }
            if (percentX < 1) {
                percentX = 1;
            }
            if (percentY < 1) {
                percentY = 1;
            }
        } else {
            percentX = 100;
            percentY = 100;
        }
        return new Dimension(percentX, percentY);
    }

    public static final int getNumLabels(Perspective p) {
        int numLabels = 0;
        JGraphType graph = p.getJGraphType();
        if (graph.isSurface()) {
            boolean bExactColor = p.getExactColorByHeight();
            INumericAxis axis = (INumericAxis)AxisUtils.getAxisObj(p, 528);
            numLabels = bExactColor ? axis.getNumericLabels().size() : axis.getNumericLabelsAsDouble().size();
        } else {
            numLabels = p.isColorByGroup() ? p.getNumGroups() : p.getNumSeries();
            if (LegendObj.isExtendedLegend(p)) {
                ++numLabels;
            }
        }
        return numLabels;
    }

    public static final String getLabel(Perspective p, int index) {
        String s = "unknown";
        JGraphType graph = p.getJGraphType();
        if (LegendObj.isExtendedLegend(p) && index == LegendMarkersLabels.getNumLabels(p) - 1) {
            return ChartRenderingStrings.getLocalizedString("Label_Total", p.getLocale());
        }
        s = graph.isSurface() ? LegendMarkersLabels.getLabelForValueLegend(p, index) : (p.isColorByGroup() ? p.getGroupLabel(index) : p.getSeriesLabel(index));
        return s;
    }

    public static final String getLabelForValueLegend(Perspective p, int index) {
        String s = "unknown";
        boolean bExactColor = p.getExactColorByHeight();
        INumericAxis axis = (INumericAxis)AxisUtils.getAxisObj(p, 528);
        if (bExactColor) {
            s = axis.getNumericLabels().get(index);
        } else {
            List<Double> axisLabelList = axis.getNumericLabelsAsDouble();
            int numLabels = axisLabelList.size();
            if (index == numLabels - 1) {
                double fPrev = axisLabelList.get(numLabels - 2);
                double fCurr = axisLabelList.get(numLabels - 1);
                double fMid = (fPrev + fCurr) / 2.0;
                s = "> " + fMid;
            } else {
                double fPrev = axisLabelList.get(index);
                double fCurr = axisLabelList.get(index + 1);
                double fMid = (fPrev + fCurr) / 2.0;
                if (index == 0) {
                    s = "< " + fMid;
                } else {
                    double fOldPrev = axisLabelList.get(index - 1);
                    double fOldMid = (fOldPrev + fPrev) / 2.0;
                    s = fOldMid + " - " + fMid;
                }
            }
        }
        return s;
    }

    static final IdentObj getMarkerId(Perspective p, int index) {
        JGraphType graph = p.getJGraphType();
        if (graph.isSurface()) {
            IdentObj id = new IdentObj(18);
            return id.changeMisc(index);
        }
        if (p.isColorByGroup()) {
            return new IdentObj(13, 0, index);
        }
        return new IdentObj(13, index);
    }

    static final IBlackBox getBlackBox(Perspective p, int index) {
        IBlackBox bb = null;
        JGraphType graph = p.getJGraphType();
        if (graph.isSurface()) {
            JChart_Base chart = p.getGraphObject();
            INumericAxis axis = (INumericAxis)AxisUtils.getAxisObj(p, 528);
            List<Double> vectStrLabels = axis.getNumericLabelsAsDouble();
            Double dLabel = vectStrLabels.get(index);
            double fValue = dLabel;
            double fRatio = axis.getValueRelCoord(fValue);
            IdentObj id = LegendMarkersLabels.getMarkerId(p, index);
            bb = chart.getBlackBox(id, fRatio);
            if (p.getGraphType() == 15) {
                bb.setTransparentBorderColor(true);
            }
        } else {
            bb = p.getGraphObject().assignSeriesColor(index);
            if (p.getBorderType(p.getLegendMarker(index)) != 4) {
                bb.setBorderProperties(p.getLegendMarker(index));
            }
        }
        return bb;
    }

    public static final double getPinPosFromMarker(Perspective p, IdentObj id) {
        int s = id.getSeriesID();
        int nNumLabels = LegendMarkersLabels.getNumLabels(p);
        if (s == -3) {
            s = 0;
        }
        double fInterval = nNumLabels == 1 ? 1.0 : 1.0 / (double)(nNumLabels - 1);
        double fPin = (double)s * fInterval;
        assert (fPin >= 0.0 && fPin <= 1.0);
        return fPin;
    }
}

