/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisDescriptor;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataFormat;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.PerspectiveBase;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataItem;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngineFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_BLA;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Funnel;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Gantt;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Gauge;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Hilo;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Hist;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Pie;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Polar;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Radar;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Scat;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Waterfall;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D_Shape;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D_Surf;
import org.apache.log4j.Logger;

public final class JGraphType {
    private static final Logger LOG = Logger.getLogger((String)"JGraphType");
    private static final IChartEngineFactory JCHART_3D = JChart_3D.engineFactory;
    private static final IChartEngineFactory JCHART_3D_SHAPE = JChart_3D_Shape.engineFactory;
    private static final IChartEngineFactory JCHART_3D_SURFACE = JChart_3D_Surf.engineFactory;
    private static final IChartEngineFactory JCHART_2D_BLA = JChart_2D_BLA.engineFactory;
    private static final IChartEngineFactory JCHART_2D_HILO = JChart_2D_Hilo.engineFactory;
    private static final IChartEngineFactory JCHART_2D_SCAT = JChart_2D_Scat.engineFactory;
    private static final IChartEngineFactory JCHART_2D_HIST = JChart_2D_Hist.engineFactory;
    private static final IChartEngineFactory JCHART_2D_PIE = JChart_2D_Pie.engineFactory;
    private static final IChartEngineFactory JCHART_2D_RADAR = JChart_2D_Radar.engineFactory;
    private static final IChartEngineFactory JCHART_2D_POLAR = JChart_2D_Polar.engineFactory;
    private static final IChartEngineFactory JCHART_2D_GANTT = JChart_2D_Gantt.engineFactory;
    private static final IChartEngineFactory JCHART_2D_FUNNEL = JChart_2D_Funnel.engineFactory;
    private static final IChartEngineFactory JCHART_2D_WATERFALL = JChart_2D_Waterfall.engineFactory;
    private static final IChartEngineFactory JCHART_2D_GAUGE = JChart_2D_Gauge.engineFactory;
    public static final int ORIENT_HORZ = 1;
    public static final int ORIENT_VERT = 2;
    public static final int SINGLE_AXIS = 1;
    public static final int DUALY_AXIS = 2;
    public static final int BIPOLAR_AXIS = 3;
    public static final int RESIZE_X = 0;
    public static final int RESIZE_Y = 1;
    public static final int RISER_UNSPECIFIED = 0;
    public static final int RISER_BAR = 1;
    public static final int RISER_MARKER = 2;
    public static final int RISER_AREA = 3;
    public static final int RISER_3D_BAR = 4;
    public static final int RISER_3D_FLOATING = 5;
    public static final int RISER_3D_CONN_SERIES = 6;
    public static final int RISER_3D_SURFACE = 7;
    public static final int RISER_3D_MARKER = 8;
    public static final int RISER_SLICE = 9;
    public static final int RISER_CELL = 10;
    public static final int RISER_3D_CONN_GROUPS = 11;
    public static final int PARETO_LINE_BAR = 12;
    public static final int THREED_BAR = 0;
    public static final int THREED_PYRAMID = 1;
    public static final int THREED_OCTAGON = 2;
    public static final int THREED_CYLINDER = 3;
    public static final int THREED_CUBE = 4;
    public static final int THREED_DIAMOND = 5;
    public static final int THREED_AREASERIES = 6;
    public static final int THREED_RIBBONSERIES = 7;
    public static final int THREED_CONE = 8;
    public static final int THREED_AREAGROUP = 9;
    public static final int THREED_RIBBONGROUP = 10;
    public static final int THREED_SPHERE = 11;
    public static final int THREED_SURFACE = 12;
    public static final int THREED_SURFACESIDES = 13;
    public static final int THREED_SURFACEHONEYCOMB = 14;
    public static final int THREED_SMOOTH_SURFACE = 15;
    public static final int THREED_SMOOTH_SURFACESIDES = 16;
    public static final int BARVERT_SIDESIDE = 17;
    public static final int BARVERT_STACKED = 18;
    public static final int BARVERT_SIDEDUAL = 19;
    public static final int BARVERT_STACKEDDUAL = 20;
    public static final int BARVERT_SIDEBIPOLAR = 21;
    public static final int BARVERT_STACKEDBIPOLAR = 22;
    public static final int BARVERT_PERCENT = 23;
    public static final int BARHORIZ_SIDESIDE = 24;
    public static final int BARHORIZ_STACKED = 25;
    public static final int BARHORIZ_SIDEDUAL = 26;
    public static final int BARHORIZ_STACKEDDUAL = 27;
    public static final int BARHORIZ_SIDEBIPOLAR = 28;
    public static final int BARHORIZ_STACKEDBIPOLAR = 29;
    public static final int BARHORIZ_PERCENT = 30;
    public static final int AREAVERT_ABS = 31;
    public static final int AREAVERT_STACKED = 32;
    public static final int AREAVERT_ABSBIPOLAR = 33;
    public static final int AREAVERT_STACKEDBIPOLAR = 34;
    public static final int AREAVERT_PERCENT = 35;
    public static final int AREAHORIZ_ABS = 36;
    public static final int AREAHORIZ_STACKED = 37;
    public static final int AREAHORIZ_ABSBIPOLAR = 38;
    public static final int AREAHORIZ_STACKEDBIPOLAR = 39;
    public static final int AREAHORIZ_PERCENT = 40;
    public static final int LINEVERT_ABS = 41;
    public static final int LINEVERT_STACKED = 42;
    public static final int LINEVERT_ABSDUAL = 43;
    public static final int LINEVERT_STACKEDDUAL = 44;
    public static final int LINEVERT_ABSBIPOLAR = 45;
    public static final int LINEVERT_STACKEDBIPOLAR = 46;
    public static final int LINEVERT_PERCENT = 47;
    public static final int LINEHORIZ_ABS = 48;
    public static final int LINEHORIZ_STACKED = 49;
    public static final int LINEHORIZ_ABSDUAL = 50;
    public static final int LINEHORIZ_STACKEDDUAL = 51;
    public static final int LINEHORIZ_ABSBIPOLAR = 52;
    public static final int LINEHORIZ_STACKEDBIPOLAR = 53;
    public static final int LINEHORIZ_PERCENT = 54;
    public static final int PIE = 55;
    public static final int PIE_RING = 56;
    public static final int PIE_MULT = 57;
    public static final int PIE_RINGMULT = 58;
    public static final int PIE_MULTPROP = 59;
    public static final int PIE_RINGMULTPROP = 60;
    public static final int SCATTER = 61;
    public static final int SCATTER_DUAL = 62;
    public static final int SCATTER_LABELS = 63;
    public static final int SCATTER_LABELSDUAL = 64;
    public static final int POLAR = 65;
    public static final int POLAR_DUAL = 66;
    public static final int RADAR_LINE = 67;
    public static final int RADAR_AREA = 68;
    public static final int RADAR_LINE_DUAL = 69;
    public static final int STOCKHILO = 73;
    public static final int STOCKHILO_DUAL = 74;
    public static final int STOCKHILO_BIPOLAR = 75;
    public static final int STOCKHILO_CLOSE = 76;
    public static final int STOCKHILO_CLOSEDUAL = 77;
    public static final int STOCKHILO_CLOSEBIPOLAR = 78;
    public static final int STOCKHILO_OPENCLOSE = 79;
    public static final int STOCKHILO_OPENCLOSEDUAL = 80;
    public static final int STOCKHILO_OPENCLOSEBIPOLAR = 81;
    public static final int STOCKHILO_VOLUME = 82;
    public static final int STOCKHILO_CLOSE_VOLUME = 88;
    public static final int STOCKHILO_OPENCLOSE_VOLUME = 83;
    public static final int STOCKHILO_CANDLE = 70;
    public static final int STOCKHILO_CANDLE_VOLUME = 71;
    public static final int STOCK_CANDLE = 72;
    public static final int STOCK_CANDLE_VOLUME = 84;
    public static final int HIST_VERT = 85;
    public static final int HIST_HORIZ = 86;
    public static final int BUBBLE = 89;
    public static final int BUBBLE_LABELS = 90;
    public static final int BUBBLE_DUAL = 91;
    public static final int BUBBLE_LABELSDUAL = 92;
    public static final int GANTT = 99;
    public static final int WATERFALL_VERT = 100;
    public static final int WATERFALL_HORZ = 101;
    public static final int BARVERT_SIDESIDE_THREEY = 103;
    public static final int BARVERT_SIDESIDE_FOURY = 104;
    public static final int BARVERT_SIDESIDE_FIVEY = 105;
    public static final int FUNNEL_VERT = 106;
    public static final int RESERVED_FOR_FUNNEL_HORZ = 107;
    public static final int TIMEAXIS_VERT = 108;
    public static final int TIMEAXIS_HORZ = 109;
    public static final int GAUGE = 110;
    public static final int BARVERT_STACKED_THREEY = 113;
    public static final int BARVERT_STACKED_FOURY = 114;
    public static final int BARVERT_STACKED_FIVEY = 115;
    public static final int THREED_SMOOTH_CONNECTED_GROUPS = 116;
    public static final int THREED_SMOOTH_CONNECTED_SERIES = 117;
    public static final int THREED_TOPO_SURFACE = 118;
    public static final int THREED_TOPO_SURFACE_SIDES = 119;
    public static final int THREED_TOPO2D = 120;
    public static final int RADAR_STACKED_LINE = 126;
    public static final int RADAR_STACKED_AREA = 127;
    public static final int STOCKHILO_OPEN = 128;
    public static final int STOCKHILO_OPENDUAL = 129;
    public static final int STOCKHILO_OPENBIPOLAR = 130;
    public static final int THREED_CUTCORNER = 131;
    public static final JGraphType JGT_THREED_BAR = new JGraphType(0, "THREED_BAR", JCHART_3D, 4, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_PYRAMID = new JGraphType(1, "THREED_PYRAMID", JCHART_3D, 4, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_OCTAGON = new JGraphType(2, "THREED_OCTAGON", JCHART_3D, 4, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_CUTCORNER = new JGraphType(131, "THREED_CUTCORNER", JCHART_3D, 4, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_CUBE = new JGraphType(4, "THREED_CUBE", JCHART_3D, 5, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_DIAMOND = new JGraphType(5, "THREED_DIAMOND", JCHART_3D, 5, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_AREASERIES = new JGraphType(6, "THREED_AREASERIES", JCHART_3D, 6, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_RIBBONSERIES = new JGraphType(7, "THREED_RIBBONSERIES", JCHART_3D, 6, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_AREAGROUP = new JGraphType(9, "THREED_AREAGROUP", JCHART_3D, 11, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_RIBBONGROUP = new JGraphType(10, "THREED_RIBBONGROUP", JCHART_3D, 11, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_SURFACE = new JGraphType(12, "THREED_SURFACE", JCHART_3D_SURFACE, 7, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_SURFACESIDES = new JGraphType(13, "THREED_SURFACESIDES", JCHART_3D_SURFACE, 7, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_SURFACEHONEYCOMB = new JGraphType(14, "THREED_SURFACEHONEYCOMB", JCHART_3D_SURFACE, 7, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_CONE = new JGraphType(8, "THREED_CONE", JCHART_3D_SHAPE, 4, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_CYLINDER = new JGraphType(3, "THREED_CYLINDER", JCHART_3D_SHAPE, 4, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_SPHERE = new JGraphType(11, "THREED_SPHERE", JCHART_3D_SHAPE, 5, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_BARVERT_SIDESIDE = new JGraphType(17, "BARVERT_SIDESIDE", JCHART_2D_BLA, 1, false, false, 2, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BARVERT_STACKED = new JGraphType(18, "BARVERT_STACKED", JCHART_2D_BLA, 1, false, false, 2, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BARVERT_SIDEDUAL = new JGraphType(19, "BARVERT_SIDEDUAL", JCHART_2D_BLA, 1, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARVERT_STACKEDDUAL = new JGraphType(20, "BARVERT_STACKEDDUAL", JCHART_2D_BLA, 1, true, false, 2, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARVERT_SIDEBIPOLAR = new JGraphType(21, "BARVERT_SIDEBIPOLAR", JCHART_2D_BLA, 1, true, true, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARVERT_STACKEDBIPOLAR = new JGraphType(22, "BARVERT_STACKEDBIPOLAR", JCHART_2D_BLA, 1, true, true, 2, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARVERT_PERCENT = new JGraphType(23, "BARVERT_PERCENT", JCHART_2D_BLA, 1, false, false, 2, 3, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BARHORIZ_SIDESIDE = new JGraphType(24, "BARHORIZ_SIDESIDE", JCHART_2D_BLA, 1, false, false, 1, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BARHORIZ_STACKED = new JGraphType(25, "BARHORIZ_STACKED", JCHART_2D_BLA, 1, false, false, 1, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BARHORIZ_SIDEDUAL = new JGraphType(26, "BARHORIZ_SIDEDUAL", JCHART_2D_BLA, 1, true, false, 1, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARHORIZ_STACKEDDUAL = new JGraphType(27, "BARHORIZ_STACKEDDUAL", JCHART_2D_BLA, 1, true, false, 1, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARHORIZ_SIDEBIPOLAR = new JGraphType(28, "BARHORIZ_SIDEBIPOLAR", JCHART_2D_BLA, 1, true, true, 1, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARHORIZ_STACKEDBIPOLAR = new JGraphType(29, "BARHORIZ_STACKEDBIPOLAR", JCHART_2D_BLA, 1, true, true, 1, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARHORIZ_PERCENT = new JGraphType(30, "BARHORIZ_PERCENT", JCHART_2D_BLA, 1, false, false, 1, 3, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_AREAVERT_ABS = new JGraphType(31, "AREAVERT_ABS", JCHART_2D_BLA, 3, false, false, 2, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_AREAVERT_STACKED = new JGraphType(32, "AREAVERT_STACKED", JCHART_2D_BLA, 3, false, false, 2, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_AREAVERT_ABSBIPOLAR = new JGraphType(33, "AREAVERT_ABSBIPOLAR", JCHART_2D_BLA, 3, true, true, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_AREAVERT_STACKEDBIPOLAR = new JGraphType(34, "AREAVERT_STACKEDBIPOLAR", JCHART_2D_BLA, 3, true, true, 2, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_AREAVERT_PERCENT = new JGraphType(35, "AREAVERT_PERCENT", JCHART_2D_BLA, 3, false, false, 2, 3, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_AREAHORIZ_ABS = new JGraphType(36, "AREAHORIZ_ABS", JCHART_2D_BLA, 3, false, false, 1, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_AREAHORIZ_STACKED = new JGraphType(37, "AREAHORIZ_STACKED", JCHART_2D_BLA, 3, false, false, 1, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_AREAHORIZ_ABSBIPOLAR = new JGraphType(38, "AREAHORIZ_ABSBIPOLAR", JCHART_2D_BLA, 3, true, true, 1, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_AREAHORIZ_STACKEDBIPOLAR = new JGraphType(39, "AREAHORIZ_STACKEDBIPOLAR", JCHART_2D_BLA, 3, true, true, 1, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_AREAHORIZ_PERCENT = new JGraphType(40, "AREAHORIZ_PERCENT", JCHART_2D_BLA, 3, false, false, 1, 3, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_LINEVERT_ABS = new JGraphType(41, "LINEVERT_ABS", JCHART_2D_BLA, 2, false, false, 2, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_LINEVERT_STACKED = new JGraphType(42, "LINEVERT_STACKED", JCHART_2D_BLA, 2, false, false, 2, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_LINEVERT_ABSDUAL = new JGraphType(43, "LINEVERT_ABSDUAL", JCHART_2D_BLA, 2, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEVERT_STACKEDDUAL = new JGraphType(44, "LINEVERT_STACKEDDUAL", JCHART_2D_BLA, 2, true, false, 2, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEVERT_ABSBIPOLAR = new JGraphType(45, "LINEVERT_ABSBIPOLAR", JCHART_2D_BLA, 2, true, true, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEVERT_STACKEDBIPOLAR = new JGraphType(46, "LINEVERT_STACKEDBIPOLAR", JCHART_2D_BLA, 2, true, true, 2, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEVERT_PERCENT = new JGraphType(47, "LINEVERT_PERCENT", JCHART_2D_BLA, 2, false, false, 2, 3, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_LINEHORIZ_ABS = new JGraphType(48, "LINEHORIZ_ABS", JCHART_2D_BLA, 2, false, false, 1, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_LINEHORIZ_STACKED = new JGraphType(49, "LINEHORIZ_STACKED", JCHART_2D_BLA, 2, false, false, 1, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_LINEHORIZ_ABSDUAL = new JGraphType(50, "LINEHORIZ_ABSDUAL", JCHART_2D_BLA, 2, true, false, 1, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEHORIZ_STACKEDDUAL = new JGraphType(51, "LINEHORIZ_STACKEDDUAL", JCHART_2D_BLA, 2, true, false, 1, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEHORIZ_ABSBIPOLAR = new JGraphType(52, "LINEHORIZ_ABSBIPOLAR", JCHART_2D_BLA, 2, true, true, 1, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEHORIZ_STACKEDBIPOLAR = new JGraphType(53, "LINEHORIZ_STACKEDBIPOLAR", JCHART_2D_BLA, 2, true, true, 1, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEHORIZ_PERCENT = new JGraphType(54, "LINEHORIZ_PERCENT", JCHART_2D_BLA, 2, false, false, 1, 3, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_PIE = new JGraphType(55, "PIE", JCHART_2D_PIE, 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_PIE_RING = new JGraphType(56, "PIE_RING", JCHART_2D_PIE, 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_PIE_MULT = new JGraphType(57, "PIE_MULT", JCHART_2D_PIE, 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_PIE_RINGMULT = new JGraphType(58, "PIE_RINGMULT", JCHART_2D_PIE, 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_PIE_MULTPROP = new JGraphType(59, "PIE_MULTPROP", JCHART_2D_PIE, 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_PIE_RINGMULTPROP = new JGraphType(60, "PIE_RINGMULTPROP", JCHART_2D_PIE, 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_SCATTER = new JGraphType(61, "SCATTER", JCHART_2D_SCAT, DataFormat.DF_XY, 2, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_SCATTER_DUAL = new JGraphType(62, "SCATTER_DUAL", JCHART_2D_SCAT, DataFormat.DF_XY, 2, true, false, 2, 1, AxisDescriptor.AD_XY_DY);
    public static final JGraphType JGT_SCATTER_LABELS = new JGraphType(63, "SCATTER_LABELS", JCHART_2D_SCAT, DataFormat.DF_XY_LBL, 2, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_SCATTER_LABELSDUAL = new JGraphType(64, "SCATTER_LABELSDUAL", JCHART_2D_SCAT, DataFormat.DF_XY_LBL, 2, true, false, 2, 1, AxisDescriptor.AD_XY_DY);
    public static final JGraphType JGT_POLAR = new JGraphType(65, "POLAR", JCHART_2D_POLAR, DataFormat.DF_XY, 2, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_POLAR_DUAL = new JGraphType(66, "POLAR_DUAL", JCHART_2D_POLAR, DataFormat.DF_XY, 2, true, false, 2, 1, AxisDescriptor.AD_XY_DY);
    public static final JGraphType JGT_RADAR_LINE = new JGraphType(67, "RADAR_LINE", JCHART_2D_RADAR, 2, false, false, 2, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_RADAR_STACKED_LINE = new JGraphType(126, "RADAR_STACKED_LINE", JCHART_2D_RADAR, 2, false, false, 2, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_RADAR_AREA = new JGraphType(68, "RADAR_AREA", JCHART_2D_RADAR, 3, false, false, 2, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_RADAR_STACKED_AREA = new JGraphType(127, "RADAR_STACKED_AREA", JCHART_2D_RADAR, 3, false, false, 2, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_RADAR_LINE_DUAL = new JGraphType(69, "RADAR_LINE_DUAL", JCHART_2D_RADAR, 2, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_GANTT = new JGraphType(99, "GANTT", JCHART_2D_GANTT, DataFormat.DF_GANTT, 2, false, false, 1, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCKHILO = new JGraphType(73, "STOCKHILO", JCHART_2D_HILO, DataFormat.DF_HL, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCKHILO_DUAL = new JGraphType(74, "STOCKHILO_DUAL", JCHART_2D_HILO, DataFormat.DF_HL, 1, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_BIPOLAR = new JGraphType(75, "STOCKHILO_BIPOLAR", JCHART_2D_HILO, DataFormat.DF_HL, 1, true, true, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_CLOSE = new JGraphType(76, "STOCKHILO_CLOSE", JCHART_2D_HILO, DataFormat.DF_HLC, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCKHILO_CLOSEDUAL = new JGraphType(77, "STOCKHILO_CLOSEDUAL", JCHART_2D_HILO, DataFormat.DF_HLC, 1, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_CLOSEBIPOLAR = new JGraphType(78, "STOCKHILO_CLOSEBIPOLAR", JCHART_2D_HILO, DataFormat.DF_HLC, 1, true, true, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_OPENCLOSE = new JGraphType(79, "STOCKHILO_OPENCLOSE", JCHART_2D_HILO, DataFormat.DF_OHLC, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCKHILO_OPENCLOSEDUAL = new JGraphType(80, "STOCKHILO_OPENCLOSEDUAL", JCHART_2D_HILO, DataFormat.DF_OHLC, 1, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_OPENCLOSEBIPOLAR = new JGraphType(81, "STOCKHILO_OPENCLOSEBIPOLAR", JCHART_2D_HILO, DataFormat.DF_OHLC, 1, true, true, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_OPEN = new JGraphType(128, "STOCKHILO_OPEN", JCHART_2D_HILO, DataFormat.DF_HLO, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCKHILO_OPENDUAL = new JGraphType(129, "STOCKHILO_OPENDUAL", JCHART_2D_HILO, DataFormat.DF_HLO, 1, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_OPENBIPOLAR = new JGraphType(130, "STOCKHILO_OPENBIPOLAR", JCHART_2D_HILO, DataFormat.DF_HLO, 1, true, true, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_VOLUME = new JGraphType(82, "STOCKHILO_VOLUME", JCHART_2D_HILO, DataFormat.DF_HL_VOL, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_CLOSE_VOLUME = new JGraphType(88, "STOCKHILO_CLOSE_VOLUME", JCHART_2D_HILO, DataFormat.DF_HLC_VOL, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_OPENCLOSE_VOLUME = new JGraphType(83, "STOCKHILO_OPENCLOSE_VOLUME", JCHART_2D_HILO, DataFormat.DF_OHLC_VOL, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_CANDLE = new JGraphType(70, "STOCKHILO_CANDLE", JCHART_2D_HILO, DataFormat.DF_OHLC, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCKHILO_CANDLE_VOLUME = new JGraphType(71, "STOCKHILO_CANDLE_VOLUME", JCHART_2D_HILO, DataFormat.DF_OHLC_VOL, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCK_CANDLE = new JGraphType(72, "STOCK_CANDLE", JCHART_2D_HILO, DataFormat.DF_OC, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCK_CANDLE_VOLUME = new JGraphType(84, "STOCK_CANDLE_VOLUME", JCHART_2D_HILO, DataFormat.DF_OC_VOL, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_HIST_VERT = new JGraphType(85, "HIST_VERT", JCHART_2D_HIST, 1, false, false, 2, 4, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_HIST_HORIZ = new JGraphType(86, "HIST_HORIZ", JCHART_2D_HIST, 1, false, false, 1, 4, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_BUBBLE = new JGraphType(89, "BUBBLE", JCHART_2D_SCAT, DataFormat.DF_XYZ, 2, AxisDescriptor.AD_XYZ);
    public static final JGraphType JGT_BUBBLE_LABELS = new JGraphType(90, "BUBBLE_LABELS", JCHART_2D_SCAT, DataFormat.DF_XYZ_LBL, 2, AxisDescriptor.AD_XYZ);
    public static final JGraphType JGT_BUBBLE_DUAL = new JGraphType(91, "BUBBLE_DUAL", JCHART_2D_SCAT, DataFormat.DF_XYZ, 2, true, false, 2, 1, AxisDescriptor.AD_XYZ_DY);
    public static final JGraphType JGT_BUBBLE_LABELSDUAL = new JGraphType(92, "BUBBLE_LABELSDUAL", JCHART_2D_SCAT, DataFormat.DF_XYZ_LBL, 2, true, false, 2, 1, AxisDescriptor.AD_XYZ_DY);
    public static final JGraphType JGT_WATERFALL_VERT = new JGraphType(100, "WATERFALL_VERT", JCHART_2D_WATERFALL, DataFormat.DF_GENERAL, 1, false, false, 2, 5, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_WATERFALL_HORZ = new JGraphType(101, "WATERFALL_HORZ", JCHART_2D_WATERFALL, DataFormat.DF_GENERAL, 1, false, false, 1, 5, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BARVERT_SIDESIDE_THREEY = new JGraphType(103, "BARVERT_SIDESIDE_THREEY", JCHART_2D_BLA, 1, false, false, 2, 1, AxisDescriptor.AD_STD_THREEY);
    public static final JGraphType JGT_BARVERT_SIDESIDE_FOURY = new JGraphType(104, "BARVERT_SIDESIDE_FOURY", JCHART_2D_BLA, 1, false, false, 2, 1, AxisDescriptor.AD_STD_FOURY);
    public static final JGraphType JGT_BARVERT_SIDESIDE_FIVEY = new JGraphType(105, "BARVERT_SIDESIDE_FIVEY", JCHART_2D_BLA, 1, false, false, 2, 1, AxisDescriptor.AD_STD_FIVEY);
    public static final JGraphType JGT_FUNNEL_VERT = new JGraphType(106, "FUNNEL_VERT", JCHART_2D_FUNNEL, 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_GAUGE = new JGraphType(110, "GAUGE", JCHART_2D_GAUGE, DataFormat.DF_GENERAL, 2, AxisDescriptor.AD_GAUGE);
    public static final JGraphType JGT_BARVERT_STACKED_THREEY = new JGraphType(113, "JGT_BARVERT_STACKED_THREEY", JCHART_2D_BLA, 1, false, false, 2, 2, AxisDescriptor.AD_STD_THREEY);
    public static final JGraphType JGT_BARVERT_STACKED_FOURY = new JGraphType(114, "JGT_BARVERT_STACKED_FOURY", JCHART_2D_BLA, 1, false, false, 2, 2, AxisDescriptor.AD_STD_FOURY);
    public static final JGraphType JGT_BARVERT_STACKED_FIVEY = new JGraphType(115, "JGT_BARVERT_STACKED_FIVEY", JCHART_2D_BLA, 1, false, false, 2, 2, AxisDescriptor.AD_STD_FIVEY);
    private final int m_id;
    private final String m_name;
    private final IChartEngineFactory chartFactory;
    private final DataFormat m_dataformat;
    private final int m_riserType;
    private final boolean m_bDualY;
    private final boolean m_bBipolar;
    private final int m_orientation;
    private final int m_scalingMethod;
    private final AxisDescriptor m_axisDescriptor;
    private boolean isTimeScaleAxis = false;
    private boolean isNumericScaleAxis = false;

    private JGraphType(int id, String name, IChartEngineFactory factory, int riserType, AxisDescriptor axisDescriptor) {
        this(id, name, factory, DataFormat.DF_GENERAL, riserType, false, false, 2, 1, axisDescriptor);
    }

    private JGraphType(int id, String name, IChartEngineFactory factory, int riserType, boolean bDualY, boolean bBipolar, int orientation, int scalingMethod, AxisDescriptor axisDescriptor) {
        this(id, name, factory, DataFormat.DF_GENERAL, riserType, bDualY, bBipolar, orientation, scalingMethod, axisDescriptor);
    }

    private JGraphType(int id, String name, IChartEngineFactory factory, DataFormat df, int riserType, AxisDescriptor axisDescriptor) {
        this(id, name, factory, df, riserType, false, false, 2, 1, axisDescriptor);
    }

    private JGraphType(int id, String name, IChartEngineFactory factory, DataFormat df, int riserType, boolean bDualY, boolean bBipolar, int orientation, int scalingMethod, AxisDescriptor axisDescriptor) {
        this.m_id = id;
        this.m_name = name;
        this.chartFactory = factory;
        this.m_dataformat = df;
        this.m_riserType = riserType;
        this.m_bDualY = bDualY;
        this.m_bBipolar = bBipolar;
        this.m_orientation = orientation;
        this.m_scalingMethod = scalingMethod;
        if (bDualY && !axisDescriptor.hasY2()) {
            LOG.warn((Object)(">>> DY problem: name = " + name));
        }
        this.m_axisDescriptor = axisDescriptor;
    }

    public boolean getIsNumericScaleAxis() {
        return this.isNumericScaleAxis;
    }

    public void setIsNumericScaleAxis(boolean isNumericScaleAxis) {
        this.isNumericScaleAxis = isNumericScaleAxis;
    }

    public void setIsTimeScaleAxis(boolean isTimeScaleAxis) {
        this.isTimeScaleAxis = isTimeScaleAxis;
    }

    public int hashCode() {
        return this.m_id;
    }

    public boolean equals(int id) {
        return id == this.m_id;
    }

    public boolean equals(Object x) {
        if (!(x instanceof JGraphType)) {
            return false;
        }
        JGraphType xJGraphType = (JGraphType)x;
        return this.m_id == xJGraphType.m_id;
    }

    public AxisDescriptor getAxisDescriptor() {
        return this.m_axisDescriptor;
    }

    public IChartEngineFactory getChartFactory() {
        return this.chartFactory;
    }

    public String getChartName() {
        return this.m_name;
    }

    public DataFormat getDataFormat() {
        if (this.isTimeScaleAxis && !this.isGanttType() || this.isBLAType() && this.isNumericScaleAxis) {
            return DataFormat.DF_XY;
        }
        return this.m_dataformat;
    }

    public int getIntegerGraphType() {
        return this.m_id;
    }

    public static JGraphType getJGraphType(int IntegerGraphType) {
        JGraphType gt = null;
        switch (IntegerGraphType) {
            case 0: {
                gt = JGT_THREED_BAR;
                break;
            }
            case 1: {
                gt = JGT_THREED_PYRAMID;
                break;
            }
            case 2: {
                gt = JGT_THREED_OCTAGON;
                break;
            }
            case 131: {
                gt = JGT_THREED_CUTCORNER;
                break;
            }
            case 4: {
                gt = JGT_THREED_CUBE;
                break;
            }
            case 5: {
                gt = JGT_THREED_DIAMOND;
                break;
            }
            case 6: {
                gt = JGT_THREED_AREASERIES;
                break;
            }
            case 7: {
                gt = JGT_THREED_RIBBONSERIES;
                break;
            }
            case 9: {
                gt = JGT_THREED_AREAGROUP;
                break;
            }
            case 10: {
                gt = JGT_THREED_RIBBONGROUP;
                break;
            }
            case 12: {
                gt = JGT_THREED_SURFACE;
                break;
            }
            case 13: {
                gt = JGT_THREED_SURFACESIDES;
                break;
            }
            case 14: {
                gt = JGT_THREED_SURFACEHONEYCOMB;
                break;
            }
            case 8: {
                gt = JGT_THREED_CONE;
                break;
            }
            case 3: {
                gt = JGT_THREED_CYLINDER;
                break;
            }
            case 11: {
                gt = JGT_THREED_SPHERE;
                break;
            }
            case 17: {
                gt = JGT_BARVERT_SIDESIDE;
                break;
            }
            case 18: {
                gt = JGT_BARVERT_STACKED;
                break;
            }
            case 19: {
                gt = JGT_BARVERT_SIDEDUAL;
                break;
            }
            case 20: {
                gt = JGT_BARVERT_STACKEDDUAL;
                break;
            }
            case 21: {
                gt = JGT_BARVERT_SIDEBIPOLAR;
                break;
            }
            case 22: {
                gt = JGT_BARVERT_STACKEDBIPOLAR;
                break;
            }
            case 23: {
                gt = JGT_BARVERT_PERCENT;
                break;
            }
            case 24: {
                gt = JGT_BARHORIZ_SIDESIDE;
                break;
            }
            case 25: {
                gt = JGT_BARHORIZ_STACKED;
                break;
            }
            case 26: {
                gt = JGT_BARHORIZ_SIDEDUAL;
                break;
            }
            case 27: {
                gt = JGT_BARHORIZ_STACKEDDUAL;
                break;
            }
            case 28: {
                gt = JGT_BARHORIZ_SIDEBIPOLAR;
                break;
            }
            case 29: {
                gt = JGT_BARHORIZ_STACKEDBIPOLAR;
                break;
            }
            case 30: {
                gt = JGT_BARHORIZ_PERCENT;
                break;
            }
            case 31: {
                gt = JGT_AREAVERT_ABS;
                break;
            }
            case 32: {
                gt = JGT_AREAVERT_STACKED;
                break;
            }
            case 33: {
                gt = JGT_AREAVERT_ABSBIPOLAR;
                break;
            }
            case 34: {
                gt = JGT_AREAVERT_STACKEDBIPOLAR;
                break;
            }
            case 35: {
                gt = JGT_AREAVERT_PERCENT;
                break;
            }
            case 36: {
                gt = JGT_AREAHORIZ_ABS;
                break;
            }
            case 37: {
                gt = JGT_AREAHORIZ_STACKED;
                break;
            }
            case 38: {
                gt = JGT_AREAHORIZ_ABSBIPOLAR;
                break;
            }
            case 39: {
                gt = JGT_AREAHORIZ_STACKEDBIPOLAR;
                break;
            }
            case 40: {
                gt = JGT_AREAHORIZ_PERCENT;
                break;
            }
            case 41: {
                gt = JGT_LINEVERT_ABS;
                break;
            }
            case 42: {
                gt = JGT_LINEVERT_STACKED;
                break;
            }
            case 43: {
                gt = JGT_LINEVERT_ABSDUAL;
                break;
            }
            case 44: {
                gt = JGT_LINEVERT_STACKEDDUAL;
                break;
            }
            case 45: {
                gt = JGT_LINEVERT_ABSBIPOLAR;
                break;
            }
            case 46: {
                gt = JGT_LINEVERT_STACKEDBIPOLAR;
                break;
            }
            case 47: {
                gt = JGT_LINEVERT_PERCENT;
                break;
            }
            case 48: {
                gt = JGT_LINEHORIZ_ABS;
                break;
            }
            case 49: {
                gt = JGT_LINEHORIZ_STACKED;
                break;
            }
            case 50: {
                gt = JGT_LINEHORIZ_ABSDUAL;
                break;
            }
            case 51: {
                gt = JGT_LINEHORIZ_STACKEDDUAL;
                break;
            }
            case 52: {
                gt = JGT_LINEHORIZ_ABSBIPOLAR;
                break;
            }
            case 53: {
                gt = JGT_LINEHORIZ_STACKEDBIPOLAR;
                break;
            }
            case 54: {
                gt = JGT_LINEHORIZ_PERCENT;
                break;
            }
            case 55: {
                gt = JGT_PIE;
                break;
            }
            case 56: {
                gt = JGT_PIE_RING;
                break;
            }
            case 57: {
                gt = JGT_PIE_MULT;
                break;
            }
            case 58: {
                gt = JGT_PIE_RINGMULT;
                break;
            }
            case 59: {
                gt = JGT_PIE_MULTPROP;
                break;
            }
            case 60: {
                gt = JGT_PIE_RINGMULTPROP;
                break;
            }
            case 61: {
                gt = JGT_SCATTER;
                break;
            }
            case 62: {
                gt = JGT_SCATTER_DUAL;
                break;
            }
            case 63: {
                gt = JGT_SCATTER_LABELS;
                break;
            }
            case 64: {
                gt = JGT_SCATTER_LABELSDUAL;
                break;
            }
            case 65: {
                gt = JGT_POLAR;
                break;
            }
            case 66: {
                gt = JGT_POLAR_DUAL;
                break;
            }
            case 67: {
                gt = JGT_RADAR_LINE;
                break;
            }
            case 68: {
                gt = JGT_RADAR_AREA;
                break;
            }
            case 69: {
                gt = JGT_RADAR_LINE_DUAL;
                break;
            }
            case 126: {
                gt = JGT_RADAR_STACKED_LINE;
                break;
            }
            case 127: {
                gt = JGT_RADAR_STACKED_AREA;
                break;
            }
            case 73: {
                gt = JGT_STOCKHILO;
                break;
            }
            case 74: {
                gt = JGT_STOCKHILO_DUAL;
                break;
            }
            case 75: {
                gt = JGT_STOCKHILO_BIPOLAR;
                break;
            }
            case 76: {
                gt = JGT_STOCKHILO_CLOSE;
                break;
            }
            case 77: {
                gt = JGT_STOCKHILO_CLOSEDUAL;
                break;
            }
            case 78: {
                gt = JGT_STOCKHILO_CLOSEBIPOLAR;
                break;
            }
            case 79: {
                gt = JGT_STOCKHILO_OPENCLOSE;
                break;
            }
            case 80: {
                gt = JGT_STOCKHILO_OPENCLOSEDUAL;
                break;
            }
            case 81: {
                gt = JGT_STOCKHILO_OPENCLOSEBIPOLAR;
                break;
            }
            case 128: {
                gt = JGT_STOCKHILO_OPEN;
                break;
            }
            case 129: {
                gt = JGT_STOCKHILO_OPENDUAL;
                break;
            }
            case 130: {
                gt = JGT_STOCKHILO_OPENBIPOLAR;
                break;
            }
            case 82: {
                gt = JGT_STOCKHILO_VOLUME;
                break;
            }
            case 88: {
                gt = JGT_STOCKHILO_CLOSE_VOLUME;
                break;
            }
            case 83: {
                gt = JGT_STOCKHILO_OPENCLOSE_VOLUME;
                break;
            }
            case 70: {
                gt = JGT_STOCKHILO_CANDLE;
                break;
            }
            case 71: {
                gt = JGT_STOCKHILO_CANDLE_VOLUME;
                break;
            }
            case 72: {
                gt = JGT_STOCK_CANDLE;
                break;
            }
            case 84: {
                gt = JGT_STOCK_CANDLE_VOLUME;
                break;
            }
            case 85: {
                gt = JGT_HIST_VERT;
                break;
            }
            case 86: {
                gt = JGT_HIST_HORIZ;
                break;
            }
            case 89: {
                gt = JGT_BUBBLE;
                break;
            }
            case 90: {
                gt = JGT_BUBBLE_LABELS;
                break;
            }
            case 91: {
                gt = JGT_BUBBLE_DUAL;
                break;
            }
            case 92: {
                gt = JGT_BUBBLE_LABELSDUAL;
                break;
            }
            case 99: {
                gt = JGT_GANTT;
                break;
            }
            case 100: {
                gt = JGT_WATERFALL_VERT;
                break;
            }
            case 101: {
                gt = JGT_WATERFALL_HORZ;
                break;
            }
            case 103: {
                gt = JGT_BARVERT_SIDESIDE_THREEY;
                break;
            }
            case 104: {
                gt = JGT_BARVERT_SIDESIDE_FOURY;
                break;
            }
            case 105: {
                gt = JGT_BARVERT_SIDESIDE_FIVEY;
                break;
            }
            case 106: {
                gt = JGT_FUNNEL_VERT;
                break;
            }
            case 110: {
                gt = JGT_GAUGE;
                break;
            }
            case 113: {
                gt = JGT_BARVERT_STACKED_THREEY;
                break;
            }
            case 114: {
                gt = JGT_BARVERT_STACKED_FOURY;
                break;
            }
            case 115: {
                gt = JGT_BARVERT_STACKED_FIVEY;
            }
        }
        if (gt != null && gt.m_id != IntegerGraphType) assert (gt.m_id == IntegerGraphType);
        return gt;
    }

    public int getOrientation() {
        return this.m_orientation;
    }

    public int getRiserType() {
        return this.m_riserType;
    }

    public int getScalingMethod() {
        return this.m_scalingMethod;
    }

    public boolean getCanSwitchDirection() {
        boolean bCanSwitch = false;
        if (this.getAxisDescriptor().hasX1() && this.getAxisDescriptor().hasY1()) {
            bCanSwitch = true;
        }
        return bCanSwitch;
    }

    public int getPreferredResizeDirection() {
        int nPreferred = 1;
        if (this.isOrientHorz()) {
            nPreferred = 0;
        }
        if (this.getAxisDescriptor().hasX1()) {
            nPreferred = 0;
        }
        return nPreferred;
    }

    public DataItem getPreferredResizeItem() {
        DataFormat df = this.getDataFormat();
        DataItem item = DataItem.DI_GENERAL;
        if (this.getAxisDescriptor().hasX1()) {
            item = df.getDataItem(0);
        }
        return item;
    }

    public boolean is3DConnectGroups() {
        return this.getRiserType() == 11;
    }

    public boolean is3DConnectSeries() {
        return this.getRiserType() == 6;
    }

    public boolean is3DFloating() {
        return this.getRiserType() == 5;
    }

    public boolean is3DRiser() {
        return this.getRiserType() == 4;
    }

    public boolean is3DSurface() {
        return this.getRiserType() == 7;
    }

    public boolean is3DRaisedOrigin() {
        return this.is3DFloating() || this.is3DRibbonType();
    }

    public boolean is3DRaisedOrigin(int riserType3D) {
        if (riserType3D == PerspectiveBase.RiserType3D.Default.ordinal()) {
            return this.is3DRaisedOrigin();
        }
        return riserType3D == PerspectiveBase.RiserType3D.ColumnLine.ordinal() || riserType3D == PerspectiveBase.RiserType3D.RowLine.ordinal() || riserType3D == PerspectiveBase.RiserType3D.Cube.ordinal() || riserType3D == PerspectiveBase.RiserType3D.Sphere.ordinal();
    }

    public boolean is3DRibbonType() {
        return this.m_id == 7 || this.m_id == 10;
    }

    public boolean is3DType() {
        return this.chartFactory == JCHART_3D || this.chartFactory == JCHART_3D_SHAPE || this.chartFactory == JCHART_3D_SURFACE;
    }

    public boolean isTopo2D() {
        return this.m_id == 120;
    }

    public boolean isBipolar() {
        return this.m_bBipolar;
    }

    public boolean isDualY() {
        return this.m_bDualY;
    }

    public boolean isThreeY() {
        return this.m_id == 103 || this.m_id == 113;
    }

    public boolean isFourY() {
        return this.m_id == 104 || this.m_id == 114;
    }

    public boolean isFiveY() {
        return this.m_id == 105 || this.m_id == 115;
    }

    public boolean isMultiY() {
        boolean bMultiY = this.isThreeY() || this.isFourY() || this.isFiveY();
        return bMultiY;
    }

    public boolean isExceptionalAllowed() {
        boolean bAllowed = true;
        if (this.isRiserArea() || this.is3DConnectGroups() || this.is3DConnectSeries() || this.is3DSurface()) {
            bAllowed = false;
        }
        if (!this.m_dataformat.equals(DataFormat.DF_GENERAL) && !this.isPolar()) {
            bAllowed = false;
        }
        return bAllowed;
    }

    public boolean isOrientHorz() {
        boolean bHorz = this.m_orientation == 1;
        return bHorz;
    }

    public boolean isPercent() {
        return this.getScalingMethod() == 3;
    }

    public boolean isBLAType() {
        return this.chartFactory == JCHART_2D_BLA;
    }

    public boolean isPieType() {
        return this.chartFactory == JCHART_2D_PIE;
    }

    public boolean isFunnelType() {
        return this.chartFactory == JCHART_2D_FUNNEL;
    }

    public boolean isStacked() {
        boolean isStacked = this.getIntegerGraphType() == 18 || this.getIntegerGraphType() == 20 || this.getIntegerGraphType() == 22 || this.getIntegerGraphType() == 25 || this.getIntegerGraphType() == 27 || this.getIntegerGraphType() == 22 || this.getIntegerGraphType() == 25 || this.getIntegerGraphType() == 27 || this.getIntegerGraphType() == 29 || this.getIntegerGraphType() == 35 || this.getIntegerGraphType() == 32 || this.getIntegerGraphType() == 34 || this.getIntegerGraphType() == 40 || this.getIntegerGraphType() == 37 || this.getIntegerGraphType() == 39 || this.getIntegerGraphType() == 42 || this.getIntegerGraphType() == 44 || this.getIntegerGraphType() == 46 || this.getIntegerGraphType() == 49 || this.getIntegerGraphType() == 51 || this.getIntegerGraphType() == 53 || this.getIntegerGraphType() == 113 || this.getIntegerGraphType() == 114 || this.getIntegerGraphType() == 115 || this.getIntegerGraphType() == 127 || this.getIntegerGraphType() == 126;
        return isStacked;
    }

    public boolean isRadarType() {
        return this.chartFactory == JCHART_2D_RADAR;
    }

    public boolean isWaterfall() {
        return this.chartFactory == JCHART_2D_WATERFALL;
    }

    public boolean isGanttType() {
        return this.chartFactory == JCHART_2D_GANTT;
    }

    public boolean isRiserArea() {
        boolean bRiserArea = this.m_riserType == 3;
        return bRiserArea;
    }

    public boolean isRiserBar() {
        boolean bRiserBar = this.m_riserType == 1;
        return bRiserBar;
    }

    public boolean isRiserUnspecified() {
        boolean bRiserBar = this.m_riserType == 0;
        return bRiserBar;
    }

    public boolean isRiserLine() {
        boolean bRiserMarker = this.isRiserMarker();
        return bRiserMarker && (this.isBLAType() || this.isRadarType());
    }

    public boolean isRiserMarker() {
        boolean bRiserMarker = this.m_riserType == 2 || this.m_riserType == 8;
        return bRiserMarker;
    }

    public boolean isScalingAbs() {
        return this.m_scalingMethod == 1;
    }

    public boolean isScalingPercent() {
        return this.m_scalingMethod == 3;
    }

    public boolean isScalingStacked() {
        return this.m_scalingMethod == 2;
    }

    public boolean isScalingWaterfall() {
        return this.m_scalingMethod == 5;
    }

    public boolean isBubble() {
        return this.m_name.equals("BUBBLE") || this.m_name.equals("BUBBLE_LABELS") || this.m_name.equals("BUBBLE_DUAL") || this.m_name.equals("BUBBLE_LABELSDUAL");
    }

    public boolean isSurface() {
        return this.m_name.indexOf("SURFACE") != -1;
    }

    public boolean isPolar() {
        return this.m_name.equals("POLAR") || this.m_name.equals("POLAR_DUAL");
    }

    public boolean isHistogram() {
        return this.m_name.equals("HIST_VERT") || this.m_name.equals("HIST_HORIZ");
    }

    public boolean isHoneyComb() {
        return this.m_name.equals("THREED_SURFACEHONEYCOMB");
    }

    public boolean isSurfaceWithSides() {
        return this.m_name.equals("THREED_SURFACESIDES");
    }

    public boolean isScatter() {
        return this.m_name.equals("SCATTER") || this.m_name.equals("SCATTER_DUAL") || this.m_name.equals("SCATTER_LABELS") || this.m_name.equals("SCATTER_LABELSDUAL");
    }

    public boolean isScatterWithLabel() {
        return this.m_name.equals("SCATTER_LABELS") || this.m_name.equals("SCATTER_LABELSDUAL") || this.m_name.equals("BUBBLE_LABELS") || this.m_name.equals("BUBBLE_LABELSDUAL");
    }

    public boolean isStockCandleType() {
        return this.m_name.equals("STOCKHILO_CANDLE") || this.m_name.equals("STOCKHILO_CANDLE_VOLUME") || this.m_name.equals("STOCK_CANDLE") || this.m_name.equals("STOCK_CANDLE_VOLUME");
    }

    public boolean isStockType() {
        return this.chartFactory == JCHART_2D_HILO;
    }

    public boolean isStockTypeWithVolume() {
        return this.chartFactory == JCHART_2D_HILO && (this.m_name.equals("STOCKHILO_VOLUME") || this.m_name.equals("STOCKHILO_CLOSE_VOLUME") || this.m_name.equals("STOCKHILO_OPENCLOSE_VOLUME") || this.m_name.equals("STOCKHILO_CANDLE_VOLUME") || this.m_name.equals("STOCK_CANDLE_VOLUME"));
    }

    public String toString() {
        return this.m_name;
    }

    public boolean wantDepthEffect() {
        boolean wantDepthEffect = false;
        wantDepthEffect = this.isTimeScaleAxis || this.isPolar() || this.isPolar() ? false : this.isBLAType() || this.isScatter() || this.isBubble() || this.isWaterfall() || this.isHistogram() || this.isGanttType();
        return wantDepthEffect;
    }

    public boolean isGaugeType() {
        return this.chartFactory == JCHART_2D_GAUGE;
    }

    public boolean hasPieRing() {
        boolean bGTHasRing = this.m_name.equals("PIE_RING") || this.m_name.equals("PIE_RINGMULT") || this.m_name.equals("PIE_RINGMULTPROP") || this.m_name.equals("PIE_BAR_RING");
        return bGTHasRing;
    }

    public boolean isProportionalPieType() {
        boolean bGTProportional = this.m_name.equals("PIE_MULTPROP") || this.m_name.equals("PIE_RINGMULTPROP");
        return bGTProportional;
    }

    public boolean isMultiPieType() {
        boolean bGTProportional = this.isProportionalPieType();
        boolean bGTMultiple = bGTProportional || this.m_name.equals("PIE_MULT") || this.m_name.equals("PIE_RINGMULT");
        return bGTMultiple;
    }

    public boolean isCircularType() {
        return this.isPieType() || this.isRadarType() || this.isPolar();
    }

    public static final boolean isBlaCombo(Perspective p) {
        boolean isBlaCombo = false;
        if (p.getJGraphType().isBLAType()) {
            int numSeries = p.getNumSeries();
            int lastSeriesType = p.getSeriesType(p.getSeries(0));
            for (int i = 0; i < numSeries; ++i) {
                int type = p.getSeriesType(p.getSeries(i));
                if (lastSeriesType == type) continue;
                isBlaCombo = true;
                break;
            }
        }
        return isBlaCombo;
    }

    public boolean hasLegend() {
        return !this.isStockCandleType() && !this.isHistogram() && !this.isTimeScaleAxis && (!this.is3DType() || this.is3DSurface());
    }

    public boolean has2DFrame() {
        return !this.is3DType() && !this.isPieType() && !this.isGaugeType() && !this.isFunnelType() && !this.isPolar();
    }

    public boolean isBar() {
        return this.m_id >= 17 && this.m_id <= 30;
    }

    public boolean isLine() {
        return this.m_id >= 41 && this.m_id <= 54;
    }

    public boolean isArea() {
        return this.m_id >= 31 && this.m_id <= 40;
    }

    public boolean isRadarLine() {
        return this.m_id == 69 || this.m_id == 67;
    }

    public boolean isPieProportional() {
        return this.m_id == 60 || this.m_id == 59;
    }

    public boolean isHiLoOpenClose() {
        return this.m_id == 79 || this.m_id == 80 || this.m_id == 81;
    }

    public boolean isHiLo() {
        return this.m_id == 73 || this.m_id == 74 || this.m_id == 75 || this.m_id == 70 || this.m_id == 71;
    }

    public boolean isHiLoOpen() {
        return this.m_id == 128 || this.m_id == 129 || this.m_id == 130;
    }

    public boolean isHiLoClose() {
        return this.m_id == 76 || this.m_id == 77 || this.m_id == 78;
    }

    public boolean isBarType() {
        return this.m_id >= 17 && this.m_id <= 30;
    }

    public boolean isLineType() {
        return this.m_id >= 41 && this.m_id <= 54;
    }

    public boolean isAreaType() {
        return this.m_id >= 31 && this.m_id <= 40;
    }

    public boolean isRegularPieType() {
        return this.m_id == 55 || this.m_id == 59 || this.m_id == 57;
    }

    public boolean isDoughnutType() {
        return this.m_id == 56 || this.m_id == 58 || this.m_id == 60;
    }
}

