/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataFormat;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataItem;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DatumObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextStyleObjFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngineFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Standard;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MinMaxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;

class JChart_2D_Hilo
extends JChart_2D_Standard {
    public static final int TICKLEN_UNIT = 600;
    public static final int MA_SCIENTIFIC = 0;
    public static final int MA_FINANCIAL = 1;
    public static final int MISC_LOWER = 1;
    public static final int kMAX_HILO_ITEMS = 4;
    public static final int STOCK_SPLITBAR = 0;
    public static final int STOCK_TICKS = 1;
    private DataFormat m_df;
    private boolean m_bHasOpen;
    private boolean m_bHasClose;
    private boolean m_bHasVolume;
    private double m_fLineWidthMA;
    private double m_fLineWidthHighWick;
    private double m_fLineWidthLowWick;
    private boolean m_bCloseSplitDisplay;
    private boolean m_bCloseTicksDisplay;
    private boolean m_bOpenTicksDisplay;
    private boolean m_bInterpretAsHLOC;
    private String[] m_VolumeDataLabel;
    private GroupsEnumerator m_gEnumReadOnly;
    public static final IChartEngineFactory engineFactory = new IChartEngineFactory(){

        public IChartEngine createChartEngine(Perspective perspective) {
            return new JChart_2D_Hilo(perspective);
        }
    };

    private JChart_2D_Hilo(Perspective perspective) {
        super(perspective);
    }

    public void init() {
        super.init();
        this.m_df = this.getDataView().getDataFormat();
        this.m_bHasOpen = this.hasOpenValue(this.m_df);
        this.m_bHasClose = this.hasCloseValue(this.m_df);
        this.m_bHasVolume = this.hasVolumeValue(this.m_df);
    }

    protected void calc52WeekLines() {
        Java2DLine line2D;
        int x2;
        int x1;
        int y2;
        int y1;
        IdentObj idHigh = new IdentObj(548);
        IdentObj idLow = new IdentObj(549);
        BlackBoxObj blackBoxHigh = new BlackBoxObj(this.m_Perspective, idHigh);
        BlackBoxObj blackBoxLow = new BlackBoxObj(this.m_Perspective, idLow);
        Rectangle frameRect = this.m_Perspective.getFrameRect(true);
        if (this.m_Perspective.getStock52WeekHighDisplay()) {
            double f52High = this.m_Perspective.getStock52WeekHighValue();
            y2 = y1 = (int)this.getY1Axis().getValueCoord(f52High);
            x1 = frameRect.x;
            x2 = frameRect.x + frameRect.width;
            line2D = new Java2DLine(this.m_Perspective);
            line2D.createLine(idHigh, idHigh, x1, y1, x2, y2, blackBoxHigh, this.m_rClip, this.m_Perspective.getLineWidth(idHigh));
        }
        if (this.m_Perspective.getStock52WeekLowDisplay()) {
            double f52Low = (int)this.m_Perspective.getStock52WeekLowValue();
            y2 = y1 = (int)this.getY1Axis().getValueCoord(f52Low);
            x1 = frameRect.x;
            x2 = frameRect.x + frameRect.width;
            line2D = new Java2DLine(this.m_Perspective);
            line2D.createLine(idLow, idLow, x1, y1, x2, y2, blackBoxLow, this.m_rClip, this.m_Perspective.getLineWidth(idLow));
        }
    }

    protected void calcDataAbsolute() {
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_gEnumReadOnly = GroupsEnumerator.getIterator(this.m_Perspective, this.getDataView());
        if (this.m_gt.isStockCandleType()) {
            this.drawCandleRisers();
        } else {
            this.drawRisersAndTicks();
        }
        if ((this.m_gt.isBipolar() || this.m_bHasVolume) && this.m_Perspective.getFrameDisplay() && this.m_Perspective.getDualAxisLineDisplay()) {
            double fSplit = (double)this.m_Perspective.getDualAxisSplitPosition() / 100.0;
            this.getFrame().drawSeparator(this.m_bHorz, fSplit);
        }
        if (!this.m_gt.isBipolar()) {
            this.calc52WeekLines();
        }
        if (this.m_Perspective.getStockMovingAverageDisplay()) {
            SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.getDataView());
            while (sEnum.hasNext()) {
                int s = sEnum.next();
                assert (s >= 0 && s < this.m_nTotalSeries);
                this.calcMovingAverageLine(s);
            }
        }
        this.drawUserLines();
        this.drawDataLabels();
        if (this.m_bHasVolume) {
            this.drawVolumeDataValues();
        }
    }

    protected Rectangle calcDataValuePosition(int s, int g, int nDataTextPosition, int nDataTextPositionSecondary, Dimension labelDim) {
        Point center = this.getCoords(s, g);
        Point base = this.getBottomCoords(s, g);
        Rectangle r = new Rectangle(center.x - labelDim.width / 2, center.y - labelDim.height / 2, labelDim.width, labelDim.height);
        switch (this.m_Perspective.getDataTextPosition()) {
            case 0: {
                double nAngle = this.m_Perspective.getDataTextAngle(s, g);
                double nDist = this.m_Perspective.getDataTextRadius(s, g);
                r.x += (int)(Math.cos(nAngle * (Math.PI / 180)) * nDist * 40.0);
                r.y += (int)(Math.sin(nAngle * (Math.PI / 180)) * nDist * 40.0);
                break;
            }
            case 1: {
                if (this.isAxisAscending(s)) {
                    r.y += labelDim.height / 2;
                    break;
                }
                r.y -= labelDim.height / 2;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.isAxisAscending(s)) {
                    r.y -= labelDim.height / 2;
                    break;
                }
                r.y += labelDim.height / 2;
                break;
            }
            case 4: {
                r.y = Math.min(center.y, base.y) + (Math.abs(center.y - base.y) - labelDim.height) / 2;
                break;
            }
            case 5: {
                r.y = base.y;
            }
        }
        Point offset = new Point(0, 0);
        if (this.getFrame() != null) {
            offset = this.getFrame().getDepthOffset(1.0);
        }
        r.x -= offset.x;
        r.y -= offset.y;
        return r;
    }

    protected void drawVolumeDataValues() {
        int g;
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.getDataView());
        GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.getDataView());
        IdentObj id = Identity.DataText;
        ArrayList<String> vectStrLabels = new ArrayList<String>(this.m_nSeries * this.m_nGroups);
        ITextStyle textStyle = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, id);
        while (gEnum.hasNext()) {
            g = gEnum.next();
            assert (g >= 0 && g < this.m_nTotalGroups);
            vectStrLabels.add(this.m_VolumeDataLabel[g]);
        }
        Dimension dimLabelDC = TextUtil.getDimLargestWidthLabelDC(this.m_Perspective.getVC(), vectStrLabels, textStyle);
        Dimension dimLabelVC = this.m_Perspective.getVC().destToVirt(dimLabelDC);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            while (gEnum.hasNext()) {
                g = gEnum.next();
                assert (g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g] || this.m_VolumeDataLabel[g] == null) continue;
                Rectangle r = this.calcVolumeDataValuePosition(s, g, dimLabelVC);
                IdentObj newID = new IdentObj(id.getObjectID(), s, g);
                DrawFactory.createLabel(this.m_Perspective.getDetectiv(), newID, this.m_VolumeDataLabel[g], r, textStyle, blackBox, null);
            }
        }
    }

    protected Rectangle calcVolumeDataValuePosition(int s, int g, Dimension labelDim) {
        boolean bDescendingVol = this.m_Y2Axis.isDescending();
        int gRel = this.m_gEnumReadOnly.getRelative(g);
        assert (gRel >= 0 && gRel < this.m_nGroups);
        double fVolume = this.getVolumeValue(s, g);
        int bottom = (int)(bDescendingVol ? this.m_Y2Axis.getValueCoord(fVolume) : this.m_Y2Axis.getBaseCoord());
        int top = (int)(bDescendingVol ? this.m_Y2Axis.getBaseCoord() : this.m_Y2Axis.getValueCoord(fVolume));
        int left = (int)this.getO1Axis().getLowCoord(0, gRel);
        int right = (int)this.getO1Axis().getHighCoord(0, gRel);
        Point center = new Point(left + (right - left) / 2, top);
        int base = bottom;
        Rectangle r = new Rectangle(center.x - labelDim.width / 2, center.y - labelDim.height / 2, labelDim.width, labelDim.height);
        switch (this.m_Perspective.getDataTextPosition()) {
            case 0: {
                double nAngle = this.m_Perspective.getDataTextAngle(s, g);
                double nDist = this.m_Perspective.getDataTextRadius(s, g);
                r.x += (int)(Math.cos(nAngle * (Math.PI / 180)) * nDist * 40.0);
                r.y += (int)(Math.sin(nAngle * (Math.PI / 180)) * nDist * 40.0);
                break;
            }
            case 1: {
                if (this.isAxisAscending(s)) {
                    r.y += labelDim.height / 2;
                    break;
                }
                r.y -= labelDim.height / 2;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.isAxisAscending(s)) {
                    r.y -= labelDim.height / 2;
                    break;
                }
                r.y += labelDim.height / 2;
                break;
            }
            case 4: {
                r.y = Math.min(center.y, base) + (Math.abs(center.y - base) - labelDim.height) / 2;
                break;
            }
            case 5: {
                r.y = base;
            }
        }
        if (this.getFrame() != null) {
            Point offset = this.getFrame().getDepthOffset(1.0);
            r.x -= offset.x;
            r.y -= offset.y;
        }
        return r;
    }

    protected void calcMovingAverageLine(int s) {
        int g;
        INumericAxis yAxisObj = this.getAxisAssignment(s) == 1 ? this.m_Y2Axis : this.getY1Axis();
        int nType = 1;
        int nOrder = 6;
        double[] fValues = new double[this.m_nTotalGroups];
        double[] fPartialSums = new double[this.m_nTotalGroups];
        int x0 = Integer.MIN_VALUE;
        int y0 = 0;
        if (nType != 0 && nType != 1) {
            throw new RuntimeException("calcMovingAverageLine: unknown moving average type = " + nType);
        }
        if (nOrder < 1) {
            throw new RuntimeException("calcMovingAverageLine: cannot average fewer than 1 point :-)");
        }
        if (nOrder >= this.m_nGroups) {
            nOrder = this.m_nGroups - 1;
        }
        DataItem item = this.m_bHasClose ? this.getCloseItem() : this.getHighItem();
        for (g = 0; g < this.m_nTotalGroups; ++g) {
            DatumObj dObj = this.getDataValue(s, g, item);
            fValues[g] = dObj.value;
            this.m_dataOK[s][g] = dObj.m_bOK;
            fPartialSums[g] = g == 0 ? fValues[g] : fPartialSums[g - 1] + fValues[g];
        }
        IdentObj id = new IdentObj(553);
        BlackBoxObj bb = new BlackBoxObj(this.m_Perspective, id);
        for (g = nOrder - 1; g < this.m_nTotalGroups; ++g) {
            int gRel = this.m_gEnumReadOnly.getRelative(g);
            if (gRel == -1) continue;
            assert (gRel >= 0 && gRel < this.m_nGroups);
            double fTotal = g < nOrder ? fPartialSums[g] : fPartialSums[g] - fPartialSums[g - nOrder];
            double fAverage = fTotal / (double)nOrder;
            int x1 = nType == 0 ? (int)this.getO1Axis().getCenterCoord(gRel) : (int)((this.getO1Axis().getCenterCoord(gRel) + this.getO1Axis().getCenterCoord(gRel - nOrder + 1)) / 2.0);
            int y1 = (int)yAxisObj.getValueCoord(fAverage);
            if (x0 != Integer.MIN_VALUE) {
                IdentObj newID = new IdentObj(id.getObjectID(), s, g);
                Java2DLine line2D = new Java2DLine(this.m_Perspective);
                line2D.createLine(newID, newID, x0, y0, x1, y1, bb, this.m_rClip, this.m_fLineWidthMA);
            }
            x0 = x1;
            y0 = y1;
        }
    }

    protected void calcVolumeBar(int g, double fVolume) {
        boolean bDescendingVol = this.m_Y2Axis.isDescending();
        int gRel = this.m_gEnumReadOnly.getRelative(g);
        assert (gRel >= 0 && gRel < this.m_nGroups);
        int bottom = (int)(bDescendingVol ? this.m_Y2Axis.getValueCoord(fVolume) : this.m_Y2Axis.getBaseCoord());
        int top = (int)(bDescendingVol ? this.m_Y2Axis.getBaseCoord() : this.m_Y2Axis.getValueCoord(fVolume));
        int left = (int)this.getO1Axis().getLowCoord(0, gRel);
        int right = (int)this.getO1Axis().getHighCoord(0, gRel);
        Rectangle rVirt = new Rectangle(left, bottom, right - left, top - bottom);
        IdentObj idVol = new IdentObj(554, 1, g);
        BlackBoxObj blackBoxVol = new BlackBoxObj(this.m_Perspective, new IdentObj(554));
        DrawFactory.createRectangle(this.getDrawContainer(), idVol, rVirt, blackBoxVol, this.m_rClip);
    }

    protected void copyParams() {
        super.copyParams();
        this.m_fLineWidthMA = this.m_Perspective.getLineWidth(Identity.StockMALine);
        this.m_fLineWidthHighWick = this.m_Perspective.getLineWidth(Identity.StockHighLine);
        this.m_fLineWidthLowWick = this.m_Perspective.getLineWidth(Identity.StockLowLine);
        this.m_bCloseSplitDisplay = this.m_Perspective.getStockCloseSplitDisplay();
        this.m_bCloseTicksDisplay = this.m_Perspective.getStockCloseTicksDisplay();
        this.m_bOpenTicksDisplay = this.m_Perspective.getStockOpenTicksDisplay();
        this.m_bInterpretAsHLOC = this.m_Perspective.getInterpretAsHLOC();
        if (this.isSingleSeriesOnly() && this.m_nSeries > 1) {
            this.m_nSeries = 1;
        }
    }

    protected void calcAxes() {
        if (this.getO1Axis() != null) {
            this.getO1Axis().calc();
        }
        if (this.getY1Axis() != null) {
            this.getY1Axis().calc();
        }
        if (this.m_Y2Axis != null) {
            this.m_Y2Axis.calc();
        }
    }

    protected void createAxes(boolean bCalc) {
        int split;
        int offsetY1 = split = this.m_gt.isBipolar() || this.m_bHasVolume ? this.m_Perspective.getDualAxisSplitPosition() : 0;
        int sizeY1 = 100 - offsetY1;
        int offsetY2 = this.m_gt.isBipolar() ? 0 : offsetY1;
        int sizeY2 = this.m_gt.isBipolar() ? 100 - sizeY1 : sizeY1;
        boolean bVerticalAxis = this.m_gt.getOrientation() == 2;
        int ordType = 1;
        this.m_O1Axis = AxisFactory.create2DOrdinalAxis(this.m_Perspective, this.getDataView(), AxisTemplate.O1_AXIS, ordType, !bVerticalAxis, bVerticalAxis);
        boolean bMustIncludeZero = this.m_Perspective.getY1MustIncludeZero();
        MinMaxObj y1MinMaxObj = this.findLimitsStock(0, bMustIncludeZero);
        this.m_Y1Axis = AxisFactory.create2DNumericAxis(this.m_Perspective, this.getDataView(), AxisTemplate.Y1_AXIS, y1MinMaxObj, bVerticalAxis, !this.m_Perspective.getY1AxisDescending(), offsetY1, sizeY1, true);
        if (this.m_gt.isDualY()) {
            bMustIncludeZero = this.m_Perspective.getY2MustIncludeZero();
            MinMaxObj y2MinMaxObj = this.findLimitsStock(1, bMustIncludeZero);
            this.m_Y2Axis = AxisFactory.create2DNumericAxis(this.m_Perspective, this.getDataView(), AxisTemplate.Y2_AXIS, y2MinMaxObj, bVerticalAxis, !this.m_Perspective.getY2AxisDescending(), offsetY2, sizeY2, true);
        } else if (this.m_bHasVolume) {
            bMustIncludeZero = this.m_Perspective.getY2MustIncludeZero();
            MinMaxObj y2MinMaxObj = this.findVolumeLimits(bMustIncludeZero);
            this.m_Y2Axis = AxisFactory.create2DNumericAxis(this.m_Perspective, this.getDataView(), AxisTemplate.Y2_AXIS, y2MinMaxObj, bVerticalAxis, !this.m_Perspective.getY2AxisDescending(), 0, split, true);
        }
        if (bCalc) {
            if (this.getO1Axis() != null) {
                this.getO1Axis().calc();
            }
            if (this.getY1Axis() != null) {
                this.getY1Axis().calc();
            }
            if (this.m_Y2Axis != null) {
                this.m_Y2Axis.calc();
            }
        }
    }

    protected void drawCandleRisers() {
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.getDataView());
        GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.getDataView());
        IdentObj idRising = new IdentObj(563);
        IdentObj idFalling = new IdentObj(564);
        IdentObj idHighLine = new IdentObj(565);
        IdentObj idLowLine = new IdentObj(566);
        double fHigh = 0.0;
        double fLow = 0.0;
        double fOpen = 0.0;
        double fClose = 0.0;
        double fVolume = 0.0;
        boolean bDescending = this.getY1Axis().isDescending();
        boolean bHasHighLow = this.m_df != DataFormat.DF_OC && this.m_df != DataFormat.DF_OC_VOL;
        String[] dataItemStringArray = new String[4];
        String sDataTextTemplate = "";
        Format format = this.getY1Axis().getDataTextFormat();
        if (!this.m_bHasClose || !this.m_bHasOpen) {
            return;
        }
        if (this.m_bHasVolume) {
            this.m_VolumeDataLabel = new String[this.m_nTotalGroups];
        }
        sDataTextTemplate = this.m_Perspective.getDataTextTemplateHiLo();
        BlackBoxObj blackBoxRising = new BlackBoxObj(this.m_Perspective, idRising);
        BlackBoxObj blackBoxFalling = new BlackBoxObj(this.m_Perspective, idFalling);
        BlackBoxObj blackBoxHighLine = new BlackBoxObj(this.m_Perspective, idHighLine);
        BlackBoxObj blackBoxLowLine = new BlackBoxObj(this.m_Perspective, idLowLine);
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            while (gEnum.hasNext()) {
                IdentObj newID;
                int y2;
                int x2;
                int y1;
                int x1;
                double fValue;
                double fMax;
                double fMin;
                int g = gEnum.next();
                assert (g >= 0 && g < this.m_nTotalGroups);
                int gRel = gEnum.getRelative(g);
                assert (gRel >= 0 && gRel < this.m_nGroups);
                this.m_dataOK[s][g] = true;
                if (this.m_bHasOpen) {
                    fOpen = this.getOpenValue(s, g);
                }
                if (bHasHighLow) {
                    fHigh = this.getHighValue(s, g);
                    fLow = this.getLowValue(s, g);
                    if (fLow > fHigh) {
                        double fTemp = fLow;
                        fLow = fHigh;
                        fHigh = fTemp;
                    }
                }
                if (this.m_bHasClose) {
                    fClose = this.getCloseValue(s, g);
                }
                if (this.m_bHasVolume) {
                    fVolume = this.getVolumeValue(s, g);
                }
                if (fClose > fOpen) {
                    fMin = fOpen;
                    fMax = fClose;
                } else {
                    fMin = fClose;
                    fMax = fOpen;
                }
                double d = fValue = bHasHighLow && fHigh > fMax ? fHigh : fMax;
                if (this.isIgnoredOffScale(this.getY1Axis(), fValue)) {
                    this.m_dataOK[s][g] = false;
                    continue;
                }
                fValue = this.m_bHasClose ? fClose : fHigh;
                int bottom = (int)(bDescending ? this.getY1Axis().getValueCoord(fMax) : this.getY1Axis().getValueCoord(fMin));
                int top = (int)(bDescending ? this.getY1Axis().getValueCoord(fMin) : this.getY1Axis().getValueCoord(fMax));
                int left = (int)this.getO1Axis().getLowCoord(0, gRel);
                int right = (int)this.getO1Axis().getHighCoord(0, gRel);
                int center = (int)this.getO1Axis().getCenterCoord(gRel);
                Rectangle rVirt = new Rectangle(left, bottom, right - left, top - bottom);
                Rectangle rDest = this.m_Perspective.getVC().virtToDest(rVirt);
                if (rDest.height < 2) {
                    rDest.height = 2;
                    rVirt = this.m_Perspective.getVC().destToVirt(rDest);
                }
                if (bHasHighLow && fHigh > fMax) {
                    x1 = center;
                    y1 = bDescending ? bottom : top;
                    x2 = center;
                    y2 = (int)this.getY1Axis().getValueCoord(fHigh);
                    newID = new IdentObj(idHighLine.getObjectID(), s, g);
                    Java2DLine line2D = new Java2DLine(this.m_Perspective);
                    line2D.createLine(newID, newID, x1, y1, x2, y2, blackBoxHighLine, this.m_rClip, this.m_fLineWidthHighWick);
                }
                if (bHasHighLow && fLow < fMin) {
                    x1 = center;
                    y1 = bDescending ? top : bottom;
                    x2 = center;
                    y2 = (int)this.getY1Axis().getValueCoord(fLow);
                    newID = new IdentObj(idLowLine.getObjectID(), s, g);
                    Java2DLine line2D = new Java2DLine(this.m_Perspective);
                    line2D.createLine(newID, newID, x1, y1, x2, y2, blackBoxLowLine, this.m_rClip, this.m_fLineWidthLowWick);
                }
                if (fClose >= fOpen) {
                    DrawFactory.createRectangle(this.getDrawContainer(), new IdentObj(563, s, g), rVirt, blackBoxRising, this.m_rClip);
                } else {
                    DrawFactory.createRectangle(this.getDrawContainer(), new IdentObj(564, s, g), rVirt, blackBoxFalling, this.m_rClip);
                }
                if (this.m_DataLabels.wantDataLabel(s, g)) {
                    if (this.m_bHasOpen) {
                        dataItemStringArray[0] = format.format(fOpen);
                    }
                    if (bHasHighLow) {
                        dataItemStringArray[1] = format.format(fHigh);
                        dataItemStringArray[2] = format.format(fLow);
                    }
                    if (this.m_bHasClose) {
                        dataItemStringArray[3] = format.format(fClose);
                    }
                    if (sDataTextTemplate == null || sDataTextTemplate.length() < 1) {
                        sDataTextTemplate = this.m_bHasClose ? "[CLOSE]" : "[HIGH]";
                    }
                    this.m_DataLabels.setDataText(this.processDataTextTemplate(dataItemStringArray, sDataTextTemplate), s, g);
                    if (this.m_bHasVolume) {
                        this.m_VolumeDataLabel[g] = NumberFormat.getInstance().format(fVolume);
                    }
                }
                if (!this.m_bHasVolume) continue;
                this.calcVolumeBar(g, fVolume);
            }
        }
    }

    protected void drawRisersAndTicks() {
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.getDataView());
        GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.getDataView());
        double fOpen = 0.0;
        double fClose = 0.0;
        double fVolume = 0.0;
        int tickWidth = this.m_Perspective.getStockTickWidthVC();
        int tickHeight = this.m_Perspective.getStockTickHeightVC();
        int riserWidth = this.m_Perspective.getStockRiserWidthVC();
        int tickOverlap = riserWidth / 10;
        String[] dataItemStringArray = new String[4];
        String sDataTextTemplate = "";
        boolean bNotifyHighLessThanLowEvent = false;
        boolean bNotifyOpenCloseNotInRangeEvent = false;
        if (this.m_bHasVolume) {
            this.m_VolumeDataLabel = new String[this.m_nTotalGroups];
        }
        sDataTextTemplate = this.m_Perspective.getDataTextTemplateHiLo();
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            INumericAxis yAxisObj = this.getAxisAssignment(s) == 1 ? this.m_Y2Axis : this.getY1Axis();
            boolean bDescending = yAxisObj.isDescending();
            Format format = yAxisObj.getDataTextFormat();
            gEnum.reset();
            while (gEnum.hasNext()) {
                int g = gEnum.next();
                assert (g >= 0 && g < this.m_nTotalGroups);
                int gRel = gEnum.getRelative(g);
                assert (gRel >= 0 && gRel < this.m_nGroups);
                this.m_dataOK[s][g] = true;
                IBlackBox blackBox = this.assignSeriesColor(s, g);
                if (this.m_bHasOpen) {
                    fOpen = this.getOpenValue(s, g);
                }
                double fHigh = this.getHighValue(s, g);
                double fLow = this.getLowValue(s, g);
                if (fLow > fHigh) {
                    double fTemp = fLow;
                    fLow = fHigh;
                    fHigh = fTemp;
                    if (!bNotifyHighLessThanLowEvent) {
                        bNotifyHighLessThanLowEvent = true;
                    }
                }
                if (this.m_bHasClose) {
                    fClose = this.getCloseValue(s, g);
                }
                if (this.m_bHasVolume) {
                    fVolume = this.getVolumeValue(s, g);
                }
                if (this.m_bHasOpen && this.m_bHasClose && !bNotifyOpenCloseNotInRangeEvent) {
                    boolean bCloseOutOfRange;
                    boolean bOpenOutOfRange = fOpen > fHigh || fOpen < fLow;
                    boolean bl = bCloseOutOfRange = fClose > fHigh || fClose < fLow;
                    if (bOpenOutOfRange || bCloseOutOfRange) {
                        bNotifyOpenCloseNotInRangeEvent = true;
                    }
                }
                if (this.isIgnoredOffScale(this.getY1Axis(), fHigh)) {
                    this.m_dataOK[s][g] = false;
                    continue;
                }
                int bottom = (int)(bDescending ? yAxisObj.getValueCoord(fHigh) : yAxisObj.getValueCoord(fLow));
                int top = (int)(bDescending ? yAxisObj.getValueCoord(fLow) : yAxisObj.getValueCoord(fHigh));
                int left = (int)(this.getO1Axis().getCenterCoord(gRel) - (double)Math.round((double)riserWidth / 2.0));
                int right = left + riserWidth;
                Rectangle rVirt = new Rectangle(left, bottom, right - left, top - bottom);
                Rectangle rDest = this.m_Perspective.getVC().virtToDest(rVirt);
                if (rDest.height < 2 || rDest.width < 1) {
                    rDest.height = Math.max(2, rDest.height);
                    rDest.width = Math.max(1, rDest.width);
                    rVirt = this.m_Perspective.getVC().destToVirt(rDest);
                }
                DrawFactory.createRectangle(this.getDrawContainer(), new IdentObj(547, s, g), rVirt, blackBox, this.m_rClip);
                if (this.m_bHasClose) {
                    int closeCoord = (int)yAxisObj.getValueCoord(fClose);
                    if (this.m_bCloseSplitDisplay) {
                        if (bDescending) {
                            bottom = closeCoord;
                        } else {
                            top = closeCoord;
                        }
                        rVirt = new Rectangle(left, bottom, right - left, top - bottom);
                        IdentObj idLower = new IdentObj(550, s, g, 1);
                        BlackBoxObj blackBoxLower = new BlackBoxObj(this.m_Perspective, idLower);
                        DrawFactory.createRectangle(this.getDrawContainer(), idLower, rVirt, blackBoxLower, this.m_rClip);
                    }
                    if (this.m_bCloseTicksDisplay) {
                        Rectangle rTick = new Rectangle(right - tickOverlap, closeCoord - tickHeight / 2, tickWidth + tickOverlap, tickHeight);
                        IdentObj newID = this.m_Perspective.getStockCloseTick(s, g);
                        DrawFactory.createRectangle(this.getDrawContainer(), newID, rTick, blackBox, null);
                    }
                }
                if (this.m_bHasOpen && this.m_bOpenTicksDisplay) {
                    int openCoord = (int)yAxisObj.getValueCoord(fOpen);
                    Rectangle rTick = new Rectangle(left - tickWidth, openCoord - tickHeight / 2, tickWidth + tickOverlap, tickHeight);
                    IdentObj newID = this.m_Perspective.getStockOpenTick(s, g);
                    DrawFactory.createRectangle(this.getDrawContainer(), newID, rTick, blackBox, null);
                }
                if (this.m_DataLabels.wantDataLabel(s, g)) {
                    if (this.m_bHasOpen) {
                        dataItemStringArray[0] = format.format(fOpen);
                    }
                    dataItemStringArray[1] = format.format(fHigh);
                    dataItemStringArray[2] = format.format(fLow);
                    if (this.m_bHasClose) {
                        dataItemStringArray[3] = format.format(fClose);
                    }
                    if (sDataTextTemplate == null || sDataTextTemplate.length() < 1) {
                        sDataTextTemplate = this.m_bHasClose ? "[CLOSE]" : "[HIGH]";
                    }
                    this.m_DataLabels.setDataText(this.processDataTextTemplate(dataItemStringArray, sDataTextTemplate), s, g);
                    if (this.m_bHasVolume) {
                        this.m_VolumeDataLabel[g] = NumberFormat.getInstance().format(fVolume);
                    }
                }
                if (!this.m_bHasVolume) continue;
                this.calcVolumeBar(g, fVolume);
            }
        }
    }

    protected String processDataTextTemplate(String[] dataItems, String dataTextTemplate) {
        String result = dataTextTemplate;
        result = TextUtil.ReplaceMacro(result, "[OPEN]", dataItems[0]);
        result = TextUtil.ReplaceMacro(result, "[HIGH]", dataItems[1]);
        result = TextUtil.ReplaceMacro(result, "[LOW]", dataItems[2]);
        result = TextUtil.ReplaceMacro(result, "[CLOSE]", dataItems[3]);
        return result;
    }

    private MinMaxObj findLimitsStock(int axis, boolean bMustIncludeZero) {
        int scaling = this.m_gt.getScalingMethod();
        MinMaxObj minMaxObj = this.findPreScaledLimits(axis, scaling, bMustIncludeZero);
        if (minMaxObj != null) {
            return minMaxObj;
        }
        minMaxObj = new MinMaxObj(bMustIncludeZero);
        DataFormat df = this.getDataView().getDataFormat();
        int nItems = df.getNumDataItems();
        if (scaling == 1) {
            if (this.m_Perspective.getStock52WeekHighDisplay() && !this.m_gt.isBipolar()) {
                double f52High = this.m_Perspective.getStock52WeekHighValue();
                minMaxObj.testRawValue(f52High);
            }
            if (this.m_Perspective.getStock52WeekLowDisplay() && !this.m_gt.isBipolar()) {
                double f52Low = this.m_Perspective.getStock52WeekLowValue();
                minMaxObj.testRawValue(f52Low);
            }
            for (int s = 0; s < this.m_nTotalSeries; ++s) {
                if ((axis == 0 || axis == 1) && this.getAxisAssignment(s) != axis) continue;
                for (int g = 0; g < this.m_nTotalGroups; ++g) {
                    for (int i = 0; i < nItems; ++i) {
                        DataItem item = df.getDataItem(i);
                        if (item.ignoreInScaling() || !AxisTemplate.isSameType(item.getAssocAxis(), axis)) continue;
                        DatumObj dObj = this.getDataValue(s, g, item);
                        double fValue = dObj.value;
                        if (!dObj.m_bOK) continue;
                        minMaxObj.testRawValue(fValue);
                    }
                }
            }
        } else {
            throw new RuntimeException("This chart type only works with Absolute scaling!");
        }
        return minMaxObj;
    }

    protected MinMaxObj findVolumeLimits(boolean bMustIncludeZero) {
        MinMaxObj minMaxObj = new MinMaxObj(bMustIncludeZero);
        int scaling = this.m_gt.getScalingMethod();
        if (scaling == 1) {
            SeriesEnumerator seriesIter = SeriesEnumerator.getIterator(this.m_Perspective, this.getDataView());
            int s = seriesIter.get(0);
            assert (s >= 0 && s < this.m_nTotalSeries);
            for (int g = 0; g < this.m_nTotalGroups; ++g) {
                double fValue = this.getVolumeValue(s, g);
                minMaxObj.testRawValue(fValue);
            }
        } else {
            throw new RuntimeException("This chart type only works with Absolute scaling!");
        }
        return minMaxObj;
    }

    private DataItem getCloseItem() {
        DataItem item;
        if (this.m_df == DataFormat.DF_HLC) {
            item = DataItem.DI_HLC_C;
        } else if (this.m_df == DataFormat.DF_HLC_VOL) {
            item = DataItem.DI_HLC_VOL_C;
        } else if (this.m_df == DataFormat.DF_OHLC) {
            item = DataItem.DI_OHLC_C;
        } else if (this.m_df == DataFormat.DF_OHLC_VOL) {
            item = DataItem.DI_OHLC_VOL_C;
        } else if (this.m_df == DataFormat.DF_OC) {
            item = DataItem.DI_OC_C;
        } else if (this.m_df == DataFormat.DF_OC_VOL) {
            item = DataItem.DI_OC_VOL_C;
        } else {
            throw new RuntimeException("getCloseItem used with wrong dataFormat: " + this.m_df.toString());
        }
        return item;
    }

    public double getCloseValue(int s, int g) {
        DataItem item = this.getCloseItem();
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.value;
        }
        throw new RuntimeException();
    }

    protected Point getCoords(int s, int g) {
        int nNumCoord;
        INumericAxis yAxisObj = this.getAxisAssignment(s) == 1 ? this.m_Y2Axis : this.getY1Axis();
        boolean bHasHighLow = this.m_df != DataFormat.DF_OC && this.m_df != DataFormat.DF_OC_VOL;
        int gRel = this.m_gEnumReadOnly.getRelative(g);
        assert (gRel >= 0 && gRel < this.m_nGroups);
        int nOrdCoord = (int)this.getO1Axis().getCenterCoord(gRel);
        if (bHasHighLow) {
            nNumCoord = (int)yAxisObj.getValueCoord(this.getHighValue(s, g));
        } else {
            double fClose = this.getCloseValue(s, g);
            double fOpen = this.getOpenValue(s, g);
            nNumCoord = (int)yAxisObj.getValueCoord(Math.max(fClose, fOpen));
        }
        Point center = this.m_bHorz ? new Point(nNumCoord, nOrdCoord) : new Point(nOrdCoord, nNumCoord);
        return center;
    }

    protected Point getBottomCoords(int s, int g) {
        int nNumCoord;
        INumericAxis yAxisObj = this.getAxisAssignment(s) == 1 ? this.m_Y2Axis : this.getY1Axis();
        boolean bHasHighLow = this.m_df != DataFormat.DF_OC && this.m_df != DataFormat.DF_OC_VOL;
        int gRel = this.m_gEnumReadOnly.getRelative(g);
        assert (gRel >= 0 && gRel < this.m_nGroups);
        int nOrdCoord = (int)this.getO1Axis().getCenterCoord(gRel);
        if (bHasHighLow) {
            nNumCoord = (int)yAxisObj.getValueCoord(this.getLowValue(s, g));
        } else {
            double fClose = this.getCloseValue(s, g);
            double fOpen = this.getOpenValue(s, g);
            nNumCoord = (int)yAxisObj.getValueCoord(Math.min(fClose, fOpen));
        }
        Point center = this.m_bHorz ? new Point(nNumCoord, nOrdCoord) : new Point(nOrdCoord, nNumCoord);
        return center;
    }

    private DataItem getHighItem() {
        DataItem item;
        if (this.m_df == DataFormat.DF_HL) {
            item = DataItem.DI_HL_H;
        } else if (this.m_df == DataFormat.DF_HLO) {
            item = DataItem.DI_HLO_H;
        } else if (this.m_df == DataFormat.DF_HL_VOL) {
            item = DataItem.DI_HL_VOL_H;
        } else if (this.m_df == DataFormat.DF_HLC) {
            item = DataItem.DI_HLC_H;
        } else if (this.m_df == DataFormat.DF_HLC_VOL) {
            item = DataItem.DI_HLC_VOL_H;
        } else if (this.m_df == DataFormat.DF_OHLC) {
            item = this.m_bInterpretAsHLOC ? DataItem.DI_HLOC_H : DataItem.DI_OHLC_H;
        } else if (this.m_df == DataFormat.DF_OHLC_VOL) {
            item = DataItem.DI_OHLC_VOL_H;
        } else {
            throw new RuntimeException("getHighItem used with wrong dataFormat: " + this.m_df.toString());
        }
        return item;
    }

    public double getHighValue(int s, int g) {
        DataItem item = this.getHighItem();
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.value;
        }
        throw new RuntimeException();
    }

    private DataItem getLowItem() {
        DataItem item;
        if (this.m_df == DataFormat.DF_HL) {
            item = DataItem.DI_HL_L;
        } else if (this.m_df == DataFormat.DF_HLO) {
            item = DataItem.DI_HLO_L;
        } else if (this.m_df == DataFormat.DF_HL_VOL) {
            item = DataItem.DI_HL_VOL_L;
        } else if (this.m_df == DataFormat.DF_HLC) {
            item = DataItem.DI_HLC_L;
        } else if (this.m_df == DataFormat.DF_HLC_VOL) {
            item = DataItem.DI_HLC_VOL_L;
        } else if (this.m_df == DataFormat.DF_OHLC) {
            item = this.m_bInterpretAsHLOC ? DataItem.DI_HLOC_L : DataItem.DI_OHLC_L;
        } else if (this.m_df == DataFormat.DF_OHLC_VOL) {
            item = DataItem.DI_OHLC_VOL_L;
        } else {
            throw new RuntimeException("getLowItem used with wrong dataFormat: " + this.m_df.toString());
        }
        return item;
    }

    public double getLowValue(int s, int g) {
        DataItem item = this.getLowItem();
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.value;
        }
        throw new RuntimeException();
    }

    private DataItem getOpenItem() {
        DataItem item;
        if (this.m_df == DataFormat.DF_OHLC) {
            item = this.m_bInterpretAsHLOC ? DataItem.DI_HLOC_O : DataItem.DI_OHLC_O;
        } else if (this.m_df == DataFormat.DF_OHLC_VOL) {
            item = DataItem.DI_OHLC_VOL_O;
        } else if (this.m_df == DataFormat.DF_OC) {
            item = DataItem.DI_OC_O;
        } else if (this.m_df == DataFormat.DF_HLO) {
            item = DataItem.DI_HLO_O;
        } else if (this.m_df == DataFormat.DF_OC_VOL) {
            item = DataItem.DI_OC_VOL_O;
        } else {
            throw new RuntimeException("getOpenItem used with wrong dataFormat: " + this.m_df.toString());
        }
        return item;
    }

    public double getOpenValue(int s, int g) {
        DataItem item = this.getOpenItem();
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.value;
        }
        throw new RuntimeException();
    }

    private DataItem getVolumeItem() {
        DataItem item;
        if (this.m_df == DataFormat.DF_HL_VOL) {
            item = DataItem.DI_HL_VOL_VOL;
        } else if (this.m_df == DataFormat.DF_HLC_VOL) {
            item = DataItem.DI_HLC_VOL_VOL;
        } else if (this.m_df == DataFormat.DF_OHLC_VOL) {
            item = DataItem.DI_OHLC_VOL_VOL;
        } else if (this.m_df == DataFormat.DF_OC_VOL) {
            item = DataItem.DI_OC_VOL_VOL;
        } else {
            throw new RuntimeException("getVolumeItem used with wrong dataFormat: " + this.m_df.toString());
        }
        return item;
    }

    public double getVolumeValue(int s, int g) {
        DataItem item = this.getVolumeItem();
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.value;
        }
        throw new RuntimeException();
    }

    protected boolean isSingleSeriesOnly() {
        boolean bSingleSeries = false;
        if (this.m_gt.isStockCandleType()) {
            bSingleSeries = true;
        }
        if (this.m_bHasVolume) {
            bSingleSeries = true;
        }
        return bSingleSeries;
    }

    public boolean wantLegend() {
        boolean bWantLegend = true;
        if (this.m_gt.isStockCandleType()) {
            bWantLegend = false;
        }
        return bWantLegend;
    }

    public boolean hasHighValue(DataFormat theDataFormat) {
        boolean bHasHighValue = theDataFormat == DataFormat.DF_HL || theDataFormat == DataFormat.DF_HLC || theDataFormat == DataFormat.DF_HLO || theDataFormat == DataFormat.DF_OHLC || theDataFormat == DataFormat.DF_HL_VOL || theDataFormat == DataFormat.DF_HLC_VOL || theDataFormat == DataFormat.DF_OHLC_VOL;
        return bHasHighValue;
    }

    public boolean hasLowValue(DataFormat theDataFormat) {
        boolean bHasLowValue = theDataFormat == DataFormat.DF_HL || theDataFormat == DataFormat.DF_HLC || theDataFormat == DataFormat.DF_HLO || theDataFormat == DataFormat.DF_OHLC || theDataFormat == DataFormat.DF_HL_VOL || theDataFormat == DataFormat.DF_HLC_VOL || theDataFormat == DataFormat.DF_OHLC_VOL;
        return bHasLowValue;
    }

    public boolean hasOpenValue(DataFormat theDataFormat) {
        boolean bHasOpenValue = theDataFormat == DataFormat.DF_OHLC || theDataFormat == DataFormat.DF_OHLC_VOL || theDataFormat == DataFormat.DF_OC || theDataFormat == DataFormat.DF_HLO || theDataFormat == DataFormat.DF_OC_VOL;
        return bHasOpenValue;
    }

    public boolean hasCloseValue(DataFormat theDataFormat) {
        boolean bHasCloseValue = theDataFormat == DataFormat.DF_HLC || theDataFormat == DataFormat.DF_OHLC || theDataFormat == DataFormat.DF_HLC_VOL || theDataFormat == DataFormat.DF_OHLC_VOL || theDataFormat == DataFormat.DF_OC || theDataFormat == DataFormat.DF_OC_VOL;
        return bHasCloseValue;
    }

    public boolean hasVolumeValue(DataFormat theDataFormat) {
        boolean bHasVolumeValue = theDataFormat == DataFormat.DF_HL_VOL || theDataFormat == DataFormat.DF_HLC_VOL || theDataFormat == DataFormat.DF_OHLC_VOL || theDataFormat == DataFormat.DF_OC_VOL;
        return bHasVolumeValue;
    }
}

