/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.border;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.GraphicsUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.RoundRectangleShape;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.border.BorderInfoObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.border.IBorder;
import java.awt.Polygon;

class BevelBorder
implements IBorder {
    protected Perspective m_Perspective;
    protected BorderInfoObj m_borderInfo;

    BevelBorder(Perspective perspective, BorderInfoObj borderInfo) {
        this.m_Perspective = perspective;
        this.m_borderInfo = borderInfo;
        this.m_borderInfo.setupHighlightAndShadowColors();
    }

    public void calc() {
        switch (this.m_borderInfo.m_nBorderType) {
            default: {
                this.createRaisedBevel();
                break;
            }
            case 3: {
                this.createLoweredBevel();
            }
        }
    }

    public boolean isBorderOpaque() {
        return true;
    }

    protected void createRaisedBevel() {
        IBlackBox highLightBlackBox = this.m_borderInfo.copyFromBlackBox(this.m_Perspective);
        IBlackBox shadowBlackBox = this.m_borderInfo.copyFromBlackBox(this.m_Perspective);
        Polygon polyHighLight = new Polygon();
        Polygon polyShadow = new Polygon();
        shadowBlackBox.setTransparentFillColor(false);
        shadowBlackBox.setFillColor(this.m_borderInfo.m_colorShadowInner);
        shadowBlackBox.setTransparentBorderColor(true);
        highLightBlackBox.setTransparentFillColor(false);
        highLightBlackBox.setFillColor(this.m_borderInfo.m_colorHighlightInner);
        highLightBlackBox.setTransparentBorderColor(true);
        RoundRectangleShape borderShape = new RoundRectangleShape(this.m_borderInfo.m_rBoundsVC, this.m_borderInfo.m_nCornerArcHeight, this.m_borderInfo.m_nCornerArcWidth, this.m_borderInfo.m_Inset);
        polyHighLight = GraphicsUtil.toPolygon(borderShape.getClip(2));
        polyShadow = GraphicsUtil.toPolygon(borderShape.getClip(3));
        if (polyHighLight.npoints > 0) {
            DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), this.m_borderInfo.m_idBorder, polyHighLight, highLightBlackBox, null, 1.0);
        }
        if (polyShadow.npoints > 0) {
            DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), this.m_borderInfo.m_idBorder, polyShadow, shadowBlackBox, null, 1.0);
        }
    }

    protected void createLoweredBevel() {
        IBlackBox highLightBlackBox = this.m_borderInfo.copyFromBlackBox(this.m_Perspective);
        IBlackBox shadowBlackBox = this.m_borderInfo.copyFromBlackBox(this.m_Perspective);
        Polygon polyHighLight = new Polygon();
        Polygon polyShadow = new Polygon();
        highLightBlackBox.setTransparentBorderColor(true);
        highLightBlackBox.setFillColor(this.m_borderInfo.m_colorHighlightInner);
        shadowBlackBox.setTransparentBorderColor(true);
        shadowBlackBox.setFillColor(this.m_borderInfo.m_colorShadowInner);
        RoundRectangleShape border = new RoundRectangleShape(this.m_borderInfo.m_rBoundsVC, this.m_borderInfo.m_nCornerArcHeight, this.m_borderInfo.m_nCornerArcWidth, this.m_borderInfo.m_Inset);
        polyHighLight = GraphicsUtil.toPolygon(border.getClip(3));
        polyShadow = GraphicsUtil.toPolygon(border.getClip(2));
        if (polyHighLight.npoints > 0) {
            DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), this.m_borderInfo.m_idBorder, polyHighLight, highLightBlackBox, 1.0);
        }
        if (polyShadow.npoints > 0) {
            DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), this.m_borderInfo.m_idBorder, polyShadow, shadowBlackBox, 1.0);
        }
    }
}

