/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.converter;

import java.awt.Color;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;

public class PatternTable {
    static int[] bits = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256};
    static int[][] table = new int[][]{{136, 136, 136, 136, 136, 136, 136, 136}, {0, 0, 0, 255, 0, 0, 0, 255}, {1, 2, 4, 8, 16, 32, 64, 128}, {128, 64, 32, 16, 8, 4, 2, 1}, {136, 136, 136, 255, 136, 136, 136, 255}, {129, 66, 36, 24, 24, 36, 66, 129}, {85, 170, 85, 170, 85, 170, 85, 170}, {15, 30, 60, 120, 240, 225, 195, 135}, {131, 193, 224, 112, 56, 28, 14, 7}, {255, 255, 0, 0, 255, 255, 0, 0}, {51, 51, 51, 51, 51, 51, 51, 51}, {255, 17, 17, 17, 255, 17, 17, 17}, {255, 1, 1, 1, 1, 1, 1, 1}, {1, 2, 4, 8, 16, 32, 64, 128}, {128, 64, 32, 16, 8, 4, 2, 1}, {255, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1}, {17, 0, 0, 0, 68, 0, 0, 0}, {17, 0, 68, 0, 17, 0, 68, 0}, {85, 0, 85, 0, 85, 0, 85, 0}, {170, 170, 85, 85, 170, 170, 85, 85}, {51, 51, 204, 204, 51, 51, 204, 204}, {129, 66, 36, 24, 24, 36, 66, 129}, {105, 210, 165, 75, 150, 45, 90, 180}, {163, 119, 58, 28, 46, 119, 226, 193}, {64, 32, 16, 8, 4, 8, 16, 32}, {0, 8, 4, 2, 0, 32, 64, 128}, {40, 68, 130, 129, 128, 64, 32, 48}, {31, 17, 17, 17, 17, 241, 17, 17}, {255, 255, 255, 255, 255, 255, 255, 255}, {130, 68, 40, 16, 40, 68, 130, 1}, {255, 0, 0, 0, 0, 0, 0, 0}, {6, 12, 24, 48, 96, 192, 129, 3}, {3, 129, 195, 102, 60, 24, 12, 6}, {193, 34, 28, 34, 193, 34, 28, 34}, {127, 67, 67, 67, 67, 127, 127, 0}, {31, 19, 51, 49, 241, 49, 51, 19}, {0, 170, 0, 85, 0, 170, 0, 85}, {131, 198, 108, 56, 56, 108, 198, 131}, {255, 0, 0, 0, 255, 0, 0, 0}, {255, 17, 17, 17, 255, 17, 17, 17}, {102, 204, 153, 51, 102, 204, 153, 51}, {136, 136, 136, 143, 136, 136, 136, 248}, {153, 102, 17, 17, 102, 153, 68, 68}, {6, 13, 15, 6, 96, 208, 240, 96}, {21, 20, 114, 82, 81, 65, 71, 37}, {85, 170, 85, 170, 85, 170, 85, 170}, {255, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1}, {3, 129, 192, 96, 48, 24, 12, 6}, {15, 15, 15, 15, 240, 240, 240, 240}, {17, 17, 17, 17, 17, 17, 17, 17}, {68, 68, 68, 170, 17, 17, 17, 170}, {255, 5, 255, 5, 5, 5, 5, 5}, {0, 2, 6, 14, 30, 62, 126, 254}, {51, 153, 204, 102, 51, 153, 204, 102}, {51, 51, 204, 204, 51, 51, 204, 204}, {135, 140, 200, 120, 120, 200, 140, 135}, {163, 199, 139, 17, 184, 124, 58, 17}, {66, 7, 66, 224, 66, 7, 66, 224}};

    static int[] getPattern(int i) {
        if (i < 1 || i > 60) {
            return null;
        }
        return table[i - 1];
    }

    static int[] getPattern(TexturePaint paint, Color foreGround) {
        int[] pattern = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        BufferedImage bi = paint.getImage();
        int rgbforeground = foreGround.getRGB();
        if (bi.getWidth() != 8 || bi.getHeight() != 8) {
            return pattern;
        }
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                int bit = bits[y];
                if (bi.getRGB(x, y) != rgbforeground) continue;
                int n = x;
                pattern[n] = pattern[n] + bit;
            }
        }
        return pattern;
    }

    public static Color getPatternColor(TexturePaint paint, Color foreGround) {
        BufferedImage bi = paint.getImage();
        int rgbforeground = foreGround.getRGB();
        for (int y = 0; y < bi.getHeight(); ++y) {
            for (int x = 0; x < bi.getWidth(); ++x) {
                int color = bi.getRGB(x, y);
                if (color == rgbforeground) continue;
                return new Color(color);
            }
        }
        return new Color(0, 0, 0);
    }

    public static short getPatternNumber(TexturePaint paint, Color foreGround) {
        int[] pattern = PatternTable.getPattern(paint, foreGround);
        for (int i = 0; i < table.length; ++i) {
            if (!Arrays.equals(table[i], pattern)) continue;
            return (short)(i + 1);
        }
        return 0;
    }

    public static TexturePaint getTexturePattern(int pattern, Color backGround, Color foreGround) {
        BufferedImage bi = new BufferedImage(8, 8, 1);
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, 8.0, 8.0);
        int[] value = PatternTable.getPattern(pattern);
        for (int y = 0; y < 8; ++y) {
            if (value == null) {
                return null;
            }
            for (int x = 0; x < 8; ++x) {
                int bit = bits[x];
                if ((value[y] & bit) == bit) {
                    bi.setRGB(y, x, foreGround.getRGB());
                    continue;
                }
                bi.setRGB(y, x, backGround.getRGB());
            }
        }
        return new TexturePaint(bi, rect);
    }
}

