/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.converter;

import com.businessobjects.visualization.pfjgraphics.rendering.converter.AdvFormatStruct;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.AnaLineInfoRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.AnodeInfoRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.AreaInstRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.ArrowInfoRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.AxisLookClass;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.BLADepthClass;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.BarLookClass;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.BoxInstRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.BubbleLookClass;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.ColorInstRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.ColorModelStruct;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.ConTextType;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.DataAxisClass;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.DropShadowInstRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.FancyBoxRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.Font3DStruct;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.FontInstRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.FontNameInfo;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.GTextInfoRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.GaugeObjectRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.GaugeRangeRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.GlowInstRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.Graph;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.GroupInfoRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.GrowArray;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.HashInst;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.LineInstRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.MatrixType;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.NewSerDepDataClass;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.PieLookClass;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.PieSerDepDataClass;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.Point3D;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.PolygonInfoRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.RGB16;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.SerDepDataClass;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.SerDepLookClass;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.StockMktLookClass;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.TTFLoadException;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.Tags;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.TimeAxisRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.TimeSeriesInfoRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.UniversalPictureStruct;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.UserLineRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.VisualizeInstRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.WashBandRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.WedgeInfoRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.sfx.AdvancedWashRecord;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.sfx.ColorizeRecord;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.sfx.LayerStruct;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.sfx.PictureRecord;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.sfx.SFXRecord;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.sfx.TextureRecord;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.sfx.WashRecord;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.export.Export3TF;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.log4j.Logger;

class GraphLoader {
    private DataInputStream file;
    private final Tags.FileInfoRec header = new Tags.FileInfoRec();
    public Graph pGraph = new Graph();
    private static final Logger log = Logger.getLogger((String)"com.businessobjects.visualization.pfjgraphics.rendering.converter.GraphLoader");
    private final byte[] twoByteBuffer = new byte[2];
    private final byte[] fourByteBuffer = new byte[4];
    private final byte[] eightByteBuffer = new byte[8];
    static final Set<Integer> includeTags = new HashSet<Integer>(20);
    private boolean minimalLoad = false;
    private int numIncludeTags = -1;
    private int readTags = -1;
    private final Set<String> missingTextureNames = new HashSet<String>();
    private static final Set<Short> skipTags;
    private static final Set<Short> skipDestIds;
    private ByteArrayOutputStream skippedOutStream = null;
    private Export3TF skippedRecords = null;
    private byte[] skippedBytes = null;
    private final int BMP_FILEHEADER_SIZE = 14;
    private final int BMP_INFOHEADER_SIZE = 40;

    public GraphLoader(DataInputStream input) {
        this.file = input;
    }

    public void loadChart() throws TTFLoadException {
        this.loadChart(false);
    }

    public void loadChart(boolean isMinimalLoad) throws TTFLoadException {
        this.missingTextureNames.clear();
        this.minimalLoad = isMinimalLoad;
        this.numIncludeTags = this.minimalLoad ? includeTags.size() : -1;
        try {
            this.load_StructHeader();
            this.initSkippedRecords();
            this.load_GraphContents();
            this.postLoad();
            if (null != this.skippedBytes) {
                this.file = new DataInputStream(new ByteArrayInputStream(this.skippedBytes));
                this.skippedRecords = null;
                this.skippedOutStream = null;
                this.load_StructHeader();
                this.load_GraphContents();
            }
        }
        catch (IOException e) {
            log.error((Object)"Bad TIFF record format.... failed to load the chart");
            throw new TTFLoadException("FailedToLoadChart", e);
        }
    }

    public void setSkipRecordsMode() {
        this.skippedOutStream = new ByteArrayOutputStream();
    }

    public byte[] getSkippedRecords() {
        if (null != this.skippedBytes) {
            return this.skippedBytes;
        }
        if (null != this.skippedOutStream) {
            return this.skippedOutStream.toByteArray();
        }
        return null;
    }

    boolean skipRecord(short tagId, short tagSize) throws IOException {
        if (this.skippedRecords == null || !skipTags.contains(tagId)) {
            return false;
        }
        this.skippedRecords.writeTIFF(tagId, tagSize);
        this.skipBytes(tagSize);
        return true;
    }

    boolean skipRecord(short tagId, short tagSize, short nArrayElement, short nDestID) throws IOException {
        if (this.skippedRecords == null || !skipDestIds.contains(nDestID)) {
            return false;
        }
        this.skippedRecords.writeTIFF(tagId, tagSize);
        this.skippedRecords.writeShort(nArrayElement);
        this.skippedRecords.writeShort(nDestID);
        this.skipBytes(tagSize - 4);
        return true;
    }

    private void skipBytes(int bytes) throws IOException {
        byte[] b = new byte[bytes];
        this.file.readFully(b);
        this.skippedRecords.writeBytes(b);
    }

    private void initSkippedRecords() throws IOException {
        if (this.skippedOutStream != null) {
            this.skippedRecords = new Export3TF(new DataOutputStream(this.skippedOutStream), (byte)this.header.nByteOrder);
            this.skippedRecords.saveHeader();
        }
    }

    private void postLoad() throws IOException {
        if (this.skippedRecords != null && !this.minimalLoad) {
            this.pGraph.fixLookXYFrame();
            this.pGraph.updateColorUsingScheme(this.pGraph.LObj.AreaColors[1].color);
            this.skippedRecords.writeTIFF((short)9999, (short)0);
            this.skippedBytes = this.skippedOutStream.toByteArray();
        }
    }

    public int getMissingTextures() {
        return this.missingTextureNames.size();
    }

    private int parseInt(byte[] string) {
        int value = 0;
        for (int i = 0; i < string.length && string[i] != 0 && string[i] >= 48 && string[i] <= 57; ++i) {
            value = value * 10 + (string[i] - 48);
        }
        return value;
    }

    private void load_StructHeader() throws IOException {
        this.file.readFully(this.header.szFileTypeName);
        byte[] bufRev = new byte[4];
        byte[] bufSub = new byte[4];
        byte[] bufByt = new byte[4];
        byte[] bufFmt = new byte[4];
        byte[] bufTrm = new byte[4];
        byte[] bufUlr = new byte[4];
        this.file.readFully(bufRev);
        this.header.nRevision = this.parseInt(bufRev);
        this.file.readFully(bufSub);
        this.header.nSubRevision = this.parseInt(bufSub);
        this.file.readFully(bufByt);
        this.header.nByteOrder = this.parseInt(bufByt);
        this.file.readFully(bufFmt);
        this.header.nFileFmt = this.parseInt(bufFmt);
        this.file.readFully(bufTrm);
        this.header.bTerminator = this.parseInt(bufTrm);
        this.file.readFully(bufUlr);
        this.header.ulRequestFlag = this.parseInt(bufUlr);
        this.file.skipBytes(222);
        this.pGraph.nRevision = this.header.nRevision;
        this.pGraph.nSubRevision = this.header.nSubRevision;
    }

    private void load_GraphContents() throws TTFLoadException, IOException {
        this.readTags = 0;
        this.load_Terminator();
        while (this.load_Record() && this.readTags != this.numIncludeTags) {
            this.load_Terminator();
        }
        return;
    }

    private void load_Terminator() throws TTFLoadException, IOException {
        if (this.header.bTerminator == 0) {
            return;
        }
        int value = this.readInt32();
        if (value != 1413829197) {
            log.error((Object)"Bad TIFF Record Terminator.... failed to load the chart");
            throw new TTFLoadException("NoTerminatorFoundIn3TF");
        }
    }

    private boolean readBoolean16() throws IOException {
        short value = this.readInt16();
        return value != 0;
    }

    private int readInt32() throws IOException {
        if (this.header.nByteOrder == 1) {
            return this.file.readInt();
        }
        this.file.readFully(this.fourByteBuffer);
        return this.fourByteBuffer[0] & 0xFF | (this.fourByteBuffer[1] & 0xFF) << 8 | (this.fourByteBuffer[2] & 0xFF) << 16 | (this.fourByteBuffer[3] & 0xFF) << 24;
    }

    private byte readByte() throws IOException {
        return this.file.readByte();
    }

    private short readInt16() throws IOException {
        if (this.header.nByteOrder == 1) {
            return this.file.readShort();
        }
        this.file.readFully(this.twoByteBuffer);
        return (short)(this.twoByteBuffer[0] & 0xFF | (this.twoByteBuffer[1] & 0xFF) << 8);
    }

    private int readUInt16() throws IOException {
        if (this.header.nByteOrder == 1) {
            return this.file.readUnsignedShort();
        }
        this.file.readFully(this.twoByteBuffer);
        return (this.twoByteBuffer[0] & 0xFF | (this.twoByteBuffer[1] & 0xFF) << 8) & 0xFFFF;
    }

    private double readDouble() throws IOException {
        if (this.header.nByteOrder == 1) {
            return this.file.readDouble();
        }
        this.file.readFully(this.eightByteBuffer);
        long value = (long)(this.eightByteBuffer[0] & 0xFF) | (long)(this.eightByteBuffer[1] & 0xFF) << 8 | (long)(this.eightByteBuffer[2] & 0xFF) << 16 | (long)(this.eightByteBuffer[3] & 0xFF) << 24 | (long)(this.eightByteBuffer[4] & 0xFF) << 32 | (long)(this.eightByteBuffer[5] & 0xFF) << 40 | (long)(this.eightByteBuffer[6] & 0xFF) << 48 | (long)(this.eightByteBuffer[7] & 0xFF) << 56;
        return Double.longBitsToDouble(value);
    }

    private void readAscii(char[] buffer) throws IOException {
        boolean isUnicode = this.isUnicode();
        this.readAscii(buffer, isUnicode);
    }

    private boolean isUnicode() {
        return this.header.nRevision * 100 + this.header.nSubRevision >= 206;
    }

    private void readAscii(char[] buffer, boolean isUnicode) throws IOException {
        byte c = 0;
        byte d = 0;
        for (int i = 0; i < buffer.length; ++i) {
            c = this.file.readByte();
            if (isUnicode) {
                d = this.file.readByte();
            }
            buffer[i] = (char)(c & 0xFF | (d & 0xFF) << 8);
        }
    }

    private void loadRGB16(RGB16 rgb) throws TTFLoadException, IOException {
        rgb.red = this.readUInt16();
        rgb.green = this.readUInt16();
        rgb.blue = this.readUInt16();
    }

    private boolean load_Record() throws TTFLoadException, IOException {
        short tagId = this.readInt16();
        short tagSize = this.readInt16();
        if (log.isDebugEnabled()) {
            log.debug((Object)(tagId + " (" + tagSize + ") " + Tags.getText(tagId)));
        }
        if (this.skipRecord(tagId, tagSize)) {
            return true;
        }
        if (tagId == 9999) {
            return false;
        }
        if (this.minimalLoad && !includeTags.contains(tagId)) {
            this.skipTag(tagId, tagSize);
            return true;
        }
        ++this.readTags;
        if (tagId >= 1000 && tagId <= 1999) {
            this.loadGraph(tagId, tagSize);
        } else if (tagId >= 2000 && tagId <= 2999) {
            this.loadLook(tagId, tagSize);
        } else if (tagId >= 10000 && tagId <= 10999) {
            this.loadSpecialEffects(tagId, tagSize);
        } else if (tagId >= 9000 && tagId <= 9999) {
            this.loadStandardDraw(tagId, tagSize);
        } else if (tagId >= 3000 && tagId <= 3999) {
            this.loadDataLook(tagId, tagSize);
        } else if (tagId >= 6000 && tagId <= 6999) {
            this.loadStructure(tagId, tagSize);
        } else if (tagId >= 11000 && tagId <= 11007) {
            this.loadThumbnails(tagId, tagSize);
        } else if (tagId == 11100) {
            this.loadExtendedLengthRecord(tagId, tagSize);
        } else if (tagId >= 14000 && tagId <= 14999) {
            this.loadPFJTags(tagId, tagSize);
        } else {
            this.skipTag(tagId, tagSize);
        }
        return true;
    }

    private void loadThumbnails(short tagId, short tagSize) throws IOException {
        if (tagId == 11006) {
            this.loadPictureStruct(tagId, tagSize);
        } else if (tagId == 11007) {
            this.loadUniversalPictureStruct(tagId, tagSize);
        } else {
            this.skipTag(tagId, tagSize);
        }
    }

    private void loadPictureStruct(short tagId, short tagSize) throws IOException {
        String filename = this.readAscii(128);
        String extension = filename.substring(filename.length() - 4, filename.length()).toLowerCase();
        if (extension.equals(".png")) {
            this.Load_PicturePNG();
        } else if (extension.equals(".wmf")) {
            this.Load_PictureWMF(filename);
        } else if (extension.equals(".bmp")) {
            this.EAT_PictureBMP();
        }
        if (!this.pGraph.universalPictureStructMap.containsKey(filename)) {
            this.missingTextureNames.add(filename);
        }
    }

    private void EAT_PictureBMP() throws IOException {
        this.readInt32();
        this.readBoolean16();
        int compressedSize = this.readInt32();
        this.readInt32();
        this.file.skipBytes(compressedSize);
    }

    private void Load_PictureWMF(String filename) throws IOException {
        int size = this.readInt32();
        UniversalPictureStruct ups = this.pGraph.universalPictureStructMap.get(filename);
        if (ups == null) {
            ups = new UniversalPictureStruct();
            this.pGraph.universalPictureStructMap.put(filename, ups);
        }
        ups.filename = filename;
        ups.rawData = new byte[size];
        ups.isMetafile = true;
        for (int i = 0; i < size; ++i) {
            ups.rawData[i] = this.readByte();
        }
    }

    private void Load_PicturePNG() throws IOException {
        int size = this.readInt32();
        byte[] buffer = new byte[size];
        for (int i = 0; i < size; ++i) {
            buffer[i] = this.readByte();
        }
    }

    private void skipPicture(int tagId, int tagSize) throws IOException {
        this.skipTag(tagId, tagSize);
        log.error((Object)"Skipping UniversalPictureStruct... problem encountered");
    }

    private void loadUniversalPictureStruct(short tagId, short tagSize) throws IOException {
        BufferedImage image;
        String filename = this.readAscii(128);
        UniversalPictureStruct ups = this.pGraph.universalPictureStructMap.get(filename);
        if (ups != null) {
            this.skipPicture(tagId, tagSize - 128);
            return;
        }
        ups = new UniversalPictureStruct();
        ups.filename = filename;
        ups.nCompressSize = this.readInt32();
        ups.nCompressionType = this.readInt16();
        ups.nUnCompressSize = this.readInt32();
        ups.nTIFFImageType = this.readInt16();
        ups.nImageFlags = this.readInt32();
        ups.rawData = new byte[ups.nCompressSize];
        this.file.read(ups.rawData);
        byte[] uncompressedBlock = null;
        switch (ups.nCompressionType) {
            default: {
                this.skipPicture(tagId, 0);
                return;
            }
            case 0: {
                uncompressedBlock = ups.rawData;
                break;
            }
            case 1: {
                uncompressedBlock = new byte[ups.nUnCompressSize + 14];
                Inflater decompressor = new Inflater();
                decompressor.setInput(ups.rawData);
                try {
                    decompressor.inflate(uncompressedBlock, 14, ups.nUnCompressSize);
                }
                catch (DataFormatException e) {
                    this.skipPicture(tagId, 0);
                    return;
                }
                decompressor.end();
            }
        }
        if (ups.nTIFFImageType == 3 && uncompressedBlock != null) {
            this.insertBMPFileHeader(ups.nUnCompressSize, uncompressedBlock);
            image = null;
            Iterator<ImageReader> readerIter = ImageIO.getImageReadersByFormatName("BMP");
            if (readerIter.hasNext()) {
                ImageReader reader = readerIter.next();
                reader.setInput(new MemoryCacheImageInputStream(new ByteArrayInputStream(uncompressedBlock)), false, true);
                image = reader.read(0);
            }
            if (image == null) {
                this.skipPicture(tagId, 0);
                return;
            }
        } else {
            this.skipPicture(tagId, 0);
            return;
        }
        ups.image = image;
        this.pGraph.universalPictureStructMap.put(filename, ups);
        this.missingTextureNames.remove(filename);
    }

    private void insertBMPFileHeader(int nUnCompressSize, byte[] uncompressedBlock) {
        uncompressedBlock[0] = 66;
        uncompressedBlock[1] = 77;
        GraphLoader.writeIntLittleEndian(uncompressedBlock, 2, nUnCompressSize + 14);
        GraphLoader.writeIntLittleEndian(uncompressedBlock, 6, 0);
        GraphLoader.writeIntLittleEndian(uncompressedBlock, 10, this.calcPixelDataOffset(uncompressedBlock));
    }

    private int calcPixelDataOffset(byte[] uncompressedBlock) {
        int pixelDataOffset = 54;
        int bpp = GraphLoader.readShortLittleEndian(uncompressedBlock, 28);
        if (8 == bpp) {
            int clrUsed = GraphLoader.readIntLittleEndian(uncompressedBlock, 46);
            pixelDataOffset += clrUsed * 4;
        }
        return pixelDataOffset;
    }

    private static void writeIntLittleEndian(byte[] buffer, int offset, int value) {
        buffer[offset] = (byte)(value & 0xFF);
        buffer[offset + 1] = (byte)(value >> 8 & 0xFF);
        buffer[offset + 2] = (byte)(value >> 16 & 0xFF);
        buffer[offset + 3] = (byte)(value >> 24 & 0xFF);
    }

    private static int readIntLittleEndian(byte[] buffer, int offset) {
        return buffer[offset] + (buffer[offset + 1] << 8) + (buffer[offset + 2] << 16) + (buffer[offset + 3] << 24);
    }

    private static int readShortLittleEndian(byte[] buffer, int offset) {
        return buffer[offset] + (buffer[offset + 1] << 8);
    }

    private void loadExtendedLengthRecord(short tagId, short tagSize) throws IOException, TTFLoadException {
        int totalBytes = this.readInt32();
        int totalBlocks = this.readInt32();
        int blockSize = this.readInt32();
        this.readInt32();
        this.load_Terminator();
        byte[] buffer = this.readExtendedBlocks(totalBytes, totalBlocks, blockSize);
        DataInputStream keepFile = this.file;
        this.file = new DataInputStream(new ByteArrayInputStream(buffer));
        while (this.load_Record()) {
            this.load_Terminator();
        }
        this.file = keepFile;
    }

    private byte[] readExtendedBlocks(int totalBytes, int totalBlocks, int blockSize) throws IOException, TTFLoadException {
        int bytesRead;
        int got;
        int blockCount = 0;
        byte[] buffer = new byte[totalBytes];
        for (bytesRead = 0; blockCount < totalBlocks && bytesRead < totalBytes; bytesRead += got, ++blockCount) {
            short blockTagId = this.readInt16();
            short blockTagSize = this.readInt16();
            if (blockTagId != 11101) {
                log.error((Object)("Missing Extended Record Block: " + blockCount));
                throw new TTFLoadException("MissingExtendedRecordBlock");
            }
            if (blockTagSize < 0 || blockTagSize > blockSize) {
                log.error((Object)("Invalid Extended Record Block Size: " + blockTagSize));
                throw new TTFLoadException("InvalidExtendedRecordBlockSize");
            }
            if (bytesRead + blockTagSize > totalBytes) {
                log.error((Object)("Extended Record Too Long: " + (bytesRead + blockTagSize)));
                throw new TTFLoadException("ExtendedRecordTooLong");
            }
            got = this.file.read(buffer, bytesRead, blockTagSize);
            if (got != blockTagSize) {
                log.error((Object)("Extended Record Read Error for block" + blockCount + ", expected " + blockTagSize + " but we got " + got));
                throw new TTFLoadException("ExtendedRecordReadError");
            }
            this.load_Terminator();
        }
        if (bytesRead != totalBytes || blockCount != totalBlocks) {
            log.error((Object)("Extended Record Read Error, expected " + totalBlocks + " blocks and " + totalBytes + " bytes, but we got " + blockCount + " blocks and " + bytesRead + " bytes"));
            throw new TTFLoadException("ExtendedRecordReadError");
        }
        return buffer;
    }

    private void loadPFJTags(short tagId, short tagSize) throws TTFLoadException, IOException {
        switch (tagId) {
            default: {
                this.skipTag(tagId, tagSize);
                break;
            }
            case 14000: {
                this.pGraph.creationRevision = this.readInt16();
                break;
            }
            case 14001: {
                this.pGraph.creationSubRevision = this.readInt16();
                break;
            }
            case 14002: {
                this.pGraph.nFrameResize = this.readInt16();
            }
        }
    }

    private void loadGraph(short tagId, short tagSize) throws TTFLoadException, IOException {
        switch (tagId) {
            default: {
                this.skipTag(tagId, tagSize);
                break;
            }
            case 1039: {
                this.loadStruct_ConTextType(tagSize);
                break;
            }
            case 1011: {
                this.pGraph.fAspect = this.readDouble();
                break;
            }
            case 1012: {
                this.pGraph.bWarning = this.readBoolean16();
                break;
            }
            case 1013: {
                this.pGraph.BW = this.readBoolean16();
                break;
            }
            case 1038: {
                this.pGraph.nQDRThreshold = this.readInt16();
                break;
            }
            case 1045: {
                this.pGraph.hiMetricsChartWidth = this.readDouble();
                break;
            }
            case 1046: {
                this.pGraph.hiMetricsChartHeight = this.readDouble();
                break;
            }
            case 1047: {
                this.pGraph.DPIResolution = this.readInt16();
                break;
            }
            case 1048: {
                this.pGraph.resolutionUnits = this.readInt16();
                break;
            }
            case 1049: {
                this.pGraph.MDOptions = this.readInt32();
                break;
            }
            case 1051: {
                this.pGraph.bAutoColorByRow = this.readBoolean16();
                break;
            }
            case 1052: {
                this.pGraph.bAdjustFrameForY1Title = this.readBoolean16();
                break;
            }
            case 1053: {
                if (tagSize == 2) {
                    this.pGraph.bShowStackBarConnectLines = this.readBoolean16();
                    break;
                }
                this.skipTag(tagId, tagSize);
                break;
            }
            case 1054: {
                if (tagSize == 2) {
                    this.pGraph.nSplitPosition = this.readInt16();
                    break;
                }
                this.skipTag(tagId, tagSize);
                break;
            }
            case 1056: {
                this.pGraph.nMarkerLayoutMode = this.readInt16();
                break;
            }
            case 1057: {
                this.pGraph.nLegendRows = this.readInt16();
                break;
            }
            case 1058: {
                this.pGraph.nWantSeriesLegend = this.readInt16();
                break;
            }
            case 1059: {
                this.pGraph.bGridLinesOnTop = this.readBoolean16();
                break;
            }
            case 1060: {
                this.pGraph.bLockedLegend = this.readBoolean16();
                break;
            }
            case 1061: {
                this.pGraph.nDefaultLegendIndicator = this.readInt16();
                break;
            }
            case 1062: {
                this.pGraph.QualityMaster.bShowQA_Y1 = this.readBoolean16();
                break;
            }
            case 1063: {
                this.pGraph.QualityMaster.bShowQA_Y2 = this.readBoolean16();
                break;
            }
            case 1064: {
                this.pGraph.QualityMaster.bShowQA_X = this.readBoolean16();
            }
        }
    }

    private void loadLook(short tagId, short tagSize) throws TTFLoadException, IOException {
        switch (tagId) {
            default: {
                this.skipTag(tagId, tagSize);
                break;
            }
            case 2000: {
                assert (tagSize == 2);
                this.pGraph.LObj.nD = this.readInt16();
                break;
            }
            case 2001: {
                assert (tagSize == 2);
                this.pGraph.LObj.nGraphType = this.readInt16();
                break;
            }
            case 2002: {
                this.readAscii(this.pGraph.LObj.szType);
                break;
            }
            case 2003: {
                assert (tagSize == 2);
                this.pGraph.LObj.SubType = this.readInt16();
                break;
            }
            case 2004: {
                assert (tagSize == 2);
                this.pGraph.LObj.bIsDualY = this.readInt16();
                break;
            }
            case 2005: {
                assert (tagSize == 2);
                this.pGraph.LObj.bIsBiPolar = this.readInt16();
                break;
            }
            case 2006: {
                assert (tagSize == 2);
                this.pGraph.LObj.nArea = this.readInt16();
                break;
            }
            case 2010: {
                assert (tagSize == 2);
                this.pGraph.LObj.nLine = this.readInt16();
                break;
            }
            case 2030: {
                this.pGraph.LObj.bLegendWanted = this.readBoolean16();
                break;
            }
            case 2104: {
                this.pGraph.LObj.xPan = this.readInt16();
                break;
            }
            case 2105: {
                this.pGraph.LObj.yPan = this.readInt16();
                break;
            }
            case 2034: {
                this.pGraph.LObj.nLegendElements = this.readInt16();
                break;
            }
            case 2035: {
                this.pGraph.LObj.nLegendLayout = this.readInt16();
                break;
            }
            case 2036: {
                this.pGraph.LObj.bColorByRow = this.readInt16();
                break;
            }
            case 2047: {
                this.pGraph.LObj.bShowTitle = this.readInt16();
                break;
            }
            case 2048: {
                this.pGraph.LObj.bShowSubTitle = this.readInt16();
                break;
            }
            case 2049: {
                this.pGraph.LObj.bShowFootnote = this.readInt16();
                break;
            }
            case 2050: {
                this.pGraph.LObj.bShowXAxisTitle = this.readInt16();
                break;
            }
            case 2051: {
                this.pGraph.LObj.bShowY1AxisTitle = this.readInt16();
                break;
            }
            case 2052: {
                this.pGraph.LObj.bShowY2AxisTitle = this.readInt16();
                break;
            }
            case 2053: {
                this.pGraph.LObj.bShowSeriesTitle = this.readInt16();
                break;
            }
            case 2054: {
                this.pGraph.LObj.bShowGroupsTitle = this.readInt16();
                break;
            }
            case 2055: {
                this.pGraph.LObj.eRiserShape = this.readInt16();
                break;
            }
            case 2084: {
                this.pGraph.LObj.nFrameTableLow = this.readInt16();
                break;
            }
            case 2085: {
                this.pGraph.LObj.nFrameTableHigh = this.readInt16();
                break;
            }
            case 2087: {
                this.pGraph.LObj.RiserDropness = this.readInt16();
                break;
            }
            case 2089: {
                this.pGraph.LObj.MiscHigh = this.readInt16();
                break;
            }
            case 2090: {
                this.pGraph.LObj.nDrawBase = this.readInt16();
                break;
            }
            case 2091: {
                this.pGraph.LObj.nCurveSmooth = this.readInt16();
                break;
            }
            case 2092: {
                this.pGraph.LObj.nCurveMoving = this.readInt16();
                break;
            }
            case 2093: {
                this.pGraph.LObj.bCurveVert = this.readInt16();
                break;
            }
            case 2094: {
                this.pGraph.LObj.bCurveColorAsSeries = this.readInt16();
                break;
            }
            case 2095: {
                this.pGraph.LObj.bSciMovAvg = this.readInt16();
                break;
            }
            case 2096: {
                this.pGraph.LObj.bFromZero = this.readInt16();
                break;
            }
            case 2130: {
                this.pGraph.LObj.nShowQDRLabels = this.readInt16();
                break;
            }
            case 2131: {
                this.pGraph.LObj.nAutoFitQDRLabels = this.readInt16();
                break;
            }
            case 2102: {
                this.pGraph.LObj.Wireframe = this.readInt16();
                break;
            }
            case 2059: {
                this.pGraph.LObj.nEndGrpThick = this.readInt16();
                break;
            }
            case 2060: {
                this.pGraph.LObj.nMarkerSize = this.readInt16();
                break;
            }
            case 2057: {
                this.pGraph.LObj.nInterGrpThick = this.readInt16();
                break;
            }
            case 2058: {
                this.pGraph.LObj.nIntraGrpThick = this.readInt16();
                break;
            }
            case 2056: {
                this.pGraph.LObj.nRiserThick[0] = this.readInt16();
                this.pGraph.LObj.nRiserThick[1] = this.readInt16();
                this.pGraph.LObj.nRiserThick[2] = this.readInt16();
                break;
            }
            case 2101: {
                this.pGraph.LObj.ShowWall[0] = this.readInt16();
                this.pGraph.LObj.ShowWall[1] = this.readInt16();
                this.pGraph.LObj.ShowWall[2] = this.readInt16();
                break;
            }
            case 2103: {
                for (int nX = 0; nX < 3; ++nX) {
                    for (int nY = 0; nY < 3; ++nY) {
                        this.pGraph.LObj.Grid3D[nX][nY] = this.readInt16();
                    }
                }
                break;
            }
            case 2136: {
                this.pGraph.LObj.nCurColor = this.readInt16();
                break;
            }
            case 2137: {
                this.pGraph.LObj.bUniformRiserBorders = this.readInt16();
                break;
            }
            case 2138: {
                this.pGraph.LObj.bUniformRiserShapes = this.readInt16();
                break;
            }
            case 2106: {
                this.pGraph.LObj.RiserTicks[0] = this.readInt16();
                this.pGraph.LObj.RiserTicks[1] = this.readInt16();
                this.pGraph.LObj.RiserTicks[2] = this.readInt16();
                break;
            }
            case 2109: {
                this.pGraph.LObj.IsSafeAngle = this.readInt16();
                break;
            }
            case 2111: {
                this.pGraph.LObj.GraphByWhat = this.readInt16();
                break;
            }
            case 2112: {
                this.pGraph.LObj.IsoValue = this.readInt32();
                break;
            }
            case 2113: {
                this.pGraph.LObj.TextQuality = this.readInt16();
                break;
            }
            case 2114: {
                this.pGraph.LObj.WantAutofit = this.readInt16();
                break;
            }
            case 2116: {
                this.pGraph.LObj.PictQuality = this.readInt16();
                break;
            }
            case 2118: {
                this.pGraph.LObj.bAutoShadeCube = this.readInt16();
                break;
            }
            case 2119: {
                this.pGraph.LObj.bAutoShadeRisers = this.readInt16();
                break;
            }
            case 2236: {
                this.pGraph.LObj.NullBehaviourMask = this.readInt32();
                break;
            }
            case 2235: {
                this.pGraph.LObj.hasAutoPlacementMask = true;
                this.pGraph.LObj.AutoPlacementMask = this.readInt32();
            }
        }
    }

    private void loadSpecialEffects(short tagId, short tagSize) throws IOException, TTFLoadException {
        switch (tagId) {
            default: {
                this.skipTag(tagId, tagSize);
                break;
            }
            case 10020: {
                this.loadStruct_GaugeObjectRec(tagSize);
                break;
            }
            case 10027: {
                this.loadStruct_GaugeObjectRec2(tagSize);
                break;
            }
            case 10021: {
                this.loadStruct_GaugeRangeRec(tagSize);
                break;
            }
            case 10024: {
                this.loadStruct_TimeSeriesInfoRec(tagSize);
                break;
            }
            case 10300: {
                this.loadStruct_TimeAxisRec(tagSize);
                break;
            }
            case 10025: {
                this.loadStruct_TimeSeriesInfoRec_2(tagSize);
                break;
            }
            case 10015: {
                this.LoadStruct_UserLineInfo(tagSize);
                break;
            }
            case 10000: {
                this.loadStruct_SFXRecord(tagSize);
                break;
            }
            case 10001: {
                this.loadStruct_SFXLayerStruct(tagSize);
                break;
            }
            case 10002: 
            case 10003: 
            case 10004: 
            case 10005: 
            case 10006: 
            case 10007: 
            case 10008: 
            case 10009: 
            case 10010: 
            case 10011: {
                this.loadStruct_SFXInfo(tagSize, tagId);
            }
        }
    }

    private void loadStruct_SFXInfo(short tagSize, int tagID) throws IOException, TTFLoadException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)tagID, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        short layerElement = this.readInt16();
        SFXRecord sfxRecord = this.loadSaveUtil_SFXRecordGetPtr(nDestID, nArrayElement);
        LayerStruct layerStruct = this.loadSaveUtil_SFXLayerStructGetPtr(sfxRecord, layerElement);
        if (layerStruct == null) {
            this.skipTag(nDestID, tagSize - 6);
            return;
        }
        switch (tagID) {
            case 10005: {
                this.readInt16();
            }
            case 10006: {
                this.readInt16();
            }
            case 10008: {
                this.readInt16();
            }
            case 10010: {
                this.readInt16();
            }
            case 10004: {
                this.readInt16();
                break;
            }
            case 10009: {
                TextureRecord textureRecord = new TextureRecord();
                textureRecord.pictScale = this.readInt16();
                textureRecord.pictFlip = this.readInt16();
                textureRecord.xExt = this.readInt16();
                textureRecord.yExt = this.readInt16();
                textureRecord.pictName = this.readAscii(64);
                textureRecord.dummy = this.readAscii(64);
                textureRecord.format = this.readInt16();
                layerStruct.effectRecord = textureRecord;
                break;
            }
            case 10007: {
                ColorizeRecord colorizeRecord = new ColorizeRecord();
                colorizeRecord.red = this.readUInt16();
                colorizeRecord.green = this.readUInt16();
                colorizeRecord.blue = this.readUInt16();
                colorizeRecord.percent = this.readInt16();
                layerStruct.effectRecord = colorizeRecord;
                break;
            }
            case 10002: {
                WashRecord washRecord = new WashRecord();
                washRecord.startColor.red = this.readUInt16();
                washRecord.startColor.green = this.readUInt16();
                washRecord.startColor.blue = this.readUInt16();
                washRecord.endColor.red = this.readUInt16();
                washRecord.endColor.green = this.readUInt16();
                washRecord.endColor.blue = this.readUInt16();
                washRecord.startBin = this.readInt16();
                washRecord.endBin = this.readInt16();
                washRecord.washType = this.readInt16();
                washRecord.washDir = this.readInt16();
                washRecord.washScale = this.readInt16();
                layerStruct.effectRecord = washRecord;
                break;
            }
            case 10003: {
                PictureRecord pictureRecord = new PictureRecord();
                pictureRecord.pictScale = this.readInt16();
                pictureRecord.pictFlip = this.readInt16();
                pictureRecord.xExt = this.readInt16();
                pictureRecord.yExt = this.readInt16();
                pictureRecord.pictName = this.readAscii(64);
                pictureRecord.dummy = this.readAscii(64);
                pictureRecord.format = this.readInt16();
                layerStruct.effectRecord = pictureRecord;
                break;
            }
            case 10011: {
                AdvancedWashRecord advWashRecord = new AdvancedWashRecord();
                advWashRecord.startColor.red = this.readUInt16();
                advWashRecord.startColor.green = this.readUInt16();
                advWashRecord.startColor.blue = this.readUInt16();
                advWashRecord.endColor.red = this.readUInt16();
                advWashRecord.endColor.green = this.readUInt16();
                advWashRecord.endColor.blue = this.readUInt16();
                advWashRecord.nOffsetX = this.readInt16();
                advWashRecord.nOffsetY = this.readInt16();
                advWashRecord.nAngle = this.readInt16();
                advWashRecord.nSteps = this.readInt16();
                advWashRecord.nScale = this.readInt16();
                advWashRecord.nWashType = this.readInt16();
                layerStruct.effectRecord = advWashRecord;
            }
        }
    }

    private String readAscii(int i) throws IOException {
        char[] buffer = new char[i];
        this.readAscii(buffer);
        return this.getString(buffer);
    }

    private LayerStruct loadSaveUtil_SFXLayerStructGetPtr(SFXRecord sfxRecord, int layerElement) {
        LayerStruct layerStruct = null;
        if (sfxRecord.aLayer[layerElement] == null) {
            sfxRecord.aLayer[layerElement] = layerStruct = new LayerStruct();
        } else {
            layerStruct = sfxRecord.aLayer[layerElement];
        }
        return layerStruct;
    }

    private void loadStruct_SFXLayerStruct(short tagSize) throws IOException, TTFLoadException {
        SFXRecord sfxRecord;
        LayerStruct layerStruct;
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)10001, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        short layerElement = this.readInt16();
        if (null == this.skippedRecords) {
            ColorInstRec pColor = this.getColorInst(nDestID, nArrayElement);
            assert (pColor != null);
        }
        if ((layerStruct = this.loadSaveUtil_SFXLayerStructGetPtr(sfxRecord = this.loadSaveUtil_SFXRecordGetPtr(nDestID, nArrayElement), layerElement)) == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        layerStruct.effectType = this.readInt16();
        layerStruct.offsetX = this.readInt16();
        layerStruct.offsetY = this.readInt16();
        layerStruct.user1 = this.readInt16();
        layerStruct.user2 = this.readInt16();
        for (int i = 0; i < 8; ++i) {
            layerStruct.reserved[i] = this.readInt16();
        }
    }

    private void loadStruct_SFXRecord(short tagSize) throws IOException, TTFLoadException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)10000, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        SFXRecord sfxRecord = this.loadSaveUtil_SFXRecordGetPtr(nDestID, nArrayElement);
        if (sfxRecord == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        sfxRecord.version = this.readInt16();
        sfxRecord.layerCount = this.readInt16();
    }

    private SFXRecord loadSaveUtil_SFXRecordGetPtr(int nDestID, int nArrayElement) throws TTFLoadException {
        SFXRecord sfxRecord = new SFXRecord();
        ColorInstRec colorInstRec = null;
        switch (nDestID) {
            case 2107: {
                colorInstRec = this.pGraph.LObj.Font3D[nArrayElement].FontInst.color;
                break;
            }
            case 2015: {
                colorInstRec = this.pGraph.LObj.Title.color;
                break;
            }
            case 2016: {
                colorInstRec = this.pGraph.LObj.SubTitle.color;
                break;
            }
            case 2017: {
                colorInstRec = this.pGraph.LObj.Header1.color;
                break;
            }
            case 2018: {
                colorInstRec = this.pGraph.LObj.Header2.color;
                break;
            }
            case 2019: {
                colorInstRec = this.pGraph.LObj.Header3.color;
                break;
            }
            case 2020: {
                colorInstRec = this.pGraph.LObj.Header4.color;
                break;
            }
            case 2021: {
                colorInstRec = this.pGraph.LObj.TitleXAxis.color;
                break;
            }
            case 2022: {
                colorInstRec = this.pGraph.LObj.TitleY1Axis.color;
                break;
            }
            case 2023: {
                colorInstRec = this.pGraph.LObj.TitleY2Axis.color;
                break;
            }
            case 2024: {
                colorInstRec = this.pGraph.LObj.Label1.color;
                break;
            }
            case 2025: {
                colorInstRec = this.pGraph.LObj.Label2.color;
                break;
            }
            case 2026: {
                colorInstRec = this.pGraph.LObj.Label3.color;
                break;
            }
            case 2027: {
                colorInstRec = this.pGraph.LObj.Footnote.color;
                break;
            }
            case 1017: 
            case 1042: 
            case 2007: 
            case 2132: 
            case 3034: 
            case 3048: 
            case 3052: 
            case 12015: 
            case 12016: 
            case 12017: 
            case 12018: 
            case 12019: 
            case 12020: 
            case 12021: 
            case 12022: 
            case 12023: 
            case 12024: 
            case 12025: 
            case 12026: 
            case 12027: 
            case 12028: 
            case 12029: 
            case 12030: 
            case 12031: 
            case 12032: 
            case 12137: 
            case 12154: 
            case 12155: 
            case 12156: 
            case 12169: 
            case 12170: 
            case 12172: 
            case 12269: 
            case 12270: 
            case 30527: 
            case 31527: {
                AreaInstRec areaInstRec = this.loadSaveUtil_AreaInstRecGetPtr(nDestID, nArrayElement);
                if (areaInstRec == null) break;
                colorInstRec = areaInstRec.color;
                break;
            }
            case 1041: 
            case 1043: 
            case 2133: 
            case 2146: {
                LineInstRec lineInstRec = this.loadSaveUtil_LineInstRecGetPtr(nDestID, nArrayElement);
                if (lineInstRec == null) break;
                colorInstRec = lineInstRec.color;
                break;
            }
            case 1019: 
            case 1044: 
            case 1050: 
            case 2147: {
                FontInstRec fontInstRec = this.loadSaveUtil_FontInstRecGetPtr(nDestID, nArrayElement);
                if (fontInstRec == null) break;
                colorInstRec = fontInstRec.color;
                break;
            }
        }
        if (colorInstRec == null) {
            sfxRecord = null;
        } else if (colorInstRec.hMaytag == null) {
            colorInstRec.hMaytag = sfxRecord = new SFXRecord();
        } else {
            sfxRecord = colorInstRec.hMaytag;
        }
        return sfxRecord;
    }

    private void loadStruct_TimeAxisRec(short tagSize) throws IOException, TTFLoadException {
        this.readInt16();
        this.readInt16();
        TimeAxisRec timeAxis = this.pGraph.TimeAxis;
        timeAxis.bShowTimeAxis = this.readBoolean16();
        timeAxis.fTimeAxisMinimum = this.readDouble();
        timeAxis.fTimeAxisMaximum = this.readDouble();
        timeAxis.nBaseUnit = this.readInt16();
        timeAxis.nMajorInterval = this.readInt16();
        timeAxis.nMajorUnit = this.readInt16();
        timeAxis.nMinorInterval = this.readInt16();
        timeAxis.nMinorUnit = this.readInt16();
        timeAxis.bAutomaticMinimum = this.readBoolean16();
        timeAxis.bAutomaticMaximum = this.readBoolean16();
        timeAxis.bAutomaticBaseUnit = this.readBoolean16();
        timeAxis.bAutomaticMajorUnit = this.readBoolean16();
        timeAxis.bAutomaticMinorUnit = this.readBoolean16();
        timeAxis.bXYData = this.readBoolean16();
    }

    private void loadStruct_TimeSeriesInfoRec(short tagSize) throws IOException, TTFLoadException {
        this.readInt16();
        this.readInt16();
        TimeSeriesInfoRec timeSeries = this.pGraph.timeSeriesInfo;
        timeSeries.bShowHistoryRange = this.readBoolean16();
        timeSeries.bShowForecastRange = this.readBoolean16();
    }

    private void loadStruct_TimeSeriesInfoRec_2(short tagSize) throws IOException, TTFLoadException {
        this.readInt16();
        this.readInt16();
        TimeSeriesInfoRec timeSeries = this.pGraph.timeSeriesInfo;
        timeSeries.bShowHistoryRange = this.readBoolean16();
        timeSeries.bShowForecastRange = this.readBoolean16();
        timeSeries.bShowHistoryBox = this.readBoolean16();
        timeSeries.bShowForecastBox = this.readBoolean16();
        timeSeries.historyBox.xULC = this.readInt16();
        timeSeries.historyBox.yULC = this.readInt16();
        timeSeries.historyBox.xLRC = this.readInt16();
        timeSeries.historyBox.yLRC = this.readInt16();
        timeSeries.forecastBox.xULC = this.readInt16();
        timeSeries.forecastBox.yULC = this.readInt16();
        timeSeries.forecastBox.xLRC = this.readInt16();
        timeSeries.forecastBox.yLRC = this.readInt16();
        timeSeries.bShowPredictions = this.readBoolean16();
    }

    private void loadStruct_GaugeRangeRec(short tagSize) throws IOException, TTFLoadException {
        short nArrayElement = this.readInt16();
        this.readInt16();
        this.pGraph.gauge.Range[nArrayElement] = (GaugeRangeRec)this.getInstance(this.pGraph.gauge.Range[nArrayElement], GaugeRangeRec.class);
        GaugeRangeRec gaugeRange = this.pGraph.gauge.Range[nArrayElement];
        gaugeRange.bShowRange = this.readBoolean16();
        gaugeRange.fRangeStart = this.readDouble();
        gaugeRange.fRangeEnd = this.readDouble();
    }

    private void loadStruct_GaugeObjectRec(short tagSize) throws IOException {
        this.readInt16();
        this.readInt16();
        GaugeObjectRec gauge = this.pGraph.gauge;
        gauge.bShow = this.readBoolean16();
        gauge.nStartAngle = this.readInt16();
        gauge.nStopAngle = this.readInt16();
        gauge.bClockwise = this.readBoolean16();
        gauge.bBlend = this.readBoolean16();
        gauge.nSeriesAttach = this.readInt16();
        gauge.nThickness = this.readInt16();
        gauge.nGaugeStyle = this.readInt16();
        gauge.nNeedleStyle = this.readInt16();
        gauge.bShowGaugeMajorInterval = this.readBoolean16();
        gauge.bShowGaugeMinorInterval = this.readBoolean16();
        gauge.bAutoScaleGaugeIntervals = this.readBoolean16();
        gauge.bShowGaugeLabel = this.readBoolean16();
        gauge.bShowIntervalLabels = this.readBoolean16();
        gauge.bShowRangeLabels = this.readBoolean16();
        gauge.fGaugeNeedleValue = this.readDouble();
        gauge.fGaugeMax = this.readDouble();
        gauge.fGaugeMin = this.readDouble();
        gauge.fGaugeMajorInterval = this.readDouble();
        gauge.fGaugeMinorInterval = this.readDouble();
        this.readAscii(gauge.szGaugeLabel);
    }

    private void loadStruct_GaugeObjectRec2(short tagSize) throws IOException {
        this.readInt16();
        this.readInt16();
        GaugeObjectRec gauge = this.pGraph.gauge;
        gauge.nStartAngle = this.readInt16();
        gauge.nStopAngle = this.readInt16();
        gauge.bClockwise = this.readBoolean16();
        gauge.bBlend = this.readBoolean16();
        gauge.nThickness = this.readInt16();
        gauge.nGaugeStyle = this.readInt16();
        gauge.nNeedleStyle = this.readInt16();
        gauge.bShowRangeLabels = this.readBoolean16();
    }

    private void loadStandardDraw(short tagId, short tagSize) throws TTFLoadException, IOException {
        switch (tagId) {
            default: {
                this.skipTag(tagId, tagSize);
                break;
            }
            case 9004: {
                this.loadStruct_AreaInstRec(tagSize);
                break;
            }
            case 9001: {
                this.loadStruct_ColorInstRec(tagSize);
                break;
            }
            case 9002: {
                this.loadStruct_DropShadowInstRec(tagSize);
                break;
            }
            case 9003: {
                this.loadStruct_LineInstRec(tagSize);
                break;
            }
            case 9005: {
                this.loadStruct_FontInstRec(tagId, tagSize, 1);
                break;
            }
            case 9014: {
                this.loadStruct_FontInstRec(tagId, tagSize, 3);
                break;
            }
            case 9015: {
                this.loadStruct_FontInstRec(tagId, tagSize, 4);
                break;
            }
            case 9016: {
                this.loadStruct_FontInstRec(tagId, tagSize, 5);
                break;
            }
            case 9017: {
                this.loadStruct_FontInstRec(tagId, tagSize, 6);
                break;
            }
            case 9006: {
                this.loadStruct_BoxInstRec(tagSize);
                break;
            }
            case 9008: {
                this.loadStruct_FontNameInfo(tagSize);
                break;
            }
            case 9019: {
                this.loadStruct_GlowInstRec(tagSize);
                break;
            }
            case 9007: {
                this.loadStruct_WashBandRec(tagSize);
            }
        }
    }

    private void loadStruct_GlowInstRec(short tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)9019, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        LineInstRec line = this.loadSaveUtil_LineInstRecGetPtr(nDestID, nArrayElement);
        if (line == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        GlowInstRec glow = line.glow;
        glow.bGlow = this.readBoolean16();
        glow.nThick = this.readInt16();
        glow.nMode = this.readInt16();
        glow.nRed = this.readInt16();
        glow.nGreen = this.readInt16();
        glow.nBlue = this.readInt16();
    }

    private void loadStructure(short tagId, short tagSize) throws TTFLoadException, IOException {
        switch (tagId) {
            default: {
                this.skipTag(tagId, tagSize);
                break;
            }
            case 6048: {
                this.LoadStruct_FancyBox(tagSize);
                break;
            }
            case 6012: {
                this.LoadStruct_dPoint3D(tagSize);
                break;
            }
            case 6013: {
                this.LoadStruct_fMatrixType(tagSize);
                break;
            }
            case 6024: {
                this.loadStruct_DataAxisClass(tagSize);
                break;
            }
            case 6000: {
                this.loadStruct_AxisLookClass(tagId, tagSize, 0);
                break;
            }
            case 6049: {
                this.loadStruct_AxisLookClass(tagId, tagSize, 1);
                break;
            }
            case 6060: {
                this.loadStruct_AxisLookClass(tagId, tagSize, 2);
                break;
            }
            case 6011: {
                this.loadStruct_HashInst(tagSize);
                break;
            }
            case 6015: {
                this.loadStruct_Font3D(tagSize);
                break;
            }
            case 6004: {
                this.loadStruct_PieLookClass(tagId, tagSize, false);
                break;
            }
            case 6062: {
                this.loadStruct_PieLookClass(tagId, tagSize, true);
                break;
            }
            case 6005: {
                this.loadStruct_BarLookClass(tagSize);
                break;
            }
            case 6031: {
                this.loadStruct_AnodeInfoRec(tagSize);
                break;
            }
            case 6032: {
                this.loadStruct_AnaLineInfoRec(tagSize);
                break;
            }
            case 6038: {
                this.loadStruct_GTextInfoRec(tagSize);
                break;
            }
            case 6033: {
                this.loadStruct_PolygonInfoRec(tagSize);
                break;
            }
            case 6034: {
                this.loadStruct_WedgeInfoRec(tagSize);
                break;
            }
            case 6039: {
                this.loadStruct_ArrowInfoRec(tagSize);
                break;
            }
            case 6040: {
                this.loadStruct_GroupInfoRec(tagSize);
                break;
            }
            case 6035: {
                this.loadStruct_Polygon(tagSize);
                break;
            }
            case 6007: {
                this.loadStruct_BLADepth(tagSize);
                break;
            }
            case 6008: {
                this.loadStruct_BubbleLookClass(tagSize);
                break;
            }
            case 6010: {
                this.loadStruct_StockMktLookClass(tagSize);
                break;
            }
            case 6050: {
                this.loadStruct_AdvFormatStruct(tagSize);
                if (this.header.nSubRevision > 3) break;
                this.header.nSubRevision = 4;
                break;
            }
            case 6025: {
                this.loadStruct_SerDepDataClass(tagId, tagSize, 1);
                break;
            }
            case 6063: {
                this.loadStruct_SerDepDataClass(tagId, tagSize, 2);
                break;
            }
            case 6026: {
                this.loadStruct_PieSerDepDataClass(tagSize);
                break;
            }
            case 6044: {
                this.loadStruct_NewSerDepDataClass(tagSize);
                break;
            }
            case 6020: {
                this.loadStruct_VarArrayINT16(tagSize);
                break;
            }
            case 6019: {
                this.loadStruct_ColorModelStruct(tagSize);
                break;
            }
            case 6021: {
                this.loadStruct_SerDepLookClass(tagId, tagSize, 1);
                break;
            }
            case 6061: {
                this.loadStruct_SerDepLookClass(tagId, tagSize, 2);
                break;
            }
            case 6037: {
                this.loadStruct_Text(tagSize);
            }
        }
    }

    private void loadStruct_Polygon(short tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6035, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        PolygonInfoRec poly = null;
        switch (nDestID) {
            case 1014: {
                AnodeInfoRec anode = this.pGraph.annotations.allocateAt(nArrayElement);
                poly = anode.poly;
            }
        }
        if (poly == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        this.readInt16();
        poly.numPoints = (tagSize - 14) / 4;
        poly.polyBBox.yULC = this.readInt16();
        poly.polyBBox.xULC = this.readInt16();
        poly.polyBBox.yLRC = this.readInt16();
        poly.polyBBox.xLRC = this.readInt16();
        poly.polyPoints = new Point[poly.numPoints];
        for (int i = 0; i < poly.numPoints; ++i) {
            short y = this.readInt16();
            short x = this.readInt16();
            poly.polyPoints[i] = new Point(x, y);
        }
    }

    private void loadStruct_Text(short tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6037, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        char[] c = null;
        switch (nDestID) {
            case 1014: {
                c = this.isUnicode() ? new char[(tagSize - 4) / 2] : new char[tagSize - 4];
                this.readAscii(c);
                AnodeInfoRec anode = this.pGraph.annotations.allocateAt(nArrayElement);
                anode.text.text = this.getString(c);
            }
        }
        if (c == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
    }

    private void LoadStruct_dPoint3D(short tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6012, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        Point3D point = null;
        switch (nDestID) {
            case 2097: {
                point = this.pGraph.LObj.Viewer;
                break;
            }
            case 2099: {
                point = this.pGraph.LObj.Size3D;
                break;
            }
            case 2100: {
                point = this.pGraph.LObj.Wall3D;
            }
        }
        if (point == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        point.x = this.readInt32();
        point.y = this.readInt32();
        point.z = this.readInt32();
    }

    private void loadStruct_SerDepLookClass(short tagId, short tagSize, int version) throws IOException, TTFLoadException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord(tagId, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        SerDepLookClass seriesDependentLook = null;
        switch (nDestID) {
            case 2139: {
                seriesDependentLook = this.pGraph.LObj.vaSerDepLook.allocateAt(nArrayElement);
            }
        }
        if (seriesDependentLook == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        if (version == 1) {
            seriesDependentLook.bShow_Y_ErrorBar = this.readBoolean16();
            seriesDependentLook.nDataLineType = this.readInt16();
            seriesDependentLook.bShow_Y_ErrorBar = false;
            seriesDependentLook.bShow_X_ErrorBar = false;
        } else {
            assert (version == 2);
            seriesDependentLook.bShow_Y_ErrorBar = this.readBoolean16();
            seriesDependentLook.bShow_X_ErrorBar = this.readBoolean16();
            seriesDependentLook.nDataLineType = this.readInt16();
            seriesDependentLook.ErrorBarInfo.fErrorBarYPlus = this.readDouble();
            seriesDependentLook.ErrorBarInfo.fErrorBarYMinus = this.readDouble();
            seriesDependentLook.ErrorBarInfo.nYMode = this.readInt16();
            seriesDependentLook.ErrorBarInfo.nYType = this.readInt16();
            seriesDependentLook.ErrorBarInfo.nYHatSize = this.readInt16();
            seriesDependentLook.ErrorBarInfo.nYStdDevMult = this.readInt16();
            seriesDependentLook.ErrorBarInfo.fErrorBarXPlus = this.readDouble();
            seriesDependentLook.ErrorBarInfo.fErrorBarXMinus = this.readDouble();
            seriesDependentLook.ErrorBarInfo.nXMode = this.readInt16();
            seriesDependentLook.ErrorBarInfo.nXType = this.readInt16();
            seriesDependentLook.ErrorBarInfo.nXHatSize = this.readInt16();
            seriesDependentLook.ErrorBarInfo.nXStdDevMult = this.readInt16();
        }
    }

    private void loadStruct_WashBandRec(short tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)9007, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        WashBandRec washBandInfo = null;
        switch (nDestID) {
            case 1002: {
                washBandInfo = this.pGraph.washBands[nArrayElement];
            }
        }
        if (washBandInfo == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        washBandInfo.startBin = this.readInt16();
        washBandInfo.endBin = this.readInt16();
    }

    private void loadStruct_AnodeInfoRec(int tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6031, (short)tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        AnodeInfoRec anodeInfo = null;
        switch (nDestID) {
            case 1014: {
                anodeInfo = this.pGraph.annotations.allocateAt(nArrayElement);
            }
        }
        if (anodeInfo == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        anodeInfo.NodeType = this.readInt16();
        anodeInfo.group = this.readInt16();
        anodeInfo.bounds.yULC = this.readInt16();
        anodeInfo.bounds.xULC = this.readInt16();
        anodeInfo.bounds.yLRC = this.readInt16();
        anodeInfo.bounds.xLRC = this.readInt16();
        anodeInfo.linkSeries = this.readInt16();
        anodeInfo.linkGroup = this.readInt16();
        anodeInfo.linkRect.yULC = this.readInt16();
        anodeInfo.linkRect.xULC = this.readInt16();
        anodeInfo.linkRect.yLRC = this.readInt16();
        anodeInfo.linkRect.xLRC = this.readInt16();
    }

    private void loadStruct_Font3D(short tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6015, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        Font3DStruct font = null;
        switch (nDestID) {
            case 2107: {
                font = this.pGraph.LObj.Font3D[nArrayElement];
                if (font != null) break;
                this.pGraph.LObj.Font3D[nArrayElement] = font = new Font3DStruct();
            }
        }
        if (font == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        font.Size = this.readInt16();
        font.Width = this.readInt16();
        font.Margin = this.readInt16();
        font.Leader = this.readInt16();
        font.FColor = this.readInt16();
        font.BColor = this.readInt16();
        font.Border = this.readInt16();
        font.HeaderOffset = this.readInt16();
        font.AutoFit = this.readBoolean16();
        font.ShowBox = this.readBoolean16();
        font.ShowMe = this.readBoolean16();
        font.TextOnWall = this.readBoolean16();
        font.bFixedSize = this.readBoolean16();
        font.n2DSize = this.readInt16();
        font.nTemp = this.readInt16();
    }

    private void loadStruct_ColorInstRec(short tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)9001, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        ColorInstRec pColor = this.getColorInst(nDestID, nArrayElement);
        if (pColor == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        pColor.useMaytag = this.readBoolean16();
        pColor.nBin = this.readInt16();
        pColor.nSpectrumBin = this.readInt16();
        pColor.nRed = this.readUInt16();
        pColor.nGreen = this.readUInt16();
        pColor.nBlue = this.readUInt16();
        pColor.nAlpha = 255;
    }

    private ColorInstRec getColorInst(int nDestID, int nArrayElement) throws TTFLoadException {
        FontInstRec pFont = this.loadSaveUtil_FontInstRecGetPtr(nDestID, nArrayElement);
        if (pFont != null) {
            return pFont.color;
        }
        LineInstRec pLine = this.loadSaveUtil_LineInstRecGetPtr(nDestID, nArrayElement);
        if (pLine != null) {
            return pLine.color;
        }
        AreaInstRec pArea = this.loadSaveUtil_AreaInstRecGetPtr(nDestID, nArrayElement);
        if (pArea != null) {
            return pArea.color;
        }
        VisualizeInstRec pVis = this.loadSaveUtil_VisualizeInstRecGetPtr(nDestID, nArrayElement);
        if (pVis != null) {
            return pVis.glowColor;
        }
        if (nDestID == 12150) {
            if (this.pGraph.ColorScheme[nArrayElement] == null) {
                this.pGraph.ColorScheme[nArrayElement] = new ColorInstRec();
            }
            return this.pGraph.ColorScheme[nArrayElement];
        }
        return null;
    }

    private BLADepthClass loadSaveUtil_BLADepthClassGetPtr(int nDestID, int nArrayElement) {
        BLADepthClass blaDepth = null;
        switch (nDestID) {
            case 2073: {
                blaDepth = this.pGraph.LObj.BLADepth;
            }
        }
        return blaDepth;
    }

    private void loadStruct_AnaLineInfoRec(int tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6032, (short)tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        AnodeInfoRec annotationInfo = null;
        AnaLineInfoRec lineInfo = null;
        switch (nDestID) {
            case 1014: {
                annotationInfo = this.pGraph.annotations.allocateAt(nArrayElement);
                lineInfo = annotationInfo.line;
            }
        }
        if (lineInfo == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        lineInfo.p1.y = this.readInt16();
        lineInfo.p1.x = this.readInt16();
        lineInfo.p2.y = this.readInt16();
        lineInfo.p2.x = this.readInt16();
        lineInfo.thickness = this.readInt16();
        lineInfo.arrowAtStart = this.readInt16();
        lineInfo.arrowAtEnd = this.readInt16();
        lineInfo.arrowSize = this.readInt16();
    }

    private void LoadStruct_fMatrixType(int tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6013, (short)tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        MatrixType matrix = null;
        switch (nDestID) {
            case 2098: {
                matrix = this.pGraph.LObj.fMatrix;
            }
        }
        if (matrix == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 3; ++y) {
                matrix.value[x][y] = this.readDouble();
            }
        }
    }

    private void loadStruct_PolygonInfoRec(int tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6033, (short)tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        AnodeInfoRec annotationInfo = null;
        PolygonInfoRec polyInfo = null;
        switch (nDestID) {
            case 1014: {
                annotationInfo = this.pGraph.annotations.allocateAt(nArrayElement);
                polyInfo = annotationInfo.poly;
            }
        }
        if (polyInfo == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        polyInfo.closed = this.readBoolean16();
    }

    private void loadStruct_WedgeInfoRec(int tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6034, (short)tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        AnodeInfoRec annotationInfo = null;
        WedgeInfoRec wedgeInfo = null;
        switch (nDestID) {
            case 1014: {
                annotationInfo = this.pGraph.annotations.allocateAt(nArrayElement);
                wedgeInfo = annotationInfo.wedge;
            }
        }
        if (wedgeInfo == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        wedgeInfo.bounds.top = this.readInt16();
        wedgeInfo.bounds.left = this.readInt16();
        wedgeInfo.bounds.bottom = this.readInt16();
        wedgeInfo.bounds.right = this.readInt16();
        wedgeInfo.ptStart.y = this.readInt16();
        wedgeInfo.ptStart.x = this.readInt16();
        wedgeInfo.ptEnd.y = this.readInt16();
        wedgeInfo.ptEnd.x = this.readInt16();
        wedgeInfo.fStartAngle = this.readDouble();
        wedgeInfo.fEndAngle = this.readDouble();
        wedgeInfo.nRing = this.readInt16();
        wedgeInfo.nHeight = this.readInt16();
    }

    private void loadStruct_GTextInfoRec(int tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6038, (short)tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        AnodeInfoRec annotationInfo = null;
        GTextInfoRec textInfo = null;
        switch (nDestID) {
            case 1014: {
                annotationInfo = this.pGraph.annotations.allocateAt(nArrayElement);
                textInfo = annotationInfo.text;
            }
        }
        if (textInfo == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        textInfo.leftInd = this.readInt16();
        textInfo.topInd = this.readInt16();
        textInfo.rightInd = this.readInt16();
        textInfo.bottomInd = this.readInt16();
        textInfo.hPct = this.readInt16();
        textInfo.vPct = this.readInt16();
        textInfo.SpikeWidth = this.readInt16();
        textInfo.bTopInd = this.readInt16();
        textInfo.bSides = this.readInt16();
        textInfo.bulTxtSpc = this.readInt16();
        textInfo.bShape = this.readInt16();
        textInfo.thickness = this.readInt16();
    }

    private void loadStruct_ArrowInfoRec(int tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6039, (short)tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        AnodeInfoRec annotationInfo = null;
        ArrowInfoRec arrowInfo = null;
        switch (nDestID) {
            case 1014: {
                annotationInfo = this.pGraph.annotations.allocateAt(nArrayElement);
                arrowInfo = annotationInfo.arrow;
            }
        }
        if (arrowInfo == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        arrowInfo.p0.y = this.readInt16();
        arrowInfo.p0.x = this.readInt16();
        arrowInfo.p1.y = this.readInt16();
        arrowInfo.p1.x = this.readInt16();
        arrowInfo.angle = this.readDouble();
        arrowInfo.headSides = this.readInt16();
        arrowInfo.headIndent = this.readInt16();
        arrowInfo.headWidth = this.readInt16();
        arrowInfo.tailIndent = this.readInt16();
        arrowInfo.tailWidth = this.readInt16();
    }

    private void loadStruct_GroupInfoRec(int tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6040, (short)tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        AnodeInfoRec annotationInfo = null;
        GroupInfoRec groupInfo = null;
        switch (nDestID) {
            case 1014: {
                annotationInfo = this.pGraph.annotations.allocateAt(nArrayElement);
                groupInfo = annotationInfo.groupInfo;
            }
        }
        if (groupInfo == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        groupInfo.children = this.readInt16();
    }

    private void loadStruct_DataAxisClass(int tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6024, (short)tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        DataAxisClass dataAxis = null;
        switch (nDestID) {
            case 3027: {
                dataAxis = this.pGraph.DLObj.X1Data;
                break;
            }
            case 3028: {
                dataAxis = this.pGraph.DLObj.Y1Data;
                break;
            }
            case 3029: {
                dataAxis = this.pGraph.DLObj.Y2Data;
                break;
            }
            case 3030: {
                dataAxis = this.pGraph.DLObj.Z1Data;
            }
        }
        if (dataAxis == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        dataAxis.nManualScale = this.readInt16();
        dataAxis.fManualScaleMin = this.readDouble();
        dataAxis.fManualScaleMax = this.readDouble();
        dataAxis.bManualMajorHash = this.readBoolean16();
        dataAxis.nMajorHashCount = this.readInt16();
        dataAxis.bManualMinorHash = this.readBoolean16();
        dataAxis.nMinorHashCount = this.readInt16();
        dataAxis.bIsLog = this.readBoolean16();
        dataAxis.fRawMin = this.readDouble();
        dataAxis.fRawMax = this.readDouble();
        dataAxis.nStdFormat = this.readInt16();
        dataAxis.nStdFormatDTXT = this.readInt16();
        dataAxis.bShowOffScale = this.readBoolean16();
        dataAxis.bAutoExcludeZero = this.readBoolean16();
    }

    private void loadStruct_BLADepth(int tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6007, (short)tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        BLADepthClass blaDepth = this.loadSaveUtil_BLADepthClassGetPtr(nDestID, nArrayElement);
        if (blaDepth == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        blaDepth.nDepthMode = this.readInt16();
        blaDepth.nAngle = this.readInt16();
        blaDepth.nDepth = this.readInt16();
        blaDepth.nRotateX = this.readInt16();
        blaDepth.nRotateY = this.readInt16();
        blaDepth.nRotateZ = this.readInt16();
        blaDepth.nZView = this.readInt32();
        blaDepth.nZProject = this.readInt32();
        blaDepth.nColorMode = this.readInt16();
    }

    private HashInst loadSaveUtil_HashInstGetPtr(int nDestID, int nArrayElement) {
        HashInst hashInst = null;
        switch (nDestID) {
            case 2061: {
                hashInst = this.pGraph.LObj.Y1Axis.ZeroLine;
                break;
            }
            case 2062: {
                hashInst = this.pGraph.LObj.Y2Axis.ZeroLine;
                break;
            }
            case 2063: {
                hashInst = this.pGraph.LObj.X1Axis.ZeroLine;
                break;
            }
            case 2064: {
                hashInst = this.pGraph.LObj.O1Axis.ZeroLine;
                break;
            }
            case 2065: {
                hashInst = this.pGraph.LObj.O2Axis.ZeroLine;
                break;
            }
            case 2066: {
                hashInst = this.pGraph.LObj.Z1Axis.ZeroLine;
                break;
            }
            case 2086: {
                hashInst = this.pGraph.LObj.DivBipolar;
                break;
            }
            case 2149: {
                hashInst = this.pGraph.LObj.Y1Axis.MajorHashFrame;
                break;
            }
            case 2150: {
                hashInst = this.pGraph.LObj.Y2Axis.MajorHashFrame;
                break;
            }
            case 2151: {
                hashInst = this.pGraph.LObj.X1Axis.MajorHashFrame;
                break;
            }
            case 2152: {
                hashInst = this.pGraph.LObj.O1Axis.MajorHashFrame;
                break;
            }
            case 2153: {
                hashInst = this.pGraph.LObj.O2Axis.MajorHashFrame;
                break;
            }
            case 2154: {
                hashInst = this.pGraph.LObj.Z1Axis.MajorHashFrame;
                break;
            }
            case 2155: {
                hashInst = this.pGraph.LObj.Y1Axis.MinorHashFrame;
                break;
            }
            case 2156: {
                hashInst = this.pGraph.LObj.Y2Axis.MinorHashFrame;
                break;
            }
            case 2157: {
                hashInst = this.pGraph.LObj.X1Axis.MinorHashFrame;
                break;
            }
            case 2158: {
                hashInst = this.pGraph.LObj.O1Axis.MinorHashFrame;
                break;
            }
            case 2159: {
                hashInst = this.pGraph.LObj.O2Axis.MinorHashFrame;
                break;
            }
            case 2160: {
                hashInst = this.pGraph.LObj.Z1Axis.MinorHashFrame;
                break;
            }
            case 2201: {
                hashInst = this.pGraph.LObj.Y1Axis.MajorHashRiser;
                break;
            }
            case 2202: {
                hashInst = this.pGraph.LObj.Y2Axis.MajorHashRiser;
                break;
            }
            case 2203: {
                hashInst = this.pGraph.LObj.X1Axis.MajorHashRiser;
                break;
            }
            case 2204: {
                hashInst = this.pGraph.LObj.O1Axis.MajorHashRiser;
                break;
            }
            case 2205: {
                hashInst = this.pGraph.LObj.O2Axis.MajorHashRiser;
                break;
            }
            case 2206: {
                hashInst = this.pGraph.LObj.Z1Axis.MajorHashRiser;
                break;
            }
            case 2207: {
                hashInst = this.pGraph.LObj.Y1Axis.MinorHashRiser;
                break;
            }
            case 2208: {
                hashInst = this.pGraph.LObj.Y2Axis.MinorHashRiser;
                break;
            }
            case 2209: {
                hashInst = this.pGraph.LObj.X1Axis.MinorHashRiser;
                break;
            }
            case 2210: {
                hashInst = this.pGraph.LObj.O1Axis.MinorHashRiser;
                break;
            }
            case 2211: {
                hashInst = this.pGraph.LObj.O2Axis.MinorHashRiser;
                break;
            }
            case 2212: {
                hashInst = this.pGraph.LObj.Z1Axis.MinorHashRiser;
            }
        }
        return hashInst;
    }

    private VisualizeInstRec loadSaveUtil_VisualizeInstRecGetPtr(int nDestID, int nArrayElement) {
        return null;
    }

    private FontInstRec loadSaveUtil_FontInstRecGetPtr(int nDestID, int nArrayElement) throws TTFLoadException {
        FontInstRec pFont = null;
        switch (nDestID) {
            default: {
                break;
            }
            case 1019: {
                pFont = this.pGraph.defaultFont;
                break;
            }
            case 2015: {
                pFont = this.pGraph.LObj.Title;
                break;
            }
            case 2016: {
                pFont = this.pGraph.LObj.SubTitle;
                break;
            }
            case 2017: {
                pFont = this.pGraph.LObj.Header1;
                break;
            }
            case 2018: {
                pFont = this.pGraph.LObj.Header2;
                break;
            }
            case 2019: {
                pFont = this.pGraph.LObj.Header3;
                break;
            }
            case 2020: {
                pFont = this.pGraph.LObj.Header4;
                break;
            }
            case 2021: {
                pFont = this.pGraph.LObj.TitleXAxis;
                break;
            }
            case 2022: {
                pFont = this.pGraph.LObj.TitleY1Axis;
                break;
            }
            case 2023: {
                pFont = this.pGraph.LObj.TitleY2Axis;
                break;
            }
            case 2024: {
                pFont = this.pGraph.LObj.Label1;
                break;
            }
            case 2025: {
                pFont = this.pGraph.LObj.Label2;
                break;
            }
            case 2026: {
                pFont = this.pGraph.LObj.Label3;
                break;
            }
            case 2027: {
                pFont = this.pGraph.LObj.Footnote;
                break;
            }
            case 2107: {
                pFont = this.pGraph.LObj.Font3D[nArrayElement].FontInst;
                break;
            }
            case 2147: {
                SerDepLookClass serDep = this.pGraph.LObj.vaSerDepLook.allocateAt(nArrayElement);
                if (serDep.pFont == null) {
                    serDep.pFont = new FontInstRec();
                }
                pFont = serDep.pFont;
                break;
            }
            case 1044: {
                AnodeInfoRec anode = this.pGraph.annotations.getAt(nArrayElement);
                pFont = anode.pFont;
            }
        }
        return pFont;
    }

    private void loadStruct_LineInstRec(short tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)9003, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        LineInstRec line = this.loadSaveUtil_LineInstRecGetPtr(nDestID, nArrayElement);
        if (line == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        line.nThick = this.readInt16();
        line.nStyle = this.readInt16();
        line.nColor = this.readInt16();
        line.nBColor = this.readInt16();
    }

    private void loadStruct_DropShadowInstRec(short tagSize) throws IOException, TTFLoadException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)9002, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        DropShadowInstRec dropShadow = null;
        FontInstRec pFont = this.loadSaveUtil_FontInstRecGetPtr(nDestID, nArrayElement);
        if (pFont != null) {
            dropShadow = pFont.drop;
        } else {
            AreaInstRec area = this.loadSaveUtil_AreaInstRecGetPtr(nDestID, nArrayElement);
            if (area != null) {
                dropShadow = area.drop;
            }
        }
        if (dropShadow == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        dropShadow.nXoff = this.readInt16();
        dropShadow.nYoff = this.readInt16();
        dropShadow.nRed = this.readInt16();
        dropShadow.nGreen = this.readInt16();
        dropShadow.nBlue = this.readInt16();
    }

    private void loadStruct_FontInstRec(short tagId, short tagSize, int version) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord(tagId, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        FontInstRec pFont = this.loadSaveUtil_FontInstRecGetPtr(nDestID, nArrayElement);
        if (pFont == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        pFont.nFontIndex = this.readInt16();
        pFont.eQuality = this.readInt16();
        pFont.nSize = this.readInt16();
        pFont.nAngle = this.readInt16();
        pFont.justH = this.readInt16();
        pFont.justV = this.readInt16();
        pFont.textFont = this.readInt16();
        pFont.textSize = this.readInt16();
        pFont.textFace = this.readInt16();
        pFont.textMode = this.readInt16();
        pFont.nFlags = this.readInt16();
        pFont.nPitchAndFamily = this.readInt16();
        pFont.nCharSet = this.readInt16();
        if (version < 3) {
            return;
        }
        pFont.nPattern = this.readInt16();
        pFont.nBRed = this.readInt16();
        pFont.nBGreen = this.readInt16();
        pFont.nBBlue = this.readInt16();
        pFont.FancyBoxInfo.nShape = this.readInt16();
        pFont.FancyBoxInfo.nStyle = this.readInt16();
        if (version < 4) {
            return;
        }
        pFont.nPointSize = this.readInt16();
        if (version < 5) {
            return;
        }
        pFont.nExtLeading = this.readInt16();
        if (version < 6) {
            return;
        }
        pFont.nMBCFontIndex = this.readInt16();
        if (pFont.nSize == 0) {
            pFont.nSize = 1000;
        }
        if (pFont.nPointSize == 0) {
            pFont.nPointSize = 1000;
        }
    }

    private void loadStruct_BoxInstRec(short tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)9006, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        BoxInstRec pBox = this.loadSaveUtil_BoxInstRecGetPtr(nDestID, nArrayElement);
        if (pBox == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        pBox.xULC = this.readInt16();
        pBox.yULC = this.readInt16();
        pBox.xLRC = this.readInt16();
        pBox.yLRC = this.readInt16();
    }

    private void loadStruct_AreaInstRec(int tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)9004, (short)tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        AreaInstRec pArea = this.loadSaveUtil_AreaInstRecGetPtr(nDestID, nArrayElement);
        if (pArea == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        assert (tagSize == 12);
        pArea.nPattern = this.readInt16();
        pArea.nBRed = this.readUInt16();
        pArea.nBGreen = this.readUInt16();
        pArea.nBBlue = this.readUInt16();
    }

    private void loadStruct_HashInst(int tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6011, (short)tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        HashInst hashInst = this.loadSaveUtil_HashInstGetPtr(nDestID, nArrayElement);
        if (hashInst == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        hashInst.bIsWanted = this.readBoolean16();
        hashInst.HashStyle = this.readInt16();
    }

    private void loadStruct_PieSerDepDataClass(short tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6026, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        PieSerDepDataClass pPieSerDepData = null;
        switch (nDestID) {
            case 3032: {
                SerDepDataClass sd = (SerDepDataClass)this.pGraph.DLObj.vaSerDep.allocateAt(nArrayElement);
                pPieSerDepData = sd.PieSerDepData;
                break;
            }
            case 3042: {
                NewSerDepDataClass nsd = (NewSerDepDataClass)this.pGraph.DLObj.vaNewSerDep.allocateAt(nArrayElement);
                pPieSerDepData = nsd.PieSerDepData;
            }
        }
        if (pPieSerDepData == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        pPieSerDepData.nShowPieLabel = this.readInt16();
        pPieSerDepData.bShowFeeler = this.readBoolean16();
        pPieSerDepData.nFeelerKind = this.readInt16();
        pPieSerDepData.nPieFRadial = this.readInt32();
        pPieSerDepData.nPieFHorizontal = this.readInt32();
        pPieSerDepData.nPieFHub = this.readInt32();
        pPieSerDepData.nMove = this.readInt32();
        pPieSerDepData.nPieRadius = this.readInt32();
    }

    private void loadStruct_SerDepDataClass(short tagId, short tagSize, int version) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord(tagId, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        SerDepDataClass pSerDepData = null;
        switch (nDestID) {
            case 3032: {
                pSerDepData = (SerDepDataClass)this.pGraph.DLObj.vaSerDep.allocateAt(nArrayElement);
            }
        }
        if (pSerDepData == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        pSerDepData.bCurv = this.readBoolean16();
        pSerDepData.bLinRLine = this.readBoolean16();
        pSerDepData.bMovA = this.readBoolean16();
        pSerDepData.bConn = this.readBoolean16();
        pSerDepData.bMean = this.readBoolean16();
        pSerDepData.bStdD = this.readBoolean16();
        pSerDepData.nEmphasized = this.readInt16();
        pSerDepData.nShape = this.readInt16();
        pSerDepData.nDummy4 = this.readInt16();
        pSerDepData.nRiserType = this.readInt16();
        pSerDepData.bSplitY = this.readInt16();
        pSerDepData.nDummy1 = this.readInt16();
        pSerDepData.nDummy2 = this.readInt16();
        pSerDepData.nDummy3 = this.readInt16();
        pSerDepData.bLinRNaturalLog = this.readBoolean16();
        pSerDepData.bLinRLog = this.readBoolean16();
        pSerDepData.bLinRExp = this.readBoolean16();
        pSerDepData.bLinRNPoly = this.readBoolean16();
        pSerDepData.nLinRNPolyFactor = this.readInt16();
        pSerDepData.bIgnore = this.readBoolean16();
        pSerDepData.bPreConn = this.readBoolean16();
        pSerDepData.nSeriesPos = version == 2 ? (int)this.readInt16() : 0;
        pSerDepData.bPreConnBreak = this.readBoolean16();
        pSerDepData.bPreStep = this.readBoolean16();
        pSerDepData.bPreStepBreak = this.readBoolean16();
        pSerDepData.bPreStepVert = this.readBoolean16();
        pSerDepData.nStdFormat = this.readInt16();
        pSerDepData.nDummy5 = this.readInt16();
        pSerDepData.bShowCorr = this.readBoolean16();
        pSerDepData.bShowFormula = this.readBoolean16();
        pSerDepData.bDeleted = this.readBoolean16();
    }

    private void loadStruct_NewSerDepDataClass(short tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6044, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        NewSerDepDataClass pNewSerDepData = null;
        switch (nDestID) {
            case 3042: {
                pNewSerDepData = (NewSerDepDataClass)this.pGraph.DLObj.vaNewSerDep.allocateAt(nArrayElement);
            }
        }
        if (pNewSerDepData == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        pNewSerDepData.bCurveType = this.readInt16();
        pNewSerDepData.bState = this.readInt16();
        pNewSerDepData.bSplitY = this.readBoolean16();
        pNewSerDepData.bIgnore = this.readBoolean16();
        pNewSerDepData.bEmphasized = this.readBoolean16();
        pNewSerDepData.bDeleted = this.readBoolean16();
        pNewSerDepData.nShape = this.readInt16();
        pNewSerDepData.nRiserType = this.readInt16();
        pNewSerDepData.nLinRNPolyFactor = this.readInt16();
        pNewSerDepData.nStdFormat = this.readInt16();
    }

    private void loadStruct_VarArrayINT16(short tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6020, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        GrowArray hVarArray = null;
        switch (nDestID) {
            case 2134: {
                hVarArray = this.pGraph.LObj.vaRiserShapes;
                break;
            }
            case 2135: {
                hVarArray = this.pGraph.LObj.vaMarkerSymbols;
            }
        }
        if (hVarArray == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        int numElements = (tagSize - 4) / 2;
        hVarArray.allocateAt(numElements - 1);
        for (int i = 0; i < numElements; ++i) {
            hVarArray.setAt(i, new Integer(this.readInt16()));
        }
    }

    private AreaInstRec loadSaveUtil_AreaInstRecGetPtr(int nDestID, int nArrayElement) throws TTFLoadException {
        AreaInstRec pArea = null;
        switch (nDestID) {
            case 2007: {
                if (this.pGraph.LObj.AreaColors[nArrayElement] == null) {
                    this.pGraph.LObj.AreaColors[nArrayElement] = new AreaInstRec();
                }
                pArea = this.pGraph.LObj.AreaColors[nArrayElement];
                break;
            }
            case 2132: {
                pArea = this.pGraph.LObj.vaRiserColors.allocateAt(nArrayElement);
                break;
            }
            case 1042: {
                AnodeInfoRec annotationInfo = this.pGraph.annotations.allocateAt(nArrayElement);
                pArea = (AreaInstRec)this.getInstance(annotationInfo.pArea, AreaInstRec.class);
                break;
            }
            case 1041: {
                AnodeInfoRec annotationInfo = this.pGraph.annotations.allocateAt(nArrayElement);
                pArea = (AreaInstRec)this.getInstance(annotationInfo.text.pbArea, AreaInstRec.class);
                break;
            }
            case 1017: {
                pArea = this.pGraph.defaultArea;
                break;
            }
            case 12015: {
                pArea = this.pGraph.defaultFont.FancyBoxArea;
                break;
            }
            case 12016: {
                pArea = this.pGraph.LObj.Title.FancyBoxArea;
                break;
            }
            case 12017: {
                pArea = this.pGraph.LObj.SubTitle.FancyBoxArea;
                break;
            }
            case 12018: {
                pArea = this.pGraph.LObj.Header1.FancyBoxArea;
                break;
            }
            case 12019: {
                pArea = this.pGraph.LObj.Header2.FancyBoxArea;
                break;
            }
            case 12020: {
                pArea = this.pGraph.LObj.Header3.FancyBoxArea;
                break;
            }
            case 12021: {
                pArea = this.pGraph.LObj.Header4.FancyBoxArea;
                break;
            }
            case 12022: {
                pArea = this.pGraph.LObj.TitleXAxis.FancyBoxArea;
                break;
            }
            case 12023: {
                pArea = this.pGraph.LObj.TitleY1Axis.FancyBoxArea;
                break;
            }
            case 12024: {
                pArea = this.pGraph.LObj.TitleY2Axis.FancyBoxArea;
                break;
            }
            case 12025: {
                pArea = this.pGraph.LObj.Label1.FancyBoxArea;
                break;
            }
            case 12026: {
                pArea = this.pGraph.LObj.Label2.FancyBoxArea;
                break;
            }
            case 12027: {
                pArea = this.pGraph.LObj.Label3.FancyBoxArea;
                break;
            }
            case 12028: {
                pArea = this.pGraph.LObj.Footnote.FancyBoxArea;
                break;
            }
            case 12029: {
                this.pGraph.LObj.Font3D[nArrayElement] = (Font3DStruct)this.getInstance(this.pGraph.LObj.Font3D[nArrayElement], Font3DStruct.class);
                pArea = this.pGraph.LObj.Font3D[nArrayElement].FontInst.FancyBoxArea;
                break;
            }
            case 3052: {
                if (nArrayElement == 0) {
                    pArea = this.pGraph.QualityMaster.QA_Y1.QALabel.FancyBoxArea;
                    break;
                }
                if (nArrayElement == 1) {
                    pArea = this.pGraph.QualityMaster.QA_Y2.QALabel.FancyBoxArea;
                    break;
                }
                pArea = this.pGraph.QualityMaster.QA_X.QALabel.FancyBoxArea;
                break;
            }
            case 12030: {
                SerDepLookClass dl = this.pGraph.LObj.vaSerDepLook.allocateAt(nArrayElement);
                if (dl.pFont == null) {
                    dl.pFont = new FontInstRec();
                }
                pArea = dl.pFont.FancyBoxArea;
                break;
            }
            case 12031: {
                AnodeInfoRec annotationInfo = this.pGraph.annotations.allocateAt(nArrayElement);
                pArea = (AreaInstRec)this.getInstance(annotationInfo.pFont.FancyBoxArea, AreaInstRec.class);
                break;
            }
            case 12161: {
                pArea = this.pGraph.ProgressionArrowFill;
                break;
            }
            case 30527: {
                pArea = this.pGraph.gauge.ScaleFont.FancyBoxArea;
                break;
            }
            case 12169: {
                pArea = this.pGraph.gauge.GaugeFill;
                break;
            }
            case 12170: {
                pArea = this.pGraph.gauge.GaugeContainerFill;
                break;
            }
            case 12172: {
                this.pGraph.gauge.Range[nArrayElement] = (GaugeRangeRec)this.getInstance(this.pGraph.gauge.Range[nArrayElement], GaugeRangeRec.class);
                pArea = this.pGraph.gauge.Range[nArrayElement].RangeArea;
                break;
            }
            case 12134: 
            case 12137: {
                pArea = this.pGraph.ROInfo[nArrayElement].AreaInfo;
            }
        }
        return pArea;
    }

    private BoxInstRec loadSaveUtil_BoxInstRecGetPtr(int nDestID, int nArrayElement) throws TTFLoadException {
        switch (nDestID) {
            default: {
                return null;
            }
            case 2012: {
                return this.pGraph.LObj.xyTitle;
            }
            case 2013: {
                return this.pGraph.LObj.xySubTitle;
            }
            case 2014: {
                return this.pGraph.LObj.xyFootnote;
            }
            case 2028: {
                return this.pGraph.LObj.xyFrame;
            }
            case 2033: {
                return this.pGraph.LObj.Legend;
            }
            case 2040: {
                return this.pGraph.LObj.XAxisTitle;
            }
            case 2041: {
                return this.pGraph.LObj.Y1AxisTitle;
            }
            case 2042: {
                return this.pGraph.LObj.Y2AxisTitle;
            }
            case 2043: {
                return this.pGraph.LObj.LocateColTitle;
            }
            case 2044: {
                return this.pGraph.LObj.LocateRowTitle;
            }
            case 2045: {
                return this.pGraph.LObj.LocateLYTitle;
            }
            case 2046: {
                return this.pGraph.LObj.LocateRYTitle;
            }
            case 2088: {
                return this.pGraph.LObj.RiserDrop;
            }
            case 3032: {
                SerDepDataClass sd = (SerDepDataClass)this.pGraph.DLObj.vaSerDep.allocateAt(nArrayElement);
                return sd.biCurveText;
            }
            case 3042: {
                NewSerDepDataClass nsd = (NewSerDepDataClass)this.pGraph.DLObj.vaNewSerDep.allocateAt(nArrayElement);
                return nsd.biCurveText;
            }
            case 3054: 
        }
        return this.pGraph.gauge.Position;
    }

    private LineInstRec loadSaveUtil_LineInstRecGetPtr(int nDestID, int nArrayElement) throws TTFLoadException {
        LineInstRec pLine = null;
        SerDepLookClass dl = null;
        block0 : switch (nDestID) {
            case 2011: {
                pLine = this.pGraph.LObj.LineColors[nArrayElement];
                if (pLine != null) break;
                pLine = new LineInstRec();
                pLine.glow = GlowInstRec.protoGlowInst;
                this.pGraph.LObj.LineColors[nArrayElement] = pLine;
                break;
            }
            case 1018: {
                pLine = this.pGraph.defaultLine;
                break;
            }
            case 2133: {
                pLine = this.pGraph.LObj.vaRiserBorders.allocateAt(nArrayElement);
                break;
            }
            case 2146: {
                dl = this.pGraph.LObj.vaSerDepLook.allocateAt(nArrayElement);
                if (dl.pLine == null) {
                    dl.pLine = new LineInstRec();
                    dl.pLine.glow = GlowInstRec.protoGlowInst;
                }
                pLine = dl.pLine;
                break;
            }
            case 1043: {
                AnodeInfoRec annotationInfo = this.pGraph.annotations.allocateAt(nArrayElement);
                pLine = (LineInstRec)this.getInstance(annotationInfo.pLine, LineInstRec.class);
                pLine.glow = GlowInstRec.protoGlowInst;
                break;
            }
            case 1041: {
                AnodeInfoRec annotationInfo = this.pGraph.annotations.allocateAt(nArrayElement);
                pLine = (LineInstRec)this.getInstance(annotationInfo.text.pbLine, LineInstRec.class);
                pLine.glow = GlowInstRec.protoGlowInst;
                break;
            }
            case 12115: {
                pLine = this.pGraph.defaultFont.FancyBoxLine;
                break;
            }
            case 12116: {
                pLine = this.pGraph.LObj.Title.FancyBoxLine;
                break;
            }
            case 12117: {
                pLine = this.pGraph.LObj.SubTitle.FancyBoxLine;
                break;
            }
            case 12118: {
                pLine = this.pGraph.LObj.Header1.FancyBoxLine;
                break;
            }
            case 12119: {
                pLine = this.pGraph.LObj.Header2.FancyBoxLine;
                break;
            }
            case 12120: {
                pLine = this.pGraph.LObj.Header3.FancyBoxLine;
                break;
            }
            case 12121: {
                pLine = this.pGraph.LObj.Header4.FancyBoxLine;
                break;
            }
            case 12122: {
                pLine = this.pGraph.LObj.TitleXAxis.FancyBoxLine;
                break;
            }
            case 12123: {
                pLine = this.pGraph.LObj.TitleY1Axis.FancyBoxLine;
                break;
            }
            case 12124: {
                pLine = this.pGraph.LObj.TitleY2Axis.FancyBoxLine;
                break;
            }
            case 12125: {
                pLine = this.pGraph.LObj.Label1.FancyBoxLine;
                break;
            }
            case 12126: {
                pLine = this.pGraph.LObj.Label2.FancyBoxLine;
                break;
            }
            case 12127: {
                pLine = this.pGraph.LObj.Label3.FancyBoxLine;
                break;
            }
            case 12128: {
                pLine = this.pGraph.LObj.Footnote.FancyBoxLine;
                break;
            }
            case 12129: {
                pLine = this.pGraph.LObj.Font3D[nArrayElement].FontInst.FancyBoxLine;
                break;
            }
            case 12130: {
                dl = this.pGraph.LObj.vaSerDepLook.allocateAt(nArrayElement);
                if (dl.pFont == null) {
                    dl.pFont = new FontInstRec();
                }
                pLine = dl.pFont.FancyBoxLine;
                break;
            }
            case 12131: {
                AnodeInfoRec annotationInfo = this.pGraph.annotations.allocateAt(nArrayElement);
                pLine = (LineInstRec)this.getInstance(annotationInfo.pFont.FancyBoxLine, LineInstRec.class);
                pLine.glow = GlowInstRec.protoGlowInst;
                break;
            }
            case 3056: {
                pLine = this.pGraph.gauge.ScaleFont.FancyBoxLine;
                break;
            }
            case 12167: {
                pLine = this.pGraph.gauge.GaugeBorder;
                break;
            }
            case 12168: {
                pLine = this.pGraph.gauge.GaugeContainerBorder;
                break;
            }
            case 12165: {
                pLine = this.pGraph.gauge.MajorGridLine;
                break;
            }
            case 12166: {
                pLine = this.pGraph.gauge.MinorGridLine;
                break;
            }
            case 12158: {
                pLine = this.pGraph.DatatextConnectLine;
                break;
            }
            case 12159: {
                pLine = this.pGraph.ProgressionArrowLine;
                break;
            }
            case 2213: {
                pLine = this.pGraph.LObj.vaSerDepLook.allocateAt((int)nArrayElement).ErrorBarInfo.ErrorBarLine;
                break;
            }
            case 12134: 
            case 12136: {
                break;
            }
            case 12135: {
                switch (nArrayElement) {
                    case 0: {
                        pLine = this.pGraph.UserLine1.LineInst;
                        break block0;
                    }
                    case 1: {
                        pLine = this.pGraph.UserLine2.LineInst;
                        break block0;
                    }
                    case 2: {
                        pLine = this.pGraph.UserLine3.LineInst;
                        break block0;
                    }
                }
                pLine = this.pGraph.UserLine4.LineInst;
            }
        }
        return pLine;
    }

    private void loadStruct_AxisLookClass(short tagId, int tagSize, int version) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord(tagId, (short)tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        AxisLookClass pAxisLookClass = null;
        switch (nDestID) {
            case 2061: {
                pAxisLookClass = this.pGraph.LObj.Y1Axis;
                break;
            }
            case 2062: {
                pAxisLookClass = this.pGraph.LObj.Y2Axis;
                break;
            }
            case 2063: {
                pAxisLookClass = this.pGraph.LObj.X1Axis;
                break;
            }
            case 2064: {
                pAxisLookClass = this.pGraph.LObj.O1Axis;
                break;
            }
            case 2065: {
                pAxisLookClass = this.pGraph.LObj.O2Axis;
                break;
            }
            case 2066: {
                pAxisLookClass = this.pGraph.LObj.Z1Axis;
            }
        }
        if (pAxisLookClass == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        if (version < 2) {
            short bIsWanted = this.readInt16();
            switch (bIsWanted) {
                case 0: {
                    pAxisLookClass.nShowStatus = 2;
                    break;
                }
                case 1: {
                    pAxisLookClass.nShowStatus = 31;
                    break;
                }
                case 2: {
                    pAxisLookClass.nShowStatus = 29;
                }
            }
        } else {
            pAxisLookClass.nShowStatus = this.readInt32();
        }
        pAxisLookClass.bOddDivs = this.readBoolean16();
        pAxisLookClass.nMajorHash = this.readInt16();
        pAxisLookClass.nMajorHashMode = this.readInt16();
        pAxisLookClass.nMinorHash = this.readInt16();
        pAxisLookClass.nMinorHashMode = this.readInt16();
        pAxisLookClass.nSuperHash = this.readInt16();
        pAxisLookClass.fDivSize = this.readDouble();
        pAxisLookClass.fMinEndOff = this.readDouble();
        pAxisLookClass.fMaxEndOff = this.readDouble();
        pAxisLookClass.nAxisLine = this.readInt16();
        pAxisLookClass.Side = this.readInt16();
        pAxisLookClass.bInvertNumScale = this.readBoolean16();
        pAxisLookClass.fMin = this.readDouble();
        pAxisLookClass.fMax = this.readDouble();
        pAxisLookClass.nLabelID = this.readInt16();
        pAxisLookClass.nAxisID = this.readInt16();
        short stagger = this.readInt16();
        pAxisLookClass.bStaggered = stagger == 2;
        pAxisLookClass.fLow = this.readDouble();
        pAxisLookClass.fHigh = this.readDouble();
        pAxisLookClass.nPlaceQDRLabel = this.readInt16();
        pAxisLookClass.nScaleEnd = this.readInt16();
        pAxisLookClass.nLabelSkip = this.readInt16();
        pAxisLookClass.nLabelStart = this.readInt16();
        pAxisLookClass.nLabelEnd = this.readInt16();
        if (version < 2) {
            this.readAscii(pAxisLookClass.szAxisName, false);
        } else {
            this.readAscii(pAxisLookClass.szAxisName, true);
        }
        pAxisLookClass.bHideLabels = this.readBoolean16();
        pAxisLookClass.nAxisType = this.readInt16();
        pAxisLookClass.nOrdLabelMode = this.readInt16();
        pAxisLookClass.nOrdSpace = this.readInt16();
        pAxisLookClass.nLabelWrapMode = this.readInt16();
        pAxisLookClass.nLabelWrapLines = this.readInt16();
        if (version > 0) {
            pAxisLookClass.fGridStep = this.readDouble();
            pAxisLookClass.bUseGridStep = this.readBoolean16();
        }
    }

    private void loadStruct_BarLookClass(short tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6005, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        if (nDestID == 2071) {
            BarLookClass barLook = this.pGraph.LObj.BarLook;
            barLook.bPictograph = this.readBoolean16();
        } else {
            this.skipTag(nDestID, tagSize - 4);
        }
    }

    public void loadStruct_PieLookClass(short tagId, short tagSize, boolean isPieLookClass_2) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord(tagId, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        if (nDestID == 2070) {
            PieLookClass pieLook = this.pGraph.LObj.PieLook;
            pieLook.nPieTilt = this.readInt16();
            pieLook.nPieRotate = this.readInt16();
            pieLook.PieDepth = this.readInt16();
            pieLook.PiesPerRow = this.readInt16();
            pieLook.PieFlagAutoShade = this.readBoolean16();
            pieLook.bPieClockWise = this.readBoolean16();
            pieLook.nHoleSize = this.readInt16();
            pieLook.bShowGroupLabels = this.readBoolean16();
            pieLook.bShowRingLabels = this.readBoolean16();
            pieLook.bPieTilt = this.readBoolean16();
            if (isPieLookClass_2) {
                pieLook.nPlaceValueLabel = this.readInt16();
                pieLook.nPlaceDataLabel = this.readInt16();
            }
        } else {
            this.skipTag(nDestID, tagSize - 4);
        }
    }

    private void loadStruct_StockMktLookClass(short tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6010, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        if (nDestID == 2082) {
            StockMktLookClass stockMktLook = this.pGraph.LObj.StockMktLook;
            stockMktLook.nHLWidth = this.readInt16();
            stockMktLook.nOCHeight = this.readInt16();
            stockMktLook.nOCWidth = this.readInt16();
            stockMktLook.bShowOpen = this.readBoolean16();
            stockMktLook.bShowClose = this.readBoolean16();
            stockMktLook.nDTXTItem = this.readInt16();
            stockMktLook.nSDLineItem = this.readInt16();
        } else {
            this.skipTag(nDestID, tagSize - 4);
        }
    }

    private void skipTag(int tag, int size) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Skip TIFF tag : " + Tags.getText(tag)));
        }
        this.file.skipBytes(size);
    }

    private void loadStruct_BubbleLookClass(short tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6008, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        if (nDestID == 2074) {
            BubbleLookClass bubbleLook = this.pGraph.LObj.BubbleLook;
            bubbleLook.nMinBubble = this.readInt16();
            bubbleLook.nMaxBubble = this.readInt16();
            bubbleLook.bShowQuadrants = this.readBoolean16();
        } else {
            this.skipTag(nDestID, tagSize - 4);
        }
    }

    private void loadStruct_FontNameInfo(short tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)9008, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        FontNameInfo fontInfo = null;
        switch (nDestID) {
            case 1021: {
                fontInfo = this.pGraph.FontMaster.fontInfoTbl.allocateAt(nArrayElement);
            }
        }
        if (fontInfo == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        this.readAscii(fontInfo.fontName);
        fontInfo.fontName[31] = '\u0000';
        fontInfo.pitchAndFamily = this.readByte();
        fontInfo.charSet = this.readByte();
        fontInfo.nFlags = this.readInt16();
    }

    private void loadStruct_AdvFormatStruct(int tagSize) throws TTFLoadException, IOException {
        short nArrayElement = this.readInt16();
        short nDestID = this.readInt16();
        int actualTagSize = tagSize;
        if (tagSize == 952) {
            actualTagSize += 4;
        }
        if (this.skipRecord((short)6050, (short)actualTagSize, nArrayElement, nDestID)) {
            return;
        }
        AdvFormatStruct pAdvFormat = this.getAdvFormatStruct(nDestID, nArrayElement);
        if (pAdvFormat == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        pAdvFormat.formatType = this.readInt32();
        pAdvFormat.iLZero = this.readInt32();
        pAdvFormat.iDigits = this.readInt32();
        pAdvFormat.iGrouping = this.readInt32();
        pAdvFormat.iNegNumber = this.readInt32();
        this.readAscii(pAdvFormat.szScientificSymbol);
        this.readAscii(pAdvFormat.szDecimal);
        this.readAscii(pAdvFormat.szThousand);
        pAdvFormat.iCurrDigits = this.readInt32();
        pAdvFormat.iMonGrouping = this.readInt32();
        pAdvFormat.iNegCurr = this.readInt32();
        pAdvFormat.iPosCurr = this.readInt32();
        this.readAscii(pAdvFormat.szCurrency);
        this.readAscii(pAdvFormat.szMonDecimalSep);
        this.readAscii(pAdvFormat.szMonThousandSep);
        this.readAscii(pAdvFormat.szTimeFormat);
        this.readAscii(pAdvFormat.szDateFormat);
        this.readAscii(pAdvFormat.szPrefixText);
        this.readAscii(pAdvFormat.szPostfixText);
        this.readAscii(pAdvFormat.szNumColor);
        this.readAscii(pAdvFormat.szNegColor);
        this.readAscii(pAdvFormat.szZeroColor);
        pAdvFormat.bPrefixPercentSymbol = (short)this.readInt32();
        pAdvFormat.dScaleFactor = this.readDouble();
        switch (tagSize) {
            case 248: {
                pAdvFormat.bNoNegSign = (short)this.readInt32();
                pAdvFormat.localeID = this.readInt32();
                break;
            }
            case 504: 
            case 508: 
            case 952: 
            case 956: {
                pAdvFormat.bNoNegSign = (short)this.readInt32();
                pAdvFormat.localeID = this.readInt32();
                this.readAscii(pAdvFormat.szCustomFormat);
            }
        }
    }

    private AdvFormatStruct getAdvFormatStruct(int nDestID, int nArrayElement) throws TTFLoadException {
        AdvFormatStruct pAdvFormat = null;
        switch (nDestID) {
            case 6052: {
                pAdvFormat = this.pGraph.DLObj.X1Data.AdvStdFormat;
                break;
            }
            case 6056: {
                pAdvFormat = this.pGraph.DLObj.X1Data.AdvStdFormatDTXT;
                break;
            }
            case 6053: {
                pAdvFormat = this.pGraph.DLObj.Y1Data.AdvStdFormat;
                break;
            }
            case 6057: {
                pAdvFormat = this.pGraph.DLObj.Y1Data.AdvStdFormatDTXT;
                break;
            }
            case 6054: {
                pAdvFormat = this.pGraph.DLObj.Y2Data.AdvStdFormat;
                break;
            }
            case 6058: {
                pAdvFormat = this.pGraph.DLObj.Y2Data.AdvStdFormatDTXT;
                break;
            }
            case 6055: {
                pAdvFormat = this.pGraph.DLObj.Z1Data.AdvStdFormat;
                break;
            }
            case 6059: {
                pAdvFormat = this.pGraph.DLObj.Z1Data.AdvStdFormatDTXT;
                break;
            }
            case 6051: {
                pAdvFormat = this.pGraph.DLObj.AdvStdFormatSum;
                break;
            }
            case 3032: {
                SerDepDataClass sd = (SerDepDataClass)this.pGraph.DLObj.vaSerDep.allocateAt(nArrayElement);
                pAdvFormat = sd.AdvStdFormat;
                break;
            }
            case 3042: {
                NewSerDepDataClass nsd = (NewSerDepDataClass)this.pGraph.DLObj.vaNewSerDep.allocateAt(nArrayElement);
                pAdvFormat = nsd.AdvStdFormat;
                break;
            }
            case 12174: {
                pAdvFormat = this.pGraph.gauge.AdvStdFormatInterval;
            }
        }
        return pAdvFormat;
    }

    private void loadDataLook(short tagId, short tagSize) throws TTFLoadException, IOException {
        switch (tagId) {
            default: {
                this.skipTag(tagId, tagSize);
                break;
            }
            case 3022: {
                this.pGraph.DLObj.bAxisSwap = this.readBoolean16();
                break;
            }
            case 3023: {
                this.pGraph.DLObj.bRowReverse = this.readBoolean16();
                break;
            }
            case 3024: {
                this.pGraph.DLObj.bColReverse = this.readBoolean16();
                break;
            }
            case 3025: {
                this.pGraph.DLObj.nStdFormatSum = this.readInt16();
                break;
            }
            case 3026: {
                this.pGraph.DLObj.nStdFormatLbl = this.readInt16();
                break;
            }
            case 3031: {
                this.pGraph.DLObj.bVertFormat = this.readBoolean16();
                break;
            }
            case 3036: {
                this.pGraph.DLObj.nDataFormatID = this.readInt16();
            }
        }
    }

    void loadStruct_ColorModelStruct(int tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6019, (short)tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        ColorModelStruct colorModel = null;
        switch (nDestID) {
            case 2127: {
                colorModel = this.pGraph.LObj.ColorModel;
            }
        }
        if (colorModel == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        colorModel.nColorModel = this.readInt16();
        colorModel.nColorDivisions = this.readInt16();
        this.loadRGB16(colorModel.washBeginColor);
        this.loadRGB16(colorModel.washEndColor);
    }

    private void loadStruct_ConTextType(int tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)1039, (short)tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        ConTextType textType = null;
        switch (nDestID) {
            case 2061: {
                textType = this.pGraph.LObj.Y1Axis.ctAxis;
                break;
            }
            case 2062: {
                textType = this.pGraph.LObj.Y2Axis.ctAxis;
                break;
            }
            case 2063: {
                textType = this.pGraph.LObj.X1Axis.ctAxis;
                break;
            }
            case 2064: {
                textType = this.pGraph.LObj.O1Axis.ctAxis;
                break;
            }
            case 2065: {
                textType = this.pGraph.LObj.O2Axis.ctAxis;
                break;
            }
            case 2066: {
                textType = this.pGraph.LObj.Z1Axis.ctAxis;
                break;
            }
            case 2031: {
                textType = this.pGraph.LObj.ctLegendHead;
                break;
            }
            case 2032: {
                textType = this.pGraph.LObj.ctLegendIcon;
                break;
            }
            case 2143: {
                textType = this.pGraph.LObj.PieLook.ctPie;
                break;
            }
            case 2144: {
                textType = this.pGraph.LObj.PieLook.ctGroupLabel;
                break;
            }
            case 2145: {
                textType = this.pGraph.LObj.PieLook.ctSliceLabel;
                break;
            }
            case 2139: {
                SerDepLookClass serdep = this.pGraph.LObj.vaSerDepLook.allocateAt(nArrayElement);
                textType = serdep.ctConstraints;
            }
        }
        if (textType == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        textType.bAutoFit = this.readInt16();
        textType.nFracParaLow = this.readInt16();
        textType.nFracParaHigh = this.readInt16();
        textType.nFracOrthLow = this.readInt16();
        textType.nFracOrthHigh = this.readInt16();
    }

    private void LoadStruct_FancyBox(short tagSize) throws IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)6048, tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        FancyBoxRec fancyBoxRec = null;
        switch (nDestID) {
            case 2186: {
                fancyBoxRec = this.pGraph.LegendFancyBox;
                break;
            }
            case 3055: {
                fancyBoxRec = this.pGraph.gauge.GaugeContainerFancyBox;
            }
        }
        if (fancyBoxRec == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        fancyBoxRec.nShape = this.readInt16();
        fancyBoxRec.nStyle = this.readInt16();
    }

    Object getInstance(Object object, Class c) throws TTFLoadException {
        if (object == null) {
            try {
                object = c.newInstance();
            }
            catch (InstantiationException e) {
                log.error((Object)"ExceptionCreatingNewObject : Unable to load chart");
                throw new TTFLoadException("ExceptionCreatingNewObject", e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"ExceptionCreatingNewObject : Unable to load chart");
                throw new TTFLoadException("ExceptionCreatingNewObject", e);
            }
        }
        return object;
    }

    private String getString(char[] c) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < c.length & c[i] != '\u0000') {
            buffer.append(c[i++]);
        }
        return buffer.toString();
    }

    private void LoadStruct_UserLineInfo(int tagSize) throws TTFLoadException, IOException {
        short nDestID;
        short nArrayElement = this.readInt16();
        if (this.skipRecord((short)10015, (short)tagSize, nArrayElement, nDestID = this.readInt16())) {
            return;
        }
        UserLineRec userLineRec = null;
        switch (nArrayElement) {
            case 0: {
                userLineRec = this.pGraph.UserLine1;
                break;
            }
            case 1: {
                userLineRec = this.pGraph.UserLine2;
                break;
            }
            case 2: {
                userLineRec = this.pGraph.UserLine3;
                break;
            }
            case 3: {
                userLineRec = this.pGraph.UserLine4;
            }
        }
        if (userLineRec == null) {
            this.skipTag(nDestID, tagSize - 4);
            return;
        }
        userLineRec.value = this.readDouble();
        userLineRec.bShowLine = this.readBoolean16();
        userLineRec.nAxisID = this.readInt16();
    }

    static {
        includeTags.add(2000);
        includeTags.add(2001);
        includeTags.add(2002);
        includeTags.add(2003);
        includeTags.add(2004);
        includeTags.add(2005);
        includeTags.add(3036);
        includeTags.add(3022);
        includeTags.add(10300);
        skipTags = new HashSet<Short>();
        skipDestIds = new HashSet<Short>();
        skipTags.add((short)10003);
        skipTags.add((short)10001);
        skipTags.add((short)10000);
        skipTags.add((short)10009);
        skipTags.add((short)10002);
        skipTags.add((short)10011);
        skipTags.add((short)6019);
        skipTags.add((short)11007);
        skipTags.add((short)2130);
        skipTags.add((short)2094);
        skipTags.add((short)2095);
        skipTags.add((short)2092);
        skipTags.add((short)2091);
        skipTags.add((short)10015);
        skipDestIds.add((short)12135);
        skipDestIds.add((short)3032);
        skipDestIds.add((short)3042);
        skipDestIds.add((short)3001);
        skipDestIds.add((short)3037);
        skipDestIds.add((short)2139);
        skipDestIds.add((short)2213);
        skipDestIds.add((short)2147);
        skipDestIds.add((short)12130);
        skipDestIds.add((short)12030);
        skipDestIds.add((short)2146);
        skipDestIds.add((short)2182);
        skipDestIds.add((short)2135);
        skipDestIds.add((short)2133);
        skipDestIds.add((short)2132);
        skipDestIds.add((short)2134);
    }
}

