/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics;

import com.businessobjects.visualization.pfjgraphics.PFJChartType;
import com.businessobjects.visualization.pfjgraphics.rendering.common.ChartNotSupportedException;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.GraphConverter;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.TTFLoadException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.zip.InflaterInputStream;

public class PFJSummaryInfo {
    private boolean seriesAreRows = false;
    private PFJChartType pfjChartType = null;
    private int numMissingTextures = 0;

    public final boolean getSeriesAreRows() {
        return this.seriesAreRows;
    }

    public final PFJChartType getPFJChartType() {
        return this.pfjChartType;
    }

    public final int getNumMissingTextures() {
        return this.numMissingTextures;
    }

    private PFJSummaryInfo() {
    }

    public static PFJSummaryInfo getPFJSummaryInfo(byte[] ttfChunk) {
        GraphConverter.PerspectiveSummary perspectiveSummary = null;
        try {
            perspectiveSummary = GraphConverter.loadPerspectiveSummary(new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(ttfChunk))));
        }
        catch (TTFLoadException e) {
            e.printStackTrace();
        }
        catch (ChartNotSupportedException e) {
            e.printStackTrace();
        }
        if (perspectiveSummary == null) {
            return null;
        }
        PFJSummaryInfo pfjSummaryInfo = new PFJSummaryInfo();
        pfjSummaryInfo.pfjChartType = PFJChartType.create(perspectiveSummary);
        pfjSummaryInfo.seriesAreRows = perspectiveSummary.seriesAreSwapped;
        pfjSummaryInfo.numMissingTextures = perspectiveSummary.numMissingTextures;
        return pfjSummaryInfo;
    }
}

