/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics;

import com.businessobjects.visualization.graphic.ColorManager;
import com.businessobjects.visualization.graphic.Palette;
import com.businessobjects.visualization.graphic.VisuBool;
import com.businessobjects.visualization.graphic.VisuColor;
import com.businessobjects.visualization.graphic.VisuColorEffectType;
import com.businessobjects.visualization.graphic.VisuInteger;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuState;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.settings.CVOMHelper;
import com.businessobjects.visualization.pfjgraphics.settings.CVOMid;
import com.businessobjects.visualization.pfjgraphics.settings.SettingsTransform;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;

public class PFJSettings {
    Perspective pfj;
    CVOMHelper cvom;

    public PFJSettings(CVOMHelper cvom, Perspective pfj) {
        this.pfj = pfj;
        this.cvom = cvom;
    }

    public void initCVOMDefaults() {
        this.pfj.setPlaceMargin(new Rectangle(-15300, -15300, 30600, 30600));
        this.pfj.setSeriesAreRows(true);
        this.pfj.setUsePGSDKViewing(true);
    }

    public void restorePFJPalette() {
        ColorManager cm = this.cvom.graphSettings.getObjectManager().getColorManager();
        VisuState vs = (VisuState)this.cvom.getProperty("root", "coloreffect");
        String colorEffect = vs.getId();
        VisuInteger alpha = (VisuInteger)this.cvom.getProperty("root", "coloreffect/alpha");
        this.cvom.graphSettings.getObjectManager().setColorEffectValue(VisuColorEffectType.ALPHA, alpha.intValue());
        int size = cm.getPaletteSize();
        this.pfj.setSeriesLooping(size);
        for (int i = 0; i < size; ++i) {
            VisuColor color = cm.getColor(i);
            if (colorEffect.equals("alpha")) {
                color = cm.getColor(i, VisuColorEffectType.ALPHA);
            }
            IdentObj seriesID = this.pfj.getSeries(i);
            Color c = (Color)SettingsTransform.Identity.toPFJ((VisuObject)color);
            this.pfj.setFillColor(seriesID, c);
            this.pfj.setBorderColor(seriesID, c);
        }
    }

    public void initCVOMPalette() {
        ColorManager cm = this.cvom.graphSettings.getObjectManager().getColorManager();
        Palette palette = new Palette();
        int size = this.pfj.getSeriesLooping();
        for (int i = 0; i < size; ++i) {
            IdentObj seriesID = this.pfj.getSeries(i);
            palette.addColor((VisuColor)SettingsTransform.Identity.toCVOM(this.pfj.getFillColor(seriesID), CVOMid.vType.UNKNOWN));
        }
        cm.setPalette(palette);
    }

    public void setPFJSizes() {
        int width = ((VisuInteger)this.cvom.getProperty("root", "width")).intValue();
        int height = ((VisuInteger)this.cvom.getProperty("root", "height")).intValue();
        int twipwidth = ((VisuInteger)this.cvom.getProperty("root", "twipwidth")).intValue();
        int twipheight = ((VisuInteger)this.cvom.getProperty("root", "twipheight")).intValue();
        this.pfj.setSize(new Dimension(width, height));
        this.pfj.setDocumentHeightInTwips(twipheight);
        this.pfj.setDocumentWidthInTwips(twipwidth);
    }

    public void setLocale() {
        this.pfj.setLocale(this.cvom.context.getLocalizedEngine().getLocale());
    }

    public void setAutoArrange() {
        boolean autoArrange = ((VisuBool)this.cvom.getProperty("root", "autoarrange")).booleanValue();
        this.pfj.setPgsdkAutoArrange(autoArrange);
    }
}

