/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.value;

import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.IInputArchive;
import com.crystaldecisions.reports.common.asserts.CrystalAssert;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataInput;
import com.crystaldecisions.reports.common.value.ArrayValue;
import com.crystaldecisions.reports.common.value.BooleanValue;
import com.crystaldecisions.reports.common.value.CrystalValue;
import com.crystaldecisions.reports.common.value.CurrencyValue;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.common.value.RangeValue;
import com.crystaldecisions.reports.common.value.SpecialCrystalValue;
import com.crystaldecisions.reports.common.value.StringValue;
import com.crystaldecisions.reports.common.value.TimeValue;
import com.crystaldecisions.reports.common.value.ValueType;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class FormulaValue
extends CrystalValue {
    private FormulaValueType long = null;
    private static Map<FormulaValueType, CrystalValue> goto = new ConcurrentHashMap<FormulaValueType, CrystalValue>();
    private static final FormulaValue[] else = new FormulaValue[0];

    public final FormulaValueType getFormulaValueType() {
        if (this.long == null) {
            this.long = FormulaValueType.fromValueType(this.getValueType());
        }
        return this.long;
    }

    public static FormulaValue coerceToNumber(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToNumber();
    }

    public FormulaValue coerceToNumber() {
        return null;
    }

    public static FormulaValue coerceToCurrency(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToCurrency();
    }

    public FormulaValue coerceToCurrency() {
        return null;
    }

    public static FormulaValue coerceToBoolean(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToBoolean();
    }

    public FormulaValue coerceToBoolean() {
        return null;
    }

    public static FormulaValue coerceToDate(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToDate();
    }

    public FormulaValue coerceToDate() {
        return null;
    }

    public static FormulaValue coerceToTime(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToTime();
    }

    public static FormulaValue Load(ValueType valueType, ExtendedDataInput extendedDataInput) throws IOException {
        if (valueType.isArray()) {
            return ArrayValue.Load(valueType, extendedDataInput);
        }
        if (valueType.isRange()) {
            return RangeValue.Load(valueType, extendedDataInput);
        }
        if (valueType.isNumber()) {
            return NumberValue.Load(valueType, extendedDataInput);
        }
        FormulaValue formulaValue = null;
        switch (valueType.value()) {
            case 7: {
                formulaValue = CurrencyValue.Load(extendedDataInput);
                break;
            }
            case 8: {
                formulaValue = BooleanValue.Load(extendedDataInput);
                break;
            }
            case 15: {
                formulaValue = DateTimeValue.Load(extendedDataInput);
                break;
            }
            case 9: {
                formulaValue = DateValue.Load(extendedDataInput);
                break;
            }
            case 10: {
                formulaValue = TimeValue.Load(extendedDataInput);
                break;
            }
            case 11: 
            case 13: {
                formulaValue = StringValue.Load(extendedDataInput);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return formulaValue;
    }

    public static FormulaValue LoadFromArchive(ValueType valueType, IInputArchive iInputArchive) throws ArchiveException {
        if (valueType.isArray()) {
            return ArrayValue.LoadFromArchive(valueType, iInputArchive);
        }
        if (valueType.isRange()) {
            return RangeValue.LoadFromArchive(valueType, iInputArchive);
        }
        if (valueType.isNumber()) {
            return NumberValue.LoadFromArchive(valueType, iInputArchive);
        }
        FormulaValue formulaValue = null;
        switch (valueType.value()) {
            case 7: {
                formulaValue = CurrencyValue.LoadFromArchive(iInputArchive);
                break;
            }
            case 8: {
                formulaValue = BooleanValue.LoadFromArchive(iInputArchive);
                break;
            }
            case 15: {
                formulaValue = DateTimeValue.LoadFromArchive(iInputArchive);
                break;
            }
            case 9: {
                formulaValue = DateValue.LoadFromArchive(iInputArchive);
                break;
            }
            case 10: {
                formulaValue = TimeValue.LoadFromArchive(iInputArchive);
                break;
            }
            case 11: 
            case 13: {
                formulaValue = StringValue.LoadFromArchive(iInputArchive);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return formulaValue;
    }

    public FormulaValue coerceToTime() {
        return null;
    }

    public static FormulaValue coerceToDateTime(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToDateTime();
    }

    public FormulaValue coerceToDateTime() {
        return null;
    }

    public static FormulaValue coerceToString(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToString();
    }

    public FormulaValue coerceToString() {
        return null;
    }

    public static FormulaValue coerceToRange(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToRange();
    }

    public FormulaValue coerceToRange() {
        try {
            return RangeValue.fromSingleValue(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static FormulaValue coerceToArray(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToArray();
    }

    public FormulaValue coerceToArray() {
        return ArrayValue.fromSingleValue(this);
    }

    public static FormulaValue coerceToRangeArray(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToRangeArray();
    }

    public FormulaValue coerceToRangeArray() {
        FormulaValue formulaValue = this.coerceToRange();
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToArray();
    }

    public static FormulaValue coerce(FormulaValue formulaValue, FormulaValueType formulaValueType) {
        if (formulaValue == null) {
            return null;
        }
        if (formulaValue.getFormulaValueType() == formulaValueType) {
            return formulaValue;
        }
        switch (formulaValueType.getBaseFormulaValueType().value()) {
            case 6: {
                formulaValue = formulaValue.coerceToNumber();
                break;
            }
            case 7: {
                formulaValue = formulaValue.coerceToCurrency();
                break;
            }
            case 8: {
                formulaValue = formulaValue.coerceToBoolean();
                break;
            }
            case 9: {
                formulaValue = formulaValue.coerceToDate();
                break;
            }
            case 10: {
                formulaValue = formulaValue.coerceToTime();
                break;
            }
            case 15: {
                formulaValue = formulaValue.coerceToDateTime();
                break;
            }
            case 11: {
                formulaValue = formulaValue.coerceToString();
                break;
            }
            default: {
                CrystalAssert.ASSERT(false);
                return null;
            }
        }
        if (formulaValue == null) {
            return null;
        }
        if (formulaValueType.isRange() && (formulaValue = formulaValue.coerceToRange()) == null) {
            return null;
        }
        if (formulaValueType.isArray() && (formulaValue = formulaValue.coerceToArray()) == null) {
            return null;
        }
        if (formulaValue.getFormulaValueType() == formulaValueType) {
            return formulaValue;
        }
        return null;
    }

    public static FormulaValue makeZeroValue(FormulaValueType formulaValueType) {
        FormulaValue formulaValue;
        if (goto.containsKey(formulaValueType)) {
            CrystalValue crystalValue = goto.get(formulaValueType);
            return crystalValue == SpecialCrystalValue.NULL ? null : (FormulaValue)crystalValue;
        }
        if (formulaValueType.isArray()) {
            formulaValue = ArrayValue.fromArray(else, formulaValueType.getNonArrayFormulaValueType());
        } else {
            switch (formulaValueType.getBaseFormulaValueType().value()) {
                case 6: {
                    formulaValue = NumberValue.zero;
                    break;
                }
                case 7: {
                    formulaValue = CurrencyValue.zero;
                    break;
                }
                case 8: {
                    formulaValue = BooleanValue.FALSE;
                    break;
                }
                case 9: 
                case 10: 
                case 15: {
                    formulaValue = null;
                    break;
                }
                case 11: {
                    formulaValue = StringValue.empty;
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException();
                }
            }
            if (formulaValueType.isRange()) {
                formulaValue = FormulaValue.coerceToRange(formulaValue);
            }
        }
        goto.put(formulaValueType, formulaValue == null ? SpecialCrystalValue.NULL : formulaValue);
        return formulaValue;
    }
}

