/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.locale;

import com.crystaldecisions.reports.common.engine.ConfigurationManager;
import com.crystaldecisions.reports.common.engine.Engine;
import com.crystaldecisions.reports.common.locale.DefaultCrystalLocale;
import com.crystaldecisions.reports.common.locale.ICrystalLocale;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FormatterCache {
    private static final ThreadLocal<Map<Locale, DecimalFormat>> new = new ThreadLocal<Map<Locale, DecimalFormat>>(){

        @Override
        protected Map<Locale, DecimalFormat> initialValue() {
            return new HashMap<Locale, DecimalFormat>();
        }
    };
    private static final ThreadLocal<Map<Locale, DecimalFormat>> int = new ThreadLocal<Map<Locale, DecimalFormat>>(){

        @Override
        protected Map<Locale, DecimalFormat> initialValue() {
            return new HashMap<Locale, DecimalFormat>();
        }
    };
    private static final ThreadLocal<Map<Calendar, Map<Locale, DateFormat>>> do = new ThreadLocal<Map<Calendar, Map<Locale, DateFormat>>>(){

        @Override
        protected Map<Calendar, Map<Locale, DateFormat>> initialValue() {
            return new HashMap<Calendar, Map<Locale, DateFormat>>();
        }
    };
    private static final ThreadLocal<Map<Calendar, Map<Locale, DateFormat>>> for = new ThreadLocal<Map<Calendar, Map<Locale, DateFormat>>>(){

        @Override
        protected Map<Calendar, Map<Locale, DateFormat>> initialValue() {
            return new HashMap<Calendar, Map<Locale, DateFormat>>();
        }
    };
    private static final ThreadLocal<Map<Calendar, Map<Locale, DateFormat>>> a = new ThreadLocal<Map<Calendar, Map<Locale, DateFormat>>>(){

        @Override
        protected Map<Calendar, Map<Locale, DateFormat>> initialValue() {
            return new HashMap<Calendar, Map<Locale, DateFormat>>();
        }
    };
    private static final ThreadLocal<Map<Calendar, Map<Locale, DateFormat>>> if = new ThreadLocal<Map<Calendar, Map<Locale, DateFormat>>>(){

        @Override
        protected Map<Calendar, Map<Locale, DateFormat>> initialValue() {
            return new HashMap<Calendar, Map<Locale, DateFormat>>();
        }
    };

    private FormatterCache() {
    }

    private static ICrystalLocale a() {
        ConfigurationManager configurationManager = Engine.getDefault().getConfigurationManager();
        ICrystalLocale iCrystalLocale = (ICrystalLocale)configurationManager.getProperty("Locale");
        if (iCrystalLocale == null) {
            iCrystalLocale = new DefaultCrystalLocale();
        }
        return iCrystalLocale;
    }

    public static synchronized DecimalFormat GetDecimalFormatter(Locale locale) {
        Map<Locale, DecimalFormat> map = new.get();
        DecimalFormat decimalFormat = map.get(locale);
        if (decimalFormat == null) {
            ICrystalLocale iCrystalLocale = FormatterCache.a();
            String string = iCrystalLocale.getNumberPattern(locale);
            DecimalFormatSymbols decimalFormatSymbols = iCrystalLocale.getDecimalFormatSymbols(locale).getNumberDecimalFormatSymbols(locale);
            decimalFormat = new DecimalFormat(string, decimalFormatSymbols);
            assert (decimalFormat != null);
            map.put(locale, decimalFormat);
        }
        return (DecimalFormat)decimalFormat.clone();
    }

    public static synchronized DecimalFormat GetDecimalCurrencyFormatter(Locale locale) {
        Map<Locale, DecimalFormat> map = int.get();
        DecimalFormat decimalFormat = map.get(locale);
        if (decimalFormat == null) {
            ICrystalLocale iCrystalLocale = FormatterCache.a();
            String string = iCrystalLocale.getCurrencyPattern(locale);
            DecimalFormatSymbols decimalFormatSymbols = iCrystalLocale.getDecimalFormatSymbols(locale).getCurrencyDecimalFormatSymbols(locale);
            decimalFormat = new DecimalFormat(string, decimalFormatSymbols);
            assert (decimalFormat != null);
            map.put(locale, decimalFormat);
        }
        return (DecimalFormat)decimalFormat.clone();
    }

    public static synchronized DateFormat GetShortDateFormatter(Calendar calendar, Locale locale) {
        DateFormat dateFormat;
        Map<Calendar, Map<Locale, DateFormat>> map = do.get();
        Map<Locale, DateFormat> map2 = map.get(calendar);
        if (map2 == null) {
            map2 = new HashMap<Locale, DateFormat>();
            map.put(calendar, map2);
        }
        if ((dateFormat = map2.get(locale)) == null) {
            ICrystalLocale iCrystalLocale = FormatterCache.a();
            String string = iCrystalLocale.getShortDatePattern(locale);
            DateFormatSymbols dateFormatSymbols = iCrystalLocale.getDateFormatSymbols(locale).getDateFormatSymbols(calendar, 3, 2, locale);
            dateFormat = new SimpleDateFormat(string, dateFormatSymbols);
            assert (dateFormat != null);
            map2.put(locale, dateFormat);
        }
        return (DateFormat)dateFormat.clone();
    }

    public static synchronized DateFormat GetLongDateFormatter(Calendar calendar, Locale locale) {
        DateFormat dateFormat;
        Map<Calendar, Map<Locale, DateFormat>> map = for.get();
        Map<Locale, DateFormat> map2 = map.get(calendar);
        if (map2 == null) {
            map2 = new HashMap<Locale, DateFormat>();
            map.put(calendar, map2);
        }
        if ((dateFormat = map2.get(locale)) == null) {
            ICrystalLocale iCrystalLocale = FormatterCache.a();
            String string = iCrystalLocale.getLongDatePattern(locale);
            DateFormatSymbols dateFormatSymbols = iCrystalLocale.getDateFormatSymbols(locale).getDateFormatSymbols(calendar, 1, 2, locale);
            dateFormat = new SimpleDateFormat(string, dateFormatSymbols);
            assert (dateFormat != null);
            map2.put(locale, dateFormat);
        }
        return (DateFormat)dateFormat.clone();
    }

    public static synchronized DateFormat GetTimeFormatter(Calendar calendar, Locale locale) {
        DateFormat dateFormat;
        Map<Calendar, Map<Locale, DateFormat>> map = a.get();
        Map<Locale, DateFormat> map2 = map.get(calendar);
        if (map2 == null) {
            map2 = new HashMap<Locale, DateFormat>();
            map.put(calendar, map2);
        }
        if ((dateFormat = map2.get(locale)) == null) {
            ICrystalLocale iCrystalLocale = FormatterCache.a();
            String string = iCrystalLocale.getTimePattern(locale);
            DateFormatSymbols dateFormatSymbols = iCrystalLocale.getDateFormatSymbols(locale).getDateFormatSymbols(calendar, 2, 2, locale);
            dateFormat = new SimpleDateFormat(string, dateFormatSymbols);
            assert (dateFormat != null);
            map2.put(locale, dateFormat);
        }
        return (DateFormat)dateFormat.clone();
    }

    public static synchronized DateFormat GetShortDateTimeFormatter(Calendar calendar, Locale locale) {
        DateFormat dateFormat;
        Map<Calendar, Map<Locale, DateFormat>> map = if.get();
        Map<Locale, DateFormat> map2 = map.get(calendar);
        if (map2 == null) {
            map2 = new HashMap<Locale, DateFormat>();
            map.put(calendar, map2);
        }
        if ((dateFormat = map2.get(locale)) == null) {
            ICrystalLocale iCrystalLocale = FormatterCache.a();
            String string = iCrystalLocale.getShortDatePattern(locale) + " " + iCrystalLocale.getTimePattern(locale);
            DateFormatSymbols dateFormatSymbols = iCrystalLocale.getDateFormatSymbols(locale).getDateFormatSymbols(calendar, 3, 2, locale);
            dateFormat = new SimpleDateFormat(string, dateFormatSymbols);
            assert (dateFormat != null);
            map2.put(locale, dateFormat);
        }
        return (DateFormat)dateFormat.clone();
    }
}

