/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.filemanagement;

import com.crystaldecisions.reports.common.asserts.CrystalAssert;
import java.io.OutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FixedByteArrayOutputStream
extends OutputStream {
    private final byte[] a;
    private int if;

    public FixedByteArrayOutputStream(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Fixed byte array output stream must be of size >= 0");
        }
        this.a = new byte[n];
    }

    public synchronized void write(int n) {
        if (this.if + 1 > this.a.length) {
            throw new IndexOutOfBoundsException("Attempt to write past the end of the fixed size byte array");
        }
        this.a[this.if] = (byte)n;
        ++this.if;
    }

    public synchronized void write(byte[] byArray, int n, int n2) {
        if (this.if + n2 > this.a.length) {
            throw new IndexOutOfBoundsException("Attempt to write past the end of the fixed size byte array");
        }
        System.arraycopy(byArray, n, this.a, this.if, n2);
        this.if += n2;
    }

    public byte[] toByteArray() {
        CrystalAssert.ASSERT(this.if == this.a.length, "The fixed size buffer is incomplete!");
        return this.a;
    }
}

