/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common;

public final class Twip {
    public static final int InvalidTwip = Integer.MIN_VALUE;
    public static final int MaxTwip = Integer.MAX_VALUE;
    public static final int TwipsPerPoint = 20;
    public static final int TwipsPerInch = 1440;
    public static final int TwipsPerCm = 567;
    public static final int EMUsPerTwip = 635;

    private Twip() {
    }

    public static int TwipsToPointsInt(int n) {
        return (int)((double)(n + 10) / 20.0);
    }

    public static double TwipsToPoints(int n) {
        return (double)n / 20.0;
    }

    public static int PointsToTwips(double d) {
        return (int)(d >= 0.0 ? d * 20.0 + 0.5 : d * 20.0 - 0.5);
    }

    public static int TwipsToEMUs(int n) {
        return n * 635;
    }

    public static long TwipsToEMUsLong(int n) {
        return (long)n * 635L;
    }

    public static double TwipsToInches(long l) {
        return (double)l / 1440.0;
    }

    public static int TwipsToInchesInt(long l) {
        return (int)(l / 1440L);
    }

    public static long InchesToTwipsLong(double d) {
        return (long)(d * 1440.0);
    }

    public static int InchesToTwipsInt(double d) {
        return (int)(d * 1440.0);
    }
}

