/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.foundation.logging.spi;

public class BootstrapLogger {
    public static final String ENABLE_KEY = "bobj.logging.debug";
    private static final String CLASS_NAME = "com.businessobjects.foundation.logging.spi.BootstrapLogger";
    private static final String ERROR_PREFIX = "com.businessobjects.foundation.logging.spi.BootstrapLogger:ERROR ";
    private static final String WARN_PREFIX = "com.businessobjects.foundation.logging.spi.BootstrapLogger:WARN ";
    private static final String DEBUG_PREFIX = "com.businessobjects.foundation.logging.spi.BootstrapLogger:DEBUG ";
    private static boolean s_silenced = !Boolean.getBoolean("bobj.logging.debug");

    public static void setQuietMode(boolean enable) {
        s_silenced = enable;
    }

    public static void debug(String msg) {
        if (!s_silenced) {
            System.out.println(DEBUG_PREFIX + msg);
        }
    }

    public static void debug(String msg, Throwable t) {
        if (!s_silenced) {
            System.out.println(DEBUG_PREFIX + msg);
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }
    }

    public static void warn(String msg) {
        if (!s_silenced) {
            System.err.println(WARN_PREFIX + msg);
        }
    }

    public static void warn(String msg, Throwable t) {
        if (!s_silenced) {
            System.err.println(WARN_PREFIX + msg);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
    }

    public static void error(String msg) {
        if (!s_silenced) {
            System.err.println(ERROR_PREFIX + msg);
        }
    }

    public static void error(String msg, Throwable t) {
        if (!s_silenced) {
            System.err.println(ERROR_PREFIX + msg);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
    }
}

