/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.util.xml;

import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.util.xml.IXmlWriteable;
import com.businessobjects.visualization.util.xml.XmlException;
import com.businessobjects.visualization.util.xml.XmlReader;
import com.businessobjects.visualization.util.xml.XmlValidationException;
import com.businessobjects.visualization.util.xml.XmlWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;

public final class XmlUtilities {
    private XmlUtilities() {
    }

    public static String toString(IXmlWriteable writeable) {
        StringWriter writer = new StringWriter();
        try {
            writeable.writeXml(new XmlWriter(writer, Charset.forName("UTF-16")));
        }
        catch (XmlException e) {
            throw new VisualizationInternalException(e);
        }
        return writer.toString();
    }

    public static String getRequiredAttribute(XmlReader reader, String namespace, String localName) throws XmlValidationException {
        String value = reader.getAttributeValue(namespace, localName);
        if (value == null) {
            throw new XmlValidationException("Missing required attribute \"" + localName + "\" in " + reader.getName(), reader, null);
        }
        return value;
    }
}

